
do	
	TRAININGGROUNDS_PersonalDanceModule={}
	TRAININGGROUNDS_PersonalDanceModule.__index = TRAININGGROUNDS_PersonalDanceModule
	local class=TRAININGGROUNDS_PersonalDanceModule

	function class.new()
		local self=setmetatable({}, class)	
		return self
	end

	function class:Setup(mobile)
		self.mobile=mobile		
		self.danceauras={}
		self.newdanceauras={}
		self.expiringdanceauras={}
	end
	
	function class:SetCustomInfo()
		--override
		self.basereactiontime=0
		self.extrareactiontime=1.000
	end
	
	function class:ApplyDanceAura(danceaura)
		tinsert(self.newdanceauras,danceaura)
	end
	
	function class:RunAllDanceAuras(elapsed)
		local localtime=self.mobile.environment.localtime
	
		for i=1,#self.danceauras do
			self.danceauras[i]:RunAura(self)
		end
		
		local auralistchanged=false
		
		for i=#self.danceauras,1,-1 do
			local danceaura=self.danceauras[i]
			if(danceaura.reaction_expirytime and (localtime>=danceaura.reaction_expirytime))then
				tremove(self.danceauras,i)
				auralistchanged=true
			end
		end
		
		for i=#self.newdanceauras,1,-1 do
			local newdanceaura=self.newdanceauras[i]
			if((not newdanceaura.reaction_activatetime) or (localtime>=newdanceaura.reaction_activatetime))then
				tremove(self.newdanceauras,i)
				auralistchanged=true
			end
		end
		
		if(auralistchanged)then
			table.sort(self.danceauras,function(a,b)return a.priority>b.priority end)
		end
	end
end