--TODO: maybe move to Drawables folder?



-----------------------------------------------------
-----------------------------------------------------
-----------------------------------------------------
-----------------------------------------------------
-----------------------------------------------------



-- Not to be confused with AnimationSystem
TRAININGGROUNDS_AnimationSequence={}
TRAININGGROUNDS_AnimationSequence.__index = TRAININGGROUNDS_AnimationSequence

function TRAININGGROUNDS_AnimationSequence.new()
	local self=setmetatable({}, TRAININGGROUNDS_AnimationSequence)	
	return self
end

function TRAININGGROUNDS_AnimationSequence:Setup(index,subindex,priority,duration,starttime,timescale,nextsequence)
	self.index=index
	self.subindex=subindex
	self.priority=priority
	self.duration=duration
	self.starttime=starttime
	self.timescale=timescale
	self.nextsequence=nextsequence

end

function TRAININGGROUNDS_AnimationSequence_QuickSetup(animationlist,name,index,subindex,priority,duration,starttime,timescale,nextsequence)
	local sequence=TRAININGGROUNDS_AnimationSequence.new()
	sequence:Setup(index,subindex,priority,duration,starttime,timescale,nextsequence)
	animationlist[name]=sequence
end

-----------------------------------------------------
-----------------------------------------------------
-----------------------------------------------------
-----------------------------------------------------
-----------------------------------------------------

-- Not to be confused with AnimationSequence

TRAININGGROUNDS_AnimationSystem={}
TRAININGGROUNDS_AnimationSystem.__index = TRAININGGROUNDS_AnimationSystem

function TRAININGGROUNDS_AnimationSystem.new()
	local self=setmetatable({}, TRAININGGROUNDS_AnimationSystem)	
	return self
end

function TRAININGGROUNDS_AnimationSystem:Setup(drawable)
	--TODO: rename self.drawable to self.owner? (or self.owner_drawable)
	self.drawable=drawable
	self.currentanimation=nil
	self:SetCustomInfo()
	self.animations_by_priority={}
	self.animation_endtimes_by_priority={}
end

function TRAININGGROUNDS_AnimationSystem:SetCustomInfo()
	
end


	-- --TODO: some things should go in TRAININGGROUNDS_AnimationSystem_RaceInfo or similar
	-- --TODO: naming discrepancy between "_END" and "CompleteCasting"

local MAX_PRIORITY=255
local MIN_PRIORITY -- is set later

do
	local i=MAX_PRIORITY+1
	TRAININGGROUNDS_ANIMATION_PRIORITY={}	
	i=i-1;TRAININGGROUNDS_ANIMATION_PRIORITY.DEATH_ACTIVE=i
	i=i-1;TRAININGGROUNDS_ANIMATION_PRIORITY.DEATH_PASSIVE=i
	i=i-1;TRAININGGROUNDS_ANIMATION_PRIORITY.TELEGRAPH=i
	i=i-1;TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST=i
	i=i-1;TRAININGGROUNDS_ANIMATION_PRIORITY.SPECIAL_MOVEMENT=i		
	i=i-1;TRAININGGROUNDS_ANIMATION_PRIORITY.MOVEMENT=i
	i=i-1;TRAININGGROUNDS_ANIMATION_PRIORITY.SPELLCASTING=i
	i=i-1;TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST_STANCE=i
	i=i-1;TRAININGGROUNDS_ANIMATION_PRIORITY.STAND=i
	i=i-1;TRAININGGROUNDS_ANIMATION_PRIORITY.NULL=i
	MIN_PRIORITY=i
end

function TRAININGGROUNDS_AnimationSystem:ClearAnimationByCategory(priority)
	self.animations_by_priority[priority]=nil
	self.animation_endtimes_by_priority[priority]=nil
end

function TRAININGGROUNDS_AnimationSystem:PreDraw(elapsed)
	--local DEBUG=nil
	--if(self.drawable.owner:Class()==TRAININGGROUNDS_VARIMATHRAS_Mobile_ShadowOfVarimathras)then DEBUG=1 end
	--if(DEBUG)then print("-----") end
	
	for i=MAX_PRIORITY,MIN_PRIORITY,-1 do
		if(self.animations_by_priority[i])then
			--if(DEBUG)then print("Priority exists at",i) end
			if(self.animation_endtimes_by_priority[i])then
				if(self.drawable.owner:GetLocalTime()<=self.animation_endtimes_by_priority[i])then		
					--if(DEBUG)then print("-choose",self.animations_by_priority[i]) end
				
					self:ChooseCurrentAnimation(self.animations_by_priority[i])
					--print("Priority (expires):",i)
					break
				else					
					--TODO: may need to rename "animation(s)_endtimes", we keep spelling it wrong
					local nextsequence=nil
					if(self.animations_by_priority[i].nextsequence)then					
						nextsequence=self.animations_by_priority[i].nextsequence
					end
					self.animations_by_priority[i]=nil
					self.animation_endtimes_by_priority[i]=nil
					--and pass through to next case
					if(nextsequence)then
						--if(DEBUG)then print("=choose",nextsequence) end
						self:SetAnimation(nextsequence)
					end
						
					
				end
			else
				--if(DEBUG)then print("::choose",self.animations_by_priority[i]) end
				self:ChooseCurrentAnimation(self.animations_by_priority[i])
				--print("Priority (does not expire):",i)
				break
			end
		end
	end
	

	
	-- if(self.activeanimationendtime and self.activeanimation)then
		-- local localtime=self.drawable.owner:GetLocalTime()
		-- if(localtime>=self.activeanimationendtime)then
			-- if(self.activeanimation~=self.passiveanimation)then
				-- if(self.passiveanimation)then
					
					-- --TODO: we're calling drawable:SetRawAnimation at least three times here
					-- --   and we're not 100% sure we want to use that function
						-- -- call a single AnimationSystem function that does it for us
					-- self.drawable:SetRawAnimation(self.passiveanimation[1])
				-- end
			-- end
			-- self.activeanimation=nil			
		-- end
	-- end
end

function TRAININGGROUNDS_AnimationSystem:ChooseCurrentAnimation(sequence)
	--local DEBUG=nil
	--if(self.drawable.owner:Class()==TRAININGGROUNDS_VARIMATHRAS_Mobile_ShadowOfVarimathras)then DEBUG=1 end
	
	if(self.currentanimation~=sequence)then
		--print("Changing animation to",sequence.index)
		self.currentanimation=sequence
		
		--if(DEBUG)then print("SetRaw",sequence.index) end
		
		--if(sequence.starttime)then print("choose animation:",sequence.index,sequence.subindex,sequence.starttime) end
		--print("choose animation:",sequence.index,sequence.subindex,sequence.starttime)
		self.drawable:SetRawAnimation(sequence.index,sequence.subindex,sequence.starttime,sequence.timescale)
	else
		--if(DEBUG)then print("No change, already",self.currentanimation.index) end
	end
end

--TODO: rename active/passiveanimation to active/passivesequence?
function TRAININGGROUNDS_AnimationSystem:SetAnimation(sequence)
	self.animations_by_priority[self:GetSequencePriority(sequence)]=sequence
	local duration=self:GetSequenceDuration(sequence)
	if(duration)then
		self.animation_endtimes_by_priority[self:GetSequencePriority(sequence)]=self.drawable.owner:GetLocalTime()+duration
	else
		self.animation_endtimes_by_priority[self:GetSequencePriority(sequence)]=nil
	end
end
function TRAININGGROUNDS_AnimationSystem:SetAnimationAndRestart(sequence)
	self:SetAnimation(sequence)
	if(self.currentanimation==sequence)then
		--TODO: somehow merge this line with ChooseCurrentAnimation function above
		self.drawable:SetRawAnimation(sequence.index,sequence.subindex,sequence.starttime,sequence.timescale)
	end
end


function TRAININGGROUNDS_AnimationSystem:GetSequencePriority(sequence)
	--TODO: move function to sequence
	return sequence.priority
	-- if(self.priorities[sequence])then
		-- return self.priorities[sequence]
	-- else
		-- --TODO: throw exception
		-- return TRAININGGROUNDS_ANIMATION_PRIORITY.SPELLCASTING
	-- end
end

function TRAININGGROUNDS_AnimationSystem:GetSequenceDuration(sequence)
	return sequence.duration
	-- --TODO:
	-- if(self.durations[sequence])then 
		-- return self.durations[sequence]
	-- else
		-- --TODO: ideally we throw an exception if sequence duration hasn't been set.
		-- --however, nil is a valid sequence duration, which means infinite duration.
			-- -- zero is ALSO a valid sequence duration which means quite the opposite.
		-- return nil
	-- end
end

function TRAININGGROUNDS_AnimationSystem:DoesNewSequenceHaveHigherPassivePriority(sequence)
	--TODO: if we aren't sure if we need this, leave a comment that we're not sure if we need this
	--TODO: priority system
	return self:DoesNewSequenceHaveHigherActivePriority(sequence)	
end
function TRAININGGROUNDS_AnimationSystem:DoesNewSequenceHaveHigherActivePriority(sequence)
	--TODO: priority system
	if(not self.activeanimation)then return true end	
	
	return true
end

--TODO: some shadows appear to be misaligned (e.g pandaren F performing 2H attack) -- is this even fixable?


-------------------------------------------------------
-------------------------------------------------------
-------------------------------------------------------
-------------------------------------------------------
-------------------------------------------------------

--TODO: move to separate file, maybe

--TODO: use wowhead names (some do already, but not all of them)
--TODO: wowhead has different names for SOME animation+variations
-- (but not all; e.g. Attack2H combines both variations into a single name.
--	although wowhead plays these variants in order, WoW plays them randomly, so we don't need to keep track)

TRAININGGROUNDS_ANIMATION_LIST={}
--TRAININGGROUNDS_AnimationSequence_QuickSetup(animationlist,name,index,subindex,priority,duration,starttime,timescale,nextsequence

TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"Stand",0,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.STAND,nil)
--TRAININGGROUNDS_ANIMATION_LIST.Stand={0}
TRAININGGROUNDS_ANIMATION_LIST.Death={1}
TRAININGGROUNDS_ANIMATION_LIST.Walk={4}
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"Run",5,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.MOVEMENT,0)
--TODO: better name than Run_FollowThrough
-- This version of Run persists for a couple frames, 
	--allowing fast-moving characters to follow slow-moving characters without stutter-step animation.
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"Run_FollowThrough",5,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.MOVEMENT,0.100)
TRAININGGROUNDS_ANIMATION_LIST.DEATH_LOOP={6}
TRAININGGROUNDS_ANIMATION_LIST.FLINCH={8}
TRAININGGROUNDS_ANIMATION_LIST.FLINCH_BIG={9}
--TODO: compare with wowhead
TRAININGGROUNDS_ANIMATION_LIST.TURN_LEFT_MAYBE={11}
TRAININGGROUNDS_ANIMATION_LIST.TURN_RIGHT_MAYBE={12}
TRAININGGROUNDS_ANIMATION_LIST.Walkbackwards={13}
TRAININGGROUNDS_ANIMATION_LIST.Stun={14}
TRAININGGROUNDS_ANIMATION_LIST.HandsClosed={15}	-- T-pose
--TRAININGGROUNDS_ANIMATION_LIST.ATTACK_UNARMED={16}
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"AttackUnarmed",16,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST,1.500)
TRAININGGROUNDS_ANIMATION_LIST.ATTACK_1H_STAB={17}
-- Attack2H: 2 variations
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"Attack2H",18,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST,1.500)
--TRAININGGROUNDS_ANIMATION_LIST.Attack2HL={19}		-- 3 variations
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"Attack2HL",19,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST,1.500)
TRAININGGROUNDS_ANIMATION_LIST.JUMP={37}
TRAININGGROUNDS_ANIMATION_LIST.MIDAIR={38}
TRAININGGROUNDS_ANIMATION_LIST.LAND_ON_GROUND={39}
TRAININGGROUNDS_ANIMATION_LIST.SWIM_IDLE={41}
TRAININGGROUNDS_ANIMATION_LIST.SWIM_FORWARD={42}
TRAININGGROUNDS_ANIMATION_LIST.SWIM_LEFT={43}
TRAININGGROUNDS_ANIMATION_LIST.SWIM_RIGHT={44}
TRAININGGROUNDS_ANIMATION_LIST.SWIM_BACKWARD={44}


--TODO: we just changed spellcasting duration from 0 to nil.
	-- this will break things later once we introduce cast-while-moving etc.
	-- ideally we change "StartCastingAnimationFunction" to "WhileCastingAnimationFunction"
	-- and reassign cast animation every frame	
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"SPELLCAST_DIRECTED",51,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.SPELLCASTING,nil)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"SPELLCAST_NONDIRECTED",52,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.SPELLCASTING,nil)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"SPELLCAST_DIRECTED_FINISH",53,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST,1.000)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"SPELLCAST_NONDIRECTED_FINISH",54,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST,1.000)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"TAUNT",55,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST,1.000)


TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"SPRINT",143,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.MOVEMENT,0)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"SPRINT_FollowThrough",143,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.MOVEMENT,0.100)



---- it would appear that 664 has been changed since we last used it
---- -- there's a very long delay now.  skip directly to roll loop
--TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"ROLL_BEGIN_LOOP",664,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.SPECIAL_MOVEMENT,0.500,
																							  --666,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.SPECIAL_MOVEMENT,nil)
--TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"ROLL_BEGIN_LOOP",666,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST,1.500,0.0,1.0)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"ROLL_LOOP",666,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.SPECIAL_MOVEMENT,0)
--TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"ROLL_BEGIN_LOOP",664,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST,0.250,0.2,1.5,TRAININGGROUNDS_ANIMATION_LIST.ROLL_LOOP)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"ROLL_BEGIN_LOOP",664,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST,0.250,0.2,1.5)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"ROLL_END",668,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST,.300,0,1)
--TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"ROLL_END",668,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST_STANCE,1.000,nil,nil,TRAININGGROUNDS_ANIMATION_LIST.ROLL_END_STANCE)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ANIMATION_LIST,"ROLL_END_STANCE",668,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST_STANCE,nil)


---------------------------------------------------------
---------------------------------------------------------
---------------------------------------------------------
---------------------------------------------------------
---------------------------------------------------------

--TODO: move to content/argus
TRAININGGROUNDS_ARGUS_ANIMATION_LIST={}
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ARGUS_ANIMATION_LIST,"CONEOFDEATH_BEGIN",219,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.SPELLCASTING,2.500)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_ARGUS_ANIMATION_LIST,"CONEOFDEATH_END",220,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.ENDCAST,1.000)


---------------------------------------------------------
---------------------------------------------------------
---------------------------------------------------------
---------------------------------------------------------
---------------------------------------------------------

--TODO: move to content/aggramar
TRAININGGROUNDS_AGGRAMAR_ANIMATION_LIST={}
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_AGGRAMAR_ANIMATION_LIST,"KneelLoop",115,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.TELEGRAPH,nil)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_AGGRAMAR_ANIMATION_LIST,"KneelEnd",116,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.TELEGRAPH,2.000)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_AGGRAMAR_ANIMATION_LIST,"FoeBreaker",57,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.TELEGRAPH,4.000)
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_AGGRAMAR_ANIMATION_LIST,"FlameRend",58,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.TELEGRAPH,4.000)
--TODO: double-check that 814 really is the very first appearance of the Searing Tempest animation
--TODO: 814 doesn't transition back into 0; use a "combat stance" idle animation instead?
TRAININGGROUNDS_AnimationSequence_QuickSetup(TRAININGGROUNDS_AGGRAMAR_ANIMATION_LIST,"SearingTempest",814,nil,TRAININGGROUNDS_ANIMATION_PRIORITY.TELEGRAPH,1.250)
