 do
		
	-- Note that ThreatTable is stored within Mobiles' AI,
	-- threat itself is generated by (and credited to) Mobiles,
	-- but the functions responsible for adding threat are often called from CombatModule.
	
	-- We assume (and are responsible for ensuring) the table is resorted every time someone's threat changes.
	
	--TODO: ThreatTable has not been unit tested
	--TODO: "pull aggro" system (110% melee, 130% ranged)
	--TODO: apparently healing is 0.5x threat, not 2.0x threat as we previously thought

	TRAININGGROUNDS_ThreatTable = {}
	local class=TRAININGGROUNDS_ThreatTable
	class.__index = class	
	
	function class.new()
		local self=setmetatable({}, class)
		return self
	end
	
	function class:Setup(ownerai)
		self.ownerai=ownerai
		-- The contents table is sorted with the highest threat first.
		self.contents={}
		-- The "contents_by_casterid" table is used to quickly find a particular casterid without having to dig through the sorted table.
		self.contents_by_casterid={}
		
	end
	
	function class:GetThreatTableEntryByCaster(castermobile)
		local threattableentry=nil
		if(not self.contents_by_casterid[castermobile.id])then
			threattableentry=TRAININGGROUNDS_ThreatTableEntry.new(castermobile.id,self.ownerai.owner.id,castermobile,self.ownerai.owner)
			tinsert(self.contents,threattableentry)
			self.contents_by_casterid[castermobile.id]=threattableentry
			--TODO: if threat is ever non-zero, table will need to be resorted here
		else
			threattableentry=self.contents_by_casterid[castermobile.id]
		end
		return threattableentry
	end
	
	function class:GetHighestThreatTableEntry()
		return self.contents[1]
	end
	
	function class:SortByHighestThreat()
		table.sort(self.contents, function(a,b) return a.threat>b.threat end)
	end
	
	--TODO: some of this needs to go in Taunt spell
	function class:TauntedBy(castercombat)
		--gathering evidence that object references need work
		local targetcombat=self.ownerai.owner.combat
		
		--TODO: check for threattable owner's diminishing returns aura first
		
		local threattableentry=self:GetThreatTableEntryByCaster(castercombat.owner)
		
		local highestthreattableentry=self:GetHighestThreatTableEntry()
		
		--TODO: move to SetThreat function which autosorts
		threattableentry.threat=highestthreattableentry.threat*1.00
		self:SortByHighestThreat()
		
		--TODO: apply aura: fixate (distinct from forced target change)
		--TODO: apply aura: taunt diminishing returns		
		
		--print(self.ownerai.owner:GetName(),"taunted by",castercombat.owner:GetName())
		self.ownerai:ForcedTargetChange(castercombat)
		
		
		
		
		--TODO: apply aura: increase threat from taunter and force target to attack taunter
			--(do this per individual spell, not in ThreatTable)
			
		--TODO: apparently taunt threat multiplier is multiplicative with tank threat multiplier?
			-- (so 2.0x taunt * 7.0x tank = 14.0x taunt tank threat, not +1.0x+6.0x = +7.0x)
			
			
		--TODO: aura definitely goes in Taunt spell, not in TauntedBy effect
		local aura=targetcombat:ApplyAuraByClass(TRAININGGROUNDS_Aura_Facing, castercombat)
		aura.targetmobile=castercombat.owner
			
		return threattableentry
	end
	
	
end
