do
	--TODO: AI assumes owner is Mobile.  will this be a problem?
	--TODO: should this go in Mobile folder?

	TRAININGGROUNDS_AI = {}
	TRAININGGROUNDS_AI.__index = TRAININGGROUNDS_AI
	function TRAININGGROUNDS_AI.new()
		local self=setmetatable({}, TRAININGGROUNDS_AI)
		return self
	end

	function TRAININGGROUNDS_AI:Setup(owner,environment)
		self.owner=owner
		self.environment=environment
		--TODO: spellqueue here is completely different from combat's queuedspell.  rename one or the other
		self.spellqueue=List.new()
		
		self:SetCustomInfo()
		
		self.moveinputvector={}
		self.moveinputvector.x=0
		self.moveinputvector.y=0	
		
		--X/Y coordinate pair
		self.targetlocation=nil
		
		
		self:CreateThreatTable()
	end

	function TRAININGGROUNDS_AI:SetCustomInfo()
		-- populate spellqueue here
		--TODO: maybe populate spellqueue in PopulateSpellqueue function
		
		--TODO: bosses should be able to specify whether to cast spells in order or randomly (if they even use a queue at all)
			-- the spellqueue is intended for abilities like taesh tech, or for adds that cast a few times then disappear
	end
	
	function TRAININGGROUNDS_AI:CreateThreatTable()
		-- we don't expect we'll ever need to override this, but just in case...
		self.threattable=TRAININGGROUNDS_ThreatTable.new()
		self.threattable:Setup(self)
	end

	--TODO: split attack and targetlocation into different functions
		-- (but targetlocation may depend on attack range)
		
	function TRAININGGROUNDS_AI:Step(elapsed)

		local obj=self.owner
		
		--if(List.size(self.spellqueue)>0)then print("Size>0")end
		if(obj.combat:IsIdle())then				
			if(List.size(self.spellqueue)==0)then
				if(obj.combat.targetcombat)then	
					if(obj.combat.autospell)then
						--TODO: automatically move into range of target regardless of autoattack
						--local targetlocation=self:GetTargetLocationForMeleeAttack(obj.combat.targetcombat.owner,obj.combat.autospell)
						local targetlocation=self:GetTargetLocationForPursuit(obj.combat.targetcombat.owner)
						if(targetlocation)then
							--TODO: this is disabled for aggramar dance
							--!!!
							--self:SetTargetLocationAndPrecision(	targetlocation, 0 )	
						end						
					end
					
						-- store max range in AI:custominfo,
						-- maybe derive it automatically from combat if possible
				
					-- local errorcode=obj.combat:TryAuto()					
					-- --TODO: machine-readable errorcode comparison
					-- --TODO: if player-controlled, first check if automove is turned on
					-- if(errorcode=="Out of range.")then
						-- local targetmobile=obj.combat.targetcombat.owner
						-- --TODO: only walk to the edge of melee range (function to determine where that is)
						-- --TODO LATER: WoW enemy swarms somehow know to spread out around the player
						-- --self:SetTargetLocationAndPrecision({x=targetmobile.x,y=targetmobile.y},0)
						-- --TODO: AI should keep some reference to autospell at all times
						-- -- (we need to reference self.combat.autospell here but shouldn't have to go through combat to get there)
						-- --TODO: not necessarily a "melee attack"
						-- self:SetTargetLocationAndPrecision(
								-- self:GetTargetLocationForMeleeAttack(targetmobile,obj.combat.autospell)
								-- ,0)
								
					-- end
				end
			else
				--print("AI: idle, spellqueue size",List.size(self.spellqueue))
				local spell=List.getleft(self.spellqueue)
				--TODO: only boss spells should call GetBossTarget!
				-- Player AI should ask BossController (or Choreography) what to aim at
					-- (we'll probably end up keeping a list of "high priority" and "can finish long spellcast" targets in player.AI to choose from)
				local multitargetcombats=spell:GetBossTarget()				
				local targetcombat=nil
				if(multitargetcombats and #multitargetcombats)then
					targetcombat=multitargetcombats[1]
				end
				--TODO: if target is nil, don't necessarily clear target (whether or not to clear target should be stored in spell info)
				
				self.targetcombat=targetcombat
				self.multitargetcombats=multitargetcombats
				local queuespellinstance=spell:NewQueue()
				--queuespellinstance.targetcombat=self.targetcombat		-- DEPRECATED, REMOVE
				--print("TryQueue a spell targeting",targetcombat)
				local errorcode=obj.combat:TryQueue(queuespellinstance)
				if(not errorcode)then
					--print("Queued up a spell from queue",self.spellqueue)
					List.popleft(self.spellqueue)
				end
				--TODO: don't popleft until the spell actually begins casting
					
				--TODO: react to errorcode (and combine with tryauto errorcode handling)
			end
		end
		
		if(obj.combat.targetcombat)then
			local targetobj=obj.combat.targetcombat.owner
			local yy=targetobj.y-obj.y
			local xx=targetobj.x-obj.x
			local angle=math.atan2(yy,xx)+math.pi/2	
			----TODO: don't hardcode 20
			---- (and don't turn here; turning should be a part of the attack process)
			--self.owner:TurnAtSpeed(angle,elapsed,20)
		end
			
		--print("targetlocation: ",self.targetlocation)
		if(self.targetlocation)then
			--print("targetlocation")
			local distx=(self.targetlocation.x-self.owner.x)
			local disty=(self.targetlocation.y-self.owner.y)
			local distsqr=distx*distx+disty*disty
			--TODO: use self:GetFinalMoveSpeed() ^ 2 instead
			local movespeed=self.owner:GetFinalMoveSpeed()
			local movespeedelapsed=movespeed*(2*elapsed)
			local dist=math.sqrt(distsqr)	
			if(distsqr>movespeedelapsed*movespeedelapsed)then
				self.moveinputvector.x=distx
				self.moveinputvector.y=disty
			else			
				--TODO: don't set targetlocation nil if forced movement occurs
				-- (not sure how to properly do this yet.  check that xspeed and yspeed are 0?)
				self.targetlocation=nil
				self.moveinputvector.x=0
				self.moveinputvector.y=0
			end
		else	-- else no targetlocation
			self.moveinputvector.x=0
			self.moveinputvector.y=0	
		end
	end

	--TODO: this is distinct from taunt fixate, which is NYI
	function TRAININGGROUNDS_AI:ForcedTargetChange(targetcombat)
		self.owner.combat.targetcombat=targetcombat
		--TODO: turn-on-autoattack should go somewhere else.
		-- (and we may need to move taunt out of AI)
		self.owner.combat:StartAttacking()
	end
	
	
	function TRAININGGROUNDS_AI:SetTargetLocationAndPrecision(targetlocation,precision)
		-- Player will end up (precision) units away from the specified location.
		local multiplier=precision*math.random()
		local angle=math.random()*math.pi*2
		self.targetlocation={x=targetlocation.x+multiplier*math.cos(angle),
							y=targetlocation.y+multiplier*math.sin(angle)}
	end
	
	function TRAININGGROUNDS_AI:GetTargetLocationForMeleeAttack(targetmobile,spell)
		local castermobile=self.owner
		local xdist=(targetmobile.x-castermobile.x)
		local ydist=(targetmobile.y-castermobile.y)
		local mobiledist=math.sqrt(xdist*xdist+ydist*ydist)
		--print("Current distance:",mobiledist)
		local dist=spell:GetFinalSpellRange(castermobile.combat)
		--print("AI: finalspellrange:",dist)
		dist=dist+targetmobile.hitboxradius-TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(1)
		
		if(mobiledist>dist)then
			--print("Maximum distance after adding hitboxradius:",dist)
			
			--TODO: caster hitbox apparently not counted as part of spell distance
			--TODO: caster hitbox has to be added to several lines both here and in Mobile:SpellDistance if we decide to use it again;
				-- add an easier way to toggle it
			
			--print("GetTargetLocation dist",dist,spell:GetFinalSpellRange(castermobile.combat),castermobile.hitboxradius,targetmobile.hitboxradius)
			--TODO: subtract a unit or two from dist
			
			-- note to self:
			-- unitvector calculation, then multiply by dist and add to targetmobile.	
			--print("Targetlocation",targetmobile.x-(xdist/mobiledist)*dist,targetmobile.y-(ydist/mobiledist)*dist)
			--print("Dist",dist)
			
			
			-- local DEBUG=0
			-- if(self.owner:Class()==TRAININGGROUNDS_VARIMATHRAS_Mobile_Varimathras)then DEBUG=1 end		
			-- if(DEBUG==1)then print("AI:",castermobile.x,castermobile.y,targetmobile.x,targetmobile.y,dist) end
			
			return {x=targetmobile.x-(xdist/mobiledist)*dist,
					y=targetmobile.y-(ydist/mobiledist)*dist}
		else
			return nil
		end
	end
	
	
	function TRAININGGROUNDS_AI:GetTargetLocationForPursuit(targetmobile)
		local castermobile=self.owner
		local xdist=(targetmobile.x-castermobile.x)
		local ydist=(targetmobile.y-castermobile.y)
		local mobiledist=math.sqrt(xdist*xdist+ydist*ydist)
		--print("Current distance:",mobiledist)
		local apathydist=self:GetPursuitApathyDistance()
		if(mobiledist>apathydist or self.targetlocation~=nil)then
			local targetdist=self:GetPursuitTargetDistance()
				
			if(mobiledist>targetdist)then					
				return {x=targetmobile.x-(xdist/mobiledist)*targetdist,
						y=targetmobile.y-(ydist/mobiledist)*targetdist}
			else
				return nil
			end
		else
			return nil
		end
	end
	
	function TRAININGGROUNDS_AI:GetPursuitTargetDistance()	
		return TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(3.5)
	end
	
	function TRAININGGROUNDS_AI:GetPursuitApathyDistance()	
		return TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(5)
	end	
		
end