 
do
	local super=TRAININGGROUNDS_Spell_SampleMeleeAttack
	TRAININGGROUNDS_VARIMATHRAS_Spell_ShadowStrike=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_VARIMATHRAS_Spell_ShadowStrike
	
	function class:SetCustomInfo()
		super.SetCustomInfo(self)
		self.basecastduration=0.0
		self.bosscastingstyle=TRAININGGROUNDS_SpellBossCastingStyle.CURRENTTARGET
		
		self.range=nil
		self.melee=false
	end
	
	function class:ExecuteSpellEffect(projectile)	
		--print("SHADOWSTRIKE")
		
		local castermobile=self.castercombat.owner
		local targetmobile=self.targetcombat.owner
		local cone=TRAININGGROUNDS_Telegraph_Cone_FlashOnce.new()
		local directionangle=math.atan2(self.targetcombat.owner.y-self.castercombat.owner.y,self.targetcombat.owner.x-self.castercombat.owner.x)
		--TODO: rename "widthangle" to "sweepangle"
		local widthangle=(math.pi/2.0)
		local radius=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(15)
		
		local x1=castermobile.x
		local y1=castermobile.y
		
		cone:Setup(castermobile.environment)
		cone:PositionCone(x1,y1,directionangle,widthangle,radius)
		cone:SetColor(0.5,0,1,1.0)
		
		local x2=x1+math.cos(directionangle-widthangle*0.5)*radius
		local y2=y1+math.sin(directionangle-widthangle*0.5)*radius
		local x3=x1+math.cos(directionangle+widthangle*0.5)*radius
		local y3=y1+math.sin(directionangle+widthangle*0.5)*radius
		
		--TODO: environment.players instead of environment.mobiles
		local players=TRAININGGROUNDS_GetAllObjectsInTriangle(
			self.castercombat.owner.environment.mobiles,
			x1,y1,x2,y2,x3,y3)
		
		for i=1,#players do			
			self.castercombat.combatlog:RecordEvent({
							action=TRAININGGROUNDS_CombatEventType.HIT_BY_ATTACK,
							subject=self:Class(),
							target=players[i].combat
							})
		end
		
		
	end
	
	
end
