
do
	local super=TRAININGGROUNDS_Aura
	TRAININGGROUNDS_VARIMATHRAS_Aura_AloneInTheDarkness=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_VARIMATHRAS_Aura_AloneInTheDarkness
	
	function class:SetCustomInfo()
		super.SetCustomInfo(self)
		self.graceperiodendtick=nil
	end
	
	function class:Step(elapsed)
		super.Step(self,elapsed)		
		
		--TODO: are we ok with referencing self.targetcombat.localtime instead of self.localtime?
		--TODO: if graceperiodendtick exists, pass it as localtime to spellcast proc function
		if(self.graceperiodendtick and self.graceperiodendtick>self.targetcombat.localtime)then 
			--print("Waiting for grace period,",self.targetcombat.localtime,"of",self.graceperiodendtick)
			return 
		end
		
		--print("Checking AITD...")
		
		local mobile=self.targetcombat.owner
		local raiders=mobile.environment.raiders
		
		--TODO: center-to-center distance function
		local ok=false
		for i=1,#raiders do
			--::continue::, if warcraft had line labels
			local raider=raiders[i]
			if(raider~=mobile)then -- then goto continue, except we can't goto in warcraft
				local xdist=raider.x-mobile.x
				local ydist=raider.y-mobile.y
				local distsqr=(xdist*xdist+ydist*ydist)
				local maxdist=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(8.0)
				local maxdistsqr=maxdist*maxdist
				if(distsqr<=maxdistsqr)then
					--print("Distsqr from",raider,"is",distsqr,"(not necessarily closest)")
					--found one
					ok=true
					break
				end
			end
		end
		if(not ok)then			
			-- uh oh!
			
			self:ProcAITD()
		end		
	end
	
	function class:ProcAITD()
		--override; specifically we want to kill the player here but not the 3rd tank
		
		local temp=self.castercombat.targetcombat
		TEMP_CastSpellOnTargetMobile(self.castercombat.owner,TRAININGGROUNDS_VARIMATHRAS_Spell_AloneInTheDarkness_Proc,self.targetcombat.owner)
		self.castercombat.targetcombat=temp		
		--print("AITD; self.castercombat.targetcombat is now",self.castercombat.targetcombat)
		--TODO: actually grace period is probably less than 4 seconds
		self.graceperiodendtick=self.targetcombat.localtime+4.0
		
	end		
end