do
	local super=TRAININGGROUNDS_VoidZone
	TRAININGGROUNDS_ARGUS_VoidZone_DeathFog = TRAININGGROUNDS_inheritsFrom(super)
	
	function TRAININGGROUNDS_ARGUS_VoidZone_DeathFog:Setup(environment,caster)
		super.Setup(self,environment,caster)
		caster.deathfogs=self
	end
	
	function TRAININGGROUNDS_ARGUS_VoidZone_DeathFog:SetCustomInfo()
		super.SetCustomInfo(self)
		
		self.aura=TRAININGGROUNDS_ARGUS_Aura_DeathFog
		
		-- Cone of Death
		self.cones={}
		-- Soulblight
		self.pools={}
		
		self:CalculateFogColor()
	end
	
	--TODO: somewhere in Game.lua, explain/allude to why we call the Step event the Step event
	function TRAININGGROUNDS_ARGUS_VoidZone_DeathFog:Step(elapsed)		
		self:CalculateFogColor()	
	end
	
	function TRAININGGROUNDS_ARGUS_VoidZone_DeathFog:AddCone(cone)
		tinsert(self.cones,cone)
	end
	
	function TRAININGGROUNDS_ARGUS_VoidZone_DeathFog:AddPool(pool)
		tinsert(self.pools,pool)
	end	
	
	function TRAININGGROUNDS_ARGUS_VoidZone_DeathFog:CollisionCheck(mobile)
		--TODO: possibly line-triangle collision instead
		local hit=false
		--print("#Cones:",#self.cones)
		for i=1,#self.cones do
			local cone=self.cones[i]
			--TODO: it is not necessary to check for cone.graceperiod (cones never have grace period)
				-- but we need to decide whether to keep this check just for consistency
			--if(self.environment.localtime>cone.spawntime+cone.graceperiod)then			
				hit=TRAININGGROUNDS_PointTriangleCollision(mobile.x,mobile.y,cone.x1,cone.y1,cone.x2,cone.y2,cone.x3,cone.y3)
				if(hit)then
					break
				end
			--end
		end
		-- --if we hit a cone, we can skip over the pool check
		if(not hit)then
			for i=1,#self.pools do
				local pool=self.pools[i]
				if(self.environment.localtime>pool.spawntime+pool.graceperiod)then	
					hit=TRAININGGROUNDS_PointCircleCollision(mobile.x,mobile.y,pool.x,pool.y,pool.width/2)
					if(hit)then
						break
					end
				end
			end
		end
		--we checked both cones and pools; now act on it
		if(hit)then	
			self:OnEnterVoidZone(mobile)
		else
			self:OnLeaveVoidZone(mobile)
		end
	end
	
	function TRAININGGROUNDS_ARGUS_VoidZone_DeathFog:CalculateFogColor()
		local t=self.environment.localtime*0.5
		local t2=t*1.5
		local brightness=0.75+0.25*math.cos(t2)
		self.fogcolorR=0--(0.125+0.125)*math.cos(t)*brightness
		self.fogcolorG=0
		self.fogcolorB=0.25*brightness
		self.fogcolorA=1.0
	end
	
	function TRAININGGROUNDS_ARGUS_VoidZone_DeathFog:SetFogColor(fogobject)
		if(not self.fogcolorR)then
			self:CalculateFogColor()
		end
	end

end