
-- This is a "fake" void zone.
-- Collision for all cones and pools is handled by TRAININGGROUNDS_ARGUS_VoidZone_DeathFog

--TODO: lots of overlap with Telegraph_Cone here

do
	local super=TRAININGGROUNDS_GameObject
	TRAININGGROUNDS_ARGUS_FakeVoidZone_ConeOfDeath = TRAININGGROUNDS_inheritsFrom(super)

	function TRAININGGROUNDS_ARGUS_FakeVoidZone_ConeOfDeath:Setup(environment,spellinstance)
		super.Setup(self,environment)
		if(not spellinstance.castercombat.deathfogs)then
			local deathfogs=TRAININGGROUNDS_ARGUS_VoidZone_DeathFog.new()			
			deathfogs:Setup(environment,spellinstance.castercombat)	
		end				
		spellinstance.castercombat.deathfogs:AddCone(self)
		self.deathfogcontroller=spellinstance.castercombat.deathfogs
		self.spawntime=environment.localtime
		self.graceperiod=0
	end
	
	function TRAININGGROUNDS_ARGUS_FakeVoidZone_ConeOfDeath:SetCustomInfo()
		super.SetCustomInfo(self)
		self.x1=0
		self.y1=0
		self.x2=0
		self.y2=0
		self.x3=0
		self.y3=0
	end
		
	function TRAININGGROUNDS_ARGUS_FakeVoidZone_ConeOfDeath:SetDrawable()
		self.drawable=TRAININGGROUNDS_Drawable_Polygon_VoidZone.new()		
		self.drawable:Setup(self,self.environment)
	end
	
	function TRAININGGROUNDS_ARGUS_FakeVoidZone_ConeOfDeath:PreDraw()
		super.PreDraw(self)
		local r,g,b,a=self.deathfogcontroller.fogcolorR,self.deathfogcontroller.fogcolorG,self.deathfogcontroller.fogcolorB,self.deathfogcontroller.fogcolorA
		local timeelapsedsincespawn=self.environment.localtime-self.spawntime
		local flash=1*(2*(0.5-timeelapsedsincespawn))
		if(flash>1)then flash=1 end
		if(flash<0)then flash=0 end
		r=r+((1-r)*flash)
		g=g+((1-g)*flash)
		b=b+((1-b)*flash)
		self.drawable:SetColor(r,g,b,a)
	end
	
	function TRAININGGROUNDS_ARGUS_FakeVoidZone_ConeOfDeath:SetVertices(x1,y1,x2,y2,x3,y3)
		self.x1=x1;self.y1=y1;self.x2=x2;self.y2=y2;self.x3=x3;self.y3=y3
		self.drawable:SetVertices(x1,y1,x2,y2,x3,y3)		
	end


end