--TRAININGGROUNDS_ARGUS_Spell_Argus_ConeOfDeath=TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_Spell)
TRAININGGROUNDS_ARGUS_Spell_Argus_ConeOfDeath=TRAININGGROUNDS_inheritsFrom(TRAININGGROUNDS_Spell_SampleRangedAttack)
function TRAININGGROUNDS_ARGUS_Spell_Argus_ConeOfDeath:SetCustomInfo()
	TRAININGGROUNDS_Spell_SampleRangedAttack.SetCustomInfo(self)
	self.bosscastingstyle=TRAININGGROUNDS_SpellBossCastingStyle.RANDOMRANGED
	self.basecastduration=2.500
end

-- function TRAININGGROUNDS_ARGUS_Spell_Argus_ConeOfDeath:NewQueue()
	-- return TRAININGGROUNDS_Spell.NewQueue(self)
-- end

function TRAININGGROUNDS_ARGUS_Spell_Argus_ConeOfDeath:StartCasting(caststarttime)
	TRAININGGROUNDS_Spell.StartCasting(self,caststarttime)
	self.targetlocation=self.targetcombat:GetLocation()
	--print("Location: ",self.targetlocation)
	--TODO: .y and .x, not [2] and [1]  (if this is even possible)
	self.targetangle=math.atan2(self.targetlocation[2],self.targetlocation[1])
	--print("Angle: ",self.targetangle)
end

function TRAININGGROUNDS_ARGUS_Spell_Argus_ConeOfDeath:BeginCastingAnimationFunction()
	-- start casting: animation 219
	-- finish casting: animation 220
	self.castercombat.owner.drawable.animationsystem:SetAnimation(TRAININGGROUNDS_ARGUS_ANIMATION_LIST.CONEOFDEATH_BEGIN)
end

function TRAININGGROUNDS_ARGUS_Spell_Argus_ConeOfDeath:CompleteCastingAnimationFunction()
	self.castercombat.owner.drawable:StopSpellcast()
	self.castercombat.owner.drawable.animationsystem:SetAnimation(TRAININGGROUNDS_ARGUS_ANIMATION_LIST.CONEOFDEATH_END)
end
	
function TRAININGGROUNDS_ARGUS_Spell_Argus_ConeOfDeath:ExecuteSpellEffect(projectile)
	local cone=TRAININGGROUNDS_ARGUS_FakeVoidZone_ConeOfDeath.new()
	cone:Setup(self.castercombat.owner.environment,self)

	local x1,y1=self.castercombat.owner.x,self.castercombat.owner.y
	local CONE_LENGTH=2000
	local x2,y2=x1+CONE_LENGTH*math.cos(self.targetangle-math.pi/8.0),y1+CONE_LENGTH*math.sin(self.targetangle-math.pi/8.0)
	local x3,y3=x1+CONE_LENGTH*math.cos(self.targetangle+math.pi/8.0),y1+CONE_LENGTH*math.sin(self.targetangle+math.pi/8.0)	
		
	cone:SetVertices(x1,y1,x2,y2,x3,y3)
	--TRAININGGROUNDS_FrameVisibilityCheck(cone.drawable.frame)
end