do
	local super=TRAININGGROUNDS_GameObject
	TRAININGGROUNDS_ARGUS_FakeVoidZone_Soulblight=TRAININGGROUNDS_inheritsFrom(super)

	function TRAININGGROUNDS_ARGUS_FakeVoidZone_Soulblight:Setup(environment,arguscombat)
		super.Setup(self,environment)
		if(not arguscombat.deathfogs)then
			local deathfogs=TRAININGGROUNDS_ARGUS_VoidZone_DeathFog.new()
			deathfogs:Setup(environment,arguscombat)	
		end				
		arguscombat.deathfogs:AddPool(self)
		self.deathfogcontroller=arguscombat.deathfogs
		self.spawntime=environment.localtime
	end
	
	
	function TRAININGGROUNDS_ARGUS_FakeVoidZone_Soulblight:SetCustomInfo()
		super.SetCustomInfo(self)
		--TODO: SetGracePeriodInTicks(1)
		--TODO: does the grace period apply to the pool itself, or to the player who dropped the pool?
		self.graceperiod=1.0
		self.width=150
		self.height=self.width
	end
		
	function TRAININGGROUNDS_ARGUS_FakeVoidZone_Soulblight:SetDrawable()
		-- self.drawable=TRAININGGROUNDS_Drawable_Sprite.new()		
		-- self.drawable:Setup(self,self.environment)
		-- self.drawable.filename="Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\Misc\\circle.tga"
		-- self.drawable:ReloadFile()		
				
		self.drawable=TRAININGGROUNDS_Drawable_Sprite_Circle_VoidZone.new()		
		self.drawable:Setup(self,self.environment)
		--self.drawable.filename="Interface\\AddOns\\TrainingGrounds\\Assets\\Graphics\\Misc\\circle.tga"
		--self.drawable:ReloadFile()		
		
		--TODO: work out exactly what drawable info goes in Drawable and what goes in Mobile but gets copied to Drawable during PreDraw
		self.drawable.width=self.width
		self.drawable.height=self.height		
	end
	
	function TRAININGGROUNDS_ARGUS_FakeVoidZone_Soulblight:PreDraw()
		super.PreDraw(self)
		local r,g,b,a=self.deathfogcontroller.fogcolorR,self.deathfogcontroller.fogcolorG,self.deathfogcontroller.fogcolorB,self.deathfogcontroller.fogcolorA
		local timeelapsedsincespawn=self.environment.localtime-self.spawntime
		local flash=1*(2*(0.5-timeelapsedsincespawn))
		if(flash>1)then flash=1 end
		if(flash<0)then flash=0 end
		--TODO: decide whether we want soulblight puddles to flash
			flash=0
		r=r+((1-r)*flash)
		g=g+((1-g)*flash)
		b=b+((1-b)*flash)
		self.drawable:SetColor(r,g,b,a)
	end
	
	function TRAININGGROUNDS_ARGUS_FakeVoidZone_Soulblight:SetVertices(x1,y1,x2,y2,x3,y3)
		self.x1=x1;self.y1=y1;self.x2=x2;self.y2=y2;self.x3=x3;self.y3=y3
		self.drawable:SetVertices(x1,y1,x2,y2,x3,y3)		
	end


end