-- -- Phase 1 choreography, take 2:
-- -- all players except maintank apply aura 00
-- -- aura 00: idle: angle = coneangle, distance = (ranged/melee function)
-- -- skysea aura applied to player: apply aura 10, reactiontime +2.000
-- -- aura 10: place skysea: angle=coneangle+pi/8, distance = (sea/sky function)
-- -- skysea aura removed from player: remove aura 10 reactiontime +1.000, then apply aura 20 to all players reaction +2.000
-- -- aura 20: collect skysea: coordinate pair = (corresponding skysea zone location)
-- -- skysea buff applied to player: remove aura 20 reactiontime +1.000
-- -- skysea zone overlaps deathfog: remove aura 20
-- -- skysea zone dies: remove aura 20
-- -- soulblight applied to player: apply aura 30
-- -- aura 30: place soulblight: angle=coneangle, distance=(soulblight slot function) reactiontime +1.000
-- -- soulblight removed from player: remove aura 30, set aura 40 reactiontime +1.000
-- -- aura 40: move waypoint angle=coneangle+pi/8 distance=(currentdistance/2)
-- -- player reaches destination OR higher priority aura applied: remove aura 40
-- -- argus 90+ energy: set aura 999: angle=coneangle, reaction -10.000
-- -- aura 999: angle=coneangle.  when applied, recalculate all existing auras
-- -- argus casts coneofdeath: remove aura 999, apply aura 50
-- -- aura 50: angle=newconeangle+pi/8
-- -- aura 50 expires after (coneofdeath.basecasttime+1) seconds + reaction +2.000

do
	TRAININGGROUNDS_ARGUS_CustomDanceEvents={}
	local i=0
	i=i+1;TRAININGGROUNDS_ARGUS_CustomDanceEvents.ABANDON_SEA=i
	i=i+1;TRAININGGROUNDS_ARGUS_CustomDanceEvents.ABANDON_SKY=i
	
	
	local super=TRAININGGROUNDS_GroupDanceModule	
	TRAININGGROUNDS_ARGUS_GroupDanceModule_Argus_Phase1=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_ARGUS_GroupDanceModule_Argus_Phase1
	
	
	function class:SetCustomInfo()
		super.SetCustomInfo(self)
		self.mode=1	-- 1 counterclockwise, -1 clockwise
		self.safeangle=math.pi/2*((self.mode+1)/2)
		self:ClearSoulblightSlots()
	end
	
	function class:ClearSoulblightSlots()
		self.soulblightslots={}
	end
	
	function class:PopulateDefaultRaid(environment)
		--self.argus=self.bosscontroller.argus
		--print("PopulateDefaultRaid boss:",self.argus)
		
		self.raid:CreatePlayers(environment,3,0,4,1)
		self.raid:MakeAllPlayersIrrelevant()
	end
	
	--TODO: run StartDancing
	function class:StartDancing()
		
	end

		
	function class:ReactToCombatEvent(event)
		--print("React:",event.action,event.subject,event.target)
		--TODO: rename "action" and "subject"
		if(event.action==TRAININGGROUNDS_CombatEventType.AURA_APPLIED
		and event.subject==TRAININGGROUNDS_ARGUS_Aura_GiftOfTheSea)then			
			-- apply aura 10 to event.target with long reactiontime
		elseif(event.action==TRAININGGROUNDS_CombatEventType.AURA_APPLIED
		and event.subject==TRAININGGROUNDS_ARGUS_Aura_GiftOfTheSky)then
			-- apply aura 10 with long reactiontime
		elseif(event.action==TRAININGGROUNDS_CombatEventType.AURA_REMOVED
		and event.subject==TRAININGGROUNDS_ARGUS_Aura_StrengthOfTheSea)then
			-- remove aura 10 with short reaction time
			-- apply aura 20 to all ranged players with long reactiontime
		elseif(event.action==TRAININGGROUNDS_CombatEventType.AURA_REMOVED
		and event.subject==TRAININGGROUNDS_ARGUS_Aura_StrengthOfTheSky)then			
			-- remove aura 10 with short reaction time
			-- apply aura 20 to all melee players with long reactiontime
		elseif(event.action==TRAININGGROUNDS_CombatEventType.AURA_APPLIED   
		and (event.subject==TRAININGGROUNDS_ARGUS_Aura_StrengthOfTheSea
		or event.subject==TRAININGGROUNDS_ARGUS_Aura_StrengthOfTheSky))then
			-- remove aura 20 with medium reaction time
		elseif(event.action==TRAININGGROUNDS_CombatEventType.CHOREOGRAPHY_STATUS
		and(event.subject==self.TRAININGGROUNDS_ARGUS_CustomDanceEvents.ABANDON_SEA))then
			-- remove aura 20 from all ranged players			
		elseif(event.action==TRAININGGROUNDS_CombatEventType.CHOREOGRAPHY_STATUS
		and(event.subject==self.TRAININGGROUNDS_ARGUS_CustomDanceEvents.ABANDON_SKY))then
			-- remove aura 20 from all melee players
		elseif(event.action==TRAININGGROUNDS_CombatEventType.MOBILE_REMOVED
		and(event.subject==TRAININGGROUDNS_ARGUS_VoidZone_StrengthOfTheSea))then
			-- remove aura 20 from all ranged players	
		elseif(event.action==TRAININGGROUNDS_CombatEventType.MOBILE_REMOVED
		and(event.subject==TRAININGGROUDNS_ARGUS_VoidZone_StrengthOfTheSky))then
			-- remove aura 20 from all melee players	
		elseif(event.action==TRAININGGROUNDS_CombatEventType.AURA_APPLIED
		and (event.subject==TRAININGGROUNDS_ARGUS_Aura_Soulblight))then
			--print("apply aura 30 to event.target")
			-- apply aura 30 to event.target, medium reactiontime
			
			local groupdancemodule=self			
			local aura=function(personaldancemodule)								
					--TODO: store bossmodule during setup
				--dubious
				personaldancemodule.angle=groupdancemodule.safeangle								
			end
			
			
		elseif(event.action==TRAININGGROUNDS_CombatEventType.AURA_REMOVED
		and (event.subject==TRAININGGROUNDS_ARGUS_Aura_Soulblight))then		
			-- remove aura 30, medium reactiontime
			-- apply aura 40, matching reactiontime
		elseif(event.action==TRAININGGROUNDS_CombatEventType.WAYPOINT_REACHED)then
			-- remove aura 40
		elseif(event.action==TRAININGGROUNDS_CombatEventType.DANCE_APPLIED)then
			if(event.instance.priority)then
				--remove aura 40
			else
				print("ERROR: Assertion failed: event.instance.priority is nil")
				print("Event.instance:",event.instance)
				error("Assertion failed: event.instance.priority is nil")
			end
		end
	end

	
	
end
	