do
	local super=TRAININGGROUNDS_Mobile
	TRAININGGROUNDS_AGGRAMAR_Mobile_WakeOfFlame=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_AGGRAMAR_Mobile_WakeOfFlame
	
	function class:Setup(environment)
		super.Setup(self,environment)
		self.movementangle=nil
		self.movetime=self.environment.localtime+1.5
		--self.expirytime=self.environment.localtime+1.5+0.5
		--self.expirytime=self.environment.localtime+1.5+5.0
		self.expirytime=self.environment.localtime+1.5+7.5
		self.collided_with_player=false
	end
	
	function class:SetCustomInfo()
		super.SetCustomInfo(self)

		self.basemovespeed=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(7.5*3)	
		self.hitboxradius=TRAININGGROUNDS_Mobile_StandardHitboxRadius*0.25
	end
	

	
	function class:GetName()
		--override, don't call super
		return "WakeOfFlame "..tostring(self.id)
	end
	
	function class:SetDrawable()
		self.drawable=TRAININGGROUNDS_AGGRAMAR_Drawable_WakeOfFlame.new()
		self.drawable:Setup(self,self.environment)
	end
	
	function class:CreateAssociatedObjects()
		super.CreateAssociatedObjects(self)
		self.shadow.drawable:SetColor(1,0.25,0.25,1)
	end
	
	function class:SetMovementAngle(angle)
		self.movementangle=angle
	end
	
	function class:Step(elapsed)
		super.Step(self,elapsed)
		if(self.environment.localtime>self.movetime)then
			--TODO: ai uses "location", but worldmarker uses "position".  rename one of them
			if(not self.ai.targetlocation)then
				local yard=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(1)
				self.ai.targetlocation={x=self.x+math.cos(self.movementangle)*yard*500,
										y=self.y+math.sin(self.movementangle)*yard*500}
				
			end
		end
		
		if(not self.collided_with_player)then
			if(self.xspeed~=0 or self.yspeed~=0)then
				local player=self.environment.game.scenario.raid.rdps[1]
				--local distx=player.x-self.x
				--local disty=player.y-self.y
				--local distsqr=distx*distx+disty*disty
				--if(distsqr<=player.hitboxradius)then			
				local x1=self.x-self.xspeed*elapsed
				local y1=self.y-self.yspeed*elapsed			
				if(TRAININGGROUNDS_LineCircleCollision(x1,y1,self.x,self.y,player.x,player.y,(player.hitboxradius+self.hitboxradius)))then
					self.collided_with_player=true
					player.combat.combatlog:RecordEvent({		action=TRAININGGROUNDS_CombatEventType.HIT_BY_ATTACK,
								subject=TRAININGGROUNDS_AGGRAMAR_Mobile_WakeOfFlame,
								target=player.combat
								})		
				end
			end
		end
		
		
		--TODO: collision detection with player
	end
	
	-- function class:Cleanup()
		-- super.Cleanup(self)
		-- --print("WakeOfFlame:Cleanup")
	-- end
	
end