do
	local super=TRAININGGROUNDS_Spell_SampleMeleeAttack
	TRAININGGROUNDS_AGGRAMAR_Spell_SearingTempest=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_AGGRAMAR_Spell_SearingTempest
	
	function class:GetName()
		return "Empowered Searing Tempest"
	end		
	
	
	function class:SetCustomInfo()
		-- wowhead database says 35yd range
	
		super.SetCustomInfo(self)
		self.basecastduration=6.0
		
		self.range=nil
		--TODO: does not set GCD, is not affected by GCD
		--TODO: castable while moving
		self.basegcd=1.5	-- taeshtech GCD is applied at the END of the cast
		self.blockqueueingwhilecasting=true
	end
	
	function class:ExecuteSpellEffect(projectile)	
		--TODO: 20-yard telegraph
		--TODO: apply debuff and knockback
		--TODO: if player soaks wrong flame rend, call wipe
	end
	
	--TODO: suction effect while casting
	
	function class:SetQueuedTarget()	
		-- do nothing; targetless spell
	end
	
	function class:StartCasting(caststarttime)		
		super.StartCasting(self,caststarttime)
		local castermobile=self.castercombat.owner
		local telegraph=TRAININGGROUNDS_Telegraph_Circle_Flash.new()
		telegraph:Setup(castermobile.environment)		
		telegraph.x=castermobile.x
		telegraph.y=castermobile.y
			--TODO: nil expiry, but vanish when castercombat stops casting
				-- can't use caststarttime as castercombat's localtime is different from environment's
		telegraph.expirytime=castermobile.environment.localtime+self.basecastduration
		telegraph:SetColor(0.5,0.5,0,1)
		--TODO: two layers of telegraphs?
		telegraph:ChangeFrameLayer(castermobile.environment.camera.voidzoneframelayer)
		
		telegraph:SetRadius(TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(35))	--TODO: fix magic number
		
		local raiders=castermobile.environment.raiders
		for i=1,#raiders do			
			local raider=raiders[i]
			local aura=raider.combat:ApplyAuraByClass(TRAININGGROUNDS_AGGRAMAR_Aura_SearingTempestVacuum,self.castercombat)
			aura.expiry=raider.environment.localtime+self.basecastduration
			--print("Apply aura, expiry",aura.expiry)
		end
		
	end
	
	function class:BeginCastingAnimationFunction()	
		--print(class:GetName())
		--TODO:
	end
	
	function class:CompleteCasting(castendtime)
		super.CompleteCasting(self,castendtime)
		self:ApplyGCD(castendtime)
	end
	
	function class:CompleteCastingAnimationFunction()	
		--TODO:
		self.castercombat.owner.drawable:SetAnimation(TRAININGGROUNDS_AGGRAMAR_ANIMATION_LIST.SearingTempest)
	end	
	
	function class:ExecuteSpellEffect(projectile)
		local castermobile=self.castercombat.owner
		local telegraph=TRAININGGROUNDS_Telegraph_Circle_FlashOnce.new()
		telegraph:Setup(castermobile.environment)		
		telegraph.x=castermobile.x
		telegraph.y=castermobile.y
		telegraph:SetColor(1,0,0,1)
		local radius=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(35)
		telegraph:SetRadius(radius)	--TODO: fix magic number
		
		local mobiles=TRAININGGROUNDS_GetAllObjectsInCircle(
		self.castercombat.owner.environment.mobiles,
		castermobile.x,castermobile.y,radius)
		for i=1,#mobiles do			
			local mob=mobiles[i]
			self.castercombat.combatlog:RecordEvent({
							action=TRAININGGROUNDS_CombatEventType.HIT_BY_ATTACK,
							subject=self:Class(),
							target=mob.combat
							})
		end
	end
end