do
	local super=TRAININGGROUNDS_Spell_SampleMeleeAttack
	TRAININGGROUNDS_AGGRAMAR_Spell_FoeBreaker=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_AGGRAMAR_Spell_FoeBreaker
	
	function class:GetName()
		return "Empowered Foe Breaker"
	end	
	
	function class:SetCustomInfo()
		-- wowhead database says 25yd range
		super.SetCustomInfo(self)
		-- cast duration is currently based on animation timing
		self.basecastduration=2.75
		self.basegcd=1.0	-- taeshtech GCD is applied at the END of the cast
		self.range=nil
		--TODO: castable while moving?
		self.blockqueueingwhilecasting=true
	end
	
	function class:SetQueuedTarget()	
		-- do nothing; targetless spell
	end

	function class:StartCasting(caststarttime)
		super.StartCasting(self,caststarttime)
		self.castercombat:ApplyAuraByClass(TRAININGGROUNDS_Aura_Facing_CombatTarget_WhileCasting,self.castercombat)
	end	
	
	function class:BeginCastingAnimationFunction()	
		-- foe breaker may occur twice in a row, so for now, SetAnimationAndRestart		
		--TODO: after GCD is implemented, there should be a moment of cooldown for boss's animation to return to stance
		--TODO: after 3.0 seconds, priority should drop to stance
		self.castercombat.owner.drawable:SetAnimationAndRestart(TRAININGGROUNDS_AGGRAMAR_ANIMATION_LIST.FoeBreaker)
	end
	
	function class:CompleteCasting(castendtime)
		super.CompleteCasting(self,castendtime)
		self:ApplyGCD(castendtime)
	end
	
	function class:CompleteCastingAnimationFunction()	
		--TODO: (maybe do nothing)
	end	
	
	function class:ExecuteSpellEffect(projectile)
		local castermobile=self.castercombat.owner
		local targetx,targety
		-- Argus aims at his CURRENT target, not the target when he started casting
		if(self.castercombat.targetcombat)then
			local targetmobile=self.castercombat.targetcombat.owner
			targetx=targetmobile.x
			targety=targetmobile.y
		else
			targetx=castermobile.x+math.cos(castermobile.currentfacing)
			targety=castermobile.y+math.sin(castermobile.currentfacing)
		end
		local cone=TRAININGGROUNDS_Telegraph_Cone_FlashOnce.new()
		local directionangle=math.atan2(targety-self.castercombat.owner.y,targetx-self.castercombat.owner.x)
		--TODO: rename "widthangle" to "sweepangle"
		--local widthangle=(math.pi*2.0/3)	--120 degrees?
		local widthangle=(math.pi*2.0/4)	--90 degrees?
		local radius=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(25)	--TODO: fix magic number
		
		local x1=castermobile.x
		local y1=castermobile.y
		
		cone:Setup(castermobile.environment)
		cone:PositionCone(x1,y1,directionangle,widthangle,radius)
		cone:SetColor(1,0,0,1.0)
		
		-- local x2=x1+math.cos(directionangle-widthangle*0.5)*radius
		-- local y2=y1+math.sin(directionangle-widthangle*0.5)*radius
		-- local x3=x1+math.cos(directionangle+widthangle*0.5)*radius
		-- local y3=y1+math.sin(directionangle+widthangle*0.5)*radius
		

		local mobiles=TRAININGGROUNDS_GetAllObjectsInCone(
			self.castercombat.owner.environment.mobiles,
			x1,y1,directionangle,widthangle,radius)
		
		--print("Mobiles hit by Foe Breaker:",#mobiles)
		for i=1,#mobiles do			
			if(mobiles[i]~=self.castercombat.owner)then
				--TODO: who should record event, caster or target?
				self.castercombat.combatlog:RecordEvent({
								action=TRAININGGROUNDS_CombatEventType.HIT_BY_ATTACK,
								subject=self:Class(),
								target=mobiles[i].combat
								})
				local aura=mobiles[i].combat:ApplyAuraByClass(TRAININGGROUNDS_AGGRAMAR_Aura_SearingBinding,self.castercombat)
			end
		end
	end
end
