
do
	local super=TRAININGGROUNDS_Spell_SampleMeleeAttack
	TRAININGGROUNDS_AGGRAMAR_Spell_FlameRend=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_AGGRAMAR_Spell_FlameRend
	
	function class:GetName()
		return "Empowered Flame Rend"
	end		
	
	function class:SetCustomInfo()
		-- wowhead database says 25yd range
		super.SetCustomInfo(self)
		-- cast duration is currently based on animation timing
		self.basecastduration=2.75
		self.range=nil
		--TODO: does not set GCD, is not affected by GCD
		--TODO: castable while moving
		self.basegcd=1.0	-- taeshtech GCD is applied at the END of the cast
		self.blockqueueingwhilecasting=true
	end
	
	function class:SetQueuedTarget()	
		-- do nothing; targetless spell
	end
	
	function class:StartCasting(caststarttime)
		super.StartCasting(self,caststarttime)
		self.castercombat:ApplyAuraByClass(TRAININGGROUNDS_Aura_Facing_CombatTarget_WhileCasting,self.castercombat)
	end		
	
	function class:BeginCastingAnimationFunction()	
		-- note that Flame Rend will never occur twice in a row
		--TODO: it might occur twice in a row in challenge mode
		self.castercombat.owner.drawable:SetAnimation(TRAININGGROUNDS_AGGRAMAR_ANIMATION_LIST.FlameRend)
	end
	
	function class:CompleteCasting(castendtime)
		super.CompleteCasting(self,castendtime)
		self:ApplyGCD(castendtime)
	end
	
	function class:CompleteCastingAnimationFunction()	
		--TODO: (maybe do nothing)
	end	
	
	function class:ExecuteSpellEffect(projectile)
		--TODO: apply debuff and knockback
		--TODO: if player soaks wrong flame rend, call wipe	
		local castermobile=self.castercombat.owner
		local targetx,targety
		-- Argus aims at his CURRENT target, not the target when he started casting
		if(self.castercombat.targetcombat)then
			local targetmobile=self.castercombat.targetcombat.owner
			targetx=targetmobile.x
			targety=targetmobile.y
		else
			targetx=castermobile.x+math.cos(castermobile.currentfacing)
			targety=castermobile.y+math.sin(castermobile.currentfacing)
		end
		local cone=TRAININGGROUNDS_Telegraph_Cone_FlashOnce.new()
		local directionangle=math.atan2(targety-self.castercombat.owner.y,targetx-self.castercombat.owner.x)
		--TODO: rename "widthangle" to "sweepangle"
		--local widthangle=(math.pi*2.0/3)	--120 degrees?
		local widthangle=(math.pi*2.0/4)	--90 degrees?
		local radius=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(25) --TODO: fix magic number
		
		local x1=castermobile.x
		local y1=castermobile.y
		
		cone:Setup(castermobile.environment)
		cone:PositionCone(x1,y1,directionangle,widthangle,radius)
		cone:SetColor(1,0,0,1.0)
		
		local x2=x1+math.cos(directionangle-widthangle*0.5)*radius
		local y2=y1+math.sin(directionangle-widthangle*0.5)*radius
		local x3=x1+math.cos(directionangle+widthangle*0.5)*radius
		local y3=y1+math.sin(directionangle+widthangle*0.5)*radius
		
		local raiders=TRAININGGROUNDS_GetAllObjectsInCone(
			self.castercombat.owner.environment.raiders,
			x1,y1,directionangle,widthangle,radius)
		
		for i=1,#raiders do			
			local mob=raiders[i]
			self.castercombat.combatlog:RecordEvent({
							action=TRAININGGROUNDS_CombatEventType.HIT_BY_ATTACK,
							subject=self:Class(),
							target=mob.combat
							})
			local angle=math.atan2(mob.y-castermobile.y,mob.x-castermobile.x)
			--local force=(2+(20/#raiders))*50
			---- TODO: for now, we're forcing 6 raiders in case AI dance breaks.  Fix later
			local force=(3+(20/6.0))*40
			--local knockback_hz=6*force
			local knockback_hz=3*force
			local knockback_vt=2*force
			mob.z=knockback_vt*0.1	--TODO: elapsed, somehow
			mob.zspeed=knockback_vt
			mob.xspeed=knockback_hz*math.cos(angle)
			mob.yspeed=knockback_hz*math.sin(angle)
			--print("Zspeed:",mob.zspeed)
		end
	end	
end
