


do
	local super=TRAININGGROUNDS_Aura
	TRAININGGROUNDS_AGGRAMAR_Aura_RavenousBlaze=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_AGGRAMAR_Aura_RavenousBlaze
	
	function class:SetCustomInfo()
		super.SetCustomInfo(self)
		self.baseduration=8
		self.basetickrate=2
		self.tickdelay=2
	end
	
	function class:OnApply(combattime)
		--TODO: "auraradius" might become a reserved word in future
		--print("OnApply (0)")
		self.auraradius=5
		self:ApplyTelegraph()
		
		
	end
	
	function class:OnTick(ticktime,percentage)	
		super.OnTick(self,ticktime,percentage)
		self:ApplyDamageEffect()
		
		self.auraradius=self.auraradius+5		
		if(self.auraradius<=20)then
			self:ApplyTelegraph()			
		end
	end
	
	function class:ApplyTelegraph()
		local targetmobile=self.targetcombat.owner
		local telegraph=TRAININGGROUNDS_Telegraph_BigThinCircle_Flash.new()
		
		local x1=targetmobile.x
		local y1=targetmobile.y
		telegraph:Setup(targetmobile.environment)		
		telegraph.x=x1
		telegraph.y=y1
			--TODO: expires on next tick
		telegraph.expirytime=targetmobile.environment.localtime+2.0
		--telegraph.expirytime=targetmobile.environment.localtime+8.0 	-- dubious
		telegraph.flashperiod=1.0
		telegraph:SetColor(0.5,0.5,0,1)
		telegraph:ChangeFrameLayer(targetmobile.environment.camera.voidzoneframelayer)
		
		telegraph.lockonmobile=targetmobile
		
		--print(self.auraradius)
		telegraph:SetRadius(TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(self.auraradius))
	end
	
	function class:ApplyDamageEffect()
		local targetmobile=self.targetcombat.owner		
		local telegraph=TRAININGGROUNDS_Telegraph_Circle_FlashOnce.new()
		telegraph:Setup(targetmobile.environment)		
		local x1=targetmobile.x
		local y1=targetmobile.y		
		telegraph.x=x1
		telegraph.y=y1	
		telegraph:SetColor(1,0,0,1)
		telegraph:SetRadius(TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(self.auraradius))	--TODO: fix magic number
		
		local players=TRAININGGROUNDS_GetAllObjectsInCircle(
			self.castercombat.owner.environment.mobiles,
			x1,y1,TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(self.auraradius))
		
		--print("Checking for players within radius",x1,y1)
		--print("Found",#players)
		for i=1,#players do			
			if(players[i]~=targetmobile)then
				self.castercombat.combatlog:RecordEvent({
								action=TRAININGGROUNDS_CombatEventType.HIT_BY_ATTACK,
								subject=self:Class(),
								target=players[i].combat,
								source=targetmobile.combat
								})
			end
		end
	end
	
end