

--TODO LATER: search for "REDX", make sure playerdead=true for all instances

--TODO: Phase3All: Flame Rend even soak doesn't work if you miss your soak (says "Good" at the same time as "you missed")




--------
--TODO: particle effect camera apparently depends on screen size, so all particle effects need a prominent sprite telegraph, and we need to figure out how to deal with the graphics presentation...
--TODO: get a video of the spinner ember blooper (atan2modulo error on scenario populate followthroughfacing)
--TODO: increase max camera zoom?
--TODO: start scenario with camera zoomed all the way out?
--TODO LATER: it would appear that in WoW, ember's movement is in fact synced with its movement animation.

--TODO LATER: wake of flame appearance is wrong 1st time we run program, but not 2nd
	-- there is probably something in reusablemodelframe_resetproperties we need to copy over to init
	-- good chance something in init doesn't take effect until frame is made visible
	
	-- also, wake of flame appearance is still wrong on 2nd loop of 1st runthrough


do
	local super=TRAININGGROUNDS_AGGRAMAR_GroupDanceModule_Aggramar 
	TRAININGGROUNDS_AGGRAMAR_GroupDanceModule_Aggramar_Phase3All = TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_AGGRAMAR_GroupDanceModule_Aggramar_Phase3All

		
	function class:SetCustomInfo()
		super.SetCustomInfo(self)
		self.firstloop=true
		self.embers={}		
		-- we use a 3-second cooldown for Typhoon		
		self.faketyphoonoffcooldowntime=0
		-- when it's "careful time", we don't Typhoon adds as much because we're expecting Flares to come in soon.
		self.faketyphoonoffcarefultime=0		
		self.fakegorefiendsgraspoffcooldowntime=0
	end
	
	function class:GetIntoInitialPosition()		
		super.GetIntoInitialPosition(self)
		--print("KneelLoop")
		self.aggramar.drawable.animationsystem:SetAnimation(TRAININGGROUNDS_AGGRAMAR_ANIMATION_LIST.KneelLoop)
		self.aggramar.x=0;self.aggramar.y=0
		
		self.typhooncounter=0
	end
	
	--TODO: maybe baseline, maybe not
	function class:SetupInitialCameraFocus()
		local camera=self.aggramar.environment.camera
		
		tinsert(camera.focus,self.player)
		tinsert(camera.focus,self.aggramar)
	end

	
	local yard=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(1)
	local AGGRAMAR_Y=yard*35
	local REDX="\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_7:12\124t"
	
	function class:StartTestCycle()
	
		--!!!
		--!!!
		--self.debugticker=C_Timer.NewTicker(1.0,function()self:DEBUG_WakeOfFlame() end)
		--!!!
		--!!!
		
		
		
		if(self.firstloop)then self:SoakChoiceMessage() end
		
		if(self.firstloop)then
			self.embers={}
			for i=1,#self.aggramar.environment.mobiles do
				local obj=self.aggramar.environment.mobiles[i]
				if(obj:Isa(TRAININGGROUNDS_AGGRAMAR_Mobile_EmberOfTaeshalach))then
					tinsert(self.embers,obj)
				end
			end
			for i=1,#self.embers do
				local ember=self.embers[i]
				if(not ember.expirytime)then
					ember.expirytime=self.aggramar.environment.localtime+3*60
					ember.ai.fixatemobile=self.aggramar
				end
			end
		end



		--delay playerdead=false until taeshtech is cast, in case player is currently off the edge
		
		if(self.firstloop)then
			self.firstloop=false
			self.aggramar.drawable.animationsystem:SetAnimation(TRAININGGROUNDS_AGGRAMAR_ANIMATION_LIST.KneelEnd)
			
			local event=TRAININGGROUNDS_TimedDanceEvent.new()
			event.time=self.scenario.localtime+3.0	--!!!
			event.execute=function() 
								self.aggramar.ai:SetTargetLocationAndPrecision({x=0,y=AGGRAMAR_Y},0)
							end;tinsert(self.timedevents,event)			
		else
			-- If this isn't 1st loop, Aggramar might not be facing north			
			self.aggramar.projectedmovementfacing=math.pi/2
			-- (if this IS 1st loop, Aggramar is still in his standing-up animation)
		end
		
		self.maintanks[1].ai:SetTargetLocationAndPrecision({x=-yard*1,y=yard*45},0)
		self.maintanks[2].ai:SetTargetLocationAndPrecision({x=yard*1,y=yard*45},0)		
		
		local camera=self.aggramar.environment.camera
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		local wmcontroller=self.scenario.wmcontroller

		self.faketyphoonoffcarefultime=self.aggramar.environment.localtime+8+7+3
		
		self:AIPreFlare()
		event.time=self.scenario.localtime+3.0	
		event.execute=function() 
						--print("Debug: Phase3All: StartTestCycle+3.0 ResetPlayerDeathChecks")
						self:ResetPlayerDeathChecks()						
						-- self.playerdead=false
						-- self.flaredead=false
						-- self.blazedead=false
						-- self.taeshdead=false
							TRAININGGROUNDS_FakeDBM_MinorWarning(DBM,"Flare soon -- move to "..REDX)
							--self.typhooncounter=0							
							local wm4pos=wmcontroller:GetWorldMarkerPosition(4)
							if(wm4pos)then
								tinsert(camera.focus,{x=wm4pos.x,y=wm4pos.y-yard*40})
							end						
							tinsert(camera.focus,{x=0,y=AGGRAMAR_Y+yard*40})
							TRAININGGROUNDS_FakeDBM_Countdown(DBM,8)
						end;	tinsert(self.timedevents,event)	
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		event.time=self.scenario.localtime+11.0	
		event.execute=function() 
							self.aggramar.bosscontroller:ResetFlareTargets()
							TEMP_CastSpellOnTargetMobile(self.aggramar,TRAININGGROUNDS_AGGRAMAR_Spell_EmpoweredFlare,nil)							
						end;tinsert(self.timedevents,event)	
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		event.time=self.scenario.localtime+11.0+0.75
		event.execute=function() 
							TEMP_CastSpellOnTargetMobile(self.aggramar,TRAININGGROUNDS_AGGRAMAR_Spell_EmpoweredFlare,nil)
						end;tinsert(self.timedevents,event)							
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		event.time=self.scenario.localtime+11.0+1.5
		event.execute=function() 
							TEMP_CastSpellOnTargetMobile(self.aggramar,TRAININGGROUNDS_AGGRAMAR_Spell_EmpoweredFlare,nil)
						end;tinsert(self.timedevents,event)	

						
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		event.time=self.scenario.localtime+11.0+1.5		-- -11.0 
		event.execute=function() 
							self:AIPreBlaze1()
						end;tinsert(self.timedevents,event)		

			
		-- delaying	mass dispel for a bit to make massgrip easier to line up
		local event=TRAININGGROUNDS_TimedDanceEvent.new()			
		event.time=self.scenario.localtime+11.0+1.5+4.0+3	-- -11.0 
		event.execute=function() 
							self:FakeMassDispel()
						end;tinsert(self.timedevents,event)		
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		event.time=self.scenario.localtime+11.0+1.5+4.0+3+1.5	-- -11.0 
		event.execute=function() 
							self:FakeGorefiendsGrasp()
						end;tinsert(self.timedevents,event)								
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		event.time=self.scenario.localtime+11.0+1.5+4.0+3+1.5+1.5	-- -11.0 
		event.execute=function() 
							self:FakeSingleGrip()	
						end;tinsert(self.timedevents,event)	
						
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		event.time=self.scenario.localtime+16.5
		event.execute=function() 												
							TRAININGGROUNDS_FakeDBM_MinorWarning(DBM,"Ravenous Blaze soon")
							TRAININGGROUNDS_FakeDBM_Countdown(DBM,8)
						end;tinsert(self.timedevents,event)							
						
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		event.time=self.scenario.localtime+22.5			-- -16.0 
		event.execute=function() 
							self:AIPreBlaze2()
						end;tinsert(self.timedevents,event)							
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		--event.time=self.scenario.localtime+23.5		--	-11.0 
		event.time=self.scenario.localtime+20.5		--	-11.0 		-- camera focus removal event time depends on how fast Wake of Flame moves
		event.execute=function() 
							tremove(camera.focus,4)
							tremove(camera.focus,3)							
						end;tinsert(self.timedevents,event)	
		
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		event.time=self.scenario.localtime+24.5			-- -16.0
		event.execute=function() 
							--print("Attempting Ravenous Blaze...")
							TEMP_CastSpellOnTargetMobile(self.aggramar,TRAININGGROUNDS_AGGRAMAR_Spell_RavenousBlaze,nil)
						end;tinsert(self.timedevents,event)							

		-- TODO: well this is a mess -- we somehow split the +33.0 code into 3 separate events
		if(self.playeroddoreven_choice==3)then
			local event=TRAININGGROUNDS_TimedDanceEvent.new()
			event.time=self.scenario.localtime+33	
			event.execute=function() 
							--print("Debug: randomize oddoreven (P3A)")
							self.playeroddoreven=math.random(1,2)
							if(self.firsttechnique)then		
								self.firsttechnique=false	
								--TODO: leak: first is currently global, not local
								first="First, soak the "
							else
								first="This time, soak the "
							end
							
							if(self.playeroddoreven==1)then
								which="ODD"
							else
								which="EVEN"
							end
							local soaktext=first..which.." Flame Rend."					
							if(DBM) then print(soaktext) end
							TRAININGGROUNDS_FakeDBM_MajorWarning(DBM,soaktext,1)
						end;tinsert(self.timedevents,event)	
		else
			self.playeroddoreven=self.playeroddoreven_choice
			local event=TRAININGGROUNDS_TimedDanceEvent.new()
			event.time=self.scenario.localtime+33	
			event.execute=function() 
							TRAININGGROUNDS_FakeDBM_MinorWarning(DBM,"Taeshalach Technique soon")
						end;tinsert(self.timedevents,event)			
		end
		
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		event.time=self.scenario.localtime+33
		event.execute=function() 												
							self:SetPlayerAIForInitialPositions()
							TRAININGGROUNDS_FakeDBM_Countdown(DBM,5)
						end;tinsert(self.timedevents,event)			
						
		local event=TRAININGGROUNDS_TimedDanceEvent.new()
		event.time=self.scenario.localtime+38	
		event.execute=function() 							
							TEMP_CastSpellOnTargetMobile(self.aggramar,TRAININGGROUNDS_AGGRAMAR_Spell_TaeshalachTechnique,nil)
						end;tinsert(self.timedevents,event)													
	end
	
	
	
	function class:ReactToCustomDanceEvent(event)
		if(event.action==TRAININGGROUNDS_AGGRAMAR_CustomDanceEventType.RAVENOUS_BLAZE_TARGETS)then
			-- local newevent=TRAININGGROUNDS_TimedDanceEvent.new()
			-- newevent.time=self.scenario.localtime+2.5
			-- newevent.execute=function() 		
			local targetcombats=event.targets
			local targetmobiles={}
			local target_index_table={}
			local player=self.player
			local player_index=-1
			for i=1,#targetcombats do
				targetmobiles[i]=targetcombats[i].owner
				target_index_table[targetmobiles[i]]=true
			end
			if(target_index_table[player])then				
				TRAININGGROUNDS_FakeDBM_MajorWarning(DBM,"Ravenous Blaze - move away from others",1)
			else
				TRAININGGROUNDS_FakeDBM_MinorWarning(DBM,"Ravenous Blaze",1)		
			end
			for i=1,#self.nonplayerrdps do
				local raider=self.nonplayerrdps[i]
				if(not target_index_table[raider])then
																			-- localtime+1.0 seemed a little too slow, maybe +0.75 feels better
																		-- (players with blaze really shouldn't move though until the other raiders move away)
					local newevent=TRAININGGROUNDS_TimedDanceEvent.new();newevent.time=self.scenario.localtime+0.75;newevent.execute=function() 
						self:MoveRaiderToTargetMobile(raider,self.aggramar,yard*10)
					end;tinsert(self.timedevents,newevent)	
				end
			end
			-- non-blaze players are safe,
			-- now work on blaze positioning
			for i=1,#targetmobiles do
				-- math.atan2: player on left of semicircle will have angle negative math.pi-ish
				targetmobiles[i].TEMP_angle=math.atan2(targetmobiles[i].y-AGGRAMAR_Y,targetmobiles[i].x-0)
			end
			
			table.sort(targetmobiles,function(a,b)return a.TEMP_angle<b.TEMP_angle end)	
			for i=1,#targetmobiles do
				--print("Sorted temp angle:",targetmobiles[i].TEMP_angle)
				if(targetmobiles[i]==player)then
					player_index=i
				end
			end
			local maxangle=math.pi*4/5
			local offsetangle=math.pi+(math.pi-maxangle)/2		
			local totalminus1=#targetmobiles-1
			if(totalminus1<1)then totalminus1=1 end	
			for i=1,#targetmobiles do
				local raider=targetmobiles[i]
				if(raider~=player)then						
					local newevent=TRAININGGROUNDS_TimedDanceEvent.new();newevent.time=self.scenario.localtime+2.0;newevent.execute=function() 
						local angle=offsetangle+(maxangle*((i-1)/totalminus1))
						-- must subtract 2pi to be compatible with upcoming atan2 check!
						angle=angle-math.pi*2	
						local distance=35*yard
						-- ok, so now we have the raider's target location, but
						-- IF the player has blaze, (ignore this step if player doesn't have blaze)
						-- we don't want the AI to run "past" the player
													-- <s>so check linecirclecollision (line: raider's old/new position, circle: player 20yds)</s>
						-- instead of checking linecirclecollision, just compare 
																			-- signum of new/old angles
																			-- and/or AI's angle with player's
						-- if collision would occur, AND the AI is "adjacent" to player,
							-- AI panics, picks a spot between player and previous raider, and moves out
						-- also, if AI is #1 or #5, they're already on the edge, so they'll just stand there and let player die
						local collision=false
						local currentplayerangle
						if(math.abs(player_index-i)<=1)then -- "adjacent to player" check
							if(i~=1 and i~=5)then	-- "not on edge" check
								--print("checking",i,"vs player",player_index,"...")
								--collision=TRAININGGROUNDS_LineCircleCollision(raider.x,raider,y,xpos,ypos,player.x,player.y,yard*20)	
								local currentraiderangle=math.atan2(raider.y-AGGRAMAR_Y,raider.x-0)
								currentplayerangle=math.atan2(player.y-AGGRAMAR_Y,player.x-0)
								
								local sig1=TRAININGGROUNDS_signum(currentraiderangle-currentplayerangle)
								local sig2=TRAININGGROUNDS_signum(angle-currentplayerangle)
								--print("current:",currentraiderangle,"player:",currentplayerangle,"destination:",angle)
								--if(sig1~=sig2)then
								if(math.abs(currentplayerangle-angle)<math.pi/8 or sig1~=sig2)then
									collision=true
								end
							end
						end
						if(not collision)then							
							local xpos=0+distance*math.cos(angle)
							local ypos=AGGRAMAR_Y+distance*math.sin(angle)
							raider.ai:SetTargetLocationAndPrecision({x=xpos,y=ypos},yard*2)
						else
							-- calculate the (destination) angle of the other raider who's squeezing this one against the player
							local squeezeraiderindex=i+TRAININGGROUNDS_signum(i-player_index)
							local squeezeraiderangle=offsetangle+(maxangle*((squeezeraiderindex-1)/totalminus1))
							squeezeraiderangle=squeezeraiderangle-math.pi*2	
							--print("panic!")
							--print("AI",i," --- player:",player_index)
							--print("squeeze:",squeezeraiderindex)					
							local newangle=(currentplayerangle+squeezeraiderangle)/2
							--print("new angle:",newangle)
							local newdistance=55*yard
							--TODO: check out of bounds
							local xpos=0+newdistance*math.cos(newangle)
							local ypos=AGGRAMAR_Y+newdistance*math.sin(newangle)
							raider.ai:SetTargetLocationAndPrecision({x=xpos,y=ypos},yard*2)
						end												
					end;tinsert(self.timedevents,newevent)						
				end
			end
		elseif(event.action==TRAININGGROUNDS_AGGRAMAR_CustomDanceEventType.CHECK_FLARE_DISTANCE)then
			if(event.source==self.player.combat)then
				-- allow enough time for flares to explode and collision to resolve
				-- if the player makes a mistake with collision, that takes priority over distance check
				local newevent=TRAININGGROUNDS_TimedDanceEvent.new();newevent.time=self.scenario.localtime+4.0+2.0;newevent.execute=function() 
					local red=self.wmcontroller:GetWorldMarkerPosition(4)
					local distx=event.location.x-red.x
					local disty=event.location.y-red.y
					local distsqr=distx*distx+disty*disty
					local dist=math.sqrt(distsqr)
					--mass dispel: 15 yard radius
					local mindist=yard*15
					local minsplashdist=yard*7.5
					local distnumber=string.format("%.1f",TRAININGGROUNDS_Mobile_ConvertTGUnitsToYards(dist))
					local disttext="(You placed your Flare "..distnumber.."yd away)"					
					
					if(dist>mindist)then
						if(not self.flaredead)then
							self.flaredead=true
							self.playerdead=true
							TRAININGGROUNDS_FakeDBM_MajorWarning(DBM,disttext,1,true)
							print(REDX.." Mass Dispel has a radius of 15 yards.  Place your Flare close to the stack point so the new Embers can be dispelled.")
						end
					--elseif(dist>minsplashdist)then
					-- elseif(false)then
						-- if(not self.flaredead)then
							-- --self.flaredead=true
							-- --self.playerdead=true
							-- TRAININGGROUNDS_FakeDBM_MajorWarning(DBM,disttext,1,true)
							-- print(REDX.." Real players would have dodged your Flare, but ... maybe stand closer to the group next time?")
						-- end
					else
						if(not self.flaredead)then
							TRAININGGROUNDS_FakeDBM_MajorWarning(DBM,disttext,1,true)
						end
					end
				end;tinsert(self.timedevents,newevent)
			end
		end
	end
	
	
	function class:AIPreFlare()
		for i=1,#self.nonplayerrdps do
			local raider=self.nonplayerrdps[i]
			--print("Raiderx:",raider.x,"Targetx:",targetmobile.x)
			local wmcontroller=self.scenario.wmcontroller
			local wm4pos=wmcontroller:GetWorldMarkerPosition(4)
			if(wm4pos)then
				raider.ai:SetTargetLocationAndPrecision(wm4pos,yard*3.0)
			end	
		end
	end
	
	--TODO: PreBlaze2: move away from player
	function class:AIPreBlaze1()
		local maxangle=math.pi*4/5
		local offsetangle=math.pi+(math.pi-maxangle)/2		
		for i=1,#self.nonplayerrdps do
			local raider=self.nonplayerrdps[i]
			local totalminus1=#self.nonplayerrdps-1
			if(totalminus1<1)then totalminus1=1 end
			
			--print("Raiderx:",raider.x,"Targetx:",targetmobile.x)
			if(raider~=self.player)then
				local angle=offsetangle+(maxangle*((i-1)/totalminus1))	
				local xpos=0+math.cos(angle)*yard*35
				local ypos=AGGRAMAR_Y+math.sin(angle)*yard*35
				raider.ai:SetTargetLocationAndPrecision({x=xpos,y=ypos},yard*2)
			end
		end
	end	

	function class:AIPreBlaze2()
		self:MoveRaidersAwayFromTargetMobile(self.player,yard*6)
	end	


	
	-- Blaze AI
	-- Everyone starts 35yd from Aggramar
	-- All non-targets move into center <15yd from Aggramar
	-- Sort the five targetplayers by angle (not strictly x-position) from left to right 1-5

	-- If target 1 is within 22 yd of target 2, target 1 moves left until they're clear or they reach the edge
	-- If target 5 is within 22 yd of target 4, target 5 moves right until they're clear or they reach the edge
	
	-- If target 2 is within 22 yd of target 1 XOR target 3, move left or right until they're clear
	-- If target 2 is within 22 yd of target 1 AND target 3, move back
	
	-- If target 4 is within 22 yd of target 3 XOR target 5, move left or right until they're clear
	-- If target 4 is within 22 yd of target 3 AND target 5, move back	
	
	-- Target 3 don't move?
	
	
	-- A target is "squished" if it's between two other targets and those two targets are <45yd apart

	
	
	
	function class:MoveRaiderToTargetMobile(raider,targetmobile,targetdistance)
		local raiderx=raider.x
		local raidery=raider.y		
		local distx=raiderx-targetmobile.x
		local disty=raidery-targetmobile.y
		local distsqr=distx*distx+disty*disty		
		local distx,disty,distsqr	
		if(raider.ai.targetlocation)then
			distx=raider.ai.targetlocation.x-targetmobile.x
			disty=raider.ai.targetlocation.y-targetmobile.y
			distsqr=distx*distx+disty*disty				
		else
			distx=raider.x-targetmobile.x
			disty=raider.y-targetmobile.y
			distsqr=distx*distx+disty*disty				
		end		
		if(distsqr>targetdistance*targetdistance)then						
			local angle=math.atan2(disty,distx)	
			local newx=targetmobile.x+targetdistance*math.cos(angle)
			local newy=targetmobile.y+targetdistance*math.sin(angle)			
			raider.ai:SetTargetLocationAndPrecision({x=newx,y=newy},0)
		end
	end
	
	
	
	function class:SoakChoiceMessage()
		--if(whichchoice==3)then return end
		local soaktext
		if(self.playeroddoreven_choice==1)then
			soaktext="You have chosen to soak ODD Flame Rends."
		elseif(self.playeroddoreven_choice==2)then
			soaktext="You have chosen to soak EVEN Flame Rends."
		elseif(self.playeroddoreven_choice==3)then
			soaktext="You have chosen to soak RANDOM Flame Rends!"
		end		
		TRAININGGROUNDS_FakeDBM_MajorWarning(DBM,soaktext,1)
		if(DBM) then print(soaktext) end
	end
	
	function class:ReactToCombatEvent(event)
		super.ReactToCombatEvent(self,event)
		if(event.action==TRAININGGROUNDS_CombatEventType.HIT_BY_ATTACK
		and event.subject==TRAININGGROUNDS_AGGRAMAR_Aura_RavenousBlaze
		and event.target.owner:Isa(TRAININGGROUNDS_PlayerCharacter))then	
			--print("Ravenous Blaze check")
			if(not self.blazedead)then				
				if(event.source==self.player.combat)then
					self.blazedead=true
					self.playerdead=true
					TRAININGGROUNDS_FakeDBM_MajorWarning(DBM,"You splashed other players with Ravenous Blaze!",3,true)
					print(REDX.." Spread out before Ravenous Blaze occurs to avoid killing other players.  If Ravenous Blaze affects you, keep your distance from Aggramar as well.")
				end
			end			
			if(event.target==self.player.combat)then
				self.player.combat:FlashDamageFlash_Alert()
				if(not self.blazedead)then				
					local event=TRAININGGROUNDS_TimedDanceEvent.new();event.time=self.scenario.localtime+0.5;event.execute=function() 
						if(not self.blazedead)then
							self.blazedead=true
							self.playerdead=true
							TRAININGGROUNDS_FakeDBM_MajorWarning(DBM,"You were hit by Ravenous Blaze!",3,true)
							print(REDX.." Even the small Ravenous Blaze circles will oneshot you.  Spread out before it occurs, and run toward Aggramar if you aren't affected.")
							self.aggramar.ai:SetTargetLocationAndPrecision({x=0,y=AGGRAMAR_Y},0)
						end
					end;tinsert(self.timedevents,event)					
				end
			end			
		elseif(event.action==TRAININGGROUNDS_CombatEventType.HIT_BY_ATTACK
		and event.subject==TRAININGGROUNDS_AGGRAMAR_Spell_EmpoweredFlare)then	
			--print("!!!")
			--TODO: ember detection!
			--TODO: distance from REDX detection!
			if(not self.flaredead)then
				if(event.target==self.player.combat)then
					self.player.combat:FlashDamageFlash_Alert()
					local event=TRAININGGROUNDS_TimedDanceEvent.new();event.time=self.scenario.localtime+1.5;event.execute=function() 
						if(not self.flaredead)then
							self.flaredead=true
							self.playerdead=true
							TRAININGGROUNDS_FakeDBM_MajorWarning(DBM,"You were hit by Flare!",3,true)
							print(REDX.." When the third Flare appears, you have 2.5 seconds to move out before the first Flare explodes.")
							--TODO: why was this line here?  bad copypaste?  remove if nothing broke
							--self.aggramar.ai:SetTargetLocationAndPrecision({x=0,y=AGGRAMAR_Y},0)
						end
					end;tinsert(self.timedevents,event)										
				elseif(event.target.owner:Isa(TRAININGGROUNDS_PlayerCharacter))then
					self.flaredotherplayers=true
				elseif(event.target.owner:Isa(TRAININGGROUNDS_AGGRAMAR_Mobile_EmberOfTaeshalach))then					
					if(not self.flaredead)then
						-- must check dance success BEFORE applying Catalyzed
						if(#event.target.auramodule.speedboost==0)then						
							self.flaredead=true
							self.playerdead=true
							TRAININGGROUNDS_FakeDBM_MajorWarning(DBM,"You splashed an Ember with Flare!",3,true)
							print(REDX.." Run to the stack point before Flare occurs to avoid Catalyzing the Embers of Taeshalach.")
						end
					end
				end
			end
		elseif(event.action==TRAININGGROUNDS_CombatEventType.HIT_BY_ATTACK
		and event.subject==TRAININGGROUNDS_AGGRAMAR_Mobile_WakeOfFlame
		and event.target==self.player.combat)then
			self.player.combat:FlashDamageFlash_Alert()
			if(not self.wakedead)then
				self.wakedead=true
				self.playerdead=true
				TRAININGGROUNDS_FakeDBM_MajorWarning(DBM,"You were hit by Wake of Flame!",3,true)
				print(REDX.." Flares produce Wakes of Flame when they explode.  Look behind you as you spread for Ravenous Blaze.")
			end		
		end
	end
	
	function class:Step(elapsed)
		super.Step(self,elapsed)
		local threshold=yard*(20)
		if(self.aggramar.environment.localtime>=self.faketyphoonoffcarefultime)then
			threshold=threshold+yard*self.typhooncounter*10			
		else
			self.typhooncounter=0 --!!!
			--print("???")
		end
		if(threshold>yard*40)then
			threshold=yard*40
		end
		--print("thresh",threshold)			
		if(self.aggramar.environment.localtime>=self.faketyphoonoffcooldowntime)then			
			local closestember=nil
			local closestemberdistsqr=threshold*threshold
			for i=1,#self.embers do				
				local ember=self.embers[i]
				local xdist=ember.x-0
				local ydist=AGGRAMAR_Y-ember.y
				local distsqr=xdist*xdist+ydist*ydist				
				--TODO: ignore an add after it gets gripped to aggramar
				if(distsqr<yard*7*yard*7)then
					ember:Die()	--TODO: DieInGame
				elseif(ember:CCImmunityCheck()==false)then
					if(distsqr<closestemberdistsqr)then					
						if(ember.z<=0 and ember.yspeed>0)then
							closestember=ember
							closestemberdistsqr=distsqr
						end
					end
				end
			end
			if(closestember)then
				self:FakeTyphoon(closestember)
			end
		end
		
		for i=#self.embers,1,-1 do
			local ember=self.embers[i]
			if(ember.dead)then
				tremove(self.embers,i)
			end			
		end
	end
	
	function class:FakeTyphoon(targetember)
		self.faketyphoonoffcooldowntime=self.aggramar.environment.localtime+3.0
		self.typhooncounter=self.typhooncounter+1
		
		-- aim towards REDX when using typhoon
		local red=self.wmcontroller:GetWorldMarkerPosition(4)
		local targetangle=math.atan2(red.y-targetember.y,red.x-targetember.x)
		local casterx=targetember.x-math.cos(targetangle)*yard*12
		local castery=targetember.y-math.sin(targetangle)*yard*12
		
		
		--TODO: FlameRend cone is 25 yards -- either flamerend is too small, or typhoon is too big
			-- (but for now, we're making faketyphoon very large so we hit most of the embers)
		local embers=TRAININGGROUNDS_GetAllObjectsInCone(
			self.embers,
			casterx,castery,math.pi*1.5,math.pi*2/3,yard*30)
			
		for i=1,#embers do			
			local ember=embers[i]		
			if(ember:CCImmunityCheck()==false)then
				local angle=math.atan2(ember.y-castery,ember.x-casterx)
				angle=angle+(math.random()-0.5)*math.pi/16
				local force=(3+(20/6.0))*30
				local knockback_hz=3*force
				local knockback_vt=2*force
				if(ember.z==0)then ember.z=knockback_vt*0.1	end --TODO: elapsed, somehow
				ember.zspeed=knockback_vt
				ember.xspeed=knockback_hz*math.cos(angle)
				ember.yspeed=knockback_hz*math.sin(angle)
			end
		end
	end
	
	
	function class:FakeMassDispel()
		local red=self.wmcontroller:GetWorldMarkerPosition(4)
		for i=1,#self.embers do
			local ember=self.embers[i]
			local xdist=ember.x-red.x
				-- we're aiming mass dispel a bit north of the stack point
			local ydist=ember.y-(red.y+yard*7.5)
			local distsqr=xdist*xdist+ydist*ydist
			local mindist=15*yard
			if(distsqr<=mindist*mindist)then
				--TODO: graphical spell effect
				ember.combat.auramodule:DEBUG_DispelEntireAuraList(ember.combat.auramodule.speedboost)				
			end
		end
	end
	
	function class:FakeGorefiendsGrasp()
		local red=self.wmcontroller:GetWorldMarkerPosition(4)
		-- naive massgrip: just grab anything within 20 yards of center			
		local casterx=0
		-- 20 yards north of red absolute minimum, but adds will run a bit while catalyzed
		local castery=red.y+yard*(20+10)
		for i=1,#self.embers do			
			local ember=self.embers[i]					
			if(ember:CCImmunityCheck()==false)then
				local xdist=ember.x-casterx
				local ydist=ember.y-castery
				local distsqr=xdist*xdist+ydist*ydist				
				--TODO: ignore an add after it gets gripped to aggramar (but not singlegripped INTO pack)
				if(distsqr<yard*20*yard*20)then
					--!!!
					--TODO: in addition to proper pull aura,
					-- only pull to within 5-7 yards of caster
					--ember.x=casterx
					--ember.y=castery
					self:FakeSingleGripMobileToLocation(ember,casterx,castery)
				end
			end
		end
	end
	
	function class:FakeSingleGrip()
		local red=self.wmcontroller:GetWorldMarkerPosition(4)
		local casterx=0
		local castery=red.y+yard*(20+10+3)
		local furthestdistsqr=yard*7*yard*7
		local furthestember=nil
		for i=1,#self.embers do			
			local ember=self.embers[i]					
			if(ember:CCImmunityCheck()==false)then
				local xdist=ember.x-casterx
				local ydist=ember.y-castery
				local distsqr=xdist*xdist+ydist*ydist				
				--TODO: ignore an add after it gets gripped to aggramar (but not singlegripped INTO pack)
				if(distsqr<yard*30*yard*30)then
					if(distsqr>furthestdistsqr)then
						furthestdistsqr=distsqr
						furthestember=ember
					end
				end
			end
		end
		if(furthestember)then
			--TODO: proper pull aura
			--print("pulling",furthestember)
			--furthestember.x=casterx
			--furthestember.y=castery
			self:FakeSingleGripMobileToLocation(furthestember,casterx,castery)
		else
			--print("nothing to pull")
		end
	end	
	
	function class:FakeSingleGripMobileToLocation(mob,x,y)
		--TODO: pass localtime (environment.localtime and/or combat.localtime?) to applyaurabyclass
		local grip=mob.combat:ApplyAuraByClass(TRAININGGROUNDS_Aura_Grip,mob.combat)
		local distx=x-mob.x
		local disty=y-mob.y
		local dist=math.sqrt(distx*distx+disty*disty)
		local targetdist=yard*2
		local angle=math.atan2(disty,distx)
		--if enemy is already closer than 2 yards, just move it slightly closer (half distance to target)
		if(dist<targetdist)then 
			targetdist=dist/2 
		end
		grip.startx=mob.x
		grip.starty=mob.y
		grip.startz=mob.z
		grip.targetx=x+math.cos(angle)*targetdist
		grip.targety=y+math.sin(angle)*targetdist
		grip.targetz=0
		
	end
	
	function class:DEBUG_WakeOfFlame()
		--local startangle=math.random()*math.pi*2
		local startangle=0 --!!!
		--print("Wake of Flame...")
		--TODO NEXT: possible temp workaround -- run this exactly once at startup so the frames will get recycled?
		local wakecount=5 --!!!
		for i=1,wakecount do
			local wake=TRAININGGROUNDS_AGGRAMAR_Mobile_WakeOfFlame.new()
			wake:Setup(self.aggramar.environment)
			local angle=startangle+i*(math.pi*2/wakecount)
			local green=self.wmcontroller:GetWorldMarkerPosition(2)
			-- wake.x=damagetelegraph.x+math.cos(angle)*yard*10
			-- wake.y=damagetelegraph.y+math.sin(angle)*yard*10
			wake.x=green.x+math.cos(angle)*yard*10
			wake.y=green.y+math.sin(angle)*yard*10
			wake:SetMovementAngle(angle)

			--wake.expirytime=self.aggramar.environment.localtime+1
		end
	end
	
	function class:GetEndOfCycleDelay()
		return 0.0
	end
	
	
	function class:Cleanup()
		if(self.debugticker)then			
			--print("Cancelled debugticker successfully (if we don't see this message, /reload now before your client crashes)")
			self.debugticker:Cancel()
		end
	end
end