do
	local super=TRAININGGROUNDS_Telegraph_Circle_Flash
	TRAININGGROUNDS_AGGRAMAR_Telegraph_Flare=TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_AGGRAMAR_Telegraph_Flare
	
	function class:SetCustomInfo()
		super.SetCustomInfo(self)
		-- overwrite targetradius after setup
		self.targetradius=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(10)		
		-- overwrite playersource after setup
		self.sourcecombat=nil
		-- TODO: move currentradius to setup instead of setcustominfo
		self.currentradius=0
		
		-- set by Spell_EmpoweredFlare, determined by bosscontroller
		self.wakeofflame_at_player=nil
	end
	
	function class:Step(elapsed)
		super.Step(self,elapsed)

		if(self.currentradius<self.targetradius)then
			self.currentradius=self.currentradius+elapsed*TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(20.0)
			if(self.currentradius>self.targetradius)then
				self.currentradius=self.targetradius				
			end
			self:SetRadius(self.currentradius)
		end
	end
	
	function class:OnExpiry(expirytime)
		local damagetelegraph=TRAININGGROUNDS_Telegraph_Circle_FlashOnce.new()
		damagetelegraph:Setup(self.environment)
		damagetelegraph.x=self.x
		damagetelegraph.y=self.y
		damagetelegraph:SetRadius(self.targetradius)
		damagetelegraph:SetColor(1,0,0,1)
		

		local mobiles=TRAININGGROUNDS_GetAllObjectsInCircle(
			self.environment.mobiles,
			damagetelegraph.x,damagetelegraph.y,self.targetradius)
		
		for i=1,#mobiles do						
			-- must check dance success BEFORE applying Catalyzed
				-- (since we're ignoring mobs which spawn from flares and already have Catalyzed)
			mobiles[i].combat.combatlog:RecordEvent({
							action=TRAININGGROUNDS_CombatEventType.HIT_BY_ATTACK,
							subject=TRAININGGROUNDS_AGGRAMAR_Spell_EmpoweredFlare,
							target=mobiles[i].combat,
							source=self.sourcecombat
							})		
			if(mobiles[i]:Isa(TRAININGGROUNDS_AGGRAMAR_Mobile_EmberOfTaeshalach))then
				mobiles[i].combat:ApplyAuraByClass(TRAININGGROUNDS_AGGRAMAR_Aura_Catalyzed,self.sourcecombat)
			end
		end			
		
	
		local ember=TRAININGGROUNDS_AGGRAMAR_Mobile_EmberOfTaeshalach.new()
		ember:Setup(self.environment)
		ember.x=damagetelegraph.x
		ember.y=damagetelegraph.y
		ember.combat:ApplyAuraByClass(TRAININGGROUNDS_AGGRAMAR_Aura_Catalyzed,self.sourcecombat)

		local bosscontroller=self.environment.game.scenario.aggramar
		if(not bosscontroller)then error("Assertion failed: Telegraph_Flare is not part of a scenario with an Aggramar bosscontroller") end
		local aggmobile=bosscontroller.aggramar
		ember.ai.fixatemobile=aggmobile		
		ember.currentfacing=math.atan2(aggmobile.y-ember.y,aggmobile.x-ember.x)
		ember.expirytime=ember.environment.localtime+3*60
		
		local groupdancemodule=bosscontroller.groupdancemodule		
		if(groupdancemodule)then
			if(groupdancemodule.embers)then
				tinsert(groupdancemodule.embers,ember)
			end
		end
		
		local yard=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(1)
		
		local startangle -- =math.random()*math.pi*2		
		local targetmob
		if(self.wakeofflame_at_player)then
			targetmob=bosscontroller.scenario.raid.rdps[1]
		else
			targetmob=bosscontroller.scenario.raid.rdps[math.random(1,#bosscontroller.scenario.raid.rdps)]
		end
		startangle=math.atan2(targetmob.y-damagetelegraph.y,targetmob.x-damagetelegraph.x)
		
		--print("Wake of Flame...")
		local wakecount=5
		for i=1,wakecount do
			local wake=TRAININGGROUNDS_AGGRAMAR_Mobile_WakeOfFlame.new()
			wake:Setup(self.environment)
			local angle=startangle+i*(math.pi*2/wakecount)
			wake.x=damagetelegraph.x+math.cos(angle)*yard*7
			wake.y=damagetelegraph.y+math.sin(angle)*yard*7
			--wake.x=0+math.cos(angle)*yard*10
			--wake.y=0+math.sin(angle)*yard*10
			wake:SetMovementAngle(angle)
		end
		
	end
	
end