

do

	local super=TRAININGGROUNDS_BossController
	TRAININGGROUNDS_AGGRAMAR_BossController_Aggramar = TRAININGGROUNDS_inheritsFrom(super)
	local class=TRAININGGROUNDS_AGGRAMAR_BossController_Aggramar

	function class:CreateBossDetails(xoffset,yoffset,startxoffset,startyoffset)
		if(not xoffset)then xoffset=0 end
		if(not yoffset)then yoffset=0 end
		if(not startxoffset)then startxoffset=0 end
		if(not startyoffset)then startyoffset=300 end	
		
		self.xoffset=xoffset
		self.yoffset=yoffset
		
		local aggramar=TRAININGGROUNDS_AGGRAMAR_Mobile_Aggramar.new()		
		aggramar:Setup(self.environment.game.environment_gameplay)	
		aggramar.x=startxoffset;aggramar.y=startyoffset
		--TODO: this should be part of boss:setup
		aggramar.bosscontroller=self
		
		tinsert(self.boss,aggramar)
		self.aggramar=aggramar	
		
		-- history: whichever card was drawn "first"
		self.ravenousblaze_playerhistory=(math.random()>0.5)
		-- shuffle: which of the two cards in the deck we start with
			-- (i.e. if shuffle==2, we're pretending we've already drawn the 1st card)
			-- (if shuffle==1, we ignore/overwrite playerhistory)
		self.ravenousblaze_shuffle=math.random(1,2)
		
		self:ResetFlareTargets()
	end

	function class:ReturnNewGroupDanceModule()
		local groupdancemodule=TRAININGGROUNDS_AGGRAMAR_GroupDanceModule_Aggramar.new()
		return groupdancemodule
	end
	--TODO: when boss is removed, remove groupdancemodule


	function class:CreateAndReturnBossOverrideButtons()
		local buttons={}
		-- local button=self:CreateQuickBossOverrideFromSpell(self.aggramar,self.aggramar.combat.taeshalachtechnique)
		-- button.x=0;button.y=0
		-- tinsert(buttons,button)	
					
		return buttons
	end

	function class:Step(elapsed)
		TRAININGGROUNDS_BossController.Step(self,elapsed)
		
		--print(self.scenario.currentplayer)
	end
	
	
	function class:GetRavenousBlazeTargetCombats()	
		--TODO: we are still cheating here and pretending the entire raid is ranged
			-- (also only keeping track of playerhistory, not any other players)
		local targetcombats={}
		local chooseplayer		
		self.ravenousblaze_shuffle=self.ravenousblaze_shuffle+1
		if(self.ravenousblaze_shuffle>2)then self.ravenousblaze_shuffle=1 end
		if(self.ravenousblaze_shuffle==1)then
			chooseplayer=(math.random()>0.5)
			self.ravenousblaze_playerhistory=chooseplayer
		else
			chooseplayer=(not self.ravenousblaze_playerhistory)
		end
				
		--chooseplayer=true --debug
		
		local nonplayertargetcount
		if(chooseplayer)then
			--TODO: cheating here too, pretending we know raid contains exactly 11 rDPS including the player
				-- (also, the 50-50 odds thing strictly applies to only 10 rDPS, not 11)
			tinsert(targetcombats,self.scenario.raid.rdps[1].combat)
			nonplayertargetcount=4
		else
			nonplayertargetcount=5
		end
		
		local nonplayerrdpscopy={}
		for i=2,11 do
			tinsert(nonplayerrdpscopy,self.raid.rdps[i])
		end
		
		for i=1,nonplayertargetcount do
			local j=math.random(1,#nonplayerrdpscopy)
			tinsert(targetcombats,nonplayerrdpscopy[j].combat)
			tremove(nonplayerrdpscopy,j)
		end
		
		return targetcombats
	end
	
	function class:ResetFlareTargets()
		self.flarecounter=0
		self.flare_playerchosen=false
		self.flaresizes={12.5,13.75,15}
		self.wakeofflame_at_player_index=math.random(1,3)
	end
	
	function class:GetNextFlareTargetCombatAndRadius()
		local targetcombat,radius
		self.flarecounter=self.flarecounter+1
		local wmcontroller=self.scenario.wmcontroller
		--TODO: scenario.player
		local player=self.scenario.raid.rdps[1]
		
		-- draw a new radius from the deck...
		local r=math.random(1,#self.flaresizes)
		radius=self.flaresizes[r]
		tremove(self.flaresizes,r)
						
		-- try to force "worst case scenario" for the player...
		-- if player is far away on the 1st flare, they were late to run in
		-- otherwise, wait for 3rd flare, where player might run out early
		local chooseplayer=false
		--print("Flarecounter:",self.flarecounter)
		if(self.flarecounter==1)then
			local red=wmcontroller:GetWorldMarkerPosition(4)
			local distx=player.x-red.x
			local disty=player.y-red.y
			local distsqr=distx*distx+disty*disty			
			---- TODO: probably better to use 7 yards
				-- but for now, use 15 yards so we don't have to worry as much about splashing AI
			--local mindist=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(7)
			local mindist=TRAININGGROUNDS_Mobile_ConvertYardsToTGUnits(15)
			if(distsqr>mindist*mindist)then
				--print("Dist:",math.sqrt(distsqr)*7/200.0,"yards")
				chooseplayer=true
			end
		elseif(self.flarecounter==3 and self.flare_playerchosen==false)then
			chooseplayer=true
		end				
		if(chooseplayer)then 
			--print("chooseplayer!")
			self.flare_playerchosen=true 
			targetcombat=player.combat
		else
			-- TODO: we're kinda cheating here; the same AI could (incorrectly) get chosen for two flares
			local r=math.random(2,#self.scenario.raid.rdps)
			targetcombat=self.scenario.raid.rdps[r].combat
		end
		local wakeofflame_at_player=false
		if(self.wakeofflame_at_player_index==self.flarecounter)then
			wakeofflame_at_player=true
		end
		
		return targetcombat,radius,wakeofflame_at_player
	end

end	