--[[
File Author: Erik Vonderscheer
File Revision: ee66f37
File Date: 2017-05-19T4:37:02Z
]]--
local debug = false
--[===[@debug@
debug = true
--@end-debug@]===]

local L =  LibStub("AceLocale-3.0"):NewLocale("TradeFilter3", "enUS", true)
if L then
L[" Blacklist Filtered"] = true
L[" Messages Filtered"] = true
L[" Repeats Blocked"] = true
L["#RPT"] = "Repeats"
L["#RPTD"] = "Number of repeats before filtered."
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset filtered count.]=] ] = true
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset repeat count.]=] ] = true
L["0 Messages Filtered"] = true
L["0 Repeats Blocked"] = true
L["BASE Filters"] = true
L["BCF"] = "Base Channel Filters"
L["BCFD"] = "Base Channel Filters are only applied to the General/LFG/Special Channel, no other channels are affected by this list."
L["BG"] = "Battleground Filters"
L["BG Filters"] = true
L["BGC"] = "Filter Battleground"
L["BGCD"] = "Select this to apply filter to Battleground."
L["BGD"] = "Battleground Filters are only applied to the Battleground, no other channels are affected by this list."
L["BLBYPASS"] = "Black List Bypass"
L["BLBYPASSD"] = "Allow strings that match a pattern in your whitelist to bypass the Black List filter."
L["BLE"] = "Enable Blacklist Checking"
L["bLists"] = "BlackList"
L["BTF"] = "Trade Channel Filters"
L["BTFD"] = "Trade Channel Filters are only applied to the Trade Channel, no other channels are affected by this list."
L["bwLists"] = "Black/White List"
L["CEPM"] = "Current Exempt Party Members"
L["CFM"] = "Checking for Match:"
L["channelGroup"] = "Channel Selection"
L["Current Exempt List"] = true
L["Debug"] = true
L["DebugChecking"] = "Strip 'Checking For Match'"
L["DebugCheckingD"] = "Strip 'Checking For Match' from debug output."
L["DebugDesc"] = "Enable Debugging output to DEBUG frame"
L["debugFrame"] = "DEBUG"
L["DEBUGGING"] = "Debugging Output Options"
L["DISABLED"] = "|cffff8080Disabled|r"
L["DUEL_WINNER_KNOCKOUT"] = "%1$s has defeated %2$s in a duel"
L["DUEL_WINNER_RETREAT"] = "%2$s has fled from %1$s in a duel"
L["EBL"] = "Edit Black List"
L["EditFilter"] = "Edit Filter Expressions"
L["EditFilterD"] = "Edit Filter Expressions to be matched in Trade or Base Channel."
L["EditFilterGD"] = "Edit Filter Expressions to be matched in Trade or Base Channel Group."
L["EditFilterGroup"] = "Edit Custom Filters"
L["EditFilterUsage"] = "Case Insensitive LFG = [lL][fF][gG]"
L["EditLists"] = "Edit Black/White List"
L["ENABLED"] = "|cff00ff00Enabled|r"
L["EWL"] = "Edit White List"
L["Exempt Friend List"] = true
L["Exempt List"] = true
L["Exempt Party Members"] = true
L["FADD"] = "added to the TradeFilter exempt list."
L["FDS"] = "Filter Duel Spam"
L["FDSD"] = "Filter Duel Spam"
L["FREM"] = "removed from TradeFilter exempt list."
L["Friends"] = true
L["FSELF"] = "Filter Self"
L["FSELFD"] = "Allow yourself to be filtered? This can be used to test filters. TRUE = Player is subject to filtering, FALSE =  Player is not subject to filtering and passes through unchecked."
L["GAC"] = "Filter Guild AddOns Channel"
L["GACD"] = "Filter AddOns that make use of the hidden AddOns Guild channel. This Filter abides by the BASE Channel Filter list."
L["GC"] = "Filter General Channel"
L["GCD"] = "Select this to apply filter to General Channel."
L["General"] = true
L["If enabled party members will be exempt from filtration."] = true
L["If enabled your friends list will be exempt from filtration."] = true
L["INPUSAGE"] = "Input one entry per line."
L["LFG"] = true
L["LFGC"] = "Filter LFG Channel"
L["LFGCD"] = "Select this to apply filter to LFG Channel."
L["listsGD"] = "Add words or patterns to match against for a Black/White list."
L["listsGroup"] = "Black/White Lists"
L["LOADED"] = "|cff00ff00Loaded!|r"
L["MATCHED"] = "|cff00ff00Matched:|r"
L["Messages filtered are saved per session only"] = true
L["MIPM"] = "Found an unknown party member; rescanning..."
L["NJAOF"] = "Not just any old filter!"
L["NOMATCH"] = "|cff00ff00NO Match Found - Redirected|r"
L["Notes"] = "A Simple World of Warcraft Spam Filter!"
L["OUTPUT"] = "Output Options"
L["PADD"] = "added to the temporary TradeFilter exempt list."
L["Party Members"] = true
L["Profiles"] = true
L["RBF"] = "Reset Base Filters"
L["RBLS"] = "Reset Black List"
L["RBWL"] = "Reset Black/White List"
L["Redir"] = "Redirect Spam"
L["RedirBL"] = "Redirect Blacklist matches to 'SPAM' ChatFrame."
L["RedirDesc"] = "Redirect Channel Spam to SPAM frame"
L["redirectFrame"] = "SPAM"
L["REPEAT"] = "Repeat Filtration"
L["repeatFrame"] = "REPEAT"
L["RLS"] = "Reset Lists"
L["RMVRT1"] = "Removed"
L["RMVRT2"] = "from TradeFilter3 repeat database."
L["RPTA"] = "Repeat Advanced"
L["RPTAD"] = "Repeat Advanced settings and table information"
L["RPTBLOCKED"] = "Blocked"
L["RPTBLOCKEDD"] = "Total Repeats Blocked"
L["RPTBYPASS"] = "Repeat Bypass"
L["RPTBYPASSD"] = "Allow strings that match a pattern in your whitelist to bypass the repeat filter."
L["RPTENABLE"] = "Enable Repeat Check"
L["RPTENABLED"] = "Enable or Disable Repeat Check"
L["RPTRESET"] = "Reset"
L["RPTRESETD"] = "Reset Repeat Count"
L["RPTRS"] = "Recycle Size"
L["RPTRSD"] = "Run repeat recycle function when repeat table has reached X size."
L["RPTRT"] = "Recycle Timer"
L["RPTRTD"] = "Run repeat recycle function at X seconds."
L["RPTRTSU"] = "The RecycleTables function will run only when both the Recyle Time and Recycle Size conditions have been met."
L["RPTTC"] = "People in Repeat DB"
L["RPTTS"] = "Repeat Table Size"
L["RPTTT"] = "Trim Table"
L["RPTTTD"] = "Trim the repeat table data if the Recyle Time and Recycle Size conditions have been met."
L["RPTU"] = "If string is repeated X times in Y seconds then filter."
L["RSF"] = "Reset Special Filters"
L["RTF"] = "Reset Trade Filter"
L["RUI"] = "Reload UI"
L["RUID"] = "Reload the User Interface for some changes to take effect."
L["RWLS"] = "Reset White List"
L["Say/Yell"] = true
L["SAYC"] = "Filter SAY Channel"
L["SAYCD"] = "Select this to apply filter to SAY Channel."
L["SECPSD"] = "seconds passed."
L["SPCS"] = "Special Channel Selection"
L["SPCST"] = "Special Channels"
L["SPCSTD"] = "Special Channels are intended for AddOns that use channels for chat redirections that you still want filtered."
L["TC"] = "Filter Trade Channel"
L["TCD"] = "Select this to apply filter to Trade Channel"
L["TFFR"] = "Importing your friends for TradeFilter3 exemption list..."
L["TFFRC"] = "Friends list import completed"
L["TFR"] = "TradeFilter3"
L["Trade"] = true
L["TRADE Filters"] = true
L["TRPT"] = "Time"
L["TRPTD"] = "Time required between repeats in seconds."
L["TurnOn"] = "Turn On"
L["TurnOnDesc"] = "Enable Trade Channel Filter."
L["Wiping party exempt list"] = true
L["WLE"] = "Enable Whitelist Checking"
L["wLists"] = "WhiteList"
L["YELLC"] = "Filter YELL Channel"
L["YELLCD"] = "Select this to apply filter to YELL Channel."

if GetLocale() == "enUS" then return end
end

local L =  LibStub("AceLocale-3.0"):NewLocale("TradeFilter3", "deDE")
if L then
L[" Blacklist Filtered"] = "Schwarze Liste gefiltert"
L[" Messages Filtered"] = "Nachrichten gefiltert"
L[" Repeats Blocked"] = " Wiederholungen blockiert"
L["#RPT"] = "Wiederholungen"
L["#RPTD"] = "Anzahl der Wiederholungen, bevor gefiltert wird."
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset filtered count.]=] ] = [=[|cffeda55fRechtsklick|r öffnet die Optionen.
|cffeda55fLinksklick|r setzt den Filterzähler zurück.]=]
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset repeat count.]=] ] = [=[|cffeda55fRechtsklicken|r, um das Konfigurationsmenü zu öffnen.
|cffeda55fLinksklicken|r, um den Wiederholungszähler zurückzusetzen.]=]
L["0 Messages Filtered"] = "0 Nachrichten gefiltert"
L["0 Repeats Blocked"] = "0 Wiederholungen blockierte"
L["BASE Filters"] = "Grundfilter"
L["BCF"] = "Grundlegende Channelfilter"
L["BCFD"] = "Grundfilter werden auf die Allgemein-, SucheNachGruppe-, Spezialchannel usw. angewandt. Der Handelschannel ist nicht von dieser Liste betroffen."
L["BG"] = "Schlachtfeldchannel-Filter"
L["BG Filters"] = "Schlachtfeldchannelfilter"
L["BGC"] = "Schlachtfeldchannel filtern"
L["BGCD"] = "Aktivere diese Funktion, um den Filter auf den Schlachtfeldchannel anzuwenden."
L["BGD"] = "Schlachtfeldchannel-Filter werden nur auf den Schlachtfeldchannel angewandt, keine anderen Channel sind von dieser Liste betroffen."
L["BLBYPASS"] = "Schwarze Liste umgehen"
L["BLBYPASSD"] = "Erlaube Zeichenketten, die auf der Weißen Liste vorkommen, die Schwarze Liste zu umgehen."
L["BLE"] = "Schwarze Liste prüfen"
L["bLists"] = "Schwarze Liste"
L["BTF"] = "Handelschannelfilter"
L["BTFD"] = "Handelschannel-Filter werden nur auf den Handelschannel angewandt, keine anderen Channel sind von dieser Liste betroffen."
L["bwLists"] = "Schwarze/Weiße Liste"
L["CEPM"] = "Derzeit bevorrechtigte Gruppenmitglieder"
L["CFM"] = "Suche Übereinstimmung:"
L["channelGroup"] = "Channelauswahl"
L["Current Exempt List"] = "Aktuelle Bevorrechtigtenliste"
L["Debug"] = "Debuginfos anzeigen"
L["DebugChecking"] = "Verstecke die 'Suche Übereinstimmung'-Meldungen"
L["DebugCheckingD"] = "Versteckt die 'Suche Übereinstimmung'-Meldungen in der Debug-Ausgabe."
L["DebugDesc"] = "Zeigt die Debug-Ausgabe im Channel DEBUG an"
L["debugFrame"] = "DEBUG"
L["DEBUGGING"] = "Einstellungen für Debug-Ausgabe"
L["DISABLED"] = "|cffff8080Deaktiviert|r"
L["DUEL_WINNER_KNOCKOUT"] = "%1$s hat %2$s in einem Duell besiegt"
L["DUEL_WINNER_RETREAT"] = "%2$s ist vor %1$s aus einem Duell geflüchtet"
L["EBL"] = "Schwarze Liste bearbeiten"
L["EditFilter"] = "Filter bearbeiten"
L["EditFilterD"] = "Filter bearbeiten, die auf Handel- oder sonstige Channel angewandt werden sollen."
L["EditFilterGD"] = "Filter bearbeiten, die auf Handel- oder sonstige Channel angewandt werden sollen."
L["EditFilterGroup"] = "Filter bearbeiten"
L["EditFilterUsage"] = "LFG, unabhängig von Groß- und Kleinschreibung, identisch mit [lL][fF][gG]"
L["EditLists"] = "Schwarze/Weiße Liste bearbeiten"
L["ENABLED"] = "|cff00ff00Aktiviert|r"
L["EWL"] = "Weiße Liste bearbeiten"
L["Exempt Friend List"] = "Liste bevorrechtigter Freunde"
L["Exempt List"] = "Bevorrechtigtenliste"
L["Exempt Party Members"] = "Bevorrechtigte Gruppenmitglieder"
L["FADD"] = "zur TradeFilter-Bevorrechtigtenliste hinzugefügt."
L["FDS"] = "Duellspam filtern"
L["FDSD"] = "Duellspam filtern"
L["FREM"] = "von der TradeFilter-Bevorrechtigtenliste entfernt."
L["Friends"] = "Freunde"
L["FSELF"] = "Dich selbst filtern"
L["FSELFD"] = "Dich selbst filtern? Nutze diese Funktion, um Filter zu testen. Ist die Funktion eingeschaltet, werden die Filter auch auf dich angewandt. Ist sie ausgeschaltet, werden deine Sätze nicht gefiltert."
L["GAC"] = "Gilden-Add-on-Channel filtern [Experimentell]"
L["GACD"] = "Aktiviere diese Funktion, um den Filter auf den versteckten gildeninternen Add-on-Channel anzuwenden. [Experimentell]"
L["GC"] = "Allgemein-Channel filtern"
L["GCD"] = "Aktivere diese Funktion, um den Filter auf den Allgemein-Channel anzuwenden."
L["General"] = "Allgemein"
L["If enabled party members will be exempt from filtration."] = "Aktivere diese Funktion, um Gruppenmitglieder nicht zu filtern."
L["If enabled your friends list will be exempt from filtration."] = "Aktivere diese Funktion, um Freunde nicht zu filtern."
L["INPUSAGE"] = "Ein Eintrag pro Zeile."
L["LFG"] = "SucheNachGruppe"
L["LFGC"] = "SucheNachGruppe-Channel filtern"
L["LFGCD"] = "Aktivere diese Funktion, um den Filter auf den SucheNachGruppe-Channel anzuwenden."
L["listsGD"] = "Füge Worte und Suchmuster zur Schwarzen und Weißen Liste hinzu."
L["listsGroup"] = "Schwarze/Weiße Liste"
L["LOADED"] = "|cff00ff00Geladen!|r"
L["MATCHED"] = "|cff00ff00Treffer:|r"
L["Messages filtered are saved per session only"] = "Gefilterte Nachrichten werden nur während dieser Session gespeichert"
L["MIPM"] = "Unbekanntes Gruppenmitglied gefunden; scanne erneut..."
L["NJAOF"] = "Nicht einfach nur ein Filter!"
L["NOMATCH"] = "|cff00ff00Keine Übereinstimmung gefunden - umgeleitet|r"
L["Notes"] = "Nicht einfach nur ein Filter!"
L["OUTPUT"] = "Ausgabeoptionen"
L["PADD"] = "zur temporären TradeFilter-Bevorrechtigtenliste hinzugefügt."
L["Party Members"] = "Gruppenmitglieder"
L["Profiles"] = "Profile"
L["RBF"] = "Grundfilter zurücksetzen"
L["RBLS"] = "Schwarze Liste zurücksetzen"
L["RBWL"] = "Schwarze/Weiße Liste zurücksetzen"
L["Redir"] = "Spam umleiten"
L["RedirBL"] = "Zeige Treffer auf der Schwarzen Liste im Chatfenster 'SPAM'."
L["RedirDesc"] = "Zeigt gefilterten Spam im Channel SPAM an"
L["redirectFrame"] = "SPAM"
L["REPEAT"] = "Wiederholungsfilter"
L["repeatFrame"] = "REPEAT"
L["RLS"] = "Listen zurücksetzen"
L["RMVRT1"] = "Habe"
L["RMVRT2"] = "aus der TradeFilter3-Wiederholungsdatanbank entfernt."
L["RPTA"] = "Erweitertes Wiederholen"
L["RPTAD"] = "Einstellungen und Tabelleninformationen zum erweiterten Wiederholen"
L["RPTBLOCKED"] = "Blockiert"
L["RPTBLOCKEDD"] = "Insgesamt blockierte Wiederholungen"
L["RPTBYPASS"] = "Wiederholungsfilter umgehen"
L["RPTBYPASSD"] = "Erlaube Zeichenketten, die auf der Weißen Liste vorkommen, den Wiederholungsfilter zu umgehen."
L["RPTENABLE"] = "Wiederholungsprüfung einschalten"
L["RPTENABLED"] = "Wiederholungsprüfung ein- oder ausschalten"
L["RPTRESET"] = "Zurücksetzen"
L["RPTRESETD"] = "Wiederholungszähler zurücksetzen"
L["RPTRS"] = "Wiederverwertungsgröße"
L["RPTRSD"] = "Führe die Wiederverwertungsfunktion für Wiederholungen aus, sobald die Tabelle mit Wiedeholungen X Einträge hat."
L["RPTRT"] = "Wiederverwertungstimer"
L["RPTRTD"] = "Wiederverwertungsfunktion für Wiederholungen nach X Sekunden ausführen"
L["RPTRTSU"] = "Die Funktion RecycleTables wird nur starten, wenn sowohl Wiederverwertungstimer als auch Wiederverwertungsgröße erreicht wurden."
L["RPTTC"] = "Spieler in Wiederholungsdatenbank"
L["RPTTS"] = "Größe der Wiederholungstabelle"
L["RPTTT"] = "Tabelle kürzen"
L["RPTTTD"] = "Wiederholungstabelle kürzen, wenn Wiederverwertungstimer und -größe erreicht wurden."
L["RPTU"] = "Filtere Zeichenketten, die x-mal innerhalb von y Sekunden im Chat erscheinen."
L["RSF"] = "Spezialfilter zurücksetzen"
L["RTF"] = "Handelsfilter zurücksetzen"
L["RUI"] = "Interface neu laden"
L["RUID"] = "Lädt das Interface neu, um einige Änderungen zu aktivieren."
L["RWLS"] = "Weiße Liste zurücksetzen"
L["Say/Yell"] = "Sagen/Schreien"
L["SAYC"] = "Sagen-Channel filtern"
L["SAYCD"] = "Aktivere diese Funktion, um den Filter auf den Sagen-Channel anzuwenden."
L["SECPSD"] = "Sekunden vergangen."
L["SPCS"] = "Spezialchannel-Auswahl"
L["SPCST"] = "Spezialchannels"
L["SPCSTD"] = "Spezialchannels gehören zu Add-ons, die Chatnachrichten umleiten, die du gefiltert haben möchtest."
L["TC"] = "Handelschannel filtern"
L["TCD"] = "Aktivere diese Funktion, um den Filter auf den Handelschannel anzuwenden."
L["TFFR"] = "Importiere deine Freundesliste in die TradeFilter3-Bevorrechtigtenliste..."
L["TFFRC"] = "Freundesliste vollständig importiert"
L["TFR"] = "TradeFilter3"
L["Trade"] = "Handel"
L["TRADE Filters"] = "Handelschannelfilter"
L["TRPT"] = "Zeit"
L["TRPTD"] = "Zulässige Zeit zwischen Wiederholungen in Sekunden."
L["TurnOn"] = "Aktivieren"
L["TurnOnDesc"] = "Aktiviert den Handelschannel-Filter."
L["Wiping party exempt list"] = "Leere die Liste alle TradeFilter-Bevorrechtigten aus deinen Gruppen"
L["WLE"] = "Weiße Liste prüfen"
L["wLists"] = "Weiße Liste"
L["YELLC"] = "Schreien-Channel filtern"
L["YELLCD"] = "Aktivere diese Funktion, um den Filter auf den Schreien-Channel anzuwenden."

if GetLocale() == "deDE" then return end
end

local L =  LibStub("AceLocale-3.0"):NewLocale("TradeFilter3", "zhCN")
if L then
--[[Translation missing --]]
L[" Blacklist Filtered"] = " Blacklist Filtered"
--[[Translation missing --]]
L[" Messages Filtered"] = " Messages Filtered"
--[[Translation missing --]]
L[" Repeats Blocked"] = " Repeats Blocked"
L["#RPT"] = "重复次数"
L["#RPTD"] = "需要过滤的重复次数"
--[[Translation missing --]]
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset filtered count.]=] ] = [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset filtered count.]=]
--[[Translation missing --]]
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset repeat count.]=] ] = [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset repeat count.]=]
--[[Translation missing --]]
L["0 Messages Filtered"] = "0 Messages Filtered"
--[[Translation missing --]]
L["0 Repeats Blocked"] = "0 Repeats Blocked"
--[[Translation missing --]]
L["BASE Filters"] = "BASE Filters"
L["BCF"] = "基础频道过滤器"
L["BCFD"] = "基础频道过滤器仅能过滤综合/组队/特定频道, 其他频道不会被这个列表所影响。"
--[[Translation missing --]]
L["BG"] = "Battleground Filters"
--[[Translation missing --]]
L["BG Filters"] = "BG Filters"
--[[Translation missing --]]
L["BGC"] = "Filter Battleground"
--[[Translation missing --]]
L["BGCD"] = "Select this to apply filter to Battleground."
--[[Translation missing --]]
L["BGD"] = "Battleground Filters are only applied to the Battleground, no other channels are affected by this list."
--[[Translation missing --]]
L["BLBYPASS"] = "Black List Bypass"
--[[Translation missing --]]
L["BLBYPASSD"] = "Allow strings that match a pattern in your whitelist to bypass the Black List filter."
L["BLE"] = "启用黑名单检测"
L["bLists"] = "黑名单"
L["BTF"] = "基础交易频道过滤器"
L["BTFD"] = "交易频道过滤器仅过滤交易频道的内容, 其他频道不会受到这个列表的影响。"
L["bwLists"] = "黑/白名单"
--[[Translation missing --]]
L["CEPM"] = "Current Exempt Party Members"
L["CFM"] = "检测匹配:"
L["channelGroup"] = "频道选择"
--[[Translation missing --]]
L["Current Exempt List"] = "Current Exempt List"
L["Debug"] = "除错模式 [需要新建一个聊天框名为 'DEBUG']"
L["DebugChecking"] = "除掉 '检测匹配'"
L["DebugCheckingD"] = "从除错输出中除掉 '检测匹配'"
L["DebugDesc"] = "启用除错模式并输出到 <DEBUG> 频道 [需要新建聊天框名为 'DEBUG']"
L["debugFrame"] = "DEBUG"
L["DEBUGGING"] = "除错输出选项"
L["DISABLED"] = "|cffff8080禁用|r"
--[[Translation missing --]]
L["DUEL_WINNER_KNOCKOUT"] = "%1$s has defeated %2$s in a duel"
--[[Translation missing --]]
L["DUEL_WINNER_RETREAT"] = "%2$s has fled from %1$s in a duel"
L["EBL"] = "编辑黑名单"
L["EditFilter"] = "编辑过滤符号"
L["EditFilterD"] = "编辑在交易或基础频道中要匹配的过滤符号。"
L["EditFilterGD"] = "编辑在交易或基础频道分组中要匹配的过滤符号。"
L["EditFilterGroup"] = "编辑自定义过滤器"
--[[Translation missing --]]
L["EditFilterUsage"] = "Case Insensitive LFG = [lL][fF][gG]"
L["EditLists"] = "编辑黑/白名单"
L["ENABLED"] = "|cff00ff00启用|r"
L["EWL"] = "编辑白名单"
--[[Translation missing --]]
L["Exempt Friend List"] = "Exempt Friend List"
--[[Translation missing --]]
L["Exempt List"] = "Exempt List"
--[[Translation missing --]]
L["Exempt Party Members"] = "Exempt Party Members"
L["FADD"] = "增加到 TradeFilter 豁免列表。"
L["FDS"] = "过滤决斗信息"
--[[Translation missing --]]
L["FDSD"] = "Filter Duel Spam"
L["FREM"] = "从 TradeFilter 豁免列表中移除。"
--[[Translation missing --]]
L["Friends"] = "Friends"
L["FSELF"] = "过滤自身"
L["FSELFD"] = "允许过滤自身? 这个可以用来测试过滤器. TRUE = 玩家自身将被过滤, FALSE = 玩家自身将不被过滤."
L["GAC"] = "过滤<公会插件>频道 [试验性质]"
--[[Translation missing --]]
L["GACD"] = "Filter AddOns that make use of the hidden AddOns Guild channel. This Filter abides by the BASE Channel Filter list."
L["GC"] = "过滤 <综合> 频道"
L["GCD"] = "选中以过滤 <综合> 频道"
L["General"] = "综合"
--[[Translation missing --]]
L["If enabled party members will be exempt from filtration."] = "If enabled party members will be exempt from filtration."
--[[Translation missing --]]
L["If enabled your friends list will be exempt from filtration."] = "If enabled your friends list will be exempt from filtration."
L["INPUSAGE"] = "每一行输入一个。"
L["LFG"] = true
L["LFGC"] = "过滤 <组队> 频道"
L["LFGCD"] = "选中以过滤 <组队> 频道"
L["listsGD"] = "增加需要过滤的词语或词组到黑/白名单。"
L["listsGroup"] = "黑/白名单列表"
L["LOADED"] = "|cff00ff00已加载!|r"
L["MATCHED"] = "|cff00ff00匹配:|r"
--[[Translation missing --]]
L["Messages filtered are saved per session only"] = "Messages filtered are saved per session only"
--[[Translation missing --]]
L["MIPM"] = "Found an unknown party member; rescanning..."
--[[Translation missing --]]
L["NJAOF"] = "Not just any old filter!"
L["NOMATCH"] = "|cff00ff00没有找到匹配 - 已重定向|r"
L["Notes"] = "过滤讨厌的交易频道垃圾信息."
L["OUTPUT"] = "输出选项"
--[[Translation missing --]]
L["PADD"] = "added to the temporary TradeFilter exempt list."
--[[Translation missing --]]
L["Party Members"] = "Party Members"
L["Profiles"] = "配置文件"
L["RBF"] = "重置基础过滤器"
L["RBLS"] = "重置黑名单"
L["RBWL"] = "重置黑/白名单"
L["Redir"] = "重定向垃圾信息 [需要新建聊天框名为 'SPAM']"
L["RedirBL"] = "重定向黑名单匹配的内容到 'SPAM'  聊天框。"
L["RedirDesc"] = "重定向交易频道垃圾信息到垃圾信息频道 [需要新建聊天框名为 'SPAM']"
L["redirectFrame"] = "SPAM"
L["REPEAT"] = "重复过滤"
L["repeatFrame"] = "REPEAT"
L["RLS"] = "重置列表"
L["RMVRT1"] = "移除"
L["RMVRT2"] = "从 TradeFilter3 重复内容数据库。"
--[[Translation missing --]]
L["RPTA"] = "Repeat Advanced"
--[[Translation missing --]]
L["RPTAD"] = "Repeat Advanced settings and table information"
L["RPTBLOCKED"] = "阻止"
L["RPTBLOCKEDD"] = "重复内容阻止总数"
L["RPTBYPASS"] = "重复内容通过"
L["RPTBYPASSD"] = "允许在白名单中匹配的词组可以通过重复内容过滤器。"
L["RPTENABLE"] = "启用重复内容检测"
L["RPTENABLED"] = "启用或禁用重复内容检测"
L["RPTRESET"] = "重置"
L["RPTRESETD"] = "重置重复内容计数"
--[[Translation missing --]]
L["RPTRS"] = "Recycle Size"
--[[Translation missing --]]
L["RPTRSD"] = "Run repeat recycle function when repeat table has reached X size."
--[[Translation missing --]]
L["RPTRT"] = "Recycle Timer"
--[[Translation missing --]]
L["RPTRTD"] = "Run repeat recycle function at X seconds."
--[[Translation missing --]]
L["RPTRTSU"] = "The RecycleTables function will run only when both the Recyle Time and Recycle Size conditions have been met."
--[[Translation missing --]]
L["RPTTC"] = "People in Repeat DB"
--[[Translation missing --]]
L["RPTTS"] = "Repeat Table Size"
--[[Translation missing --]]
L["RPTTT"] = "Trim Table"
--[[Translation missing --]]
L["RPTTTD"] = "Trim the repeat table data if the Recyle Time and Recycle Size conditions have been met."
L["RPTU"] = "如果字符在Y秒内重复X次则过滤。"
L["RSF"] = "重置特殊过滤器"
L["RTF"] = "重置交易过滤器"
L["RUI"] = "重载 UI"
L["RUID"] = "重载 UI 以使一些改动生效。"
L["RWLS"] = "重置白名单"
L["Say/Yell"] = "说/喊"
L["SAYC"] = "过滤 <说> 频道"
L["SAYCD"] = "选中以过滤 <说> 频道"
L["SECPSD"] = "秒。"
L["SPCS"] = "特殊频道选择"
L["SPCST"] = "特殊频道"
--[[Translation missing --]]
L["SPCSTD"] = "Special Channels are intended for AddOns that use channels for chat redirections that you still want filtered."
L["TC"] = "过滤交易频道"
L["TCD"] = "选中以过滤 <交易> 频道"
L["TFFR"] = "TradeFilter 首次加载!正在导入你的好友列表..."
--[[Translation missing --]]
L["TFFRC"] = "Friends list import completed"
L["TFR"] = "TradeFilter3"
L["Trade"] = "交易"
--[[Translation missing --]]
L["TRADE Filters"] = "TRADE Filters"
L["TRPT"] = "次数"
L["TRPTD"] = "在间隔的秒数内允许的重复次数"
L["TurnOn"] = "开启"
L["TurnOnDesc"] = "启用交易频道过滤器"
--[[Translation missing --]]
L["Wiping party exempt list"] = "Wiping party exempt list"
L["WLE"] = "启用白名单检测"
L["wLists"] = "白名单"
L["YELLC"] = "过滤 <大喊> 频道"
L["YELLCD"] = "选中以过滤 <大喊> 频道"

if GetLocale() == "zhCN" then return end
end

local L =  LibStub("AceLocale-3.0"):NewLocale("TradeFilter3", "zhTW")
if L then
L[" Blacklist Filtered"] = "黑名單過濾"
L[" Messages Filtered"] = "訊息過濾"
L[" Repeats Blocked"] = "重複被攔截"
L["#RPT"] = "重複"
L["#RPTD"] = "過濾前重複的次數。"
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset filtered count.]=] ] = [=[|cffeda55f右鍵點擊|r 開啟使用者介面設定。
|cffeda55f左鍵點擊|r 重置過濾統計。]=]
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset repeat count.]=] ] = [=[|cffeda55f右鍵點擊|r 開啟使用者介面設定。
|cffeda55f左鍵點擊|r 重置重複統計。]=]
L["0 Messages Filtered"] = "0 訊息過濾"
L["0 Repeats Blocked"] = "0 重複被攔截"
L["BASE Filters"] = "基本過濾"
L["BCF"] = "過濾 <基本> 頻道"
L["BCFD"] = "基本頻道過濾只作用到綜合/尋求組隊/特別頻道，其它頻道不受名單影響。"
L["BG"] = "過濾 <戰場> 頻道"
L["BG Filters"] = "戰場過濾"
L["BGC"] = "過濾 <戰場> 頻道"
L["BGCD"] = "選中以過濾 <戰場> 頻道。"
L["BGD"] = "戰場過濾只用在戰場，其它頻道不受名單影響。"
L["BLBYPASS"] = "繞過黑名單"
L["BLBYPASSD"] = "允許字串的圖樣與你的白名單吻合避開黑名單過濾。"
L["BLE"] = "啟用黑名單檢查"
L["bLists"] = "黑名單"
L["BTF"] = "過濾 <交易> 頻道"
L["BTFD"] = "交易頻道過濾只會使用在交易頻道，其它頻道不會受到名單影響。"
L["bwLists"] = "黑/白名單"
L["CEPM"] = "目前豁免隊伍成員"
L["CFM"] = "檢查吻合："
L["channelGroup"] = "頻道選擇"
L["Current Exempt List"] = "目前豁免名單"
L["Debug"] = "除錯模式 [需要新建聊天視窗名為 'DEBUG']"
L["DebugChecking"] = "去除'檢查吻合'"
L["DebugCheckingD"] = "去除'檢查吻合'從除錯輸出。"
L["DebugDesc"] = "啟用除錯模式並輸出到 <DEBUG> 頻道 [需要新建聊天視窗名為 'DEBUG']"
L["debugFrame"] = "DEBUG"
L["DEBUGGING"] = "除錯輸出設定"
L["DISABLED"] = "|cffff8080禁用|r"
L["DUEL_WINNER_KNOCKOUT"] = "在決鬥中%1$s已經被%2$s擊殺"
L["DUEL_WINNER_RETREAT"] = "在決鬥中%2$s已經從%1$s逃跑"
L["EBL"] = "編輯黑名單"
L["EditFilter"] = "編輯過濾詞彙"
L["EditFilterD"] = "編輯交易或基本頻道相吻合的過濾詞彙。"
L["EditFilterGD"] = "編輯交易或基本頻道群組相吻合的過濾詞彙。"
L["EditFilterGroup"] = "編輯自定義過濾"
L["EditFilterUsage"] = "尋求組隊區分大小寫 = [lL][fF][gG]"
L["EditLists"] = "編輯黑/白名單"
L["ENABLED"] = "|cff00ff00啟用|r"
L["EWL"] = "編輯白名單"
L["Exempt Friend List"] = "豁免朋友名單"
L["Exempt List"] = "豁免名單"
L["Exempt Party Members"] = "豁免隊伍成員"
L["FADD"] = "新增到交易過濾豁免名單。"
L["FDS"] = "過濾 <決鬥> 垃圾訊息"
L["FDSD"] = "過濾 <決鬥> 垃圾訊息"
L["FREM"] = "從交易過濾豁免名單裡移除。"
L["Friends"] = "朋友"
L["FSELF"] = "過濾自身"
L["FSELFD"] = "允許過濾自身訊息? 這個可以用來測試過濾器。TRUE = 玩家自身將被過濾，FALSE = 玩家自身將不被過濾。"
L["GAC"] = "過濾公會插件頻道[試驗]"
L["GACD"] = "過濾插件使用隱藏公會插件頻道的插件！[試驗]"
L["GC"] = "過濾 <綜合> 頻道"
L["GCD"] = "選中以過濾 <綜合> 頻道。"
L["General"] = "綜合"
L["If enabled party members will be exempt from filtration."] = "如果啟用隊伍成員將會從過濾中豁免。"
L["If enabled your friends list will be exempt from filtration."] = "如果啟用你的朋友名單將會從過濾中豁免。"
L["INPUSAGE"] = "在每行輸入一個項目。"
L["LFG"] = "尋求組隊"
L["LFGC"] = "過濾 <組隊> 頻道"
L["LFGCD"] = "選中以過濾 <組隊> 頻道。"
L["listsGD"] = "新增文字或是圖案與黑/白名單吻合。"
L["listsGroup"] = "黑/白名單"
L["LOADED"] = "|cff00ff00已載入!|r"
L["MATCHED"] = "|cff00ff00吻合：|r"
L["Messages filtered are saved per session only"] = "過濾的訊息只會被儲存一段時間"
L["MIPM"] = "找到未知隊伍成員；重新掃描..."
L["NJAOF"] = "不僅只是個過濾器！"
L["NOMATCH"] = "|cff00ff00沒有發現吻合 - 已重新導向|r"
L["Notes"] = "過濾討厭的交易頻道垃圾訊息。"
L["OUTPUT"] = "輸出選項"
L["PADD"] = "新增到臨時交易過濾豁免名單。"
L["Party Members"] = "隊伍成員"
L["Profiles"] = "設定檔"
L["RBF"] = "重置基本過濾"
L["RBLS"] = "重置黑名單"
L["RBWL"] = "重置黑/白名單"
L["Redir"] = "重新導向垃圾訊息 [需要新建聊天視窗名為 'SPAM']"
L["RedirBL"] = "重新導向黑名單和'SPAM'聊天框吻合。"
L["RedirDesc"] = "重新導向交易頻道垃圾訊息到 <SPAM> 頻道 [需要新建聊天視窗名為 'SPAM']"
L["redirectFrame"] = "SPAM"
L["REPEAT"] = "重複過濾"
L["repeatFrame"] = "REPEAT"
L["RLS"] = "重置名單"
L["RMVRT1"] = "已移除"
L["RMVRT2"] = "從TradeFilter3重複資料庫。"
L["RPTA"] = "重複自訂"
L["RPTAD"] = "重複自訂設定和表訊息。"
L["RPTBLOCKED"] = "攔截"
L["RPTBLOCKEDD"] = "總共重複攔截"
L["RPTBYPASS"] = "重複繞過"
L["RPTBYPASSD"] = "允許字串的圖案與白名單吻合繞過重複過濾。"
L["RPTENABLE"] = "啟用重複檢查"
L["RPTENABLED"] = "啟用或停用重複檢查。"
L["RPTRESET"] = "重置"
L["RPTRESETD"] = "重置重複計數"
L["RPTRS"] = "回收大小"
L["RPTRSD"] = "運作重複回收程式當重複表已經達到X大小。"
L["RPTRT"] = "資源回收計時器"
L["RPTRTD"] = "運作重複回收程式在X秒內。"
L["RPTRTSU"] = "回收表程式將只會運作當回收計時和回收大小狀況有衝突。"
L["RPTTC"] = "重複資料庫的人"
L["RPTTS"] = "重複表大小"
L["RPTTT"] = "修飾表"
L["RPTTTD"] = "修飾重複表資料如果回收計時和回收大小情況有衝突。"
L["RPTU"] = "如果字串已重複X次在Y秒內就過濾。"
L["RSF"] = "重置特別過濾"
L["RTF"] = "重置交易過濾"
L["RUI"] = "重載 UI"
L["RUID"] = "重載 UI 以使一些改動生效。"
L["RWLS"] = "重置白名單"
L["Say/Yell"] = "說/大喊"
L["SAYC"] = "過濾 <說> 頻道"
L["SAYCD"] = "選中以過濾 <說> 頻道。"
L["SECPSD"] = "幾秒內通過。"
L["SPCS"] = "特別頻道選擇"
L["SPCST"] = "特別頻道"
L["SPCSTD"] = "特別頻道是計畫給插件使用聊天重新導向你扔然想要過濾。"
L["TC"] = "過濾 <交易> 頻道"
L["TCD"] = "選中以過濾 <交易> 頻道。"
L["TFFR"] = "輸入你的朋友到TradeFilter3豁免名單..."
L["TFFRC"] = "朋友名單匯入完成"
L["TFR"] = "TradeFilter3"
L["Trade"] = "交易"
L["TRADE Filters"] = "交易過濾"
L["TRPT"] = "時間"
L["TRPTD"] = "在數秒內重複之所需要的時間。"
L["TurnOn"] = "開啟"
L["TurnOnDesc"] = "啟用交易頻道過濾器。"
L["Wiping party exempt list"] = "消除隊伍豁免名單"
L["WLE"] = "啟用白名單檢查"
L["wLists"] = "白名單"
L["YELLC"] = "過濾 <大喊> 頻道"
L["YELLCD"] = "選中以過濾 <大喊> 頻道。"

if GetLocale() == "zhTW" then return end
end

local L =  LibStub("AceLocale-3.0"):NewLocale("TradeFilter3", "koKR")
if L then
--[[Translation missing --]]
L[" Blacklist Filtered"] = " Blacklist Filtered"
--[[Translation missing --]]
L[" Messages Filtered"] = " Messages Filtered"
--[[Translation missing --]]
L[" Repeats Blocked"] = " Repeats Blocked"
L["#RPT"] = "반복"
L["#RPTD"] = "필터링 전 반복 횟수"
--[[Translation missing --]]
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset filtered count.]=] ] = [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset filtered count.]=]
--[[Translation missing --]]
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset repeat count.]=] ] = [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset repeat count.]=]
--[[Translation missing --]]
L["0 Messages Filtered"] = "0 Messages Filtered"
--[[Translation missing --]]
L["0 Repeats Blocked"] = "0 Repeats Blocked"
--[[Translation missing --]]
L["BASE Filters"] = "BASE Filters"
L["BCF"] = "기본 채널 필터"
--[[Translation missing --]]
L["BCFD"] = "Base Channel Filters are only applied to the General/LFG/Special Channel, no other channels are affected by this list."
--[[Translation missing --]]
L["BG"] = "Battleground Filters"
--[[Translation missing --]]
L["BG Filters"] = "BG Filters"
--[[Translation missing --]]
L["BGC"] = "Filter Battleground"
--[[Translation missing --]]
L["BGCD"] = "Select this to apply filter to Battleground."
--[[Translation missing --]]
L["BGD"] = "Battleground Filters are only applied to the Battleground, no other channels are affected by this list."
--[[Translation missing --]]
L["BLBYPASS"] = "Black List Bypass"
--[[Translation missing --]]
L["BLBYPASSD"] = "Allow strings that match a pattern in your whitelist to bypass the Black List filter."
L["BLE"] = "블랙 리스트 확인 사용"
L["bLists"] = "블랙 리스트"
L["BTF"] = "기본 거래 필터"
--[[Translation missing --]]
L["BTFD"] = "Trade Channel Filters are only applied to the Trade Channel, no other channels are affected by this list."
L["bwLists"] = "블랙/화이트 리스트"
--[[Translation missing --]]
L["CEPM"] = "Current Exempt Party Members"
--[[Translation missing --]]
L["CFM"] = "Checking for Match:"
L["channelGroup"] = "채널 선택"
--[[Translation missing --]]
L["Current Exempt List"] = "Current Exempt List"
L["Debug"] = "디버그"
--[[Translation missing --]]
L["DebugChecking"] = "Strip 'Checking For Match'"
--[[Translation missing --]]
L["DebugCheckingD"] = "Strip 'Checking For Match' from debug output."
L["DebugDesc"] = "디버깅 결과를 DEBUG 채널에 출력"
L["debugFrame"] = "DEBUG"
L["DEBUGGING"] = "출력 옵션 디버깅"
L["DISABLED"] = "|cffff8080미사용|r"
--[[Translation missing --]]
L["DUEL_WINNER_KNOCKOUT"] = "%1$s has defeated %2$s in a duel"
--[[Translation missing --]]
L["DUEL_WINNER_RETREAT"] = "%2$s has fled from %1$s in a duel"
--[[Translation missing --]]
L["EBL"] = "Edit Black List"
--[[Translation missing --]]
L["EditFilter"] = "Edit Filter Expressions"
--[[Translation missing --]]
L["EditFilterD"] = "Edit Filter Expressions to be matched in Trade or Base Channel."
--[[Translation missing --]]
L["EditFilterGD"] = "Edit Filter Expressions to be matched in Trade or Base Channel Group."
L["EditFilterGroup"] = "사용자 필터 편집"
--[[Translation missing --]]
L["EditFilterUsage"] = "Case Insensitive LFG = [lL][fF][gG]"
L["EditLists"] = "블랙/화이트 리스트 편집"
L["ENABLED"] = "|cff00ff00사용|r"
--[[Translation missing --]]
L["EWL"] = "Edit White List"
--[[Translation missing --]]
L["Exempt Friend List"] = "Exempt Friend List"
--[[Translation missing --]]
L["Exempt List"] = "Exempt List"
--[[Translation missing --]]
L["Exempt Party Members"] = "Exempt Party Members"
L["FADD"] = "TradeFilter 예외 목록에 추가됨"
--[[Translation missing --]]
L["FDS"] = "Filter Duel Spam"
--[[Translation missing --]]
L["FDSD"] = "Filter Duel Spam"
L["FREM"] = "TradeFilter 예외 목록에서 제외됨"
--[[Translation missing --]]
L["Friends"] = "Friends"
--[[Translation missing --]]
L["FSELF"] = "Filter Self"
--[[Translation missing --]]
L["FSELFD"] = "Allow yourself to be filtered? This can be used to test filters. TRUE = Player is subject to filtering, FALSE =  Player is not subject to filtering and passes through unchecked."
--[[Translation missing --]]
L["GAC"] = "Filter Guild AddOns Channel"
--[[Translation missing --]]
L["GACD"] = "Filter AddOns that make use of the hidden AddOns Guild channel. This Filter abides by the BASE Channel Filter list."
L["GC"] = "공개 채널 필터링"
L["GCD"] = "공개 채널에 필터를 적용하려면 선택"
L["General"] = "일반"
--[[Translation missing --]]
L["If enabled party members will be exempt from filtration."] = "If enabled party members will be exempt from filtration."
--[[Translation missing --]]
L["If enabled your friends list will be exempt from filtration."] = "If enabled your friends list will be exempt from filtration."
--[[Translation missing --]]
L["INPUSAGE"] = "Input one entry per line."
L["LFG"] = "파티 찾기"
L["LFGC"] = "파티찾기 채널 필터링"
L["LFGCD"] = "파티찾기 채널에 필터를 적용하려면 선택"
--[[Translation missing --]]
L["listsGD"] = "Add words or patterns to match against for a Black/White list."
L["listsGroup"] = "블랙/화이트 리스트"
--[[Translation missing --]]
L["LOADED"] = "|cff00ff00Loaded!|r"
--[[Translation missing --]]
L["MATCHED"] = "|cff00ff00Matched:|r"
--[[Translation missing --]]
L["Messages filtered are saved per session only"] = "Messages filtered are saved per session only"
--[[Translation missing --]]
L["MIPM"] = "Found an unknown party member; rescanning..."
--[[Translation missing --]]
L["NJAOF"] = "Not just any old filter!"
--[[Translation missing --]]
L["NOMATCH"] = "|cff00ff00NO Match Found - Redirected|r"
--[[Translation missing --]]
L["Notes"] = "A Simple World of Warcraft Spam Filter!"
L["OUTPUT"] = "출력 옵션"
--[[Translation missing --]]
L["PADD"] = "added to the temporary TradeFilter exempt list."
--[[Translation missing --]]
L["Party Members"] = "Party Members"
L["Profiles"] = "프로필"
L["RBF"] = "기본 필터 초기화"
L["RBLS"] = "블랙 리스트 초기화"
L["RBWL"] = "블랙/화이트 리스트 초기화"
L["Redir"] = "스팸 우회"
--[[Translation missing --]]
L["RedirBL"] = "Redirect Blacklist matches to 'SPAM' ChatFrame."
L["RedirDesc"] = "거래 채널 스팸을 SPAM 채널로 우회"
L["redirectFrame"] = "스팸"
--[[Translation missing --]]
L["REPEAT"] = "Repeat Filtration"
L["repeatFrame"] = "반복"
L["RLS"] = "목록 초기화"
--[[Translation missing --]]
L["RMVRT1"] = "Removed"
--[[Translation missing --]]
L["RMVRT2"] = "from TradeFilter3 repeat database."
--[[Translation missing --]]
L["RPTA"] = "Repeat Advanced"
--[[Translation missing --]]
L["RPTAD"] = "Repeat Advanced settings and table information"
L["RPTBLOCKED"] = "차단"
--[[Translation missing --]]
L["RPTBLOCKEDD"] = "Total Repeats Blocked"
--[[Translation missing --]]
L["RPTBYPASS"] = "Repeat Bypass"
--[[Translation missing --]]
L["RPTBYPASSD"] = "Allow strings that match a pattern in your whitelist to bypass the repeat filter."
L["RPTENABLE"] = "반복 확인 사용"
L["RPTENABLED"] = "반복 확인 사용 여부"
L["RPTRESET"] = "리셋"
L["RPTRESETD"] = "반복 횟수 초기화"
--[[Translation missing --]]
L["RPTRS"] = "Recycle Size"
--[[Translation missing --]]
L["RPTRSD"] = "Run repeat recycle function when repeat table has reached X size."
--[[Translation missing --]]
L["RPTRT"] = "Recycle Timer"
--[[Translation missing --]]
L["RPTRTD"] = "Run repeat recycle function at X seconds."
--[[Translation missing --]]
L["RPTRTSU"] = "The RecycleTables function will run only when both the Recyle Time and Recycle Size conditions have been met."
--[[Translation missing --]]
L["RPTTC"] = "People in Repeat DB"
--[[Translation missing --]]
L["RPTTS"] = "Repeat Table Size"
--[[Translation missing --]]
L["RPTTT"] = "Trim Table"
--[[Translation missing --]]
L["RPTTTD"] = "Trim the repeat table data if the Recyle Time and Recycle Size conditions have been met."
--[[Translation missing --]]
L["RPTU"] = "If string is repeated X times in Y seconds then filter."
--[[Translation missing --]]
L["RSF"] = "Reset Special Filters"
L["RTF"] = "거래 필터 초기화"
L["RUI"] = "UI 다시 불러오기"
L["RUID"] = "변경 사항을 적용하기 위해 유저 인터페이스 다시 불러오기"
L["RWLS"] = "화이트 리스트 초기화"
L["Say/Yell"] = "일반 대화/외침"
L["SAYC"] = "일반 대화 채널 필터링"
L["SAYCD"] = "일반 대화 채널에 필터를 적용하려면 선택"
--[[Translation missing --]]
L["SECPSD"] = "seconds passed."
--[[Translation missing --]]
L["SPCS"] = "Special Channel Selection"
--[[Translation missing --]]
L["SPCST"] = "Special Channels"
--[[Translation missing --]]
L["SPCSTD"] = "Special Channels are intended for AddOns that use channels for chat redirections that you still want filtered."
L["TC"] = "거래 채널 필터링"
L["TCD"] = "거래 채널에 필터를 적용하려면 선택"
--[[Translation missing --]]
L["TFFR"] = "Importing your friends for TradeFilter3 exemption list..."
--[[Translation missing --]]
L["TFFRC"] = "Friends list import completed"
L["TFR"] = "TradeFilter3"
--[[Translation missing --]]
L["Trade"] = "Trade"
--[[Translation missing --]]
L["TRADE Filters"] = "TRADE Filters"
--[[Translation missing --]]
L["TRPT"] = "Time"
--[[Translation missing --]]
L["TRPTD"] = "Time required between repeats in seconds."
L["TurnOn"] = "사용하기"
L["TurnOnDesc"] = "거래 채널 필터 사용"
--[[Translation missing --]]
L["Wiping party exempt list"] = "Wiping party exempt list"
L["WLE"] = "화이트 리스트 확인 사용"
L["wLists"] = "화이트 리스트"
L["YELLC"] = "외침 채널 필터링"
L["YELLCD"] = "외침 채널에 필터를 적용하려면 선택"

if GetLocale() == "koKR" then return end
end

local L =  LibStub("AceLocale-3.0"):NewLocale("TradeFilter3", "frFR")
if L then
--[[Translation missing --]]
L[" Blacklist Filtered"] = " Blacklist Filtered"
--[[Translation missing --]]
L[" Messages Filtered"] = " Messages Filtered"
--[[Translation missing --]]
L[" Repeats Blocked"] = " Repeats Blocked"
L["#RPT"] = "Répétitions"
L["#RPTD"] = "Nombre de répétitions avant filtrage"
--[[Translation missing --]]
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset filtered count.]=] ] = [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset filtered count.]=]
--[[Translation missing --]]
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset repeat count.]=] ] = [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset repeat count.]=]
--[[Translation missing --]]
L["0 Messages Filtered"] = "0 Messages Filtered"
--[[Translation missing --]]
L["0 Repeats Blocked"] = "0 Repeats Blocked"
--[[Translation missing --]]
L["BASE Filters"] = "BASE Filters"
L["BCF"] = "Filtres de base des canaux"
L["BCFD"] = "Les filtres du canal Commerce ne sont appliqués que pour le canal Commerce, aucun autre canal n'est affecté par cette liste."
--[[Translation missing --]]
L["BG"] = "Battleground Filters"
--[[Translation missing --]]
L["BG Filters"] = "BG Filters"
--[[Translation missing --]]
L["BGC"] = "Filter Battleground"
--[[Translation missing --]]
L["BGCD"] = "Select this to apply filter to Battleground."
--[[Translation missing --]]
L["BGD"] = "Battleground Filters are only applied to the Battleground, no other channels are affected by this list."
--[[Translation missing --]]
L["BLBYPASS"] = "Black List Bypass"
--[[Translation missing --]]
L["BLBYPASSD"] = "Allow strings that match a pattern in your whitelist to bypass the Black List filter."
--[[Translation missing --]]
L["BLE"] = "Enable Blacklist Checking"
L["bLists"] = "Liste noire"
L["BTF"] = "Filtres de base du commerce"
--[[Translation missing --]]
L["BTFD"] = "Trade Channel Filters are only applied to the Trade Channel, no other channels are affected by this list."
L["bwLists"] = "Liste noire et blanche"
--[[Translation missing --]]
L["CEPM"] = "Current Exempt Party Members"
--[[Translation missing --]]
L["CFM"] = "Checking for Match:"
L["channelGroup"] = "Sélection du canal"
--[[Translation missing --]]
L["Current Exempt List"] = "Current Exempt List"
L["Debug"] = "Debugage"
--[[Translation missing --]]
L["DebugChecking"] = "Strip 'Checking For Match'"
--[[Translation missing --]]
L["DebugCheckingD"] = "Strip 'Checking For Match' from debug output."
L["DebugDesc"] = "Activer le débugage et ressort dans le canal DEBUG"
L["debugFrame"] = "DEBUG"
--[[Translation missing --]]
L["DEBUGGING"] = "Debugging Output Options"
L["DISABLED"] = "|cffff8080Désactiver|r"
--[[Translation missing --]]
L["DUEL_WINNER_KNOCKOUT"] = "%1$s has defeated %2$s in a duel"
--[[Translation missing --]]
L["DUEL_WINNER_RETREAT"] = "%2$s has fled from %1$s in a duel"
--[[Translation missing --]]
L["EBL"] = "Edit Black List"
L["EditFilter"] = "Editer les expressions des filtres"
L["EditFilterD"] = "Editer les expressions des filtres du canal commerce ou général"
--[[Translation missing --]]
L["EditFilterGD"] = "Edit Filter Expressions to be matched in Trade or Base Channel Group."
L["EditFilterGroup"] = "Editer les filtres perso"
L["EditFilterUsage"] = "Insensible à la casse : LFG = [lL][fF][gG]"
L["EditLists"] = "Editer les listes"
L["ENABLED"] = "|cff00ff00Activer|r"
--[[Translation missing --]]
L["EWL"] = "Edit White List"
--[[Translation missing --]]
L["Exempt Friend List"] = "Exempt Friend List"
--[[Translation missing --]]
L["Exempt List"] = "Exempt List"
--[[Translation missing --]]
L["Exempt Party Members"] = "Exempt Party Members"
L["FADD"] = "Ajoute à la liste d'exception de TradeFilter"
--[[Translation missing --]]
L["FDS"] = "Filter Duel Spam"
--[[Translation missing --]]
L["FDSD"] = "Filter Duel Spam"
L["FREM"] = "Supprime de la liste d'exception de TradeFilter"
--[[Translation missing --]]
L["Friends"] = "Friends"
L["FSELF"] = "Se filtrer"
L["FSELFD"] = "Se filtrer soi-même ? Peut servir pour tester les filtres. TRUE = filtrage actif sur soi, FALSE = pas de filtrage sur soi."
--[[Translation missing --]]
L["GAC"] = "Filter Guild AddOns Channel"
--[[Translation missing --]]
L["GACD"] = "Filter AddOns that make use of the hidden AddOns Guild channel. This Filter abides by the BASE Channel Filter list."
L["GC"] = "Filtre du canal Général"
L["GCD"] = "Sélectionner pour être appliqué au canal Général"
L["General"] = "Général"
--[[Translation missing --]]
L["If enabled party members will be exempt from filtration."] = "If enabled party members will be exempt from filtration."
--[[Translation missing --]]
L["If enabled your friends list will be exempt from filtration."] = "If enabled your friends list will be exempt from filtration."
--[[Translation missing --]]
L["INPUSAGE"] = "Input one entry per line."
--[[Translation missing --]]
L["LFG"] = "LFG"
L["LFGC"] = "Filtre du canal RechercheDeGroupe"
L["LFGCD"] = "Sélectionner pour être appliqué au canal RechercheDeGroupe"
L["listsGD"] = "Ajouter des mots ou des expressions pour gérer vos listes noire et blanche."
L["listsGroup"] = "Listes noire/blanche"
L["LOADED"] = "|cff00ff00Charger!|r"
--[[Translation missing --]]
L["MATCHED"] = "|cff00ff00Matched:|r"
--[[Translation missing --]]
L["Messages filtered are saved per session only"] = "Messages filtered are saved per session only"
--[[Translation missing --]]
L["MIPM"] = "Found an unknown party member; rescanning..."
--[[Translation missing --]]
L["NJAOF"] = "Not just any old filter!"
--[[Translation missing --]]
L["NOMATCH"] = "|cff00ff00NO Match Found - Redirected|r"
L["Notes"] = "Filtre le canal Commerce des commentaires hors charte"
L["OUTPUT"] = "Options d'affichage"
--[[Translation missing --]]
L["PADD"] = "added to the temporary TradeFilter exempt list."
--[[Translation missing --]]
L["Party Members"] = "Party Members"
L["Profiles"] = "Profils"
L["RBF"] = "Réinitialiser les filtres de base"
--[[Translation missing --]]
L["RBLS"] = "Reset Black List"
L["RBWL"] = "Réinitialiser les listes noire/blanche"
L["Redir"] = "Redirige les spams"
--[[Translation missing --]]
L["RedirBL"] = "Redirect Blacklist matches to 'SPAM' ChatFrame."
L["RedirDesc"] = "Rediriger les spams du canal Commerce vers le canal SPAM"
L["redirectFrame"] = "SPAM"
L["REPEAT"] = "Répéter le filtrage"
L["repeatFrame"] = "REPETER"
L["RLS"] = "Réinitialiser le listes"
--[[Translation missing --]]
L["RMVRT1"] = "Removed"
--[[Translation missing --]]
L["RMVRT2"] = "from TradeFilter3 repeat database."
--[[Translation missing --]]
L["RPTA"] = "Repeat Advanced"
--[[Translation missing --]]
L["RPTAD"] = "Repeat Advanced settings and table information"
L["RPTBLOCKED"] = "Bloqué"
L["RPTBLOCKEDD"] = "Total des répétitions bloquées"
--[[Translation missing --]]
L["RPTBYPASS"] = "Repeat Bypass"
--[[Translation missing --]]
L["RPTBYPASSD"] = "Allow strings that match a pattern in your whitelist to bypass the repeat filter."
L["RPTENABLE"] = "Activer le contrôle des répétitions."
L["RPTENABLED"] = "Activer ou Désactiver le contrôle des répétitions"
L["RPTRESET"] = "Réinitialiser"
L["RPTRESETD"] = "Réinitialiser le comptage de répétition"
--[[Translation missing --]]
L["RPTRS"] = "Recycle Size"
--[[Translation missing --]]
L["RPTRSD"] = "Run repeat recycle function when repeat table has reached X size."
--[[Translation missing --]]
L["RPTRT"] = "Recycle Timer"
--[[Translation missing --]]
L["RPTRTD"] = "Run repeat recycle function at X seconds."
--[[Translation missing --]]
L["RPTRTSU"] = "The RecycleTables function will run only when both the Recyle Time and Recycle Size conditions have been met."
--[[Translation missing --]]
L["RPTTC"] = "People in Repeat DB"
--[[Translation missing --]]
L["RPTTS"] = "Repeat Table Size"
--[[Translation missing --]]
L["RPTTT"] = "Trim Table"
--[[Translation missing --]]
L["RPTTTD"] = "Trim the repeat table data if the Recyle Time and Recycle Size conditions have been met."
L["RPTU"] = "Si le message est répété X fois en Y secondes, alors filtrer."
L["RSF"] = "Filtres Spéciaux Remis"
L["RTF"] = "Réinitialiser les filtres du commerce"
L["RUI"] = "Relancer l'interface"
L["RUID"] = "Relancer l'interface pour que les changements soient activés"
--[[Translation missing --]]
L["RWLS"] = "Reset White List"
L["Say/Yell"] = "Dire/Crier"
L["SAYC"] = "Filtre du canal Dire"
L["SAYCD"] = "Sélectionner pour appliquer le filtre au canal Dire"
--[[Translation missing --]]
L["SECPSD"] = "seconds passed."
L["SPCS"] = "Sélection spéciale d'un canal"
--[[Translation missing --]]
L["SPCST"] = "Special Channels"
--[[Translation missing --]]
L["SPCSTD"] = "Special Channels are intended for AddOns that use channels for chat redirections that you still want filtered."
L["TC"] = "Filtre du canal Commerce"
L["TCD"] = "Sélectionner pour appliquer le filtre au canal Commerce"
--[[Translation missing --]]
L["TFFR"] = "Importing your friends for TradeFilter3 exemption list..."
--[[Translation missing --]]
L["TFFRC"] = "Friends list import completed"
L["TFR"] = "TradeFilter3"
L["Trade"] = "Commerce"
--[[Translation missing --]]
L["TRADE Filters"] = "TRADE Filters"
L["TRPT"] = "Temps"
L["TRPTD"] = "Temps requis entre chaque répétitions en secondes."
L["TurnOn"] = "Activer"
L["TurnOnDesc"] = "Activer le filtre des canaux"
--[[Translation missing --]]
L["Wiping party exempt list"] = "Wiping party exempt list"
--[[Translation missing --]]
L["WLE"] = "Enable Whitelist Checking"
L["wLists"] = "Liste blanche"
L["YELLC"] = "Filtre du canal Crier"
L["YELLCD"] = "Sélectionner pour appliquer le filtre au canal Crier"

if GetLocale() == "frFR" then return end
end

local L =  LibStub("AceLocale-3.0"):NewLocale("TradeFilter3", "ruRU")
if L then
--[[Translation missing --]]
L[" Blacklist Filtered"] = " Blacklist Filtered"
--[[Translation missing --]]
L[" Messages Filtered"] = " Messages Filtered"
--[[Translation missing --]]
L[" Repeats Blocked"] = " Repeats Blocked"
L["#RPT"] = "Повторы"
L["#RPTD"] = "Количество повторов перед тем как фильтровать"
--[[Translation missing --]]
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset filtered count.]=] ] = [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset filtered count.]=]
--[[Translation missing --]]
L[ [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset repeat count.]=] ] = [=[|cffeda55fRight Click|r to open config GUI.
|cffeda55fLeft Click|r reset repeat count.]=]
--[[Translation missing --]]
L["0 Messages Filtered"] = "0 Messages Filtered"
--[[Translation missing --]]
L["0 Repeats Blocked"] = "0 Repeats Blocked"
--[[Translation missing --]]
L["BASE Filters"] = "BASE Filters"
--[[Translation missing --]]
L["BCF"] = "Base Channel Filters"
--[[Translation missing --]]
L["BCFD"] = "Base Channel Filters are only applied to the General/LFG/Special Channel, no other channels are affected by this list."
--[[Translation missing --]]
L["BG"] = "Battleground Filters"
--[[Translation missing --]]
L["BG Filters"] = "BG Filters"
--[[Translation missing --]]
L["BGC"] = "Filter Battleground"
--[[Translation missing --]]
L["BGCD"] = "Select this to apply filter to Battleground."
--[[Translation missing --]]
L["BGD"] = "Battleground Filters are only applied to the Battleground, no other channels are affected by this list."
--[[Translation missing --]]
L["BLBYPASS"] = "Black List Bypass"
--[[Translation missing --]]
L["BLBYPASSD"] = "Allow strings that match a pattern in your whitelist to bypass the Black List filter."
--[[Translation missing --]]
L["BLE"] = "Enable Blacklist Checking"
L["bLists"] = "Чёрный список"
--[[Translation missing --]]
L["BTF"] = "Trade Channel Filters"
--[[Translation missing --]]
L["BTFD"] = "Trade Channel Filters are only applied to the Trade Channel, no other channels are affected by this list."
L["bwLists"] = "Черный/Белый список"
--[[Translation missing --]]
L["CEPM"] = "Current Exempt Party Members"
L["CFM"] = "Проверка соответствия"
L["channelGroup"] = "Выбор каналов"
--[[Translation missing --]]
L["Current Exempt List"] = "Current Exempt List"
L["Debug"] = "Отладка"
--[[Translation missing --]]
L["DebugChecking"] = "Strip 'Checking For Match'"
--[[Translation missing --]]
L["DebugCheckingD"] = "Strip 'Checking For Match' from debug output."
L["DebugDesc"] = "Выводить отладочные сообщения в канал \"ОТЛАДКА\""
--[[Translation missing --]]
L["debugFrame"] = "DEBUG"
--[[Translation missing --]]
L["DEBUGGING"] = "Debugging Output Options"
--[[Translation missing --]]
L["DISABLED"] = "|cffff8080Disabled|r"
--[[Translation missing --]]
L["DUEL_WINNER_KNOCKOUT"] = "%1$s has defeated %2$s in a duel"
--[[Translation missing --]]
L["DUEL_WINNER_RETREAT"] = "%2$s has fled from %1$s in a duel"
L["EBL"] = "Редактировать Чёрный список"
--[[Translation missing --]]
L["EditFilter"] = "Edit Filter Expressions"
--[[Translation missing --]]
L["EditFilterD"] = "Edit Filter Expressions to be matched in Trade or Base Channel."
--[[Translation missing --]]
L["EditFilterGD"] = "Edit Filter Expressions to be matched in Trade or Base Channel Group."
L["EditFilterGroup"] = "Редактировать индивидуальные фильтры"
--[[Translation missing --]]
L["EditFilterUsage"] = "Case Insensitive LFG = [lL][fF][gG]"
L["EditLists"] = "Редактировать белый/черный списки"
--[[Translation missing --]]
L["ENABLED"] = "|cff00ff00Enabled|r"
L["EWL"] = "Редактировать Белый список"
--[[Translation missing --]]
L["Exempt Friend List"] = "Exempt Friend List"
--[[Translation missing --]]
L["Exempt List"] = "Exempt List"
--[[Translation missing --]]
L["Exempt Party Members"] = "Exempt Party Members"
--[[Translation missing --]]
L["FADD"] = "added to the TradeFilter exempt list."
L["FDS"] = "Фильтровать дуэльный спам"
L["FDSD"] = "Фильтровать дуэльный спам"
--[[Translation missing --]]
L["FREM"] = "removed from TradeFilter exempt list."
--[[Translation missing --]]
L["Friends"] = "Friends"
L["FSELF"] = "Фильтровать себя"
L["FSELFD"] = "Фильтровать себя? Может быть использовано для теста фильтров. TRUE = фразы игрока подвергаются фильтрованию, FALSE = фразы игрока не фильтруется и пропускаются без изменений."
--[[Translation missing --]]
L["GAC"] = "Filter Guild AddOns Channel"
--[[Translation missing --]]
L["GACD"] = "Filter AddOns that make use of the hidden AddOns Guild channel. This Filter abides by the BASE Channel Filter list."
L["GC"] = "Фильтр главного канала"
L["GCD"] = "Выберите это, чтобы применить фильтр к главному каналу"
--[[Translation missing --]]
L["General"] = "General"
--[[Translation missing --]]
L["If enabled party members will be exempt from filtration."] = "If enabled party members will be exempt from filtration."
--[[Translation missing --]]
L["If enabled your friends list will be exempt from filtration."] = "If enabled your friends list will be exempt from filtration."
--[[Translation missing --]]
L["INPUSAGE"] = "Input one entry per line."
L["LFG"] = "ЛФГ"
L["LFGC"] = "Фильтр LFG канала"
L["LFGCD"] = "Выберите это, чтобы применить фильтр к каналу LFG "
L["listsGD"] = "Добавить слова или выражения в Чёрный/Белый список"
L["listsGroup"] = "Чёрный/Белый список"
--[[Translation missing --]]
L["LOADED"] = "|cff00ff00Loaded!|r"
--[[Translation missing --]]
L["MATCHED"] = "|cff00ff00Matched:|r"
--[[Translation missing --]]
L["Messages filtered are saved per session only"] = "Messages filtered are saved per session only"
--[[Translation missing --]]
L["MIPM"] = "Found an unknown party member; rescanning..."
--[[Translation missing --]]
L["NJAOF"] = "Not just any old filter!"
--[[Translation missing --]]
L["NOMATCH"] = "|cff00ff00NO Match Found - Redirected|r"
L["Notes"] = "Не просто фильтр!"
L["OUTPUT"] = "Опции вывода"
--[[Translation missing --]]
L["PADD"] = "added to the temporary TradeFilter exempt list."
--[[Translation missing --]]
L["Party Members"] = "Party Members"
L["Profiles"] = "Профили"
L["RBF"] = "Сбросить базовые фильтры"
L["RBLS"] = "Сбросить Чёрный список"
L["RBWL"] = "Сбросить черный/белый списки"
L["Redir"] = "Перенаправить СПАМ"
--[[Translation missing --]]
L["RedirBL"] = "Redirect Blacklist matches to 'SPAM' ChatFrame."
L["RedirDesc"] = "Перенаправить Спам торгового канала в канал СПАМ"
--[[Translation missing --]]
L["redirectFrame"] = "SPAM"
L["REPEAT"] = "Фильтрация повторов"
--[[Translation missing --]]
L["repeatFrame"] = "REPEAT"
--[[Translation missing --]]
L["RLS"] = "Reset Lists"
L["RMVRT1"] = "Удалено"
--[[Translation missing --]]
L["RMVRT2"] = "from TradeFilter3 repeat database."
--[[Translation missing --]]
L["RPTA"] = "Repeat Advanced"
--[[Translation missing --]]
L["RPTAD"] = "Repeat Advanced settings and table information"
L["RPTBLOCKED"] = "Заблокировано"
L["RPTBLOCKEDD"] = "Всего повторений заблокировано"
--[[Translation missing --]]
L["RPTBYPASS"] = "Repeat Bypass"
--[[Translation missing --]]
L["RPTBYPASSD"] = "Allow strings that match a pattern in your whitelist to bypass the repeat filter."
--[[Translation missing --]]
L["RPTENABLE"] = "Enable Repeat Check"
--[[Translation missing --]]
L["RPTENABLED"] = "Enable or Disable Repeat Check"
--[[Translation missing --]]
L["RPTRESET"] = "Reset"
L["RPTRESETD"] = "Сброс счётчика повторов"
--[[Translation missing --]]
L["RPTRS"] = "Recycle Size"
--[[Translation missing --]]
L["RPTRSD"] = "Run repeat recycle function when repeat table has reached X size."
--[[Translation missing --]]
L["RPTRT"] = "Recycle Timer"
--[[Translation missing --]]
L["RPTRTD"] = "Run repeat recycle function at X seconds."
--[[Translation missing --]]
L["RPTRTSU"] = "The RecycleTables function will run only when both the Recyle Time and Recycle Size conditions have been met."
--[[Translation missing --]]
L["RPTTC"] = "People in Repeat DB"
--[[Translation missing --]]
L["RPTTS"] = "Repeat Table Size"
--[[Translation missing --]]
L["RPTTT"] = "Trim Table"
--[[Translation missing --]]
L["RPTTTD"] = "Trim the repeat table data if the Recyle Time and Recycle Size conditions have been met."
L["RPTU"] = "Если строка повторяется X раз за Y секунд, значит фильтровать"
L["RSF"] = "Сбросить специальные фильтры"
L["RTF"] = "Сбросить фильтр"
L["RUI"] = "Перезагрузить ПИ"
L["RUID"] = "Перезагрузите Пользовательский интерфейс(ПИ), чтобы изменения вступили в силу"
L["RWLS"] = "Сбросить Белый список"
--[[Translation missing --]]
L["Say/Yell"] = "Say/Yell"
L["SAYC"] = "Фильтр канала СКАЗАТЬ"
L["SAYCD"] = "Выберите это, чтобы применить фильтр к каналу СКАЗАТЬ"
L["SECPSD"] = "Секунд прошло"
L["SPCS"] = "Выбор специального канала"
L["SPCST"] = "Специальные каналы"
--[[Translation missing --]]
L["SPCSTD"] = "Special Channels are intended for AddOns that use channels for chat redirections that you still want filtered."
L["TC"] = "Фильтр канала ТОРГОВЛЯ"
L["TCD"] = "Выберите это, чтобы применить фильтр к каналу ТОРГОВЛЯ"
--[[Translation missing --]]
L["TFFR"] = "Importing your friends for TradeFilter3 exemption list..."
--[[Translation missing --]]
L["TFFRC"] = "Friends list import completed"
L["TFR"] = "ТорговыйФильтр3"
--[[Translation missing --]]
L["Trade"] = "Trade"
--[[Translation missing --]]
L["TRADE Filters"] = "TRADE Filters"
L["TRPT"] = "Время"
--[[Translation missing --]]
L["TRPTD"] = "Time required between repeats in seconds."
L["TurnOn"] = "Включить"
L["TurnOnDesc"] = "Включить фильтр канала ТОРГОВЛЯ"
--[[Translation missing --]]
L["Wiping party exempt list"] = "Wiping party exempt list"
--[[Translation missing --]]
L["WLE"] = "Enable Whitelist Checking"
L["wLists"] = "Белый список"
L["YELLC"] = "Фильтр канала КРИК"
L["YELLCD"] = "Выбрать для применения фильтра к каналу КРИК"

if GetLocale() == "ruRU" then return end
end
