--[[
	TradeCycle 2.2e
	by Durdanius / Darkmoon Faire

	Enable / Disable trades automatically
  - Disable trades in all cities by default.
  - Everywhere else trades are enabled.
  - Use /tc to toggle trades on/off.
--]]

-- Define slashcommand
SLASH_TRADECYCLE1, SLASH_TRADECYCLE2 = '/tradecycle', '/tc';

-- Define all cities where trades are off
TRADECYCLE_CITIES = {"Stormwind", "Ironforge", "Darnassus", "Undercity", "Thunder Bluff", "Orgrimmar", "Exodar", "Shattrath", "Silvermoon", "Dalaran", "Shrine of Seven Stars", "Shrine of Two Moons"};

-- Exceptions for keeping trades on in these zones
TRADECYCLE_EXCEPTIONS = {"Siege of Orgrimmar"};

local frame = CreateFrame("Frame")

frame:RegisterEvent("ZONE_CHANGED_NEW_AREA")

frame:SetScript("OnEvent", function(self, event, ...)
  -- Assume we're not in a city
  local TRADECYCLE_InCity = "false";
  
  -- Get current zone
  local TRADECYCLE_Zone = GetRealZoneText();
  
  -- Check if current zone is a city and disable trades if it is so
	local i = 1;
	for _ in pairs(TRADECYCLE_CITIES) do
		if (string.find(GetRealZoneText(), TRADECYCLE_CITIES[i])) then
			TRADECYCLE_InCity = "true";
		end
		i = i + 1;
	end
	
  -- Check for exceptions
  local i = 1;
	for _ in pairs(TRADECYCLE_EXCEPTIONS) do
		if (string.find(GetRealZoneText(), TRADECYCLE_EXCEPTIONS[i])) then
			TRADECYCLE_InCity = "false";
		end
		i = i + 1;
	end

	-- We're not in a city. Enable trades, in case we are in a city - disable trades.
	if (TRADECYCLE_InCity == "false") then
		SetCVar("BlockTrades", 0);
		TRADECYCLE_Print("Trades are now enabled.")
	else
		SetCVar("BlockTrades", 1);		
		TRADECYCLE_Print("Trades are now disabled.")
	end
end)

-- Print to default chat window
function TRADECYCLE_Print(TRADECYCLE_Message)
	DEFAULT_CHAT_FRAME:AddMessage(TRADECYCLE_Message);
end

-- Cycle trading
function SlashCmdList.TRADECYCLE(msg, editbox)
	if (GetCVar("BlockTrades") == "0") then
		SetCVar("BlockTrades", 1);
		TRADECYCLE_Print("Trades are now disabled.")
	else
		SetCVar("BlockTrades", 0);
		TRADECYCLE_Print("Trades are now enabled.")
	end
end
