----------------------------------------------------------------------------------
-- Total RP 3
--	---------------------------------------------------------------------------
--	Copyright 2015 Sylvain Cossement (telkostrasz@totalrp3.info)
--  Copyright 2018 Renaud "Ellypse" Parize <ellypse@totalrp3.info> @EllypseCelwe
--
--	Licensed under the Apache License, Version 2.0 (the "License");
--	you may not use this file except in compliance with the License.
--	You may obtain a copy of the License at
--
--		http://www.apache.org/licenses/LICENSE-2.0
--
--	Unless required by applicable law or agreed to in writing, software
--	distributed under the License is distributed on an "AS IS" BASIS,
--	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--	See the License for the specific language governing permissions and
--	limitations under the License.
----------------------------------------------------------------------------------
local Localization = TRP3_API.loc;

--- This is a trick to get IntelliJ's code completion to work on a table that was already initialized elsewhere.
--- We are not redefining TRP3_API.loc, but IntelliJ thinks so
---@type TRP3_API
local TRP3_API = {}
TRP3_API.loc = {

	NEW_EXTENDED_VERSION = "|cffff9900A new version for TRP3:Extended is available (%s). |cff00ff00Go check it out on Curse!",

-- MISC
	EX_SOUND_HISTORY = "Sounds history",
	EX_SOUND_HISTORY_EMPTY = "No sound has been played.",
	EX_SOUND_HISTORY_LINE = "%s played soundID %s in channel %s.",
	EX_SOUND_HISTORY_STOP = "Stop",
	EX_SOUND_HISTORY_REPLAY = "Replay",
	EX_SOUND_HISTORY_CLEAR = "Clear",
	EX_SOUND_HISTORY_STOP_ALL = "Stop all",
	EX_SOUND_HISTORY_TT = "See what sounds have been played, see where they're from and stop them if they still are playing.\n\n|cffffff00Click:|r Open sound history\n|cffffff00Right-click:|r Stop all sounds/musics",
	BINDING_NAME_TRP3_INVENTORY = "Open character's inventory",
	BINDING_NAME_TRP3_MAIN_CONTAINER = "Open main container",
	BINDING_NAME_TRP3_SEARCH_FOR_ITEMS = "Search for items",
	BINDING_NAME_TRP3_QUESTLOG = "Open TRP3's quest log",
	BINDING_NAME_TRP3_QUEST_LOOK = "Quest action: inspect",
	BINDING_NAME_TRP3_QUEST_LISTEN = "Quest action: listen",
	BINDING_NAME_TRP3_QUEST_ACTION = "Quest action: interact",
	BINDING_NAME_TRP3_QUEST_TALK = "Quest action: talk",
	ERROR_MISSING_ARG = "Missing argument %1$s when trying to call function %2$s.",

-- INVENTORY
	IT_CON = "Container",
	IT_CON_TT = "Container (%d/%d slots used)",
	IT_CON_ERROR_TYPE = "This container can't contain this kind of items.",
	IT_CON_ERROR_TRADE = "You can't drop this container if it's not empty.",
	IT_CON_OPEN = "Open/Close container",
	IT_CON_CAN_INNER = "Can't place a container inside itself!",
	IT_INV_SHOW_ALL = "Show all inventory",
	IT_INV_SHOW_CONTENT = "|cffffff00Click:|r Open main container (if exists)\n|cffffff00Right-click:|r Open inventory",
	IT_INV_ERROR_MAX = "You can't carry any more of %s.",
	IT_INV_ERROR_FULL = "%s is full.",
	IT_INV_ERROR_CANT_HERE = "You can't place items here.",
	IT_INV_ERROR_CANT_DESTROY_LOOT = "You can't destroy loot items.",
	IT_INV_SCAN_MY_ITEMS = "Scan for my items",
	IT_CON_TT_MISSING_CLASS = "Missing item class ID",
	IT_EX_DOWNLOAD = "Download",
	IT_EX_DOWNLOAD_TT = "|cffff9900This item is %s messages long and would take at minimum %.1f seconds to be downloaded (in the best condition).\n\n|cff00ff00Click to requests %s to send you all the data about this item.\n\n|cffff9900You can't finish a trade if you don't have all the updated information about all items you would receive.",
	IT_EX_EMPTY_DRAG = "You can drag and drop items here.",
	IT_EX_EMPTY = "Nothing to trade",
	IT_EX_SLOT_DOWNLOAD = "|rYou don't have the information about this item.\n\n|cff00ff00If the item is not too large, TRP3 will download it automatically from %s.\n\n|cffff9900If it is too large, you can manually request its information with the download button, but keep in mind that it could take some time to be downloaded.",
	IT_EX_DOWNLOADING = "Downloading: %0.1f %%",
	IT_LOOT_ERROR = "Can't display loot right now, another loot is currently shown.",
	IT_INV_GOT = "Received: %s x%d",

-- INVENTORY PAGE
	INV_PAGE_CAMERA_CONFIG = "Camera parameters:\n   Rotation: %.2f",
	INV_PAGE_MARKER = "Marker position:\n   x: %.2f\n   y: %.2f",
	INV_PAGE_PLAYER_INV = "%s's inventory",
	INV_PAGE_CHARACTER_INV = "Inventory",
	INV_PAGE_INV_OPEN = "Open inventory",
	INV_PAGE_LOOT_ALL = "Loot all",
	INV_PAGE_QUICK_SLOT = "Quick slot",
	INV_PAGE_QUICK_SLOT_TT = "This slot will be used as primary container.",
	INV_PAGE_ITEM_LOCATION = "Item location on character",
	INV_PAGE_TOTAL_VALUE = "Total items value",
	INV_PAGE_TOTAL_VALUE_TT = "This is the value of your inventory.\n\nThis is not the amount of \"coins\" but the estimated total value of all items in the inventory.",
	INV_PAGE_CHARACTER_INSPECTION = "Character inspection",
	INV_PAGE_CHARACTER_INSPECTION_TT = "Inspect this character's inventory.",
	INV_PAGE_WEAR_TT = "This item is wearable.\nThe green zone indicates the item location on the character.",
	INV_PAGE_WEAR_ACTION = "Configure item location",
	INV_PAGE_WEAR_ACTION_RESET = "Reset configuration",
	INV_PAGE_SEQUENCE = "Sequence ID",
	INV_PAGE_WAIT = "Waiting for response",
	INV_PAGE_SEQUENCE_TT = "You can change the pose of your character by entering an animation ID here and select the animation frame with the slider below.\n\nWarning: If the animation flickers it's because there is a problem with the animation for your race model. If it happens, please select another animation.",
	INV_PAGE_SEQUENCE_PRESET = "You can select a sequence ID corresponding to an emote.",
	INV_PAGE_EDIT_ERROR1 = "You must be the author of this item to edit it.",
	INV_PAGE_EDIT_ERROR2 = "This item is not in Quick mode.",

-- SEC
	SEC_LEVEL = "Security level",
	SEC_LEVEL_DETAIL = "Click to see a detail of the used unsecure scripts.",
	SEC_LEVEL_DETAIL2 = "Click to see a detail of the used unsecure scripts and configure which one can be executed.",
	SEC_LOW = "Low",
	SEC_LOW_TT = "This item, or one of its related object, uses one or more unsecure scripts that can have malicious effects.",
	SEC_MEDIUM = "Medium",
	SEC_MEDIUM_TT = "This item, or one of its related object, uses one or more unsecure scripts that can have undesirable effects.",
	SEC_HIGH = "High",
	SEC_HIGH_TT = "This item and all of its related object are secured and don't use any malicious or undesirable effects.",
	SEC_LEVEL_DETAILS = "Security details",
	SEC_LEVEL_DETAILS_TT = "For %s and all its inner objects.\n|cffff9900Made by: |cff00ff00%s\n|cffff9900Received from: |cff00ff00%s",
	SEC_LEVEL_DETAILS_SECURED = "This object and all its inner objects are secure!",
	SEC_UNSECURED_WHY = "Why is this unsecure?",
	SEC_REASON_SCRIPT = "Lua script",
	SEC_REASON_SCRIPT_WHY = "This object could trigger any of the Extended effects.\n\n|cffff0000It may be used in a malicious way to force you so say something reprehensible by the Blizzard terms of services that can make you banned from the game.\n\n|cff00ff00If blocked, the code will still be executed but in a secured environment (for instance, chat effects will be printed only for you and not said by your character).",
	SEC_REASON_TALK = "Character talk",
	SEC_REASON_TALK_WHY = "This object could force your character to say something (through /say, /yell or any other channel).\n\n|cffff0000It may be used in a malicious way to force you so say something reprehensible by the Blizzard terms of services that can make you banned from the game.\n\n|cff00ff00If blocked, the text will be printed only for you (and not said by your character).",
	SEC_REASON_SOUND = "Playing a sound",
	SEC_REASON_SOUND_WHY = "This object could play a sound or a music that will be heard by the TRP3:E users around you.\n\n|cffff9900It may be undesirable for them if the sound is spammed or if the sound is particulary annoying. And if it's the case, they could blame you and block you.\n\n|cff00ff00If blocked, the sound/music will be played only for you.",
	SEC_REASON_DISMOUNT = "Dismount",
	SEC_REASON_DISMOUNT_WHY = "This object could force you to unmount.\n\n|cffff9900It may be undesirable for you... Especially if you are on a flying mount!",
	SEC_LEVEL_DETAILS_THIS = "Switch security for this objects",
	SEC_LEVEL_DETAILS_THIS_TT = "Accept the execution of this effect for this object only.",
	SEC_LEVEL_DETAILS_ALL = "Switch security for all objects",
	SEC_LEVEL_DETAILS_ALL_TT = "Accept the execution of this effect for all objects, now and in the future.",
	SEC_LEVEL_DETAILS_BLOCKED = "Blocked",
	SEC_LEVEL_DETAILS_ACCEPTED = "Accepted",
	SEC_LEVEL_DETAILS_FROM = "Always accept when received from %s",
	SEC_EFFECT_BLOCKED = "Effect(s) blocked",
	SEC_EFFECT_BLOCKED_TT = "Due to your current security settings, at least one of this item (or sub-objects) effects has been secured.\n\n|cffff9900Click to review security for this item.\n\nYou can also Ctrl+Right-click on the item in your inventory to configure the security later.",
	SEC_MISSING_SCRIPT = "Cannot find workflow \"%s\"",
	SEC_SCRIPT_ERROR = "Error in workflow %s.",
	SEC_TT_COMBO = "Alt + Right click:|cffff9900 Configure security",
	SET_TT_SECURED = "Some potentially malicious effects have been secured for your safety.\n|cff00ff00Alt + Right click for more details.",
	SET_TT_DETAILS_1 = "Hold Alt key to show more",
	SET_TT_DETAILS_2 = "%s warning(s)",
	SET_TT_OLD = "This item has been created with an older version of Extended (v %s). Incompatibilities may occured.",

-- LOOT
	LOOT = "Loot",
	LOOT_CONTAINER = "Loot container",
	LOOT_DISTANCE = "You moved too far from the loot point.",

-- DOCUMENT
	DOC_UNKNOWN_ALERT = "Can't open the document. (Missing class)",
	DO_PAGE_FIRST = "First page",
	DO_PAGE_NEXT = "Next page",
	DO_PAGE_LAST = "Last page",
	DO_PAGE_PREVIOUS = "Previous page",
	DO_EMPTY = "Empty document",

-- Campaign
	QE_CAMPAIGN = "Campaign",
	QE_CAMPAIGNS = "Campaigns",
	QE_CAMPAIGN_LIST = "%s available campaigns",
	QE_CAMPAIGN_START = "Starting campaign |cff00ff00[%s]|r.",
	QE_CAMPAIGN_START_BUTTON = "Start or resume campaign",
	QE_CAMPAIGN_RESUME = "Resuming campaign |cff00ff00[%s]|r.",
	QE_CAMPAIGN_RESET = "Reset campaign",
	QE_CAMPAIGN_PAUSE = "Pausing current campaign.",
	QE_CAMPAIGN_CURRENT = "Current campaign",
	QE_CAMPAIGN_CURRENT_NO = "No active campaign.",
	QE_CAMPAIGN_UNSTARTED = "You haven't started this campaign yet.\nClick on the top right \"Start\" button to start it.",
	QE_CAMPAIGN_NOQUEST = "No quest revealed yet for this campaign.\nTake a look at the campaign description to unlock your first quest.",
	QE_CAMPAIGN_EMPTY = "This campaign has no quest.",
	QE_QUEST_START = "Starting quest |cff00ff00[%s]|r.",
	QE_QUEST_TT_STEP = "|cffffff00Currently:|r\n\"%s\"",
	QE_QUEST_OBJ_AND_HIST = "Objectives and history",
	QE_QUEST = "Quest",
	QE_QUESTS = "Quests",
	QE_QUEST_OBJ_REVEALED = "|cffffff00New objective: |cff00ff00%s",
	QE_QUEST_OBJ_UPDATED = "|cffffff00Objective updated: |cff00ff00%s",
	QE_QUEST_OBJ_FINISHED = "|cffffff00Objective complete: |cff00ff00%s",
	QE_QUEST_LIST = "Quests for this campaign",
	QE_STEP = "Step",
	QE_STEP_LIST = "Steps for this quest",
	QE_STEP_LIST_CURRENT = "Available quests",
	QE_STEP_LIST_FINISHED = "Finished quests",
	QE_STEP_MISSING = "Missing step information.",
	QE_BUTTON = "Open quest log",
	QE_NPC = "Campaign NPC",
	QE_RESET_CONFIRM = "Reset this campaign?\n\nThis will lose all your progression for ALL the quests in this campaign.\n\nNote that you will keep all items you gained through this campaign.",
	QE_AUTORESUME_CONFIRM = "An effect was called for the campaign |cff00ff00[%s]|r.\n\nActivate this campaign ?\n(If you already have an active campaign, it will be paused and your progress will be saved.)",
	QE_ACTIONS_TYPE_LOOK = "Inspect",
	QE_ACTIONS_TYPE_TALK = "Talk",
	QE_ACTIONS_TYPE_LISTEN = "Listen",
	QE_ACTIONS_TYPE_INTERRACT = "Interact",
	QE_NOACTION_LOOK = "You don't see anything special.",
	QE_NOACTION_LISTEN = "You don't hear anything special.",
	QE_NOACTION_ACTION = "There is nothing to do.",
	QE_NOACTION_TALK = "There is nothing to say.",
	QE_PREVIOUS_STEP = "Previously",
	QE_OVERVIEW = "Quest overview",
	QE_COMPLETED = "Completed",
	QE_FAILED = "Failed",
	QE_NEW = "New quest revealed",
	QE_ACTION = "Quest action",
	QE_MACRO = "Create macro",
	QE_MACRO_TT = "Creates a macro for this action type and pickup the macro on your cursor to be placed in any action bars.",
	QE_MACRO_MAX = "You can't have more macro. Please free a macro slot before trying again.",
	QE_PROGRESS = "Campaign progression",
	DI_NEXT = "Next",
	DI_WAIT_LOOT = "Please loot all items",
	QE_ACTION_NO_CURRENT = "You don't have any active campaign. You should activate a campaign before trying to do an action..",
	QE_CAMPAIGN_NO = "No started yet",
	QE_CAMPAIGN_FULL = "Finished",

-- COMMANDS
	COM_NPC_ID = " get targeted npc id",

-- SETTINGS
	UNIT_FRIES = "fries",
	UNIT_POTATOES = "potatoes",
	CONF_MAIN = "Extended settings",
	CONF_UNIT = "Units",
	CONF_UNIT_WEIGHT = "Weight unit",
	CONF_UNIT_WEIGHT_TT = "Defines how weight values are displayed.",
	CONF_UNIT_WEIGHT_1 = "Grams",
	CONF_UNIT_WEIGHT_2 = "Pounds",
	CONF_UNIT_WEIGHT_3 = "Potatoes",
	CONF_SOUNDS = "Local sounds / musics",
	CONF_SOUNDS_ACTIVE = "Play local sounds",
	CONF_SOUNDS_ACTIVE_TT = "Local sounds are sounds played by other players (for example through an item) to a certain range in yards.\n\nTurn this off if you don't want to hear these sounds at all.\n\n|cff00ff00Note that you will never hear sounds from ignored players.\n\n|cff00ff00Note that all sounds are interruptible via the Sound History in the TRP3 shortcuts bar.",
	CONF_SOUNDS_METHOD = "Local sound playback method",
	CONF_SOUNDS_METHOD_TT = "Determine how you will hear a local sound when you are in range.",
	CONF_SOUNDS_METHOD_1 = "Play automatically",
	CONF_SOUNDS_METHOD_1_TT = "If you are in range, it will play the sound/music without asking your permission.",
	CONF_SOUNDS_METHOD_2 = "Ask permission",
	CONF_SOUNDS_METHOD_2_TT = "If you are in range, a link will be placed in the chat frame to ask you confirmation to play the sound/music.",
	CONF_MUSIC_ACTIVE = "Play local musics",
	CONF_MUSIC_ACTIVE_TT = "Local musics are musics played by other players (for example through an item) to a certain range in yards.\n\nTurn this off if you don't want to hear these musics at all.\n\n|cff00ff00Note that you will never hear musics from ignored players.\n\n|cff00ff00Note that all musics are interruptible via the Sound History in the TRP3 shortcuts bar.",
	CONF_MUSIC_METHOD = "Local music playback method",
	CONF_MUSIC_METHOD_TT = "Determine how you will hear a local music when you are in range.",
	CONF_SOUNDS_MAXRANGE = "Playback maximum range",
	CONF_SOUNDS_MAXRANGE_TT = "Set the maximum range (in yards) within which you will hear local sounds/musics.\n\n|cff00ff00Usefull to avoid people playing sounds through the whole contient.\n\n|cffff9900Zero means no limit!",

--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- SPEECH
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	NPC_SAYS = "says",
	NPC_YELLS = "yells",
	NPC_WHISPERS = "whispers",
	NPC_EMOTES = "emotes",

--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- DROP SYSTEM
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	DR_SYSTEM = "Drop system",
	DR_SYSTEM_TT = "Drop / search for items and create / access your stashes.\n\nThe drop system does not work in dungeons/arenas/battlegrounds.",
	DR_POPUP = "Drop here",
	DR_POPUP_ASK = "Total RP 3\n \nSelect what to do with the item:\n%s",
	DR_POPUP_REMOVE = "Destroy",
	DR_POPUP_REMOVE_TEXT = "Destroy this item?",
	DR_SEARCH_BUTTON = "Search for |cff00ff00my|r items",
	DR_SEARCH_BUTTON_TT = "Search for your items in the area within 15 yards.",
	DR_NOTHING = "No items found in this area.",
	DR_DELETED = "Destroyed: %s x%d",
	DR_DROPED = "Droped on the ground: %s x%d",
	DR_RESULTS = "Found %s items",
	DR_STASHES = "Stashes",
	DR_STASHES_CREATE = "Create a stash here",
	DR_STASHES_CREATE_TT = "Create a stash where you stand.",
	DR_STASHES_EDIT = "Edit stash",
	DR_STASHES_REMOVE = "Remove stash",
	DR_STASHES_REMOVE_PP = "Remove this stash?\n|cffff9900All items still inside will be lost!",
	DR_STASHES_NAME = "Stash",
	DR_STASHES_MAX = "max 50 characters",
	DR_STASHES_WITHIN = "|cff00ff00Your|r stashes within 15 yards",
	DR_STASHES_SEARCH = "Search for |cff00ff00players|r stashes",
	DR_STASHES_SEARCH_TT = "Search for stashes from other players in the area within 15 yards.\n\nIt will launch a scan for 3 seconds, stand still!",
	DR_STASHES_SCAN_MY = "Scan for my stashes",
	DR_STASHES_SCAN = "Scan for players stashes",
	DR_STASHES_TOO_FAR = "You are too far from this stash.",
	DR_STASHES_REMOVED = "Stash removed.",
	DR_STASHES_FULL = "This stash is full.",
	DR_STASHED = "Stashed: %s x%d",
	DR_STASHES_FOUND = "Stashes found: %s",
	DR_STASHES_NOTHING = "No stashes found in this area.",
	DR_STASHES_SYNC = "Synchronizing...",
	DR_STASHES_RESYNC = "Resynchronize",
	DR_STASHES_ERROR_SYNC = "Stash is not synced.",
	DR_STASHES_ERROR_OUT_SYNC = "Stash out of sync, please retry.",
	DR_STASHES_DROP = "You can't drop item in someone else's stash.",
	DR_STASHES_HIDE = "Hide from scan",
	DR_STASHES_HIDE_TT = "This stash won't appear on other players map scan.\n\nNote that they will always be able to access it if they know where it is.",

--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- EXTENDED TOOLS
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

-- TOOLBAR BUTTON
	TB_TOOLS = "Extended objects database",
	TB_TOOLS_TT = "Create your own items and quests.",

-- TYPES
	ALL = "All",
	TYPE = "Type",
	TYPE_CAMPAIGN = "Campaign",
	TYPE_QUEST = "Quest",
	TYPE_QUEST_STEP = "Quest step",
	TYPE_ITEM = "Item",
	TYPE_LOOT = "Loot",
	TYPE_DOCUMENT = "Document",
	TYPE_DIALOG = "Cutscene",
	TYPE_ITEMS = "Item(s)",

-- MODES
	MODE_QUICK = "Quick",
	MODE_NORMAL = "Normal",
	MODE_EXPERT = "Expert",

-- DATABASE
	DB = "Database",
	DB_MY = "My database (%s)",
	DB_OTHERS = "Players database (%s)",
	DB_BACKERS = "Backers database (%s)",
	DB_FULL = "Full database (%s)",
	DB_LIST = "Creations list",
	DB_RESULTS = "Search results",
	DB_FILTERS = "Search filters",
	DB_FILTERS_OWNER = "Created by",
	DB_FILTERS_NAME = "Object name",
	DB_ACTIONS = "Actions",
	DB_WARNING = "\n|cffff0000!!! Warning !!!\n\n|cffff9900Don't forget to save your changes before returning to the database list!",
	DB_FILTERS_CLEAR = "Clear",
	DB_BROWSER = "Object browser",
	DB_DELETE_TT = "Removes this object and all its children objects.",
	DB_EXPERT_TT = "Switchs this object to expert mode, allowing more complex customizations.",
	DB_SECURITY_TT = "Shows all security parameters for this object. From there you can allow or prevent certain undesirable effects.",
	DB_ADD_ITEM_TT = "Adds units of this item in your primary container (or main inventory if you don't have any primary container on your character).",
	DB_COPY_ID_TT = "Display the object ID in a popup to be copy/pastable.",
	DB_COPY_TT = "Copy all this object information and child objects to be pastable as inner objects in another object.",
	DB_EXPORT = "Quick export object",
	DB_EXPORT_TT = "Serializes the object content to be exchangeable outside the game.\n\nOnly works on small objects (lesser than 20 kB once serialized). For larger object, use the full export feature.",
	DB_EXPORT_TT_2 = "Serializes the object content to be exchangeable outside the game.\n\n|cffff0000Note: Exporting large object may freeze the game for a few seconds.|r",
	DB_EXPORT_TOO_LARGE = "This object is too large once serialized to be exported this way. Please use the full export feature.\n\nSize: %0.1f kB.",
	DB_EXPORT_HELP = "Code for object %s (size: %0.1f kB)",
	DB_WAGO_INFO = [[|cffff0000New:|r You can now post your quick exports on the WeakAuras sharing website |cff00ff00[<a href="http://wago.io">wago.io</a>]|r !<br/>Paste this export string on their website, add a description, a few screenshots and you will have a nice URL to share with your friends!]],
	DB_IMPORT = "Quick object import",
	DB_IMPORT_TT = "Paste here a previously serialized object",
	DB_IMPORT_TT_WAGO = [[Don't have anything to paste here? The WeakAuras sharing website |cff00ff00[<a href="http://wago.io">wago.io</a>]|r now hosts Total RP 3: Extended creations.
<br/>
You can browse their website for other people's creations and paste them here.]],
	DB_IMPORT_WORD = "Import",
	DB_IMPORT_ERROR1 = "The object could not be deserialized.",
	DB_IMPORT_CONFIRM = "This object was serialized in a different version of Total RP 3 Extended than yours.\n\nImport TRP3E version: %s\nYour TRP3E version: %s\n\n|cffff9900This can lead to incompatibilities.\nContinue the import anyway?",
	DB_IMPORT_VERSION = "You are importing an older version of this object than the version you already have.\n\nImport version: %s\nYour version: %s\n\n|cffff9900Do you confirm you want to downgrade?",
	DB_LOCALE = "Object locale",
	DB_FULL_EXPORT = "Full export",
	DB_FULL_EXPORT_TT = "Make a full export for this object regardless of its size.\n\nThis will trigger a UI reload in order to force the writing of add-on save file.",
	DB_EXPORT_MODULE_NOT_ACTIVE = "Object full export/import: Please enable the totalRP3_Extended_ImpExport add-on first.",
	DB_EXPORT_DONE = "Your object has been exported in the file called |cff00ff00totalRP3_Extended_ImpExport.lua|r in this game directory:\n\nWorld of Warcraft\\WTF\\\naccount\\YOUR_ACCOUNT\\SavedVariables\n\nYou can share this file with your friends!\n\nThey can follow the import process in the |cff00ff00Full Database tab|r.",
	DB_IMPORT_FULL = "Full objects import",
	DB_IMPORT_FULL_TT = "Import the |cff00ff00totalRP3_Extended_ImpExport.lua|r file.",
	DB_IMPORT_EMPTY = "There is no object to import in your |cff00ff00totalRP3_Extended_ImpExport.lua|r file.\n\nThe file must be placed in this game directory |cffff9900prior to the game launch|r:\n\nWorld of Warcraft\\WTF\\\naccount\\YOUR_ACCOUNT\\SavedVariables",
	DB_IMPORT_DONE = "Object successfully imported!",
	DB_BACKERS_LIST = "Credits",

	DB_MY_EMPTY = "You don't have created any object yet.\nUse one of the buttons below to unleash your creativity!",
	DB_OTHERS_EMPTY = "Here will be placed all objects created by other players.",
	DB_CREATE_ITEM = "Create item",
	DB_CREATE_ITEM_TT = "Select a template for a new item",
	DB_CREATE_ITEM_TEMPLATES = "Or select a template",
	DB_CREATE_ITEM_TEMPLATES_QUICK = "Quick creation",
	DB_CREATE_ITEM_TEMPLATES_QUICK_TT = "Quickly creates a simple item without any effect.\nThen adds one unit of this item in your primary bag.",
	DB_CREATE_ITEM_TEMPLATES_DOCUMENT = "Document item",
	DB_CREATE_ITEM_TEMPLATES_DOCUMENT_TT = "An item template with an inner document object.\nUseful to quickly create a book or a scroll.",
	DB_CREATE_ITEM_TEMPLATES_BLANK = "Blank item",
	DB_CREATE_ITEM_TEMPLATES_BLANK_TT = "A blank template.\nFor those who like to start from scratch.",
	DB_CREATE_ITEM_TEMPLATES_CONTAINER = "Container item",
	DB_CREATE_ITEM_TEMPLATES_CONTAINER_TT = "A container template.\nContainer can hold other items.",
	DB_CREATE_ITEM_TEMPLATES_FROM = "Create from ...",
	DB_CREATE_ITEM_TEMPLATES_FROM_TT = "Create a copy of an existing item.",
	DB_ADD_ITEM = "Add to main inventory",
	DB_TO_EXPERT = "Convert to expert mode",
	DB_CREATE_CAMPAIGN = "Create campaign",
	DB_CREATE_CAMPAIGN_TT = "Start creating a campaign",
	DB_CREATE_CAMPAIGN_TEMPLATES_BLANK = "Blank campaign",
	DB_CREATE_CAMPAIGN_TEMPLATES_BLANK_TT = "A blank template.\nFor those who like to start from scratch.",
	DB_CREATE_CAMPAIGN_TEMPLATES_FROM = "Create from ...",
	DB_CREATE_CAMPAIGN_TEMPLATES_FROM_TT = "Create a copy of an existing campaign.",
	DB_REMOVE_OBJECT_POPUP = "Please confirm the removal of the object:\nID: |cff00ffff\"%s\"|r\n|cff00ff00[%s]|r\n\n|cffff9900Warning: This action cannot be reverted!.",
	DB_ADD_COUNT = "How many units of %s do you want to add to your inventory?",
	DB_IMPORT_ITEM = "Import item",
	DB_HARD_SAVE = "Hard save",
	DB_HARD_SAVE_TT = "Reload the game UI in order to force saved variables to be written on the disk.",
	DB_IMPORT_FULL_CONFIRM = "Do you want to import the following object?\n\n%s\n%s\nBy |cff00ff00%s|r\nVersion %s",

-- Creation
	ROOT_TITLE = "Root object",
	ROOT_ID = "Object ID",
	ROOT_GEN_ID = "Generated ID",
	ROOT_VERSION = "Version",
	ROOT_CREATED = "Created by %s on %s",
	ROOT_CREATED_BY = "Created by",
	ROOT_CREATED_ON = "Created on",
	ROOT_SAVED = "Last modification by %s on %s",
	SPECIFIC_INNER_ID = "Inner ID",
	SPECIFIC_PATH = "Root path",
	SPECIFIC_MODE = "Mode",
	SPECIFIC = "Specific object",
	ITEM_ID = "Item ID",
	QUEST_ID = "Quest ID",

-- Editor common
	EDITOR_MORE = "More",
	EDITOR_PREVIEW = "Preview",
	EDITOR_ICON_SELECT = "Click to select an icon.",
	EDITOR_NOTES = "Free notes",
	EDITOR_MAIN = "Main",
	EDITOR_CONFIRM = "Confirm",
	EDITOR_SAVE_TT = "Save all changes to the whole object %s (root object and all inner objects) and automatically increments the version number.",
	EDITOR_CANCEL_TT = "Cancel all changes to the whole object %s (root object and all inner objects).\n\n|cffff9900Unsaved changes will be lost!",
	EDITOR_ID_COPY = "Copy ID",
	EDITOR_ID_COPY_POPUP = "You can copy the object ID below if you need to paste it somewhere.",
	EDITOR_WARNINGS = "There are %s warnings.\n\n|cffff9900%s|r\n\nSave anyway?",
	EDITOR_TOP = "Top",
	EDITOR_BOTTOM = "Bottom",
	EDITOR_WIDTH = "Width",
	EDITOR_HEIGHT = "Height",
	EDITOR_ICON = "Select icon",

-- Item creation
	IT_CAST = "Casting",
	IT_NEW_NAME = "New item",
	IT_NEW_NAME_CO = "New container",
	IT_QUICK_EDITOR = "Quick item creation",
	IT_QUICK_EDITOR_EDIT = "Quick item edition",
	IT_CONVERT_TO_NORMAL = "Convert to normal mode",
	IT_CONVERT_TO_NORMAL_TT = "You are in quick mode, an easy first approach to create a simple item.\n\nYou can go further and edit this item in normal mode. This will bring you more possibilities but it's also more complex to learn and use.\n\n|cffff9900Warning: if you convert this item to normal mode, you can't revert it back to quick mode.",
	IT_DISPLAY_ATT = "Display attributes",
	IT_GAMEPLAY_ATT = "Gameplay attributes",
	IT_FIELD_QUALITY = "Item quality",
	IT_FIELD_NAME = "Item name",
	IT_FIELD_NAME_TT = "It's your item name, as it will appear on the tooltip or in item links in the chat frame.",
	IT_TT_LEFT = "Tooltip left custom text",
	IT_TT_LEFT_TT = "It's a free text that will be in the tooltip, bellow the item name.\n\n|cff00ff00A good example of information to put there is the item type (Armor, clothe, weapon, potion ...).",
	IT_TT_RIGHT = "Tooltip right custom text",
	IT_TT_RIGHT_TT = "It's a free text that will be in the tooltip, right to the left custom text.\n\n|cff00ff00A good example of information to put there would be a precision of the item type you put in the left custom text.\n\nFor example if you put Armor as left custom text you could precise here Helmet or Gloves.",
	IT_TT_DESCRIPTION = "Tooltip description",
	IT_TT_DESCRIPTION_TT = "It's your item description.\n\n|cff00ff00It shouldn't be a wall of text here, try to stay concise.\n\nIf your item is usable, try to give hints here to how it should be used.",
	IT_TT_REAGENT = "Crafting reagent flag",
	IT_TT_REAGENT_TT = "Shows the \"Crafting reagent\" line in the tooltip.\n\n|cffff7700Like others display attributes, it's just a visual flag and it's not required for your item to really be a crafting reagent.",
	IT_QUEST = "Quest flag",
	IT_QUEST_TT = "Adds a marker to the item icon to indicates that using this item should start a quest.\n\n|cffff7700Like others display attributes, it's just a visual flag and it's not required for your item to really be able to start a quest.",
	IT_TT_VALUE = "Item value",
	IT_TT_VALUE_FORMAT = "Item value (in %s)",
	IT_TT_VALUE_TT = "This value will be informed on the tooltip extension (hold Alt) or during transactions.\n\n|cffff7700If you think that this item is invaluable, please leave 0. Zero doesn't mean that is has no value, it means that the value is undefined.",
	IT_TT_WEIGHT = "Item weight",
	IT_TT_WEIGHT_FORMAT = "Item weight (in grams)",
	IT_TT_WEIGHT_TT = "The weight influence the total weight of the container.\n\n|cffff7700Please enter the value in GRAMS, as it will be converted to the user selected unit on display.",
	IT_SOULBOUND_TT = "This item will be bound to the player when put on his inventory and cannot be exchanged or dropped on the ground.",
	IT_UNIQUE_TT = "When active, the maximum item units that can be possessed by a character will be limited.",
	IT_UNIQUE_COUNT = "Max units",
	IT_UNIQUE_COUNT_TT = "Sets the maximum units that a character can possessed. Should be greater than 0.",
	IT_CRAFTED = "Crafted",
	IT_CRAFTED_TT = "A crafted item will display in the tooltip the name of the player who crafted it. The player who craft the item is the player making the action of creating one instance of this item, manually or through a workflow.",
	IT_STACK = "Stackable",
	IT_STACK_TT = "Allow units for this item to be stacked in a same container slot.",
	IT_STACK_COUNT = "Max units per stack",
	IT_STACK_COUNT_TT = "Sets the maximum units that can be stacked in a same container slot. Should be greated than 1.",
	IT_USE = "Usable",
	IT_ON_USE = "On use",
	IT_ON_USE_TT = "This workflow will be triggered when the player uses this item.\n\n|cffff9900Note:|r If you want to have more workflows for this item, you can convert it to Expert mode through the Databases view (by right-clicking on it and select |cff00ff00Convert to Expert mode|r).",
	IT_USE_TT = "Allow this item to be usable.\n\n|cff00ff00You can configure the item use effect in the 'Workflow' tab of this editor.",
	IT_USE_TEXT = "Usage text",
	IT_USE_TEXT_TT = "This text, explaining the effect for using this item, will appears in the tooltip.",
	IT_WEARABLE = "Wearable",
	IT_WEARABLE_TT = "Enables this item for the inspection feature and allows you to precisely place it on your character.\n\n|cffff9900If this flag is checked people will be able to see this item on your inventory if they inspect you, even if you don't configure the item position.",
	IT_CONTAINER_TT = "Sets this item to be a container. Container can hold other items.\n\n|cff00ff00The container can be configured in the 'Container' tab of this editor.",
	IT_CO_DURABILITY = "Durability",
	IT_CO_DURABILITY_TT = "Determine the overall max health for your container. A container can lose health over time or can be damaged. But it can also be repaired with the proper items.\n\n|cff00ff00Zero means invulnerable.",
	IT_CO_MAX = "Max weight (in grams)",
	IT_CO_MAX_TT = "This sets the limit of weight from where your container will start losing health over time due to overweight.\n\n|cff00ff00Zero means no limit.\n\n|cffff9900Please enter the max weight in GRAMS.",
	IT_CO_SIZE = "Container size",
	IT_CO_SIZE_COLROW = "%s |1row;rows; by %s columns",
	IT_DOC_ACTION = "Read document",
	IT_WARNING_1 = "Shouldn't make an item both stackable and craftable. (%s)",
	IT_WARNING_2 = "Shouldn't make a stackable container. (%s)",
	IT_CO_ONLY_INNER = "Can only contain inner items",
	IT_CO_ONLY_INNER_TT = "Marks this container to be able to contain only children items from the same root object.\n\nAs for now, only container with this option enabled can be traded while containing items.",
	IT_TRIGGER_ON_USE = "On use",
	IT_TRIGGER_ON_USE_TT = "Triggered each time the player use this item.\n\n|cff00ff00Don't forget to make your item usable in the main tab.",
	IT_TRIGGER_ON_DESTROY = "On stack destroy",
	IT_TRIGGER_ON_DESTROY_TT = "Triggered when the player destroy a stack of this item (drags & drops it out of his inventory and confirms the destruction).|cffff9900\n\nIt is triggered once per stack, and just before the actual stack destruction (so counting the item units in inventory in this workflow will still count the stack).",
	IT_NO_ADD = "Prevent manual adding",
	IT_NO_ADD_TT = "Prevent the player to manually adding the item to his inventory. Then it can only be added or looted through workflows.",
	IT_PU_SOUND = "Pick up sound",
	IT_PU_SOUND_1183 = "Bag",
	IT_PU_SOUND_1184 = "Book",
	IT_PU_SOUND_1185 = "Cloth",
	IT_PU_SOUND_1186 = "Food",
	IT_PU_SOUND_1187 = "Herb",
	IT_PU_SOUND_1188 = "Chain",
	IT_PU_SOUND_1189 = "Meat",
	IT_PU_SOUND_1190 = "Metal large",
	IT_PU_SOUND_1191 = "Metal small",
	IT_PU_SOUND_1192 = "Paper",
	IT_PU_SOUND_1193 = "Ring",
	IT_PU_SOUND_1194 = "Rock",
	IT_PU_SOUND_1195 = "Small chain",
	IT_PU_SOUND_1196 = "Wand",
	IT_PU_SOUND_1197 = "Liquid",
	IT_PU_SOUND_1198 = "Wood small",
	IT_PU_SOUND_1199 = "Wood large",
	IT_PU_SOUND_1221 = "Gems",
	IT_DR_SOUND = "Drop sound",

-- Documents
	DO_NEW_DOC = "Document",
	DO_PREVIEW = "Click to see a preview",
	DO_PARAMS_GLOBAL = "Default parameters",
	DO_PARAMS_GLOBAL_TT = "Change the document default parameters. These parameters will be used for all pages that does not use custom page parameters.",
	DO_PARAMS_CUSTOM = "Page custom parameters",
	DO_PAGE_MANAGER = "Pages manager",
	DO_PAGE_EDITOR = "Page editor: page %s",
	DO_PAGE_HEIGHT = "Page height",
	DO_PAGE_HEIGHT_TT = "The page height, in pixel. Please note that certain background support only a certain height/width ratio and can be deformed.",
	DO_PAGE_WIDTH = "Page width",
	DO_PAGE_WIDTH_TT = "The page width, in pixel. Please note that certain background support only a certain height/width ratio and can be deformed.",
	DO_PAGE_FONT = "%s font",
	DO_PAGE_BORDER = "Border",
	DO_PAGE_BORDER_1 = "Parchment",
	DO_PAGE_TILING = "Background tiling",
	DO_PAGE_TILING_TT = "Sets if the background will tile vertically and horizontally. If not, the texture will be stretched.",
	DO_PAGE_RESIZE = "Resizable",
	DO_PAGE_RESIZE_TT = "Allow the user to resize the frame.\n\n|cffff9900Be sure that your layout can be readable and does not depend on height/width ratio.\n\n|cff00ff00Note that the user will never be able to reduce the frame size below the default width and height.",
	DO_PAGE_REMOVE = "Remove page",
	DO_PAGE_REMOVE_POPUP = "Remove the page %s ?",
	DO_PAGE_ADD = "Add page",
	DO_PAGE_COUNT = "Page %s / %s",
	DO_LINKS_ONOPEN = "On open",
	DO_LINKS_ONOPEN_TT = "Triggered when the document is shown to the player.",
	DO_LINKS_ONCLOSE = "On close",
	DO_LINKS_ONCLOSE_TT = "Triggered when the document is closed by the player or another event (e.g. through a workflow effect)",

-- Workflows
	WO_WORKFLOW = "Workflows",
	WO_NO = "No workflows",
	WO_EXECUTION = "Workflow execution",
	WO_EMPTY = "You can start by adding an element to your workflow.\nThis can be an effect, a condition or a delay.",
	WO_ELEMENT_ADD = "Add element to workflow",
	WO_ELEMENT_COPY = "Copy element content",
	WO_ELEMENT_PASTE = "Paste element content",
	WO_END = "End of workflow",
	WO_ELEMENT = "Element edition",
	WO_ELEMENT_EDIT = "Click to edit element",
	WO_ELEMENT_EDIT_RIGHT = "Right-click for more operations",
	WO_ELEMENT_EDIT_CTRL = "Control-click to condition this instruction",
	WO_ELEMENT_COND = "Edit effect condition",
	WO_ELEMENT_COND_TT = "Adds a condition to this single effect.",
	WO_ELEMENT_COND_NO = "Remove effect condition",
	WO_EFFECT = "Effect",
	WO_EFFECT_TT = "Plays an effect.\nIt can be playind sounds, displaying text ...etc",
	WO_EFFECT_SELECT = "Select an effect",
	WO_EFFECT_CAT_COMMON = "Common",
	WO_EFFECT_NO_EDITOR = "This effect can't be configured.",
	WO_CONDITION = "Condition",
	WO_CONDITION_TT = "Evaluates a condition.\nStops the workflow if the condition fails.",
	WO_DELAY = "Delay",
	WO_DELAY_TT = "Pauses the workflow.\nCan also be used as a cast and can be interrupt.",
	WO_DELAY_WAIT = "Waits for",
	WO_DELAY_CAST = "Casts for",
	WO_DELAY_SECONDS = "second(s)",
	WO_DELAY_CAST_SOUND = "Cast sound ID",
	WO_DELAY_CAST_SOUND_TT = "A sound ID for a precast sound. You can put a loopable sound here and it will be interrupted in case of cast interruption.\n\n|cff00ff00Examples: 12273, 12361, ...etc.",
	WO_DELAY_CAST_TEXT = "Cast text",
	WO_DELAY_CAST_TEXT_TT = "The text placed on the cast bar.",
	WO_ELEMENT_TYPE = "Select the element type",
	WO_SECURITY = "Security level",
	WO_WO_SECURITY = "Workflow security",
	WO_SECURITY_HIGH = "High",
	WO_SECURITY_HIGH_DETAILS = "This effect is secured and will not prompt security warning.",
	WO_SECURITY_NORMAL = "Medium",
	WO_SECURITY_NORMAL_DETAILS = "This effect is secured but could cause inconveniences. It will prompt security warning, based on the user security settings.",
	WO_SECURITY_LOW = "Low",
	WO_SECURITY_LOW_DETAILS = "This effect is not secured and could be malicious. It will prompt security warning and will ask for confirmation, based on the user security settings.",
	WO_EXPERT = "Expert mode",
	WO_EXPERT_TT = "A workflow is a set of instructions that can make your object dynamic.\n\nHere you can define all your workflows for this object, then you can link them to an action in the event links tab.",
	WO_EXPERT_DONE = "Switched %s to expert mode. Now unleash your creativity!",
	WO_ADD = "Create workflow",
	WO_ADD_ID = "|cff00ff00Enter the workflow ID.|r\n\nIt's an internal ID to help you manage your workflows and won't be visible by the user.\n\nPlease note that you can't have two workflows with the same ID within the same object.",
	WO_ADD_ID_NO_AVAILABLE = "This workflow ID is not available.",
	WO_REMOVE_POPUP = "Delete the workflow %s?",
	WO_LINKS = "Event links",
	WO_EVENT_LINKS = "Object event links",
	WO_ACTIONS_LINKS = "Action links",
	WO_ACTIONS_LINKS_TT = "Here you can link your workflows to player quest actions.\nThese actions are: |cff00ff00Interact, listen, talk and inspect.|r\nEach link can be conditioned.",
	WO_LINKS_TRIGGERS = "Here you can link your workflows to specifics events for this object.",
	WO_LINKS_NO_LINKS = "No link",
	WO_LINKS_NO_LINKS_TT = "Does not link this action/event to a workflow.",
	WO_LINKS_SELECT = "Select a workflow to link",
	WO_LINKS_TO = "Linked to workflow",
	WO_CONTEXT = "Context",
	WO_CONTEXT_TT = "The workflow context determines which effects can be used in the workflow.",
	WO_COMMON_EFFECT = "Common effects",
	WO_EXPERT_EFFECT = "Expert effects",
	WO_COPY = "Copy workflow content",
	WO_PASTE = "Paste workflow content",
	WO_PASTE_CONFIRM = "Replace this workflow content with the one you copied earlier?",
	WO_EVENT_EX_LINKS = "Game event links",
	WO_EVENT_EX_LINKS_TT = "Here you can link your workflows to game events.\nEach link can be conditioned.",
	WO_EVENT_EX_LINK = "Game event link",
	WO_EVENT_EX_ADD = "Add event link",
	WO_EVENT_EX_NO = "No event link",
	WO_EVENT_EX_EDITOR = "Event link editor",
	WO_EVENT_EX_CONDI = "Event link condition editor",
	WO_EVENT_ID = "Event ID",
	WO_EVENT_ID_TT = "The event ID.\n\nYou can see the whole events list on websites like wowwiki of wowpedia.\n\nHere as an example, PLAYER_REGEN_DISABLED is triggered when you enter a combat.",

-- Delay editor
	WO_DELAY_DURATION = "Duration",
	WO_DELAY_DURATION_TT = "The duration for this delay, in seconds.",
	WO_DELAY_TYPE = "Delay type",
	WO_DELAY_TYPE_1 = "Regular delay",
	WO_DELAY_TYPE_1_TT = "Simply pauses the workflow, without showing any specific information to the player.",
	WO_DELAY_TYPE_2 = "Cast",
	WO_DELAY_TYPE_2_TT = "Show a casting bar during the workflow pause.",
	WO_DELAY_INTERRUPT = "Interruption",
	WO_DELAY_INTERRUPT_1 = "No interruption",
	WO_DELAY_INTERRUPT_2 = "Interrupt on move",

-- Effects editors
	EFFECT_SCRIPT = "Execute restricted lua script",
	EFFECT_SCRIPT_TT = "Execute a lua script in a restricted safe environment.",
	EFFECT_SCRIPT_SCRIPT = "Lua code",
	EFFECT_SCRIPT_SCRIPT_TT = [[This script will be executed in a safe environment where you can have access to all lua synthax and API (table, string, math...) and the Extended |cff00ff00effect|r function.

|cffff0000You don't have access to the game API here!|r

A custom lua script will always be less efficient than a workflow effect, as it is compiled each time, in opposition to a workflow effect being compiled once.

|cffff9900So keep the script to the minimum and only use this script effect if necessary.]],
	EFFECT_SCRIPT_I_EFFECT = "Insert effect",
	EFFECT_SCRIPT_I_EFFECT_TT = [[Insert an effect function where the cursor is in the code.

The function is in the form of:
|cff00ffffeffect( effectID, args, arg1, arg2, ...);|r
- |cff00ffffEffect ID|r: the effect ID, you can find it by looking at the addon source code.
- |cff00ffffargs|r: The execution arguments: should always be the args variable.
- |cff00ffffEffect arguments argX|r: All effects arguments can be found in the addon source code.

|cffffff00Please always keep the 'args' as second parameters, |rit is needed by the effect function and contains all workflows arguments.

|cff00ff00We won't, for now, heavily document all effect ID and arguments as we consider this effect restricted to users capable of looking at the addon source code. ;)]],
	EFFECT_CAT_SOUND = "Sound and music",
	EFFECT_CAT_SPEECH = "Speech and emotes",
	EFFECT_CAT_CAMPAIGN = "Campaign and quest",
	EFFECT_TEXT = "Display text",
	EFFECT_TEXT_TT = "Displays a text.\nDifferent outputs are possible.",
	EFFECT_TEXT_PREVIEW = "Displayed text",
	EFFECT_TEXT_TEXT = "Text",
	EFFECT_TEXT_TEXT_DEFAULT = "Hello.\nHow are you?",
	EFFECT_TEXT_TEXT_TT = "The text to display.",
	EFFECT_TEXT_TYPE = "Text type",
	EFFECT_TEXT_TYPE_1 = "Chat frame text",
	EFFECT_TEXT_TYPE_2 = "Alert popup",
	EFFECT_TEXT_TYPE_3 = "Raid alert text",
	EFFECT_TEXT_TYPE_4 = "Alert message",
	EFFECT_DISMOUNT = "Dismiss mount",
	EFFECT_DISMOUNT_TT = "Dismount the player from his current mount.",
	EFFECT_DISPET = "Dismiss battle pet",
	EFFECT_DISPET_TT = "Dismiss the currently invoked battle pet.",
	EFFECT_RANDSUM = "Summon random battle pet",
	EFFECT_SUMMOUNT = "Summon a mount",
	EFFECT_SUMMOUNT_TT = "Summon a specific mount, if available.",
	EFFECT_SHEATH = "Toggle weapons sheath",
	EFFECT_SHEATH_TT = "Draw or put up the character weapons.",
	EFFECT_VAR_OBJECT_CHANGE = "Variable operation",
	EFFECT_VAR_OBJECT_CHANGE_TT = "Performs an operation on a variable.\n\n|cffff9900For math operations: If the variable does not exists or can't be cast as a number, it will be initialized at 0.",
	EFFECT_VAR_OPERAND = "Variable dynamic value",
	EFFECT_VAR_OPERAND_TT = "Place a dynamic value in a variable. You have access to all test values from conditions.",
	EFFECT_VAR_OPERAND_CONFIG = "Value configuration",
	EFFECT_VAR_OPERAND_CONFIG_NO = "No configuration for this value",
	EFFECT_VAR = "Variable name",
	EFFECT_SOURCE = "Source",
	EFFECT_SOURCE_V = "Variable source",
	EFFECT_SOURCE_W = "Workflow source",
	EFFECT_SOURCE_WORKFLOW = "Workflow",
	EFFECT_SOURCE_WORKFLOW_TT = "Search the variable in the workflow execution. The scope for this variable is limited to the workflow execution and will be discarded afterward.",
	EFFECT_SOURCE_OBJECT = "Object",
	EFFECT_SOURCE_OBJECT_TT = "Search the variable in the workflow source object.\n\nOnly works if the source object is an item or a campaign/quest/step.\n\nIn the case of a campaign, quest or quest step, the variable will be searched in the campaign level (global for the whole campaign).",
	EFFECT_SOURCE_CAMPAIGN = "Active campaign",
	EFFECT_SOURCE_CAMPAIGN_TT = "Search the variable in the current campaign, if there is a currently active campaign.",
	EFFECT_SOURCE_PARENT = "Parent container",
	EFFECT_SOURCE_PARENT_TT = "Search for the workflow in the parent container item.",
	EFFECT_SOURCE_SLOT = "Item in slot (child)",
	EFFECT_SOURCE_SLOT_TT = "Search the workflow in the item in a specific slot inside the container item. Only works for container item!",
	EFFECT_SOURCE_SLOT_B = "Item in slot (sibling)",
	EFFECT_SOURCE_SLOT_B_TT = "Search the workflow in the item in a specific slot of the same parent container.",
	EFFECT_OPERATION = "Operation",
	EFFECT_OPERATION_TYPE = "Operation type",
	EFFECT_OPERATION_TYPE_INIT = "Init",
	EFFECT_OPERATION_TYPE_INIT_TT = "Initializes the variable to a value, only if the variable does not exist yet.",
	EFFECT_OPERATION_TYPE_SET = "Set",
	EFFECT_OPERATION_TYPE_SET_TT = "Sets the variable to a value, even if the variable has already been initialiazed.",
	EFFECT_OPERATION_TYPE_MULTIPLY = "Multiplication",
	EFFECT_OPERATION_TYPE_ADD = "Addition",
	EFFECT_OPERATION_TYPE_DIV = "Division",
	EFFECT_OPERATION_TYPE_SUB = "Substraction",
	EFFECT_VAR_VALUE = "Variable value",
	EFFECT_OPERATION_VALUE = "Operation value",
	EFFECT_DOC_DISPLAY = "Display document",
	EFFECT_DOC_DISPLAY_TT = "Display a document to the player. If there is already a shown document, it will be replaced.",
	EFFECT_DOC_CLOSE = "Close document",
	EFFECT_DOC_CLOSE_TT = "Close the currently opened document. Do nothing if there is no shown document.",
	EFFECT_SPEECH_NAR = "Speech: Narration",
	EFFECT_SPEECH_NAR_TT = "Plays a narration as a formated emote.\n\n|cff00ff00Has the same effect as playing an emote starting with a || (pipe character). It will be formated in chat for other TRP users.",
	EFFECT_SPEECH_NAR_DEFAULT = "The snow blows white on the mountain tonight ...",
	EFFECT_SPEECH_NAR_TEXT_TT = "Please do not include the leading pipe || character.",
	EFFECT_SPEECH_TYPE = "Speech type",
	EFFECT_SPEECH_NPC = "Speech: NPC",
	EFFECT_SPEECH_NPC_TT = "Plays a npc speech as a formated emote.\n\n|cff00ff00Has the same effect as playing an emote starting with a || (pipe character) with a npc name and a text. It will be formated in chat for other TRP users.",
	EFFECT_SPEECH_NPC_DEFAULT = "Do you want to build a snowman?",
	EFFECT_SPEECH_NPC_NAME = "NPC name",
	EFFECT_SPEECH_NPC_NAME_TT = "The NPC name.",
	EFFECT_SPEECH_PLAYER = "Speech: Player",
	EFFECT_SPEECH_PLAYER_TT = "Makes the player speak, yell or do an /e emote.",
	EFFECT_SPEECH_PLAYER_DEFAULT = "Let the dragon consume you!",
	EFFECT_SOUND_PLAY = "Play",
	EFFECT_SOUND_ID_SELF = "Play sound ID",
	EFFECT_SOUND_ID_SELF_TT = "Plays a sound in a particular channel. Only the player will hear it.",
	EFFECT_SOUND_ID_SELF_PREVIEW = "Plays sound ID %s in channel %s.",
	EFFECT_SOUND_ID_SELF_ID = "Sound ID",
	EFFECT_SOUND_ID_SELF_ID_TT = "The ID is an internal identifier for sounds in the game.\n\n|cff00ff00You can easily find all ID on websites like wowhead.\n\n|cffff9900Note that if the ID points to multiple sub-sounds, a sub-sound will be chosen randomly.",
	EFFECT_SOUND_ID_SELF_CHANNEL = "Channel",
	EFFECT_SOUND_ID_SELF_CHANNEL_SFX = "SFX",
	EFFECT_SOUND_ID_SELF_CHANNEL_SFX_TT = "SFX is for effect sounds. It uses the sound volume game option.\n\nMultiple different SFX sounds can be played simultaneously.",
	EFFECT_SOUND_ID_SELF_CHANNEL_AMBIANCE = "Ambience",
	EFFECT_SOUND_ID_SELF_CHANNEL_AMBIANCE_TT = "Ambience is for ambiant sound. It uses the ambience volume game option\n\nMultiple different ambience sounds can be played simultaneously.\n\n|cffff9900Please do not use this effect to play music as this won't stop the current game music and you would have musics overlaping each other. If you want to play a music use the proper music effect.",
	EFFECT_SOUND_ID_SELF_ID_TT = "The ID is an internal identifier for sounds in the game.\n\n|cff00ff00You can easily find all ID on websites like wowhead.\n\n|cffff9900Leave empty to stop all sounds played on the selected channel.",
	EFFECT_SOUND_MUSIC_SELF = "Play music",
	EFFECT_SOUND_MUSIC_SELF_TT = "Plays a music. Only the player will hear it.\n\nNote that the music will loop until the game plays a music of his own (when entering a zone for example), or until a \"stop music\" effect is played. Also the player can always manually stop the music through the sound history frame.",
	EFFECT_SOUND_MUSIC_SELF_PREVIEW = "Plays music: %s",
	EFFECT_SOUND_MUSIC_SELF_PATH = "Music path",
	EFFECT_SOUND_MUSIC_SELF_PATH_TT = "The music path within the game files.\n\n|cffff9900It must not contains the Sounds\\Music\\ part of the path, nor the .mp3 at the end.",
	EFFECT_SOUND_MUSIC_STOP = "Stop music",
	EFFECT_SOUND_ID_LOCAL = "Play local sound",
	EFFECT_SOUND_ID_LOCAL_TT = "Plays a sound for players around you.",
	EFFECT_SOUND_ID_LOCAL_PREVIEW = "Plays sound ID %s in channel %s in a %s yards radius.",
	EFFECT_SOUND_LOCAL_DISTANCE = "Playback radius",
	EFFECT_SOUND_LOCAL_DISTANCE_TT = "Determine the radius around the player within which other players will hear this sound.",
	EFFECT_SOUND_MUSIC_LOCAL = "Play local music",
	EFFECT_SOUND_MUSIC_LOCAL_TT = "Plays a music for players around you.",
	EFFECT_SOUND_MUSIC_LOCAL_PREVIEW = "Plays music \"%s\" in a %s yards radius.",
	EFFECT_ITEM_BAG_DURABILITY = "Damage/repair container",
	EFFECT_ITEM_BAG_DURABILITY_TT = "Repair or damage the durability of the item parent container.\n\n|cff00ff00Only works on containers having durability.",
	EFFECT_ITEM_BAG_DURABILITY_PREVIEW_1 = "|cff00ff00Repair|cffffff00 parent container for %s durability points.",
	EFFECT_ITEM_BAG_DURABILITY_PREVIEW_2 = "|cffff0000Damage|cffffff00 parent container for %s durability points.",
	EFFECT_ITEM_BAG_DURABILITY_METHOD = "Type",
	EFFECT_ITEM_BAG_DURABILITY_METHOD_HEAL = "Repair",
	EFFECT_ITEM_BAG_DURABILITY_METHOD_HEAL_TT = "Repair the parent container. The parent container health can't exceed the container maximum durability.",
	EFFECT_ITEM_BAG_DURABILITY_METHOD_DAMAGE = "Damage",
	EFFECT_ITEM_BAG_DURABILITY_METHOD_DAMAGE_TT = "Damage the parent container. The parent container health can't be damage below 0.",
	EFFECT_ITEM_BAG_DURABILITY_VALUE = "Durability point",
	EFFECT_ITEM_BAG_DURABILITY_VALUE_TT = "The amount of durability points to add/substract from the parent container health.",
	EFFECT_ITEM_CONSUME = "Consume item",
	EFFECT_ITEM_CONSUME_TT = "Consumes the used item and destroys it.",
	EFFECT_DOC_ID = "Document ID",
	EFFECT_DOC_ID_TT = "The document to show.\n\n|cffffff00Please enter the full document ID (parents ID and inner ID).\n\n|cff00ff00Hint: copy/paste the full ID to be sure to avoid typos.",
	EFFECT_ITEM_ADD = "Add item",
	EFFECT_ITEM_ADD_TT = "Adds items to your bag.",
	EFFECT_ITEM_ADD_PREVIEW = "Adds %sx %s",
	EFFECT_ITEM_ADD_ID = "Item ID",
	EFFECT_ITEM_ADD_ID_TT = "The item to add.\n\n|cffffff00Please enter the full item ID (parents ID and inner ID).\n\n|cff00ff00Hint: copy/paste the full ID to be sure to avoid typos.",
	EFFECT_ITEM_ADD_QT = "Amount",
	EFFECT_ITEM_ADD_QT_TT = "The number of item to add.\n\n|cff00ff00Note that the addon will do his best to reach this amount but it is possible that not all items will be added: for example if the bag becomes full or if the item has a maximum of units the character can have ('Unique' attribute).",
	EFFECT_ITEM_ADD_CRAFTED = "Crafted",
	EFFECT_ITEM_ADD_CRAFTED_TT = "When checked, and if the added items are craftable (have the crafted flag in their display attributes), will display \"Crafted by xxx\" in the items tooltip where xxx will be the player name.",
	EFFECT_ITEM_REMOVE = "Destroy item",
	EFFECT_ITEM_REMOVE_TT = "Destroy items from your inventory.",
	EFFECT_ITEM_REMOVE_PREVIEW = "Destroys %sx %s",
	EFFECT_ITEM_REMOVE_ID_TT = "The item to remove.\n\n|cffffff00Please enter the full item ID (parents ID and inner ID).\n\n|cff00ff00Hint: copy/paste the full ID to be sure to avoid typos.",
	EFFECT_ITEM_REMOVE_QT_TT = "The number of item to remove.",
	EFFECT_ITEM_COOLDOWN = "Start cooldown",
	EFFECT_ITEM_COOLDOWN_TT = "Start a cooldown for this item.",
	EFFECT_COOLDOWN_DURATION = "Cooldown duration",
	EFFECT_ITEM_COOLDOWN_PREVIEW = "Duration: %s second(s)",
	EFFECT_COOLDOWN_DURATION_TT = "The cooldown duration, in seconds.",
	EFFECT_ITEM_SOURCE_ID = "You can select an item ID you want to search, or leave empty if you want to search for all types of items.",
	EFFECT_ITEM_SOURCE_1 = "All inventory",
	EFFECT_ITEM_SOURCE_2 = "Parent container",
	EFFECT_ITEM_SOURCE_3 = "This item",
	EFFECT_ITEM_USE = "Container: item use",
	EFFECT_ITEM_USE_TT = "Use a item in a slot in the container.\n\n|cffff9900Only works if this workflow is triggered by a container.",
	EFFECT_ITEM_USE_PREVIEW = "Use item in slot %s",
	EFFECT_ITEM_WORKFLOW_PREVIEW_P = "Triggers workflow %s in parent container.",
	EFFECT_ITEM_WORKFLOW_PREVIEW_S = "Triggers workflow %s in sibling item in slot %s.",
	EFFECT_ITEM_WORKFLOW_PREVIEW_C = "Triggers workflow %s in child item in slot %s.",
	EFFECT_ITEM_WORKFLOW = "Run item workflow",
	EFFECT_ITEM_WORKFLOW_TT = "Run a workflow on the parent container or on an item in a specific child item (for container only).",
	EFFECT_ITEM_DICE = "Roll dices",
	EFFECT_ITEM_DICE_TT = "They see me rollin', they hating.",
	EFFECT_ITEM_DICE_PREVIEW = "Rollin' %s",
	EFFECT_ITEM_DICE_ROLL = "Roll",
	EFFECT_ITEM_DICE_ROLL_TT = "Enter a roll configuration similar to the /trp3 roll command.\n\n|cff00ff00Example: 1d20, 3d6 ..etc.",
	EFFECT_RUN_WORKFLOW_SLOT = "Slot ID",
	EFFECT_RUN_WORKFLOW_SLOT_TT = "The index of the container slot to trigger. Slots are indexed from top left to bottom right beginning with slot 1.",
	EFFECT_PROMPT = "Prompt for input",
	EFFECT_PROMPT_PREVIEW = "Prompt user for an input to store in variable |cff00ff00%s|r.",
	EFFECT_PROMPT_TT = "Ask the user for an input and store it in a variable. Then optionally trigger a workflow.\n\n|cffff0000WARNING, this effect execution is asynchronous.",
	EFFECT_PROMPT_TEXT = "Popup text",
	EFFECT_PROMPT_TEXT_TT = "The text that will be presented to the user in the input popup.",
	EFFECT_PROMPT_DEFAULT = "Default value",
	EFFECT_PROMPT_DEFAULT_TT = "The default value for the input.",
	EFFECT_PROMPT_VAR = "Variable name",
	EFFECT_PROMPT_VAR_TT = "The name of the variable storing the user input.",
	EFFECT_PROMPT_CALLBACK = "Workflow callback (optional)",
	EFFECT_PROMPT_CALLBACK_TT = "The workflow name to call after the user input.\n\nThis is optional. Leave empty to not use any callback.\n\nIs given, the workflow will be called with the input as workflow variable with the proper name.\n\n|cffffff00Warning: the callback is called even if the player click 'Cancel' in the prompt popup. In that case the variable will be left untouched if it exists.",
	EFFECT_USE_SLOT = "Container slot number",
	EFFECT_USE_SLOT_TT = "The container slots number are assigned from left to right and top to bottom.",
	EFFECT_QUEST_START = "Reveal quest",
	EFFECT_QUEST_START_TT = "Reveal a quest in the quest log.\n\n|cffff9900Only works if the quest is part of the current active campaign.",
	EFFECT_QUEST_START_PREVIEW = "Reveal quest %s.",
	EFFECT_QUEST_START_ID = "Quest ID",
	EFFECT_QUEST_START_ID_TT = "Use the browser to select your quest (the quest must exist before linking it to this effect).\n\nIf your quest does not appear in the browser, save your campaign and try again.",
	EFFECT_QUEST_GOTOSTEP = "Change quest step",
	EFFECT_QUEST_GOTOSTEP_TT = "Change a quest step.\n\n|cffff9900Only works if the quest is part of the current active campaign and that the quest has already been revealed in the quest log.",
	EFFECT_QUEST_GOTOSTEP_ID = "Quest step ID",
	EFFECT_QUEST_GOTOSTEP_ID_TT = "Use the browser to select your quest step (the quest and quest step must exist before linking it to this effect).\n\nIf your quest step does not appear in the browser, save your campaign and try again.",
	EFFECT_QUEST_GOTOSTEP_PREVIEW = "Go to step %s.",
	EFFECT_QUEST_REVEAL_OBJ = "Reveal quest objective",
	EFFECT_QUEST_REVEAL_OBJ_TT = "Reveal a quest objective.\n\n|cffff9900Only works if the quest is part of the current active campaign and that the quest has already been revealed in the quest log.",
	EFFECT_QUEST_REVEAL_OBJ_PREVIEW = "Reveal objective: %s for %s",
	EFFECT_QUEST_OBJ_ID = "Objective ID",
	EFFECT_QUEST_OBJ_ID_TT = "Enter the objective ID. Enter only the objective ID and not the full campaign-quest-objective ID.",
	EFFECT_QUEST_REVEAL_OBJ_DONE = "Complete objective",
	EFFECT_QUEST_REVEAL_OBJ_DONE_TT = "Marks an objective as completed.\n\n|cffff9900Only works if the quest is part of the current active campaign, if the quest has already been revealed in the quest log and if the objective has already been revealed.",
	EFFECT_QUEST_REVEAL_OBJ_DONE_PREVIEW = "Complete objective: %s for %s",
	EFFECT_DIALOG_START = "Start cutscene",
	EFFECT_DIALOG_START_TT = "Start a cutscene. If a cutscene is already played, it will be interrupted and replace by this one.",
	EFFECT_DIALOG_START_PREVIEW = "Start cutscene %s.",
	EFFECT_DIALOG_ID = "Cutscene ID",
	EFFECT_DIALOG_QUICK = "Quick cutscene",
	EFFECT_DIALOG_QUICK_TT = "Generate a quick cutscene with only one step. It will automatically takes the player's target as speaker.",
	EFFECT_ITEM_LOOT = "Show/drop loot",
	EFFECT_ITEM_LOOT_TT = "Displays a loot container to the player or drop loot on the ground where the player is.",
	EFFECT_ITEM_LOOT_PREVIEW_1 = "Drop %s item(s) on the ground.",
	EFFECT_ITEM_LOOT_PREVIEW_2 = "Display loot with %s item(s).",
	EFFECT_ITEM_LOOT_DROP = "Drop items",
	EFFECT_ITEM_LOOT_DROP_TT = "Drops items on the ground instead of presenting a loot frame to the player. The player can then loot the items he wants with the 'search for items' feature.",
	EFFECT_ITEM_LOOT_NAME = "Source name",
	EFFECT_ITEM_LOOT_NAME_TT = "This will be the loot container name.",
	EFFECT_ITEM_LOOT_SLOT = "Click on a slot to configure it.",
	EFFECT_MISSING = "This effect (%s) is unknown and you should remove it.",
	EFFECT_SIGNAL = "Send signal",
	EFFECT_SIGNAL_TT = "Send a signal with an ID and a value to the player's target.\n\nThis signal can be handle by campaign/quest/step game event links through the event |cff00ff00TRP3_SIGNAL|r.",
	EFFECT_SIGNAL_PREVIEW = "|cffffff00Send signal ID:|r %s|cffffff00 with value:|r %s",
	EFFECT_SIGNAL_ID = "Signal ID",
	EFFECT_SIGNAL_ID_TT = "It's the ID of your signal. It can be tested if conditions and workflows triggered by the game event |cff00ff00TRP3_SIGNAL|r.",
	EFFECT_SIGNAL_VALUE = "Signal value",
	EFFECT_SIGNAL_VALUE_TT = "It's the value of your signal. It can be tested if conditions and workflows triggered by the game event |cff00ff00TRP3_SIGNAL|r and inserted as text tags like |cff00ff00${event.2}|r.",
	EFFECT_RUN_WORKFLOW = "Run workflow",
	EFFECT_RUN_WORKFLOW_TT = "Run another workflow. All workflow variables will be passed through the next.",
	EFFECT_RUN_WORKFLOW_PREVIEW = "Run workflow %s in %s.",
	EFFECT_W_OBJECT_TT = "Search for the workflow in the same object.",
	EFFECT_W_CAMPAIGN_TT = "Search for the workflow in the current active campaign.",
	EFFECT_RUN_WORKFLOW_ID = "Workflow ID",
	EFFECT_RUN_WORKFLOW_ID_TT = "The workflow ID you want to run.",
	EFFECT_CAT_CAMERA = "Camera",
	EFFECT_CAT_CAMERA_ZOOM_IN = "Camera zoom in",
	EFFECT_CAT_CAMERA_ZOOM_IN_TT = "Zooms the camera in by a specified distance.",
	EFFECT_CAT_CAMERA_ZOOM_OUT = "Camera zoom out",
	EFFECT_CAT_CAMERA_ZOOM_OUT_TT = "Zooms the camera out by a specified distance.",
	EFFECT_CAT_CAMERA_ZOOM_DISTANCE = "Zoom distance",
	EFFECT_CAT_CAMERA_SAVE = "Save camera",
	EFFECT_CAT_CAMERA_SAVE_TT = "Saves the player's current camera position in one of the 5 save slots available.",
	EFFECT_CAT_CAMERA_LOAD = "Load camera",
	EFFECT_CAT_CAMERA_LOAD_TT = "Sets the player's camera position based on a previously saved position.",
	EFFECT_CAT_CAMERA_SLOT = "Slot number",
	EFFECT_CAT_CAMERA_SLOT_TT = "The index of one of the slots available, 1 to 5.",

-- Inner objects
	IN_INNER = "Inner objects",
	IN_INNER_S = "Inner object",
	IN_INNER_LIST = "Inner object list",
	IN_INNER_HELP_TITLE = "What are inner objects?",
	IN_INNER_ADD = "Add inner object",
	IN_INNER_ADD_NEW = "Create new object",
	IN_INNER_ADD_COPY = "Add copy of existing object",
	IN_INNER_ENTER_ID = "Enter new inner object ID",
	IN_INNER_ENTER_ID_TT = "Inner object ID must be unique within the parent object.\n\n|cffff9900Please only use lower case characters and underscores. Any other character will be converted to underscores.",
	IN_INNER_EMPTY = "No inner objects\n\nYou can add one by using the add button below.",
	IN_INNER_HELP = [[Inner objects are objects stored in a parent object.

We should begin with some examples:
|cffff9900
- You want to create a rifle item with bullets item to charge it. Typically the rifle would be the main object, in which the bullet object would be an inner object for the rifle.

- A mail item opening a document. The document would be an inner object for the mail item.

- Creating quests: any item/document/cutscenes you use in a quest could be inner objects for this quest.

|rThe advantages of using inner objects are multiple:
|cff00ff00
- Inner objects data are really stored inside the parent object data. That mean they share the same version number, and their data are exchanged in the same time as the parent object data.

- You can freely determine the inner object ID, as it will use the parent object ID as prefix. You just can't have two inner objects having the same ID inside the same parent object.

- Using inner objects brings better performances.

- It's easier to manage and navigate through your objects if they are stored in parent objects. You can really see a parent object as a folder in which you store files.

|rSo it's simple: when you want to create an object, always ask yourself if it wouldn't be better to have it as an inner object for another item or a quest.

|cff00ff00Also: document and cutscenes can only be inner objects!]],
	IN_INNER_DELETE_CONFIRM = "Remove the inner object |cff00ffff\"%s\"|r |cff00ff00[%s]|r from the parent object |cff00ff00[%s]|r?\n\n|cffff9900The inner object will be lost.",
	IN_INNER_DELETE_TT = "Remove this inner object from the parent object.",
	IN_INNER_ID_ACTION = "Change ID",
	IN_INNER_ID_COPY = "Copy",
	IN_INNER_ID_COPY_TT = "You can copy your inner object to paste it in any other parent object.",
	IN_INNER_ID = "Please enter a new ID for the inner object |cff00ff00[%s]|r.\n\nOld ID: |cff00ffff\"%s\"|r",
	IN_INNER_NO_AVAILABLE = "This inner ID is not available!",
	IN_INNER_COPY_ACTION = "Copy object content",
	IN_INNER_PASTE_ACTION = "Paste object content",
	IN_INNER_PASTE_CONFIRM = "Replace the content of this inner object with the one you copied earlier?",

-- Operands
	OP_COMP_EQUALS = "is equal to",
	OP_COMP_NEQUALS = "is not equal to",
	OP_COMP_GREATER = "is greater than",
	OP_COMP_GREATER_OR_EQUALS = "is greater than or equal to",
	OP_COMP_LESSER = "is lesser than",
	OP_COMP_LESSER_OR_EQUALS = "is lesser than or equal to",
	OP_UNIT = "Unit type",
	OP_UNIT_PLAYER = "Player",
	OP_UNIT_TARGET = "Target",
	OP_UNIT_NPC = "NPC",
	OP_AND = "AND",
	OP_AND_SWITCH = "Switch to AND",
	OP_OR = "OR",
	OP_OR_SWITCH = "Switch to OR",
	OP_COMPA_SEL = "Comparator selection",
	OP_REMOVE_TEST = "Remove test",
	OP_ADD_TEST = "Add test",
	OP_FAIL = "Failure message",
	OP_FAIL_TT = "This message will be displayed if the condition fails. Leave empty if you don't want to show any message.",
	OP_FAIL_W = "Failure workflow (Expert)",
	OP_FAIL_W_TT = "If this condition fails, this workflow will be called. That's a way for making an 'else' in a condition.\n\n|cffff9900Please note that this feature is performance heavy and should be used with caution. The called workflow must exist in the same object.\n\n|cffff0000Do NEVER, ever, create a cycle in called workflow (e.g. a workflow A calling a workflow B calling again the workflow A), even using delays!",
	OP_UNIT_VALUE = "Unit value",
	OP_UNIT_TEST = "Unit test",
	OP_EVAL_VALUE = "Evaluated value",
	OP_PREVIEW = "Preview value",
	OP_CONFIGURE = "Configure",
	OP_DIRECT_VALUE = "Direct value",
	OP_STRING = "String value",
	OP_NUMERIC = "Numeric value",
	OP_BOOL = "Boolean value",
	OP_BOOL_TRUE = "TRUE",
	OP_BOOL_FALSE = "FALSE",
	OP_CURRENT = "Current value",
	OP_CURRENT_TT = "Prints in the chat frame the evaluation of this operand based on the current situation.",
	OP_OP_UNIT_NAME = "Unit name",
	OP_OP_UNIT_NAME_TT = "|cff00ff00The unit name, as returned by the first parameters of UnitName.\n\n|rWhen used on a player, it could equals |cff00ff00'player'|r or |cff00ff00'player-realm'|r. So if you want to be sure to have the form |cff00ff00'player-realm'|r use the |cff00ff00'Unit ID'|r operand.",
	OP_OP_UNIT_ID = "Unit ID",
	OP_OP_UNIT_ID_TT = "|cff00ff00The unit id in the form |cff00ff00'player-realm'|r, as returned by UnitFullName. Ensure that there is always a realm part.",
	OP_OP_UNIT_NPC_ID = "Unit NPC ID",
	OP_OP_UNIT_NPC_ID_TT = "|cff00ff00The NPC ID, as determined by UnitGUID. Only works with NPC.",
	OP_OP_UNIT_HEALTH = "Unit health",
	OP_OP_UNIT_HEALTH_TT = "|cff00ff00The unit's current amount of health (hit points).",
	OP_OP_UNIT_EXISTS = "Unit exists",
	OP_OP_UNIT_EXISTS_TT = "|cff00ff00Returns whether a unit exists.\n\n|rA unit 'exists' if it can be referenced by the player; e.g. target exists if the player has a target, npc exists if the player is currently interacting with an NPC, etc.",
	OP_OP_UNIT_GUILD = "Unit guild name",
	OP_OP_UNIT_GUILD_TT = "|cff00ff00The unit guild name (if any).",
	OP_OP_UNIT_GUILD_RANK = "Unit guild rank",
	OP_OP_UNIT_GUILD_RANK_TT = "|cff00ff00The guild rank of the unit (if the unit has a guild).",
	OP_OP_UNIT_RACE = "Unit race",
	OP_OP_UNIT_RACE_TT = "|cff00ff00The unit race IN ENGLISH LOWER CASE, as returned by the second arguments of UnitRace.\n\nSo it's Scourge for Undead.",
	OP_OP_UNIT_CLASS = "Unit class",
	OP_OP_UNIT_CLASS_TT = "|cff00ff00The unit class IN ENGLISH LOWER CASE, as returned by the second arguments of UnitClass.",
	OP_OP_UNIT_SEX = "Unit sex",
	OP_OP_UNIT_SEX_TT = "|cff00ff00The unit sex index. 2 = Male, 3 = Female. 1 is for neutral or unknown.\n\n|cffffff00Returned as a STRING.",
	OP_OP_UNIT_FACTION = "Unit faction",
	OP_OP_UNIT_FACTION_TT = "|cff00ff00The unit faction IN ENGLISH LOWER CASE.",
	OP_OP_UNIT_LEVEL = "Unit level",
	OP_OP_UNIT_LEVEL_TT = "|cff00ff00The level of the unit.",
	OP_OP_UNIT_SPEED = "Unit speed",
	OP_OP_UNIT_SPEED_TT = "|cff00ff00The current unit speed in yard per seconds. Walking is 2.5 and running without buff is 7.",
	OP_OP_UNIT_CLASSIFICATION = "Unit classification",
	OP_OP_UNIT_CLASSIFICATION_TT = "|cff00ff00The unit classification IN ENGLISH LOWER CASE. Example: normal, elite, rare, worldboss, minus...\n\nAlways returns normal for players.",
	OP_OP_UNIT_ISPLAYER = "Unit is player",
	OP_OP_UNIT_ISPLAYER_TT = "|cff00ff00Returns whether the unit is a player.",
	OP_OP_UNIT_DEAD = "Unit is dead",
	OP_OP_UNIT_DEAD_TT = "|cff00ff00Returns whether a unit is either dead or a ghost.",
	OP_OP_INV_WEIGHT = "Container total weight",
	OP_OP_INV_WEIGHT_PREVIEW = "Total weight of |cffff9900%s",
	OP_OP_INV_WEIGHT_TT = "|cff00ff00The current total weight of a container (its own weight plus the content).",
	OP_OP_INV_COUNT = "Item units count",
	OP_OP_INV_COUNT_TT = "|cff00ff00The number of units of an item the player possesses in his inventory.\n\nLeave the ID empty to count for all items.",
	OP_OP_INV_COUNT_PREVIEW = "%s units in |cffff9900%s",
	OP_OP_INV_COUNT_ANY = "Any item",
	OP_OP_QUEST_STEP = "Quest current step",
	OP_OP_QUEST_STEP_TT = "Return the current quest step ID. If the quest is not revealed or has no current step, returns nil.",
	OP_OP_QUEST_STEP_PREVIEW = "%s current step",
	OP_OP_QUEST_OBJ = "Quest objective",
	OP_OP_QUEST_OBJ_TT = "Return the completion (true or false) for a quest objective. If the campaign, quest or the objective is not yet revealed, returns false.",
	OP_OP_QUEST_OBJ_PREVIEW = "Objective %s from %s",
	OP_OP_QUEST_NPC = "Unit is campaign NPC",
	OP_OP_QUEST_NPC_TT = "|cff00ff00Returns whether a unit is a customized NPC in the currently active campaign.",
	OP_OP_QUEST_OBJ_ALL = "Quest all objectives",
	OP_OP_QUEST_OBJ_ALL_TT = "Returns whether all possible quest objectives are completed. So all objectives also has to be revealed.",
	OP_OP_QUEST_OBJ_ALL_PREVIEW = "%s all obj. done",
	OP_OP_QUEST_OBJ_CURRENT = "Quest current objectives",
	OP_OP_QUEST_OBJ_CURRENT_TT = "Returns whether all currently revealed quest objectives are completed.",
	OP_OP_QUEST_OBJ_CURRENT_PREVIEW = "%s current obj. done",
	OP_OP_UNIT_DISTANCE_TRADE = "Unit is near (trade)",
	OP_OP_UNIT_DISTANCE_TRADE_TT = "|cff00ff00Returns whether a unit is close enough for trading (11.11 yards).",
	OP_OP_UNIT_DISTANCE_INSPECT = "Unit is near (inspection)",
	OP_OP_UNIT_DISTANCE_INSPECT_TT = "|cff00ff00Returns whether a unit is close enough for inspection (28 yards).",
	OP_OP_CHAR_FACING = "Character facing",
	OP_OP_CHAR_FACING_TT = "Returns the player's orientation (in radians, 0 = north, values increasing counterclockwise).\n\n|cffff9900Indicates the direction the player model is (normally) facing and in which the player will move if he begins walking forward, not the camera orientation.",
	OP_OP_CHECK_VAR = "Variable string value",
	OP_OP_CHECK_VAR_TT = "Returns the value of a variable, |cff00ff00interpreted as a string|r.\n\nIf the variable does not exists or can't be reached, returns the string 'nil'.\n\n|cffff9900As the value depends on runtime, it cannot be previewed.",
	OP_OP_CHECK_VAR_PREVIEW = "|cff00ffff%s:|r %s",
	OP_OP_CHECK_VAR_N_PREVIEW = "|cff00ffff%s: |cffff9900(n)|r %s",
	OP_OP_CHECK_VAR_N = "Variable numeric value",
	OP_OP_CHECK_VAR_N_TT = "Returns the value of a variable, |cff00ff00interpreted as a number|r.\n\nIf the variable does not exists, can't be reached or can't be interpreted as a number, returns 0.\n\n|cffff9900As the value depends on runtime, it cannot be previewed.",
	OP_OP_CHAR_FALLING = "Character is falling",
	OP_OP_CHAR_FALLING_TT = "Returns whether the player's character is currently plummeting to their doom.",
	OP_OP_CHAR_STEALTH = "Character is stealthed",
	OP_OP_CHAR_STEALTH_TT = "Checks if the character is stealthed.",
	OP_OP_CHAR_FLYING = "Character is flying",
	OP_OP_CHAR_FLYING_TT = "Checks if the character is flying.",
	OP_OP_CHAR_MOUNTED = "Character is mounted",
	OP_OP_CHAR_MOUNTED_TT = "Checks if the character is on a mount.",
	OP_OP_CHAR_RESTING = "Character is resting",
	OP_OP_CHAR_RESTING_TT = "Checks if the character is resting. You are resting if you are in an Inn or a Major City like Ironforge or Orgrimmar.",
	OP_OP_CHAR_SWIMMING = "Character is swimming",
	OP_OP_CHAR_SWIMMING_TT = "Checks if the character is swimming. They do not need to be underwater.",
	OP_OP_UNIT_POSITION_X = "Unit x position",
	OP_OP_UNIT_POSITION_X_TT = "Returns the X coordinate of a unit.\n\nOnly works with players.\n\n|cffff9900Does not work in instance/battleground/arena since patch 7.1.",
	OP_OP_UNIT_POSITION_Y = "Unit y position",
	OP_OP_UNIT_POSITION_Y_TT = "Returns the Y coordinate of a unit.\n\nOnly works with players.\n\n|cffff9900Does not work in instance/battleground/arena since patch 7.1.",
	OP_OP_DISTANCE_POINT = "Unit point distance",
	OP_OP_DISTANCE_POINT_TT = "Returns the distance (in yards) between a unit and a point coordinates.\n\nOnly works with players.\n\nReturns 0 if unit doesn't exist.\n\n|cffff9900Does not work in instance/battleground/arena since patch 7.1.",
	OP_OP_DISTANCE_POINT_PREVIEW = "|cff00ff00%s|r distance from |cff00ff00(%s, %s)",
	OP_OP_DISTANCE_X = "X coordinate",
	OP_OP_DISTANCE_Y = "Y coordinate",
	OP_OP_DISTANCE_ME = "Unit distance to player",
	OP_OP_DISTANCE_ME_TT = "Returns the distance (in yards) between a unit and the player.\n\nOnly works with players.\n\nReturns 0 if unit doesn't exist.\n\n|cffff9900Does not work in instance/battleground/arena since patch 7.1.",
	OP_OP_DISTANCE_CURRENT = "Use current position",
	EFFECT_VAR_INDEX = "Argument index",
	EFFECT_VAR_INDEX_TT = "The index of the argument.\n\nSo if you want to check the third argument of an event, enter 3.",
	OP_OP_CHECK_EVENT_VAR = "Event argument string value",
	OP_OP_CHECK_EVENT_VAR_TT = "Checks the n-th argument of the event triggering this condition (if any).\n\nInterpreted as a string.\n\nIf does not exists or can't be interpreted, returns 'nil'.",
	OP_OP_CHECK_EVENT_VAR_N = "Event argument number value",
	OP_OP_CHECK_EVENT_VAR_N_TT = "Checks the n-th argument of the event triggering this condition (if any).\n\nInterpreted as a number.\n\nIf does not exists or can't be interpreted, returns 0.",
	OP_OP_CHECK_EVENT_VAR_PREVIEW = "%s-th event argument |cff00ff00(string)",
	OP_OP_CHECK_EVENT_VAR_N_PREVIEW = "%s-th event argument |cff00ff00(number)",
	OP_OP_RANDOM = "Random",
	OP_OP_RANDOM_TT = "Random number (integer) between two bounds.",
	OP_OP_RANDOM_PREVIEW = "Random number between |cff00ff00%s|r and |cff00ff00%s|r.",
	OP_OP_RANDOM_FROM = "From",
	OP_OP_RANDOM_TO = "To",
	OP_OP_CHAR_ZONE = "Zone name",
	OP_OP_CHAR_ZONE_TT = "The zone name where the character currently is.\n\n|cffff9900Warning: The text depends on the client locale.",
	OP_OP_CHAR_SUBZONE = "Sub-zone name",
	OP_OP_CHAR_SUBZONE_TT = "The sub-zone name where the character currently is.\n\n|cffff9900Warning: The text depends on the client locale.",
	OP_OP_CHAR_MINIMAP = "Minimap text",
	OP_OP_CHAR_MINIMAP_TT = "Returns the minimap zone text.\n\nThe game event \"MINIMAP_ZONE_CHANGED\" is triggered, when the text changes. So you can test it in a game event link in a campaign or a quest.",
	OP_OP_CHAR_CAM_DISTANCE = "Camera distance",
	OP_OP_CHAR_CAM_DISTANCE_TT = "The camera distance from the player. 0 if in first person view.",
	OP_OP_CHAR_ACHIEVEMENT = "Achievement",
	OP_OP_CHAR_ACHIEVEMENT_TT = "Checks if the account has completed the specified achievement.",
	OP_OP_CHAR_ACHIEVEMENT_ID = "Achievement ID",
	OP_OP_CHAR_ACHIEVEMENT_ID_TT = "The numeric ID of the achievement you want to check.",
	OP_OP_CHAR_ACHIEVEMENT_WHO = "Completed by",
	OP_OP_CHAR_ACHIEVEMENT_ACC = "Account",
	OP_OP_CHAR_ACHIEVEMENT_ACC_TT = "Checks if any character from this account has completed the achievement",
	OP_OP_CHAR_ACHIEVEMENT_CHAR = "Character",
	OP_OP_CHAR_ACHIEVEMENT_CHAR_TT = "Checks if the current character has completed the achievement",
	OP_OP_CHAR_ACHIEVEMENT_PREVIEW = "%s completed by |cffff9900%s",
	OP_OP_TIME_HOUR = "Time: Hour",
	OP_OP_TIME_HOUR_TT = "The current hour of the day, server time.",
	OP_OP_TIME_MINUTE = "Time: Minute",
	OP_OP_TIME_MINUTE_TT = "The current minute of the hour, server time.",

-- Test
	COND_EDITOR = "Condition editor",
	COND_EDITOR_EFFECT = "Effect condition editor",
	COND_CONDITIONED = "Conditioned",
	COND_PREVIEW_TEST = "Preview test",
	COND_PREVIEW_TEST_TT = "Prints in the chat frame the evaluation of this test based on the current situation.",
	COND_TESTS = "Condition tests",
	COND_COMPLETE = "Complete logical expression",
	COND_TEST_EDITOR = "Test editor",
	COND_LITT_COMP = "All comparison types",
	COND_NUM_COMP = "Numeric comparison only",
	COND_NUM_FAIL = "You must have two numeric operands if you uses a numeric comparator.",

-- Campaign and quests
	CA_NPC = "Campaign NPC list",
	CA_NPC_TT = "You can customize NPCs to give them a name, an icon and a description.\nThis customization will be visible when the player has your campaign as active.",
	CA_NPC_ADD = "Add customized NPC",
	CA_NPC_UNIT = "Customized NPC",
	CA_NPC_ID = "NPC ID",
	CA_NPC_AS = "Duplicate",
	CA_NPC_NAME = "Default NPC name",
	CA_NPC_REMOVE = "Remove customization for this NPC?",
	CA_NPC_ID_TT = "Please enter the ID of the NPC to customize.\n\n|cff00ff00To get the ID of an NPC you targeted, type this command in the chat: /trp3 getID",
	CA_NPC_EDITOR = "NPC editor",
	CA_NPC_EDITOR_NAME = "NPC name",
	CA_NPC_EDITOR_DESC = "NPC description",
	CA_NO_NPC = "No customized NPC",
	CA_NAME_NEW = "New campaign",
	CA_NAME = "Campaign name",
	CA_NAME_TT = "This is the name of your campaign. It appears on the quest log.",
	CA_ICON = "Campaign icon",
	CA_ICON_TT = "Select campaign icon",
	CA_DESCRIPTION = "Campaign summary",
	CA_DESCRIPTION_TT = "This brief summary will be visible on the campaign page, in the quest log.",
	QE_QUESTS_HELP = "You can add quests to your campaign here. Please note that a quest is not automatically added to the player's quests log when he starts your campaign. You have to start the quests through workflows.\n|cffff9900Quests are sorted by ID in the quest log, not by name nor by reveal order.",
	CA_QUEST_ADD = "Add quest",
	CA_QUEST_REMOVE = "Remove this quest?",
	CA_QUEST_NO = "No quest",
	CA_QUEST_EXIST = "There is already a quest with the ID %s.",
	QE_NAME_NEW = "New quest",
	CA_QE_ID = "Change quest ID",
	CA_QUEST_CREATE = "Please enter the quest ID. You can't have two quests with the same ID within the same campaign.\n\n|cffff9900Please note that the quests will be listed in alphabetical order of IDs in the quest log.\n\n|cff00ff00So it's a good practice to always start your ID by quest_# where # is the quest number in the campaign.",
	CA_LINKS_ON_START = "On campaign start",
	CA_LINKS_ON_START_TT = "Triggered |cff00ff00once|r when the player start your campaign, so activating your campaign for the first time, or reset it in the quest log.\n\n|cff00ff00This is a good place to activate your first quest.",
	CA_IMAGE = "Campaign portrait",
	CA_IMAGE_TT = "Select campaign portrait",
	QE_STEPS = "Quest steps",
	QE_NAME = "Quest name",
	QE_NAME_TT = "It's your quest name, as it will appear on the quest log.",
	QE_DESCRIPTION = "Quest summary",
	QE_DESCRIPTION_TT = "This brief summary will be visible on the quest page, in the quest log.",
	QE_LINKS_ON_START = "On quest start",
	QE_LINKS_ON_START_TT = "Triggered |cff00ff00once|r when the player start your quest, by unlocking it in the quest log.\n\n|cff00ff00This is a good place to go to the first quest step.",
	QE_LINKS_ON_OBJECTIVE = "On objective completed",
	QE_LINKS_ON_OBJECTIVE_TT = "Triggered each time the player complete an objective for this quest.\n\n|cff00ff00It's a good place to check if all objectives has been completed and reveal the next quest.",
	CA_ACTIONS_ADD = "Add action",
	CA_ACTIONS_NO = "No action",
	CA_ACTIONS = "Actions",
	CA_ACTIONS_EDITOR = "Action editor",
	CA_ACTION_CONDI = "Action condition editor",
	CA_ACTION_REMOVE = "Remove this action?",
	CA_ACTIONS_SELECT = "Select action type",
	CA_ACTIONS_COND = "Edit condition",
	CA_ACTIONS_COND_REMOVE = "Remove condition",
	CA_ACTIONS_COND_ON = "This action is conditioned.",
	CA_ACTIONS_COND_OFF = "This action is not conditioned.",
	QE_AUTO_REVEAL = "Auto reveal",
	QE_AUTO_REVEAL_TT = "Reveal the quest in the quest log when the campaign is started.",
	QE_OBJ = "Quest objectives",
	QE_OBJ_SINGULAR = "Quest objective",
	QE_OBJ_TT = "Quest objectives are hints for the player. Accomplishing all objectives does not automatically complete the quest. You decide when objectives are shown so you can have secret objective in your quest.\n|cffff9900Objectives are always ordered by ID in the quest log, and not following their reveal order.",
	QE_OBJ_ADD = "Add objective",
	QE_OBJ_REMOVE = "Remove this quest objective?",
	QE_OBJ_NO = "No quest objective",
	QE_OBJ_ID = "Objective ID",
	QE_OBJ_ID_TT = "This is your objective ID. You can't have two objectives with the same ID in a same quest.",
	QE_OBJ_TEXT = "Objective text",
	QE_OBJ_AUTO = "Auto reveal",
	QE_OBJ_AUTO_TT = "Automatically reveal this objective when the quest is unlocked in the quest log.",
	QE_STEP = "Quest steps",
	QE_STEP_TT = "Quest are cut down into a list of steps.\nEach step can add a text entry to the quest log once reached and another history text once completed.",
	QE_STEP_ADD = "Add quest step",
	QE_STEP_NO = "No quest step",
	QE_STEP_REMOVE = "Remove this step?",
	QE_STEP_CREATE = "Please enter the step ID. You can't have two steps with the same ID within the same quest.\n\n|cffff9900Please note that the steps will be listed in alphabetical order of IDs here and on the database.\n\n|cff00ff00So it's a good practice to always start your ID by step_# where # is the step number in the quest.",
	CA_QE_ST_ID = "Change quest step ID",
	QE_STEP_EXIST = "There is already a step with the ID %s.",
	QE_STEP_NAME_NEW = "New quest step",
	QE_ST_PRE = "Quest log entry",
	QE_ST_POST = "Quest log history",
	QE_ST_AUTO_REVEAL = "Initial step",
	QE_ST_AUTO_REVEAL_TT = "Marks this step as the initial step when unlocking the quest in the quest log.",
	QE_ST_LINKS_ON_START = "On quest step start",
	QE_ST_LINKS_ON_START_TT = "Triggered |cff00ff00everytime|r the player reachs this step.",
	QE_ST_LINKS_ON_LEAVE = "On quest step leave",
	QE_ST_LINKS_ON_LEAVE_TT = "Triggered |cff00ff00everytime|r the player leave this step for another one. This will be triggered before the next step \"On quest step start\" trigger occurs.",
	QE_ST_END = "Final step",
	QE_ST_END_TT = "Marks this step as the final step for this quest. When the step is reached, the quest will automatically be marked as completed in the quest log.",
	QE_PROGRESS = "Progression",
	QE_PROGRESS_TT = "This parameter flags this quest as part of the campaign progression (even if the quest is not revealed).\n\nThe campaign progression is a % indicator in the quest log showing the global campaign progression (% of completed quests / total quests).\n\n|cff00ff00Typically this should be checked, except for side/secondary quests.",

-- Cutscene
	DI_STEPS = "Cutscene steps",
	DI_STEP = "Cutscene step",
	DI_STEP_ADD = "Add step",
	DI_STEP_EDIT = "Cutscene step edition",
	DI_STEP_TEXT = "Step text",
	DI_ATTR_TT = "Only check this if you want to change this attribute relative to the previous cutscene step.",
	DI_NAME_DIRECTION = "Change dialog direction",
	DI_NAME_DIRECTION_TT = "Determines where to place the chat bubble and name and which model to animate. Select none to completely hide the chat bubble and name.",
	DI_NAME = "Change speaker name",
	DI_NAME_TT = "The name of the talking character.\n\nOnly necessary if the dialog direction above is not NONE.",
	DI_LEFT_UNIT = "Change left model",
	DI_RIGHT_UNIT = "Change right model",
	DI_UNIT_TT = "Sets the model to display:\n\n- Leave empty to hide the model\n- \"player\" to use the player's model\n- \"target\" to use the target's model\n- Any number to load as NPC ID",
	DI_ATTRIBUTE = "Stage modification",
	DI_BKG = "Change background image",
	DI_BKG_TT = "Will be used as background for the cutscene step. Please enter the full texture path.\n\nIf you change the background during a cutscene there will be a fade between the two different backgrounds.",
	DI_DIALOG = "Dialog",
	DI_FRAME = "Decoration",
	DI_MODELS = "Models",
	DI_IMAGE = "Change image",
	DI_IMAGE_TT = "Displays an image in the center of the cutscene frame. The image will fade in. Please enter the full texture path.\n\nTo hide the image afterward, just leave the box empty.",
	DI_LOOT = "Wait for loot",
	DI_LOOT_TT = "If the workflow selected on the left will display a loot to the player, you can check this parameter to prevent the player to go to the next cutscene step until he looted all the items.",
	DI_DISTANCE = "Distance max (yards)",
	DI_DISTANCE_TT = "Defines the max distance (in yards) the player can move away once the cutscene started before auto closing it (and trigger the 'On Cancel' object event).\n\n|cff00ff00Zero means no limit.\n\n|cffff9900Does not work in instance/battleground/arena since patch 7.1.",
	DI_END = "End point",
	DI_END_TT = "Marks this step as end point. When reached it will finish the cutscene (and triggers the On finish object event).\n\n|cff00ff00Handy if you use player choices in this cutscene.",
	DI_CHOICES = "Player choices",
	DI_CHOICES_TT = "Configure player choices for this step.",
	DI_CHOICE = "Option",
	DI_CHOICE_TT = "Enter the text for this option.\n\n|cff00ff00Leave empty to disable this option.",
	DI_CHOICE_STEP = "Go to step",
	DI_CHOICE_STEP_TT = "Enter the cutscene step number to play if the player selects this option.\n\n|cff00ff00If empty or invalid step index, it will end the cutscene if selected (and trigger the On finish object event).",
	DI_CHOICE_TEXT = "Choose an option",
	DI_HISTORY = "Cutscenes history",
	DI_HISTORY_TT = "Click to see/hide the history panel, showing the previous cutscene lines.",
	DI_NEXT = "Next step index",
	DI_CHOICE_CONDI = "Option condition",
	DI_NEXT_TT = "You can indicate which step will be played after this one.\n\n|cff00ff00Leave empty to play the next index in sequential order, only use this field if you need to 'jump' to another index. Useful when using choices.",
	DI_CONDI_TT = "Sets a condition for this option. If the condition is not checked when showing the options, the associated option will not be visible.\n\n|cff00ff00Click: Configure condition\nRight-click: Clear condition",
	DI_LINKS_ONSTART = "On cutscene start",
	DI_LINKS_ONSTART_TT = "Triggered when the cutscene is played.\n\n|cffff9900Note that this workflow will be played BEFORE showing the first step.",
	DI_LINKS_ONEND = "On cutscene end",
	DI_LINKS_ONEND_TT = "Triggered when the cutscene is ended.\n\n|cff00ff00This can be done by reaching the end of last step or by allowing the player to select a choice with an empty or unknown 'go to step'.\n\n|cffff0000This is NOT triggered if the player cancels the cutscene by manually closing the frame.",
	DI_GET_ID = "Target ID",
	DI_GET_ID_TT = "Copy the target's NPC ID. Only works if your current target is an NPC.",


	DEBUG_QUEST_STEP = "Go to a quest step.",
	DEBUG_QUEST_STEP_USAGE = "Usage: /trp3 debug_quest_step questID stepID",
	DEBUG_QUEST_START = "Start quest",
	DEBUG_QUEST_START_USAGE = "Usage: /trp3 debug_quest_start questID",

	DISCLAIMER_OK = "I hereby sign this contract with my blood",
	DISCLAIMER = [[{h1:c}Please read{/h1}

	Creating items and quests takes time and energy and it's always terrible when you lose all the hard work you have done.

	All add-ons in World of Warcraft can store data but there are limitations:

	• There is an unknown data size limit for add-on data (depending on the fact that you are running a 32 or 64 bits client, among other things).
	• Reaching this limit can wipe all the add-on saved data.
	• Kill the process, force-closing the game client (Alt+F4) or crashing can corrupt the add-on saved data.
	• Even if you exit the game correctly, there is always a chance that the game doesn't succeed to save the add-on data and corrupt it.

	In regards to all of that, we STRONGLY recommand to regularely backup your add-on saved data.

	You can find here a tutorial about finding all saved data:
	{link*https://totalrp3.info/documentation/how_to/saved_variables*Where are my information stored?}

	You can find here a tutorial about syncing your data to a cloud service:
	{link*https://totalrp3.info/documentation/how_to/backup_and_sync_profiles*How to backup and synchronize your add-ons settings using a cloud service}

	Please understand that we won't reply anymore to comment or ticket relative to a data wipe.
	It's not because we don't want to help but because we can't do anything to restore wiped data.

	Thank you, and enjoy Total RP 3 Extended!

	{p:r}The TRP3 Team{/p}]],

--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- TUTORIAL: Databases
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	TU_TITLE = "Tutorial",
	TU_DB_1_TEXT = [[|cff00ff00Welcome to the database tutorial.|r

This is the database, where all the objects are stored.

An object contains all information about an item, a document, a campaign/quest/step or a cutscene.]],
	TU_DB_2 = "Database types",
	TU_DB_2_TEXT = [[There are four tabs, filtering the entire database.

|cff00ff00My database:|r it contains all the objects you created.

|cff00ff00Players database:|r it contains all objects you received (or imported) from other players.

|cff00ff00Backers database:|r it contains the objects created by the Kickstarter backers and the TRP3 team.

|cff00ff00Full database:|r it contains all the previous databases content.]],
	TU_DB_3_TEXT = [[You can filter more each database to find a specific object by changing the search filters and select |cff00ff00Search|r.

Without filters, the objects list follows a hierarchical presentation.

But if you filter the list, the results are shown with a flat presentation.
Here we just filtered the list by object type to show only the |cffff9900items|r.

To exit the search mode, click on the |cff00ff00Clear|r button in the filters panel.]],
	TU_DB_4 = "Root and inner objects",
	TU_DB_4_TEXT = [[There are two kind of objects: |cff00ff00root objects and inner objects|r.

|cff00ff00Inner objects|r are always stored in a |cff00ff00root object|r (even if they can be inside another inner object all the way to the root).

When you exchange an item with someone, all the root object information is actually exchanged, even if the item is only an inner object.

So for now, just remember that using inner objects is a good way to link objects that always should be exchange together.

Examples:
- An item showing a document: the document would be an inner object of the root item object.
- A campaign with 4 quests: each quest is actually an inner object of the root campaign object.
- A gun item firing bullet item: the bullet object would be an inner object of the root gun object.

But don't worry, it will comes naturally !]],
	TU_DB_5 = "Root objects",
	TU_DB_5_TEXT = "Only items and campaigns can be root objects.\n\nYou can use these two buttons to create an new item or campaign.",
	TU_DB_6 = "Create an item",
	TU_DB_6_TEXT = [[When creating a new item, you can select a template or use the quick creation mode.

The |cff00ff00quick creation|r mode allows you to easily create a first item, but the possibilities are limited. Now that you can always go to normal creation mode afterward.

Use the |cff00ff00blank item|r template if you want to start from scratch without any example.

The |cff00ff00document item|r template will actually create two objects: an item object and its document inner object. It will also configure the item to show the document when used.

The |cff00ff00container item|r template will create a configure an item object to be used as a container.

Finally, the |cff00ff00create from|r allows you to duplicate an existing item.]],
	TU_DB_7 = "Object line",
	TU_DB_7_TEXT = "Each line represents an object. You can click on it to edit it or right click to perform various actions.",

--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- TUTORIAL: Items
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	TU_IT_1_TEXT = [[|cff00ff00Welcome to the item creation tutorial.|r

An item is an object that you can store in your character's inventory (or drop it on the ground).

You are here on the Main tab where you can define all the basic attributes for your item.]],

	TU_IT_2 = "Display attributes",
	TU_IT_2_TEXT = [[The display attributes are purely cosmetic and don't have any "gameplay" effect.

It's all about the attributes needed for the item tooltip and the item icon.]],

	TU_IT_4 = "Gameplay attributes",
	TU_IT_4_TEXT = [[The gameplay attributes have some effects on the gameplay.

Two attributes are important: |cff00ff00Usable|r and |cff00ff00Container|r as checking them will display the |cff00ff00Workflow|r and |cff00ff00Container|r tabs.]],

	TU_IT_3 = "Free notes",
	TU_IT_3_TEXT = [[You can write down notes to help you remember what do you want to do with your item.

These notes can also help others that would want to start an item based on yours.]],

--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- TUTORIAL: Workflow
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	TU_WO_1_TEXT = [[|cff00ff00Welcome to the workflow creation tutorial.|r

A workflow is the mechanism that can bring life to your creation. It's here that you will be able to play effects like showing a text, playing a sound or looting an item to the player.]],

	TU_WO_2 = "Workflow list",
	TU_WO_2_TEXT = [[On the left you have the |cff00ff00workflows list|r.

You can remove, rename or copy/paste a workflow by right-clicking on it.

|cffff9900Note: If you are here when editing an item in "normal mode", you won't see a list of workflows but only a single "On use" workflow for the item. If you want to be able to use multiple workflows for an item, you can convert this item to "Expert mode" by right-clicking on it in the databases view.]],

	TU_WO_3_TEXT = [[Here is a list of all the workflow elements.

An element can be an effect, a delay or a condition.

The element order is important because they will be executed sequentially during the workflow execution.

You can change the element order by using the arrows at the top right of each elements.]],

	TU_WO_4 = "Add an effect",
	TU_WO_4_TEXT = [[Effects are things like "playing a sound", "displaying a text" or "start a cutscene".

There are a LOT of effects, each are explained in their own tooltip!]],

	TU_WO_5 = "Add a condition",
	TU_WO_5_TEXT = [[Conditions allow you to |cff00ff00test values in order to stop the workflow execution.|r

|cffff9900If the condition is not met, the workflow execution won't continue further.|r

A condition is composed of a series of tests linked together by the OR or AND operator.

Each test is a values comparision. For example: "The target's health is lesser than 500", "The player is not dead" or "The player has more than 3 units of item [xxx] in his inventory".]],

	TU_WO_6 = "Add a delay",
	TU_WO_6_TEXT = [[Delays can pause the execution of the workflow for a given time, but they can also act as a cast and interrupt the workflow if the player moves.]],

	TU_WO_ERROR_1 = "Please create a workflow before resuming this tutorial.",

--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- TUTORIAL: container
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	TU_CO_1_TEXT = [[A container is an item that can contain other items.

To open a container, you can |cff00ff00double-click|r on it in the inventory.

It is possible to have a container that is also usable (by right-click). It isn't two exclusive concepts.

|cffff9900Please note that for now, you can only trade with players containers that are empty, or that contains only items that are inner objects of the container. Please see the inner object tab for more information.]],

--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- TUTORIAL: Links
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	TU_EL_1_TEXT = [[The event links tab is the place where you can |cff00ff00link your workflows to events|r.

|cffff9900Indeed, workflows aren't executed automatically by default!|r So you have to link them to an event in order to have them executed when that event occurs.

We have here two type of events: |cff00ff00Object events and Game events|r.]],

	TU_EL_2_TEXT = [[|cff00ff00Object events|r are event proper to how Total RP 3 works.

The list of possible events is fixed and depends on the type of the object (item, quest ..etc).

You can link one event to only one workflow. But the same workflow can be linked to multiple events.]],



	TU_EL_4_TEXT = [[|cff00ff00Game events|r are only available for campaigns, quests and quest steps.]],

--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- TUTORIAL: actions
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	TU_AC_1_TEXT = [[|cff00ff00Action links|r is where you can link a workflow to a quest action.

There are four types of quest actions that a player can perform: |cff00ff00listen, look, talk and interact|r.

You can define action links in the campaign, quest or quest step level.]],

	TU_AC_2 = "Actions evaluation",

	TU_AC_2_TEXT = [[Each action can be conditionned by |cff00ff00Ctrl+click on it|r.

When the player performs an action, |cff00ff00all action links will be evaluated in a certain order|r beginning at the quest step level, then the quest and finally the campaign.

If a link can be used (if it's from the good action type and has no condition or the condition is met), then the associated workflow will be executed and |cffff9900the add-on will stop searching for another link|r.]],

--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- TUTORIAL: Cutscene
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	TU_CS_1_TEXT = [[With |cff00ff00cutscenes|r you will be able to create a real narative experience for the player.

Cutscenes uses the layout already used in the Storyline add-on.]],

	TU_CS_2_TEXT = [[A cutscene is a list of step that will be played one after another.

The cutscene takes place in a scene with two characters talking to each other.

In each step you will be able to completely reconfigure the scene.]],

	TU_CS_3_TEXT = [[The step text will be cut down into sub-steps when you enter a double line break. But these sub-steps will share the same step configuration.

So you will typically change step when you want to change which character is speaking (with the "dialog direction" attribute).

When you want to change a step attribute, |cff00ff00be sure to have activated the parameter.]],

	TU_CS_4 = "Cutscenes and workflows",
	TU_CS_4_TEXT = [[You can link a workflow to a step. It will be executed a the start of the step (or first sub-step).

If this workflow contains a Loot effect, you can check the "Wait for loot" option to force the player to loot before the cutscene can continue.]],

	TU_CS_5 = "Preview",
	TU_CS_5_TEXT = [[You can preview your cutscene at any moment.

|cffff9900Linked workflows won't be executed in preview mode.]],

--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- TUTORIAL: Inventory
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	INV_TU_1 = [[You can place an item (or a stack of items) in each slot of the inventory.

|cff00ff00You are not limited in capacity as you can have an unlimited amount of bags and containers. You can also have containers in containers.

|cffff9900The only thing you should be careful with is the carry weight of each container.|r

If a container has a maximum weight capacity and you overpass this capacity, it will slowly be damaged over time and could randomly drop items on the ground!]],

	INV_TU_2 = [[Any bag you place here will act as primary container.

|cffff9900It's very important to always have a primary container with free space as it will be the container used when exchanging items with other players.

|cff00ff00Also, the primary container can easily be opened with the inventory button on the TRP toolbar.]],

	INV_TU_3 = [[For items that are directly on the character (not in a bag), if they are wearable (which is a choice from the item author), |cff00ff00you can indicates where they are in your character.

|cffff9900For that click on the dot near the item and place the marker on your character. You can also rotate your character and select his pose.

|cff00ff00When someone uses the inspection feature on you, they will see the markers with the proper character pose!

|rYou can inspect someone's inventory by selecting the character and click on the target bar button |cff00ff00"Character inspection"|r.

|cffff9900Note that the two players must use TRP Extended to be able to inspect each other.]],

	INV_TU_4 = [[When drag & droping an item outside the inventory, |cffff9900you will be asked to choose between destroying it or droping it on the ground.|r

You can drop items (almost) everywhere in the world. |cff00ff00You can then go loot them back later by using the "Search for items" button on the toolbar.

You can also see all droped items on the map by using the "Scan for my items" button.

|cffff9900Note that sometimes items can be droped automatically: if you receive items but your inventory is full, or if one of your bags is damaged.]],



--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
-- TUTORIAL: Quest log
--*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

	QUEST_TU_1 = [[Quests will often require that |cff00ff00you interact with NPCs or with your environment through actions|r.

There are four types of action: |cff00ff00Listen, look, talk and interact|r.

You can perform an action by |cff00ff00right-clicking on the quest log button on the TRP3 toolbar|r.

But another easier way to do actions is to |cff00ff00create macro for it|r. To help you create the action macros you can use this button.]],

	QUEST_TU_2 = [[|cff00ff00You can find here a list of all available campaigns.|r

A campaign is a collection of one or more quests.

|cffff9900You can only progress in one campaign at a time|r. For this you must mark this campaign as the active campaign. |cff00ff00You can use the "Start or resume" button to activate or pause a campaign.|r

You won't lose your progression if you switch from one campaign to another.

|cffff9900You can reset your progression in a campaign by right-clicking on it and select Reset campaign. Note that all looted items won't be lost on campaign reset.]],

	QUEST_TU_3 = [[|cff00ff00You can find here the list of all currently available quests and all finished quests.|r

You can easily see each quest current situation and what are the current objectives.]],

	QUEST_TU_4 = [[|cff00ff00You can find here the current progression of this quest and all current objectives.|r

You can also see the history of previous steps, in case you forget something.]],
	CL_CREATION = "Extended creation",
	CL_EXTENDED_ITEM = "Extended item",
	CL_EXTENDED_CAMPAIGN = "Extended campaign",
	CL_CAMPAIGN_PROGRESSION = "Progression for %s:",
	CL_IMPORT = "Import into database",
	CL_IMPORT_ITEM_BAG = "Add item to your bag",
	CL_TOOLTIP = "Create a chat link",
	IN_INNER_ENTER_ID_NO_SPACE = "Object IDs can't contain spaces. Remember that this isn't the object's name !",
	EFFECT_SOUND_ID_SELF_ID_TT = "The ID is an internal identifier for sounds in the game.\n\n|cff00ff00You can easily find all ID on websites like wowhead.\n\n|cffff9900Leave empty to stop all sounds played on the selected channel.",
	EFFECT_SOUND_ID_STOP = "Stop sound ID",
	EFFECT_SOUND_ID_STOP_TT = "Stops one or all sounds in a particular channel.",
	EFFECT_SOUND_ID_STOP_PREVIEW = "Stops sound ID %s in channel %s.",
	EFFECT_SOUND_ID_STOP_ALL_PREVIEW = "Stops |cff00ff00all|cffffff00 sounds in channel %s.",
	EFFECT_SOUND_MUSIC_STOP_TT = "If you use the \"play music\" effect, the music will loop until the game plays another music (for example: the player enters a new zone), or if the player stops it manually or until you use this effect.\n\n|cffff9900Note that this effect will only stop music played by the addon, and will not stop a music played by the game.",
	EFFECT_SOUND_ID_LOCAL_STOP = "Stop local sound",
	EFFECT_SOUND_ID_LOCAL_STOP_TT = "Stops one or all sounds in a particular channel for players around you.",
	EFFECT_SOUND_MUSIC_LOCAL_STOP = "Stop local music",
	EFFECT_SOUND_MUSIC_LOCAL_STOP_TT = "If you use the \"play local music\" effect, the music will loop for all players around until the game plays another music (for example: the player enters a new zone), or if each player stops it manually or until you use this effect.\n\n|cffff9900Note that this effect will only stop music played by the addon, and will not stop a music played by the game.",
	SEC_TT_COMBO_2 = "Configure security",
	SET_TT_SECURED_2 = "Some potentially malicious effects have been secured for your safety.",
	SET_TT_SECURED_2_1 = "See more details.",
	IT_EX_TRADE_BUTTON = "Open exchange",
	IT_EX_TRADE_BUTTON_TT = "Open the exchange frame to start trading items with this player.",
	INV_TU_5_V2 = [[You can exchange an item (or a stack of items) with another player by drag & drop the stack on the player (just like the game does) or using the dedicated button on the target frame.

|cffff9900When someone give you an item, the exchange frame will tell you if the item could possibly have annoying effects (nobody want their character to shout horrible things).

|rWhen that's the case, TRP will convert these effects into a less damaging form (for instance, the shouting will be converted to a personal text) until you decide to unblock them.

|cff00ff00You can block/unblock effects and white-list effects or players by Alt + Right-click on an item on your inventory.]],
	DB_CREATE_ITEM_TEMPLATES_EXPERT = "Expert item",
	DB_CREATE_ITEM_TEMPLATES_EXPERT_TT = "An expert blank template.\nFor users with experience making creations.",
	TU_EL_3_TEXT_V2 = [[|cff00ff00Game events|r are events triggered by the game when something happens.

Each link you add will link a game event to a workflow. Each time the event occurs, the workflow will be executed.

|cff00ff00You can add a condition to the link by Ctrl+click on it.|r The condition will have access to the event arguments to be tested.
For example if you listen to the event of casting a spell, you will be able in the condition to test which spell is casted.

|cffff9900There is a large list of game event, thus it wouldn't be for us to list them all in the add-on. We suggest you to consult webwite like wowwiki.
http://wowwiki.wikia.com/wiki/Event_API

|rIn addition to the game's events, |cff00ff00Total RP 3: Extended offers a couple of custom events|r detailed on the addon wiki.
|cff00ff00https://github.com/Ellypse/Total-RP-3-Extended/wiki|r]],
	DR_STASHES_OWNERSHIP = "Take ownership",
	DR_STASHES_OWNERSHIP_PP = "Take ownership of this stash?\nThis character will be shown as owner of this stash when other players scan for it.",
	EFFECT_ITEM_DICE_PREVIEW_STORED = "Rollin' %s and saving the result to %s",
	EFFECT_ITEM_DICE_ROLL_VAR = "Variable name (optional)",
	EFFECT_ITEM_DICE_ROLL_VAR_TT = "The variable in which you want to store the dice roll result.\nLeave empty if you don't want to store the result.",


	------------------------------------------------------------------------------------------------
	--- PLACE LOCALIZATION NOT ALREADY UPLOADED TO CURSEFORGE HERE
	--- THEN MOVE IT UP ONCE IMPORTED
	------------------------------------------------------------------------------------------------

	WO_EVENT_EX_UNKNOWN_ERROR = "[Error] Unknown event %s in %s",
	WO_EVENT_EX_BROWSER_TITLE = "Event browser",
	WO_EVENT_EX_BROWSER_OPEN = "Open event browser",
	WO_EVENT_EX_BROWSER_NO_PAYLOAD = "No arguments",
	WO_EVENT_EX_BROWSER_COMBAT_LOG_ERROR = "Can't show arguments, refer to Wowpedia",
	DR_STASHES_ERROR_INSTANCE = "Cannot create a stash in an instance",
	DR_DROP_ERROR_INSTANCE = "Cannot drop items in an instance",
	EFFECT_RANDSUM_TT = "Summon a random battle pet.",
	EFFECT_RANDSUM_SUMMON_FAV = "Only summon favourite pets",
	EFFECT_RANDSUM_PREVIEW_FULL = "Summon a random battle pet from your |c0000ff00entire pool|r.",
	EFFECT_RANDSUM_PREVIEW_FAV = "Summon a random battle pet from your |c0000ff00favourite pool|r.",
	EFFECT_SUMMOUNT_RANDOMMOUNT = "Random favourite",
	EFFECT_SUMMOUNT_ACTION_TT = "Select a specific mount",
	EFFECT_ITEM_SOURCE_SEARCH = "Search in",
	EFFECT_ITEM_SOURCE_1_SEARCH_TT = "Search for the item(s) inside the entire character inventory.",
	EFFECT_ITEM_SOURCE_2_SEARCH_TT = "Search for the item(s) only inside this item parent container (and any sub-container).\n\n|cffff9900Only works if this script is in an item context.",
	EFFECT_ITEM_SOURCE_3_SEARCH_TT = "Search for the item(s) only inside this item (and any sub-container).\n\n|cffff9900Only works if this script is in an item context and this item is a container.",
	EFFECT_ITEM_SOURCE_ADD = "Add to",
	EFFECT_ITEM_SOURCE_1_ADD_TT = "Add the item(s) anywhere inside the entire character inventory, starting with the main container.",
	EFFECT_ITEM_SOURCE_2_ADD_TT = "Add the item(s) only inside this item parent container (and any sub-container).\n\n|cffff9900Only works if this script is in an item context.",
	EFFECT_ITEM_SOURCE_3_ADD_TT = "Add the item(s) only inside this item (and any sub-container).\n\n|cffff9900Only works if this script is in an item context and this item is a container.",
}

Localization:GetDefaultLocale():AddTexts(TRP3_API.loc);


-- Register all locales into the localization system
-- Note the localeContent is filled by the publishing script using CurseForge's localization tool when packaging builds
-- See https://wow.curseforge.com/projects/total-rp-3-extended/localization
local localeContent = {};

localeContent = {
	["ALL"] = "All",
	["BINDING_NAME_TRP3_INVENTORY"] = "Open character's inventory",
	["BINDING_NAME_TRP3_MAIN_CONTAINER"] = "Open main container",
	["BINDING_NAME_TRP3_QUEST_ACTION"] = "Quest action: interact",
	["BINDING_NAME_TRP3_QUEST_LISTEN"] = "Quest action: listen",
	["BINDING_NAME_TRP3_QUEST_LOOK"] = "Quest action: inspect",
	["BINDING_NAME_TRP3_QUEST_TALK"] = "Quest action: talk",
	["BINDING_NAME_TRP3_QUESTLOG"] = "Open TRP3's quest log",
	["BINDING_NAME_TRP3_SEARCH_FOR_ITEMS"] = "Search for items",
	["CA_ACTION_CONDI"] = "Action condition editor",
	["CA_ACTION_REMOVE"] = "Remove this action?",
	["CA_ACTIONS"] = "Actions",
	["CA_ACTIONS_ADD"] = "Add action",
	["CA_ACTIONS_COND"] = "Edit condition",
	["CA_ACTIONS_COND_OFF"] = "This action is not conditioned.",
	["CA_ACTIONS_COND_ON"] = "This action is conditioned.",
	["CA_ACTIONS_COND_REMOVE"] = "Remove condition",
	["CA_ACTIONS_EDITOR"] = "Action editor",
	["CA_ACTIONS_NO"] = "No action",
	["CA_ACTIONS_SELECT"] = "Select action type",
	["CA_DESCRIPTION"] = "Campaign summary",
	["CA_DESCRIPTION_TT"] = "This brief summary will be visible on the campaign page, in the quest log.",
	["CA_ICON"] = "Campaign icon",
	["CA_ICON_TT"] = "Select campaign icon",
	["CA_IMAGE"] = "Campaign portrait",
	["CA_IMAGE_TT"] = "Select campaign portrait",
	["CA_LINKS_ON_START"] = "On campaign start",
	["CA_LINKS_ON_START_TT"] = [=[Triggered |cff00ff00once|r when the player start your campaign, so activating your campaign for the first time, or reset it in the quest log.

|cff00ff00This is a good place to activate your first quest.]=],
	["CA_NAME"] = "Campaign name",
	["CA_NAME_NEW"] = "New campaign",
	["CA_NAME_TT"] = "This is the name of your campaign. It appears on the quest log.",
	["CA_NO_NPC"] = "No customized NPC",
	["CA_NPC"] = "Campaign NPC list",
	["CA_NPC_ADD"] = "Add customized NPC",
	["CA_NPC_AS"] = "Duplicate",
	["CA_NPC_EDITOR"] = "NPC editor",
	["CA_NPC_EDITOR_DESC"] = "NPC description",
	["CA_NPC_EDITOR_NAME"] = "NPC name",
	["CA_NPC_ID"] = "NPC ID",
	["CA_NPC_ID_TT"] = [=[Please enter the ID of the NPC to customize.

|cff00ff00To get the ID of an NPC you targeted, type this command in the chat: /trp3 getID]=],
	["CA_NPC_NAME"] = "Default NPC name",
	["CA_NPC_REMOVE"] = "Remove customization for this NPC?",
	["CA_NPC_TT"] = [=[You can customize NPCs to give them a name, an icon and a description.
This customization will be visible when the player has your campaign as active.]=],
	["CA_NPC_UNIT"] = "Customized NPC",
	["CA_QE_ID"] = "Change quest ID",
	["CA_QE_ST_ID"] = "Change quest step ID",
	["CA_QUEST_ADD"] = "Add quest",
	["CA_QUEST_CREATE"] = [=[Please enter the quest ID. You can't have two quests with the same ID within the same campaign.

|cffff9900Please note that the quests will be listed in alphabetical order of IDs in the quest log.

|cff00ff00So it's a good practice to always start your ID by quest_# where # is the quest number in the campaign.]=],
	["CA_QUEST_EXIST"] = "There is already a quest with the ID %s.",
	["CA_QUEST_NO"] = "No quest",
	["CA_QUEST_REMOVE"] = "Remove this quest?",
	["CL_CAMPAIGN_PROGRESSION"] = "Progression for %s:",
	["CL_CREATION"] = "Extended creation",
	["CL_EXTENDED_CAMPAIGN"] = "Extended campaign",
	["CL_EXTENDED_ITEM"] = "Extended item",
	["CL_IMPORT"] = "Import into database",
	["CL_IMPORT_ITEM_BAG"] = "Add item to your bag",
	["CL_TOOLTIP"] = "Create a chat link",
	["COM_NPC_ID"] = " get targeted npc id",
	["COND_COMPLETE"] = "Complete logical expression",
	["COND_CONDITIONED"] = "Conditioned",
	["COND_EDITOR"] = "Condition editor",
	["COND_EDITOR_EFFECT"] = "Effect condition editor",
	["COND_LITT_COMP"] = "All comparison types",
	["COND_NUM_COMP"] = "Numeric comparison only",
	["COND_NUM_FAIL"] = "You must have two numeric operands if you use a numeric comparator.",
	["COND_PREVIEW_TEST"] = "Preview test",
	["COND_PREVIEW_TEST_TT"] = "Prints in the chat frame the evaluation of this test based on the current situation.",
	["COND_TEST_EDITOR"] = "Test editor",
	["COND_TESTS"] = "Condition tests",
	["CONF_MAIN"] = "Extended settings",
	["CONF_MUSIC_ACTIVE"] = "Play local musics",
	["CONF_MUSIC_ACTIVE_TT"] = [=[Local musics are musics played by other players (for example through an item) to a certain range in yards.

Turn this off if you don't want to hear these musics at all.

|cff00ff00Note that you will never hear music from ignored players.

|cff00ff00Note that all music is interruptible via the Sound History in the TRP3 shortcuts bar.]=],
	["CONF_MUSIC_METHOD"] = "Local music playback method",
	["CONF_MUSIC_METHOD_TT"] = "Determine how you will hear local music when you are in range.",
	["CONF_SOUNDS"] = "Local sounds / musics",
	["CONF_SOUNDS_ACTIVE"] = "Play local sounds",
	["CONF_SOUNDS_ACTIVE_TT"] = [=[Local sounds are sounds played by other players (for example through an item) to a certain range in yards.

Turn this off if you don't want to hear these sounds at all.

|cff00ff00Note that you will never hear sounds from ignored players.

|cff00ff00Note that all sounds are interruptible via the Sound History in the TRP3 shortcuts bar.]=],
	["CONF_SOUNDS_MAXRANGE"] = "Playback maximum range",
	["CONF_SOUNDS_MAXRANGE_TT"] = [=[Set the maximum range (in yards) within which you will hear local sounds/music.

|cff00ff00Usefull to avoid people playing sounds through the whole continent.

|cffff9900Zero means no limit!]=],
	["CONF_SOUNDS_METHOD"] = "Local sound playback method",
	["CONF_SOUNDS_METHOD_1"] = "Play automatically",
	["CONF_SOUNDS_METHOD_1_TT"] = "If you are in range, it will play the sound/music without asking your permission.",
	["CONF_SOUNDS_METHOD_2"] = "Ask permission",
	["CONF_SOUNDS_METHOD_2_TT"] = "If you are in range, a link will be placed in the chat frame to ask you confirmation to play the sound/music.",
	["CONF_SOUNDS_METHOD_TT"] = "Determine how you will hear a local sound when you are in range.",
	["CONF_UNIT"] = "Units",
	["CONF_UNIT_WEIGHT"] = "Weight unit",
	["CONF_UNIT_WEIGHT_1"] = "Grams",
	["CONF_UNIT_WEIGHT_2"] = "Pounds",
	["CONF_UNIT_WEIGHT_3"] = "Potatoes",
	["CONF_UNIT_WEIGHT_TT"] = "Defines how weight values are displayed.",
	["DB"] = "Database",
	["DB_ACTIONS"] = "Actions",
	["DB_ADD_COUNT"] = "How many units of %s do you want to add to your inventory?",
	["DB_ADD_ITEM"] = "Add to main inventory",
	["DB_ADD_ITEM_TT"] = "Adds units of this item in your primary container (or main inventory if you don't have any primary container on your character).",
	["DB_BACKERS"] = "Backers database (%s)",
	["DB_BACKERS_LIST"] = "Credits",
	["DB_BROWSER"] = "Object browser",
	["DB_COPY_ID_TT"] = "Display the object ID in a popup to be copy/pastable.",
	["DB_COPY_TT"] = "Copy information for this object (and child objects) to be pastable as inner objects in another object.",
	["DB_CREATE_CAMPAIGN"] = "Create campaign",
	["DB_CREATE_CAMPAIGN_TEMPLATES_BLANK"] = "Blank campaign",
	["DB_CREATE_CAMPAIGN_TEMPLATES_BLANK_TT"] = [=[A blank template.
For those who like to start from scratch.]=],
	["DB_CREATE_CAMPAIGN_TEMPLATES_FROM"] = "Create from ...",
	["DB_CREATE_CAMPAIGN_TEMPLATES_FROM_TT"] = "Create a copy of an existing campaign.",
	["DB_CREATE_CAMPAIGN_TT"] = "Start creating a campaign",
	["DB_CREATE_ITEM"] = "Create item",
	["DB_CREATE_ITEM_TEMPLATES"] = "Or select a template",
	["DB_CREATE_ITEM_TEMPLATES_BLANK"] = "Blank item",
	["DB_CREATE_ITEM_TEMPLATES_BLANK_TT"] = [=[A blank template.
For those who like to start from scratch.]=],
	["DB_CREATE_ITEM_TEMPLATES_CONTAINER"] = "Container item",
	["DB_CREATE_ITEM_TEMPLATES_CONTAINER_TT"] = [=[A container template.
Containers can hold other items.]=],
	["DB_CREATE_ITEM_TEMPLATES_DOCUMENT"] = "Document item",
	["DB_CREATE_ITEM_TEMPLATES_DOCUMENT_TT"] = [=[An item template with an inner document object.
Useful to quickly create a book or a scroll.]=],
	["DB_CREATE_ITEM_TEMPLATES_EXPERT"] = "Expert item",
	["DB_CREATE_ITEM_TEMPLATES_EXPERT_TT"] = [=[An expert blank template.
For users with experience making creations.]=],
	["DB_CREATE_ITEM_TEMPLATES_FROM"] = "Create from ...",
	["DB_CREATE_ITEM_TEMPLATES_FROM_TT"] = "Create a copy of an existing item.",
	["DB_CREATE_ITEM_TEMPLATES_QUICK"] = "Quick creation",
	["DB_CREATE_ITEM_TEMPLATES_QUICK_TT"] = [=[Quickly creates a simple item without any effect.
Then adds one unit of this item into your primary bag.]=],
	["DB_CREATE_ITEM_TT"] = "Select a template for a new item",
	["DB_DELETE_TT"] = "Removes this object and all its children objects.",
	["DB_EXPERT_TT"] = "Switches this object to expert mode, allowing more complex customizations.",
	["DB_EXPORT"] = "Quick export object",
	["DB_EXPORT_DONE"] = [=[Your object has been exported in the file called |cff00ff00totalRP3_Extended_ImpExport.lua|r in this game directory:

World of Warcraft\WTF\
account\YOUR_ACCOUNT\SavedVariables

You can share this file with your friends!

They can follow the import process in the |cff00ff00Full Database tab|r.]=],
	["DB_EXPORT_HELP"] = "Code for object %s (size: %0.1f kB)",
	["DB_EXPORT_MODULE_NOT_ACTIVE"] = "Object full export/import: Please enable the totalRP3_Extended_ImpExport add-on first.",
	["DB_EXPORT_TOO_LARGE"] = [=[This object is too large once serialized to be exported this way. Please use the full export feature.

Size: %0.1f kB.]=],
	["DB_EXPORT_TT"] = [=[Serializes the object content to be exchangeable outside the game.

Only works on small objects (lesser than 20 kB once serialized). For larger object, use the full export feature.]=],
	["DB_FILTERS"] = "Search filters",
	["DB_FILTERS_CLEAR"] = "Clear",
	["DB_FILTERS_NAME"] = "Object name",
	["DB_FILTERS_OWNER"] = "Created by",
	["DB_FULL"] = "Full database (%s)",
	["DB_FULL_EXPORT"] = "Full export",
	["DB_FULL_EXPORT_TT"] = [=[Make a full export for this object regardless of its size.

This will trigger a UI reload in order to force the writing of add-on save file.]=],
	["DB_HARD_SAVE"] = "Hard save",
	["DB_HARD_SAVE_TT"] = "Reload the game UI in order to force saved variables to be written on the disk.",
	["DB_IMPORT"] = "Quick object import",
	["DB_IMPORT_CONFIRM"] = [=[This object was serialized in a different version of Total RP 3 Extended than yours.

Import TRP3E version: %s
Your TRP3E version: %s

|cffff9900This can lead to incompatibilities.
Continue the import anyway?]=],
	["DB_IMPORT_DONE"] = "Object successfully imported!",
	["DB_IMPORT_EMPTY"] = [=[There is no object to import in your |cff00ff00totalRP3_Extended_ImpExport.lua|r file.

The file must be placed in this game directory |cffff9900prior to the game launch|r:

World of Warcraft\WTF\
account\YOUR_ACCOUNT\SavedVariables]=],
	["DB_IMPORT_ERROR1"] = "The object could not be deserialized.",
	["DB_IMPORT_FULL"] = "Full objects import",
	["DB_IMPORT_FULL_CONFIRM"] = [=[Do you want to import the following object?

%s
%s
By |cff00ff00%s|r
Version %s]=],
	["DB_IMPORT_FULL_TT"] = "Import the |cff00ff00totalRP3_Extended_ImpExport.lua|r file.",
	["DB_IMPORT_ITEM"] = "Import item",
	["DB_IMPORT_TT"] = "Paste a previously serialized object here",
	["DB_IMPORT_VERSION"] = [=[You are importing an older version of this object than the version you already have.

Import version: %s
Your version: %s

|cffff9900Do you confirm you want to downgrade?]=],
	["DB_IMPORT_WORD"] = "Import",
	["DB_LIST"] = "Creations list",
	["DB_LOCALE"] = "Object locale",
	["DB_MY"] = "My database (%s)",
	["DB_MY_EMPTY"] = [=[You have not created any objects yet.
Use one of the buttons below to unleash your creativity!]=],
	["DB_OTHERS"] = "Players database (%s)",
	["DB_OTHERS_EMPTY"] = "Here all objects created by other players will be placed.",
	["DB_REMOVE_OBJECT_POPUP"] = [=[Please confirm the removal of the object:
ID: |cff00ffff"%s"|r
|cff00ff00[%s]|r

|cffff9900Warning: This action cannot be reverted!.]=],
	["DB_RESULTS"] = "Search results",
	["DB_SECURITY_TT"] = "Shows all security parameters for this object. From there you can allow or prevent certain undesirable effects.",
	["DB_TO_EXPERT"] = "Convert to expert mode",
	["DB_WARNING"] = [=[
|cffff0000!!! Warning !!!

|cffff9900Don't forget to save your changes before returning to the database list!]=],
	["DEBUG_QUEST_START"] = "Start quest",
	["DEBUG_QUEST_START_USAGE"] = "Usage: /trp3 debug_quest_start questID",
	["DEBUG_QUEST_STEP"] = "Go to a quest step.",
	["DEBUG_QUEST_STEP_USAGE"] = "Usage: /trp3 debug_quest_step questID stepID",
	["DI_ATTR_TT"] = "Only check this if you want to change this attribute relative to the previous cutscene step.",
	["DI_ATTRIBUTE"] = "Stage modification",
	["DI_BKG"] = "Change background image",
	["DI_BKG_TT"] = [=[Will be used as background for the cutscene step. Please enter the full texture path.

If you change the background during a cutscene there will be a fade between the two different backgrounds.]=],
	["DI_CHOICE"] = "Option",
	["DI_CHOICE_CONDI"] = "Option condition",
	["DI_CHOICE_STEP"] = "Go to step",
	["DI_CHOICE_STEP_TT"] = [=[Enter the cutscene step number to play if the player selects this option.

|cff00ff00If empty or invalid step index, it will end the cutscene if selected (and trigger the On finish object event).]=],
	["DI_CHOICE_TT"] = [=[Enter the text for this option.

|cff00ff00Leave empty to disable this option.]=],
	["DI_CHOICES"] = "Player choices",
	["DI_CHOICES_TT"] = "Configure player choices for this step.",
	["DI_CONDI_TT"] = [=[Sets a condition for this option. If the condition is not checked when showing the options, the associated option will not be visible.

|cff00ff00Click: Configure condition
Right-click: Clear condition]=],
	["DI_DIALOG"] = "Dialog",
	["DI_DISTANCE"] = "Distance max (yards)",
	["DI_DISTANCE_TT"] = [=[Defines the max distance (in yards) the player can move away once the cutscene started before auto closing it (and trigger the 'On Cancel' object event).

|cff00ff00Zero means no limit.

|cffff9900Does not work in instance/battleground/arena since patch 7.1.]=],
	["DI_END"] = "End point",
	["DI_END_TT"] = [=[Marks this step as end point. When reached it will finish the cutscene (and triggers the On finish object event).

|cff00ff00Handy if you use player choices in this cutscene.]=],
	["DI_FRAME"] = "Decoration",
	["DI_GET_ID"] = "Target ID",
	["DI_GET_ID_TT"] = "Copy the target's NPC ID. Only works if your current target is an NPC.",
	["DI_HISTORY"] = "Cutscenes history",
	["DI_HISTORY_TT"] = "Click to see/hide the history panel, showing the previous cutscene lines.",
	["DI_IMAGE"] = "Change image",
	["DI_IMAGE_TT"] = [=[Displays an image in the center of the cutscene frame. The image will fade in. Please enter the full texture path.

To hide the image afterward, just leave the box empty.]=],
	["DI_LEFT_UNIT"] = "Change left model",
	["DI_LINKS_ONEND"] = "On cutscene end",
	["DI_LINKS_ONEND_TT"] = [=[Triggered when the cutscene is ended.

|cff00ff00This can be done by reaching the end of last step or by allowing the player to select a choice with an empty or unknown 'go to step'.

|cffff0000This is NOT triggered if the player cancels the cutscene by manually closing the frame.]=],
	["DI_LINKS_ONSTART"] = "On cutscene start",
	["DI_LINKS_ONSTART_TT"] = [=[Triggered when the cutscene is played.

|cffff9900Note that this workflow will be played BEFORE showing the first step.]=],
	["DI_LOOT"] = "Wait for loot",
	["DI_LOOT_TT"] = "If the workflow selected on the left will display a loot to the player, you can check this parameter to prevent the player to go to the next cutscene step until he looted all the items.",
	["DI_MODELS"] = "Models",
	["DI_NAME"] = "Change speaker name",
	["DI_NAME_DIRECTION"] = "Change dialog direction",
	["DI_NAME_DIRECTION_TT"] = "Determines where to place the chat bubble/name and which model to animate. Select none to completely hide the chat bubble and name.",
	["DI_NAME_TT"] = [=[The name of the talking character.

Only necessary if the dialog direction above is not NONE.]=],
	["DI_NEXT"] = "Next step index",
	["DI_NEXT_TT"] = [=[You can indicate which step will be played after this one.

|cff00ff00Leave empty to play the next index in sequential order, only use this field if you need to 'jump' to another index. Useful when using choices.]=],
	["DI_RIGHT_UNIT"] = "Change right model",
	["DI_STEP"] = "Cutscene step",
	["DI_STEP_ADD"] = "Add step",
	["DI_STEP_EDIT"] = "Cutscene step edition",
	["DI_STEP_TEXT"] = "Step text",
	["DI_STEPS"] = "Cutscene steps",
	["DI_UNIT_TT"] = [=[Sets the model to display:

- Leave empty to hide the model
- "player" to use the player's model
- "target" to use the target's model
- Any number to load as NPC ID]=],
	["DI_WAIT_LOOT"] = "Please loot all items",
	["DISCLAIMER"] = [=[{h1:c}Please read{/h1}
Creating items and quests takes time and energy and it's always terrible when you lose all the hard work you have done.
All add-ons in World of Warcraft can store data but there are limitations:
• There is an unknown data size limit for add-on data (depending on the fact that you are running a 32 or 64 bits client, among other things).
• Reaching this limit can wipe all the add-on saved data.
• Kill the process, force-closing the game client (Alt+F4) or crashing can corrupt the add-on saved data.
• Even if you exit the game correctly, there is always a chance that the game doesn't succeed to save the add-on data and corrupt it.
In regards to all of that, we STRONGLY recommend to regularely backup your add-on saved data.
You can find here a tutorial about finding all saved data:
{link*https://totalrp3.info/documentation/how_to/saved_variables*Where is my information stored?}
You can find here a tutorial about syncing your data to a cloud service:
{link*https://totalrp3.info/documentation/how_to/backup_and_sync_profiles*How to backup and synchronize your add-ons settings using a cloud service}
Please understand we will no longer reply to comments or tickets relating to data wipes.
It's not because we don't want to help but because we can't do anything to restore wiped data.
Thank you, and enjoy Total RP 3 Extended!
{p:r}The TRP3 Team{/p}]=],
	["DISCLAIMER_OK"] = "I hereby sign this contract with my blood",
	["DO_EMPTY"] = "Empty document",
	["DO_LINKS_ONCLOSE"] = "On close",
	["DO_LINKS_ONCLOSE_TT"] = "Triggered when the document is closed by the player or another event (e.g. through a workflow effect)",
	["DO_LINKS_ONOPEN"] = "On open",
	["DO_LINKS_ONOPEN_TT"] = "Triggered when the document is shown to the player.",
	["DO_NEW_DOC"] = "Document",
	["DO_PAGE_ADD"] = "Add page",
	["DO_PAGE_BORDER"] = "Border",
	["DO_PAGE_BORDER_1"] = "Parchment",
	["DO_PAGE_COUNT"] = "Page %s / %s",
	["DO_PAGE_EDITOR"] = "Page editor: page %s",
	["DO_PAGE_FIRST"] = "First page",
	["DO_PAGE_FONT"] = "%s font",
	["DO_PAGE_HEIGHT"] = "Page height",
	["DO_PAGE_HEIGHT_TT"] = "The page height, in pixels. Please note that certain backgrounds only support a certain height/width ratio and can be deformed.",
	["DO_PAGE_LAST"] = "Last page",
	["DO_PAGE_MANAGER"] = "Pages manager",
	["DO_PAGE_NEXT"] = "Next page",
	["DO_PAGE_PREVIOUS"] = "Previous page",
	["DO_PAGE_REMOVE"] = "Remove page",
	["DO_PAGE_REMOVE_POPUP"] = "Remove the page %s ?",
	["DO_PAGE_RESIZE"] = "Resizable",
	["DO_PAGE_RESIZE_TT"] = [=[Allow the user to resize the frame.

|cffff9900Be sure that your layout can be readable and does not depend on height/width ratio.

|cff00ff00Note that the user will never be able to reduce the frame size below the default width and height.]=],
	["DO_PAGE_TILING"] = "Background tiling",
	["DO_PAGE_TILING_TT"] = "Sets if the background will tile vertically and horizontally. If not, the texture will be stretched.",
	["DO_PAGE_WIDTH"] = "Page width",
	["DO_PAGE_WIDTH_TT"] = "The page width, in pixels. Please note that certain backgrounds only support a certain height/width ratio and can be deformed.",
	["DO_PARAMS_CUSTOM"] = "Page custom parameters",
	["DO_PARAMS_GLOBAL"] = "Default parameters",
	["DO_PARAMS_GLOBAL_TT"] = "Change the document default parameters. These parameters will be used for all pages that does not use custom page parameters.",
	["DO_PREVIEW"] = "Click to see a preview",
	["DOC_UNKNOWN_ALERT"] = "Can't open the document. (Missing class)",
	["DR_DELETED"] = "Destroyed: %s x%d",
	["DR_DROPED"] = "Droped on the ground: %s x%d",
	["DR_NOTHING"] = "No items found in this area.",
	["DR_POPUP"] = "Drop here",
	["DR_POPUP_ASK"] = [=[Total RP 3
 
Select what to do with the item:
%s]=],
	["DR_POPUP_REMOVE"] = "Destroy",
	["DR_POPUP_REMOVE_TEXT"] = "Destroy this item?",
	["DR_RESULTS"] = "Found %s items",
	["DR_SEARCH_BUTTON"] = "Search for |cff00ff00my|r items",
	["DR_SEARCH_BUTTON_TT"] = "Search for your items in the area within 15 yards.",
	["DR_STASHED"] = "Stashed: %s x%d",
	["DR_STASHES"] = "Stashes",
	["DR_STASHES_CREATE"] = "Create a stash here",
	["DR_STASHES_CREATE_TT"] = "Create a stash where you stand.",
	["DR_STASHES_DROP"] = "You can't drop item in someone else's stash.",
	["DR_STASHES_EDIT"] = "Edit stash",
	["DR_STASHES_ERROR_OUT_SYNC"] = "Stash out of sync, please retry.",
	["DR_STASHES_ERROR_SYNC"] = "Stash is not synced.",
	["DR_STASHES_FOUND"] = "Stashes found: %s",
	["DR_STASHES_FULL"] = "This stash is full.",
	["DR_STASHES_HIDE"] = "Hide from scan",
	["DR_STASHES_HIDE_TT"] = [=[This stash won't appear on other players map scan.

Note that they will always be able to access it if they know where it is.]=],
	["DR_STASHES_MAX"] = "max 50 characters",
	["DR_STASHES_NAME"] = "Stash",
	["DR_STASHES_NOTHING"] = "No stashes found in this area.",
	["DR_STASHES_OWNERSHIP"] = "Take ownership",
	["DR_STASHES_OWNERSHIP_PP"] = [=[Take ownership of this stash?
This character will be shown as owner of this stash when other players scan for it.]=],
	["DR_STASHES_REMOVE"] = "Remove stash",
	["DR_STASHES_REMOVE_PP"] = [=[Remove this stash?
|cffff9900All items still inside will be lost!]=],
	["DR_STASHES_REMOVED"] = "Stash removed.",
	["DR_STASHES_RESYNC"] = "Resynchronize",
	["DR_STASHES_SCAN"] = "Scan for players stashes",
	["DR_STASHES_SCAN_MY"] = "Scan for my stashes",
	["DR_STASHES_SEARCH"] = "Search for |cff00ff00players|r stashes",
	["DR_STASHES_SEARCH_TT"] = [=[Search for stashes from other players in the area within 15 yards.

It will launch a scan for 3 seconds, stand still!]=],
	["DR_STASHES_SYNC"] = "Synchronizing...",
	["DR_STASHES_TOO_FAR"] = "You are too far from this stash.",
	["DR_STASHES_WITHIN"] = "|cff00ff00Your|r stashes within 15 yards",
	["DR_SYSTEM"] = "Drop system",
	["DR_SYSTEM_TT"] = [=[Drop / search for items and create / access your stashes.

The drop system does not work in dungeons/arenas/battlegrounds.]=],
	["EDITOR_BOTTOM"] = "Bottom",
	["EDITOR_CANCEL_TT"] = [=[Cancel all changes to the whole object %s (root object and all inner objects).

|cffff9900Unsaved changes will be lost!]=],
	["EDITOR_CONFIRM"] = "Confirm",
	["EDITOR_HEIGHT"] = "Height",
	["EDITOR_ICON"] = "Select icon",
	["EDITOR_ICON_SELECT"] = "Click to select an icon.",
	["EDITOR_ID_COPY"] = "Copy ID",
	["EDITOR_ID_COPY_POPUP"] = "You can copy the object ID below if you need to paste it somewhere.",
	["EDITOR_MAIN"] = "Main",
	["EDITOR_MORE"] = "More",
	["EDITOR_NOTES"] = "Free notes",
	["EDITOR_PREVIEW"] = "Preview",
	["EDITOR_SAVE_TT"] = "Save all changes to the whole object %s (root object and all inner objects) and automatically increments the version number.",
	["EDITOR_TOP"] = "Top",
	["EDITOR_WARNINGS"] = [=[There are %s warnings.

|cffff9900%s|r

Save anyway?]=],
	["EDITOR_WIDTH"] = "Width",
	["EFFECT_CAT_CAMERA"] = "Camera",
	["EFFECT_CAT_CAMERA_LOAD"] = "Load camera",
	["EFFECT_CAT_CAMERA_LOAD_TT"] = "Sets the player's camera position based on a previously saved position.",
	["EFFECT_CAT_CAMERA_SAVE"] = "Save camera",
	["EFFECT_CAT_CAMERA_SAVE_TT"] = "Saves the player's current camera position in one of the 5 save slots available.",
	["EFFECT_CAT_CAMERA_SLOT"] = "Slot number",
	["EFFECT_CAT_CAMERA_SLOT_TT"] = "The index of one of the slots available, 1 to 5.",
	["EFFECT_CAT_CAMERA_ZOOM_DISTANCE"] = "Zoom distance",
	["EFFECT_CAT_CAMERA_ZOOM_IN"] = "Camera zoom in",
	["EFFECT_CAT_CAMERA_ZOOM_IN_TT"] = "Zooms the camera in by a specified distance.",
	["EFFECT_CAT_CAMERA_ZOOM_OUT"] = "Camera zoom out",
	["EFFECT_CAT_CAMERA_ZOOM_OUT_TT"] = "Zooms the camera out by a specified distance.",
	["EFFECT_CAT_CAMPAIGN"] = "Campaign and quest",
	["EFFECT_CAT_SOUND"] = "Sound and music",
	["EFFECT_CAT_SPEECH"] = "Speech and emotes",
	["EFFECT_COOLDOWN_DURATION"] = "Cooldown duration",
	["EFFECT_COOLDOWN_DURATION_TT"] = "The cooldown duration, in seconds.",
	["EFFECT_DIALOG_ID"] = "Cutscene ID",
	["EFFECT_DIALOG_QUICK"] = "Quick cutscene",
	["EFFECT_DIALOG_QUICK_TT"] = "Generate a quick cutscene with only one step. It will automatically takes the player's target as speaker.",
	["EFFECT_DIALOG_START"] = "Start cutscene",
	["EFFECT_DIALOG_START_PREVIEW"] = "Start cutscene %s.",
	["EFFECT_DIALOG_START_TT"] = "Start a cutscene. If a cutscene is already played, it will be interrupted and replaced by this one.",
	["EFFECT_DISMOUNT"] = "Dismiss mount",
	["EFFECT_DISMOUNT_TT"] = "Dismount the player from their current mount.",
	["EFFECT_DISPET"] = "Dismiss battle pet",
	["EFFECT_DISPET_TT"] = "Dismiss the currently invoked battle pet.",
	["EFFECT_DOC_CLOSE"] = "Close document",
	["EFFECT_DOC_CLOSE_TT"] = "Close the currently opened document. Do nothing if there is no shown document.",
	["EFFECT_DOC_DISPLAY"] = "Display document",
	["EFFECT_DOC_DISPLAY_TT"] = "Display a document to the player. If there is already a shown document, it will be replaced.",
	["EFFECT_DOC_ID"] = "Document ID",
	["EFFECT_DOC_ID_TT"] = [=[The document to show.

|cffffff00Please enter the full document ID (parents ID and inner ID).

|cff00ff00Hint: copy/paste the full ID to be sure to avoid typos.]=],
	["EFFECT_ITEM_ADD"] = "Add item",
	["EFFECT_ITEM_ADD_CRAFTED"] = "Crafted",
	["EFFECT_ITEM_ADD_CRAFTED_TT"] = "When checked, and if the added items are craftable (have the crafted flag in their display attributes), will display \"Crafted by xxx\" in the items tooltip where xxx will be the player name.",
	["EFFECT_ITEM_ADD_ID"] = "Item ID",
	["EFFECT_ITEM_ADD_ID_TT"] = [=[The item to add.

|cffffff00Please enter the full item ID (parents ID and inner ID).

|cff00ff00Hint: copy/paste the full ID to be sure to avoid typos.]=],
	["EFFECT_ITEM_ADD_PREVIEW"] = "Adds %sx %s",
	["EFFECT_ITEM_ADD_QT"] = "Amount",
	["EFFECT_ITEM_ADD_QT_TT"] = [=[The number of item to add.

|cff00ff00Note that the addon will do his best to reach this amount but it is possible that not all items will be added: for example if the bag becomes full or if the item has a maximum of units the character can have ('Unique' attribute).]=],
	["EFFECT_ITEM_ADD_TT"] = "Adds items to your bag.",
	["EFFECT_ITEM_BAG_DURABILITY"] = "Damage/repair container",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD"] = "Type",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_DAMAGE"] = "Damage",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_DAMAGE_TT"] = "Damage the parent container. The parent container health can't be damage below 0.",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_HEAL"] = "Repair",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_HEAL_TT"] = "Repair the parent container. The parent container health can't exceed the container maximum durability.",
	["EFFECT_ITEM_BAG_DURABILITY_PREVIEW_1"] = "|cff00ff00Repair|cffffff00 parent container for %s durability points.",
	["EFFECT_ITEM_BAG_DURABILITY_PREVIEW_2"] = "|cffff0000Damage|cffffff00 parent container for %s durability points.",
	["EFFECT_ITEM_BAG_DURABILITY_TT"] = [=[Repair or damage the durability of the item parent container.

|cff00ff00Only works on containers having durability.]=],
	["EFFECT_ITEM_BAG_DURABILITY_VALUE"] = "Durability point",
	["EFFECT_ITEM_BAG_DURABILITY_VALUE_TT"] = "The amount of durability points to add/substract from the parent container health.",
	["EFFECT_ITEM_CONSUME"] = "Consume item",
	["EFFECT_ITEM_CONSUME_TT"] = "Consumes the used item and destroys it.",
	["EFFECT_ITEM_COOLDOWN"] = "Start cooldown",
	["EFFECT_ITEM_COOLDOWN_PREVIEW"] = "Duration: %s second(s)",
	["EFFECT_ITEM_COOLDOWN_TT"] = "Start a cooldown for this item.",
	["EFFECT_ITEM_DICE"] = "Roll dice",
	["EFFECT_ITEM_DICE_PREVIEW"] = "Rollin' %s",
	["EFFECT_ITEM_DICE_PREVIEW_STORED"] = "Rollin' %s and saving the result to %s",
	["EFFECT_ITEM_DICE_ROLL"] = "Roll",
	["EFFECT_ITEM_DICE_ROLL_TT"] = [=[Enter a roll configuration similar to the /trp3 roll command.

|cff00ff00Example: 1d20, 3d6 ..etc.]=],
	["EFFECT_ITEM_DICE_ROLL_VAR"] = "Variable name (optional)",
	["EFFECT_ITEM_DICE_ROLL_VAR_TT"] = [=[The variable in which you want to store the dice roll result.
Leave empty if you don't want to store the result.]=],
	["EFFECT_ITEM_DICE_TT"] = "They see me rollin', they hating.",
	["EFFECT_ITEM_LOOT"] = "Show/drop loot",
	["EFFECT_ITEM_LOOT_DROP"] = "Drop items",
	["EFFECT_ITEM_LOOT_DROP_TT"] = "Drops items on the ground instead of presenting a loot frame to the player. The player can then loot the items he wants with the 'search for items' feature.",
	["EFFECT_ITEM_LOOT_NAME"] = "Source name",
	["EFFECT_ITEM_LOOT_NAME_TT"] = "This will be the loot container name.",
	["EFFECT_ITEM_LOOT_PREVIEW_1"] = "Drop %s item(s) on the ground.",
	["EFFECT_ITEM_LOOT_PREVIEW_2"] = "Display loot with %s item(s).",
	["EFFECT_ITEM_LOOT_SLOT"] = "Click on a slot to configure it.",
	["EFFECT_ITEM_LOOT_TT"] = "Displays a loot container to the player or drop loot on the ground where the player is.",
	["EFFECT_ITEM_REMOVE"] = "Destroy item",
	["EFFECT_ITEM_REMOVE_ID_TT"] = [=[The item to remove.

|cffffff00Please enter the full item ID (parents ID and inner ID).

|cff00ff00Hint: copy/paste the full ID to be sure to avoid typos.]=],
	["EFFECT_ITEM_REMOVE_PREVIEW"] = "Destroys %sx %s",
	["EFFECT_ITEM_REMOVE_QT_TT"] = "The number of item to remove.",
	["EFFECT_ITEM_REMOVE_TT"] = "Destroy items from your inventory.",
	["EFFECT_ITEM_SOURCE"] = "Search in",
	["EFFECT_ITEM_SOURCE_1"] = "All inventory",
	["EFFECT_ITEM_SOURCE_1_TT"] = "Search for the item(s) inside the entire character inventory.",
	["EFFECT_ITEM_SOURCE_2"] = "Parent container",
	["EFFECT_ITEM_SOURCE_2_TT"] = [=[Search for the item(s) only inside this item parent container (and any sub-container).

|cffff9900Only works if this script is in an item context.]=],
	["EFFECT_ITEM_SOURCE_3"] = "This item",
	["EFFECT_ITEM_SOURCE_3_TT"] = [=[Search for the item(s) only inside this item (and any sub-container).

|cffff9900Only works if this script is in an item context and this item is a container.]=],
	["EFFECT_ITEM_SOURCE_ID"] = "You can select an item ID you want to search, or leave empty if you want to search for all types of items.",
	["EFFECT_ITEM_USE"] = "Container: item use",
	["EFFECT_ITEM_USE_PREVIEW"] = "Use item in slot %s",
	["EFFECT_ITEM_USE_TT"] = [=[Use a item in a slot in the container.

|cffff9900Only works if this workflow is triggered by a container.]=],
	["EFFECT_ITEM_WORKFLOW"] = "Run item workflow",
	["EFFECT_ITEM_WORKFLOW_PREVIEW_C"] = "Triggers workflow %s in child item in slot %s.",
	["EFFECT_ITEM_WORKFLOW_PREVIEW_P"] = "Triggers workflow %s in parent container.",
	["EFFECT_ITEM_WORKFLOW_PREVIEW_S"] = "Triggers workflow %s in sibling item in slot %s.",
	["EFFECT_ITEM_WORKFLOW_TT"] = "Run a workflow on the parent container or on an item in a specific child item (for container only).",
	["EFFECT_MISSING"] = "This effect (%s) is unknown and you should remove it.",
	["EFFECT_OPERATION"] = "Operation",
	["EFFECT_OPERATION_TYPE"] = "Operation type",
	["EFFECT_OPERATION_TYPE_ADD"] = "Addition",
	["EFFECT_OPERATION_TYPE_DIV"] = "Division",
	["EFFECT_OPERATION_TYPE_INIT"] = "Init",
	["EFFECT_OPERATION_TYPE_INIT_TT"] = "Initializes the variable to a value, only if the variable does not exist yet.",
	["EFFECT_OPERATION_TYPE_MULTIPLY"] = "Multiplication",
	["EFFECT_OPERATION_TYPE_SET"] = "Set",
	["EFFECT_OPERATION_TYPE_SET_TT"] = "Sets the variable to a value, even if the variable has already been initialiazed.",
	["EFFECT_OPERATION_TYPE_SUB"] = "Substraction",
	["EFFECT_OPERATION_VALUE"] = "Operation value",
	["EFFECT_PROMPT"] = "Prompt for input",
	["EFFECT_PROMPT_CALLBACK"] = "Workflow callback (optional)",
	["EFFECT_PROMPT_CALLBACK_TT"] = [=[The workflow name to call after the user input.

This is optional. Leave empty to not use any callback.

Is given, the workflow will be called with the input as workflow variable with the proper name.

|cffffff00Warning: the callback is called even if the player click 'Cancel' in the prompt popup. In that case the variable will be left untouched if it exists.]=],
	["EFFECT_PROMPT_DEFAULT"] = "Default value",
	["EFFECT_PROMPT_DEFAULT_TT"] = "The default value for the input.",
	["EFFECT_PROMPT_PREVIEW"] = "Prompt user for an input to store in variable |cff00ff00%s|r.",
	["EFFECT_PROMPT_TEXT"] = "Popup text",
	["EFFECT_PROMPT_TEXT_TT"] = "The text that will be presented to the user in the input popup.",
	["EFFECT_PROMPT_TT"] = [=[Ask the user for an input and store it in a variable. Then optionally trigger a workflow.

|cffff0000WARNING, this effect execution is asynchronous.]=],
	["EFFECT_PROMPT_VAR"] = "Variable name",
	["EFFECT_PROMPT_VAR_TT"] = "The name of the variable storing the user input.",
	["EFFECT_QUEST_GOTOSTEP"] = "Change quest step",
	["EFFECT_QUEST_GOTOSTEP_ID"] = "Quest step ID",
	["EFFECT_QUEST_GOTOSTEP_ID_TT"] = [=[Use the browser to select your quest step (the quest and quest step must exist before linking it to this effect).

If your quest step does not appear in the browser, save your campaign and try again.]=],
	["EFFECT_QUEST_GOTOSTEP_PREVIEW"] = "Go to step %s.",
	["EFFECT_QUEST_GOTOSTEP_TT"] = [=[Change a quest step.

|cffff9900Only works if the quest is part of the current active campaign and that the quest has already been revealed in the quest log.]=],
	["EFFECT_QUEST_OBJ_ID"] = "Objective ID",
	["EFFECT_QUEST_OBJ_ID_TT"] = "Enter the objective ID. Enter only the objective ID and not the full campaign-quest-objective ID.",
	["EFFECT_QUEST_REVEAL_OBJ"] = "Reveal quest objective",
	["EFFECT_QUEST_REVEAL_OBJ_DONE"] = "Complete objective",
	["EFFECT_QUEST_REVEAL_OBJ_DONE_PREVIEW"] = "Complete objective: %s for %s",
	["EFFECT_QUEST_REVEAL_OBJ_DONE_TT"] = [=[Marks an objective as completed.

|cffff9900Only works if the quest is part of the current active campaign, if the quest has already been revealed in the quest log and if the objective has already been revealed.]=],
	["EFFECT_QUEST_REVEAL_OBJ_PREVIEW"] = "Reveal objective: %s for %s",
	["EFFECT_QUEST_REVEAL_OBJ_TT"] = [=[Reveal a quest objective.

|cffff9900Only works if the quest is part of the current active campaign and that the quest has already been revealed in the quest log.]=],
	["EFFECT_QUEST_START"] = "Reveal quest",
	["EFFECT_QUEST_START_ID"] = "Quest ID",
	["EFFECT_QUEST_START_ID_TT"] = [=[Use the browser to select your quest (the quest must exist before linking it to this effect).

If your quest does not appear in the browser, save your campaign and try again.]=],
	["EFFECT_QUEST_START_PREVIEW"] = "Reveal quest %s.",
	["EFFECT_QUEST_START_TT"] = [=[Reveal a quest in the quest log.

|cffff9900Only works if the quest is part of the current active campaign.]=],
	["EFFECT_RANDSUM"] = "Summon random battle pet",
	["EFFECT_RANDSUM_TT"] = "Summon a random battle pet, picked up in your favorite pets pool.",
	["EFFECT_RUN_WORKFLOW"] = "Run workflow",
	["EFFECT_RUN_WORKFLOW_ID"] = "Workflow ID",
	["EFFECT_RUN_WORKFLOW_ID_TT"] = "The workflow ID you want to run.",
	["EFFECT_RUN_WORKFLOW_PREVIEW"] = "Run workflow %s in %s.",
	["EFFECT_RUN_WORKFLOW_SLOT"] = "Slot ID",
	["EFFECT_RUN_WORKFLOW_SLOT_TT"] = "The index of the container slot to trigger. Slots are indexed from top left to bottom right beginning with slot 1.",
	["EFFECT_RUN_WORKFLOW_TT"] = "Run another workflow. All workflow variables will be passed through the next.",
	["EFFECT_SCRIPT"] = "Execute restricted Lua script",
	["EFFECT_SCRIPT_I_EFFECT"] = "Insert effect",
	["EFFECT_SCRIPT_I_EFFECT_TT"] = [=[Insert an effect function where the cursor is in the code.
The function is in the form of:
|cff00ffffeffect( effectID, args, arg1, arg2, ...);|r
- |cff00ffffEffect ID|r: the effect ID, you can find it by looking at the addon source code.
- |cff00ffffargs|r: The execution arguments: should always be the args variable.
- |cff00ffffEffect arguments argX|r: All effects arguments can be found in the addon source code.
|cffffff00Please always keep the 'args' as second parameters, |rit is needed by the effect function and contains all workflows arguments.
|cff00ff00We won't, for now, heavily document all effect ID and arguments as we consider this effect restricted to users capable of looking at the addon source code. ;)]=],
	["EFFECT_SCRIPT_SCRIPT"] = "Lua code",
	["EFFECT_SCRIPT_SCRIPT_TT"] = [=[This script will be executed in a safe environment where you can have access to all Lua synthax and API (table, string, math...) and the Extended |cff00ff00effect|r function.
|cffff0000You don't have access to the game API here!|r
A custom Lua script will always be less efficient than a workflow effect, as it is compiled each time, in opposition to a workflow effect being compiled once.
|cffff9900So keep the script to the minimum and only use this script effect if necessary.]=],
	["EFFECT_SCRIPT_TT"] = "Execute a Lua script in a restricted safe environment.",
	["EFFECT_SHEATH"] = "Toggle weapons sheath",
	["EFFECT_SHEATH_TT"] = "Draw or put up the character weapons.",
	["EFFECT_SIGNAL"] = "Send signal",
	["EFFECT_SIGNAL_ID"] = "Signal ID",
	["EFFECT_SIGNAL_ID_TT"] = "It's the ID of your signal. It can be tested if conditions and workflows triggered by the game event |cff00ff00TRP3_SIGNAL|r.",
	["EFFECT_SIGNAL_PREVIEW"] = "|cffffff00Send signal ID:|r %s|cffffff00 with value:|r %s",
	["EFFECT_SIGNAL_TT"] = [=[Send a signal with an ID and a value to the player's target.

This signal can be handle by campaign/quest/step game event links through the event |cff00ff00TRP3_SIGNAL|r.]=],
	["EFFECT_SIGNAL_VALUE"] = "Signal value",
	["EFFECT_SIGNAL_VALUE_TT"] = "It's the value of your signal. It can be tested if conditions and workflows triggered by the game event |cff00ff00TRP3_SIGNAL|r and inserted as text tags like |cff00ff00${event.2}|r.",
	["EFFECT_SOUND_ID_LOCAL"] = "Play local sound",
	["EFFECT_SOUND_ID_LOCAL_PREVIEW"] = "Plays sound ID %s in channel %s in a %s yards radius.",
	["EFFECT_SOUND_ID_LOCAL_STOP"] = "Stop local sound",
	["EFFECT_SOUND_ID_LOCAL_STOP_TT"] = "Stops one or all sounds in a particular channel for players around you.",
	["EFFECT_SOUND_ID_LOCAL_TT"] = "Plays a sound for players around you.",
	["EFFECT_SOUND_ID_SELF"] = "Play sound ID",
	["EFFECT_SOUND_ID_SELF_CHANNEL"] = "Channel",
	["EFFECT_SOUND_ID_SELF_CHANNEL_AMBIANCE"] = "Ambience",
	["EFFECT_SOUND_ID_SELF_CHANNEL_AMBIANCE_TT"] = [=[Ambience is for ambient sound. It uses the ambience volume game option

Multiple different ambience sounds can be played simultaneously.

|cffff9900Please do not use this effect to play music as this won't stop the current game music and you would have musics overlaping each other. If you want to play a music use the proper music effect.]=],
	["EFFECT_SOUND_ID_SELF_CHANNEL_SFX"] = "SFX",
	["EFFECT_SOUND_ID_SELF_CHANNEL_SFX_TT"] = [=[SFX is for effect sounds. It uses the sound volume game option.

Multiple different SFX sounds can be played simultaneously.]=],
	["EFFECT_SOUND_ID_SELF_ID"] = "Sound ID",
	["EFFECT_SOUND_ID_SELF_ID_TT"] = [=[The ID is an internal identifier for sounds in the game.

|cff00ff00You can easily find all ID on websites like wowhead.

|cffff9900Leave empty to stop all sounds played on the selected channel.]=],
	["EFFECT_SOUND_ID_SELF_PREVIEW"] = "Plays sound ID %s in channel %s.",
	["EFFECT_SOUND_ID_SELF_TT"] = "Plays a sound in a particular channel. Only the player will hear it.",
	["EFFECT_SOUND_ID_STOP"] = "Stop sound ID",
	["EFFECT_SOUND_ID_STOP_ALL_PREVIEW"] = "Stops |cff00ff00all|cffffff00 sounds in channel %s.",
	["EFFECT_SOUND_ID_STOP_PREVIEW"] = "Stops sound ID %s in channel %s.",
	["EFFECT_SOUND_ID_STOP_TT"] = "Stops one or all sounds in a particular channel.",
	["EFFECT_SOUND_LOCAL_DISTANCE"] = "Playback radius",
	["EFFECT_SOUND_LOCAL_DISTANCE_TT"] = "Determine the radius around the player within which other players will hear this sound.",
	["EFFECT_SOUND_MUSIC_LOCAL"] = "Play local music",
	["EFFECT_SOUND_MUSIC_LOCAL_PREVIEW"] = "Plays music \"%s\" in a %s yards radius.",
	["EFFECT_SOUND_MUSIC_LOCAL_STOP"] = "Stop local music",
	["EFFECT_SOUND_MUSIC_LOCAL_STOP_TT"] = [=[If you use the "play local music" effect, the music will loop for all players around until the game plays another music (for example: the player enters a new zone), or if each player stops it manually or until you use this effect.

|cffff9900Note that this effect will only stop music played by the addon, and will not stop a music played by the game.]=],
	["EFFECT_SOUND_MUSIC_LOCAL_TT"] = "Plays a music for players around you.",
	["EFFECT_SOUND_MUSIC_SELF"] = "Play music",
	["EFFECT_SOUND_MUSIC_SELF_PATH"] = "Music path",
	["EFFECT_SOUND_MUSIC_SELF_PATH_TT"] = [=[The music path within the game files.

|cffff9900It must not contain the Sounds\Music\ part of the path, nor the .mp3 at the end.]=],
	["EFFECT_SOUND_MUSIC_SELF_PREVIEW"] = "Plays music: %s",
	["EFFECT_SOUND_MUSIC_SELF_TT"] = [=[Plays music. Only the player will hear it.

Note that the music will loop until the game plays a music of his own (when entering a zone for example), or until a "stop music" effect is played. Also the player can always manually stop the music through the sound history frame.]=],
	["EFFECT_SOUND_MUSIC_STOP"] = "Stop music",
	["EFFECT_SOUND_MUSIC_STOP_TT"] = [=[If you use the "play music" effect, the music will loop until the game plays another music (for example: the player enters a new zone), or if the player stops it manually or until you use this effect.

|cffff9900Note that this effect will only stop music played by the addon, and will not stop a music played by the game.]=],
	["EFFECT_SOUND_PLAY"] = "Play",
	["EFFECT_SOURCE"] = "Source",
	["EFFECT_SOURCE_CAMPAIGN"] = "Active campaign",
	["EFFECT_SOURCE_CAMPAIGN_TT"] = "Search the variable in the current campaign, if there is a currently active campaign.",
	["EFFECT_SOURCE_OBJECT"] = "Object",
	["EFFECT_SOURCE_OBJECT_TT"] = [=[Search the variable in the workflow source object.

Only works if the source object is an item or a campaign/quest/step.

In the case of a campaign, quest or quest step, the variable will be searched in the campaign level (global for the whole campaign).]=],
	["EFFECT_SOURCE_PARENT"] = "Parent container",
	["EFFECT_SOURCE_PARENT_TT"] = "Search for the workflow in the parent container item.",
	["EFFECT_SOURCE_SLOT"] = "Item in slot (child)",
	["EFFECT_SOURCE_SLOT_B"] = "Item in slot (sibling)",
	["EFFECT_SOURCE_SLOT_B_TT"] = "Search the workflow in the item in a specific slot of the same parent container.",
	["EFFECT_SOURCE_SLOT_TT"] = "Search the workflow in the item in a specific slot inside the container item. Only works for container item!",
	["EFFECT_SOURCE_V"] = "Variable source",
	["EFFECT_SOURCE_W"] = "Workflow source",
	["EFFECT_SOURCE_WORKFLOW"] = "Workflow",
	["EFFECT_SOURCE_WORKFLOW_TT"] = "Search the variable in the workflow execution. The scope for this variable is limited to the workflow execution and will be discarded afterward.",
	["EFFECT_SPEECH_NAR"] = "Speech: Narration",
	["EFFECT_SPEECH_NAR_DEFAULT"] = "The snow blows white on the mountain tonight ...",
	["EFFECT_SPEECH_NAR_TEXT_TT"] = "Please do not include the leading pipe || character.",
	["EFFECT_SPEECH_NAR_TT"] = [=[Plays a narration as a formated emote.

|cff00ff00Has the same effect as playing an emote starting with a || (pipe character). It will be formated in chat for other TRP users.]=],
	["EFFECT_SPEECH_NPC"] = "Speech: NPC",
	["EFFECT_SPEECH_NPC_DEFAULT"] = "Do you want to build a snowman?",
	["EFFECT_SPEECH_NPC_NAME"] = "NPC name",
	["EFFECT_SPEECH_NPC_NAME_TT"] = "The NPC name.",
	["EFFECT_SPEECH_NPC_TT"] = [=[Plays a npc speech as a formated emote.

|cff00ff00Has the same effect as playing an emote starting with a || (pipe character) with a npc name and a text. It will be formated in chat for other TRP users.]=],
	["EFFECT_SPEECH_PLAYER"] = "Speech: Player",
	["EFFECT_SPEECH_PLAYER_DEFAULT"] = "Let the dragon consume you!",
	["EFFECT_SPEECH_PLAYER_TT"] = "Makes the player speak, yell or do an /e emote.",
	["EFFECT_SPEECH_TYPE"] = "Speech type",
	["EFFECT_SUMMOUNT"] = "Summon a mount",
	["EFFECT_SUMMOUNT_NOMOUNT"] = "No mount select yet.",
	["EFFECT_SUMMOUNT_TT"] = "Summon a specific mount, if available.",
	["EFFECT_TEXT"] = "Display text",
	["EFFECT_TEXT_PREVIEW"] = "Displayed text",
	["EFFECT_TEXT_TEXT"] = "Text",
	["EFFECT_TEXT_TEXT_DEFAULT"] = [=[Hello.
How are you?]=],
	["EFFECT_TEXT_TEXT_TT"] = "The text to display.",
	["EFFECT_TEXT_TT"] = [=[Displays a text.
Different outputs are possible.]=],
	["EFFECT_TEXT_TYPE"] = "Text type",
	["EFFECT_TEXT_TYPE_1"] = "Chat frame text",
	["EFFECT_TEXT_TYPE_2"] = "Alert popup",
	["EFFECT_TEXT_TYPE_3"] = "Raid alert text",
	["EFFECT_TEXT_TYPE_4"] = "Alert message",
	["EFFECT_USE_SLOT"] = "Container slot number",
	["EFFECT_USE_SLOT_TT"] = "The container slots number are assigned from left to right and top to bottom.",
	["EFFECT_VAR"] = "Variable name",
	["EFFECT_VAR_INDEX"] = "Argument index",
	["EFFECT_VAR_INDEX_TT"] = [=[The index of the argument.

So if you want to check the third argument of an event, enter 3.]=],
	["EFFECT_VAR_OBJECT_CHANGE"] = "Variable operation",
	["EFFECT_VAR_OBJECT_CHANGE_TT"] = [=[Performs an operation on a variable.

|cffff9900For math operations: If the variable does not exists or can't be cast as a number, it will be initialized at 0.]=],
	["EFFECT_VAR_OPERAND"] = "Variable dynamic value",
	["EFFECT_VAR_OPERAND_CONFIG"] = "Value configuration",
	["EFFECT_VAR_OPERAND_CONFIG_NO"] = "No configuration for this value",
	["EFFECT_VAR_OPERAND_TT"] = "Place a dynamic value in a variable. You have access to all test values from conditions.",
	["EFFECT_VAR_VALUE"] = "Variable value",
	["EFFECT_W_CAMPAIGN_TT"] = "Search for the workflow in the current active campaign.",
	["EFFECT_W_OBJECT_TT"] = "Search for the workflow in the same object.",
	["ERROR_MISSING_ARG"] = "Missing argument %1$s when trying to call function %2$s.",
	["EX_SOUND_HISTORY"] = "Sounds history",
	["EX_SOUND_HISTORY_CLEAR"] = "Clear",
	["EX_SOUND_HISTORY_EMPTY"] = "No sound has been played.",
	["EX_SOUND_HISTORY_LINE"] = "%s played soundID %s in channel %s.",
	["EX_SOUND_HISTORY_REPLAY"] = "Replay",
	["EX_SOUND_HISTORY_STOP"] = "Stop",
	["EX_SOUND_HISTORY_STOP_ALL"] = "Stop all",
	["EX_SOUND_HISTORY_TT"] = [=[See what sounds have been played, see where they're from and stop them if they still are playing.

|cffffff00Click:|r Open sound history
|cffffff00Right-click:|r Stop all sounds/musics]=],
	["IN_INNER"] = "Inner objects",
	["IN_INNER_ADD"] = "Add inner object",
	["IN_INNER_ADD_COPY"] = "Add copy of existing object",
	["IN_INNER_ADD_NEW"] = "Create new object",
	["IN_INNER_COPY_ACTION"] = "Copy object content",
	["IN_INNER_DELETE_CONFIRM"] = [=[Remove the inner object |cff00ffff"%s"|r |cff00ff00[%s]|r from the parent object |cff00ff00[%s]|r?

|cffff9900The inner object will be lost.]=],
	["IN_INNER_DELETE_TT"] = "Remove this inner object from the parent object.",
	["IN_INNER_EMPTY"] = [=[No inner objects

You can add one by using the add button below.]=],
	["IN_INNER_ENTER_ID"] = "Enter new inner object ID",
	["IN_INNER_ENTER_ID_NO_SPACE"] = "Object IDs can't contain spaces. Remember that this isn't the object's name !",
	["IN_INNER_ENTER_ID_TT"] = [=[Inner object ID must be unique within the parent object.

|cffff9900Please only use lower case characters and underscores. Any other character will be converted to underscores.]=],
	["IN_INNER_HELP"] = [=[Inner objects are objects stored in a parent object.
We should begin with some examples:
|cffff9900
- You want to create a rifle item with bullets item to charge it. Typically the rifle would be the main object, in which the bullet object would be an inner object for the rifle.
- A mail item opening a document. The document would be an inner object for the mail item.
- Creating quests: any item/document/cutscenes you use in a quest could be inner objects for this quest.
|rThe advantages of using inner objects are multiple:
|cff00ff00
- Inner objects data are really stored inside the parent object data. That means they share the same version number, and their data is exchanged in the same time as the parent object data.
- You can freely determine the inner object ID, as it will use the parent object ID as prefix. You just can't have two inner objects having the same ID inside the same parent object.
- Using inner objects brings better performance.
- It's easier to manage and navigate through your objects if they are stored in parent objects. You can really see a parent object as a folder in which you store files.
|rSo it's simple: when you want to create an object, always ask yourself if it wouldn't be better to have it as an inner object for another item or a quest.
|cff00ff00Also: document and cutscenes can only be inner objects!]=],
	["IN_INNER_HELP_TITLE"] = "What are inner objects?",
	["IN_INNER_ID"] = [=[Please enter a new ID for the inner object |cff00ff00[%s]|r.

Old ID: |cff00ffff"%s"|r]=],
	["IN_INNER_ID_ACTION"] = "Change ID",
	["IN_INNER_ID_COPY"] = "Copy",
	["IN_INNER_ID_COPY_TT"] = "You can copy your inner object to paste it in any other parent object.",
	["IN_INNER_LIST"] = "Inner object list",
	["IN_INNER_NO_AVAILABLE"] = "This inner ID is not available!",
	["IN_INNER_PASTE_ACTION"] = "Paste object content",
	["IN_INNER_PASTE_CONFIRM"] = "Replace the content of this inner object with the one you copied earlier?",
	["IN_INNER_S"] = "Inner object",
	["INV_PAGE_CAMERA_CONFIG"] = [=[Camera parameters:
   Rotation: %.2f]=],
	["INV_PAGE_CHARACTER_INSPECTION"] = "Character inspection",
	["INV_PAGE_CHARACTER_INSPECTION_TT"] = "Inspect this character's inventory.",
	["INV_PAGE_CHARACTER_INV"] = "Inventory",
	["INV_PAGE_EDIT_ERROR1"] = "You must be the author of this item to edit it.",
	["INV_PAGE_EDIT_ERROR2"] = "This item is not in Quick mode.",
	["INV_PAGE_INV_OPEN"] = "Open inventory",
	["INV_PAGE_ITEM_LOCATION"] = "Item location on character",
	["INV_PAGE_LOOT_ALL"] = "Loot all",
	["INV_PAGE_MARKER"] = [=[Marker position:
   x: %.2f
   y: %.2f]=],
	["INV_PAGE_PLAYER_INV"] = "%s's inventory",
	["INV_PAGE_QUICK_SLOT"] = "Quick slot",
	["INV_PAGE_QUICK_SLOT_TT"] = "This slot will be used as primary container.",
	["INV_PAGE_SEQUENCE"] = "Sequence ID",
	["INV_PAGE_SEQUENCE_PRESET"] = "You can select a sequence ID corresponding to an emote.",
	["INV_PAGE_SEQUENCE_TT"] = [=[You can change the pose of your character by entering an animation ID here and select the animation frame with the slider below.

Warning: If the animation flickers it's because there is a problem with the animation for your race model. If it happens, please select another animation.]=],
	["INV_PAGE_TOTAL_VALUE"] = "Total items value",
	["INV_PAGE_TOTAL_VALUE_TT"] = [=[This is the value of your inventory.

This is not the amount of "coins" but the estimated total value of all items in the inventory.]=],
	["INV_PAGE_WAIT"] = "Waiting for response",
	["INV_PAGE_WEAR_ACTION"] = "Configure item location",
	["INV_PAGE_WEAR_ACTION_RESET"] = "Reset configuration",
	["INV_PAGE_WEAR_TT"] = [=[This item is wearable.
The green zone indicates the item location on the character.]=],
	["INV_TU_1"] = [=[You can place an item (or a stack of items) in each slot of the inventory.
|cff00ff00You are not limited in capacity as you can have an unlimited amount of bags and containers. You can also have containers in containers.
|cffff9900The only thing you should be careful with is the carry weight of each container.|r
If a container has a maximum weight capacity and you overpass this capacity, it will slowly be damaged over time and could randomly drop items on the ground!]=],
	["INV_TU_2"] = [=[Any bag you place here will act as primary container.
|cffff9900It's very important to always have a primary container with free space as it will be the container used when exchanging items with other players.
|cff00ff00Also, the primary container can easily be opened with the inventory button on the TRP toolbar.]=],
	["INV_TU_3"] = [=[For items that are directly on the character (not in a bag), if they are wearable (which is a choice from the item author), |cff00ff00you can indicates where they are in your character.
|cffff9900For that click on the dot near the item and place the marker on your character. You can also rotate your character and select his pose.
|cff00ff00When someone uses the inspection feature on you, they will see the markers with the proper character pose!
|rYou can inspect someone's inventory by selecting the character and click on the target bar button |cff00ff00"Character inspection"|r.
|cffff9900Note that the two players must use TRP Extended to be able to inspect each other.]=],
	["INV_TU_4"] = [=[When drag & droping an item outside the inventory, |cffff9900you will be asked to choose between destroying it or droping it on the ground.|r
You can drop items (almost) everywhere in the world. |cff00ff00You can then go loot them back later by using the "Search for items" button on the toolbar.
You can also see all droped items on the map by using the "Scan for my items" button.
|cffff9900Note that sometimes items can be droped automatically: if you receive items but your inventory is full, or if one of your bags is damaged.]=],
	["INV_TU_5"] = [=[You can exchange an item (or a stack of items) with another player by drag & drop the stack on the player (just like the game does).
|cffff9900When someone give you an item, the exchange frame will tell you if the item could possibly have annoying effects (nobody want their character to shout horrible things).
|rWhen that's the case, TRP will convert these effects into a less damaging form (for instance, the shouting will be converted to a personal text) until you decide to unblock them.
|cff00ff00You can block/unblock effects and white-list effects or players by Alt + Right-click on an item on your inventory.]=],
	["INV_TU_5_V2"] = [=[You can exchange an item (or a stack of items) with another player by drag & drop the stack on the player (just like the game does) or using the dedicated button on the target frame.

|cffff9900When someone give you an item, the exchange frame will tell you if the item could possibly have annoying effects (nobody want their character to shout horrible things).

|rWhen that's the case, TRP will convert these effects into a less damaging form (for instance, the shouting will be converted to a personal text) until you decide to unblock them.

|cff00ff00You can block/unblock effects and white-list effects or players by Alt + Right-click on an item on your inventory.]=],
	["IT_CAST"] = "Casting",
	["IT_CO_DURABILITY"] = "Durability",
	["IT_CO_DURABILITY_TT"] = [=[Determine the overall max health for your container. A container can lose health over time or can be damaged. But it can also be repaired with the proper items.

|cff00ff00Zero means invulnerable.]=],
	["IT_CO_MAX"] = "Max weight (in grams)",
	["IT_CO_MAX_TT"] = [=[This sets the limit of weight from where your container will start losing health over time due to overweight.

|cff00ff00Zero means no limit.

|cffff9900Please enter the max weight in GRAMS.]=],
	["IT_CO_ONLY_INNER"] = "Can only contain inner items",
	["IT_CO_ONLY_INNER_TT"] = [=[Marks this container to be able to contain only children items from the same root object.

As for now, only containers with this option enabled can be traded while containing items.]=],
	["IT_CO_SIZE"] = "Container size",
	["IT_CO_SIZE_COLROW"] = "%s |1row;rows; by %s columns",
	["IT_CON"] = "Container",
	["IT_CON_CAN_INNER"] = "Can't place a container inside itself!",
	["IT_CON_ERROR_TRADE"] = "You can't drop this container if it's not empty.",
	["IT_CON_ERROR_TYPE"] = "This container can't contain that kind of item.",
	["IT_CON_OPEN"] = "Open/Close container",
	["IT_CON_TT"] = "Container (%d/%d slots used)",
	["IT_CON_TT_MISSING_CLASS"] = "Missing item class ID",
	["IT_CONTAINER_TT"] = [=[Sets this item to be a container. Containers can hold other items.

|cff00ff00The container can be configured in the 'Container' tab of this editor.]=],
	["IT_CONVERT_TO_NORMAL"] = "Convert to normal mode",
	["IT_CONVERT_TO_NORMAL_TT"] = [=[You are in quick mode, an easy first approach to create a simple item.

You can go further and edit this item in normal mode. This will bring you more possibilities but it's also more complex to learn and use.

|cffff9900Warning: if you convert this item to normal mode, you can't revert it back to quick mode.]=],
	["IT_CRAFTED"] = "Crafted",
	["IT_CRAFTED_TT"] = "A crafted item will display in the tooltip the name of the player who crafted it. The player who crafted the item is the player making the action of creating one instance of this item, manually or through a workflow.",
	["IT_DISPLAY_ATT"] = "Display attributes",
	["IT_DOC_ACTION"] = "Read document",
	["IT_DR_SOUND"] = "Drop sound",
	["IT_EX_DOWNLOAD"] = "Download",
	["IT_EX_DOWNLOAD_TT"] = [=[|cffff9900This item is %s messages long and would take at minimum %.1f seconds to be downloaded (in the best condition).

|cff00ff00Click to request %s to send you all the data about this item.

|cffff9900You can't finish a trade if you don't have all the updated information about all items you would receive.]=],
	["IT_EX_DOWNLOADING"] = "Downloading: %0.1f %%",
	["IT_EX_EMPTY"] = "Nothing to trade",
	["IT_EX_EMPTY_DRAG"] = "You can drag and drop items here.",
	["IT_EX_SLOT_DOWNLOAD"] = [=[|rYou don't have the information about this item.

|cff00ff00If the item is not too large, TRP3 will download it automatically from %s.

|cffff9900If it is too large, you can manually request its information with the download button, but keep in mind that it could take some time to be downloaded.]=],
	["IT_EX_TRADE_BUTTON"] = "Open exchange",
	["IT_EX_TRADE_BUTTON_TT"] = "Open the exchange frame to start trading items with this player.",
	["IT_FIELD_NAME"] = "Item name",
	["IT_FIELD_NAME_TT"] = "It's your item name, as it will appear on the tooltip or in item links in the chat frame.",
	["IT_FIELD_QUALITY"] = "Item quality",
	["IT_GAMEPLAY_ATT"] = "Gameplay attributes",
	["IT_INV_ERROR_CANT_DESTROY_LOOT"] = "You can't destroy loot items.",
	["IT_INV_ERROR_CANT_HERE"] = "You can't place items here.",
	["IT_INV_ERROR_FULL"] = "%s is full.",
	["IT_INV_ERROR_MAX"] = "You can't carry any more of %s.",
	["IT_INV_GOT"] = "Received: %s x%d",
	["IT_INV_SCAN_MY_ITEMS"] = "Scan for my items",
	["IT_INV_SHOW_ALL"] = "Show all inventory",
	["IT_INV_SHOW_CONTENT"] = [=[|cffffff00Click:|r Open main container (if exists)
|cffffff00Right-click:|r Open inventory]=],
	["IT_LOOT_ERROR"] = "Can't display loot right now, another loot is currently shown.",
	["IT_NEW_NAME"] = "New item",
	["IT_NEW_NAME_CO"] = "New container",
	["IT_NO_ADD"] = "Prevent manual adding",
	["IT_NO_ADD_TT"] = "Prevent the player to manually adding the item to their inventory. Then it can only be added or looted through workflows.",
	["IT_ON_USE"] = "On use",
	["IT_ON_USE_TT"] = [=[This workflow will be triggered when the player uses this item.

|cffff9900Note:|r If you want to have more workflows for this item, you can convert it to Expert mode through the Databases view (by right-clicking on it and select |cff00ff00Convert to Expert mode|r).]=],
	["IT_PU_SOUND"] = "Pick up sound",
	["IT_PU_SOUND_1183"] = "Bag",
	["IT_PU_SOUND_1184"] = "Book",
	["IT_PU_SOUND_1185"] = "Cloth",
	["IT_PU_SOUND_1186"] = "Food",
	["IT_PU_SOUND_1187"] = "Herb",
	["IT_PU_SOUND_1188"] = "Chain",
	["IT_PU_SOUND_1189"] = "Meat",
	["IT_PU_SOUND_1190"] = "Metal large",
	["IT_PU_SOUND_1191"] = "Metal small",
	["IT_PU_SOUND_1192"] = "Paper",
	["IT_PU_SOUND_1193"] = "Ring",
	["IT_PU_SOUND_1194"] = "Rock",
	["IT_PU_SOUND_1195"] = "Small chain",
	["IT_PU_SOUND_1196"] = "Wand",
	["IT_PU_SOUND_1197"] = "Liquid",
	["IT_PU_SOUND_1198"] = "Wood small",
	["IT_PU_SOUND_1199"] = "Wood large",
	["IT_PU_SOUND_1221"] = "Gems",
	["IT_QUEST"] = "Quest flag",
	["IT_QUEST_TT"] = [=[Adds a marker to the item icon to indicates that using this item should start a quest.

|cffff7700Like others display attributes, it's just a visual flag and it's not required for your item to really be able to start a quest.]=],
	["IT_QUICK_EDITOR"] = "Quick item creation",
	["IT_QUICK_EDITOR_EDIT"] = "Quick item edition",
	["IT_SOULBOUND_TT"] = "This item will be bound to the player when put in their inventory and cannot be exchanged or dropped on the ground.",
	["IT_STACK"] = "Stackable",
	["IT_STACK_COUNT"] = "Max units per stack",
	["IT_STACK_COUNT_TT"] = "Sets the maximum units that can be stacked in a same container slot. Should be greated than 1.",
	["IT_STACK_TT"] = "Allow units for this item to be stacked in a same container slot.",
	["IT_TRIGGER_ON_DESTROY"] = "On stack destroy",
	["IT_TRIGGER_ON_DESTROY_TT"] = [=[Triggered when the player destroys a stack of this item (drags & drops it out of their inventory and confirms the destruction).|cffff9900

It is triggered once per stack, and just before the actual stack destruction (so counting the item units in inventory in this workflow will still count the stack).]=],
	["IT_TRIGGER_ON_USE"] = "On use",
	["IT_TRIGGER_ON_USE_TT"] = [=[Triggered each time the player use this item.

|cff00ff00Don't forget to make your item usable in the main tab.]=],
	["IT_TT_DESCRIPTION"] = "Tooltip description",
	["IT_TT_DESCRIPTION_TT"] = [=[It's your item description.

|cff00ff00It shouldn't be a wall of text here, try to stay concise.

If your item is usable, try to give hints here to how it should be used.]=],
	["IT_TT_LEFT"] = "Tooltip left custom text",
	["IT_TT_LEFT_TT"] = [=[It's a free text that will be in the tooltip, bellow the item name.

|cff00ff00A good example of information to put there is the item type (Armor, clothe, weapon, potion ...).]=],
	["IT_TT_REAGENT"] = "Crafting reagent flag",
	["IT_TT_REAGENT_TT"] = [=[Shows the "Crafting reagent" line in the tooltip.

|cffff7700Like others display attributes, it's just a visual flag and it's not required for your item to really be a crafting reagent.]=],
	["IT_TT_RIGHT"] = "Tooltip right custom text",
	["IT_TT_RIGHT_TT"] = [=[It's a free text that will be in the tooltip, right to the left custom text.

|cff00ff00A good example of information to put there would be a precision of the item type you put in the left custom text.

For example if you put Armor as left custom text you could precise here Helmet or Gloves.]=],
	["IT_TT_VALUE"] = "Item value",
	["IT_TT_VALUE_FORMAT"] = "Item value (in %s)",
	["IT_TT_VALUE_TT"] = [=[This value will be informed on the tooltip extension (hold Alt) or during transactions.

|cffff7700If you think that this item is invaluable, please leave 0. Zero doesn't mean that is has no value, it means that the value is undefined.]=],
	["IT_TT_WEIGHT"] = "Item weight",
	["IT_TT_WEIGHT_FORMAT"] = "Item weight (in grams)",
	["IT_TT_WEIGHT_TT"] = [=[The weight influences the total weight of the container.

|cffff7700Please enter the value in GRAMS, as it will be converted to the user selected unit on display.]=],
	["IT_UNIQUE_COUNT"] = "Max units",
	["IT_UNIQUE_COUNT_TT"] = "Sets the maximum units that a character can possessed. Should be greater than 0.",
	["IT_UNIQUE_TT"] = "When active, the maximum item units that can be possessed by a character will be limited.",
	["IT_USE"] = "Usable",
	["IT_USE_TEXT"] = "Usage text",
	["IT_USE_TEXT_TT"] = "This text, explaining the effect for using this item, will appear in the tooltip.",
	["IT_USE_TT"] = [=[Allow this item to be usable.

|cff00ff00You can configure the item use effect in the 'Workflow' tab of this editor.]=],
	["IT_WARNING_1"] = "You should not make an item both stackable and craftable. (%s)",
	["IT_WARNING_2"] = "You should not make a stackable container. (%s)",
	["IT_WEARABLE"] = "Wearable",
	["IT_WEARABLE_TT"] = [=[Enables this item for the inspection feature and allows you to precisely place it on your character.

|cffff9900If this flag is checked people will be able to see this item on your inventory if they inspect you, even if you don't configure the item position.]=],
	["ITEM_ID"] = "Item ID",
	["LOOT"] = "Loot",
	["LOOT_CONTAINER"] = "Loot container",
	["LOOT_DISTANCE"] = "You moved too far from the loot point.",
	["MODE_EXPERT"] = "Expert",
	["MODE_NORMAL"] = "Normal",
	["MODE_QUICK"] = "Quick",
	["NEW_EXTENDED_VERSION"] = "|cffff9900A new version for TRP3:Extended is available (%s). |cff00ff00Go check it out on Curse!",
	["NPC_EMOTES"] = "emotes",
	["NPC_SAYS"] = "says",
	["NPC_WHISPERS"] = "whispers",
	["NPC_YELLS"] = "yells",
	["OP_ADD_TEST"] = "Add test",
	["OP_AND"] = "AND",
	["OP_AND_SWITCH"] = "Switch to AND",
	["OP_BOOL"] = "Boolean value",
	["OP_BOOL_FALSE"] = "FALSE",
	["OP_BOOL_TRUE"] = "TRUE",
	["OP_COMP_EQUALS"] = "is equal to",
	["OP_COMP_GREATER"] = "is greater than",
	["OP_COMP_GREATER_OR_EQUALS"] = "is greater than or equal to",
	["OP_COMP_LESSER"] = "is lesser than",
	["OP_COMP_LESSER_OR_EQUALS"] = "is lesser than or equal to",
	["OP_COMP_NEQUALS"] = "is not equal to",
	["OP_COMPA_SEL"] = "Comparator selection",
	["OP_CONFIGURE"] = "Configure",
	["OP_CURRENT"] = "Current value",
	["OP_CURRENT_TT"] = "Prints in the chat frame the evaluation of this operand based on the current situation.",
	["OP_DIRECT_VALUE"] = "Direct value",
	["OP_EVAL_VALUE"] = "Evaluated value",
	["OP_FAIL"] = "Failure message",
	["OP_FAIL_TT"] = "This message will be displayed if the condition fails. Leave empty if you don't want to show any message.",
	["OP_FAIL_W"] = "Failure workflow (Expert)",
	["OP_FAIL_W_TT"] = [=[If this condition fails, this workflow will be called. That's a way for making an 'else' in a condition.

|cffff9900Please note that this feature is performance heavy and should be used with caution. The called workflow must exist in the same object.

|cffff0000Do NEVER, ever, create a cycle in called workflow (e.g. a workflow A calling a workflow B calling again the workflow A), even using delays!]=],
	["OP_NUMERIC"] = "Numeric value",
	["OP_OP_CHAR_ACHIEVEMENT"] = "Achievement",
	["OP_OP_CHAR_ACHIEVEMENT_ACC"] = "Account",
	["OP_OP_CHAR_ACHIEVEMENT_ACC_TT"] = "Checks if any character from this account has completed the achievement",
	["OP_OP_CHAR_ACHIEVEMENT_CHAR"] = "Character",
	["OP_OP_CHAR_ACHIEVEMENT_CHAR_TT"] = "Checks if the current character has completed the achievement",
	["OP_OP_CHAR_ACHIEVEMENT_ID"] = "Achievement ID",
	["OP_OP_CHAR_ACHIEVEMENT_ID_TT"] = "The numeric ID of the achievement you want to check.",
	["OP_OP_CHAR_ACHIEVEMENT_PREVIEW"] = "%s completed by |cffff9900%s",
	["OP_OP_CHAR_ACHIEVEMENT_TT"] = "Checks if the account has completed the specified achievement.",
	["OP_OP_CHAR_ACHIEVEMENT_WHO"] = "Completed by",
	["OP_OP_CHAR_CAM_DISTANCE"] = "Camera distance",
	["OP_OP_CHAR_CAM_DISTANCE_TT"] = "The camera distance from the player. 0 if in first person view.",
	["OP_OP_CHAR_FACING"] = "Character facing",
	["OP_OP_CHAR_FACING_TT"] = [=[Returns the player's orientation (in radians, 0 = north, values increasing counterclockwise).

|cffff9900Indicates the direction the player model is (normally) facing and in which the player will move if he begins walking forward, not the camera orientation.]=],
	["OP_OP_CHAR_FALLING"] = "Character is falling",
	["OP_OP_CHAR_FALLING_TT"] = "Returns whether the player's character is currently plummeting to their doom.",
	["OP_OP_CHAR_FLYING"] = "Character is flying",
	["OP_OP_CHAR_FLYING_TT"] = "Checks if the character is flying.",
	["OP_OP_CHAR_MINIMAP"] = "Minimap text",
	["OP_OP_CHAR_MINIMAP_TT"] = [=[Returns the minimap zone text.

The game event "MINIMAP_ZONE_CHANGED" is triggered, when the text changes. So you can test it in a game event link in a campaign or a quest.]=],
	["OP_OP_CHAR_MOUNTED"] = "Character is mounted",
	["OP_OP_CHAR_MOUNTED_TT"] = "Checks if the character is on a mount.",
	["OP_OP_CHAR_RESTING"] = "Character is resting",
	["OP_OP_CHAR_RESTING_TT"] = "Checks if the character is resting. You are resting if you are in an Inn or a Major City like Ironforge or Orgrimmar.",
	["OP_OP_CHAR_STEALTH"] = "Character is stealthed",
	["OP_OP_CHAR_STEALTH_TT"] = "Checks if the character is stealthed.",
	["OP_OP_CHAR_SUBZONE"] = "Sub-zone name",
	["OP_OP_CHAR_SUBZONE_TT"] = [=[The sub-zone name where the character currently is.

|cffff9900Warning: The text depends on the client locale.]=],
	["OP_OP_CHAR_SWIMMING"] = "Character is swimming",
	["OP_OP_CHAR_SWIMMING_TT"] = "Checks if the character is swimming. They do not need to be underwater.",
	["OP_OP_CHAR_ZONE"] = "Zone name",
	["OP_OP_CHAR_ZONE_TT"] = [=[The zone name where the character currently is.

|cffff9900Warning: The text depends on the client locale.]=],
	["OP_OP_CHECK_EVENT_VAR"] = "Event argument string value",
	["OP_OP_CHECK_EVENT_VAR_N"] = "Event argument number value",
	["OP_OP_CHECK_EVENT_VAR_N_PREVIEW"] = "%s-th event argument |cff00ff00(number)",
	["OP_OP_CHECK_EVENT_VAR_N_TT"] = [=[Checks the n-th argument of the event triggering this condition (if any).

Interpreted as a number.

If does not exists or can't be interpreted, returns 0.]=],
	["OP_OP_CHECK_EVENT_VAR_PREVIEW"] = "%s-th event argument |cff00ff00(string)",
	["OP_OP_CHECK_EVENT_VAR_TT"] = [=[Checks the n-th argument of the event triggering this condition (if any).

Interpreted as a string.

If does not exists or can't be interpreted, returns 'nil'.]=],
	["OP_OP_CHECK_VAR"] = "Variable string value",
	["OP_OP_CHECK_VAR_N"] = "Variable numeric value",
	["OP_OP_CHECK_VAR_N_PREVIEW"] = "|cff00ffff%s: |cffff9900(n)|r %s",
	["OP_OP_CHECK_VAR_N_TT"] = [=[Returns the value of a variable, |cff00ff00interpreted as a number|r.

If the variable does not exists, can't be reached or can't be interpreted as a number, returns 0.

|cffff9900As the value depends on runtime, it cannot be previewed.]=],
	["OP_OP_CHECK_VAR_PREVIEW"] = "|cff00ffff%s:|r %s",
	["OP_OP_CHECK_VAR_TT"] = [=[Returns the value of a variable, |cff00ff00interpreted as a string|r.

If the variable does not exists or can't be reached, returns the string 'nil'.

|cffff9900As the value depends on runtime, it cannot be previewed.]=],
	["OP_OP_DISTANCE_CURRENT"] = "Use current position",
	["OP_OP_DISTANCE_ME"] = "Unit distance to player",
	["OP_OP_DISTANCE_ME_TT"] = [=[Returns the distance (in yards) between a unit and the player.

Only works with players.

Returns 0 if unit doesn't exist.

|cffff9900Does not work in instance/battleground/arena since patch 7.1.]=],
	["OP_OP_DISTANCE_POINT"] = "Unit point distance",
	["OP_OP_DISTANCE_POINT_PREVIEW"] = "|cff00ff00%s|r distance from |cff00ff00(%s, %s)",
	["OP_OP_DISTANCE_POINT_TT"] = [=[Returns the distance (in yards) between a unit and a point coordinates.

Only works with players.

Returns 0 if unit doesn't exist.

|cffff9900Does not work in instance/battleground/arena since patch 7.1.]=],
	["OP_OP_DISTANCE_X"] = "X coordinate",
	["OP_OP_DISTANCE_Y"] = "Y coordinate",
	["OP_OP_INV_COUNT"] = "Item units count",
	["OP_OP_INV_COUNT_ANY"] = "Any item",
	["OP_OP_INV_COUNT_PREVIEW"] = "%s units in |cffff9900%s",
	["OP_OP_INV_COUNT_TT"] = [=[|cff00ff00The number of units of an item the player possesses in his inventory.

Leave the ID empty to count for all items.]=],
	["OP_OP_INV_WEIGHT"] = "Container total weight",
	["OP_OP_INV_WEIGHT_PREVIEW"] = "Total weight of |cffff9900%s",
	["OP_OP_INV_WEIGHT_TT"] = "|cff00ff00The current total weight of a container (its own weight plus the content).",
	["OP_OP_QUEST_NPC"] = "Unit is campaign NPC",
	["OP_OP_QUEST_NPC_TT"] = "|cff00ff00Returns whether a unit is a customized NPC in the currently active campaign.",
	["OP_OP_QUEST_OBJ"] = "Quest objective",
	["OP_OP_QUEST_OBJ_ALL"] = "Quest all objectives",
	["OP_OP_QUEST_OBJ_ALL_PREVIEW"] = "%s all obj. done",
	["OP_OP_QUEST_OBJ_ALL_TT"] = "Returns whether all possible quest objectives are completed. So all objectives also has to be revealed.",
	["OP_OP_QUEST_OBJ_CURRENT"] = "Quest current objectives",
	["OP_OP_QUEST_OBJ_CURRENT_PREVIEW"] = "%s current obj. done",
	["OP_OP_QUEST_OBJ_CURRENT_TT"] = "Returns whether all currently revealed quest objectives are completed.",
	["OP_OP_QUEST_OBJ_PREVIEW"] = "Objective %s from %s",
	["OP_OP_QUEST_OBJ_TT"] = "Return the completion (true or false) for a quest objective. If the campaign, quest or the objective is not yet revealed, returns false.",
	["OP_OP_QUEST_STEP"] = "Quest current step",
	["OP_OP_QUEST_STEP_PREVIEW"] = "%s current step",
	["OP_OP_QUEST_STEP_TT"] = "Return the current quest step ID. If the quest is not revealed or has no current step, returns nil.",
	["OP_OP_RANDOM"] = "Random",
	["OP_OP_RANDOM_FROM"] = "From",
	["OP_OP_RANDOM_PREVIEW"] = "Random number between |cff00ff00%s|r and |cff00ff00%s|r.",
	["OP_OP_RANDOM_TO"] = "To",
	["OP_OP_RANDOM_TT"] = "Random number (integer) between two bounds.",
	["OP_OP_TIME_HOUR"] = "Time: Hour",
	["OP_OP_TIME_HOUR_TT"] = "The current hour of the day, server time.",
	["OP_OP_TIME_MINUTE"] = "Time: Minute",
	["OP_OP_TIME_MINUTE_TT"] = "The current minute of the hour, server time.",
	["OP_OP_UNIT_CLASS"] = "Unit class",
	["OP_OP_UNIT_CLASS_TT"] = "|cff00ff00The unit class IN ENGLISH LOWER CASE, as returned by the second arguments of UnitClass.",
	["OP_OP_UNIT_CLASSIFICATION"] = "Unit classification",
	["OP_OP_UNIT_CLASSIFICATION_TT"] = [=[|cff00ff00The unit classification IN ENGLISH LOWER CASE. Example: normal, elite, rare, worldboss, minus...

Always returns normal for players.]=],
	["OP_OP_UNIT_DEAD"] = "Unit is dead",
	["OP_OP_UNIT_DEAD_TT"] = "|cff00ff00Returns whether a unit is either dead or a ghost.",
	["OP_OP_UNIT_DISTANCE_INSPECT"] = "Unit is near (inspection)",
	["OP_OP_UNIT_DISTANCE_INSPECT_TT"] = "|cff00ff00Returns whether a unit is close enough for inspection (28 yards).",
	["OP_OP_UNIT_DISTANCE_TRADE"] = "Unit is near (trade)",
	["OP_OP_UNIT_DISTANCE_TRADE_TT"] = "|cff00ff00Returns whether a unit is close enough for trading (11.11 yards).",
	["OP_OP_UNIT_EXISTS"] = "Unit exists",
	["OP_OP_UNIT_EXISTS_TT"] = [=[|cff00ff00Returns whether a unit exists.

|rA unit 'exists' if it can be referenced by the player; e.g. target exists if the player has a target, npc exists if the player is currently interacting with an NPC, etc.]=],
	["OP_OP_UNIT_FACTION"] = "Unit faction",
	["OP_OP_UNIT_FACTION_TT"] = "|cff00ff00The unit faction IN ENGLISH LOWER CASE.",
	["OP_OP_UNIT_GUILD"] = "Unit guild name",
	["OP_OP_UNIT_GUILD_RANK"] = "Unit guild rank",
	["OP_OP_UNIT_GUILD_RANK_TT"] = "|cff00ff00The guild rank of the unit (if the unit has a guild).",
	["OP_OP_UNIT_GUILD_TT"] = "|cff00ff00The unit guild name (if any).",
	["OP_OP_UNIT_HEALTH"] = "Unit health",
	["OP_OP_UNIT_HEALTH_TT"] = "|cff00ff00The unit's current amount of health (hit points).",
	["OP_OP_UNIT_ID"] = "Unit ID",
	["OP_OP_UNIT_ID_TT"] = "|cff00ff00The unit id in the form |cff00ff00'player-realm'|r, as returned by UnitFullName. Ensure that there is always a realm part.",
	["OP_OP_UNIT_ISPLAYER"] = "Unit is player",
	["OP_OP_UNIT_ISPLAYER_TT"] = "|cff00ff00Returns whether the unit is a player.",
	["OP_OP_UNIT_LEVEL"] = "Unit level",
	["OP_OP_UNIT_LEVEL_TT"] = "|cff00ff00The level of the unit.",
	["OP_OP_UNIT_NAME"] = "Unit name",
	["OP_OP_UNIT_NAME_TT"] = [=[|cff00ff00The unit name, as returned by the first parameters of UnitName.

|rWhen used on a player, it could equal |cff00ff00'player'|r or |cff00ff00'player-realm'|r. So if you want to be sure to have the form |cff00ff00'player-realm'|r use the |cff00ff00'Unit ID'|r operand.]=],
	["OP_OP_UNIT_NPC_ID"] = "Unit NPC ID",
	["OP_OP_UNIT_NPC_ID_TT"] = "|cff00ff00The NPC ID, as determined by UnitGUID. Only works with NPC.",
	["OP_OP_UNIT_POSITION_X"] = "Unit x position",
	["OP_OP_UNIT_POSITION_X_TT"] = [=[Returns the X coordinate of a unit.

Only works with players.

|cffff9900Does not work in instance/battleground/arena since patch 7.1.]=],
	["OP_OP_UNIT_POSITION_Y"] = "Unit y position",
	["OP_OP_UNIT_POSITION_Y_TT"] = [=[Returns the Y coordinate of a unit.

Only works with players.

|cffff9900Does not work in instance/battleground/arena since patch 7.1.]=],
	["OP_OP_UNIT_RACE"] = "Unit race",
	["OP_OP_UNIT_RACE_TT"] = [=[|cff00ff00The unit race IN ENGLISH LOWER CASE, as returned by the second arguments of UnitRace.

So it's Scourge for Undead.]=],
	["OP_OP_UNIT_SEX"] = "Unit gender",
	["OP_OP_UNIT_SEX_TT"] = [=[|cff00ff00The unit gender index. 2 = Male, 3 = Female. 1 is for neutral or unknown.

|cffffff00Returned as a STRING.]=],
	["OP_OP_UNIT_SPEED"] = "Unit speed",
	["OP_OP_UNIT_SPEED_TT"] = "|cff00ff00The current unit speed in yards per second. Walking is 2.5 and running without buff is 7.",
	["OP_OR"] = "OR",
	["OP_OR_SWITCH"] = "Switch to OR",
	["OP_PREVIEW"] = "Preview value",
	["OP_REMOVE_TEST"] = "Remove test",
	["OP_STRING"] = "String value",
	["OP_UNIT"] = "Unit type",
	["OP_UNIT_NPC"] = "NPC",
	["OP_UNIT_PLAYER"] = "Player",
	["OP_UNIT_TARGET"] = "Target",
	["OP_UNIT_TEST"] = "Unit test",
	["OP_UNIT_VALUE"] = "Unit value",
	["QE_ACTION"] = "Quest action",
	["QE_ACTION_NO_CURRENT"] = "You don't have any active campaigns. You should activate a campaign before trying to do an action..",
	["QE_ACTIONS_TYPE_INTERRACT"] = "Interact",
	["QE_ACTIONS_TYPE_LISTEN"] = "Listen",
	["QE_ACTIONS_TYPE_LOOK"] = "Inspect",
	["QE_ACTIONS_TYPE_TALK"] = "Talk",
	["QE_AUTO_REVEAL"] = "Auto reveal",
	["QE_AUTO_REVEAL_TT"] = "Reveal the quest in the quest log when the campaign is started.",
	["QE_AUTORESUME_CONFIRM"] = [=[An effect was called for the campaign |cff00ff00[%s]|r.

Activate this campaign ?
(If you already have an active campaign, it will be paused and your progress will be saved.)]=],
	["QE_BUTTON"] = "Open quest log",
	["QE_CAMPAIGN"] = "Campaign",
	["QE_CAMPAIGN_CURRENT"] = "Current campaign",
	["QE_CAMPAIGN_CURRENT_NO"] = "No active campaign.",
	["QE_CAMPAIGN_EMPTY"] = "This campaign has no quest.",
	["QE_CAMPAIGN_FULL"] = "Finished",
	["QE_CAMPAIGN_LIST"] = "%s available campaigns",
	["QE_CAMPAIGN_NO"] = "Not started yet",
	["QE_CAMPAIGN_NOQUEST"] = [=[No quest revealed yet for this campaign.
Take a look at the campaign description to unlock your first quest.]=],
	["QE_CAMPAIGN_PAUSE"] = "Pausing current campaign.",
	["QE_CAMPAIGN_RESET"] = "Reset campaign",
	["QE_CAMPAIGN_RESUME"] = "Resuming campaign |cff00ff00[%s]|r.",
	["QE_CAMPAIGN_START"] = "Starting campaign |cff00ff00[%s]|r.",
	["QE_CAMPAIGN_START_BUTTON"] = "Start or resume campaign",
	["QE_CAMPAIGN_UNSTARTED"] = [=[You haven't started this campaign yet.
Click on the top right "Start" button to start it.]=],
	["QE_CAMPAIGNS"] = "Campaigns",
	["QE_COMPLETED"] = "Completed",
	["QE_DESCRIPTION"] = "Quest summary",
	["QE_DESCRIPTION_TT"] = "This brief summary will be visible on the quest page, in the quest log.",
	["QE_FAILED"] = "Failed",
	["QE_LINKS_ON_OBJECTIVE"] = "On objective completed",
	["QE_LINKS_ON_OBJECTIVE_TT"] = [=[Triggered each time the player complete an objective for this quest.

|cff00ff00It's a good place to check if all objectives has been completed and reveal the next quest.]=],
	["QE_LINKS_ON_START"] = "On quest start",
	["QE_LINKS_ON_START_TT"] = [=[Triggered |cff00ff00once|r when the player start your quest, by unlocking it in the quest log.

|cff00ff00This is a good place to go to the first quest step.]=],
	["QE_MACRO"] = "Create macro",
	["QE_MACRO_MAX"] = "You can't have more macros. Please free a macro slot before trying again.",
	["QE_MACRO_TT"] = "Creates a macro for this action type and puts the macro on your cursor to be placed on any action bar.",
	["QE_NAME"] = "Quest name",
	["QE_NAME_NEW"] = "New quest",
	["QE_NAME_TT"] = "It's your quest name, as it will appear on the quest log.",
	["QE_NEW"] = "New quest revealed",
	["QE_NOACTION_ACTION"] = "There is nothing to do.",
	["QE_NOACTION_LISTEN"] = "You don't hear anything special.",
	["QE_NOACTION_LOOK"] = "You don't see anything special.",
	["QE_NOACTION_TALK"] = "There is nothing to say.",
	["QE_NPC"] = "Campaign NPC",
	["QE_OBJ"] = "Quest objectives",
	["QE_OBJ_ADD"] = "Add objective",
	["QE_OBJ_AUTO"] = "Auto reveal",
	["QE_OBJ_AUTO_TT"] = "Automatically reveal this objective when the quest is unlocked in the quest log.",
	["QE_OBJ_ID"] = "Objective ID",
	["QE_OBJ_ID_TT"] = "This is your objective ID. You can't have two objectives with the same ID in a same quest.",
	["QE_OBJ_NO"] = "No quest objective",
	["QE_OBJ_REMOVE"] = "Remove this quest objective?",
	["QE_OBJ_SINGULAR"] = "Quest objective",
	["QE_OBJ_TEXT"] = "Objective text",
	["QE_OBJ_TT"] = [=[Quest objectives are hints for the player. Accomplishing all objectives does not automatically complete the quest. You decide when objectives are shown so you can have secret objective in your quest.
|cffff9900Objectives are always ordered by ID in the quest log, and not following their reveal order.]=],
	["QE_OVERVIEW"] = "Quest overview",
	["QE_PREVIOUS_STEP"] = "Previously",
	["QE_PROGRESS"] = "Progression",
	["QE_PROGRESS_TT"] = [=[This parameter flags this quest as part of the campaign progression (even if the quest is not revealed).

The campaign progression is a % indicator in the quest log showing the global campaign progression (% of completed quests / total quests).

|cff00ff00Typically this should be checked, except for side/secondary quests.]=],
	["QE_QUEST"] = "Quest",
	["QE_QUEST_LIST"] = "Quests for this campaign",
	["QE_QUEST_OBJ_AND_HIST"] = "Objectives and history",
	["QE_QUEST_OBJ_FINISHED"] = "|cffffff00Objective complete: |cff00ff00%s",
	["QE_QUEST_OBJ_REVEALED"] = "|cffffff00New objective: |cff00ff00%s",
	["QE_QUEST_OBJ_UPDATED"] = "|cffffff00Objective updated: |cff00ff00%s",
	["QE_QUEST_START"] = "Starting quest |cff00ff00[%s]|r.",
	["QE_QUEST_TT_STEP"] = [=[|cffffff00Currently:|r
"%s"]=],
	["QE_QUESTS"] = "Quests",
	["QE_QUESTS_HELP"] = [=[You can add quests to your campaign here. Please note that a quest is not automatically added to the player's quests log when he starts your campaign. You have to start the quests through workflows.
|cffff9900Quests are sorted by ID in the quest log, not by name nor by reveal order.]=],
	["QE_RESET_CONFIRM"] = [=[Reset this campaign?

This will lose all your progression for ALL the quests in this campaign.

Note that you will keep all items you gained through this campaign.]=],
	["QE_ST_AUTO_REVEAL"] = "Initial step",
	["QE_ST_AUTO_REVEAL_TT"] = "Marks this step as the initial step when unlocking the quest in the quest log.",
	["QE_ST_END"] = "Final step",
	["QE_ST_END_TT"] = "Marks this step as the final step for this quest. When the step is reached, the quest will automatically be marked as completed in the quest log.",
	["QE_ST_LINKS_ON_LEAVE"] = "On quest step leave",
	["QE_ST_LINKS_ON_LEAVE_TT"] = "Triggered |cff00ff00everytime|r the player leave this step for another one. This will be triggered before the next step \"On quest step start\" trigger occurs.",
	["QE_ST_LINKS_ON_START"] = "On quest step start",
	["QE_ST_LINKS_ON_START_TT"] = "Triggered |cff00ff00everytime|r the player reachs this step.",
	["QE_ST_POST"] = "Quest log history",
	["QE_ST_PRE"] = "Quest log entry",
	["QE_STEP"] = "Quest steps",
	["QE_STEP_ADD"] = "Add quest step",
	["QE_STEP_CREATE"] = [=[Please enter the step ID. You can't have two steps with the same ID within the same quest.

|cffff9900Please note that the steps will be listed in alphabetical order of IDs here and on the database.

|cff00ff00So it's a good practice to always start your ID by step_# where # is the step number in the quest.]=],
	["QE_STEP_EXIST"] = "There is already a step with the ID %s.",
	["QE_STEP_LIST"] = "Steps for this quest",
	["QE_STEP_LIST_CURRENT"] = "Available quests",
	["QE_STEP_LIST_FINISHED"] = "Finished quests",
	["QE_STEP_MISSING"] = "Missing step information.",
	["QE_STEP_NAME_NEW"] = "New quest step",
	["QE_STEP_NO"] = "No quest step",
	["QE_STEP_REMOVE"] = "Remove this step?",
	["QE_STEP_TT"] = [=[Quest are cut down into a list of steps.
Each step can add a text entry to the quest log once reached and another history text once completed.]=],
	["QE_STEPS"] = "Quest steps",
	["QUEST_ID"] = "Quest ID",
	["QUEST_TU_1"] = [=[Quests will often require that |cff00ff00you interact with NPCs or with your environment through actions|r.
There are four types of action: |cff00ff00Listen, look, talk and interact|r.
You can perform an action by |cff00ff00right-clicking on the quest log button on the TRP3 toolbar|r.
But another easier way to do actions is to |cff00ff00create macro for it|r. To help you create the action macros you can use this button.]=],
	["QUEST_TU_2"] = [=[|cff00ff00You can find here a list of all available campaigns.|r
A campaign is a collection of one or more quests.
|cffff9900You can only progress in one campaign at a time|r. For this you must mark this campaign as the active campaign. |cff00ff00You can use the "Start or resume" button to activate or pause a campaign.|r
You won't lose your progression if you switch from one campaign to another.
|cffff9900You can reset your progression in a campaign by right-clicking on it and select Reset campaign. Note that all looted items won't be lost on campaign reset.]=],
	["QUEST_TU_3"] = [=[|cff00ff00You can find here the list of all currently available quests and all finished quests.|r
You can easily see each quest current situation and what are the current objectives.]=],
	["QUEST_TU_4"] = [=[|cff00ff00You can find here the current progression of this quest and all current objectives.|r
You can also see the history of previous steps, in case you forget something.]=],
	["ROOT_CREATED"] = "Created by %s on %s",
	["ROOT_CREATED_BY"] = "Created by",
	["ROOT_CREATED_ON"] = "Created on",
	["ROOT_GEN_ID"] = "Generated ID",
	["ROOT_ID"] = "Object ID",
	["ROOT_SAVED"] = "Last modification by %s on %s",
	["ROOT_TITLE"] = "Root object",
	["ROOT_VERSION"] = "Version",
	["SEC_EFFECT_BLOCKED"] = "Effect(s) blocked",
	["SEC_EFFECT_BLOCKED_TT"] = [=[Due to your current security settings, at least one of this item (or sub-objects) effects has been secured.

|cffff9900Click to review security for this item.

You can also Ctrl+Right-click on the item in your inventory to configure the security later.]=],
	["SEC_HIGH"] = "High",
	["SEC_HIGH_TT"] = "This item and all of its related object are secured and don't use any malicious or undesirable effects.",
	["SEC_LEVEL"] = "Security level",
	["SEC_LEVEL_DETAIL"] = "Click to see details of the unsecure scripts used.",
	["SEC_LEVEL_DETAIL2"] = "Click to see details of the unsecure scripts used and configure which ones can be executed.",
	["SEC_LEVEL_DETAILS"] = "Security details",
	["SEC_LEVEL_DETAILS_ACCEPTED"] = "Accepted",
	["SEC_LEVEL_DETAILS_ALL"] = "Switch security for all objects",
	["SEC_LEVEL_DETAILS_ALL_TT"] = "Accept the execution of this effect for all objects, now and in the future.",
	["SEC_LEVEL_DETAILS_BLOCKED"] = "Blocked",
	["SEC_LEVEL_DETAILS_FROM"] = "Always accept when received from %s",
	["SEC_LEVEL_DETAILS_SECURED"] = "This object and all its inner objects are secure!",
	["SEC_LEVEL_DETAILS_THIS"] = "Switch security for this objects",
	["SEC_LEVEL_DETAILS_THIS_TT"] = "Accept the execution of this effect for this object only.",
	["SEC_LEVEL_DETAILS_TT"] = [=[For %s and all its inner objects.
|cffff9900Made by: |cff00ff00%s
|cffff9900Received from: |cff00ff00%s]=],
	["SEC_LOW"] = "Low",
	["SEC_LOW_TT"] = "This item, or one of its related object, uses one or more unsecure scripts that can have malicious effects.",
	["SEC_MEDIUM"] = "Medium",
	["SEC_MEDIUM_TT"] = "This item, or one of its related object, uses one or more unsecure scripts that can have undesirable effects.",
	["SEC_MISSING_SCRIPT"] = "Cannot find workflow \"%s\"",
	["SEC_REASON_DISMOUNT"] = "Dismount",
	["SEC_REASON_DISMOUNT_WHY"] = [=[This object could force you to unmount.

|cffff9900It may be undesirable for you... especially if you are on a flying mount!]=],
	["SEC_REASON_SCRIPT"] = "Lua script",
	["SEC_REASON_SCRIPT_WHY"] = [=[This object could trigger any of the Extended effects.

|cffff0000It may be used in a malicious way to force you so say something reprehensible by the Blizzard terms of services that can make you banned from the game.

|cff00ff00If blocked, the code will still be executed but in a secured environment (for instance, chat effects will be printed only for you and not said by your character).]=],
	["SEC_REASON_SOUND"] = "Playing a sound",
	["SEC_REASON_SOUND_WHY"] = [=[This object could play a sound or a music that will be heard by the TRP3:E users around you.

|cffff9900It may be undesirable for them if the sound is spammed or if the sound is particulary annoying. And if it's the case, they could blame you and block you.

|cff00ff00If blocked, the sound/music will be played only for you.]=],
	["SEC_REASON_TALK"] = "Character talk",
	["SEC_REASON_TALK_WHY"] = [=[This object could force your character to say something (through /say, /yell or any other channel).

|cffff0000It may be used in a malicious way to force you so say something reprehensible by the Blizzard terms of services that can make you banned from the game.

|cff00ff00If blocked, the text will be printed only for you (and not said by your character).]=],
	["SEC_SCRIPT_ERROR"] = "Error in workflow %s.",
	["SEC_TT_COMBO"] = "Alt + Right click:|cffff9900 Configure security",
	["SEC_TT_COMBO_2"] = "Configure security",
	["SEC_UNSECURED_WHY"] = "Why is this unsecure?",
	["SET_TT_DETAILS_1"] = "Hold Alt key to show more",
	["SET_TT_DETAILS_2"] = "%s warning(s)",
	["SET_TT_OLD"] = "This item has been created with an older version of Extended (v %s). Incompatibilities may occur.",
	["SET_TT_SECURED"] = [=[Some potentially malicious effects have been secured for your safety.
|cff00ff00Alt + Right click for more details.]=],
	["SET_TT_SECURED_2"] = "Some potentially malicious effects have been secured for your safety.",
	["SET_TT_SECURED_2_1"] = "See more details.",
	["SPECIFIC"] = "Specific object",
	["SPECIFIC_INNER_ID"] = "Inner ID",
	["SPECIFIC_MODE"] = "Mode",
	["SPECIFIC_PATH"] = "Root path",
	["TB_TOOLS"] = "Extended objects database",
	["TB_TOOLS_TT"] = "Create your own items and quests.",
	["TU_AC_1_TEXT"] = [=[|cff00ff00Action links|r is where you can link a workflow to a quest action.
There are four types of quest actions that a player can perform: |cff00ff00listen, look, talk and interact|r.
You can define action links in the campaign, quest or quest step level.]=],
	["TU_AC_2"] = "Actions evaluation",
	["TU_AC_2_TEXT"] = [=[Each action can be conditionned by |cff00ff00Ctrl+click on it|r.
When the player performs an action, |cff00ff00all action links will be evaluated in a certain order|r beginning at the quest step level, then the quest and finally the campaign.
If a link can be used (if it's from the good action type and has no condition or the condition is met), then the associated workflow will be executed and |cffff9900the add-on will stop searching for another link|r.]=],
	["TU_CO_1_TEXT"] = [=[A container is an item that can contain other items.
To open a container, you can |cff00ff00double-click|r on it in the inventory.
It is possible to have a container that is also usable (by right-click). It isn't two exclusive concepts.
|cffff9900Please note that for now, you can only trade with players containers that are empty, or that contains only items that are inner objects of the container. Please see the inner object tab for more information.]=],
	["TU_CS_1_TEXT"] = [=[With |cff00ff00cutscenes|r you will be able to create a real narative experience for the player.
Cutscenes uses the layout already used in the Storyline add-on.]=],
	["TU_CS_2_TEXT"] = [=[A cutscene is a list of step that will be played one after another.
The cutscene takes place in a scene with two characters talking to each other.
In each step you will be able to completely reconfigure the scene.]=],
	["TU_CS_3_TEXT"] = [=[The step text will be cut down into sub-steps when you enter a double line break. But these sub-steps will share the same step configuration.
So you will typically change step when you want to change which character is speaking (with the "dialog direction" attribute).
When you want to change a step attribute, |cff00ff00be sure to have activated the parameter.]=],
	["TU_CS_4"] = "Cutscenes and workflows",
	["TU_CS_4_TEXT"] = [=[You can link a workflow to a step. It will be executed a the start of the step (or first sub-step).
If this workflow contains a Loot effect, you can check the "Wait for loot" option to force the player to loot before the cutscene can continue.]=],
	["TU_CS_5"] = "Preview",
	["TU_CS_5_TEXT"] = [=[You can preview your cutscene at any moment.
|cffff9900Linked workflows won't be executed in preview mode.]=],
	["TU_DB_1_TEXT"] = [=[|cff00ff00Welcome to the database tutorial.|r
This is the database, where all the objects are stored.
An object contains all information about an item, a document, a campaign/quest/step or a cutscene.]=],
	["TU_DB_2"] = "Database types",
	["TU_DB_2_TEXT"] = [=[There are four tabs, filtering the entire database.
|cff00ff00My database:|r it contains all the objects you created.
|cff00ff00Players database:|r it contains all objects you received (or imported) from other players.
|cff00ff00Backers database:|r it contains the objects created by the Kickstarter backers and the TRP3 team.
|cff00ff00Full database:|r it contains all the previous databases content.]=],
	["TU_DB_3_TEXT"] = [=[You can filter each database to find a specific object by changing the search filters and select |cff00ff00Search|r.
Without filters, the objects list follows a hierarchical presentation.
But if you filter the list, the results are shown with a flat presentation.
Here we just filtered the list by object type to show only the |cffff9900items|r.
To exit the search mode, click on the |cff00ff00Clear|r button in the filters panel.]=],
	["TU_DB_4"] = "Root and inner objects",
	["TU_DB_4_TEXT"] = [=[There are two kind of objects: |cff00ff00root objects and inner objects|r.
|cff00ff00Inner objects|r are always stored in a |cff00ff00root object|r (even if they can be inside another inner object all the way to the root).
When you exchange an item with someone, all the root object information is actually exchanged, even if the item is only an inner object.
So for now, just remember that using inner objects is a good way to link objects that always should be exchange together.
Examples:
- An item showing a document: the document would be an inner object of the root item object.
- A campaign with 4 quests: each quest is actually an inner object of the root campaign object.
- A gun item firing bullet item: the bullet object would be an inner object of the root gun object.
But don't worry, it will come naturally !]=],
	["TU_DB_5"] = "Root objects",
	["TU_DB_5_TEXT"] = [=[Only items and campaigns can be root objects.

You can use these two buttons to create an new item or campaign.]=],
	["TU_DB_6"] = "Create an item",
	["TU_DB_6_TEXT"] = [=[When creating a new item, you can select a template or use the quick creation mode.
The |cff00ff00quick creation|r mode allows you to easily create a first item, but the possibilities are limited. Now that you can always go to normal creation mode afterward.
Use the |cff00ff00blank item|r template if you want to start from scratch without any example.
The |cff00ff00document item|r template will actually create two objects: an item object and its document inner object. It will also configure the item to show the document when used.
The |cff00ff00container item|r template will create and configure an item object to be used as a container.
Finally, the |cff00ff00create from|r allows you to duplicate an existing item.]=],
	["TU_DB_7"] = "Object line",
	["TU_DB_7_TEXT"] = "Each line represents an object. You can click on it to edit it or right click to perform various actions.",
	["TU_EL_1_TEXT"] = [=[The event links tab is the place where you can |cff00ff00link your workflows to events|r.
|cffff9900Indeed, workflows aren't executed automatically by default!|r So you have to link them to an event in order to have them executed when that event occurs.
We have here two type of events: |cff00ff00Object events and Game events|r.]=],
	["TU_EL_2_TEXT"] = [=[|cff00ff00Object events|r are event proper to how Total RP 3 works.
The list of possible events is fixed and depends on the type of the object (item, quest ..etc).
You can link one event to only one workflow. But the same workflow can be linked to multiple events.]=],
	["TU_EL_3_TEXT"] = [=[|cff00ff00Game events|r are events triggered by the game when something happens.
Each link you add will link a game event to a workflow. Each time the event occurs, the workflow will be executed.
|cff00ff00You can add a condition to the link by Ctrl+click on it.|r The condition will have access to the event arguments to be tested.
For example if you listen to the event of casting a spell, you will be able in the condition to test which spell is casted.
|cffff9900There is a large list of game event, thus it wouldn't be for us to list them all in the add-on. We suggest you to consult webwite like wowwiki.
http://wowwiki.wikia.com/wiki/Event_API]=],
	["TU_EL_3_TEXT_V2"] = [=[|cff00ff00Game events|r are events triggered by the game when something happens.

Each link you add will link a game event to a workflow. Each time the event occurs, the workflow will be executed.

|cff00ff00You can add a condition to the link by Ctrl+click on it.|r The condition will have access to the event arguments to be tested.
For example if you listen to the event of casting a spell, you will be able in the condition to test which spell is casted.

|cffff9900There is a large list of game event, thus it wouldn't be for us to list them all in the add-on. We suggest you to consult webwite like wowwiki.
http://wowwiki.wikia.com/wiki/Event_API

|rIn addition to the game's events, |cff00ff00Total RP 3: Extended offers a couple of custom events|r detailed on the addon wiki.
|cff00ff00https://github.com/Ellypse/Total-RP-3-Extended/wiki|r]=],
	["TU_EL_4_TEXT"] = "|cff00ff00Game events|r are only available for campaigns, quests and quest steps.",
	["TU_IT_1_TEXT"] = [=[|cff00ff00Welcome to the item creation tutorial.|r
An item is an object that you can store in your character's inventory (or drop it on the ground).
You are here on the Main tab where you can define all the basic attributes for your item.]=],
	["TU_IT_2"] = "Display attributes",
	["TU_IT_2_TEXT"] = [=[The display attributes are purely cosmetic and don't have any "gameplay" effect.
It's all about the attributes needed for the item tooltip and the item icon.]=],
	["TU_IT_3"] = "Free notes",
	["TU_IT_3_TEXT"] = [=[You can write down notes to help you remember what do you want to do with your item.
These notes can also help others that would want to start an item based on yours.]=],
	["TU_IT_4"] = "Gameplay attributes",
	["TU_IT_4_TEXT"] = [=[The gameplay attributes have some effects on the gameplay.
Two attributes are important: |cff00ff00Usable|r and |cff00ff00Container|r as checking them will display the |cff00ff00Workflow|r and |cff00ff00Container|r tabs.]=],
	["TU_TITLE"] = "Tutorial",
	["TU_WO_1_TEXT"] = [=[|cff00ff00Welcome to the workflow creation tutorial.|r
A workflow is the mechanism that can bring life to your creation. It's here that you will be able to play effects like showing text, playing a sound or looting an item to the player.]=],
	["TU_WO_2"] = "Workflow list",
	["TU_WO_2_TEXT"] = [=[On the left you have the |cff00ff00workflows list|r.
You can remove, rename or copy/paste a workflow by right-clicking on it.
|cffff9900Note: If you are here when editing an item in "normal mode", you won't see a list of workflows but only a single "On use" workflow for the item. If you want to be able to use multiple workflows for an item, you can convert this item to "Expert mode" by right-clicking on it in the databases view.]=],
	["TU_WO_3_TEXT"] = [=[Here is a list of all the workflow elements.
An element can be an effect, a delay or a condition.
The element order is important because they will be executed sequentially during the workflow execution.
You can change the element order by using the arrows at the top right of each elements.]=],
	["TU_WO_4"] = "Add an effect",
	["TU_WO_4_TEXT"] = [=[Effects are things like "playing a sound", "displaying a text" or "start a cutscene".
There are a LOT of effects, each are explained in their own tooltip!]=],
	["TU_WO_5"] = "Add a condition",
	["TU_WO_5_TEXT"] = [=[Conditions allow you to |cff00ff00test values in order to stop the workflow execution.|r
|cffff9900If the condition is not met, the workflow execution won't continue further.|r
A condition is composed of a series of tests linked together by the OR or AND operator.
Each test is a values comparision. For example: "The target's health is lesser than 500", "The player is not dead" or "The player has more than 3 units of item [xxx] in his inventory".]=],
	["TU_WO_6"] = "Add a delay",
	["TU_WO_6_TEXT"] = "Delays can pause the execution of the workflow for a given time, but they can also act as a cast and interrupt the workflow if the player moves.",
	["TU_WO_ERROR_1"] = "Please create a workflow before resuming this tutorial.",
	["TYPE"] = "Type",
	["TYPE_CAMPAIGN"] = "Campaign",
	["TYPE_DIALOG"] = "Cutscene",
	["TYPE_DOCUMENT"] = "Document",
	["TYPE_ITEM"] = "Item",
	["TYPE_ITEMS"] = "Item(s)",
	["TYPE_LOOT"] = "Loot",
	["TYPE_QUEST"] = "Quest",
	["TYPE_QUEST_STEP"] = "Quest step",
	["UNIT_FRIES"] = "fries",
	["UNIT_POTATOES"] = "potatoes",
	["WO_ACTIONS_LINKS"] = "Action links",
	["WO_ACTIONS_LINKS_TT"] = [=[Here you can link your workflows to player quest actions.
These actions are: |cff00ff00Interact, listen, talk and inspect.|r
Each link can be conditioned.]=],
	["WO_ADD"] = "Create workflow",
	["WO_ADD_ID"] = [=[|cff00ff00Enter the workflow ID.|r

It's an internal ID to help you manage your workflows and won't be visible by the user.

Please note that you can't have two workflows with the same ID within the same object.]=],
	["WO_ADD_ID_NO_AVAILABLE"] = "This workflow ID is not available.",
	["WO_COMMON_EFFECT"] = "Common effects",
	["WO_CONDITION"] = "Condition",
	["WO_CONDITION_TT"] = [=[Evaluates a condition.
Stops the workflow if the condition fails.]=],
	["WO_CONTEXT"] = "Context",
	["WO_CONTEXT_TT"] = "The workflow context determines which effects can be used in the workflow.",
	["WO_COPY"] = "Copy workflow content",
	["WO_DELAY"] = "Delay",
	["WO_DELAY_CAST"] = "Casts for",
	["WO_DELAY_CAST_SOUND"] = "Cast sound ID",
	["WO_DELAY_CAST_SOUND_TT"] = [=[A sound ID for a precast sound. You can put a loopable sound here and it will be interrupted in case of cast interruption.

|cff00ff00Examples: 12273, 12361, ...etc.]=],
	["WO_DELAY_CAST_TEXT"] = "Cast text",
	["WO_DELAY_CAST_TEXT_TT"] = "The text placed on the cast bar.",
	["WO_DELAY_DURATION"] = "Duration",
	["WO_DELAY_DURATION_TT"] = "The duration for this delay, in seconds.",
	["WO_DELAY_INTERRUPT"] = "Interruption",
	["WO_DELAY_INTERRUPT_1"] = "No interruption",
	["WO_DELAY_INTERRUPT_2"] = "Interrupt on move",
	["WO_DELAY_SECONDS"] = "second(s)",
	["WO_DELAY_TT"] = [=[Pauses the workflow.
Can also be used as a cast and can be interrupt.]=],
	["WO_DELAY_TYPE"] = "Delay type",
	["WO_DELAY_TYPE_1"] = "Regular delay",
	["WO_DELAY_TYPE_1_TT"] = "Simply pauses the workflow, without showing any specific information to the player.",
	["WO_DELAY_TYPE_2"] = "Cast",
	["WO_DELAY_TYPE_2_TT"] = "Show a casting bar during the workflow pause.",
	["WO_DELAY_WAIT"] = "Waits for",
	["WO_EFFECT"] = "Effect",
	["WO_EFFECT_CAT_COMMON"] = "Common",
	["WO_EFFECT_NO_EDITOR"] = "This effect cannot be configured.",
	["WO_EFFECT_SELECT"] = "Select an effect",
	["WO_EFFECT_TT"] = [=[Plays an effect.
It can be playing sounds, displaying text, etc...]=],
	["WO_ELEMENT"] = "Element edition",
	["WO_ELEMENT_ADD"] = "Add element to workflow",
	["WO_ELEMENT_COND"] = "Edit effect condition",
	["WO_ELEMENT_COND_NO"] = "Remove effect condition",
	["WO_ELEMENT_COND_TT"] = "Adds a condition to this single effect.",
	["WO_ELEMENT_COPY"] = "Copy element content",
	["WO_ELEMENT_EDIT"] = "Click to edit element",
	["WO_ELEMENT_EDIT_CTRL"] = "Control-click to condition this instruction",
	["WO_ELEMENT_EDIT_RIGHT"] = "Right-click for more operations",
	["WO_ELEMENT_PASTE"] = "Paste element content",
	["WO_ELEMENT_TYPE"] = "Select the element type",
	["WO_EMPTY"] = [=[You can start by adding an element to your workflow.
This can be an effect, condition or delay.]=],
	["WO_END"] = "End of workflow",
	["WO_EVENT_EX_ADD"] = "Add event link",
	["WO_EVENT_EX_CONDI"] = "Event link condition editor",
	["WO_EVENT_EX_EDITOR"] = "Event link editor",
	["WO_EVENT_EX_LINK"] = "Game event link",
	["WO_EVENT_EX_LINKS"] = "Game event links",
	["WO_EVENT_EX_LINKS_TT"] = [=[Here you can link your workflows to game events.
Each link can be conditioned.]=],
	["WO_EVENT_EX_NO"] = "No event link",
	["WO_EVENT_ID"] = "Event ID",
	["WO_EVENT_ID_TT"] = [=[The event ID.

You can see the entire event list on websites like WoWWiki of Wowpedia.

Here as an example, PLAYER_REGEN_DISABLED is triggered when you enter a combat.]=],
	["WO_EVENT_LINKS"] = "Object event links",
	["WO_EXECUTION"] = "Workflow execution",
	["WO_EXPERT"] = "Expert mode",
	["WO_EXPERT_DONE"] = "Switched %s to expert mode. Now unleash your creativity!",
	["WO_EXPERT_EFFECT"] = "Expert effects",
	["WO_EXPERT_TT"] = [=[A workflow is a set of instructions that can make your object dynamic.

Here you can define all your workflows for this object, then you can link them to an action in the event links tab.]=],
	["WO_LINKS"] = "Event links",
	["WO_LINKS_NO_LINKS"] = "No link",
	["WO_LINKS_NO_LINKS_TT"] = "Does not link this action/event to a workflow.",
	["WO_LINKS_SELECT"] = "Select a workflow to link",
	["WO_LINKS_TO"] = "Linked to workflow",
	["WO_LINKS_TRIGGERS"] = "Here you can link your workflows to specifics events for this object.",
	["WO_NO"] = "No workflows",
	["WO_PASTE"] = "Paste workflow content",
	["WO_PASTE_CONFIRM"] = "Replace this workflow content with the one you copied earlier?",
	["WO_REMOVE_POPUP"] = "Delete the workflow %s?",
	["WO_SECURITY"] = "Security level",
	["WO_SECURITY_HIGH"] = "High",
	["WO_SECURITY_HIGH_DETAILS"] = "This effect is secured and will not prompt security warning.",
	["WO_SECURITY_LOW"] = "Low",
	["WO_SECURITY_LOW_DETAILS"] = "This effect is not secured and could be malicious. It will prompt a security warning and will ask for confirmation, based on the user security settings.",
	["WO_SECURITY_NORMAL"] = "Medium",
	["WO_SECURITY_NORMAL_DETAILS"] = "This effect is secured but could cause inconveniences. It will prompt a security warning, based on the user security settings.",
	["WO_WO_SECURITY"] = "Workflow security",
	["WO_WORKFLOW"] = "Workflows"
}

Localization:GetLocale("enUS"):AddTexts(localeContent);
localeContent = {
	["ALL"] = "Alle",
	["BINDING_NAME_TRP3_INVENTORY"] = "Inventar des Charakters öffnen",
	["BINDING_NAME_TRP3_QUEST_ACTION"] = "Quest Aktion: Interagieren",
	["BINDING_NAME_TRP3_QUEST_LISTEN"] = "Quest Aktion: Zuhören",
	["BINDING_NAME_TRP3_QUEST_LOOK"] = "Quest Aktion: Untersuchen",
	["BINDING_NAME_TRP3_QUEST_TALK"] = "Quest Aktion: Reden",
	["BINDING_NAME_TRP3_SEARCH_FOR_ITEMS"] = "Suche nach Gegenständen",
	["CA_ACTION_CONDI"] = "Aktionsbedingungen-Editor",
	["CA_ACTION_REMOVE"] = "Diese Aktion entfernen?",
	["CA_ACTIONS"] = "Aktionen",
	["CA_ACTIONS_ADD"] = "Aktion hinzufügen",
	["CA_ACTIONS_EDITOR"] = "Aktioneneditor",
	["CA_ACTIONS_NO"] = "Keine Aktion",
	["CA_DESCRIPTION"] = "Kampagnenzusammenfassung",
	["CA_DESCRIPTION_TT"] = "Diese kurze Zusammenfassung wird auf der Kampagnenseite im Questjournal zu sehen sein.",
	["CA_ICON"] = "Kampagnenicon",
	["CA_ICON_TT"] = "Wähle Kampagnenicon",
	["CA_IMAGE"] = "Kampagnenportrait",
	["CA_IMAGE_TT"] = "Wähle Kampagnenportrait",
	["CA_NAME"] = "Kampagnenname",
	["CA_NAME_NEW"] = "Neue Kampagne",
	["CA_NAME_TT"] = "Dies ist der Name Ihrer Kampagne. Es erscheint im Questlog.",
	["CA_NO_NPC"] = "Kein individueller NPC",
	["CA_NPC"] = "Kampagnen NPC Liste",
	["CA_NPC_ADD"] = "Füge benutzerdefinierten NPC hinzu",
	["CA_NPC_AS"] = "Duplikat",
	["CA_NPC_EDITOR"] = "NPC-Editor",
	["CA_NPC_EDITOR_DESC"] = "Beschreibung des NPC",
	["CA_NPC_EDITOR_NAME"] = "Name des NPC",
	["CA_NPC_ID"] = "NPC ID",
	["CA_NPC_ID_TT"] = [=[Bitte geben sie die ID des NPCs für die Anpassung ein.

|cff00ff00Um die ID eines anvisierten NPCs zu erhalten, gebe diesen Befehl in den Chat ein: /trp3 getID]=],
	["CA_NPC_NAME"] = "Standartname des NPC",
	["CA_NPC_REMOVE"] = "Anpassung für diesen NPC entfernen?",
	["CA_NPC_TT"] = "Du kannst NPCs anpassen, um ihnen einen eigenen Namen, ein Bild und eine Beschreibung geben. Diese Anpassungen sind nur für den Spieler sichtbar, der deine Kampagne aktiviert hat.",
	["CA_NPC_UNIT"] = "Angepasster NPC",
	["CA_QE_ID"] = "Ändere Quest-ID",
	["CA_QE_ST_ID"] = "Ändere Questfortschritt-ID",
	["CA_QUEST_ADD"] = "Quest hinzufügen",
	["CA_QUEST_CREATE"] = [=[Bitte gebe eine Quest-ID ein. Es kann keine zwei Quests mit der selben ID in der selben Kampagne.

|cffff9900Bitte bedenke, dass die Quests nach ID sortiert im Questjournal aufgelistet werden.

|cff00ff00Es ist gute Praktik, die Quest-ID mit quest_# zu starten, wobei # die tatsächliche Questnummer innerhalb der Kampagne ist.]=],
	["CA_QUEST_EXIST"] = "Es existiert bereits eine Quest mit der ID %s.",
	["CA_QUEST_NO"] = "Keine Quest",
	["CA_QUEST_REMOVE"] = "Diese Quest entfernen?",
	["COND_EDITOR"] = "Bedingungseditor",
	["COND_EDITOR_EFFECT"] = "Effektbedingungseditor",
	["COND_LITT_COMP"] = "Alle Vergleichstypen",
	["COND_NUM_COMP"] = "Nur numerische Vergleiche",
	["COND_NUM_FAIL"] = "Du musst zwei numerische Operanten angeben, wenn du einen numerischen Vergleich verwendest.",
	["COND_PREVIEW_TEST"] = "Testvorschau",
	["COND_PREVIEW_TEST_TT"] = "Gibt im Chat die Bewertung des Tests basierend auf die derzeitige Situation aus.",
	["COND_TEST_EDITOR"] = "Testeditor",
	["COND_TESTS"] = "Bedingungstests",
	["CONF_MAIN"] = [=[
Erweiterte Einstellungen]=],
	["CONF_MUSIC_ACTIVE"] = "Spiele Umgebungssound ab",
	["CONF_MUSIC_ACTIVE_TT"] = [=[Lokale Musik ist Musik, welche von anderen Spieler (zum Beispiel durch ein Item) in einer bestimmten Reichweite gespielt wird.

Schalte dies aus, wenn du diese Musik nicht hören möchtest.

Von Spielern die du ignorierst wirst du keine Musik hören.

Beachte, dass du die Musik über die Sound History in dem TRP3-Shortcut-Balken unterbrechen kannst.]=],
	["CONF_SOUNDS"] = "Umgebungsgeräusche / Musik",
	["CONF_SOUNDS_ACTIVE"] = "Ton abspielen",
	["CONF_SOUNDS_ACTIVE_TT"] = [=[Sounds sind Geräusche/Musik, die durch andere Spieler (zum Beispiel mit einem Gegenstand) innerhalb einer bestimmten Reichweite in Meter abgespielt werden.

Deaktiviere diese Option wenn du gar keine Sounds hören möchtest.

|cff00ff00Du wirst niemals Sounds von ignorierten Spielern hören.

|cff00ff00Alle Sounds können mit der Soundhistorie in der TRP3 Schnellzugriffleiste unterbrochen werden.]=],
	["CONF_SOUNDS_MAXRANGE"] = "Maximale Abspielreichweite",
	["CONF_SOUNDS_MAXRANGE_TT"] = [=[Setze die maximale Reichweite (in Meter) in der du Sounds in der Umgebung hören würdest.

|cff00ff00Es ist nützlich, damit Sounds nicht über den ganzen Kontinent für andere Spieler abgespielt werden.

cffff9900Null bedeutet, dass es kein Limit gibt!]=],
	["CONF_SOUNDS_METHOD"] = "Methode zum Abspielen von Umgebungsgeräuschen",
	["CONF_SOUNDS_METHOD_1"] = "Automatisch abspielen",
	["CONF_SOUNDS_METHOD_1_TT"] = "Wenn du in Reichweite bist wird die Musik/das Geräusch automatisch ohne deine Zustimmung abgespielt.",
	["CONF_SOUNDS_METHOD_2"] = "Anfrage stellen",
	["CONF_SOUNDS_METHOD_2_TT"] = "Wenn du in Reichweite bist erhältst du einen Link in deinem Chat, in dem du bestätigst, dass du diese Musik/dieses Geräusch abspielen willst.",
	["CONF_SOUNDS_METHOD_TT"] = "Bestimme, wie du in Reichweite Geräusche hören möchtest.",
	["CONF_UNIT"] = "Einheiten",
	["CONF_UNIT_WEIGHT"] = "Gewichtseinheiten",
	["CONF_UNIT_WEIGHT_1"] = "Gramm",
	["CONF_UNIT_WEIGHT_2"] = "Pfund",
	["CONF_UNIT_WEIGHT_3"] = "Kartoffel",
	["CONF_UNIT_WEIGHT_TT"] = "Definiere, wie das Gewicht angezeigt wird.",
	["DB"] = "Datenbank",
	["DB_ACTIONS"] = "Aktionen",
	["DB_ADD_COUNT"] = "Wie viel %s möchtest du deinem Inventar hinzufügen?",
	["DB_ADD_ITEM"] = "Zum Hauptinventar hinzufügen",
	["DB_ADD_ITEM_TT"] = "Fügt Mengen dieses Gegenstands in deinen erste Tasche (oder dein Hauptinventar wenn du keine Tasche auf diesem Charakter besitzt).",
	["DB_BROWSER"] = "Objektbrowser",
	["EDITOR_ICON_SELECT"] = "Klicke um ein Icon zu wählen.",
	["EDITOR_ID_COPY"] = "Kopiere ID",
	["EDITOR_MORE"] = "Mehr",
	["EDITOR_NOTES"] = "Freie Notizen",
	["EDITOR_PREVIEW"] = "Vorschau",
	["EDITOR_WIDTH"] = "Breite",
	["EFFECT_CAT_CAMERA"] = "Kamera",
	["EFFECT_CAT_CAMERA_LOAD"] = "Lade Kamera",
	["EFFECT_CAT_CAMERA_LOAD_TT"] = "Setzt die Kamera des Spielers auf eine vorher gespeicherte Position.",
	["EFFECT_CAT_CAMERA_SAVE"] = "Speichere Kamera",
	["EFFECT_CAT_CAMERA_SAVE_TT"] = "Speichert die derzeitige Kameraposition des Spielers in eine der 5 verfügbaren Speicherplätze.",
	["EFFECT_CAT_CAMERA_SLOT"] = "Platznummer",
	["EFFECT_CAT_CAMPAIGN"] = "Kampagne und Quest",
	["EFFECT_CAT_SOUND"] = "Geräusche und Musik",
	["EFFECT_CAT_SPEECH"] = "Sprache und Emotes",
	["EFFECT_DIALOG_START"] = "Starte Zwischensequenz",
	["EFFECT_DIALOG_START_TT"] = "Starte eine Zwischensequenz. Wenn gerade eine Zwischensequenz abgespielt wird, wird sie unterbrochen und durch diese ersetzt.",
	["EFFECT_DOC_ID"] = "Dokument ID",
	["EFFECT_ITEM_ADD"] = "Gegenstand hinzufügen",
	["EFFECT_ITEM_ADD_CRAFTED"] = "Hergestellt",
	["EFFECT_ITEM_ADD_ID"] = "Gegenstands ID",
	["EFFECT_ITEM_ADD_QT"] = "Anzahl",
	["EFFECT_ITEM_ADD_TT"] = "Fügt Gegenstände deiner Tasche hinzu.",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD"] = "Typ",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_DAMAGE"] = "Schaden",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_HEAL"] = "Reparieren",
	["EFFECT_SOUND_ID_LOCAL"] = "Ton abspielen",
	["EFFECT_SOUND_ID_LOCAL_PREVIEW"] = "Spiele Sound ID %s in Channel %s in einem Radius von %s Meter.",
	["EFFECT_SOUND_ID_SELF_ID"] = "Sound ID",
	["EFFECT_SOUND_ID_SELF_PREVIEW"] = "Spielt Sound ID %s im Channel %s ab.",
	["EFFECT_SOUND_MUSIC_LOCAL"] = "Umgebungsmusik abspielen",
	["EFFECT_SOUND_MUSIC_LOCAL_PREVIEW"] = "spielt die Musik \"%s\" in einem Radius von %s Meter ab.",
	["EFFECT_SOUND_MUSIC_LOCAL_TT"] = "Spielt Musik für umliegende Spieler ab.",
	["EFFECT_SOUND_MUSIC_SELF"] = "Musik abspielen",
	["EFFECT_SOUND_MUSIC_STOP"] = "Musik stoppen",
	["EFFECT_SOUND_PLAY"] = "Abspielen",
	["EX_SOUND_HISTORY"] = "Soundhistorie",
	["EX_SOUND_HISTORY_EMPTY"] = "Es wurde kein Sound abgespielt.",
	["EX_SOUND_HISTORY_LINE"] = "%s hat SoundID %s im Channel %s abgespielt.",
	["EX_SOUND_HISTORY_REPLAY"] = "Wiederholen",
	["EX_SOUND_HISTORY_STOP"] = "Stop",
	["EX_SOUND_HISTORY_STOP_ALL"] = "Alles stoppen",
	["IT_DR_SOUND"] = "Sound entfernen",
	["IT_PU_SOUND"] = "Aufnehmen-Geräusch",
	["IT_PU_SOUND_1183"] = "Tasche",
	["IT_PU_SOUND_1184"] = "Buch",
	["IT_PU_SOUND_1185"] = "Stoff",
	["IT_PU_SOUND_1186"] = "Essen",
	["IT_PU_SOUND_1187"] = "Kräuter",
	["IT_PU_SOUND_1188"] = "Kette",
	["IT_PU_SOUND_1189"] = "Fleisch",
	["IT_PU_SOUND_1190"] = "Großes Metal",
	["IT_PU_SOUND_1191"] = "Kleines Metal",
	["IT_PU_SOUND_1192"] = "Papier",
	["IT_PU_SOUND_1193"] = "Ring",
	["IT_PU_SOUND_1194"] = "Stein",
	["IT_PU_SOUND_1195"] = "Kleine Kette",
	["IT_PU_SOUND_1196"] = "Stab",
	["IT_PU_SOUND_1197"] = "Flüssigkeit",
	["IT_PU_SOUND_1198"] = "Kleines Holz",
	["IT_PU_SOUND_1199"] = "Großes Holz",
	["IT_PU_SOUND_1221"] = "Edelsteine",
	["QE_QUESTS"] = "Kanal:",
	["SEC_HIGH"] = "Hoch",
	["SEC_HIGH_TT"] = "Dieser Gegenstand und alle zugehörigen Objekte sind sicher und nutzen keine potenziell bösartigen oder ungewollten Effekte.",
	["SEC_LOW"] = "Niedrig",
	["SEC_LOW_TT"] = "Dieser Gegenstand, oder einer der zugehörigen Objekte, benutzt ein oder mehrere unsichere Skripte, die potenziell böswillige Effekte haben.",
	["SEC_MEDIUM"] = "Mittel",
	["SEC_MEDIUM_TT"] = "Dieser Gegenstand, oder einer der zugehörigen Objekte, benutzt ein oder mehrere unsichere Skripte, die potentiell ungewollte Effekte haben.",
	["SEC_MISSING_SCRIPT"] = "Arbeitsablauf \"%s\" nicht gefunden",
	["SEC_REASON_DISMOUNT"] = "Absitzen",
	["SEC_REASON_DISMOUNT_WHY"] = [=[Dieser Gegenstand könnte dich zum absitzen zwingen.

|cffff9900Das könnte sehr unangenehm für dich werden... Vor allem auf einem fliegenden Reittier!]=],
	["SEC_REASON_SCRIPT"] = "Lua Skript",
	["SEC_REASON_SCRIPT_WHY"] = [=[Dieses Objekt könnte jeden "TotalRP 3: Extended"-Effekt auslösen.

|cffff0000Es könnte in einer bösartigen Weise verwendet werden, etwas laut Blizzards Nutzungsbedingungen verwerfliches zu sagen. So etwas kann einen Ausschluss (Ban) vom Spiel bedeuten.

|cff00ff00Wenn der Code blockiert wird, wird er weiterhin in einer gesicherten Umgebung ausgeführt (Chateffekte werden zum Beispiel nur für dich ausgegeben, von deinem Charakter aber nicht ausgesprochen).]=],
	["SEC_REASON_SOUND"] = "Sound abspielen",
	["SEC_SCRIPT_ERROR"] = "Fehler in Arbeitsabfolge %s.",
	["WO_EXPERT"] = "Expertenmodus",
	["WO_LINKS_NO_LINKS"] = "kein Link",
	["WO_LINKS_NO_LINKS_TT"] = "Verknüpft diese Aktion/dieses Ereignis nicht mit einem Arbeitsablauf.",
	["WO_LINKS_SELECT"] = "Arbeitsablauf zum verknüpfen wählen",
	["WO_LINKS_TO"] = "Verknüpft mit Arbeitsablauf",
	["WO_LINKS_TRIGGERS"] = "Hier kannst du deinen Arbeitsablauf mit einem bestimmten Ereignis deines Objekt verknüpfen.",
	["WO_NO"] = "keine Arbeitsabläufe",
	["WO_PASTE"] = "Füge Inhalt des Arbeitsablauf ein",
	["WO_SECURITY_HIGH"] = "Hoch",
	["WO_SECURITY_LOW"] = "Niedrig",
	["WO_SECURITY_NORMAL"] = "Mittel",
	["WO_SECURITY_NORMAL_DETAILS"] = "Der Effekt ist abgesichert, aber könnte Unannehmlichkeiten erzeugen. Es werden Warnungen basierend auf den Sicherheitseinstellungen des Benutzers angezeigt.",
	["WO_WO_SECURITY"] = "Sicherheit der Arbeitsabläufe",
	["WO_WORKFLOW"] = "Arbeitsabläufe"
}

Localization:GetLocale("deDE"):AddTexts(localeContent);
localeContent = {
	["ALL"] = "Tous",
	["BINDING_NAME_TRP3_INVENTORY"] = "Ouvrir l'inventaire du personnage",
	["BINDING_NAME_TRP3_MAIN_CONTAINER"] = "Ouvrir le contenant principal",
	["BINDING_NAME_TRP3_QUEST_ACTION"] = "Action de quête : interagir",
	["BINDING_NAME_TRP3_QUEST_LISTEN"] = "Action de quête : écouter",
	["BINDING_NAME_TRP3_QUEST_LOOK"] = "Action de quête : observer",
	["BINDING_NAME_TRP3_QUEST_TALK"] = "Action de quête : parler",
	["BINDING_NAME_TRP3_QUESTLOG"] = "Ouvrir le journal de quêtes TRP3",
	["BINDING_NAME_TRP3_SEARCH_FOR_ITEMS"] = "Rechercher des objets",
	["CA_ACTION_CONDI"] = "Éditeur de condition d'action",
	["CA_ACTION_REMOVE"] = "Supprimer cette action ?",
	["CA_ACTIONS"] = "Actions",
	["CA_ACTIONS_ADD"] = "Ajouter action",
	["CA_ACTIONS_COND"] = "Modifier condition",
	["CA_ACTIONS_COND_OFF"] = "Cette action n'est pas conditionnée.",
	["CA_ACTIONS_COND_ON"] = "Cette action est conditionnée.",
	["CA_ACTIONS_COND_REMOVE"] = "Supprimer condition",
	["CA_ACTIONS_EDITOR"] = "Éditeur d'action",
	["CA_ACTIONS_NO"] = "Pas d'action",
	["CA_ACTIONS_SELECT"] = "Sélection de type d'action",
	["CA_DESCRIPTION"] = "Résumé de la campagne",
	["CA_DESCRIPTION_TT"] = "Ce bref résumé apparaîtra sur la page de la campagne, dans le journal de quêtes.",
	["CA_ICON"] = "Icône de la campagne",
	["CA_ICON_TT"] = "Sélection de l'icône de campagne",
	["CA_IMAGE"] = "Portrait de campagne",
	["CA_IMAGE_TT"] = "Sélection du portrait de campagne",
	["CA_LINKS_ON_START"] = "Au lancement de la campagne",
	["CA_LINKS_ON_START_TT"] = [=[Déclenché |cff00ff00une seule fois|r lorsque le joueur commence votre campagne, donc lorsqu'il active votre campagne pour la première fois, ou la réinitialise dans le journal de quêtes.

|cff00ff00C'est un bon endroit où placer l'activation de la première quête.|r]=],
	["CA_NAME"] = "Nom de campagne",
	["CA_NAME_NEW"] = "Nouvelle campagne",
	["CA_NAME_TT"] = "C'est le nom de votre campagne. Il apparaît dans le journal de quêtes.",
	["CA_NO_NPC"] = "Pas de PNJ personnalisé",
	["CA_NPC"] = "Liste des PNJs de campagne",
	["CA_NPC_ADD"] = "Ajouter un PNJ personnalisé",
	["CA_NPC_AS"] = "Dupliquer",
	["CA_NPC_EDITOR"] = "Éditeur de PNJ",
	["CA_NPC_EDITOR_DESC"] = "Description du PNJ",
	["CA_NPC_EDITOR_NAME"] = "Nom du PNJ",
	["CA_NPC_ID"] = "ID du PNJ",
	["CA_NPC_ID_TT"] = [=[Veuillez entrer l'identifiant du PNJ à personnaliser.

|cff00ff00Pour obtenir l'identifiant d'un PNJ actuellement ciblé, tapez cette commande dans le chat: /trp3 getID]=],
	["CA_NPC_NAME"] = "Nom de PNJ par défaut",
	["CA_NPC_REMOVE"] = "Supprimer ce PNJ personnalisé ?",
	["CA_NPC_TT"] = [=[Vous pouvez personnaliser des PNJs afin de leur donner un nom, une icône et une description.
Cette personnalisation sera visible lorsque le joueur aura votre campagne comme campagne active.]=],
	["CA_NPC_UNIT"] = "PNJ personnalisé",
	["CA_QE_ID"] = "Changer l'ID de quête",
	["CA_QE_ST_ID"] = "Changer l'ID de l'étape de quête",
	["CA_QUEST_ADD"] = "Ajouter quête",
	["CA_QUEST_CREATE"] = [=[Veuillez entrer l'ID de quête. Vous ne pouvez avoir deux quêtes avec le même ID au sein d'une campagne.

|cffff9900Veuillez noter que les quêtes seront listées dans le journal par ordre alphabétique d'ID.

|cff00ff00Il est donc conseillé de commencer l'ID d'une quête par quete_#, où le # est le numéro d’apparition voulu de la quête dans le journal.]=],
	["CA_QUEST_EXIST"] = "Il y a déjà une quête avec l'identifiant %s.",
	["CA_QUEST_NO"] = "Pas de quête",
	["CA_QUEST_REMOVE"] = "Supprimer cette quête ?",
	["CL_CAMPAIGN_PROGRESSION"] = "Progression pour %s:",
	["CL_CREATION"] = "Création Extended",
	["CL_EXTENDED_CAMPAIGN"] = "Campagne Extended",
	["CL_EXTENDED_ITEM"] = "Object Extended",
	["CL_IMPORT"] = "Importer dans la base de données",
	["CL_IMPORT_ITEM_BAG"] = "Ajouter dans votre inventaire",
	["CL_TOOLTIP"] = "Créer un lien de discussion",
	["COM_NPC_ID"] = "voir l'ID du PNJ ciblé",
	["COND_COMPLETE"] = "Expression logique complète",
	["COND_CONDITIONED"] = "Conditionné",
	["COND_EDITOR"] = "Éditeur de condition",
	["COND_EDITOR_EFFECT"] = "Editeur de condition d'effet",
	["COND_LITT_COMP"] = "Tous types de comparaison",
	["COND_NUM_COMP"] = "Comparaison numérique seulement",
	["COND_NUM_FAIL"] = "Vous devez avoir deux opérandes numériques si vous utilisez un comparateur numérique.",
	["COND_PREVIEW_TEST"] = "Prévisualiser le test",
	["COND_PREVIEW_TEST_TT"] = "Imprime dans la fenêtre de discussion l'évaluation de ce test, basé sur la situation actuelle.",
	["COND_TEST_EDITOR"] = "Éditeur de test",
	["COND_TESTS"] = "Tests de la condition",
	["CONF_MAIN"] = "Extended",
	["CONF_MUSIC_ACTIVE"] = "Jouer les musiques locales",
	["CONF_MUSIC_ACTIVE_TT"] = [=[Les musiques locales sont des musiques jouées par d'autres joueurs (par exemple via un objet) dans un certain rayon en mètres.

Désactivez ceci si vous voulez ne pas entendre ces musiques.

|cff00ff00Notez que vous n'entendrez jamais les musiques des joueurs ignorés.

|cff00ff00Notez que toutes les musiques sont interruptibles via l'Historique sonore dans la barre de raccourcis TRP3.]=],
	["CONF_MUSIC_METHOD"] = "Méthode d'écoute de musique locale",
	["CONF_MUSIC_METHOD_TT"] = "Détermine de quelle façon vous entendrez une musique locale quand vous êtes à portée.",
	["CONF_SOUNDS"] = "Musiques / sons locaux",
	["CONF_SOUNDS_ACTIVE"] = "Jouer les sons locaux",
	["CONF_SOUNDS_ACTIVE_TT"] = [=[Les sons locaux sont des sons joués par d'autres joueurs (par exemple via un objet) dans un certain rayon en mètres.

Désactivez ceci si vous voulez ne pas entendre ces sons.

|cff00ff00Notez que vous n'entendrez jamais les sons des joueurs ignorés.

|cff00ff00Notez que tous les sons sont interruptibles via l'Historique sonore dans la barre de raccourcis TRP3.]=],
	["CONF_SOUNDS_MAXRANGE"] = "Distance maximum d'écoute",
	["CONF_SOUNDS_MAXRANGE_TT"] = [=[Règle le rayon maximum (en mètres) dans lequel vous entendrez les musiques/sons locaux.

|cffff9900Utile pour éviter les personnes jouant des sons à l'échelle de tout le continent.

|cffff9900Zéro correspond à pas de limite !]=],
	["CONF_SOUNDS_METHOD"] = "Méthode d'écoute de son local",
	["CONF_SOUNDS_METHOD_1"] = "Jouer automatiquement",
	["CONF_SOUNDS_METHOD_1_TT"] = "Si vous êtes à portée, les musiques/sons seront joués sans demander votre permission.",
	["CONF_SOUNDS_METHOD_2"] = "Demander la permission",
	["CONF_SOUNDS_METHOD_2_TT"] = "Si vous êtes à portée, un lien apparaîtra dans la fenêtre de discussion pour vous demander confirmation avant de jouer la musique ou le son.",
	["CONF_SOUNDS_METHOD_TT"] = "Détermine de quelle façon vous entendrez un son local quand vous êtes à portée.",
	["CONF_UNIT"] = "Unités",
	["CONF_UNIT_WEIGHT"] = "Unité de poids",
	["CONF_UNIT_WEIGHT_1"] = "Grammes",
	["CONF_UNIT_WEIGHT_2"] = "Livres",
	["CONF_UNIT_WEIGHT_3"] = "Pommes de terre",
	["CONF_UNIT_WEIGHT_TT"] = "Définit de quelle façon les poids sont affichés.",
	["DB"] = "Base de données",
	["DB_ACTIONS"] = "Actions",
	["DB_ADD_COUNT"] = "Combien d'unités de %s voulez-vous ajouter à votre inventaire ?",
	["DB_ADD_ITEM"] = "Ajouter à l'inventaire principal",
	["DB_ADD_ITEM_TT"] = "Ajoute des unités de cet objet dans votre contenant principal (ou dans l'inventaire principal si vous n'avez pas de contenant principal sur votre personnage).",
	["DB_BACKERS"] = "Base de données Backers (%s)",
	["DB_BACKERS_LIST"] = "Remerciements",
	["DB_BROWSER"] = "Navigateur de créations",
	["DB_COPY_ID_TT"] = "Affiche l'identifiant de création dans une nouvelle fenêtre pour être copié-collé.",
	["DB_COPY_TT"] = "Copie toutes les informations de cette création et de ses créations liées, pour permettre de les coller en tant que création interne.",
	["DB_CREATE_CAMPAIGN"] = "Créer une campagne",
	["DB_CREATE_CAMPAIGN_TEMPLATES_BLANK"] = "Campagne vierge",
	["DB_CREATE_CAMPAIGN_TEMPLATES_BLANK_TT"] = [=[Un modèle vierge.
Pour ceux qui préfèrent commencer de zéro.]=],
	["DB_CREATE_CAMPAIGN_TEMPLATES_FROM"] = "Créer à partir de...",
	["DB_CREATE_CAMPAIGN_TEMPLATES_FROM_TT"] = "Crée une copie d'une campagne préexistante.",
	["DB_CREATE_CAMPAIGN_TT"] = "Commencer la création d'une campagne",
	["DB_CREATE_ITEM"] = "Créer un objet",
	["DB_CREATE_ITEM_TEMPLATES"] = "Ou sélectionnez un modèle",
	["DB_CREATE_ITEM_TEMPLATES_BLANK"] = "Objet vierge",
	["DB_CREATE_ITEM_TEMPLATES_BLANK_TT"] = [=[Un modèle vierge.
Pour ceux qui préfèrent commencer de zéro.]=],
	["DB_CREATE_ITEM_TEMPLATES_CONTAINER"] = "Objet contenant",
	["DB_CREATE_ITEM_TEMPLATES_CONTAINER_TT"] = [=[Un modèle de contenant.
Un contenant peut contenir d'autres objets.]=],
	["DB_CREATE_ITEM_TEMPLATES_DOCUMENT"] = "Objet document",
	["DB_CREATE_ITEM_TEMPLATES_DOCUMENT_TT"] = [=[Un modèle d'objet incluant un document.
Utile pour créer rapidement un livre ou un parchemin.]=],
	["DB_CREATE_ITEM_TEMPLATES_EXPERT"] = "Objet expert",
	["DB_CREATE_ITEM_TEMPLATES_EXPERT_TT"] = [=[Un modèle expert vierge.
Pour les joueurs expérimentés dans la création d'objets.]=],
	["DB_CREATE_ITEM_TEMPLATES_FROM"] = "Créer à partir de...",
	["DB_CREATE_ITEM_TEMPLATES_FROM_TT"] = "Crée une copie d'un objet préexistant.",
	["DB_CREATE_ITEM_TEMPLATES_QUICK"] = "Création rapide",
	["DB_CREATE_ITEM_TEMPLATES_QUICK_TT"] = [=[Crée rapidement un objet simple et sans effet.
En ajoute une unité dans votre sac principal.]=],
	["DB_CREATE_ITEM_TT"] = "Sélectionner un modèle pour un nouvel objet.",
	["DB_DELETE_TT"] = "Supprime cette création et tous ses éléments enfants.",
	["DB_EXPERT_TT"] = "Bascule cette création en mode expert, qui permet des personnalisations plus poussées.",
	["DB_EXPORT"] = "Exportation rapide de création",
	["DB_EXPORT_DONE"] = [=[Votre création a été exportée dans un fichier appelé |cff00ff00totalRP3_Extended_ImpExport.lua|r dans ce dossier du jeu :

World of Warcraft\WTF\
account\YOUR_ACCOUNT\SavedVariables

Vous pouvez partager ce fichier avec vos amis !

Vous pouvez suivre le processus d'exportation dans |cff00ff00Full Database tab|r.]=],
	["DB_EXPORT_HELP"] = "Code pour la création %s (taille: %0.1f ko)",
	["DB_EXPORT_MODULE_NOT_ACTIVE"] = "Import/export complet de création: Veuillez activer l'add-on totalRP3_Extended_ImpExport en premier lieu.",
	["DB_EXPORT_TOO_LARGE"] = [=[Cette création est trop lourde une fois sérialisée pour être exportée de cette façon. Veuillez utiliser la méthode d'exportation complète.

Taille : %0.1f kB.]=],
	["DB_EXPORT_TT"] = [=[Sérialise le contenu de cette création pour être échangeable en-dehors du jeu.

Fonctionne seulement sur de petites créations (moins de 20 ko après sérialisation). pour de plus grosses créations, utilisez la méthode d'exportation complète.]=],
	["DB_FILTERS"] = "Filtres de recherche",
	["DB_FILTERS_CLEAR"] = "Effacer",
	["DB_FILTERS_NAME"] = "Nom de la création",
	["DB_FILTERS_OWNER"] = "Créé par",
	["DB_FULL"] = "Base de données complète (%s)",
	["DB_FULL_EXPORT"] = "Exportation complète",
	["DB_FULL_EXPORT_TT"] = [=[Effectuez une exportation complète pour cette création, peu importe sa taille.

Ceci déclenchera un rechargement de l'interface, de façon à forcer l'écriture du fichier de sauvegarde d'add-on.]=],
	["DB_HARD_SAVE"] = "Sauvegarde forcée",
	["DB_HARD_SAVE_TT"] = "Recharge l'interface du jeu de façon à forcer l'écriture des éléments à sauvegarder sur le disque.",
	["DB_IMPORT"] = "Importation rapide de création",
	["DB_IMPORT_CONFIRM"] = [=[Cette création a été sérialisée dans une version de TotalRP3:Extended différente de la vôtre.

Version TRP3E de l'importation : %s
Votre version TRP3E : %s

|cffff9900Ceci peut engendrer des incompatibilités.
Poursuivre l'importation malgré tout ?]=],
	["DB_IMPORT_DONE"] = "Création importée avec succès !",
	["DB_IMPORT_EMPTY"] = [=[Il n'y a pas de création à importer dans votre fichier |cff00ff00totalRP3_Extended_ImpExport.lua|r.

Le fichier doit être placé dans ce dossier du jeu |cffff9900avant de lancer le jeu|r:

World of Warcraft\WTF\
account\YOUR_ACCOUNT\SavedVariables]=],
	["DB_IMPORT_ERROR1"] = "La création n'a pas pu être dé-sérialisée.",
	["DB_IMPORT_FULL"] = "Importation complète de créations",
	["DB_IMPORT_FULL_CONFIRM"] = [=[Voulez-vous importer la création suivante ?

%s
%s
Par |cff00ff00%s|r
Version %s]=],
	["DB_IMPORT_FULL_TT"] = "Importe le fichier |cff00ff00totalRP3_Extended_ImpExport.lua|r.",
	["DB_IMPORT_ITEM"] = "Importer l'objet",
	["DB_IMPORT_TT"] = "Collez ici une création précédemment sérialisée.",
	["DB_IMPORT_VERSION"] = [=[Vous êtes en train d'importer une version plus ancienne de cette création, par rapport à celle que vous détenez.

Version de l'importation : %s
Votre version : %s

|cffff9900Confirmez-vous ce retour en arrière ?]=],
	["DB_IMPORT_WORD"] = "Importer",
	["DB_LIST"] = "Liste des créations",
	["DB_LOCALE"] = "Langue",
	["DB_MY"] = "Ma base de données (%s)",
	["DB_MY_EMPTY"] = [=[Vous n'avez pas encore de créations.
Utilisez un des boutons ci-dessous et déchaînez votre créativité !]=],
	["DB_OTHERS"] = "Base de données des joueurs (%s)",
	["DB_OTHERS_EMPTY"] = "Ici seront placées toutes les créations d'autres joueurs.",
	["DB_REMOVE_OBJECT_POPUP"] = [=[Veuillez confirmer la suppression de cette création:
Identifiant : |cff00ffff"%s"|r
|cff00ff00[%s]|r

|cffff9900Attention : Cette action est irréversible !]=],
	["DB_RESULTS"] = "Résultats de la recherche",
	["DB_SECURITY_TT"] = "Montre tous les paramètres de sécurité pour cette création. À partir d'ici, vous pourrez autoriser ou non certains effets indésirables.",
	["DB_TO_EXPERT"] = "Basculer en mode expert",
	["DB_WARNING"] = [=[|cffff0000!!! Attention !!!

|cffff9900N'oubliez pas d'enregistrer vos modifications avant de revenir à la liste de la base de données !]=],
	["DEBUG_QUEST_START"] = "Commencer la quête",
	["DEBUG_QUEST_START_USAGE"] = "Utilisation: /trp3 debug_quest_start ID_de_quete",
	["DEBUG_QUEST_STEP"] = "Aller à une étape de quête.",
	["DEBUG_QUEST_STEP_USAGE"] = "Utilisation: /trp3 debug_quest_step ID_de_quete ID_detape",
	["DI_ATTR_TT"] = "Cochez si vous souhaitez changer la valeur de ce paramètre par rapport à l'étape précédente.",
	["DI_ATTRIBUTE"] = "Modifier les attributs",
	["DI_BKG"] = "Image de fond",
	["DI_BKG_TT"] = [=[Sera utilisé comme fond d'écran pour l'étape de dialogue. Merci d'entre le chemin complet de la texture.

Si vous changez le fond d'écran pendant le dialogue, ces fonds d'écran s’enchaîneront en fondu.]=],
	["DI_CHOICE"] = "Choix",
	["DI_CHOICE_CONDI"] = "Condition de choix",
	["DI_CHOICE_STEP"] = "Aller à l'étape",
	["DI_CHOICE_STEP_TT"] = [=[Entrez le numéro d'étape du dialogue à jouer si le joueur sélectionne ce choix de dialogue.

|cff00ff00Si laissé vide ou si le numéro est invalide, cela mettra fin au dialogue si sélectionné (et déclenchera l’événement d'objet "A la fin").]=],
	["DI_CHOICE_TT"] = [=[Entrez le texte pour cette option.

|cff00ff00Laissez vide pour désactiver cette option.]=],
	["DI_CHOICES"] = "Choix laissés au joueur",
	["DI_CHOICES_TT"] = "Configurer les choix laissés au joueur pour cette étape.",
	["DI_CONDI_TT"] = [=[Définit une condition pour cette option. Si la condition n'est pas validée quand les options sont affichées, l'option en question ne sera pas visible.

|cff00ff00Clic : Configurer la condition
Clic droit : Effacer la condition]=],
	["DI_DIALOG"] = "Dialogue",
	["DI_DISTANCE"] = "Distance max (mètres)",
	["DI_DISTANCE_TT"] = [=[Définit la distance maximum (en mètres) à laquelle le joueur peut aller une fois la scène lancée, avant qu'elle ne se ferme automatiquement (et ne déclenche donc l'évènement "Annulé" de l'élément).

|cff00ff00Zéro signifie : pas de limite.

|cff00ff00Ne fonctionne pas en instance/champ de bataille/arène depuis le patch 7.1.]=],
	["DI_END"] = "Étape de terminaison",
	["DI_END_TT"] = [=[Marque cette étape comme étape de terminaison. Lorsqu'elle sera atteinte, cela mettra fin au dialogue (et déclenchera l'événement d'objet "A la fin").

|cff00ff00Pratique si vous utilisez les choix de dialogue.]=],
	["DI_FRAME"] = "Décoration",
	["DI_GET_ID"] = "ID de la cible",
	["DI_GET_ID_TT"] = "Copie l'ID PNJ de la cible. Ne fonctionne que si votre cible actuelle est un PNJ.",
	["DI_HISTORY"] = "Historique des cinématiques",
	["DI_HISTORY_TT"] = "Cliquez pour voir/cacher le panneau d'historique, qui montre les précédentes lignes de cinématique.",
	["DI_IMAGE"] = "Image",
	["DI_IMAGE_TT"] = [=[Affiche une image au centre de la fenêtre de cinématique. L'image apparaîtra en fondu. Veuillez entrer le chemin de la texture entière.

Pour cacher l'image par la suite, laissez juste le champ vide.]=],
	["DI_LEFT_UNIT"] = "Modèle de gauche",
	["DI_LINKS_ONEND"] = "En fin de cinématique",
	["DI_LINKS_ONEND_TT"] = [=[Déclenché lorsque la cinématique est terminée.

|cff00ff00Cela peut se produire lorsque la dernière étape est atteinte ou lorsqu'un choix laissé au joueur mène à une étape vide ou non existante.

|cffff0000Cela n'est PAS déclenché lorsque le joueur annule la cinématique en fermant manuellement la fenêtre de cinématique.]=],
	["DI_LINKS_ONSTART"] = "En début de cinématique",
	["DI_LINKS_ONSTART_TT"] = [=[Déclenché lorsque la cinématique commence.

|cffff9900Notez que ce déclencheur se lance avant que la première étape de cinématique ne s'exécute.]=],
	["DI_LOOT"] = "Attendre le butin",
	["DI_LOOT_TT"] = "Si le processus sélectionné à gauche déclenche l'affichage d'un butin pour le joueur, vous pouvez cocher ce paramètre pour empêcher le joueur de passer à l'étape suivante du dialogue tant qu'il n'a pas récupéré l'intégralité du butin.",
	["DI_MODELS"] = "Modèles",
	["DI_NAME"] = "Nom de l'orateur",
	["DI_NAME_DIRECTION"] = "Direction du dialogue",
	["DI_NAME_DIRECTION_TT"] = "Détermine comment placer la bulle et le nom, et quel modèle animer. Ne rien sélectionner revient à cacher la bulle et le nom.",
	["DI_NAME_TT"] = [=[Le nom du personnage parlant.

Seulement nécessaire si la direction de dialogue ci-dessus n'est pas mise à "Aucun".]=],
	["DI_NEXT"] = "Indice d'étape suivante",
	["DI_NEXT_TT"] = [=[Vous pouvez indiquer quelle étape sera jouée après celle-ci.

|cff00ff00Laissez vide pour jouer l'index suivant dans l'ordre séquentiel, n'utilisez ce champ que si vous devez "sauter" à un autre index. Utile quand vous programmez des choix.]=],
	["DI_RIGHT_UNIT"] = "Modèle de droite",
	["DI_STEP"] = "Étape de cinématique",
	["DI_STEP_ADD"] = "Ajouter étape",
	["DI_STEP_EDIT"] = "Édition d'étape de cinématique",
	["DI_STEP_TEXT"] = "Texte d'étape",
	["DI_STEPS"] = "Étapes de cinématique",
	["DI_UNIT_TT"] = [=[Définit le modèle à afficher :

- Laissez vide pour cacher le modèle
- "player", pour utiliser le modèle du joueur
- "target", pour utiliser le modèle de la cible
- un nombre voulu, pour charger un ID de PNJ]=],
	["DI_WAIT_LOOT"] = "Veuillez ramasser tous les objets",
	["DISCLAIMER"] = [=[{h1:c}Veuillez lire{/h1}

La création d'objets et quêtes prend du temps et de l'énergie, et c'est toujours tragique de perdre tout ce dur labeur accompli...

Tous les add-ons de World of Warcraft peuvent stocker des données mais il y a des limites :

• Il y a une limite de taille des données, pour les données d'add-on, qui est inconnue (dépend de si vous tournez sur un client 32 ou 64 bits, entre autres).
• Atteindre cette limite peut balayer d'un coup toutes les données enregistrées d'add-on.
• "Killer" le processus, fermer le jeu de force (Alt+F4) ou crasher peut corrompre les données enregistrées d'add-on.
• Même si vous quittez le jeu proprement, il existe toujours une chance que le jeu ne parvienne pas à sauvegarder les données d'add-on, et les corrompe.

Au regard de tout ceci, nous recommandons FORTEMENT de sauvegarder ailleurs, régulièrement, vos données enregistrées d'add-on.

Vous trouverez ici un tutoriel sur la façon de retrouver toutes les données enregistrées :
{link*https://totalrp3.info/documentation/how_to/saved_variables*Where are my information stored?}

Vous trouverez ici un tutoriel sur la façon de synchroniser vos données avec un service de "cloud" :
{link*https://totalrp3.info/documentation/how_to/backup_and_sync_profiles*How to backup and synchronize your add-ons settings using a cloud service}

Veuillez comprendre que nous ne répondrons plus aux commentaires ni aux requêtes relevant d'une perte de données.
Ce n'est pas parce que nous ne voulons pas aider, mais parce que nous ne pouvons techniquement rien faire pour restaurer des données perdues.

Merci, et profitez bien de Total RP 3 Extended !

{p:r}L'équipe de TRP3{/p}]=],
	["DISCLAIMER_OK"] = "Par la présente, je signe ce contrat de mon sang",
	["DO_EMPTY"] = "Document vide",
	["DO_LINKS_ONCLOSE"] = "À la fermeture",
	["DO_LINKS_ONCLOSE_TT"] = "Déclenché quand le document est fermé par le joueur ou un autre évènement (par ex. via un effet de processus)",
	["DO_LINKS_ONOPEN"] = "À l'ouverture",
	["DO_LINKS_ONOPEN_TT"] = "Déclenché quand le document est montré au joueur.",
	["DO_NEW_DOC"] = "Document",
	["DO_PAGE_ADD"] = "Ajouter page",
	["DO_PAGE_BORDER"] = "Bordure",
	["DO_PAGE_BORDER_1"] = "Parchemin",
	["DO_PAGE_COUNT"] = "Page %s / %s",
	["DO_PAGE_EDITOR"] = "Éditeur de page : page %s",
	["DO_PAGE_FIRST"] = "Première page",
	["DO_PAGE_FONT"] = "police %s",
	["DO_PAGE_HEIGHT"] = "Hauteur de page",
	["DO_PAGE_HEIGHT_TT"] = "La hauteur de page, en pixels. Veuillez noter que certains fonds supportent seulement un certain rapport hauteur/largeur et peuvent se trouver déformés.",
	["DO_PAGE_LAST"] = "Dernière page",
	["DO_PAGE_MANAGER"] = "Gestionnaire de pages",
	["DO_PAGE_NEXT"] = "Page suivante",
	["DO_PAGE_PREVIOUS"] = "Page précédente",
	["DO_PAGE_REMOVE"] = "Supprimer page",
	["DO_PAGE_REMOVE_POPUP"] = "Supprimer la page %s ?",
	["DO_PAGE_RESIZE"] = "Taille changeable",
	["DO_PAGE_RESIZE_TT"] = [=[Permet à l'utilisateur de changer la taille de la fenêtre.

|cffff9900Soyez sûr que votre mise en page soit lisible et ne dépende pas du rapport hauteur/largeur.

|cff00ff00Notez que l'utilisateur ne pourra jamais réduire la taille de fenêtre en-dessous des largeur et hauteur par défaut.]=],
	["DO_PAGE_TILING"] = "Répétition de fond d'écran",
	["DO_PAGE_TILING_TT"] = "Cochez si le fond d'écran doit être répété horizontalement et verticalement. Si non, la texture sera étirée.",
	["DO_PAGE_WIDTH"] = "Largeur de page",
	["DO_PAGE_WIDTH_TT"] = "La largeur de page, en pixels. Veuillez noter que certains fonds supportent seulement un certain rapport hauteur/largeur et peuvent se trouver déformés.",
	["DO_PARAMS_CUSTOM"] = "Paramètres personnalisés de page",
	["DO_PARAMS_GLOBAL"] = "Paramètres par défaut",
	["DO_PARAMS_GLOBAL_TT"] = "Change les paramètres par défaut du document. Ces paramètres seront employés pour toutes les pages qui n'ont pas de paramètres de page spécifiés.",
	["DO_PREVIEW"] = "Cliquer pour voir l'aperçu",
	["DOC_UNKNOWN_ALERT"] = "Ouverture du document impossible. (Classe manquante)",
	["DR_DELETED"] = "Détruit : %s x%d",
	["DR_DROPED"] = "Déposé au sol : %s x%d",
	["DR_NOTHING"] = "Aucun objet trouvé dans cette zone.",
	["DR_POPUP"] = "Déposer ici",
	["DR_POPUP_ASK"] = [=[Total RP 3

Choisissez quoi faire de cet objet :
%s]=],
	["DR_POPUP_REMOVE"] = "Détruire",
	["DR_POPUP_REMOVE_TEXT"] = "Détruire cet objet ?",
	["DR_RESULTS"] = "%s objets trouvés",
	["DR_SEARCH_BUTTON"] = "Rechercher |cff00ff00mes|r objets",
	["DR_SEARCH_BUTTON_TT"] = "Recherche vos objets dans la zone des 15 mètres alentours.",
	["DR_STASHED"] = "Cachés : %s x%d",
	["DR_STASHES"] = "Cachettes",
	["DR_STASHES_CREATE"] = "Créer une cachette ici",
	["DR_STASHES_CREATE_TT"] = "Crée une cachette où vous êtes.",
	["DR_STASHES_DROP"] = "Vous ne pouvez pas déposer d'objet dans la cachette de quelqu'un d'autre.",
	["DR_STASHES_EDIT"] = "Éditer la cachette",
	["DR_STASHES_ERROR_OUT_SYNC"] = "Cachette dé-synchronisée, veuillez réessayer.",
	["DR_STASHES_ERROR_SYNC"] = "Cachette non synchronisée.",
	["DR_STASHES_FOUND"] = "Cachettes trouvées : %s",
	["DR_STASHES_FULL"] = "Cette cachette est pleine.",
	["DR_STASHES_HIDE"] = "Rendre furtif au radar",
	["DR_STASHES_HIDE_TT"] = [=[Cette cachette n'apparaîtra pas sur le radar de carte des autres joueurs.

NB : Elle leur sera toujours accessible, s'ils savent déjà où elle est.]=],
	["DR_STASHES_MAX"] = "50 caractères max",
	["DR_STASHES_NAME"] = "Cachette",
	["DR_STASHES_NOTHING"] = "Aucune cachette trouvée dans cette zone.",
	["DR_STASHES_OWNERSHIP"] = "Approprier",
	["DR_STASHES_OWNERSHIP_PP"] = [=[S'approprier la cachette ?
Ce personnage sera affiché comme propriétaire de la cachette lorsque d'autres personnages effectueront un scan.]=],
	["DR_STASHES_REMOVE"] = "Supprimer cachette",
	["DR_STASHES_REMOVE_PP"] = [=[Supprimer cette cachette ?
|cffff9900Tous les objets encore à l'intérieur seront perdus !]=],
	["DR_STASHES_REMOVED"] = "Cachette supprimée.",
	["DR_STASHES_RESYNC"] = "Resynchroniser",
	["DR_STASHES_SCAN"] = "Afficher toutes les cachettes",
	["DR_STASHES_SCAN_MY"] = "Afficher mes cachettes",
	["DR_STASHES_SEARCH"] = "Rechercher des cachettes de |cff00ff00joueurs|r",
	["DR_STASHES_SEARCH_TT"] = [=[Recherche des cachettes d'autres joueurs dans les 15 mètres alentours.

La recherche durera 3 secondes, patience !]=],
	["DR_STASHES_SYNC"] = "Synchronisation...",
	["DR_STASHES_TOO_FAR"] = "Vous êtes trop loin de cette cachette.",
	["DR_STASHES_WITHIN"] = "|cff00ff00Vos|r cachettes dans les 15 mètres",
	["DR_SYSTEM"] = "Système de dépôt",
	["DR_SYSTEM_TT"] = [=[Déposez / cherchez des objets et créez / accédez à vos cachettes.

Le système de dépôt ne fonctionne pas en donjon/arène/champ de bataille.]=],
	["EDITOR_BOTTOM"] = "Bas",
	["EDITOR_CANCEL_TT"] = [=[Annule tous les changements sur l'élément %s entier (l'élément-racine et tous ses éléments internes).

|cffff9900Les changements non sauvegardés seront perdus !]=],
	["EDITOR_CONFIRM"] = "Confirmer",
	["EDITOR_HEIGHT"] = "Hauteur",
	["EDITOR_ICON"] = "Choisir icône",
	["EDITOR_ICON_SELECT"] = "Cliquez pour choisir une icône.",
	["EDITOR_ID_COPY"] = "Copier l'ID",
	["EDITOR_ID_COPY_POPUP"] = "Vous pouvez copier l'identifiant d'élément ci-dessous si vous avez besoin de le copier ailleurs.",
	["EDITOR_MAIN"] = "Principal",
	["EDITOR_MORE"] = "Plus",
	["EDITOR_NOTES"] = "Notes libres",
	["EDITOR_PREVIEW"] = "Prévisualiser",
	["EDITOR_SAVE_TT"] = "Sauvegarde tous les changements sur l'élément %s entier (l'élément-racine et tous ses éléments internes) et incrémente automatiquement son numéro de version.",
	["EDITOR_TOP"] = "Haut",
	["EDITOR_WARNINGS"] = [=[Il y a %s avertissements.

|cffff9900%s|r

Sauvegarder quand même ?]=],
	["EDITOR_WIDTH"] = "Largeur",
	["EFFECT_CAT_CAMERA"] = "Caméra",
	["EFFECT_CAT_CAMERA_LOAD"] = "Charger caméra",
	["EFFECT_CAT_CAMERA_LOAD_TT"] = "Place la caméra du joueur à une position précédemment sauvegardée.",
	["EFFECT_CAT_CAMERA_SAVE"] = "Sauvegarder caméra",
	["EFFECT_CAT_CAMERA_SAVE_TT"] = "Sauvegarde la position actuelle de la caméra du joueur dans un des 5 emplacements disponibles.",
	["EFFECT_CAT_CAMERA_SLOT"] = "Emplacement de sauvegarde",
	["EFFECT_CAT_CAMERA_SLOT_TT"] = "L'index d'un des 5 emplacements de sauvegarde disponibles.",
	["EFFECT_CAT_CAMERA_ZOOM_DISTANCE"] = "Distance de zoom",
	["EFFECT_CAT_CAMERA_ZOOM_IN"] = "Zoomer caméra",
	["EFFECT_CAT_CAMERA_ZOOM_IN_TT"] = "Zoomer la caméra d'une certaine distance",
	["EFFECT_CAT_CAMERA_ZOOM_OUT"] = "Dézoomer caméra",
	["EFFECT_CAT_CAMERA_ZOOM_OUT_TT"] = "Dézoomer la caméra d'une certaine distance.",
	["EFFECT_CAT_CAMPAIGN"] = "Campagne et quête",
	["EFFECT_CAT_SOUND"] = "Son et musique",
	["EFFECT_CAT_SPEECH"] = "Parole et émotes",
	["EFFECT_COOLDOWN_DURATION"] = "Durée de rafraîchissement",
	["EFFECT_COOLDOWN_DURATION_TT"] = "Le temps du \"cooldown\", en secondes.",
	["EFFECT_DIALOG_ID"] = "ID de cinématique",
	["EFFECT_DIALOG_QUICK"] = "Cinématique rapide",
	["EFFECT_DIALOG_QUICK_TT"] = "Génère rapidement une cinématique d'une seule étape. Elle prendra automatiquement la cible du joueur comme orateur.",
	["EFFECT_DIALOG_START"] = "Démarrer cinématique",
	["EFFECT_DIALOG_START_PREVIEW"] = "Démarre la cinématique %s.",
	["EFFECT_DIALOG_START_TT"] = "Démarre une cinématique. Si une cinématique est déjà en lecture, elle sera coupée et remplacée par celle-ci.",
	["EFFECT_DISMOUNT"] = "Désarçonner",
	["EFFECT_DISMOUNT_TT"] = "Désarçonne le joueur de sa monture actuelle.",
	["EFFECT_DISPET"] = "Renvoyer mascotte",
	["EFFECT_DISPET_TT"] = "Renvoie la mascotte actuellement invoquée.",
	["EFFECT_DOC_CLOSE"] = "Fermer document",
	["EFFECT_DOC_CLOSE_TT"] = "Ferme le document actuellement ouvert. Pas d'effet s'il n'y a pas de document affiché.",
	["EFFECT_DOC_DISPLAY"] = "Afficher document",
	["EFFECT_DOC_DISPLAY_TT"] = "Affiche un document au joueur. Si un document est déjà ouvert, il sera fermé et remplacé.",
	["EFFECT_DOC_ID"] = "ID de document",
	["EFFECT_DOC_ID_TT"] = [=[Le document à montrer.

|cffffff00Veuillez entrer l'ID du document complet (ID-mère et ID inclus).

|cffffff00Conseil : copiez-collez l'ID complet pour être sûr d'éviter les coquilles.]=],
	["EFFECT_ITEM_ADD"] = "Ajouter objet",
	["EFFECT_ITEM_ADD_CRAFTED"] = "Artisanat",
	["EFFECT_ITEM_ADD_CRAFTED_TT"] = "Marque les objets ajoutés (via processus) comme étant \"Fabriqué par xxx\" où xxx sera le nom du joueur.",
	["EFFECT_ITEM_ADD_ID"] = "ID d'objet",
	["EFFECT_ITEM_ADD_ID_TT"] = [=[L'objet à ajouter.

|cffffff00Veuillez entrer l'ID d'objet complet (ID-mère et ID inclus).

|cffffff00Conseil : copiez-collez l'ID complet pour être sûr d'éviter les coquilles.]=],
	["EFFECT_ITEM_ADD_PREVIEW"] = "Ajoute %sx %s",
	["EFFECT_ITEM_ADD_QT"] = "Quantité",
	["EFFECT_ITEM_ADD_QT_TT"] = [=[Le nombre d'objets à ajouter.

|cffffff00NB : L'addon fera de son mieux pour atteindre cette quantité mais il est possible que tous les objets ne soient pas ajoutés : par exemple si le sac devient plein ou si l'objet a une limite d'unités qu'un personnage peut détenir (attribut "Unique" notamment).]=],
	["EFFECT_ITEM_ADD_TT"] = "Ajoute des objets à votre sac.",
	["EFFECT_ITEM_BAG_DURABILITY"] = "Endommager/Réparer contenant",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD"] = "Type",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_DAMAGE"] = "Endommager",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_DAMAGE_TT"] = "Abîme le contenant-mère. L'état du contenant-mère ne peut tomber en-dessous de 0.",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_HEAL"] = "Réparer",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_HEAL_TT"] = "Répare le contenant-mère. L'état du contenant-mère ne peut être meilleur que la durabilité maximum du contenant.",
	["EFFECT_ITEM_BAG_DURABILITY_PREVIEW_1"] = "|cff00ff00Répare|cffffff00 %s points d'état sur le contenant-mère.",
	["EFFECT_ITEM_BAG_DURABILITY_PREVIEW_2"] = "|cff00ff00Endommage|cffffff00 le contenant-mère de %s points d'état.",
	["EFFECT_ITEM_BAG_DURABILITY_TT"] = [=[Répare ou endommage la durabilité de l'objet contenant-mère.

|cff00ff00Ne fonctionne que sur les contenants ayant une durabilité définie.]=],
	["EFFECT_ITEM_BAG_DURABILITY_VALUE"] = "Point d'état",
	["EFFECT_ITEM_BAG_DURABILITY_VALUE_TT"] = "Le nombre de points d'état à ajouter/soustraire de la durabilité du contenant-mère.",
	["EFFECT_ITEM_CONSUME"] = "Consommer objet",
	["EFFECT_ITEM_CONSUME_TT"] = "Consomme l'objet utilisé et le détruit.",
	["EFFECT_ITEM_COOLDOWN"] = "Lancer rafraîchissement",
	["EFFECT_ITEM_COOLDOWN_PREVIEW"] = "Durée : %s seconde(s)",
	["EFFECT_ITEM_COOLDOWN_TT"] = "Déclenche un \"cooldown\" pour cet objet.",
	["EFFECT_ITEM_DICE"] = "Lancer de dés",
	["EFFECT_ITEM_DICE_PREVIEW"] = "Lancer %s",
	["EFFECT_ITEM_DICE_PREVIEW_STORED"] = "Lancer %s et sauvegarder le résultat dans %s",
	["EFFECT_ITEM_DICE_ROLL"] = "Lancer",
	["EFFECT_ITEM_DICE_ROLL_TT"] = [=[Entrez une configuration de lancer, similaire à celle de la commande /trp3 roll.

|cff00ff00Exemple: 1d20, 3d6 ..etc.]=],
	["EFFECT_ITEM_DICE_ROLL_VAR"] = "Nom de la variable (optionnel)",
	["EFFECT_ITEM_DICE_ROLL_VAR_TT"] = [=[La variable dans laquelle vous souhaitez sauvegarder le résultat du lancer de dés.
Laisser vierge si vous ne souhaitez pas sauvegarder le résultat.]=],
	["EFFECT_ITEM_DICE_TT"] = "They see me rollin', they hating.",
	["EFFECT_ITEM_LOOT"] = "Montrer/déposer butin",
	["EFFECT_ITEM_LOOT_DROP"] = "Déposer objets",
	["EFFECT_ITEM_LOOT_DROP_TT"] = "Dépose des objets au sol au lieu de présenter une fenêtre de butin au joueur. Le joueur peut ensuite ramasser les objets qu'il veut via la méthode \"rechercher des objets\".",
	["EFFECT_ITEM_LOOT_NAME"] = "Nom de la source",
	["EFFECT_ITEM_LOOT_NAME_TT"] = "Ce sera le nom du contenant du butin.",
	["EFFECT_ITEM_LOOT_PREVIEW_1"] = "Dépose %s objet(s) au sol.",
	["EFFECT_ITEM_LOOT_PREVIEW_2"] = "Affiche un butin de %s objet(s).",
	["EFFECT_ITEM_LOOT_SLOT"] = "Cliquez sur un emplacement pour le configurer.",
	["EFFECT_ITEM_LOOT_TT"] = "Affiche un contenant de butin au joueur, ou dépose le butin au sol là où est le joueur.",
	["EFFECT_ITEM_REMOVE"] = "Détruire objet",
	["EFFECT_ITEM_REMOVE_ID_TT"] = [=[L'objet à supprimer.

|cffffff00Veuillez entrer l'ID d'objet complet (ID-mère et ID inclus).

|cffffff00Conseil : copiez-collez l'ID complet pour être sûr d'éviter les coquilles.]=],
	["EFFECT_ITEM_REMOVE_PREVIEW"] = "Détruit %sx %s",
	["EFFECT_ITEM_REMOVE_QT_TT"] = "Le nombre d'objets à supprimer.",
	["EFFECT_ITEM_REMOVE_TT"] = "Détruit l'objet depuis votre inventaire.",
	["EFFECT_ITEM_SOURCE"] = "Rechercher dans",
	["EFFECT_ITEM_SOURCE_1"] = "Tout l'inventaire",
	["EFFECT_ITEM_SOURCE_1_TT"] = "Recherche l'objet dans tout l'inventaire du personnage.",
	["EFFECT_ITEM_SOURCE_2"] = "Contenant-mère",
	["EFFECT_ITEM_SOURCE_2_TT"] = [=[Recherche l'objet seulement dans cet objet contenant-mère (et dans ses éventuels sous-contenants).

|cffff9900Fonctionne seulement si ce script est dans un contexte d'objet.]=],
	["EFFECT_ITEM_SOURCE_3"] = "Cet objet",
	["EFFECT_ITEM_SOURCE_3_TT"] = [=[Recherche l'objet seulement dans cet objet (et dans ses éventuels sous-contenants).

|cffff9900Fonctionne seulement si ce script est dans un contexte d'objet et que cet objet est un contenant.]=],
	["EFFECT_ITEM_SOURCE_ID"] = "Vous pouvez choisir un ID d'objet que vous voulez trouver, ou laisser vide si vous voulez rechercher tous les types d'objets.",
	["EFFECT_ITEM_USE"] = "Contenant : utilisation d'objet",
	["EFFECT_ITEM_USE_PREVIEW"] = "Utilise l'objet à l'emplacement %s",
	["EFFECT_ITEM_USE_TT"] = [=[Utilise un objet dans un emplacement du contenant.

|cffff9900Fonctionne seulement si ce processus est déclenché par un contenant.]=],
	["EFFECT_ITEM_WORKFLOW"] = "Exécuter processus d'objet",
	["EFFECT_ITEM_WORKFLOW_PREVIEW_C"] = "Déclenche le processus %s dans l'objet contenu en emplacement %s.",
	["EFFECT_ITEM_WORKFLOW_PREVIEW_P"] = "Déclenche le processus %s dans le conteneur parent.",
	["EFFECT_ITEM_WORKFLOW_PREVIEW_S"] = "Déclenche le processus %s dans l'objet frère d'emplacement %s.",
	["EFFECT_ITEM_WORKFLOW_TT"] = "Exécute un processus dans le conteneur parent ou sur un objet contenu (si l'objet courant est un conteneur).",
	["EFFECT_MISSING"] = "Cet effet (%s) est inconnu et vous devriez le supprimer.",
	["EFFECT_OPERATION"] = "Opération",
	["EFFECT_OPERATION_TYPE"] = "Type d'opération",
	["EFFECT_OPERATION_TYPE_ADD"] = "Addition",
	["EFFECT_OPERATION_TYPE_DIV"] = "Division",
	["EFFECT_OPERATION_TYPE_INIT"] = "Initialisation",
	["EFFECT_OPERATION_TYPE_INIT_TT"] = "Initialise la variable à la valeur choisie, mais seulement si la variable n'existe pas encore.",
	["EFFECT_OPERATION_TYPE_MULTIPLY"] = "Multiplication",
	["EFFECT_OPERATION_TYPE_SET"] = "Établir",
	["EFFECT_OPERATION_TYPE_SET_TT"] = "Place la variable à la valeur choisie, même si la variable a déjà été définie auparavant.",
	["EFFECT_OPERATION_TYPE_SUB"] = "Soustraction",
	["EFFECT_OPERATION_VALUE"] = "Valeur d'opération",
	["EFFECT_PROMPT"] = "Demande de saisie",
	["EFFECT_PROMPT_CALLBACK"] = "Processus à appeler (optionnel)",
	["EFFECT_PROMPT_CALLBACK_TT"] = [=[Le nom du processus à appeler après la saisie de l'utilisateur.

Ceci est optionnel. Laissez vide pour ne pas appeler de processus.

Si donné, le processus sera appelé avec la saisie comme variable de processus avec le nom associé.

|cffffff00Attention: le processus est appelé même si le joueur clique "Annuler" dans le popup de saisie. Dans ce cas, la variable ne sera pas modifiée si elle existe.]=],
	["EFFECT_PROMPT_DEFAULT"] = "Valeur par défaut",
	["EFFECT_PROMPT_DEFAULT_TT"] = "La valeur par défaut pour la saisie.",
	["EFFECT_PROMPT_PREVIEW"] = "Demande à l'utilisateur de saisir la valeur de la variable |cff00ff00%s|r.",
	["EFFECT_PROMPT_TEXT"] = "Texte du popup",
	["EFFECT_PROMPT_TEXT_TT"] = "Le texte qui sera présenté à l'utilisateur dans la fenêtre de saisie.",
	["EFFECT_PROMPT_TT"] = [=[Demande à l'utilisateur de saisir une valeur qui sera stockée dans une variable. Optionnellement, appelle un processus après saisie.

|cffff0000ATTENTION, l'exécution de cet effet est asynchrone.]=],
	["EFFECT_PROMPT_VAR"] = "Nom de la variable",
	["EFFECT_PROMPT_VAR_TT"] = "Le nom de la variable qui stockera la valeur saisie.",
	["EFFECT_QUEST_GOTOSTEP"] = "Changer d'étape de quête",
	["EFFECT_QUEST_GOTOSTEP_ID"] = "ID d'étape de quête",
	["EFFECT_QUEST_GOTOSTEP_ID_TT"] = [=[Utilisez le navigateur pour sélectionner votre étape de quête (la quête comme l'étape de quête doivent exister avant de les lier par cet effet).

Si votre étape de quête n'apparaît pas dans le navigateur, sauvegardez votre campagne et réessayez.]=],
	["EFFECT_QUEST_GOTOSTEP_PREVIEW"] = "Va à l'étape %s.",
	["EFFECT_QUEST_GOTOSTEP_TT"] = [=[Change une étape de quête.

|cffff9900Fonctionne seulement si la quête fait partie de la campagne actuellement active et que la quête a déjà été révélée dans le journal de quête.]=],
	["EFFECT_QUEST_OBJ_ID"] = "ID d'objectif",
	["EFFECT_QUEST_OBJ_ID_TT"] = "Entrez l'ID d'objectif. Veuillez entrer uniquement l'ID de l'objectif sans le préfixer par l'identifiant de la campagne-quête.",
	["EFFECT_QUEST_REVEAL_OBJ"] = "Révéler objectif de quête",
	["EFFECT_QUEST_REVEAL_OBJ_DONE"] = "Compléter l'objectif",
	["EFFECT_QUEST_REVEAL_OBJ_DONE_PREVIEW"] = "Compléter l'objectif: %s de %s",
	["EFFECT_QUEST_REVEAL_OBJ_DONE_TT"] = [=[Marque un objectif comme complété.

|cffff9900Fonctionne seulement si la quête fait partie de la campagne active, si la quête est déjà révélée dans le journal de quêtes et si l'objectif a déjà été révélé.]=],
	["EFFECT_QUEST_REVEAL_OBJ_PREVIEW"] = "Révéler l'objectif: %s de %s",
	["EFFECT_QUEST_REVEAL_OBJ_TT"] = [=[Révèle un objectif de quête.

|cffff9900Fonctionne seulement si la quête fait partie de la campagne active et si la quête a déjà été révélée dans le journal de quêtes.]=],
	["EFFECT_QUEST_START"] = "Révéler quête",
	["EFFECT_QUEST_START_ID"] = "ID de quête",
	["EFFECT_QUEST_START_ID_TT"] = [=[Utilisez le navigateur pour sélectionner votre quête (la quête doit déjà exister avant que vous puissiez la lier à cet effet).

Si la quête n’apparaît pas dans le navigateur, essayer d'abord de sauvegarder votre campagne.]=],
	["EFFECT_QUEST_START_PREVIEW"] = "Révèle la quête %s.",
	["EFFECT_QUEST_START_TT"] = [=[Révèle la quête dans le journal de quêtes.

|cffff9900Fonctionne seulement si la quête fait partie de la campagne active.]=],
	["EFFECT_RANDSUM"] = "Invoquer une mascotte aléatoire",
	["EFFECT_RANDSUM_TT"] = "Invoque une mascotte aléatoire, choisie parmi vos mascotte favorites.",
	["EFFECT_RUN_WORKFLOW"] = "Exécuter processus",
	["EFFECT_RUN_WORKFLOW_ID"] = "ID de processus",
	["EFFECT_RUN_WORKFLOW_ID_TT"] = "L'identifiant du processus que vous souhaitez exécuter.",
	["EFFECT_RUN_WORKFLOW_PREVIEW"] = "Exécuter le processus %s situé dans %s.",
	["EFFECT_RUN_WORKFLOW_SLOT"] = "ID d'emplacement",
	["EFFECT_RUN_WORKFLOW_SLOT_TT"] = "L'indexe de l'emplacement du conteneur où trouver l'objet à déclencher. Les emplacements sont numéroté de gauche à droite et de haut en bas, en commençant par 1.",
	["EFFECT_RUN_WORKFLOW_TT"] = "Exécuter un autre processus. Toutes les variables seront passées de l'exécution actuelle du processus vers le nouveau processus appelé.",
	["EFFECT_SCRIPT"] = "Exécuter un script lua restreint",
	["EFFECT_SCRIPT_I_EFFECT"] = "Insérer un effet",
	["EFFECT_SCRIPT_I_EFFECT_TT"] = [=[Insère une fonction d'effet à l'endroit où se situe le curseur dans le code.

La fonction est de la forme : |cff00ffffeffect( effectID, args, arg1, arg2, ...);|r 
- |cff00ffffEffect ID|r: l'ID de l'effet, vous pouvez le trouver en regardant dans le code source de l'addon.
- |cff00ffffargs|r: Les arguments d'exécution: doit toujours être la variable args. 
- |cff00ffffArguments d'effet argX|r: Tous les arguments des effets peuvent être trouvés dans le code source de l'addon.

|cffffff00Gardez toujours 'args' comme second paramètre, |ril est requis pour la fonction d'effet et contient tous les arguments des processus. 

|cff00ff00Les ID et arguments d'effets ne seront pas documentés pour le moments, cet effet étant considéré restreint aux utilisateurs capables de comprendre le code source de l'addon. ;)]=],
	["EFFECT_SCRIPT_SCRIPT"] = "Code lua",
	["EFFECT_SCRIPT_SCRIPT_TT"] = [=[Ce script sera exécuté dans un environnement sécurisé dans lequel vous avez accès à toute la syntaxe et les API lua (table, string, math...) ainsi qu'à la fonction |cff00ff00effect|r d'Extended.

|cffff0000Vous n'avez pas accès à l'API du jeu ici !|r 

Un script lua personnalisé sera toujours moins efficace qu'un effet de processus, car il est compilé à chaque exécution, à l'opposé d'un effet de processus qui n'est compilé qu'une seule fois.

 |cffff9900Restreignez votre script à un minimum et n'utilisez cet effet de script que si nécessaire.]=],
	["EFFECT_SCRIPT_TT"] = "Exécute un script lua dans un environnement restreint sécurisé.",
	["EFFECT_SHEATH"] = "Dégainer/rengainer armes",
	["EFFECT_SHEATH_TT"] = "Dégaine ou rengaine les armes du personnage.",
	["EFFECT_SIGNAL"] = "Envoyer signal",
	["EFFECT_SIGNAL_ID"] = "ID du signal",
	["EFFECT_SIGNAL_ID_TT"] = "C'est l'identifiant de votre signal. Il pourra être testé dans les conditions et processus déclenchés par l’événement de jeu |cff00ff00TRP3_SIGNAL|r.",
	["EFFECT_SIGNAL_PREVIEW"] = "|cffffff00Envoyer le signal:|r %s|cffffff00 avec la valeur:|r %s",
	["EFFECT_SIGNAL_TT"] = [=[Envoi un signal avec un identifiant et une valeur au personnage sélectionné par le joueur.

Ce signal peut être écouté par les campagnes, quêtes et étapes via les événements de jeu en écoutant l’événement |cff00ff00TRP3_SIGNAL|r.]=],
	["EFFECT_SIGNAL_VALUE"] = "Valeur du signal",
	["EFFECT_SIGNAL_VALUE_TT"] = "C'est la valeur de votre signal. Il pourra être testé dans les conditions et processus déclenchés par l’événement de jeu |cff00ff00TRP3_SIGNAL|r. Il peut aussi être inséré comme balise de texte |cff00ff00${event.2}|r.",
	["EFFECT_SOUND_ID_LOCAL"] = "Jouer son local",
	["EFFECT_SOUND_ID_LOCAL_PREVIEW"] = "Jouer le son d'ID %s dans le channel %s dans un rayon de %s yards.",
	["EFFECT_SOUND_ID_LOCAL_STOP"] = "Arrêter son local",
	["EFFECT_SOUND_ID_LOCAL_STOP_TT"] = "Arrête un ou tous les sons sur un canal spécifique pour tous les joueurs autour de vous.",
	["EFFECT_SOUND_ID_LOCAL_TT"] = "Joue un son qui sera entendu par les joueurs aux alentours.",
	["EFFECT_SOUND_ID_SELF"] = "Jouer un son",
	["EFFECT_SOUND_ID_SELF_CHANNEL"] = "Channel",
	["EFFECT_SOUND_ID_SELF_CHANNEL_AMBIANCE"] = "Ambiance",
	["EFFECT_SOUND_ID_SELF_CHANNEL_AMBIANCE_TT"] = [=[Ambiance correspond aux sons ambiants. Les paramètres de volume des sons d'ambiance seront utilisés.

Plusieurs sons d'ambience peuvent être joués simultanément.

|cffff9900Veillez à ne pas utiliser cet effet pour jouer de la musique car la musique déjà jouée par la jeu ne sera pas coupée. Pour jouer une musique vous devez utiliser l'effet Jouer musique.]=],
	["EFFECT_SOUND_ID_SELF_CHANNEL_SFX"] = "SFX",
	["EFFECT_SOUND_ID_SELF_CHANNEL_SFX_TT"] = [=[SFX est à utiliser pour les effets sonores. Il utilise le volume du jeu.

Différents sons SFX peuvent être joués simultanément.]=],
	["EFFECT_SOUND_ID_SELF_ID"] = "ID de son",
	["EFFECT_SOUND_ID_SELF_ID_TT"] = [=[L'ID correspond à un identifiant interne au jeu pour chaque son.

|cff00ff00Vous pouvez trouver les ID des sons du jeu sur des sites comme WoWHead.

|cffff9900À noter que si l'ID correspond à une liste de plusieurs sons, un des sons sera choisi aléatoirement.]=],
	["EFFECT_SOUND_ID_SELF_PREVIEW"] = "Joue le son d'ID %s dans le channel %s.",
	["EFFECT_SOUND_ID_SELF_TT"] = "Joue un son dans un channel particulier. Seul le joueur l'entendra.",
	["EFFECT_SOUND_ID_STOP"] = "Arrêter un son",
	["EFFECT_SOUND_ID_STOP_ALL_PREVIEW"] = "Arrête |cff00ff00tous|cffffff00 les sons dans le canal %s.",
	["EFFECT_SOUND_ID_STOP_PREVIEW"] = "Arrête le son d'ID %s dans le channel %s.",
	["EFFECT_SOUND_ID_STOP_TT"] = "Arrête un ou tous les sons dans un canal spécifique.",
	["EFFECT_SOUND_LOCAL_DISTANCE"] = "Distance de jeu",
	["EFFECT_SOUND_LOCAL_DISTANCE_TT"] = "Détermine la distance jusqu'à laquelle les joueurs aux alentours entendront l'effet sonore.",
	["EFFECT_SOUND_MUSIC_LOCAL"] = "Jouer musique locale",
	["EFFECT_SOUND_MUSIC_LOCAL_PREVIEW"] = "Joue la musique \"%s\" dans un rayon de %s mètres.",
	["EFFECT_SOUND_MUSIC_LOCAL_STOP"] = "Arrêter musique locale",
	["EFFECT_SOUND_MUSIC_LOCAL_STOP_TT"] = [=[Si vous utilisez l'effet "Jouer musique locale", la musique se jouera en boucle pour tous les joueurs autour de vous jusqu'à ce que le jeu déclenche une autre musique (suite à un changement de zone par exemple) ou si chaque joueur arrête manuellement le son depuis l'interface d'historique sonore ou jusqu'à ce que vous utilisiez cet effet.

|cffff9900À noter que cet effet n'arrêtera que la musique jouée par l'add-on, pas celle du jeu.]=],
	["EFFECT_SOUND_MUSIC_LOCAL_TT"] = "Joue une musique pour les joueurs aux alentours.",
	["EFFECT_SOUND_MUSIC_SELF"] = "Jouer musique",
	["EFFECT_SOUND_MUSIC_SELF_PATH"] = "Chemin de la musique",
	["EFFECT_SOUND_MUSIC_SELF_PATH_TT"] = [=[Le chemin de fichier vers une musique du jeu.

|cffff9900Ne doit PAS contenir la partie Sounds\Music\ du chemin ou l'extension .mp3.]=],
	["EFFECT_SOUND_MUSIC_SELF_PREVIEW"] = "Joue la musique: %s",
	["EFFECT_SOUND_MUSIC_SELF_TT"] = [=[Joue une musique. Seul le joueur l'entendra.

À noter que la musique se jouera en boucle jusqu'à ce qu'un évènement déclenche une autre musique (suite à un changement de zone par exemple), ou qu'un effet "Arrêter la musique" est déclenché. Le joueur peut également arrêter la musique manuellement via l'interface d'historique sonore.]=],
	["EFFECT_SOUND_MUSIC_STOP"] = "Arrêter la musique",
	["EFFECT_SOUND_MUSIC_STOP_TT"] = [=[Si vous utilisez l'effet "Jouer musique", la musique se jouera en boucle jusqu'à ce que le jeu déclenche une autre musique (suite à un changement de zone par exemple) ou si le joueur arrête manuellement le son depuis l'interface d'historique sonore ou jusqu'à ce que vous utilisiez cet effet.

|cffff9900À noter que cet effet n'arrêtera que la musique jouée par l'add-on, pas celle du jeu.]=],
	["EFFECT_SOUND_PLAY"] = "Jouer",
	["EFFECT_SOURCE"] = "Source",
	["EFFECT_SOURCE_CAMPAIGN"] = "Campagne active",
	["EFFECT_SOURCE_CAMPAIGN_TT"] = "Recherche la variable dans la campagne active, si il existe une campagne active.",
	["EFFECT_SOURCE_OBJECT"] = "Création",
	["EFFECT_SOURCE_OBJECT_TT"] = [=[Recherche la variable dans le processus de l'objet source.

Ne fonctionne que si l'objet source est un objet, une campagne, une quête ou une étape de quête.

Dans le cas d'une campagne, quête ou étape de quête, la recherche se fera au niveau de la campagne (en entière).]=],
	["EFFECT_SOURCE_PARENT"] = "Conteneur parent",
	["EFFECT_SOURCE_PARENT_TT"] = "Chercher le processus dans l'objet conteneur parent.",
	["EFFECT_SOURCE_SLOT"] = "Objet dans l'emplacement (enfant)",
	["EFFECT_SOURCE_SLOT_B"] = "Objet dans l'emplacement (frère)",
	["EFFECT_SOURCE_SLOT_B_TT"] = "Cherche le processus dans l'objet situé à un certain emplacement dans le même conteneur parent.",
	["EFFECT_SOURCE_SLOT_TT"] = [=[Cherche le processus dans un emplacement spécifique à l'intérieur de cet objet.
Fonctionne uniquement si l'objet courant est un conteneur !]=],
	["EFFECT_SOURCE_V"] = "Source de la variable",
	["EFFECT_SOURCE_W"] = "Source du processus",
	["EFFECT_SOURCE_WORKFLOW"] = "Processus",
	["EFFECT_SOURCE_WORKFLOW_TT"] = "Recherche la variable dans l'exécution du processus. La portée de la variable est limitée à l'exécution de ce processus et sera détruite par après.",
	["EFFECT_SPEECH_NAR"] = "Discours: Narration",
	["EFFECT_SPEECH_NAR_DEFAULT"] = "L'hivers s'installe doucement dans la nuit ...",
	["EFFECT_SPEECH_NAR_TEXT_TT"] = "Veuillez ne pas inclure le préfixe ||.",
	["EFFECT_SPEECH_NAR_TT"] = [=[Joue un effet de narration sous la forme d'une émote.

|cff00ff00Même principe que d'écrire une émote en commençant par le caractère || (pipe). Le message sera formaté dans la fenêtre de discussions pour les autres utilisateurs de Total RP.]=],
	["EFFECT_SPEECH_NPC"] = "Discours: PNJ",
	["EFFECT_SPEECH_NPC_DEFAULT"] = "Je voudrais un bonhomme de neige.",
	["EFFECT_SPEECH_NPC_NAME"] = "Nom du PNJ",
	["EFFECT_SPEECH_NPC_NAME_TT"] = "Le nom du PNJ.",
	["EFFECT_SPEECH_NPC_TT"] = [=[Joue un texte de PNJ sous forme d'émote.

|cff00ff00Même principe que d'écrire une émote en commençant par le caractère || (pipe) avec un nom de PNJ et un texte. Le message sera formaté dans la fenêtre de discussions pour les autres utilisateurs de Total RP.]=],
	["EFFECT_SPEECH_PLAYER"] = "Discours: Joueur",
	["EFFECT_SPEECH_PLAYER_DEFAULT"] = "Que le dragon vous consume !",
	["EFFECT_SPEECH_PLAYER_TT"] = "Fait parler/crier le joueur, ou lui fait faire une emote /e.",
	["EFFECT_SPEECH_TYPE"] = "Type de discours",
	["EFFECT_SUMMOUNT"] = "Invoquer une monture",
	["EFFECT_SUMMOUNT_NOMOUNT"] = "Pas de monture sélectionnée.",
	["EFFECT_SUMMOUNT_TT"] = "Invoque une monture spécifique, si elle est disponible.",
	["EFFECT_TEXT"] = "Afficher du texte",
	["EFFECT_TEXT_PREVIEW"] = "Texte affiché",
	["EFFECT_TEXT_TEXT"] = "Texte",
	["EFFECT_TEXT_TEXT_DEFAULT"] = "Votre texte",
	["EFFECT_TEXT_TEXT_TT"] = "Le texte à afficher.",
	["EFFECT_TEXT_TT"] = [=[Affiche un texte.
Différents affichages sont disponibles.]=],
	["EFFECT_TEXT_TYPE"] = "Type d'affichage",
	["EFFECT_TEXT_TYPE_1"] = "Fenêtre de chat",
	["EFFECT_TEXT_TYPE_2"] = "Popup d'alerte",
	["EFFECT_TEXT_TYPE_3"] = "Texte d'alerte de raid",
	["EFFECT_TEXT_TYPE_4"] = "Message d'erreur",
	["EFFECT_USE_SLOT"] = "Index d'emplacement du contenant.",
	["EFFECT_USE_SLOT_TT"] = "Les indexes des emplacements sont assignés de gauche à droite et de haut en bas.",
	["EFFECT_VAR"] = "Nom de variable",
	["EFFECT_VAR_INDEX"] = "Index d'argument",
	["EFFECT_VAR_INDEX_TT"] = [=[L'index de l'argument.

Donc si vous souhaitez vérifier le troisième argument de l'événement, entrez 3.]=],
	["EFFECT_VAR_OBJECT_CHANGE"] = "Opération sur variable",
	["EFFECT_VAR_OBJECT_CHANGE_TT"] = [=[Exécute une opération sur une variable.

|cffff9900Pour les opérations mathématiques: Si la variable n'existe pas ou ne peut pas être interprétée comme un nombre elle sera initialisée à 0.]=],
	["EFFECT_VAR_OPERAND"] = "Evaluation de variable",
	["EFFECT_VAR_OPERAND_CONFIG"] = "Configuration de valeur",
	["EFFECT_VAR_OPERAND_CONFIG_NO"] = "Pas de configuration pour cette valeur",
	["EFFECT_VAR_OPERAND_TT"] = "Évalue à l'exécution une valeur à placer dans une variable. Toutes les valeurs testables dans les conditions sont disponibles.",
	["EFFECT_VAR_VALUE"] = "Valeur de variable",
	["EFFECT_W_CAMPAIGN_TT"] = "Chercher le processus dans la campagne courante.",
	["EFFECT_W_OBJECT_TT"] = "Chercher le processus dans la création courante.",
	["ERROR_MISSING_ARG"] = "Argument %1$s manquant en essayant d'appeler la fonction %2$s.",
	["EX_SOUND_HISTORY"] = "Historique sonore",
	["EX_SOUND_HISTORY_CLEAR"] = "Réinitialiser",
	["EX_SOUND_HISTORY_EMPTY"] = "Aucun son n'a été joué.",
	["EX_SOUND_HISTORY_LINE"] = "%s a joué le son %s dans le channel %s.",
	["EX_SOUND_HISTORY_REPLAY"] = "Rejouer",
	["EX_SOUND_HISTORY_STOP"] = "Arrêter",
	["EX_SOUND_HISTORY_STOP_ALL"] = "Arrêter tous",
	["EX_SOUND_HISTORY_TT"] = "Voyez quels effets sonores ont été joués, d'où ils proviennent et interrompez les si ils sont toujours en cours.",
	["IN_INNER"] = "Éléments internes",
	["IN_INNER_ADD"] = "Créer un élément interne",
	["IN_INNER_ADD_COPY"] = "Copie d'une création existante",
	["IN_INNER_ADD_NEW"] = "Nouvelle création",
	["IN_INNER_COPY_ACTION"] = "Copier le contenu de l'élément",
	["IN_INNER_DELETE_CONFIRM"] = [=[Supprimer l'élément interne |cff00ffff"%s"|r |cff00ff00[%s]|r de l'élément-mère |cff00ff00[%s]|r ?

|cffff9900Cet élément interne sera perdu.]=],
	["IN_INNER_DELETE_TT"] = "Supprime cet élément interne de l'élément-mère.",
	["IN_INNER_EMPTY"] = [=[Pas d'élément interne.

Vous pouvez en ajouter un en utilisant le bouton Ajouter ci-dessous.]=],
	["IN_INNER_ENTER_ID"] = "Entrer un nouvel ID d'élément interne",
	["IN_INNER_ENTER_ID_NO_SPACE"] = "L'ID d'un objet ne peut pas contenir d'espace. Rappelez-vous que ceci n'est pas le nom de l'objet !",
	["IN_INNER_ENTER_ID_TT"] = [=[L'ID de l'élément interne doit être unique au sein de l'élément-parent.

|cffff9900Veuillez n'utiliser que les minuscules et le tiret-bas (_). Tous les autres caractères seront automatiquement convertis en _.]=],
	["IN_INNER_HELP"] = [=[Les éléments internes sont des éléments hébergés dans un élément-mère.

Prenons quelques exemples :
|cffff9900
- Vous voulez créer un fusil avec des objets "balles" pour le recharger. Typiquement, le fusil serait l'objet principal, donc l'élément-mère, dans lequel la balle serait l'élément interne.

- Un objet de courrier ouvrant un document. Le document (une lettre, par exemple) serait l'élément interne, conçu pour l'objet de courrier (une enveloppe, par ex.).

- Création de quêtes : tous les objets/documents/cinématiques que vous employez dans une quête peuvent être de tels "élément interne", s'ils sont justement conçus pour cette quête.

|rLes avantages à employer des éléments internes sont multiples :
|cff00ff00
- Les données des éléments internes sont vraiment hébergées à l'intérieur des données de l'élément-mère. Ce qui signifie qu'ils partagent le même numéro de version, et que leurs données sont échangées en même temps que celles de leur élément-mère.

- Employer des éléments internes apporte plus de performances.

- Il est plus simple de gérer vos éléments et d'y naviguer s'ils sont hébergés dans des éléments-mères. Vous pouvez vraiment voir un élément-mère comme un dossier dans lequel vous insérez des fiches.

|rDonc c'est simple : chaque fois que vous voulez créer un élément, demandez-vous si ça ne serait pas plus efficace d'en faire un élément interne, attribué à un autre objet ou à une quête qui lui est lié(e).

|cff00ff00NB : Les documents et les cinématiques ne peuvent être QUE des éléments internes !]=],
	["IN_INNER_HELP_TITLE"] = "Qu'est-ce que les éléments internes ?",
	["IN_INNER_ID"] = [=[Veuillez entrer un nouvel ID pour cet élément interne |cff00ff00[%s]|r.

Ancien ID: |cff00ffff"%s"|r]=],
	["IN_INNER_ID_ACTION"] = "Changer l'identifiant",
	["IN_INNER_ID_COPY"] = "Copier",
	["IN_INNER_ID_COPY_TT"] = "Vous pouvez copier votre élément interne pour le coller dans un autre élément-mère.",
	["IN_INNER_LIST"] = "Liste des éléments internes",
	["IN_INNER_NO_AVAILABLE"] = "Cet identifiant inclus n'est pas disponible !",
	["IN_INNER_PASTE_ACTION"] = "Coller le contenu d'élément",
	["IN_INNER_PASTE_CONFIRM"] = "Remplacer le contenu de cet élément interne par celui que vous venez de copier ?",
	["IN_INNER_S"] = "Élément interne",
	["INV_PAGE_CAMERA_CONFIG"] = [=[Paramètres de caméra :
   Rotation: %.2f]=],
	["INV_PAGE_CHARACTER_INSPECTION"] = "Inspection de personnage",
	["INV_PAGE_CHARACTER_INSPECTION_TT"] = "Inspecte l'inventaire de ce personnage.",
	["INV_PAGE_CHARACTER_INV"] = "Inventaire",
	["INV_PAGE_EDIT_ERROR1"] = "Vous devez être l'auteur de cet objet pour l'éditer.",
	["INV_PAGE_EDIT_ERROR2"] = "Cet objet n'est pas en Mode rapide.",
	["INV_PAGE_INV_OPEN"] = "Ouvrir l'inventaire",
	["INV_PAGE_ITEM_LOCATION"] = "Emplacement d'objet sur le personnage",
	["INV_PAGE_LOOT_ALL"] = "Tout ramasser",
	["INV_PAGE_MARKER"] = [=[Position des marqueurs :
   x: %.2f
   y: %.2f]=],
	["INV_PAGE_PLAYER_INV"] = "Inventaire de %s",
	["INV_PAGE_QUICK_SLOT"] = "Emplacement rapide",
	["INV_PAGE_QUICK_SLOT_TT"] = "Cet emplacement sera utilisé comme contenant principal.",
	["INV_PAGE_SEQUENCE"] = "ID de séquence",
	["INV_PAGE_SEQUENCE_PRESET"] = "Vous pouvez sélectionner une ID de séquence correspondant à une émote.",
	["INV_PAGE_SEQUENCE_TT"] = [=[Vous pouvez changer la posture de votre personnage en entrant un ID d'animation ici et en sélectionnant la séquence d'animation avec le curseur ci-dessous.

Attention: Si l'animation tremble, c'est qu'il y a un problème avec l'animation en question pour le modèle de votre race. Si cela arrive, veuillez choisir une autre animation.]=],
	["INV_PAGE_TOTAL_VALUE"] = "Valeur totale des objets",
	["INV_PAGE_TOTAL_VALUE_TT"] = [=[C'est la valeur de votre inventaire.

Ce n'est pas la somme des "pièces", mais la valeur totale estimée de tous les objets dans l'inventaire.]=],
	["INV_PAGE_WAIT"] = "En attente d'une réponse",
	["INV_PAGE_WEAR_ACTION"] = "Configurer l'emplacement d'objet",
	["INV_PAGE_WEAR_ACTION_RESET"] = "Réinitialiser la configuration",
	["INV_PAGE_WEAR_TT"] = [=[Cet objet est équipable.
La zone verte indique l'emplacement d'objet sur le personnage.]=],
	["INV_TU_1"] = [=[Vous pouvez placer un objet (ou une pile d'objets) dans chaque emplacement d'inventaire.

|cff00ff00Vous n'êtes pas limité en place puisque vous pouvez avoir un nombre illimité de sacs et contenants. Vous pouvez aussi avoir des contenants dans des contenants.

|cffff9900La seule chose dont vous devez vous préoccuper est le poids du chargement de chaque contenant.|r

Si un contenant a une capacité maximum en poids et que vous le dépassez, il s'endommagera peu à peu et pourra, aléatoirement, semer des objet au sol !]=],
	["INV_TU_2"] = [=[Tout sac placé ici se comportera comme le contenant principal.

|cffff9900Il est très important d'avoir toujours un contenant principal avec de l'espace libre car c'est le contenant qui sera utilisé lors des échanges avec d'autres joueurs.

|cffff9900De plus, le contenant principal peut facilement être ouvert avec le bouton d'inventaire sur la barre d'outils TRP.]=],
	["INV_TU_3"] = [=[Pour les objets qui sont affichés directement sur le personnage (pas dans un sac), s'ils sont équipables (ce qui est un choix de l'auteur), |cffff9900vous pouvez indiquer où ils se trouvent sur votre personnage.

|cffff9900Pour cela, cliquez sur le point à côté de l'objet et placez le marqueur sur votre personnage. Vous pouvez aussi tourner votre personnage et choisir sa posture.

|cffff9900Quand quelqu'un utilise l'outil d'inspection sur vous, il ou elle verra le marqueur avec la posture adéquate !

|rVous pouvez inspecter l'inventaire de quelqu'un en ciblant le personnage et en cliquant sur le bouton de la barre de cible TRP |cff00ff00"Inspection du personnage"|r.

|cff00ff00Notez que les deux joueurs doivent utiliser TRP3: Extended pour pouvoir s'inspecter l'un l'autre.
]=],
	["INV_TU_4"] = [=[Quand vous glissez un objet en-dehors de l'inventaire, |cffff9900il vous sera demandé si vous choisissez de le détruire ou de le déposer au sol.|r

Vous pouvez déposer des objets (presque) partout dans le monde. |cffff9900Vous pouvez ensuite revenir les ramasser plus tard en utilisant le bouton "Rechercher des objets" dans la barre d'outils de Total RP 3.

|cffff9900NB : Parfois des objets peuvent être déposés automatiquement : si vous récupérez des objets mais que votre inventaire est plein, ou si un de vos sacs est endommagé.]=],
	["INV_TU_5"] = [=[Vous pouvez échanger un objet (ou une pile d'objets) avec un autre joueur, en glissant la pile sur ce joueur (de la même manière que dans le jeu).

|cffff9900Quand quelqu'un vous donne un objet, la fenêtre d'échange vous informera si cet objet pourrait avoir des effets gênants (personne n'aime que son personnage crie des choses horribles).

|rQuand c'est le cas, TRP convertira ces effets en une forme moins dangereuse (par exemple, le fait de crier sera converti en texte personnel) jusqu'à ce que vous décidiez de les débloquer.

|cff00ff00Vous pouvez bloquer/débloquer ces effets, et valider des effets ou joueurs de confiance, avec Alt + Clic droit sur un objet de votre inventaire.]=],
	["INV_TU_5_V2"] = [=[Vous pouvez échanger un objet (ou une pile d'objets) avec un autre joueur, en glissant la pile sur ce joueur (de la même manière que dans le jeu) ou en utilisant le bouton dédié sur le cadre de la cible.

|cffff9900Quand quelqu'un vous donne un objet, la fenêtre d'échange vous informera si cet objet pourrait avoir des effets gênants (personne n'aime que son personnage crie des choses horribles).

|rQuand c'est le cas, TRP convertira ces effets en une forme moins dangereuse (par exemple, le fait de crier sera converti en texte personnel) jusqu'à ce que vous décidiez de les débloquer.

|cff00ff00Vous pouvez bloquer/débloquer ces effets, et valider des effets ou joueurs de confiance, avec Alt + Clic droit sur un objet de votre inventaire.]=],
	["IT_CAST"] = "Incantation",
	["IT_CO_DURABILITY"] = "Durabilité",
	["IT_CO_DURABILITY_TT"] = [=[Détermine le meilleur état possible de votre contenant. Un contenant peut voir son état se dégrader dans le temps, ou peut être endommagé. Mais il peut aussi être réparé avec les objets adéquats.

|cff00ff00Zéro signifie : invulnérable.]=],
	["IT_CO_MAX"] = "Poids max (en grammes)",
	["IT_CO_MAX_TT"] = [=[Ceci définit la limite de poids à partir de laquelle votre contenant commencera à voir son état se dégrader dans le temps à cause d'une surcharge.

|cff00ff00Zéro signifie : pas de limite.

|cff00ff00Veuillez entrer le poids maximal en GRAMMES. (1 kg = 1000 grammes)]=],
	["IT_CO_ONLY_INNER"] = "Ne peut contenir que ses objets inclus",
	["IT_CO_ONLY_INNER_TT"] = [=[Marque ce contenant pour ne pouvoir contenir que les objets liés au même objet-mère de base.

Pour l'instant, seuls les contenants avec cette option activée peuvent être troqués alors qu'ils contiennent d'autres objets.]=],
	["IT_CO_SIZE"] = "Taille du contenant",
	["IT_CO_SIZE_COLROW"] = "%s lignes par %s colonnes",
	["IT_CON"] = "Contenant",
	["IT_CON_CAN_INNER"] = "Impossible de placer un contenant dans lui-même !",
	["IT_CON_ERROR_TRADE"] = "Vous ne pouvez pas déposer ce contenant s'il n'est pas vide.",
	["IT_CON_ERROR_TYPE"] = "Ce contenant ne peut contenir ce type d'objet.",
	["IT_CON_OPEN"] = "Ouvrir/Fermer le contenant",
	["IT_CON_TT"] = "Contenant (%d/%d emplacements utilisés)",
	["IT_CON_TT_MISSING_CLASS"] = "ID de classe d'objet manquante",
	["IT_CONTAINER_TT"] = [=[Définit cet objet pour être un contenant. Les contenants peuvent rassembler d'autres objets.

|cff00ff00Le contenant peut être configuré dans la table "Contenant" de cet éditeur.]=],
	["IT_CONVERT_TO_NORMAL"] = "Basculer en mode normal",
	["IT_CONVERT_TO_NORMAL_TT"] = [=[Vous êtes en mode rapide, une première approche facile pour créer un objet simple.

Vous pouvez aller plus loin et éditer cet objet en mode normal. Ceci vous apportera davantage de possibilités mais c'est aussi plus complexe à apprendre et à utiliser.

|cffff9900Attention : Si vous basculez cet objet en mode normal, vous ne pourrez pas le ramener au mode rapide.]=],
	["IT_CRAFTED"] = "Artisanat",
	["IT_CRAFTED_TT"] = "Quand une unité de cet objet sera ajoutée à votre sac ou créée par un autre objet, vous serez mentionné comme son créateur dans son infobulle.",
	["IT_DISPLAY_ATT"] = "Afficher les attributs",
	["IT_DOC_ACTION"] = "Lire le document",
	["IT_DR_SOUND"] = "Son de dépôt",
	["IT_EX_DOWNLOAD"] = "Télécharger",
	["IT_EX_DOWNLOAD_TT"] = [=[|cffff9900Cet objet est long de %s messages et prendra au moins %.1f seconds à être téléchargé (dans les meilleures conditions).

|cff00ff00Cliquez pour demander à %s de vous envoyer toutes les données sur cet objet.

|cffff9900Vous ne pouvez pas finir un troc tant que vous n'avez pas toute l'information à jour sur les objets que vous devriez recevoir.]=],
	["IT_EX_DOWNLOADING"] = "Téléchargement : %0.1f %%",
	["IT_EX_EMPTY"] = "Rien à troquer",
	["IT_EX_EMPTY_DRAG"] = "Vous pouvez glisser et déposer des objets ici.",
	["IT_EX_SLOT_DOWNLOAD"] = [=[|rVous n'avez pas l'information de cet objet.

|cff00ff00Si l'objet n'est pas trop lourd, TRP3 le téléchargera automatiquement de %s.

|cff00ff00Si l'objet est trop lourd, vous pouvez demander manuellement ses informations avec le bouton télécharger, mais gardez à l'esprit que ce téléchargement pourrait prendre quelque temps.]=],
	["IT_EX_TRADE_BUTTON"] = "Ouvrir l'échange",
	["IT_EX_TRADE_BUTTON_TT"] = "Ouvre la fenêtre d'échanges pour échanger des objets avec ce joueur.",
	["IT_FIELD_NAME"] = "Nom d'objet",
	["IT_FIELD_NAME_TT"] = "C'est le nom de votre objet, tel qu'il apparaîtra sur l'infobulle ou dans un lien d'objet dans la fenêtre de discussion.",
	["IT_FIELD_QUALITY"] = "Qualité de l'objet",
	["IT_GAMEPLAY_ATT"] = "Attributs de gameplay",
	["IT_INV_ERROR_CANT_DESTROY_LOOT"] = "Vous ne pouvez pas détruire des objets de butin.",
	["IT_INV_ERROR_CANT_HERE"] = "Vous ne pouvez pas placer d'objets ici.",
	["IT_INV_ERROR_FULL"] = "%s est plein.",
	["IT_INV_ERROR_MAX"] = "Vous ne pouvez pas porter davantage de %s.",
	["IT_INV_GOT"] = "Reçu : %s x%d",
	["IT_INV_SCAN_MY_ITEMS"] = "Afficher mes objets",
	["IT_INV_SHOW_ALL"] = "Montrer tout l'inventaire",
	["IT_INV_SHOW_CONTENT"] = [=[|cffffff00Clic :|r Ouvre le contenant principal (s'il existe)
|cffffff00Clic droit :|r Ouvre l'inventaire]=],
	["IT_LOOT_ERROR"] = "Impossible d'afficher le butin maintenant, un autre butin est déjà montré.",
	["IT_NEW_NAME"] = "Nouvel objet",
	["IT_NEW_NAME_CO"] = "Nouveau contenant",
	["IT_NO_ADD"] = "Empêcher l'ajout manuel",
	["IT_NO_ADD_TT"] = "Empêche le joueur d'ajouter manuellement l'objet à son inventaire. Ils ne peuvent donc être ajoutés ou ramassés que via certaines actions.",
	["IT_ON_USE"] = "À l'utilisation",
	["IT_ON_USE_TT"] = [=[Ce processus sera déclenché quand le joueur utilise cet objet.

|cffff9900NB :|r Si vous voulez avoir plus de processus pour cet objet, vous pouvez le basculer en Mode expert, via la vue des Bases de données (en cliquant-droit dessus et en sélectionnant |cff00ff00Basculer en Mode expert|r).]=],
	["IT_PU_SOUND"] = "Son de ramassage",
	["IT_PU_SOUND_1183"] = "Sac",
	["IT_PU_SOUND_1184"] = "Livre",
	["IT_PU_SOUND_1185"] = "Tissu",
	["IT_PU_SOUND_1186"] = "Nourriture",
	["IT_PU_SOUND_1187"] = "Plante",
	["IT_PU_SOUND_1188"] = "Chaîne",
	["IT_PU_SOUND_1189"] = "Viande",
	["IT_PU_SOUND_1190"] = "Métal (grand)",
	["IT_PU_SOUND_1191"] = "Métal (petit)",
	["IT_PU_SOUND_1192"] = "Papier",
	["IT_PU_SOUND_1193"] = "Bague",
	["IT_PU_SOUND_1194"] = "Rocher",
	["IT_PU_SOUND_1195"] = "Chaînette",
	["IT_PU_SOUND_1196"] = "Baguette",
	["IT_PU_SOUND_1197"] = "Liquide",
	["IT_PU_SOUND_1198"] = "Bois (petit)",
	["IT_PU_SOUND_1199"] = "Bois (grand)",
	["IT_PU_SOUND_1221"] = "Gemmes",
	["IT_QUEST"] = "Symbole de quête",
	["IT_QUEST_TT"] = [=[Ajoute un marqueur à l'icône d'objet pour indiquer qu'utiliser cet objet devrait démarrer une quête.

|cffff7700Comme d'autres attributs d'affichage il s'agit juste d'un symbole, qui n'est pas nécessaire à votre objet pour effectivement démarrer la quête.]=],
	["IT_QUICK_EDITOR"] = "Création rapide d'objet",
	["IT_QUICK_EDITOR_EDIT"] = "Édition rapide d'objet",
	["IT_SOULBOUND_TT"] = "Cet objet sera lié au joueur une fois dans son inventaire, et il ne pourra plus être échangé ou posé au sol.",
	["IT_STACK"] = "Empilable",
	["IT_STACK_COUNT"] = "Maximum d'unités par pile",
	["IT_STACK_COUNT_TT"] = "Définit le maximum d'unités qui peuvent être empilées dans un même emplacement d'inventaire. Devrait être supérieur à 1.",
	["IT_STACK_TT"] = "Permet aux unités de cet objet d'être empilées dans un même emplacement d'inventaire.",
	["IT_TRIGGER_ON_DESTROY"] = "À la destruction de la pile",
	["IT_TRIGGER_ON_DESTROY_TT"] = [=[Déclenché quand le joueur détruit une pile de cet objet (en le glissant hors de son inventaire et en confirmant la destruction).|cffff9900

Le déclenchement se fait une fois par pile, et juste avant la destruction effective de la pile (donc le dénombrement des unités de cet objet dans l'inventaire, dans le processus, prendra en compte la pile).]=],
	["IT_TRIGGER_ON_USE"] = "À l'utilisation",
	["IT_TRIGGER_ON_USE_TT"] = [=[Déclenché chaque fois que le joueur utilise cet objet.

|cff00ff00N'oubliez pas de rendre votre objet utilisable dans la table principale.]=],
	["IT_TT_DESCRIPTION"] = "Description d'infobulle",
	["IT_TT_DESCRIPTION_TT"] = [=[C'est la description de votre objet.

|cff00ff00Mieux vaut éviter un mur de texte ici, essayez de rester concis.

Si votre objet est utilisable, essayez d'indiquer ici comment il devrait être utilisé.]=],
	["IT_TT_LEFT"] = "Note d'infobulle de gauche",
	["IT_TT_LEFT_TT"] = [=[C'est un texte libre qui sera placé dans l'infobulle, à gauche sous le nom d'objet.

|cff00ff00Un exemple-type d'information à placer ici est l'emplacement d'équipement (Tête, Cou, Épaule, Jambes, Main droite, Tenu(e) en main gauche, Deux mains...) ou éventuellement le type d'objet (Potion...).]=],
	["IT_TT_REAGENT"] = "Indicateur de composant",
	["IT_TT_REAGENT_TT"] = [=[Affiche la ligne "Composant d'artisanat" dans l'infobulle.

|cffff7700Comme pour les autres attributs visuels, cela n'a aucune influence sur le jeu et n'est pas requis pour que cet objet puisse être utilisé en tant que composant.]=],
	["IT_TT_RIGHT"] = "Note d'infobulle de droite",
	["IT_TT_RIGHT_TT"] = [=[C'est un texte libre qui sera placé dans l'infobulle, à droite sous le nom d'objet.

|cff00ff00Un exemple-type d'information à placer ici, en complément du texte libre de gauche, est le matériau (Tissu, Cuir, Maille, Plaque, Ornemental...).]=],
	["IT_TT_VALUE"] = "Valeur de l'objet",
	["IT_TT_VALUE_FORMAT"] = "Valeur de l'objet (en %s)",
	["IT_TT_VALUE_TT"] = [=[Cette valeur sera indiquée sur l'extension d'infobulle (maintenir Alt) ou durant les transactions.

|cffff7700Si vous pensez que cet objet est inestimable, veuillez laisser 0. Zéro ne signifie pas qu'il n'a pas de valeur, mais que cette valeur est indéfinie.]=],
	["IT_TT_WEIGHT"] = "Poids de l'objet",
	["IT_TT_WEIGHT_FORMAT"] = "Poids de l'objet (en grammes)",
	["IT_TT_WEIGHT_TT"] = [=[Le poids influence le poids total dans le contenant.

|cffff7700Veuillez entrer la valeur en GRAMMES, qui sera automatiquement convertie à l'affichage selon l'unité choisie par l'utilisateur.]=],
	["IT_UNIQUE_COUNT"] = "Unités max",
	["IT_UNIQUE_COUNT_TT"] = "Définit le nombre d'unités maximum qu'un personnage peut posséder. Devrait être supérieur à 0.",
	["IT_UNIQUE_TT"] = "Une fois actif, le nombre d'unités de l'objet pouvant être possédées par un personnage sera limité.",
	["IT_USE"] = "Utilisable",
	["IT_USE_TEXT"] = "Note d'utilisation",
	["IT_USE_TEXT_TT"] = "Ce texte, expliquant l'effet de l'utilisation de l'objet, apparaîtra dans l'infobulle.",
	["IT_USE_TT"] = [=[Permet à cet objet d'être utilisé.

|cff00ff00Vous pouvez configurer l'effet d'utilisation de l'objet dans la table "Processus" de cet éditeur]=],
	["IT_WARNING_1"] = "Un objet ne devrait pas être à la fois empilable et fabriqué. (%s)",
	["IT_WARNING_2"] = "Un objet contenant ne devrait pas être empilable. (%s)",
	["IT_WEARABLE"] = "Équipable",
	["IT_WEARABLE_TT"] = [=[Autorise cet objet pour l'outil d'inspection et vous permet de le placer précisément sur votre personnage.

|cffff9900Si ce symbole est activé, les gens pourront voir cet objet sur votre inventaire s'ils vous inspectent, même si vous ne lui attribuez pas de position sur le personnage.]=],
	["ITEM_ID"] = "Identifiant de création",
	["LOOT"] = "Butin",
	["LOOT_CONTAINER"] = "Contenant de butin",
	["LOOT_DISTANCE"] = "Vous êtes trop loin du point de ramassage.",
	["MODE_EXPERT"] = "Expert",
	["MODE_NORMAL"] = "Normal",
	["MODE_QUICK"] = "Rapide",
	["NEW_EXTENDED_VERSION"] = "|cffff9900Une nouvelle version de TRP3:Extended est disponible (%s). |cff00ff00Retrouvez-la sur Curse !",
	["NPC_EMOTES"] = "émote",
	["NPC_SAYS"] = "dit",
	["NPC_WHISPERS"] = "chuchote",
	["NPC_YELLS"] = "crie",
	["OP_ADD_TEST"] = "Ajouter test",
	["OP_AND"] = "ET",
	["OP_AND_SWITCH"] = "Basculer sur ET",
	["OP_BOOL"] = "Valeur booléenne",
	["OP_BOOL_FALSE"] = "FAUX",
	["OP_BOOL_TRUE"] = "VRAI",
	["OP_COMP_EQUALS"] = "est égal à",
	["OP_COMP_GREATER"] = "est supérieur à",
	["OP_COMP_GREATER_OR_EQUALS"] = "est supérieur ou égal à",
	["OP_COMP_LESSER"] = "est inférieur à",
	["OP_COMP_LESSER_OR_EQUALS"] = "est inférieur ou égal à",
	["OP_COMP_NEQUALS"] = "n'est pas égal à",
	["OP_COMPA_SEL"] = "Sélection de comparateur",
	["OP_CONFIGURE"] = "Configurer",
	["OP_CURRENT"] = "Valeur actuelle",
	["OP_CURRENT_TT"] = "Affiche, dans la fenêtre de discussion, l'évaluation de ce paramètre basée sur la situation actuelle.",
	["OP_DIRECT_VALUE"] = "Valeur directe",
	["OP_EVAL_VALUE"] = "Valeur évaluée",
	["OP_FAIL"] = "Message d'échec",
	["OP_FAIL_TT"] = "Ce message sera affiché si les conditions ne sont pas remplies. Laissez vide si vous ne voulez pas montrer de message.",
	["OP_FAIL_W"] = "Processus d'échec (Expert)",
	["OP_FAIL_W_TT"] = [=[Si cette condition échoue, ce processus sera exécuté. C'est une manière de faire un "sinon" dans une condition.

|cffff9900Notez que cette fonctionnalité peut être lourde en performance et devrait donc être utilisée avec parcimonie. Le processus appelé doit exister dans la même création.

|cffff0000Ne faites JAMAIS de boucle dans les processus appelés (par exemple: un processus A appelant un processus B appelant lui même à nouveau le processus A), même si vous utilisez des délais !]=],
	["OP_NUMERIC"] = "Valeur numérique",
	["OP_OP_CHAR_ACHIEVEMENT"] = "Haut-fait",
	["OP_OP_CHAR_ACHIEVEMENT_ACC"] = "Compte",
	["OP_OP_CHAR_ACHIEVEMENT_ACC_TT"] = "Vérifie si un personnage du compte a complété le haut-fait",
	["OP_OP_CHAR_ACHIEVEMENT_CHAR"] = "Personnage",
	["OP_OP_CHAR_ACHIEVEMENT_CHAR_TT"] = "Vérifie si le personnage joué a complété le haut-fait",
	["OP_OP_CHAR_ACHIEVEMENT_ID"] = "ID du haut-fait",
	["OP_OP_CHAR_ACHIEVEMENT_ID_TT"] = "L'ID numérique du haut-fait que vous voulez vérifier.",
	["OP_OP_CHAR_ACHIEVEMENT_PREVIEW"] = "%s complété par |cffff9900%s",
	["OP_OP_CHAR_ACHIEVEMENT_TT"] = "Vérifie si le compte a complété le haut-fait spécifié.",
	["OP_OP_CHAR_ACHIEVEMENT_WHO"] = "Complété par",
	["OP_OP_CHAR_CAM_DISTANCE"] = "Distance caméra",
	["OP_OP_CHAR_CAM_DISTANCE_TT"] = "Distance de la caméra par rapport au joueur. 0 si en vue à la première personne.",
	["OP_OP_CHAR_FACING"] = "Orientation du personnage",
	["OP_OP_CHAR_FACING_TT"] = [=[Détermine l'orientation du personnage (en radians, 0 = nord, cette valeur augmente dans le sens anti-horaire).

|cffff9900Indique la direction à laquelle l'avatar du joueur fait face (normalement) et dans laquelle le joueur avancera s'il commence à se déplacer, et non l'orientation de la caméra.]=],
	["OP_OP_CHAR_FALLING"] = "En chute",
	["OP_OP_CHAR_FALLING_TT"] = "Détermine si le personnage du joueur est actuellement en train de se prendre pour un écureuil volant.",
	["OP_OP_CHAR_FLYING"] = "En vol",
	["OP_OP_CHAR_FLYING_TT"] = "Vérifie si le personnage est en train de voler.",
	["OP_OP_CHAR_MINIMAP"] = "Texte de la mini-carte",
	["OP_OP_CHAR_MINIMAP_TT"] = [=[Retourne le nom de la zone tel qu'indiqué sur la mini-carte.

L'évènement du jeu "MINIMAP_ZONE_CHANGED" est déclenché quand le texte change, vous pouvez donc le tester dans une campagne ou une quête.]=],
	["OP_OP_CHAR_MOUNTED"] = "En monture",
	["OP_OP_CHAR_MOUNTED_TT"] = "Vérifie si le personnage est sur une monture.",
	["OP_OP_CHAR_RESTING"] = "En repos",
	["OP_OP_CHAR_RESTING_TT"] = "Vérifie si le personnage est en repos. Vous êtes en repos dans les tavernes ou dans des grandes villes telles que Forgefer, Orgrimmar...",
	["OP_OP_CHAR_STEALTH"] = "Personnage camouflé",
	["OP_OP_CHAR_STEALTH_TT"] = "Vérifie si le personnage est actuellement furtif.",
	["OP_OP_CHAR_SUBZONE"] = "Nom de sous-zone",
	["OP_OP_CHAR_SUBZONE_TT"] = [=[Le nom de la sous-zone où le personnage est actuellement situé.

|cffff9900Attention : Le texte est influencé par le client du jeu (VO ou VF).]=],
	["OP_OP_CHAR_SWIMMING"] = "Nage",
	["OP_OP_CHAR_SWIMMING_TT"] = "Vérifie si le personnage est en train de nager. Inclut la nage en surface.",
	["OP_OP_CHAR_ZONE"] = "Nom de zone",
	["OP_OP_CHAR_ZONE_TT"] = [=[Le nom de la zone où le personnage est actuellement situé.

|cffff9900Attention : Le texte est influencé par le client du jeu (VO ou VF).]=],
	["OP_OP_CHECK_EVENT_VAR"] = "Argument d’événement (valeur texte)",
	["OP_OP_CHECK_EVENT_VAR_N"] = "Argument d’événement (valeur numérique)",
	["OP_OP_CHECK_EVENT_VAR_N_PREVIEW"] = "%s-ième argument d'événement |cff00ff00(nombre)",
	["OP_OP_CHECK_EVENT_VAR_N_TT"] = [=[Vérifie le n-ième argument de l'événement déclenchant cette condition (si existant).

Interprété comme un numéro.

S'il n'existe pas ou ne peut pas être interprété, renvoie 0.]=],
	["OP_OP_CHECK_EVENT_VAR_PREVIEW"] = "%s-ième argument d'événement |cff00ff00(texte)",
	["OP_OP_CHECK_EVENT_VAR_TT"] = [=[Vérifie le n-ième argument de l'événement déclenchant cette condition (si existant).

Interprété comme un texte.

S'il n'existe pas ou ne peut pas être interprété, renvoie 'nil' .]=],
	["OP_OP_CHECK_VAR"] = "Valeur texte variable",
	["OP_OP_CHECK_VAR_N"] = "Valeur numérique variable",
	["OP_OP_CHECK_VAR_N_PREVIEW"] = "|cff00ffff%s: |cffff9900(n)|r %s",
	["OP_OP_CHECK_VAR_N_TT"] = [=[Renvoie la valeur d'une variable,|cff00ff00interprétée comme un nombre | r.

Si la variable n'existe pas, ne peut pas être atteinte ou ne peut pas être interprétée comme un nombre, renvoie 0.

|cffff9900Comme la valeur dépend de l'exécution, elle ne peut pas être prévisualisée.]=],
	["OP_OP_CHECK_VAR_PREVIEW"] = "|cff00ffff%s:|r %s",
	["OP_OP_CHECK_VAR_TT"] = [=[Renvoie la valeur d'une variable, |cff00ff00 interprétée comme une chaîne de caractères| r.

Si la variable n'existe pas ou ne peut pas être atteinte, renvoie la chaîne de caractères 'nil'.

|cffff9900Comme la valeur dépend de l'exécution, il ne peut pas être prévisualisé.]=],
	["OP_OP_DISTANCE_CURRENT"] = "Utiliser la position actuelle",
	["OP_OP_DISTANCE_ME"] = "Distance de l'unité au joueur",
	["OP_OP_DISTANCE_ME_TT"] = [=[Détermine la distance (en mètres) entre une unité et le joueur.

Ne fonctionne qu'avec les joueurs.

Vaudra 0 si l'unité n'existe pas.

|cffff9900Ne fonctionne pas en instance/champ de bataille/arène depuis le patch 7.1.]=],
	["OP_OP_DISTANCE_POINT"] = "Distance de l'unité - point",
	["OP_OP_DISTANCE_POINT_PREVIEW"] = "|cff00ff00%s|r distance de |cff00ff00 (% s,% s)",
	["OP_OP_DISTANCE_POINT_TT"] = [=[Détermine la distance (en mètres) entre une unité et un point de coordonnées.

Ne fonctionne qu'avec les joueurs.

Vaudra 0 si l'unité n'existe pas.

|cffff9900Ne fonctionne pas en instance/champ de bataille/arène depuis le patch 7.1.]=],
	["OP_OP_DISTANCE_X"] = "Coordonnée X",
	["OP_OP_DISTANCE_Y"] = "Coordonnée Y",
	["OP_OP_INV_COUNT"] = "Compte d'unités d'objet",
	["OP_OP_INV_COUNT_ANY"] = "N'importe quel objet",
	["OP_OP_INV_COUNT_PREVIEW"] = "%s unités dans |cffff9900%s",
	["OP_OP_INV_COUNT_TT"] = "|cff00ff00Le nombre d'unités d'un élément que le joueur possède dans son inventaire.",
	["OP_OP_INV_WEIGHT"] = "Poids total du contenant",
	["OP_OP_INV_WEIGHT_PREVIEW"] = "Poids total de |cffff9900%s",
	["OP_OP_INV_WEIGHT_TT"] = "|cff00ff00Le poids total actuel d'un contenant (son propre poids plus le contenu).",
	["OP_OP_QUEST_NPC"] = "L'unité est un PNJ de campagne",
	["OP_OP_QUEST_NPC_TT"] = "|cff00ff00Retourne si une unité est un PNJ personnalisé dans la campagne active.",
	["OP_OP_QUEST_OBJ"] = "Objectif de la quête",
	["OP_OP_QUEST_OBJ_ALL"] = "Tous les objectifs de quête",
	["OP_OP_QUEST_OBJ_ALL_PREVIEW"] = "Objectifs de %s",
	["OP_OP_QUEST_OBJ_ALL_TT"] = "Indique si tous les objectifs possibles de la quêtes sont complétés. Donc tout autant les objectifs révélés que ceux pas encore révélés.",
	["OP_OP_QUEST_OBJ_CURRENT"] = "Objectifs courants",
	["OP_OP_QUEST_OBJ_CURRENT_PREVIEW"] = "Obj. courants de %s",
	["OP_OP_QUEST_OBJ_CURRENT_TT"] = "Détermine si tous les objectifs actuellement révélés sont complétés.",
	["OP_OP_QUEST_OBJ_PREVIEW"] = "Objectif %s de %s",
	["OP_OP_QUEST_OBJ_TT"] = "Renvoie l'accomplissement (vrai ou faux) pour un objectif de quête. Si la campagne, la quête ou l'objectif n'est pas encore révélé, renvoie faux.",
	["OP_OP_QUEST_STEP"] = "Étape de quête actuelle",
	["OP_OP_QUEST_STEP_PREVIEW"] = "%s étape actuelle",
	["OP_OP_QUEST_STEP_TT"] = "Renvoie l'ID de l'étape de la quête actuelle. Si la quête n'est pas révélée ou n'a pas d'étape courante, renvoie nil.",
	["OP_OP_RANDOM"] = "Aléatoire",
	["OP_OP_RANDOM_FROM"] = "De",
	["OP_OP_RANDOM_PREVIEW"] = "Nombre aléatoire entre |cff00ff00%s|r et |cff00ff00%s|r.",
	["OP_OP_RANDOM_TO"] = "à",
	["OP_OP_RANDOM_TT"] = "Nombre aléatoire (entier) entre deux bornes.",
	["OP_OP_TIME_HOUR"] = "Temps: Heure",
	["OP_OP_TIME_HOUR_TT"] = "L'heure actuelle de la journée, heure du serveur.",
	["OP_OP_TIME_MINUTE"] = "Temps: Minute",
	["OP_OP_TIME_MINUTE_TT"] = "La minute actuelle, heure du serveur.",
	["OP_OP_UNIT_CLASS"] = "Classe d'unités",
	["OP_OP_UNIT_CLASS_TT"] = "|cff00ff00La classe d'unité EN ANGLAIS MINUSCULE, retournée par les seconds arguments de UnitClass.",
	["OP_OP_UNIT_CLASSIFICATION"] = "Classification des unités",
	["OP_OP_UNIT_CLASSIFICATION_TT"] = [=[|cff00ff00Le classement de l'unité EN ANGLAIS MINUSCULE. Exemple: normal, elite, rare, worldboss, moins ...

Retourne toujours normal pour les joueurs.]=],
	["OP_OP_UNIT_DEAD"] = "L'unité est morte",
	["OP_OP_UNIT_DEAD_TT"] = "|cff00ff00Retourne si une unité est morte ou fantôme.",
	["OP_OP_UNIT_DISTANCE_INSPECT"] = "L'unité est proche (inspection)",
	["OP_OP_UNIT_DISTANCE_INSPECT_TT"] = "|cff00ff00Retourne si une unité est assez proche pour l'inspection (28 mètres).",
	["OP_OP_UNIT_DISTANCE_TRADE"] = "L'unité est proche (commerce)",
	["OP_OP_UNIT_DISTANCE_TRADE_TT"] = "|cff00ff00Retourne si une unité est assez proche pour l'échange (11,11 mètres).",
	["OP_OP_UNIT_EXISTS"] = "L'unité existe",
	["OP_OP_UNIT_EXISTS_TT"] = [=[|cff00ff00Retourne si une unité existe.

|rA Une unité 'existe' si elle peut être référencée par le joueur; par exemple. La cible existe si le joueur a une cible, le PNJ existe si le joueur interagit actuellement avec un PNJ, etc.]=],
	["OP_OP_UNIT_FACTION"] = "Faction de l'unité",
	["OP_OP_UNIT_FACTION_TT"] = "|cff00ff00La faction de l'unité en ANGLAIS ET MINUSCULE.",
	["OP_OP_UNIT_GUILD"] = "Guilde de l'unité",
	["OP_OP_UNIT_GUILD_RANK"] = "Rank de guilde de l'unité",
	["OP_OP_UNIT_GUILD_RANK_TT"] = "|cff00ff00Le rang de guilde de l'unité (si elle appartient à une guilde).",
	["OP_OP_UNIT_GUILD_TT"] = "|cff00ff00Le nom de la guilde de l'unité (si elle appartient à une guilde).",
	["OP_OP_UNIT_HEALTH"] = "Points de vie de l'unité",
	["OP_OP_UNIT_HEALTH_TT"] = "|cff00ff00Les points de vie actuels de l'unité.",
	["OP_OP_UNIT_ID"] = "ID de l'unité",
	["OP_OP_UNIT_ID_TT"] = "|cff00ff00L'ID de l'unité sous la forme |cff00ff00'joueur-royaume'|r, comme retourné par la fonction UnitFullName. Le royaume sera toujours présent.",
	["OP_OP_UNIT_ISPLAYER"] = "L'unité est un joueur",
	["OP_OP_UNIT_ISPLAYER_TT"] = "|cff00ff00Retourne vrai si l'unité est un joueur.",
	["OP_OP_UNIT_LEVEL"] = "Niveau de l'unité",
	["OP_OP_UNIT_LEVEL_TT"] = "|cff00ff00Le niveau de l'unité.",
	["OP_OP_UNIT_NAME"] = "Nom de l'unité",
	["OP_OP_UNIT_NAME_TT"] = [=[|cff00ff00Le nom d'une unité, première valeur de retour de la fonction UnitName.

|rUtilisé sur un joueur, il peut être |cff00ff00'joueur'|r ou |cff00ff00'joueur-royaume'|r. Donc si vous voulez être certain d'obtenir la forme |cff00ff00'joueur-royaume'|r vous devez utiliser l'opérande |cff00ff00'Unit ID'|r.]=],
	["OP_OP_UNIT_NPC_ID"] = "ID de PNJ de l'unité",
	["OP_OP_UNIT_NPC_ID_TT"] = "|cff00ff00Le PNJ ID, indiqué par UnitGUID. Ne fonctionne qu'avec les PNJ.",
	["OP_OP_UNIT_POSITION_X"] = "Position X de l'unité",
	["OP_OP_UNIT_POSITION_X_TT"] = [=[Retourne la coordonnée X d'une unité.

Ne fonctionne qu'avec les joueurs.

|cffff9900Ne fonctionne pas en instance/champs de bataille/arène depuis le patch 7.1.]=],
	["OP_OP_UNIT_POSITION_Y"] = "Position Y de l'unité",
	["OP_OP_UNIT_POSITION_Y_TT"] = [=[Retourne la coordonnée Y d'une unité.

Ne fonctionne qu'avec les joueurs.

|cffff9900Ne fonctionne pas en instance/champs de bataille/arène depuis le patch 7.1.]=],
	["OP_OP_UNIT_RACE"] = "Race de l'unité",
	["OP_OP_UNIT_RACE_TT"] = [=[|cff00ff00La race de l'unité EN ANGLAIS ET EN MINUSCULE, comme la seconde valeur de retour de la fonction UnitRace.

Donc scourge pour les Réprouvés.]=],
	["OP_OP_UNIT_SEX"] = "Sexe de l'unité",
	["OP_OP_UNIT_SEX_TT"] = [=[|cff00ff00L'index du sexe de l'unité. 2 = Homme, 3 = Femme. 1 correspond à neutre ou inconnu.

|cffffff00Retourné sous forme de STRING.]=],
	["OP_OP_UNIT_SPEED"] = "Vitesse de l'unité",
	["OP_OP_UNIT_SPEED_TT"] = "|cff00ff00La vitesse actuelle de l'unité en mètre par secondes. Marcher correspond à 2.5 et courir (sans amélioration) correspond à 7.",
	["OP_OR"] = "OU",
	["OP_OR_SWITCH"] = "Changer en OU",
	["OP_PREVIEW"] = "Prévisualisation",
	["OP_REMOVE_TEST"] = "Retirer le test",
	["OP_STRING"] = "Valeur texte",
	["OP_UNIT"] = "Type d'unité",
	["OP_UNIT_NPC"] = "PNJ",
	["OP_UNIT_PLAYER"] = "Joueur",
	["OP_UNIT_TARGET"] = "Cible",
	["OP_UNIT_TEST"] = "Test d'unité",
	["OP_UNIT_VALUE"] = "Valeur d'unité",
	["QE_ACTION"] = "Action de quête",
	["QE_ACTION_NO_CURRENT"] = "Vous n'avez pas de campagne active. Vous devez activer une campagne avant de pouvoir effectuer une action.",
	["QE_ACTIONS_TYPE_INTERRACT"] = "Interagir",
	["QE_ACTIONS_TYPE_LISTEN"] = "Écouter",
	["QE_ACTIONS_TYPE_LOOK"] = "Inspecter",
	["QE_ACTIONS_TYPE_TALK"] = "Parler",
	["QE_AUTO_REVEAL"] = "Révélation auto.",
	["QE_AUTO_REVEAL_TT"] = "Révèle automatiquement la quête dans le journal lorsque la campagne est commencée.",
	["QE_AUTORESUME_CONFIRM"] = [=[Un effet vient d'être appelé pour la campagne |cff00ff00[%s]|r.

Activer cette campagne ?
(Si vous avez déjà une campagne active, elle sera mise en pause et son progrès sera sauvegardé.)]=],
	["QE_BUTTON"] = "Ouvrir journal de quêtes",
	["QE_CAMPAIGN"] = "Campagne",
	["QE_CAMPAIGN_CURRENT"] = "Campagne actuelle",
	["QE_CAMPAIGN_CURRENT_NO"] = "Pas de campagne active",
	["QE_CAMPAIGN_EMPTY"] = "Cette campagne n'a pas de quête.",
	["QE_CAMPAIGN_FULL"] = "Terminée",
	["QE_CAMPAIGN_LIST"] = "%s campagne(s) disponible(s)",
	["QE_CAMPAIGN_NO"] = "Pas encore commencée",
	["QE_CAMPAIGN_NOQUEST"] = [=[Aucune quête révélée pour cette campagne.
Jetez un œil à la description de campagne pour révéler votre première quête.]=],
	["QE_CAMPAIGN_PAUSE"] = "Mettre la campagne en pause.",
	["QE_CAMPAIGN_RESET"] = "Réinitialiser la campagne",
	["QE_CAMPAIGN_RESUME"] = "Reprise de la campagne |cff00ff00[%s]|r.",
	["QE_CAMPAIGN_START"] = "Début de la campagne |cff00ff00[%s]|r.",
	["QE_CAMPAIGN_START_BUTTON"] = "Commencer ou reprendre la campagne",
	["QE_CAMPAIGN_UNSTARTED"] = [=[Vous n'avez pas encore commencé cette campagne.
Cliquez sur le bouton "Commencer" en haut à droite.]=],
	["QE_CAMPAIGNS"] = "Campagnes",
	["QE_COMPLETED"] = "Terminée",
	["QE_DESCRIPTION"] = "Résumé de quête",
	["QE_DESCRIPTION_TT"] = "Ce court résumé sera visible sur la page de la quête, dans le journal de quêtes.",
	["QE_FAILED"] = "Échouées",
	["QE_LINKS_ON_OBJECTIVE"] = "A la complétion d'objectif",
	["QE_LINKS_ON_OBJECTIVE_TT"] = [=[Déclenché à chaque fois que le joueur complète un objectif pour cette quête.

|cff00ff00C'est un bon endroit où vérifier si tous les objectifs actuels ont été complétés si vous avez plusieurs objectifs en cours à un moment donné.]=],
	["QE_LINKS_ON_START"] = "Au démarrage de la quête",
	["QE_LINKS_ON_START_TT"] = [=[Déclenché |cff00ff00une fois|r lorsque le joueur commencer votre quête, en la révélant dans son journal de quêtes.

|cff00ff00C'est un bon endroit pour diriger le joueur vers la première étape de la quête.]=],
	["QE_MACRO"] = "Créer macro",
	["QE_MACRO_MAX"] = "Vous ne pouvez pas créer plus de macros. Merci de libérer un emplacement de macro avant de réessayer.",
	["QE_MACRO_TT"] = "Créer une macro pour ce type d'action et placer la macro sous le curseur afin de vous laisser la placer dans vos barres d'actions.",
	["QE_NAME"] = "Nom de la quête",
	["QE_NAME_NEW"] = "Nouvelle quête",
	["QE_NAME_TT"] = "C'est le nom de votre quête, tel qu'il apparaîtra dans le journal de quêtes.",
	["QE_NEW"] = "Nouvelle quête révélée",
	["QE_NOACTION_ACTION"] = "Il n'y a rien à faire.",
	["QE_NOACTION_LISTEN"] = "Vous n'entendez rien d'intéressant.",
	["QE_NOACTION_LOOK"] = "Vous ne voyez rien de spécial.",
	["QE_NOACTION_TALK"] = "Il n'y a rien à dire.",
	["QE_NPC"] = "PNJ de campagne",
	["QE_OBJ"] = "Objectifs de quête",
	["QE_OBJ_ADD"] = "Ajouter objectif",
	["QE_OBJ_AUTO"] = "Révélation auto.",
	["QE_OBJ_AUTO_TT"] = "Révèle automatiquement cet objectif lorsque la quête est révélée dans le journal de quêtes.",
	["QE_OBJ_ID"] = "ID d'objectif",
	["QE_OBJ_ID_TT"] = "C'est l'identifiant de votre objectif. Vous ne pouvez avoir deux objectifs ayant le même ID dans la même quête.",
	["QE_OBJ_NO"] = "Pas d'objectif de quête",
	["QE_OBJ_REMOVE"] = "Supprimer cet objectif de quête ?",
	["QE_OBJ_SINGULAR"] = "Objectif de quête",
	["QE_OBJ_TEXT"] = "Texte d'objectif",
	["QE_OBJ_TT"] = [=[Les objectifs de quête sont des indices pour le joueur. Accomplir tous les objectifs ne cloture pas automatiquement la quête dans le journal. Vous décidez pleinement quand les objectifs sont révélés et il est dès lors possible d'avoir des objectifs cachés.
|cffff9900Les objectifs sont toujours ordonnés par ID dans le journal de quête, et non pas alphabétiquement.]=],
	["QE_OVERVIEW"] = "Aperçu de la quête",
	["QE_PREVIOUS_STEP"] = "Précédemment",
	["QE_PROGRESS"] = "Progression",
	["QE_PROGRESS_TT"] = [=[Ce paramètre indique que cette quête fait partie du calcul de progression de la campagne (même si la quête n'est pas révélée).

La progression de campagne est un indicateur en % placé dans le journal de quête et reflétant la progression globale des quêtes (en terme de % de quêtes accomplies par rapport au nombre total de quêtes).

|cff00ff00De manière générale cet indicateur sera toujours sélectionné, sauf pour les quêtes considérées comme annexe à votre campagne.]=],
	["QE_QUEST"] = "Quête",
	["QE_QUEST_LIST"] = "Quêtes pour cette campagne",
	["QE_QUEST_OBJ_AND_HIST"] = "Objectifs et historique",
	["QE_QUEST_OBJ_FINISHED"] = "|cffffff00Objectif accompli: |cff00ff00%s",
	["QE_QUEST_OBJ_REVEALED"] = "|cffffff00Nouvel objectif: |cff00ff00%s",
	["QE_QUEST_OBJ_UPDATED"] = "|cffffff00Objectif mis à jour: |cff00ff00%s",
	["QE_QUEST_START"] = "Début de la quête |cff00ff00[%s]|r.",
	["QE_QUEST_TT_STEP"] = [=[|cffffff00Actuellement:|r
"%s"]=],
	["QE_QUESTS"] = "Quêtes",
	["QE_QUESTS_HELP"] = [=[Vous pouvez ici ajouter des quêtes à votre campagne. Notez qu'une quête n'est pas automatiquement ajoutée au journal de quêtes du joueur lorsqu'il commence la campagne. Vous devez démarrer les quêtes à l'aide de processus.
|cffff9900Les quêtes sont ordonnées par ID dans le journal de quêtes et non pas alphabétiquement ou par ordre de révélation.|r]=],
	["QE_RESET_CONFIRM"] = [=[Réinitialiser cette campagne ?

Cela va annuler toute progression pour toutes les quêtes de la campagne.

Veuillez noter que vous ne perdrez pas les objets gagnés précédemment lors de la campagne.]=],
	["QE_ST_AUTO_REVEAL"] = "Étape initiale",
	["QE_ST_AUTO_REVEAL_TT"] = "Marque cette étape comme étant l'étape initiale de la quête lorsque celle-ci est révélée dans le journal de quête.",
	["QE_ST_END"] = "Étape finale",
	["QE_ST_END_TT"] = "Marque cette étape comme étant une étape finale de la quête. Lorsque cette étape sera atteinte, la quête sera automatiquement marquée comme terminée dans le journal de quêtes.",
	["QE_ST_LINKS_ON_LEAVE"] = "A la fin d'étape",
	["QE_ST_LINKS_ON_LEAVE_TT"] = "Déclenché |cff00ff00à chaque fois|r que le joueur quitte cette étape pour une autre. Cela sera déclenché avant que l’événement \"Au début d'étape\" de l'étape suivante ne soit déclenché.",
	["QE_ST_LINKS_ON_START"] = "Au début d'étape",
	["QE_ST_LINKS_ON_START_TT"] = "Déclanché |cff00ff00à chaque fois|r que le joueur atteint cette étape.",
	["QE_ST_POST"] = "Historique de la quête",
	["QE_ST_PRE"] = "Entrée du journal de quêtes",
	["QE_STEP"] = "Étapes de quête",
	["QE_STEP_ADD"] = "Ajouter étape de quête",
	["QE_STEP_CREATE"] = [=[Veuillez entrer l'ID d'étape. Vous ne pouvez avoir deux étapes ayant le même ID au sein de la même quête.

|cffff9900Veuillez noter que les étapes seront listées par ordre alphabétique d'ID ici et sur la base de données.

|cff00ff00C'est donc de bonne pratique de toujours commencer l'ID d'une étape par step_# où # est le numéro d'étape dans la quête.]=],
	["QE_STEP_EXIST"] = "Il existe déjà une étape avec l'identifiant %s.",
	["QE_STEP_LIST"] = "Étapes pour cette quête",
	["QE_STEP_LIST_CURRENT"] = "Quêtes disponibles",
	["QE_STEP_LIST_FINISHED"] = "Quêtes terminées",
	["QE_STEP_MISSING"] = "Informations d'étape manquantes.",
	["QE_STEP_NAME_NEW"] = "Nouvelle étape de quête",
	["QE_STEP_NO"] = "Pas d'étape de quête",
	["QE_STEP_REMOVE"] = "Supprimer cette étape ?",
	["QE_STEP_TT"] = [=[Les quêtes sont découpées en une liste d'étapes.
Chaque étape possède un texte explicatif visible dans le journal et peut ajouter une entrée dans l'historique de la quête une fois une nouvelle étape atteinte.]=],
	["QE_STEPS"] = "Étapes de quête",
	["QUEST_ID"] = "Identifiant de quête",
	["QUEST_TU_1"] = [=[Les quêtes vont souvent nécessiter |cff00ff00des interactions avec des PNJs ou des éléments de l'environnement.|r

Il y a quatre types d'action: |cff00ff00Écouter, inspecter, parler et interagir|r.

Vous pouvez effectuer des actions en |cff00ff00cliquant-droit sur le bouton du journal de quête sur la barre TRP3.|r

Mais une manière plus simple est de |cff00ff00créer des macro.|r Pour cela, utilisez ce bouton de création de macro.]=],
	["QUEST_TU_2"] = [=[|cff00ff00Vous trouvez ici la liste de toutes les campagnes disponibles.|r

Une campagne est une collection de quêtes.

|cffff9900Vous ne pouvez progresser que dans une campagne à la fois|r. Il faut donc marquer cette campagne comme étant la campagne active. |cff00ff00Pour cela utilisez le bouton "Commencer ou continuer" situé sur le cadre de la campagne.|r

Vous ne perdrez pas votre progression dans vos campagnes quand vous passez d'une campagne à une autre.

|cffff9900Vous pouvez néanmoins réinitialiser votre progression dans une campagne en cliquant-droit sur son cadre et sélectionner Réinitialiser campagne. Veuillez noter que vous garderez tous vos objets gagnés lors de votre progression.]=],
	["QUEST_TU_3"] = [=[|cff00ff00Vous trouverez ici la liste de toutes les quêtes en cours et terminées.|r

Vous pouvez y voir pour chaque quête ses objectifs actuels ainsi que la dernière étape atteinte.]=],
	["QUEST_TU_4"] = [=[|cff00ff00Vous trouverez ici la progression actuelle de la quête et tous les objectifs à remplir.|r

Vous trouverez aussi un historique des étapes précédentes, au cas où vous auriez besoin de vous rafraîchir la mémoire.]=],
	["ROOT_CREATED"] = "Créé par %s le %s",
	["ROOT_CREATED_BY"] = "Créé par",
	["ROOT_CREATED_ON"] = "Créé le",
	["ROOT_GEN_ID"] = "ID généré",
	["ROOT_ID"] = "Identifiant de création",
	["ROOT_SAVED"] = "Dernière modif. par %s le %s",
	["ROOT_TITLE"] = "Création racine",
	["ROOT_VERSION"] = "Version",
	["SEC_EFFECT_BLOCKED"] = "Effet(s) bloqué(s)",
	["SEC_EFFECT_BLOCKED_TT"] = [=[En raison de vos paramètres de sécurité actuels, au moins un effet de cet objet (ou élément interne) est bloqué.

|cffff9900Cliquez pour visualiser la sécurité de cet objet.

Vous pourrez aussi Ctrl+Clic droit sur l'objet dans votre inventaire pour configurer la sécurité plus tard.]=],
	["SEC_HIGH"] = "Haut",
	["SEC_HIGH_TT"] = "Cette création et tous ses éléments liés sont sécurisés et n'utilisent pas d'effets gênants ou malveillants.",
	["SEC_LEVEL"] = "Niveau de sécurité",
	["SEC_LEVEL_DETAIL"] = "Cliquer pour voir le détail du script non-sécurisé.",
	["SEC_LEVEL_DETAIL2"] = "Cliquer pour voir le détail du script non-sécurisé et configurer ce qui peut être exécuté.",
	["SEC_LEVEL_DETAILS"] = "Détails de sécurité",
	["SEC_LEVEL_DETAILS_ACCEPTED"] = "Accepté",
	["SEC_LEVEL_DETAILS_ALL"] = "Change la sécurité pour tous les objets",
	["SEC_LEVEL_DETAILS_ALL_TT"] = "Accepte l'exécution de cet effet sur tous les éléments, maintenant et à l'avenir.",
	["SEC_LEVEL_DETAILS_BLOCKED"] = "Bloqué",
	["SEC_LEVEL_DETAILS_FROM"] = "Toujours accepter quand reçu de %s",
	["SEC_LEVEL_DETAILS_SECURED"] = "Cet élément et tous ses éléments internes sont sûrs !",
	["SEC_LEVEL_DETAILS_THIS"] = "Change la sécurité pour cet objet",
	["SEC_LEVEL_DETAILS_THIS_TT"] = "Accepte l'exécution de cet effet pour cet élément seulement.",
	["SEC_LEVEL_DETAILS_TT"] = [=[Pour %s et tous ses éléments internes.
|cffff9900Fait par : |cff00ff00%s
|cffff9900Reçu de : |cff00ff00%s]=],
	["SEC_LOW"] = "Bas",
	["SEC_LOW_TT"] = "Cet objet, ou un de ses éléments liés, utilise au moins un script non-sécurisé qui pourrait avoir des effets malveillants.",
	["SEC_MEDIUM"] = "Moyen",
	["SEC_MEDIUM_TT"] = "Cet objet, ou un de ses éléments liés, utilise au moins un script non-sécurisé qui pourrait avoir des effets gênants.",
	["SEC_MISSING_SCRIPT"] = "Processus \"%s\" introuvable",
	["SEC_REASON_DISMOUNT"] = "Désarçonner",
	["SEC_REASON_DISMOUNT_WHY"] = [=[Cet élément pourrait vous désarçonner de votre monture.

|cffff9900Ceci pourrait être indésirable... En particulier si vous êtes sur une monture volante !]=],
	["SEC_REASON_SCRIPT"] = "Script lua",
	["SEC_REASON_SCRIPT_WHY"] = [=[Cet objet peut appeler n'importe lequel des effets Extended.

|cffff0000Il peut être utilisé à mauvais escient pour vous forcer à énoncer des propos répréhensibles par les termes d'utilisation de Blizzard, passibles d'un ban du jeu.

|cff00ff00Si bloqué, le code sera exécuté dans un environnement plus sécurisé (par exemple, les effets de discussion ne seront affichés que pour vous et pas énoncés par votre personnage).]=],
	["SEC_REASON_SOUND"] = "Déclenche un son",
	["SEC_REASON_SOUND_WHY"] = [=[Cet élément pourrait jouer un son ou une musique qui serait entendu(e) par les utilisateurs de TRP3:E alentours.

|cffff9900Ceci pourrait être indésirable pour eux, si le son est spammé ou très agaçant. Et si c'est le cas, ils pourraient vous en blâmer et vous bloquer.

|cffff9900Si vous le bloquez, ce son ou cette musique ne sera joué(e) que pour vous.]=],
	["SEC_REASON_TALK"] = "Prise de parole du personnage",
	["SEC_REASON_TALK_WHY"] = [=[Cet élément pourrait forcer votre personnage à dire un texte (via /dire, /crier ou tout autre canal).

|cffff0000Ceci pourrait être utilisé d'une façon malveillante pour vous forcer à dire quelque-chose de répréhensible selon les termes de services de Blizzard, ce qui pourrait vous valoir un bannissement du jeu.

|cffff0000Si vous le bloquez, le texte sera affiché seulement pour vous (et non prononcé par votre personnage).]=],
	["SEC_SCRIPT_ERROR"] = "Erreur dans le processus %s.",
	["SEC_TT_COMBO"] = "Alt + clic droit:|cffff9900 Configurer la sécurité",
	["SEC_TT_COMBO_2"] = "Paramétrer la sécurité",
	["SEC_UNSECURED_WHY"] = "Pourquoi n'est-ce pas sûr ?",
	["SET_TT_DETAILS_1"] = "Maintenez Alt pour afficher",
	["SET_TT_DETAILS_2"] = "%s alerte(s)",
	["SET_TT_OLD"] = [=[Cet objet a été créé avec une version antérieure de Extended (v %s).
Cela peut entraîner des incompatibilités.]=],
	["SET_TT_SECURED"] = [=[Certains effets potentiellement dérangeants ont été sécurisés.
|cff00ff00Alt + clic droit pour plus de détails.]=],
	["SET_TT_SECURED_2"] = "Des effets potentiellement malicieux ont été blockés pour votre sécurité.",
	["SET_TT_SECURED_2_1"] = "Voir plus d'informations.",
	["SPECIFIC"] = "Création spécifique",
	["SPECIFIC_INNER_ID"] = "ID interne",
	["SPECIFIC_MODE"] = "Mode",
	["SPECIFIC_PATH"] = "Chemin de la racine",
	["TB_TOOLS"] = "Base de données d'objets Extended",
	["TB_TOOLS_TT"] = "Créez vos propres objets et quêtes.",
	["TU_AC_1_TEXT"] = [=[Les |cff00ff00liens d'action|r vous permettent de lier un processus à une action de quête.

Il y a quatre types d'actions de quête que le joueur peut effectuer : |cff00ff00écouter, regarder, parler et interagir|r. 

Vous pouvez définir les liens d'action au niveau de la campagne, d'une quête, ou d'une étape de quête.]=],
	["TU_AC_2"] = "Évaluation d'actions",
	["TU_AC_2_TEXT"] = [=[Chaque action peut être conditionnée en effectuant un |cff00ff00Ctrl+click dessus|r.

Lorsqu'un joueur effectue une action, |cff00ff00tous les liens d'action seront testés dans l'ordre|r en commençant par les étapes de quêtes, suivies des quêtes, suivies enfin de la campagne.

Si un lien valide est trouvé (s'il s'agit du bon type d'action et que la condition, si existante, est remplie), le processus associé sera exécuté et |cffff9900l'addon cessera de chercher un autre lien|r.]=],
	["TU_CO_1_TEXT"] = [=[Un contenant est un object pouvant contenir d'autres objets.

Pour ouvrir un contenant vous pouvez |cff00ff00double-cliquer|r dessus dans l'inventaire.

Il est possible d'avoir des contenants qui sont également utilisables (par clic-droit). L'un n'empêche pas l'autre.

|cffff9900Please note that for now, you can only trade with players containers that are empty, or that contains only items that are inner objects of the container. Please see the inner object tab for more information.]=],
	["TU_CS_1_TEXT"] = [=[Avec les |cff00ff00cinématiques|r vous pouvez créer une expérience narrative plus immersive pour le joueur.

Les cinématiques suivent le même format utilisé dans l'addon Storyline.]=],
	["TU_CS_2_TEXT"] = [=[Une cinématique est une liste d'étapes qui seront jouées l'une après l'autre.

La cinématique prend place dans une scène avec deux personnages discutant entre eux.

A chaque étape, vous avez la possibilité de reconfigurer complètement la scène.]=],
	["TU_CS_3_TEXT"] = [=[Le texte d'étape sera découpé en plusieurs sous-étapes à chaque double saut de ligne. Ces sous-étapes suivent la même configuration d'étape.

Vous changerez typiquement d'étape lorsque vous souhaitez changer le personnage qui parle (avec l'attribut de "sens du dialogue").

Lorsque vous souhaitez changer l'attribut d'une étape, |cff00ff00assurez-vous d'avoir activé le paramètre en question.|r]=],
	["TU_CS_4"] = "Cinématiques et processus",
	["TU_CS_4_TEXT"] = [=[Vous pouvez lier un processus à une étape. Il sera exécuté au début de l'étape (ou à la première sous-étape).

Si ce processus contient un effet de Butin, vous pouvez cocher l'option "Attendre le butin" pour forcer le joueur à récupérer le butin avant de continuer la cinématique.]=],
	["TU_CS_5"] = "Aperçu",
	["TU_CS_5_TEXT"] = [=[Vous pouvez prévisualiser votre cinématique à tout moment.

|cffff9900Les processus liés ne seront pas exécutés durant la prévisualisation.|r]=],
	["TU_DB_1_TEXT"] = [=[|cff00ff00Bienvenue dans le tutoriel de la base de données.|r

Ceci est la base de données où toutes les créations sont rangées.

Une création contient toutes les informations sur un objet, un document, une campagne/quête/étape de quête ou une scène cinématique.]=],
	["TU_DB_2"] = "Types de base de données",
	["TU_DB_2_TEXT"] = [=[Il y a quatre onglets pour filtrer la base de données.

|cff00ff00Ma base de données :|r contient tous les objets que vous avez créé.

|cff00ff00Base de données des joueurs :|r contient tous les objets que vous avez reçu ou importé d'autres joueurs.

|cff00ff00 Base de données Backers :|r contient les objets créé par les backers ayant participé au Kickstarter et par l'équipe de TRP3.

|cff00ff00 Base de données complète :|r contient toutes les données.]=],
	["TU_DB_3_TEXT"] = [=[Vous pouvez filtrer chaque base de données plus précisément pour trouver une création spécifique en changeant les filtres de recherche et en sélectionnant |cff00ff00Rechercher|r. 

Sans filtres, la liste des créations suit une présentation hiérarchique.

En revanche, si vous filtrez la liste, les résultats seront affichés linéairement. Ici nous avons filtré la liste par type de création pour n'afficher que les |cffff9900objets|r.

Pour quitter la recherche, vous pouvez appuyer sur le bouton |cff00ff00Effacer|r dans la section des filtres.]=],
	["TU_DB_4"] = "Création racine et créations internes",
	["TU_DB_4_TEXT"] = [=[Il y a deux types de créations : |cff00ff00les créations racines et les créations internes|r. 

Les |cff00ff00créations internes|r sont toujours stockées dans une |cff00ff00création racine|r (même si elles peuvent être à l'intérieur d'une autre création interne stockée, ainsi de suite jusqu'à la racine).

Lorsque vous échangez un objet avec quelqu'un, toute l'information stockée dans l'objet racine est échangée, même si la création échangée est une création interne.

Pour le moment, souvenez-vous que les créations internes sont une bonne manière de lier des objets qui doivent toujours être échangés ensemble.

Exemples :
- Un objet affichant un document : le document doit être une création interne de l'objet racine.
- Une campagne avec 4 quêtes : chaque quête est une création interne de la campagne racine.
- Un objet fusil tirant des objets balles : l'objet balle doit être une création interne de l'objet fusil racine.

Ne vous inquiétez pas, cela viendra naturellement !]=],
	["TU_DB_5"] = "Créations racines",
	["TU_DB_5_TEXT"] = [=[Seuls les objets et les campagnes peuvent être des créations racines.

Vous pouvez utiliser ces deux boutons pour créer un nouvel objet ou campagne.]=],
	["TU_DB_6"] = "Créer un objet",
	["TU_DB_6_TEXT"] = [=[Lorsque vous créez un nouvel objet, vous pouvez sélectionner un patron ou utiliser le mode de création rapide.

Le mode de |cff00ff00création rapide|r vous permet de créer facilement un premier objet, mais les possibilités à votre disposition sont limitées. Notez que vous pouvez passer en mode normal à tout moment.

Utilisez le patron d'|cff00ff00objet vierge|r si vous souhaitez démarrer de zéro sans exemple.

Le patron d'|cff00ff00objet document|r crée deux créations : un objet ainsi qu'un document en création interne. Ceci configurera aussi l'objet pour afficher le document quand utilisé.

Le patron d'|cff00ff00objet contenant|r configure un objet pour être utilisé en tant que contenant.

Enfin, |cff00ff00créer à partir de...|r vous permet de dupliquer un objet existant.]=],
	["TU_DB_7"] = "Line d'une création",
	["TU_DB_7_TEXT"] = "Chaque ligne représente une création. Vous pouvez cliquer dessus pour l'éditer, ou faire un clic droit pour effectuer diverses actions.",
	["TU_EL_1_TEXT"] = [=[L'onglet de liens d'évènements est l'endroit où vous pouvez |cff00ff00lier vos processus à des évènements|r. 

|cffff9900En effet, les processus ne sont pas exécutés automatiquement par défaut !|r Vous devez les lier à un évènement afin qu'ils s'exécutent lorsqu'un évènement se produit.

Nous avons ici deux types d'évènements : |cff00ff00Les évènements de création, et les évènements du jeu|r.]=],
	["TU_EL_2_TEXT"] = [=[|cff00ff00Les évènements de création|r sont des évènements propres au fonctionnement de Total RP 3 Extended.

La liste des évènements possibles est fixée et dépend du type de création (objet, quête, etc).

Vous ne pouvez lier chaque évènement qu'à un seul processus, mais ce processus peut être lié à plusieurs évènements.]=],
	["TU_EL_3_TEXT"] = [=[|cff00ff00Les évènements du jeu|r sont des évènements lancés par le jeu lorsque quelque chose se produit.

Chaque lien que vous ajoutez liera un évènement du jeu à un processus. A chaque fois que l'évènement se produit, le processus sera exécuté.

|cff00ff00Vous pouvez ajouter une condition au lien en effectuant un Ctrl+clic dessus.|r La condition aura accès aux arguments de l'évènement à tester.
Par exemple, si vous surveillez l'évènement de lancement d'un sort, vous pourrez tester dans la condition le sort lancé.

|cffff9900Il existe une large liste d'évènements du jeu, il nous est impossible de tous les lister dans l'addon. Nous vous suggérons de consulter des sites tels que Wowwiki. http://wowwiki.wikia.com/wiki/Event_API|r]=],
	["TU_EL_3_TEXT_V2"] = [=[|cff00ff00Les évènements du jeu|r sont des évènements lancés par le jeu lorsque quelque chose se produit.

Chaque lien que vous ajoutez liera un évènement du jeu à un processus. A chaque fois que l'évènement se produit, le processus sera exécuté.

|cff00ff00Vous pouvez ajouter une condition au lien en effectuant un Ctrl+clic dessus.|r La condition aura accès aux arguments de l'évènement à tester.
Par exemple, si vous surveillez l'évènement de lancement d'un sort, vous pourrez tester dans la condition le sort lancé.

|cffff9900Il existe une large liste d'évènements du jeu, il nous est impossible de tous les lister dans l'addon. Nous vous suggérons de consulter des sites tels que Wowwiki. http://wowwiki.wikia.com/wiki/Event_API|r

|rEn plus des évènements du jeu, |cff00ff00Total RP 3: Extended met à disposition quelques évènements personnalisés|r détaillés dans le wiki de l'addon (en anglais).
|cff00ff00https://github.com/Ellypse/Total-RP-3-Extended/wiki|r]=],
	["TU_EL_4_TEXT"] = "|cff00ff00Les évènements du jeu|r ne sont disponibles que pour les campagnes, quêtes et étapes de quêtes.",
	["TU_IT_1_TEXT"] = [=[|cff00ff00Bienvenue dans le tutoriel de création d'objet.|r

Un objet est une création que vous pouvez stocker dans l'inventaire de votre personnage (ou déposer au sol).

Vous vous trouvez ici dans l'onglet Principal dans lequel vous pouvez définir tous les attributs basiques pour votre objet.]=],
	["TU_IT_2"] = "Paramètres d'affichage",
	["TU_IT_2_TEXT"] = [=[Les attributs d'affichage sont purement cosmétiques et n'ont aucun effet en jeu.

Il s'agit de tous les attributs requis pour le tooltip de l'objet ainsi que son icône.]=],
	["TU_IT_3"] = "Notes libres",
	["TU_IT_3_TEXT"] = [=[Vous pouvez rédiger des notes pour vous souvenir de ce que vous souhaitez réaliser avec votre objet.

Ces notes pourront aider d'autres joueurs qui souhaiteraient créer un objet basé sur le vôtre.]=],
	["TU_IT_4"] = "Paramètres de jouabilité",
	["TU_IT_4_TEXT"] = [=[Les attributs de jeu ont quelques effets sur le jeu.

Deux attributs sont importants: |cff00ff00Utilisable|r et |cff00ff00Contenant|r car cocher ceux-ci fera apparaître les onglets |cff00ff00Processus|r et |cff00ff00Contenant|r.]=],
	["TU_TITLE"] = "Tutoriel",
	["TU_WO_1_TEXT"] = [=[|cff00ff00Bienvenue dans ce tutoriel de création de processus.|r

Un processus est un mécanisme apportant du dynamisme à votre création. C'est ici que vous serez capable de jouer des sons, d'afficher un texte ou de proposer un loot au joueur, par exemple.]=],
	["TU_WO_2"] = "Liste de processus",
	["TU_WO_2_TEXT"] = [=[A gauche se trouve |cff00ff00la liste de vos processus|r.

Vous pouvez supprimer, renommer ou copier/coller un processus en cliquant-droit sur ce dernier.

|cffff9900Note: Si vous êtes en train de modifier un objet en "mode normal", vous ne verrez pas une liste de processus mais un seul et unique processus "A l'utilisation".

Si vous souhaitez pouvoir utiliser plusieurs processus pour un objet, vous pouvez le convertir en "mode Expert" en cliquant-droit sur l'objet dans la vue des bases de données.]=],
	["TU_WO_3_TEXT"] = [=[Ici se trouve la liste de tous les éléments du processus sélectionné.

Un élément peut être un effet, un délais ou une condition.

L'ordre des éléments est important car le processus sera exécuté de manière séquentielle.

Vous pouvez dès lors changer l'ordre des éléments en utilisant les flèches en haut à droite de chaque élément.]=],
	["TU_WO_4"] = "Ajouter un effet",
	["TU_WO_4_TEXT"] = [=[Les effets sont les éléments comme "jouer un son", "commencer une quête" ou encore "afficher une alerte".

Il y a BEAUCOUP d'effets, chacun étant décrit dans son infobulle !]=],
	["TU_WO_5"] = "Ajouter une condition",
	["TU_WO_5_TEXT"] = [=[Les conditions vous permettent |cff00ff00de tester des valeurs afin d'altérer l'exécution du processus.|r

|cffff9900Si la condition n'est pas respectée, l'exécution du processus s’interrompt.|r

Une condition est composée d'une série de tests liés entre eux par des opérateurs OU et ET.

Chaque test est une comparaison de valeurs. Par exemple: "Les points de vie de la cible sont inférieur à 500", "Le joueur n'est pas mort" ou encore "Le joueur possède au moins 3 unités de tel objet dans son inventaire".]=],
	["TU_WO_6"] = "Ajouter un délais",
	["TU_WO_6_TEXT"] = "Les délais peuvent mettre l'exécution du processus en pause pour une durée déterminée, mais ils peuvent aussi agir en tant qu'incantation et être interrompu lorsque le joueur se déplace.",
	["TU_WO_ERROR_1"] = "Veuillez créer un processus avant de continuer ce tutoriel.",
	["TYPE"] = "Type",
	["TYPE_CAMPAIGN"] = "Campagne",
	["TYPE_DIALOG"] = "Cinématique",
	["TYPE_DOCUMENT"] = "Document",
	["TYPE_ITEM"] = "Objet",
	["TYPE_ITEMS"] = "Objet(s)",
	["TYPE_LOOT"] = "Butin",
	["TYPE_QUEST"] = "Quête",
	["TYPE_QUEST_STEP"] = "Étape de quête",
	["UNIT_FRIES"] = "frites",
	["UNIT_POTATOES"] = "pommes de terre",
	["WO_ACTIONS_LINKS"] = "Liens d'action",
	["WO_ACTIONS_LINKS_TT"] = [=[Ici vous pouvez lier vos processus aux actions de quête des joueurs.
Ces actions sont : |cff00ff00Interagir, écouter, parler and inspecter.|r]=],
	["WO_ADD"] = "Créer processus",
	["WO_ADD_ID"] = [=[|cff00ff00Entrez l'ID du processus.|r

C'est un identifiant interne qui vous permet de gérer vos processus, et qui ne sera pas visible par le joueur.

Veuillez noter que vous ne pouvez pas avoir deux processus avec le même ID dans le même élément.]=],
	["WO_ADD_ID_NO_AVAILABLE"] = "Cette ID de processus n'est pas disponible.",
	["WO_COMMON_EFFECT"] = "Effets communs",
	["WO_CONDITION"] = "Condition",
	["WO_CONDITION_TT"] = [=[Évalue une condition.
Stoppe le processus si la condition échoue.]=],
	["WO_CONTEXT"] = "Contexte",
	["WO_CONTEXT_TT"] = "Le contexte de processus détermine quels effets peuvent être employés dans le processus.",
	["WO_COPY"] = "Copier le contenu de processus",
	["WO_DELAY"] = "Délai",
	["WO_DELAY_CAST"] = "Incanter pendant",
	["WO_DELAY_CAST_SOUND"] = "ID de son d'incantation",
	["WO_DELAY_CAST_SOUND_TT"] = [=[L'ID du son qui sera joué pendant l'incantation. Vous pouvez y indiquer un son qui est répétable et il sera correctement interrompu en cas d'interruption d'incantation.

|cff00ff00Exemples: 12273, 12361, ...etc.]=],
	["WO_DELAY_CAST_TEXT"] = "Texte d'incantation",
	["WO_DELAY_CAST_TEXT_TT"] = "Le texte affiché sur la barre d'incantation.",
	["WO_DELAY_DURATION"] = "Durée",
	["WO_DELAY_DURATION_TT"] = "La durée de ce délai, en secondes.",
	["WO_DELAY_INTERRUPT"] = "Interruption",
	["WO_DELAY_INTERRUPT_1"] = "Pas d'interruption",
	["WO_DELAY_INTERRUPT_2"] = "Interruption au mouvement",
	["WO_DELAY_SECONDS"] = "seconde(s)",
	["WO_DELAY_TT"] = [=[Met le processus en pause.
Peut aussi être utilisé comme incantation et peut être interrompu.]=],
	["WO_DELAY_TYPE"] = "Type de délai",
	["WO_DELAY_TYPE_1"] = "Délai normal",
	["WO_DELAY_TYPE_1_TT"] = "Met simplement le processus en pause, sans afficher d'information au joueur.",
	["WO_DELAY_TYPE_2"] = "Incantation",
	["WO_DELAY_TYPE_2_TT"] = "Affiche une barre d'incantation pendant la pause.",
	["WO_DELAY_WAIT"] = "Pause pendant",
	["WO_EFFECT"] = "Effet",
	["WO_EFFECT_CAT_COMMON"] = "Commun",
	["WO_EFFECT_NO_EDITOR"] = "Cet effet ne peut être configuré.",
	["WO_EFFECT_SELECT"] = "Sélectionnez un effet",
	["WO_EFFECT_TT"] = [=[Jouer un effet.
Il peut s'agir de jouer un son, afficher un texte ...etc.]=],
	["WO_ELEMENT"] = "Condition d'élément",
	["WO_ELEMENT_ADD"] = "Ajouter un élément au processus",
	["WO_ELEMENT_COND"] = "Modifier la condition de l'effet",
	["WO_ELEMENT_COND_NO"] = "Retirer la condition de l'effet",
	["WO_ELEMENT_COND_TT"] = "Ajouter une condition à l'exécution de cet effet.",
	["WO_ELEMENT_COPY"] = "Copier contenu de l'élément",
	["WO_ELEMENT_EDIT"] = "Cliquez pour modifier l'élément",
	["WO_ELEMENT_EDIT_CTRL"] = "Control-click pour conditionner cette instruction",
	["WO_ELEMENT_EDIT_RIGHT"] = "Click-droit pour plus d'opérations",
	["WO_ELEMENT_PASTE"] = "Coller contenu de l'élément",
	["WO_ELEMENT_TYPE"] = "Sélectionnez le type d'élément",
	["WO_EMPTY"] = [=[Commencez par ajouter un élément à votre processus.
Cela peut être un effet, une condition ou un délai.]=],
	["WO_END"] = "Fin de processus",
	["WO_EVENT_EX_ADD"] = "Ajouter un lien d'événement",
	["WO_EVENT_EX_CONDI"] = "Éditeur de condition de lien",
	["WO_EVENT_EX_EDITOR"] = "Éditeur de lien d'événement",
	["WO_EVENT_EX_LINK"] = "Lien d'événement du jeu",
	["WO_EVENT_EX_LINKS"] = "Liens d'événements du jeu",
	["WO_EVENT_EX_LINKS_TT"] = [=[Ici vous pouvez lier vos processus à des événements du jeu.
Chaque lien peut être conditionné.]=],
	["WO_EVENT_EX_NO"] = "Pas de lien",
	["WO_EVENT_ID"] = "ID d'événement",
	["WO_EVENT_ID_TT"] = [=[L'ID d'événement.

Vous trouverez la liste complète des événements du jeu sur des sites comme wowwiki ou wowpedia.

Par exemple, PLAYER_REGEN_DISABLED est un événement déclenché dès que le joueur entre en combat.]=],
	["WO_EVENT_LINKS"] = "Liens d'événements de création",
	["WO_EXECUTION"] = "Exécution du processus",
	["WO_EXPERT"] = "Mode expert",
	["WO_EXPERT_DONE"] = "%s passé en mode expert. Déchaînez maintenant votre créativité !",
	["WO_EXPERT_EFFECT"] = "Effets experts",
	["WO_EXPERT_TT"] = [=[Un processus est un ensemble d'instructions pouvant rentre votre création dynamique.

Ici vous pouvez définir tous les processus de votre création et les lier à des actions ou des événements dans l'onglet de Liens d'événements.]=],
	["WO_LINKS"] = "Liens d'événements",
	["WO_LINKS_NO_LINKS"] = "Pas de lien",
	["WO_LINKS_NO_LINKS_TT"] = "Ne pas lier cette action/événement à un processus.",
	["WO_LINKS_SELECT"] = "Sélectionnez un processus à lier",
	["WO_LINKS_TO"] = "Lié au processus",
	["WO_LINKS_TRIGGERS"] = "Ici, vous pouvez lier vos processus à des événements spécifiques pour cette création.",
	["WO_NO"] = "Pas de processus",
	["WO_PASTE"] = "Coller le contenu du processus",
	["WO_PASTE_CONFIRM"] = "Remplacer le contenu de ce processus par celui copié précédemment ?",
	["WO_REMOVE_POPUP"] = "Supprimer le processus %s ?",
	["WO_SECURITY"] = "Niveau de sécurité",
	["WO_SECURITY_HIGH"] = "Haute",
	["WO_SECURITY_HIGH_DETAILS"] = "Cet effet est sécurisé et ne demandera aucune autorisation à l'utilisateur.",
	["WO_SECURITY_LOW"] = "Basse",
	["WO_SECURITY_LOW_DETAILS"] = "Cet effet n'est pas sécurisé et peut être utilisé de manière mal intentionnée. Une alerte sera affichée et une autorisation sera demandée à l'utilisateur, selon ses paramètres de sécurité.",
	["WO_SECURITY_NORMAL"] = "Moyenne",
	["WO_SECURITY_NORMAL_DETAILS"] = "Cet effet est sécurisé mais peut causer des inconveniences. Pour cette raison, il est possible qu'une autorisation soit demandée à l'utilisateur, en fonction de ses paramètres de sécurité.",
	["WO_WO_SECURITY"] = "Sécurité du processus",
	["WO_WORKFLOW"] = "Processus"
}

Localization:GetLocale("frFR"):AddTexts(localeContent);
localeContent = {
	["ALL"] = "Todo",
	["BINDING_NAME_TRP3_INVENTORY"] = "Abrir inventario del personaje",
	["BINDING_NAME_TRP3_MAIN_CONTAINER"] = "Abrir bolsa principal",
	["BINDING_NAME_TRP3_QUEST_ACTION"] = "Acción de misión: interactuar",
	["BINDING_NAME_TRP3_QUEST_LISTEN"] = "Acción de misión: escuchar",
	["BINDING_NAME_TRP3_QUEST_LOOK"] = "Acción de misión: inspeccionar",
	["BINDING_NAME_TRP3_QUEST_TALK"] = "Acción de misión: hablar",
	["BINDING_NAME_TRP3_QUESTLOG"] = "Abrir el diario de misiones de TRP3",
	["BINDING_NAME_TRP3_SEARCH_FOR_ITEMS"] = "Buscar objetos",
	["CA_ACTION_CONDI"] = "Editor de condiciones de la acción",
	["CA_ACTION_REMOVE"] = "¿Eliminar esta acción?",
	["CA_ACTIONS"] = "Acciones",
	["CA_ACTIONS_ADD"] = "Añadir acción",
	["CA_ACTIONS_COND"] = "Editar condición",
	["CA_ACTIONS_COND_OFF"] = "Esta acción no está condicionada.",
	["CA_ACTIONS_COND_ON"] = "Esta acción está condicionada.",
	["CA_ACTIONS_COND_REMOVE"] = "Eliminar condición",
	["CA_ACTIONS_EDITOR"] = "Editor de acción",
	["CA_ACTIONS_NO"] = "Sin acción",
	["CA_ACTIONS_SELECT"] = "Seleccionar tipo de acción",
	["CA_DESCRIPTION"] = "Resumen de campaña",
	["CA_DESCRIPTION_TT"] = "Este breve resumen será visible en la página de campaña, en el diario de misiones.",
	["CA_ICON"] = "Icono de campaña",
	["CA_ICON_TT"] = "Seleccionar icono de campaña",
	["CA_IMAGE"] = "Retrato de campaña",
	["CA_IMAGE_TT"] = "Seleccionar retrato de campaña",
	["CA_LINKS_ON_START"] = "Al inicio de la campaña",
	["CA_LINKS_ON_START_TT"] = [=[Activado |cff00ff00once|r cuando el jugador empiece tu campaña, ya sea por primera vez o reiniciándola en el diario de misiones.

|cff00ff00Este es un buen lugar para activar tu primera misión.]=],
	["CA_NAME"] = "Nombre de campaña",
	["CA_NAME_NEW"] = "Nueva campaña",
	["CA_NAME_TT"] = "Este es el nombre de tu campaña. Aparece en el diario de misiones.",
	["CA_NO_NPC"] = "PNJ no personalizado",
	["CA_NPC"] = "Lista de PNJs de la campaña",
	["CA_NPC_ADD"] = "Añadir PNJ personalizado",
	["CA_NPC_AS"] = "Duplicar",
	["CA_NPC_EDITOR"] = "Editor de PNJ",
	["CA_NPC_EDITOR_DESC"] = "Descripción de PNJ",
	["CA_NPC_EDITOR_NAME"] = "Nombre de PNJ",
	["CA_NPC_ID"] = "ID de PNJ",
	["CA_NPC_ID_TT"] = [=[Por favor, introduce la ID del PNJ a personalizar.

|cff00ff00Para obtener la ID del PNJ que tienes en objetivo, escribe este comando en el chat: /trp3 getID]=],
	["CA_NPC_NAME"] = "Nombre de PNJ por defecto",
	["CA_NPC_REMOVE"] = "¿Deseas eliminar la personalización para este NPC?",
	["CA_NPC_TT"] = "Puedes personalizar PNJs para darles un nombre, icono y descripción. Esta personalización será visible cuando el jugador tenga tu campaña activa.",
	["CA_NPC_UNIT"] = "PNJ personalizado",
	["CA_QE_ID"] = "Cambiar ID de misión",
	["CA_QE_ST_ID"] = "Cambiar ID del paso de misión",
	["CA_QUEST_ADD"] = "Añadir misión",
	["CA_QUEST_CREATE"] = [=[Por favor, introduce la ID de misión. No puedes tener dos misiones con la misma ID en la misma campaña.

|cffff9900Por favor, ten en cuenta que las misiones serán listadas en orden alfabético de ID en la lista de misiones.

|cff00ff00Es una buena práctica empezar tus ID por quest_#, donde # es el número de la misión en la campaña.]=],
	["CA_QUEST_EXIST"] = "Ya existe una misión con la ID %s.",
	["CA_QUEST_NO"] = "Sin misiones",
	["CA_QUEST_REMOVE"] = "¿Eliminar esta misión?",
	["COM_NPC_ID"] = "obtener id de pnj",
	["COND_COMPLETE"] = "Completar expresión lógica",
	["COND_EDITOR"] = "Editor de condiciones",
	["COND_LITT_COMP"] = "Todos los tipos de comparación",
	["COND_NUM_COMP"] = "Sólo comparación numérica",
	["COND_NUM_FAIL"] = "Debes tener dos operandos numéricos si usas el comparador numérico.",
	["COND_PREVIEW_TEST"] = "Prueba preliminar",
	["COND_PREVIEW_TEST_TT"] = "Muestra en el chat la evaluación de la prueba basada en la situación actual.",
	["COND_TEST_EDITOR"] = "Editor de prueba",
	["COND_TESTS"] = "Pruebas de condición",
	["CONF_MAIN"] = "Ajustes extendidos",
	["CONF_MUSIC_ACTIVE"] = "Reproducir música local",
	["CONF_MUSIC_ACTIVE_TT"] = [=[La música local es música reproducida por otros jugadores (por ejemplo, mediante un objeto) a cierto rango en metros.

Desactívalo si no quieres escuchar estas músicas.

|cff00ff00Ten en cuenta que no escucharás música de jugadores ignorados.

|cff00ff00Ten en cuenta que todas las músicas son interrumpibles mediante la opción Historial de sonido en la barra de atajos de TRP3.]=],
	["CONF_MUSIC_METHOD_TT"] = "Determina cómo escucharás la música local cuando estés en rango.",
	["CONF_SOUNDS"] = "Música/sonido local",
	["CONF_SOUNDS_ACTIVE"] = "Reproducir sonidos locales",
	["CONF_SOUNDS_ACTIVE_TT"] = [=[Los sonidos locales son sonidos reproducidos por otros jugadores (por ejemplo, mediante un objeto) a cierto rango en metros.

Desactívalo si no quieres escuchar estos sonidos.

|cff00ff00Ten en cuenta que no escucharás sonidos de jugadores ignorados.

|cff00ff00Ten en cuenta que todos los sonidos son interrumpibles mediante la opción Historial de sonido en la barra de atajos de TRP3.]=],
	["CONF_SOUNDS_MAXRANGE_TT"] = [=[Establece el rango máximo (en metros) en que escucharás sonido/música local.

|cff00ff00Útil para evitar a gente que use sonidos en todo el continente.

|cffff9900¡Cero significa sin límite!]=],
	["CONF_SOUNDS_METHOD_1"] = "Reproducir automáticamente",
	["CONF_SOUNDS_METHOD_1_TT"] = "Si estás en rango, se reproducirá el sonido/música sin pedirte permiso.",
	["CONF_SOUNDS_METHOD_2"] = "Pedir permiso",
	["CONF_SOUNDS_METHOD_2_TT"] = "Si estás en rango, aparecerá un link en el chat pidiéndote confirmación para reproducir el sonido/música.",
	["CONF_SOUNDS_METHOD_TT"] = "Determina cómo escucharás el sonido local cuando estés en rango.",
	["CONF_UNIT"] = "Unidades",
	["CONF_UNIT_WEIGHT"] = "Unidad de peso",
	["CONF_UNIT_WEIGHT_1"] = "Gramos",
	["CONF_UNIT_WEIGHT_2"] = "Libras",
	["CONF_UNIT_WEIGHT_3"] = "Patatas",
	["CONF_UNIT_WEIGHT_TT"] = "Define cómo se muestran los valores de peso.",
	["DB"] = "Base de datos",
	["DB_ACTIONS"] = "Acciones",
	["DB_ADD_COUNT"] = "¿Cuántas unidades de %s deseas añadir al inventario?",
	["DB_ADD_ITEM"] = "Añadir al inventario principal",
	["DB_ADD_ITEM_TT"] = "Añade unidades de este objeto en tu bolsa principal (o inventario principal si no tienes una bolsa principal con el personaje).",
	["DB_BACKERS"] = "Base de datos de backers (%s)",
	["DB_BACKERS_LIST"] = "Créditos",
	["DB_BROWSER"] = "Buscador de objetos",
	["DB_COPY_ID_TT"] = "Muestra la ID del objeto en un popup para copiar/pegar.",
	["DB_COPY_TT"] = "Copia toda la información de este objeto y sus hijos para poderse añadir como objeto interno de otro objeto",
	["DB_CREATE_CAMPAIGN"] = "Crear campaña",
	["DB_CREATE_CAMPAIGN_TT"] = "Iniciar la creación de una campaña",
	["DB_CREATE_ITEM"] = "Crear objeto",
	["DB_CREATE_ITEM_TEMPLATES"] = "O seleccionar una plantilla",
	["DB_CREATE_ITEM_TEMPLATES_BLANK"] = "Objeto en blanco",
	["DB_CREATE_ITEM_TEMPLATES_BLANK_TT"] = [=[Plantilla en blanco.
Para aquellos a quienes les gusta empezar de cero.]=],
	["DB_CREATE_ITEM_TEMPLATES_CONTAINER"] = "Contenedor",
	["DB_CREATE_ITEM_TEMPLATES_CONTAINER_TT"] = [=[Una plantilla para objetos de tipo contenedor.
Un contenedor puede almacenar otros objetos.]=],
	["DB_CREATE_ITEM_TEMPLATES_DOCUMENT"] = "Documento",
	["DB_CREATE_ITEM_TEMPLATES_DOCUMENT_TT"] = [=[Una plantilla con un objeto interno de tipo documento.
Útil para crear rápidamente un libro o un pergamino.]=],
	["DB_CREATE_ITEM_TEMPLATES_FROM"] = "Crear desde...",
	["DB_CREATE_ITEM_TEMPLATES_FROM_TT"] = "Crear una copia de un objeto existente.",
	["DB_CREATE_ITEM_TEMPLATES_QUICK"] = "Creación rápida",
	["DB_CREATE_ITEM_TEMPLATES_QUICK_TT"] = [=[Rápidamente crea un objeto sencillo sin efectos.
Añade una unidad de este objeto a tu bolsa principal.]=],
	["DB_CREATE_ITEM_TT"] = "Seleccionar plantilla para el nuevo objeto",
	["DB_DELETE_TT"] = "Elimina este objeto y sus hijos.",
	["DB_EXPERT_TT"] = "Cambia este objeto al modo experto, permitiendo personalizaciones más complejas.",
	["DB_EXPORT"] = "Exportación rápida",
	["DB_EXPORT_DONE"] = [=[Tu objeto ha sido exportado en un archivo llamado |cff00ff00totalRP3_Extended_ImpExport.lua|r localizado en:

World of Warcraft\WTF\
account\YOUR_ACCOUNT\SavedVariables

¡Puedes compartir este archivo con tus amigos!

Con él pueden seguir el proceso de importación situado en la |cff00ff00pestaña de Base de datos total|r.]=],
	["DB_EXPORT_HELP"] = "Código para el objeto %s (tamaño: %0.1f kB)",
	["DB_EXPORT_MODULE_NOT_ACTIVE"] = "Importación/exportación completa de objetos: Por favor, habilita el complemento \"totalRP3_Extended_ImpExport\" primero.",
	["DB_EXPORT_TOO_LARGE"] = [=[Este objeto es demasiado grande para ser exportado de este modo. Por favor, usa la opción "Exportación completa".

Tamaño: %0.1f kB.]=],
	["DB_EXPORT_TT"] = [=[Serializa el contenido del objeto para ser compartido fuera del juego.

Solo funciona con objetos pequeños (menos de 20 kB una vez serializados). Para objetos de mayor tamaño, usa la opción "exportación completa".]=],
	["DB_FILTERS"] = "Filtros de búsqueda",
	["DB_FILTERS_CLEAR"] = "Limpiar",
	["DB_FILTERS_NAME"] = "Nombre de objeto",
	["DB_FILTERS_OWNER"] = "Creado por",
	["DB_FULL"] = "Base de datos total (%s)",
	["DB_FULL_EXPORT"] = "Exportación completa",
	["DB_FULL_EXPORT_TT"] = [=[Realiza una exportación completa de este objeto sin importar su tamaño.

Esto provocará una recarga de la interfaz para forzar el guardado de los ficheros del add-on.]=],
	["DB_HARD_SAVE"] = "Forzar guardado",
	["DB_HARD_SAVE_TT"] = "Recarga la interfaz del juego para forzar que las variables guardadas se escriban en el disco.",
	["DB_IMPORT"] = "Importación rápida de objetos",
	["DB_IMPORT_CONFIRM"] = [=[Este objeto ha sido serializado en una versión diferente a la tuya de Total RP 3 Extended.

Versión TRP3E del objeto: %s
Tu versión de TRP3E: %s

|cffff9900Esto podría provocar incompatibilidades.
¿Continuar con la importación de todas formas?]=],
	["DB_IMPORT_DONE"] = "¡Objeto importado con éxito!",
	["DB_IMPORT_EMPTY"] = [=[No hay objetos para importar en el fichero |cff00ff00totalRP3_Extended_ImpExport.lua|r.

Este fichero debe colocarse en el siguiente directorio |cffff9900antes de lanzar el juego|r:

World of Warcraft\WTF\
account\YOUR_ACCOUNT\SavedVariables]=],
	["DB_IMPORT_ERROR1"] = "El objeto no pudo ser deserializado.",
	["DB_IMPORT_FULL"] = "Importación total",
	["DB_IMPORT_FULL_CONFIRM"] = [=[¿Quieres importar el siguiente objeto?

%s
%s
Por |cff00ff00%s|r
Versión %s]=],
	["DB_IMPORT_FULL_TT"] = "Importa el fichero |cff00ff00totalRP3_Extended_ImpExport.lua|r.",
	["DB_IMPORT_ITEM"] = "Importar objeto",
	["DB_IMPORT_TT"] = "Pega aquí un objeto previamente serializado.",
	["DB_IMPORT_VERSION"] = [=[Estás importando una versión anterior de un objeto ya existente.

Versión de importación: %s
Tu versión: %s

|cffff9900¿Confirmas los cambios?]=],
	["DB_IMPORT_WORD"] = "Importar",
	["DB_LIST"] = "Lista de creaciones",
	["DB_LOCALE"] = "Localización del objeto",
	["DB_MY"] = "Mi base de datos (%s)",
	["DB_MY_EMPTY"] = [=[No has creado ningún objeto todavía.
¡Usa los botones de abajo para dar rienda suelta a tu creatividad!]=],
	["DB_OTHERS"] = "Base de datos de jugadores (%s)",
	["DB_OTHERS_EMPTY"] = "Aquí se colocarán los objetos creados por otros jugadores.",
	["DB_REMOVE_OBJECT_POPUP"] = [=[Por favor, confirma la eliminación del objeto:
ID: |cff00ffff"%s"|r
|cff00ff00[%s]|r

|cffff9900Aviso: ¡Esta acción no puede revertirse!]=],
	["DB_RESULTS"] = "Buscar resultados",
	["DB_SECURITY_TT"] = "Muestra todos los parámetros de seguridad para este objeto. Desde aquí puedes permitir o prevenir ciertos efectos indeseados.",
	["DB_TO_EXPERT"] = "Convertir a modo experto",
	["DB_WARNING"] = [=[|cffff0000¡¡¡ Aviso !!!

|cffff9900¡No olvides guardar los cambios antes de volver a la lista de la base de datos!]=],
	["DEBUG_QUEST_START"] = "Iniciar misión",
	["DEBUG_QUEST_START_USAGE"] = "Uso: /trp3 debug_quest_start questID",
	["DEBUG_QUEST_STEP"] = "Ir al paso de la misión.",
	["DEBUG_QUEST_STEP_USAGE"] = "Uso: /trp3 debug_quest_step questID stepID",
	["DI_ATTR_TT"] = "Solo marca esta opción si quieres cambiar este atributo en relación al paso anterior de la escena.",
	["DI_ATTRIBUTE"] = "Cambiar atributos",
	["DI_BKG"] = "Imagen de fondo",
	["DI_BKG_TT"] = [=[Se usará como fondo para este paso de la escena. Por favor introduce la ruta completa de la textura.

Si cambias el fondo durante la escena habrá una transición entre los diferentes fondos.]=],
	["DI_CHOICE"] = "Opción",
	["DI_CHOICE_CONDI"] = "Condición de opción",
	["DI_CHOICE_STEP"] = "Ir al paso",
	["DI_CHOICE_STEP_TT"] = [=[Introduce el número del paso de la escena que quieres mostrar si el jugador selecciona esta opción.

|cff00ff00Si se deja vacío o con un valor inválido, seleccionar esta opción hará terminar la escena (y activar el evento "Al finalizar").]=],
	["DI_CHOICE_TT"] = [=[Introducir el texto para esta opción.

|cff00ff00Dejar en blanco para deshabilitar esta opción.]=],
	["DI_CHOICES"] = "Elecciones del jugador",
	["DI_CHOICES_TT"] = "Configurar las elecciones de jugador para este paso.",
	["DI_CONDI_TT"] = [=[Establece una condición para esta opción. Si la condición no se cumple cuando se muestren las opciones, la opción asociada a esta no será visible.

|cff00ff00Click: Configurar condición
Click-derecho: Eliminar condición]=],
	["DI_DIALOG"] = "Diálogo",
	["DI_DISTANCE"] = "Distancia máxima (metros)",
	["DI_DISTANCE_TT"] = [=[Define la distancia máxima (en yardas) en la que el jugador puede alejarse de la escena una vez comenzada. Pasado este límite se cerrará automáticamente (y activará el evento "Al cancelar").

|cff00ff00Cero implica que no hay límite.

|cffff9900No funciona en instancias/campos de batalla/arenas desde el parche 7.1.]=],
	["DI_END"] = "Paso final",
	["DI_END_TT"] = [=[Marca este paso como el último. Cuando se llegue a éste se finalizará la escena (y se activará el evento "Al terminar").

|cff00ff00Útil si has usado opciones de jugadores en esta escena.]=],
	["DI_FRAME"] = "Decoración",
	["DI_GET_ID"] = "ID del objetivo",
	["DI_GET_ID_TT"] = "Copia la ID del PNJ objetivo. Solo funciona si tu objetivo actual es un PNJ.",
	["DI_HISTORY"] = "Historial de escenas",
	["DI_HISTORY_TT"] = "Click para mostrar/ocultar el panel del historial, mostrando las líneas anteriores de la escena.",
	["DI_IMAGE"] = "Imagen",
	["DI_IMAGE_TT"] = [=[Muestra una imagen en el centro del marco de la escena. Esta imagen aparecerá lentamente.
Por favor, introduce la ruta completa de la textura.

Para ocultar la imagen más adelante simplemente no informes este atributo.]=],
	["DI_LEFT_UNIT"] = "Cambiar modelo de la izquierda",
	["DI_LINKS_ONEND"] = "Al finalizar la escena",
	["DI_LINKS_ONEND_TT"] = [=[Se activa cuando la escena actual finaliza.

|cff00ff00Esto puede ocurrir cuando se llega al último paso o permitiendo que el jugador elija una opción con un "ir al paso" sin informar o desconocido.

|cffff0000Esto NO se activará si el jugador cancela la escena manualmente cerrando el marco.]=],
	["DI_LINKS_ONSTART"] = "Al comenzar la escena",
	["DI_LINKS_ONSTART_TT"] = [=[Se activa cuando comienza la escena.

|cffff9900Ten en cuenta que este flujo de trabajo se activará ANTES de mostrar el primer paso de la escena.]=],
	["DI_LOOT"] = "Esperar a despojar objetos",
	["DI_LOOT_TT"] = "Si el flujo de trabajo seleccionado a la izquierda muestra una selección de objetos al jugador, puedes marcar este parámetro para prevenir que el jugador avance a la siguiente escena si éste no ha despojado todos los objetos.",
	["DI_MODELS"] = "Modelos",
	["DI_NAME"] = "Cambiar el nombre del portavoz",
	["DI_NAME_DIRECTION"] = "Dirección del diálogo",
	["DI_NAME_DIRECTION_TT"] = "Determina donde colocar la burbuja de diálogo y el nombre, y qué modelo animar. Selecciona \"Ninguno\" para ocultar completamente la burbuja de diálogo y el nombre.",
	["DI_NAME_TT"] = [=[El nombre del personaje hablando en este paso.

Solo es necesario si la dirección del diálogo seleccionada arriba es "Ninguno".]=],
	["DI_NEXT"] = "Índice del siguiente paso",
	["DI_NEXT_TT"] = [=[Puedes indicar qué paso será mostrado después de este.

|cff00ff00Dejarlo en blanco mostrará el siguiente paso en orden secuencial. Únicamente usa este campo si necesitas 'saltar' a otro paso. Útil cuando se usan "opciones".]=],
	["DI_RIGHT_UNIT"] = "Cambiar modelo de la derecha",
	["DI_STEP"] = "Paso de la escena",
	["DI_STEP_ADD"] = "Añadir paso",
	["DI_STEP_EDIT"] = "Editar paso",
	["DI_STEP_TEXT"] = "Texto del paso",
	["DI_STEPS"] = "Pasos de la escena",
	["DI_UNIT_TT"] = [=[Establece el modelo a mostrar:

- Dejar vacío para ocultar el modelo
- "player" para usar el modelo del jugador
- "target" para usar el modelo del objetivo
- Cualquier número para cargar un ID de PNJ]=],
	["DI_WAIT_LOOT"] = "Por favor, despoja todos los objetos",
	["DISCLAIMER_OK"] = "Por la presente firmo este contrato con mi sangre",
	["DO_EMPTY"] = "Documento vacío",
	["DO_LINKS_ONCLOSE"] = "Al cerrar",
	["DO_LINKS_ONCLOSE_TT"] = "Se activa cuando el documento se cierra por el jugador u otro evento (por ejemplo a través de un efecto del flujo de trabajo)",
	["DO_LINKS_ONOPEN"] = "Al abrir",
	["DO_LINKS_ONOPEN_TT"] = "Se activa cuando el documento se muestra al jugador.",
	["DO_NEW_DOC"] = "Documento",
	["DO_PAGE_ADD"] = "Añadir página",
	["DO_PAGE_BORDER"] = "Borde",
	["DO_PAGE_BORDER_1"] = "Pergamino",
	["DO_PAGE_COUNT"] = "Página %s / %s",
	["DO_PAGE_EDITOR"] = "Editor de página: página %s",
	["DO_PAGE_FIRST"] = "Primera página",
	["DO_PAGE_FONT"] = "%s fuente",
	["DO_PAGE_HEIGHT"] = "Altura de página",
	["DO_PAGE_HEIGHT_TT"] = "La altura de la página en píxeles. Por favor, ten en cuenta que algunos fondos sólo se verán bien a determinado ancho/alto y pueden deformarse.",
	["DO_PAGE_LAST"] = "Última página",
	["DO_PAGE_MANAGER"] = "Gestor de páginas",
	["DO_PAGE_NEXT"] = "Página siguiente",
	["DO_PAGE_PREVIOUS"] = "Página anterior",
	["DO_PAGE_REMOVE"] = "Eliminar página",
	["DO_PAGE_REMOVE_POPUP"] = "¿Eliminar la página %s ?",
	["DO_PAGE_RESIZE"] = "Redimensionable",
	["DO_PAGE_RESIZE_TT"] = [=[Permite al usuario cambiar el tamaño del marco.

|cffff9900Asegúrate que tu diseño pueda leerse y no dependa de la altura/anchura.

|cff00ff00Ten en cuenta que el usuario no podrá reducir el tamaño del marco por debajo del ancho y alto por defecto.]=],
	["DO_PAGE_TILING"] = "Mosaico de fondo",
	["DO_PAGE_TILING_TT"] = "Determina si el fondo se repetirá vertical y horizontalmente. En caso contrario, la textura se expandirá hasta ocupar todo el marco.",
	["DO_PAGE_WIDTH"] = "Ancho de página",
	["DO_PAGE_WIDTH_TT"] = "El ancho de la página en píxeles. Por favor, ten en cuenta que algunos fondos sólo se verán bien a determinado ancho/alto y pueden deformarse.",
	["DO_PARAMS_CUSTOM"] = "Parámetros personalizados de página",
	["DO_PARAMS_GLOBAL"] = "Parámetros por defecto",
	["DO_PARAMS_GLOBAL_TT"] = "Cambia los parámetros por defecto del documento. Estos parámetros se usarán para todas las páginas que no usen parámetros de página propios.",
	["DO_PREVIEW"] = "Clic para vista previa",
	["DOC_UNKNOWN_ALERT"] = "No se puede abrir el documento. (Missing class)",
	["DR_DELETED"] = "Destruido: %s x%d",
	["DR_DROPED"] = "Soltado en el suelo: %s x%d",
	["DR_NOTHING"] = "No se hallaron objetos en este área.",
	["DR_POPUP"] = "Soltar aquí",
	["DR_POPUP_ASK"] = [=[Total RP 3

Selecciona qué quieres hacer con el objeto:
%s]=],
	["DR_POPUP_REMOVE"] = "Destruir",
	["DR_POPUP_REMOVE_TEXT"] = "¿Destruir este objeto?",
	["DR_STASHED"] = "Esconder: %s x%d",
	["DR_STASHES"] = "Escondites",
	["DR_STASHES_CREATE"] = "Crear un escondite aquí",
	["DR_STASHES_CREATE_TT"] = "Crea un escondite donde estás parado.",
	["DR_STASHES_EDIT"] = "Editar escondite",
	["DR_STASHES_FOUND"] = "Escondites encontrados: %s",
	["DR_STASHES_FULL"] = "Este escondite está lleno.",
	["DR_STASHES_HIDE"] = "Ocultar del escaneo",
	["DR_STASHES_MAX"] = "máx 50 caracteres",
	["DR_STASHES_NAME"] = "Escondite",
	["DR_STASHES_NOTHING"] = "No se han encontrado escondites en esta zona.",
	["DR_STASHES_REMOVE"] = "Eliminar escondite",
	["DR_STASHES_REMOVE_PP"] = [=[¿Eliminar este escondite?
|cffff9900¡Todos los objetos que están dentro se perderán!]=],
	["DR_STASHES_REMOVED"] = "Escondite eliminado.",
	["DR_STASHES_RESYNC"] = "Resincronizar",
	["DR_STASHES_SCAN"] = "Rastrear escondites de los jugadores",
	["DR_STASHES_SCAN_MY"] = "Rastrear mis escondites",
	["DR_STASHES_SYNC"] = "Sincronizando...",
	["EDITOR_CONFIRM"] = "Confirmar",
	["EDITOR_HEIGHT"] = "Altura",
	["EDITOR_ICON"] = "Seleccionar icono",
	["EDITOR_ICON_SELECT"] = "Haz clic para seleccionar un icono.",
	["EDITOR_ID_COPY"] = "Copiar ID",
	["EDITOR_MAIN"] = "Principal",
	["EDITOR_MORE"] = "Más",
	["EDITOR_PREVIEW"] = "Previsualizar",
	["EDITOR_WIDTH"] = "Ancho",
	["EFFECT_CAT_CAMERA"] = "Cámara",
	["EFFECT_CAT_CAMERA_LOAD"] = "Cargar cámara",
	["EFFECT_CAT_CAMPAIGN"] = "Campaña y misión",
	["EFFECT_CAT_SOUND"] = "Sonido y música",
	["EFFECT_CAT_SPEECH"] = "Diálogos y emociones",
	["EFFECT_DOC_CLOSE"] = "Cerrar documento",
	["EFFECT_DOC_CLOSE_TT"] = "Cierra el documento actualmente abierto. No hace nada si no hay ningún documento abierto.",
	["EFFECT_DOC_DISPLAY"] = "Mostrar documento",
	["EFFECT_DOC_DISPLAY_TT"] = "Muestra un documento al jugador. Si ya hay un documento abierto, este será reemplazado.",
	["EFFECT_DOC_ID"] = "ID del documento",
	["EFFECT_ITEM_ADD"] = "Añadir objeto",
	["EFFECT_ITEM_ADD_ID"] = "ID de objeto",
	["EFFECT_ITEM_ADD_PREVIEW"] = "Añadir %sx %s",
	["EFFECT_ITEM_ADD_QT"] = "Cantidad",
	["EFFECT_ITEM_ADD_TT"] = "Añade objetos a tu bolsa.",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD"] = "Tipo",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_DAMAGE"] = "Daño",
	["EFFECT_ITEM_BAG_DURABILITY_METHOD_HEAL"] = "Reparar",
	["EFFECT_ITEM_CONSUME"] = "Consumir objeto",
	["EFFECT_ITEM_CONSUME_TT"] = "Consume el objeto usado y lo destruye.",
	["EFFECT_ITEM_DICE"] = "Tirar dados",
	["EFFECT_ITEM_REMOVE"] = "Destruir objeto",
	["EFFECT_ITEM_REMOVE_PREVIEW"] = "Destruye %sx %s",
	["EFFECT_ITEM_REMOVE_TT"] = "Destruye objetos de tu inventario.",
	["EFFECT_ITEM_SOURCE"] = "Buscar en",
	["EFFECT_ITEM_SOURCE_1"] = "Todo el inventario",
	["EFFECT_ITEM_SOURCE_3"] = "Este objeto",
	["EFFECT_OPERATION"] = "Operación",
	["EFFECT_OPERATION_TYPE"] = "Tipo de operación",
	["EFFECT_OPERATION_TYPE_ADD"] = "Sumar",
	["EFFECT_OPERATION_TYPE_DIV"] = "Dividir",
	["EFFECT_OPERATION_TYPE_MULTIPLY"] = "Multiplicar",
	["EFFECT_OPERATION_TYPE_SUB"] = "Restar",
	["EFFECT_OPERATION_VALUE"] = "Valor de la operación",
	["EFFECT_QUEST_GOTOSTEP_PREVIEW"] = "Ir al paso %s.",
	["EFFECT_QUEST_OBJ_ID"] = "ID del objetivo",
	["EFFECT_QUEST_REVEAL_OBJ_DONE"] = "Completar objetivo",
	["EFFECT_QUEST_START_ID"] = "ID de misión",
	["EFFECT_RANDSUM"] = "Invocar mascota de batalla aleatoria",
	["EFFECT_SIGNAL"] = "Enviar señal",
	["EFFECT_SIGNAL_ID"] = "ID de señal",
	["EFFECT_SIGNAL_VALUE"] = "Valor de la señal",
	["EFFECT_SOUND_ID_LOCAL"] = "Reproducir sonido local",
	["EFFECT_SOUND_ID_SELF_CHANNEL"] = "Canal",
	["EFFECT_SOUND_ID_SELF_CHANNEL_SFX"] = "SFX",
	["EFFECT_SOUND_ID_SELF_ID"] = "ID del sonido",
	["EFFECT_SOUND_MUSIC_LOCAL"] = "Reproducir música local",
	["EFFECT_SOUND_MUSIC_SELF"] = "Reproducir música",
	["EFFECT_SOUND_MUSIC_SELF_PREVIEW"] = "Reproducir música: %s",
	["EFFECT_SOUND_MUSIC_STOP"] = "Detener música",
	["EFFECT_SOUND_PLAY"] = "Reproducir",
	["EFFECT_SOURCE_CAMPAIGN"] = "Activar campaña",
	["EFFECT_SPEECH_NPC"] = "Diálogo: PNJ",
	["EFFECT_SPEECH_NPC_DEFAULT"] = "¿Quieres hacer un muñeco de nieve?",
	["EFFECT_SPEECH_NPC_NAME"] = "Nombre del PNJ",
	["EFFECT_SPEECH_NPC_NAME_TT"] = "El nombre del PNJ.",
	["EFFECT_SPEECH_PLAYER"] = "Diálogo: Jugador",
	["EFFECT_SPEECH_PLAYER_DEFAULT"] = "¡Deja que el fuego te consuma!",
	["EFFECT_SPEECH_PLAYER_TT"] = "Hace que el jugador hable, grite o haga un /e emote.",
	["EFFECT_SPEECH_TYPE"] = "Tipo de diálogo",
	["EFFECT_SUMMOUNT"] = "Invocar montura",
	["EFFECT_TEXT"] = "Mostrar texto",
	["EFFECT_TEXT_PREVIEW"] = "Texto mostrado",
	["EFFECT_TEXT_TEXT"] = "Texto",
	["EFFECT_TEXT_TEXT_DEFAULT"] = "Tu texto",
	["EFFECT_TEXT_TEXT_TT"] = "Texto para mostrar.",
	["EFFECT_TEXT_TYPE"] = "Tipo de texto",
	["EFFECT_TEXT_TYPE_3"] = "Texto de alerta de banda",
	["EFFECT_TEXT_TYPE_4"] = "Mensaje de alerta",
	["EX_SOUND_HISTORY"] = "Historial de sonido",
	["EX_SOUND_HISTORY_CLEAR"] = "Limpiar",
	["EX_SOUND_HISTORY_EMPTY"] = "No se ha reproducido ningún sonido.",
	["EX_SOUND_HISTORY_STOP"] = "Detener",
	["EX_SOUND_HISTORY_STOP_ALL"] = "Detener todo",
	["IN_INNER_ADD_COPY"] = "Añadir copia de objeto existente",
	["IN_INNER_ADD_NEW"] = "Crear nuevo objeto",
	["IN_INNER_ID_ACTION"] = "Cambiar ID",
	["IN_INNER_ID_COPY"] = "Copiar",
	["INV_PAGE_CAMERA_CONFIG"] = [=[Parámetros de cámara:
  Rotación: %.2f]=],
	["INV_PAGE_CHARACTER_INSPECTION"] = "Inspección de personaje",
	["INV_PAGE_CHARACTER_INSPECTION_TT"] = "Inspeccionar el inventario del personaje.",
	["INV_PAGE_CHARACTER_INV"] = "Inventario",
	["INV_PAGE_EDIT_ERROR1"] = "Debes ser el autor de este objeto para editarlo.",
	["INV_PAGE_INV_OPEN"] = "Abrir inventario",
	["IT_CRAFTED"] = "Creado",
	["IT_DR_SOUND"] = "Sonido al soltarlo",
	["IT_EX_DOWNLOADING"] = "Descargando: %0.1f %%",
	["IT_EX_EMPTY"] = "Nada que intercambiar",
	["IT_INV_ERROR_CANT_HERE"] = "No puedes poner objetos aquí.",
	["IT_INV_ERROR_MAX"] = "No puedes llevar más %s.",
	["IT_INV_SCAN_MY_ITEMS"] = "Rastrear mis objetos",
	["IT_NEW_NAME"] = "Nuevo objeto",
	["IT_PU_SOUND"] = "Sonido al cogerlo",
	["IT_PU_SOUND_1183"] = "Bolsa",
	["IT_PU_SOUND_1184"] = "Libro",
	["IT_PU_SOUND_1185"] = "Tela",
	["IT_PU_SOUND_1186"] = "Comida",
	["IT_PU_SOUND_1187"] = "Hierba",
	["IT_PU_SOUND_1188"] = "Cadena",
	["IT_PU_SOUND_1189"] = "Carne",
	["IT_PU_SOUND_1190"] = "Metal grande",
	["IT_PU_SOUND_1191"] = "Metal pequeño",
	["IT_PU_SOUND_1192"] = "Papel",
	["IT_PU_SOUND_1193"] = "Anillo",
	["IT_PU_SOUND_1194"] = "Roca",
	["IT_PU_SOUND_1195"] = "Cadena pequeña",
	["IT_PU_SOUND_1196"] = "Varita",
	["IT_PU_SOUND_1197"] = "Líquido",
	["IT_PU_SOUND_1198"] = "Palo pequeño",
	["IT_PU_SOUND_1199"] = "Palo grande",
	["IT_PU_SOUND_1221"] = "Gemas",
	["IT_STACK"] = "Apilable",
	["IT_TT_VALUE"] = "Valor del objeto",
	["IT_TT_VALUE_FORMAT"] = "Valor del objeto (en %s)",
	["IT_TT_WEIGHT"] = "Peso del objeto",
	["IT_TT_WEIGHT_FORMAT"] = "Peso del objeto (en gramos)",
	["IT_USE"] = "Usable",
	["IT_WEARABLE"] = "Usable",
	["ITEM_ID"] = "ID del objeto",
	["NPC_SAYS"] = "dice",
	["NPC_WHISPERS"] = "susurros",
	["NPC_YELLS"] = "grita",
	["OP_UNIT_NPC"] = "PNJ",
	["OP_UNIT_PLAYER"] = "Jugador",
	["OP_UNIT_TARGET"] = "Objetivo",
	["QE_CAMPAIGN"] = "Campaña",
	["QE_CAMPAIGN_RESET"] = "Reiniciar campaña",
	["QE_CAMPAIGNS"] = "Campañas",
	["QE_NAME"] = "Nombre de misión",
	["QE_NAME_NEW"] = "Nueva misión",
	["QE_PROGRESS"] = "Progresión",
	["QE_QUEST"] = "Misión",
	["QE_QUESTS"] = "Misiones",
	["QUEST_ID"] = "ID de misión",
	["ROOT_CREATED"] = "Creado por %s en %s",
	["ROOT_CREATED_BY"] = "Creado por",
	["ROOT_CREATED_ON"] = "Creado el",
	["ROOT_VERSION"] = "Versión",
	["SEC_HIGH"] = "Alto",
	["SEC_LEVEL"] = "Nivel de seguridad",
	["SEC_LEVEL_DETAILS"] = "Detalles de seguridad",
	["SEC_LEVEL_DETAILS_ACCEPTED"] = "Aceptado",
	["SEC_LEVEL_DETAILS_ALL"] = "Cambiar seguridad para todos los objetos",
	["SEC_LEVEL_DETAILS_ALL_TT"] = "Aceptar la ejecución de este efecto para todos los objetos, ahora y en el futuro.",
	["SEC_LEVEL_DETAILS_BLOCKED"] = "Bloqueado",
	["SEC_LEVEL_DETAILS_FROM"] = "Aceptar siempre al recibir de %s.",
	["SEC_LEVEL_DETAILS_THIS"] = "Cambiar seguridad para estos objetos",
	["SEC_LEVEL_DETAILS_THIS_TT"] = "Aceptar la ejecución de este efecto sólo para este objeto.",
	["SEC_LOW"] = "Bajo",
	["SEC_MEDIUM"] = "Medio",
	["SEC_REASON_DISMOUNT"] = "Desmontar",
	["SEC_REASON_SOUND"] = "Reproducir un sonido",
	["SEC_TT_COMBO"] = "Alt + Clic derecho:|cffff9900 Configurar seguridad.",
	["SET_TT_DETAILS_1"] = "Mantén pulsado Alt para mostrar más",
	["SET_TT_DETAILS_2"] = "%s aviso(s)",
	["SPECIFIC"] = "Objeto específico",
	["SPECIFIC_MODE"] = "Modo",
	["TB_TOOLS_TT"] = "Crea tus propios items y misiones.",
	["TU_AC_2"] = "Evaluación de acciones",
	["TU_CS_5"] = "Previsualizar",
	["TU_DB_1_TEXT"] = [=[|cff00ff00Bienvenido al tutorial de la base de datos.|r

Esta es la base de datos, donde se almacenan todos los objetos.

Un objeto contiene toda la información de un item, documento, campaña/misión/paso o escena.]=],
	["TU_DB_2"] = "Tipos de base de datos",
	["TU_DB_6"] = "Crear objeto",
	["TU_DB_7_TEXT"] = "Cada línea representa un objeto. Puedes hacer clic para editarlo o clic derecho para realizar varias acciones.",
	["TU_IT_1_TEXT"] = [=[|cff00ff00Bienvenido al tutorial de creación de objetos.|r

Un objeto es aquel que puedes almacenar en el inventario de tu personaje (o dejarlo en el suelo).

Aquí, en la ventana principal, puedes definir todos los atributos básicos para tu objeto.]=],
	["TU_IT_3_TEXT"] = [=[Puedes escribir notas que te ayuden a recordar qué quieres hacer con el objeto.

Estas notas pueden ayudar también a otros que quieran crear un objeto basado en el tuyo.]=],
	["TU_TITLE"] = "Tutorial",
	["TU_WO_4"] = "Añadir un efecto",
	["TU_WO_4_TEXT"] = [=[Efectos como "reproducir un sonido", "mostrar un texto" o "iniciar una escena".

Hay MUCHOS efectos, ¡todos explicados en su propia herramienta!]=],
	["TU_WO_5"] = "Añadir una condición",
	["TU_WO_6"] = "Añadir retraso",
	["TYPE"] = "Tipo",
	["TYPE_CAMPAIGN"] = "Campaña",
	["TYPE_DOCUMENT"] = "Documento",
	["TYPE_ITEM"] = "Objeto",
	["TYPE_ITEMS"] = "Objeto(s)",
	["TYPE_LOOT"] = "Botín",
	["TYPE_QUEST"] = "Misión",
	["UNIT_POTATOES"] = "patatas",
	["WO_CONDITION"] = "Condición",
	["WO_CONTEXT"] = "Contexto",
	["WO_DELAY"] = "Retraso",
	["WO_DELAY_CAST_TEXT"] = "Texto de casteo",
	["WO_DELAY_CAST_TEXT_TT"] = "El texto situado en la barra de casteo.",
	["WO_DELAY_DURATION"] = "Duración",
	["WO_DELAY_DURATION_TT"] = "La duración del retraso, en segundos.",
	["WO_DELAY_INTERRUPT"] = "Interrupción",
	["WO_DELAY_INTERRUPT_1"] = "Sin interrupción",
	["WO_DELAY_INTERRUPT_2"] = "Interrumpir en movimiento",
	["WO_DELAY_SECONDS"] = "segundo(s)",
	["WO_DELAY_TYPE"] = "Tipo de retraso",
	["WO_EFFECT"] = "Efecto",
	["WO_EFFECT_NO_EDITOR"] = "No se puede configurar este efecto.",
	["WO_EFFECT_SELECT"] = "Selecciona un efecto",
	["WO_EFFECT_TT"] = [=[Reproduce un efecto.
Ya sea sonidos, texto, etc.]=],
	["WO_ELEMENT"] = "Edición del elemento",
	["WO_ELEMENT_COPY"] = "Copiar el contenido del elemento",
	["WO_ELEMENT_EDIT"] = "Haz clic para editar un elemento",
	["WO_ELEMENT_PASTE"] = "Pega el contenido del elemento",
	["WO_ELEMENT_TYPE"] = "Selecciona el tipo de elemento",
	["WO_EVENT_EX_ADD"] = "Añadir enlace de evento",
	["WO_EVENT_EX_CONDI"] = "Editor de condición de enlace de evento",
	["WO_EVENT_EX_EDITOR"] = "Editor de enlace de evento",
	["WO_EVENT_EX_LINK"] = "Enlace de evento de juego",
	["WO_EVENT_EX_LINKS"] = "Enlaces de evento de juego",
	["WO_EVENT_EX_NO"] = "Sin enlace de evento",
	["WO_EVENT_ID"] = "ID de evento",
	["WO_EVENT_ID_TT"] = [=[La ID del evento.

Puedes ver la lista completa de eventos en páginas web como wowwiki o wowpedia.

He aquí un ejemplo, PLAYER_REGEN_DISABLED se activa cuando entras en combate.]=],
	["WO_EXPERT"] = "Modo experto",
	["WO_EXPERT_DONE"] = "Cambiado %s a modo experto. ¡Desata tu creatividad!",
	["WO_SECURITY"] = "Nivel de seguridad",
	["WO_SECURITY_HIGH"] = "Alto",
	["WO_SECURITY_LOW"] = "Bajo",
	["WO_SECURITY_NORMAL"] = "Medio"
}

Localization:GetLocale("esES"):AddTexts(localeContent);

--[[ Removed while CurseForge is malfunctioning
localeContent = 
}

Localization:GetLocale("esMX"):AddTexts(localeContent);
]]

--[[ Removed while CurseForge is malfunctioning
localeContent = 
}

Localization:GetLocale("itIT"):AddTexts(localeContent);
]]

localeContent = {
	["ALL"] = "모든",
	["CA_ACTIONS"] = "행위",
	["CONF_UNIT"] = "단위",
	["DB"] = "데이터 베이스"
}

Localization:GetLocale("koKR"):AddTexts(localeContent);

--[[ Removed while CurseForge is malfunctioning
localeContent = 
}

Localization:GetLocale("ptBR"):AddTexts(localeContent);
]]

localeContent = {
	["ALL"] = "Все",
	["BINDING_NAME_TRP3_INVENTORY"] = "Открыть инвентарь персонажа",
	["BINDING_NAME_TRP3_MAIN_CONTAINER"] = "Открыть главную сумку",
	["BINDING_NAME_TRP3_QUEST_ACTION"] = "Действие квеста: взаимодействовать",
	["BINDING_NAME_TRP3_QUEST_LISTEN"] = "Действие квеста: слушать",
	["BINDING_NAME_TRP3_QUEST_LOOK"] = "Действие квеста: исследовать",
	["BINDING_NAME_TRP3_QUEST_TALK"] = "Действие квеста: говорить",
	["BINDING_NAME_TRP3_QUESTLOG"] = "Открыть журнал квестов TRP3",
	["BINDING_NAME_TRP3_SEARCH_FOR_ITEMS"] = "Поиск предметов",
	["CA_ACTION_CONDI"] = "Редактор условий действия",
	["CA_ACTION_REMOVE"] = "Удалить это действие?",
	["CA_ACTIONS"] = "Действия",
	["CA_ACTIONS_ADD"] = "Добавить действие",
	["CA_ACTIONS_COND"] = "Изменить условие",
	["CA_ACTIONS_COND_OFF"] = "Это действие не обусловлено.",
	["CA_ACTIONS_COND_ON"] = "Это действие обусловлено.",
	["CA_ACTIONS_COND_REMOVE"] = "Удалить условиe",
	["CA_ACTIONS_EDITOR"] = "Редактор действий",
	["CA_ACTIONS_NO"] = "Нет действий",
	["CA_ACTIONS_SELECT"] = "Выберите тип действия",
	["CA_DESCRIPTION"] = "Сводка по кампании",
	["CA_DESCRIPTION_TT"] = "Эта краткая сводка будет видна на странице кампании в журнале заданий.",
	["CA_ICON"] = "Значок кампании",
	["CA_ICON_TT"] = "Выберите значок кампании",
	["CA_IMAGE"] = "Портрет кампании",
	["CA_IMAGE_TT"] = "Выберите значок кампании",
	["CA_LINKS_ON_START"] = "На старте кампании",
	["CA_LINKS_ON_START_TT"] = [=[Срабатывает |cff00ff00один|r раз, когда игрок начал кампанию, так что активация кампании в первый раз, или сбросить его в журнале квестов.

|cff00ff00Это хорошее место, чтобы активировать ваш первый квест.]=],
	["CA_NAME"] = "Название кампании",
	["CA_NAME_NEW"] = "Новая кампания",
	["CA_NAME_TT"] = "Это название Вашей кампании. Он появляется в журнале квестов.",
	["CA_NO_NPC"] = "Нет кастомных НПС",
	["CA_NPC"] = "Список НПС в кампании",
	["CA_NPC_ADD"] = "Добавить кастомизированного НПС",
	["CA_NPC_AS"] = "Дубликат",
	["CA_NPC_EDITOR"] = "НПС редактор",
	["CA_NPC_EDITOR_DESC"] = "Описание НПС",
	["CA_NPC_EDITOR_NAME"] = "Имя НПС",
	["CA_NPC_ID"] = "ID НПС",
	["CA_NPC_ID_TT"] = [=[Пожалуйста, введите ID НПС, чтобы настроить.

|cff00ff00Чтобы получить ID НПС, введите эту команду в чате:/trp3 getID]=],
	["CA_NPC_REMOVE"] = "Удалить изменения для этого НИП?"
}

Localization:GetLocale("ruRU"):AddTexts(localeContent);


localeContent = {
	["ALL"] = "全部",
	["BINDING_NAME_TRP3_INVENTORY"] = "打开角色目录",
	["BINDING_NAME_TRP3_MAIN_CONTAINER"] = "打开主容器",
	["CA_ACTION_CONDI"] = "动作条件编辑",
	["CA_ACTION_REMOVE"] = "删除这个动作?",
	["CA_ACTIONS"] = "动作",
	["CA_ACTIONS_ADD"] = "添加动作",
	["CA_ACTIONS_EDITOR"] = "动作编辑",
	["CA_ACTIONS_NO"] = "没有动作",
	["CA_DESCRIPTION"] = "剧本概要",
	["CA_DESCRIPTION_TT"] = "在这里写一些简明扼要的内容, 内容将在任务日志中显示.",
	["CA_ICON"] = "剧本图标",
	["CA_ICON_TT"] = "选择剧本图标",
	["CA_IMAGE"] = "剧本人物",
	["CA_IMAGE_TT"] = "选择剧本人物",
	["CA_LINKS_ON_START"] = "触发剧本",
	["CA_LINKS_ON_START_TT"] = [=[触发 |cff00ff00once|r 当玩家第一次激活你的剧本，或者在任务日志中重置剧本时触发

|cff00ff00这是激活你第一个任务的地方.]=],
	["CA_NAME"] = "剧本名字",
	["CA_NAME_NEW"] = "新的剧本",
	["CA_NAME_TT"] = "这是你剧本的名字。它出现在任务日志中.",
	["CA_NO_NPC"] = "没有自定义 NPC",
	["CA_NPC"] = "剧本 NPC 列表",
	["CA_NPC_ADD"] = "添加自定义 NPC",
	["CA_NPC_AS"] = "复制品",
	["CA_NPC_EDITOR"] = "NPC 编辑",
	["CA_NPC_EDITOR_NAME"] = "NPC 名称",
	["CA_NPC_ID"] = "NPC ID",
	["CA_NPC_NAME"] = "默认 NPC 名",
	["CA_NPC_UNIT"] = "自定义 NPC",
	["CA_QE_ID"] = "变更任务 ID",
	["CA_QUEST_ADD"] = "添加任务",
	["CA_QUEST_EXIST"] = "我们已经对 ID %s进行了搜索.",
	["CA_QUEST_NO"] = "没有任务",
	["CA_QUEST_REMOVE"] = "删除这个任务?",
	["CONF_MAIN"] = "扩展设置",
	["CONF_MUSIC_ACTIVE"] = "播放本地音乐",
	["CONF_MUSIC_METHOD"] = "本地音乐回放模式",
	["CONF_SOUNDS"] = "本地声音 / 音乐",
	["CONF_SOUNDS_ACTIVE"] = "播放本地声音",
	["CONF_SOUNDS_MAXRANGE"] = "播放音量",
	["CONF_SOUNDS_METHOD"] = "本地声音回放模式",
	["CONF_SOUNDS_METHOD_1"] = "自动播放",
	["CONF_SOUNDS_METHOD_2"] = "播放前询问",
	["CONF_UNIT"] = "单位",
	["CONF_UNIT_WEIGHT"] = "重量单位",
	["CONF_UNIT_WEIGHT_1"] = "g/克",
	["CONF_UNIT_WEIGHT_2"] = "Pounds/磅",
	["DB"] = "数据库",
	["DB_ACTIONS"] = "动作",
	["DB_ADD_ITEM"] = "添加物品到主背包",
	["DB_BACKERS"] = "后台数据库 (%s)",
	["DB_BACKERS_LIST"] = "关于作者",
	["DB_BROWSER"] = "浏览器",
	["DB_CREATE_CAMPAIGN"] = "创建剧本",
	["DB_CREATE_CAMPAIGN_TT"] = "开始创建剧本",
	["DB_CREATE_ITEM"] = "创建物品",
	["DB_CREATE_ITEM_TEMPLATES"] = "或者选择一个模板",
	["DB_CREATE_ITEM_TEMPLATES_BLANK"] = "空白项",
	["DB_CREATE_ITEM_TEMPLATES_BLANK_TT"] = [=[一个空白的模板.
对于那些喜欢从头开始的人来说.]=],
	["DB_CREATE_ITEM_TEMPLATES_CONTAINER"] = "容器包包",
	["DB_CREATE_ITEM_TEMPLATES_CONTAINER_TT"] = [=[一个容器模板.
容器可以存放其他物品.]=],
	["DB_CREATE_ITEM_TEMPLATES_DOCUMENT"] = "文档项目",
	["DB_CREATE_ITEM_TEMPLATES_DOCUMENT_TT"] = [=[一个带有内部文档对象的项目模板.
有助于快速创建一本书或一卷书.]=],
	["DB_CREATE_ITEM_TEMPLATES_FROM"] = "从 ...创建",
	["DB_CREATE_ITEM_TEMPLATES_FROM_TT"] = "创建一个现有项目的副本.",
	["DB_CREATE_ITEM_TEMPLATES_QUICK"] = "快速创建物品",
	["DB_CREATE_ITEM_TEMPLATES_QUICK_TT"] = [=[快速创建一个没有任何效果的简单物品.
然后在你的主包包中添加这个物品.]=],
	["DB_CREATE_ITEM_TT"] = "为新物品选择一个模板",
	["DB_DELETE_TT"] = "删除该对象及其所有子对象.",
	["DB_EXPERT_TT"] = "将该对象转换为专家模式，允许更复杂的自定义.",
	["DB_FILTERS"] = "搜索过滤",
	["DB_FILTERS_CLEAR"] = "清除",
	["DB_FILTERS_NAME"] = "对象名称",
	["DB_FILTERS_OWNER"] = "创建者",
	["DB_FULL"] = "全部数据库 (%s)",
	["DB_FULL_EXPORT"] = "刷新全部（会RL重置）",
	["DB_HARD_SAVE"] = "本地保存",
	["DB_LIST"] = "创建列表",
	["DB_LOCALE"] = "目标文件",
	["DB_MY"] = "我的数据库 (%s)",
	["DB_OTHERS"] = "RP玩家的数据库 (%s)",
	["DB_RESULTS"] = "搜索结果",
	["DB_SECURITY_TT"] = "显示该对象的所有安全参数. From there you can allow or prevent certain undesirable effects.",
	["DB_TO_EXPERT"] = "专家模式",
	["DB_WARNING"] = [=[
|cffff0000!!! 警告 !!!

|cffff9900不要忘记保存之前的内容!]=],
	["DEBUG_QUEST_STEP"] = "转到任务步骤.",
	["DI_CHOICE"] = "选项",
	["DI_CHOICE_CONDI"] = "选择条件",
	["DI_HISTORY"] = "过场动画历史",
	["DI_NAME"] = "改变说话人的名字",
	["DI_NEXT"] = "下一步索引",
	["DI_STEP"] = "剧本步骤",
	["DI_STEP_ADD"] = "添加步骤",
	["DI_STEP_EDIT"] = "剧本步骤编辑",
	["DI_STEP_TEXT"] = "步骤文本",
	["DI_STEPS"] = "剧本步骤",
	["DISCLAIMER"] = [=[{h1:c}请一定要阅读{/h1}

创造物品和任务非常消耗精力的一件事，所以存储丢失是非常悲剧的。

这里可以存储所有你在wow里创造的东西，当然它是有限制的：
*所有附加数据都有一个未知的数据大小限制（取决于运行32或64位客户端，还有其他杂七杂八）
*达到或者超过这个限制会删除所有数据
*杀死进程，强制关闭客户端（alt+f4）会损坏已经保存的附加数据
*即使你正确退出游戏，总有一个机会，游戏不能成功保存附加数据并造成破坏
*顺便说下这玩意和MyRolePlay（另一个人物卡RP插件）冲突 
*顺便说下存储机制是一个账号下所有角色存一个地方，所以分身太多可能容易崩溃，目前不清楚wow lua memory存储限制

正因如此，我们强烈建议你备份保存所有数据。
数据保存位置参见:
{link*https://totalrp3.info/documentation/how_to/saved_variables*我信息存在哪里?}
{h2:c}直接备份“WTF\Account\你的角色名\SavedVariables” 下所有内容就行了{/h2}
主要是totalRP3.lua 配置存档/totalrp3_data.lua数据存档/totalrp3_storyline.lua

你可以在这里找到关于同步您的数据到云服务教程:
{link*https://totalrp3.info/documentation/how_to/backup_and_sync_profiles*如何云同步数据？}
需要一些满足版本迭代的云同步如Google Driver你们上不去我就不管了 O(∩_∩)O~

反正你数据没了我们不能恢复。
特此 感谢︿(￣︶￣)︿。

{p:r} TRP3 小组{/p}]=],
	["DISCLAIMER_OK"] = "鲜血为引灵魂为代价我签订这份契约。",
	["DO_PAGE_FIRST"] = "第一页",
	["DO_PAGE_LAST"] = "最后一页",
	["DO_PAGE_NEXT"] = "下一页",
	["DO_PAGE_PREVIOUS"] = "上一页",
	["DO_PARAMS_GLOBAL"] = "默认参数",
	["DR_DELETED"] = "损坏的: %s x%d",
	["DR_DROPED"] = "扔掉在地上: %s x%d",
	["DR_NOTHING"] = "在这个地区没有发现任何物品.",
	["DR_POPUP"] = "搜这里",
	["DR_POPUP_ASK"] = [=[Total RP 3
 
选择如何处理该物品:
%s]=],
	["DR_POPUP_REMOVE"] = "毁掉",
	["DR_POPUP_REMOVE_TEXT"] = "要销毁吗?",
	["DR_RESULTS"] = "找到 %s 物品",
	["DR_SEARCH_BUTTON"] = "搜索 |cff00ff00我的|r 物品",
	["DR_SEARCH_BUTTON_TT"] = "搜索附近15码内你的物品.",
	["DR_STASHED"] = "藏了: %s x%d",
	["DR_STASHES"] = "藏匿",
	["DR_STASHES_CREATE"] = "创建一个藏宝箱在这里",
	["DR_STASHES_CREATE_TT"] = "在你站的地方创建一个藏宝箱.",
	["DR_STASHES_DROP"] = "你不能把物品丢在别人的藏物里.",
	["DR_STASHES_EDIT"] = "编辑宝藏",
	["DR_STASHES_ERROR_OUT_SYNC"] = "宝藏同步失败，重试.",
	["DR_STASHES_ERROR_SYNC"] = "宝藏没有同步.",
	["DR_STASHES_FOUND"] = "发现宝藏: %s",
	["DR_STASHES_FULL"] = "这地方藏满了.",
	["DR_STASHES_HIDE"] = "躲避搜索",
	["DR_STASHES_HIDE_TT"] = [=[这些宝箱不会出现在其他玩家的地图扫描上.

请注意，如果他们知道它在哪里，他们将始终能够访问它。]=],
	["DR_STASHES_MAX"] = "最多 50 个字符",
	["DR_STASHES_NAME"] = "宝藏",
	["DR_STASHES_NOTHING"] = "这地方没发现宝藏.",
	["DR_STASHES_REMOVE"] = "删除宝藏",
	["DR_STASHES_REMOVE_PP"] = [=[删除宝藏?
|cffff9900All 存放在里面的东西会丢失!]=],
	["DR_STASHES_REMOVED"] = "宝藏被搬走了.",
	["DR_STASHES_RESYNC"] = "再同步",
	["DR_STASHES_SCAN"] = "搜索玩家的宝藏",
	["DR_STASHES_SCAN_MY"] = "搜索我的宝藏",
	["DR_STASHES_SEARCH"] = "搜索 |cff00ff00玩家|r 宝藏",
	["DR_STASHES_SEARCH_TT"] = [=[搜索15码内其他玩家的宝藏.

搜索需要3秒，别动!]=],
	["DR_STASHES_SYNC"] = "正在同步...",
	["DR_STASHES_TOO_FAR"] = "你离宝藏太远了.",
	["DR_STASHES_WITHIN"] = "|cff00ff00Your|r 15码内有宝藏",
	["DR_SYSTEM"] = "寻宝系统",
	["DR_SYSTEM_TT"] = [=[ 开始寻宝 /创建搜索 /查看自己藏匿点 .

这系统不能在地下城/竞技场/战场使用.]=],
	["EDITOR_CONFIRM"] = "确认",
	["EDITOR_ICON_SELECT"] = "选择一个图标.",
	["EDITOR_MAIN"] = "主要",
	["EDITOR_MORE"] = "更多",
	["EDITOR_NOTES"] = "说明（不显示）",
	["EDITOR_PREVIEW"] = "预览",
	["EFFECT_CAT_CAMPAIGN"] = "剧本和任务",
	["EFFECT_ITEM_SOURCE"] = "搜索",
	["EFFECT_ITEM_SOURCE_1"] = "所有目录",
	["EFFECT_ITEM_SOURCE_2"] = "所有容器",
	["EFFECT_ITEM_SOURCE_3"] = "所有物品",
	["EFFECT_SOURCE_CAMPAIGN"] = "剧本",
	["EFFECT_SOURCE_OBJECT"] = "目标",
	["EFFECT_SOURCE_WORKFLOW"] = "工作流",
	["EFFECT_TEXT_TEXT_DEFAULT"] = [=[Hi~ o(*￣▽￣*)ブ.
你好]=],
	["EFFECT_VAR"] = "变量名",
	["EFFECT_VAR_OPERAND"] = "变量的动态值",
	["EX_SOUND_HISTORY"] = "声音历史",
	["IN_INNER"] = "内部对象",
	["IN_INNER_ADD_COPY"] = "添加现有对象的副本",
	["IN_INNER_ADD_NEW"] = "创建新的对象",
	["IN_INNER_LIST"] = "内部对象清单",
	["IN_INNER_S"] = "内部对象 ",
	["INV_PAGE_CAMERA_CONFIG"] = [=[摄像机参数:
   循环: %.2f]=],
	["INV_PAGE_CHARACTER_INSPECTION"] = "角色检查",
	["INV_PAGE_CHARACTER_INV"] = "背包",
	["INV_PAGE_INV_OPEN"] = "打开背包",
	["INV_PAGE_ITEM_LOCATION"] = "角色的物品所在地",
	["INV_PAGE_LOOT_ALL"] = "所有战利品",
	["INV_PAGE_MARKER"] = [=[标记的位置:
   x: %.2f
   y: %.2f]=],
	["INV_PAGE_PLAYER_INV"] = "%s的背包",
	["INV_PAGE_QUICK_SLOT"] = " 行囊袋",
	["INV_PAGE_QUICK_SLOT_TT"] = "将包包拖到这个槽作为主容器.",
	["INV_PAGE_SEQUENCE"] = "序列 ID",
	["INV_PAGE_TOTAL_VALUE"] = "物品总价值",
	["INV_PAGE_WAIT"] = "等待响应",
	["IT_CAST"] = "扔掉",
	["IT_CO_DURABILITY"] = "耐久（0表示无耐久）",
	["IT_CO_MAX"] = "最大重量 (g/克)",
	["IT_CO_SIZE"] = "容器大小",
	["IT_CON"] = "容器",
	["IT_CON_CAN_INNER"] = "不能把这个背包放进自己包包里!",
	["IT_CON_ERROR_TRADE"] = "你不能删除这个背包，如果它不是空的.",
	["IT_CON_ERROR_TYPE"] = "这个背包不能容纳这件的物品.",
	["IT_CON_OPEN"] = "打开/关闭背包",
	["IT_CON_TT"] = "容器 (%d/%d 已用)",
	["IT_CON_TT_MISSING_CLASS"] = "物品 ID 丢失",
	["IT_CRAFTED"] = "精心制作的",
	["IT_DISPLAY_ATT"] = "显示属性",
	["IT_DR_SOUND"] = "丢弃音效",
	["IT_EX_DOWNLOAD"] = "下载",
	["IT_EX_DOWNLOADING"] = "下载: %0.1f %%",
	["IT_EX_EMPTY_DRAG"] = "你可以在这里拖拽物品.",
	["IT_FIELD_NAME"] = "物品名称",
	["IT_FIELD_QUALITY"] = "物品质量",
	["IT_GAMEPLAY_ATT"] = "游戏属性",
	["IT_INV_ERROR_CANT_DESTROY_LOOT"] = "不能销毁这个战利品.",
	["IT_INV_ERROR_CANT_HERE"] = "你不能把东西放这.",
	["IT_INV_ERROR_FULL"] = "%s 满了.",
	["IT_INV_ERROR_MAX"] = "你不能携带更多 %s.",
	["IT_INV_GOT"] = "Received: %s x%d",
	["IT_INV_SCAN_MY_ITEMS"] = "搜索我的物品",
	["IT_INV_SHOW_ALL"] = "显示所有装备",
	["IT_INV_SHOW_CONTENT"] = [=[|cffffff00左击:|r 打开主背包 (如果存在)
|cffffff00右击:|r 打开装备栏]=],
	["IT_NEW_NAME"] = "新的物品",
	["IT_NEW_NAME_CO"] = "新的容器",
	["IT_NO_ADD"] = "防止手动添加",
	["IT_ON_USE_TT"] = [=[当玩家使用这个项目时，这个工作流将被触发。

|cffff9900Note:|r 如果您想要为这个项目提供更多的工作流程，您可以通过数据库视图将它转换为专家模式 (b通过右键单击并选择 |cff00ff00专家模式|r).]=],
	["IT_PU_SOUND"] = "拾取音效",
	["IT_PU_SOUND_1183"] = "包",
	["IT_PU_SOUND_1184"] = "书",
	["IT_PU_SOUND_1185"] = "衣服",
	["IT_PU_SOUND_1186"] = "食物",
	["IT_PU_SOUND_1187"] = "草药",
	["IT_PU_SOUND_1188"] = "锁链",
	["IT_PU_SOUND_1189"] = "肉",
	["IT_PU_SOUND_1190"] = "金属 大",
	["IT_PU_SOUND_1191"] = "金属 小",
	["IT_PU_SOUND_1192"] = "纸",
	["IT_PU_SOUND_1193"] = "戒指",
	["IT_PU_SOUND_1194"] = "石头",
	["IT_PU_SOUND_1195"] = "锁链 小",
	["IT_PU_SOUND_1196"] = "魔杖",
	["IT_PU_SOUND_1197"] = "液体",
	["IT_PU_SOUND_1198"] = "木 小",
	["IT_PU_SOUND_1199"] = "木 大",
	["IT_PU_SOUND_1221"] = "宝石",
	["IT_QUEST"] = "任务标记（！）",
	["IT_QUICK_EDITOR"] = "新的物品编辑",
	["IT_QUICK_EDITOR_EDIT"] = "物品快速编辑",
	["IT_STACK"] = "堆叠",
	["IT_TT_DESCRIPTION"] = "提示描述",
	["IT_TT_LEFT"] = "物品描述（左边）",
	["IT_TT_REAGENT"] = "试剂标记（看上去像试剂而已）",
	["IT_TT_RIGHT"] = "物品描述（右边）",
	["IT_TT_VALUE"] = "物品价值",
	["IT_TT_VALUE_FORMAT"] = "物品价值 (钱 %s)",
	["IT_TT_WEIGHT"] = "物品重量",
	["IT_TT_WEIGHT_FORMAT"] = "物品重量 (克)",
	["IT_USE"] = "可用的",
	["IT_USE_TEXT"] = "使用方法",
	["IT_WEARABLE"] = "可穿戴的",
	["ITEM_ID"] = "物品 ID",
	["LOOT"] = "战利品",
	["LOOT_CONTAINER"] = "战利品箱子",
	["MODE_EXPERT"] = "超严谨RP",
	["MODE_NORMAL"] = "正常RP",
	["MODE_QUICK"] = "快速RP",
	["NPC_EMOTES"] = "表情",
	["NPC_SAYS"] = "说",
	["NPC_WHISPERS"] = "悄悄说",
	["NPC_YELLS"] = "喊",
	["QE_ACTION"] = "任务动作",
	["QE_ACTIONS_TYPE_INTERRACT"] = "交互",
	["QE_ACTIONS_TYPE_LISTEN"] = "听",
	["QE_ACTIONS_TYPE_LOOK"] = "检查",
	["QE_ACTIONS_TYPE_TALK"] = "说",
	["QE_AUTO_REVEAL"] = "自动显示",
	["QE_BUTTON"] = "打开任务日志",
	["QE_CAMPAIGN"] = "剧本",
	["QE_CAMPAIGN_CURRENT"] = "现在的剧本.",
	["QE_CAMPAIGN_CURRENT_NO"] = "没有合适的剧本.",
	["QE_CAMPAIGN_EMPTY"] = "这个剧本没有任务.",
	["QE_CAMPAIGN_FULL"] = "完成",
	["QE_CAMPAIGN_LIST"] = "%s 可以接的剧本",
	["QE_CAMPAIGN_PAUSE"] = "暂停现在的剧本.",
	["QE_CAMPAIGN_RESET"] = "重置剧本",
	["QE_CAMPAIGN_RESUME"] = "恢复暂停 |cff00ff00[%s]|r.",
	["QE_CAMPAIGN_START"] = "开始剧本 |cff00ff00[%s]|r.",
	["QE_CAMPAIGN_START_BUTTON"] = "开始或重新开始剧本",
	["QE_CAMPAIGN_UNSTARTED"] = [=[你还不能开始这个剧本.
Click 顶部按钮 "Start" 按钮来开始.]=],
	["QE_CAMPAIGNS"] = "所有剧本",
	["QE_COMPLETED"] = "完成",
	["QE_FAILED"] = "失败",
	["QE_NAME"] = "任务名字",
	["QE_NAME_NEW"] = "新的任务",
	["QE_NEW"] = "新的任务发布",
	["QE_NOACTION_ACTION"] = "这里没有任何事情.",
	["QE_NOACTION_LISTEN"] = "你没有听到任何特殊的声音.",
	["QE_NOACTION_LOOK"] = "你没有看到任何特殊的地方.",
	["QE_NOACTION_TALK"] = "无话可说.",
	["QE_NPC"] = "剧本 NPC",
	["QE_OBJ"] = "任务目标",
	["QE_OBJ_ADD"] = "添加任务目标",
	["QE_OBJ_AUTO"] = "自动显示",
	["QE_OBJ_ID"] = "目标 ID",
	["QE_OBJ_NO"] = "没有任务目标",
	["QE_OBJ_REMOVE"] = "删除这个任务目标?",
	["QE_OBJ_SINGULAR"] = "任务目标",
	["QE_OBJ_TEXT"] = "目标文本",
	["QE_OVERVIEW"] = "任务综述",
	["QE_PROGRESS"] = "进度",
	["QE_QUEST"] = "寻找",
	["QE_QUEST_LIST"] = "任务需要物品",
	["QE_QUEST_OBJ_AND_HIST"] = "目标和历史",
	["QE_QUEST_OBJ_FINISHED"] = "|cffffff00任务完成: |cff00ff00%s",
	["QE_QUEST_OBJ_REVEALED"] = "|cffffff00新目标 : |cff00ff00%s",
	["QE_QUEST_OBJ_UPDATED"] = "|cffffff00任务更新: |cff00ff00%s",
	["QE_QUEST_START"] = "开始任务 |cff00ff00[%s]|r.",
	["QE_QUEST_TT_STEP"] = [=[|cffffff00当前:|r
"%s"]=],
	["QE_QUESTS"] = "任务道具",
	["QE_QUESTS_HELP"] = [=[你可以在这里增加你的任务. 当他开始你的剧本时，任务不会自动添加到玩家的任务日志中.你必须通过工作流程来完成任务.
|cffff9900任务按照ID在任务日志中进行排序，而不是通过名称或显示顺序.]=],
	["QE_ST_AUTO_REVEAL"] = "第一步",
	["QE_ST_END"] = "最后一步",
	["QE_ST_POST"] = "任务历史记录",
	["QE_ST_PRE"] = "任务内容",
	["QE_STEP"] = "任务步骤",
	["QE_STEP_ADD"] = "添加任务步骤",
	["QE_STEP_LIST"] = "这个任务的步骤",
	["QE_STEP_LIST_CURRENT"] = "可用的任务",
	["QE_STEP_LIST_FINISHED"] = "完成的任务",
	["QE_STEP_MISSING"] = "缺少下一步任务的信息.",
	["QE_STEP_NAME_NEW"] = "新的任务步骤",
	["QE_STEP_NO"] = "没有任务步骤",
	["QE_STEP_REMOVE"] = "删除这一步骤?",
	["QE_STEPS"] = "任务步骤",
	["QUEST_ID"] = "任务 ID",
	["ROOT_CREATED"] = "创建者 %s 在 %s",
	["ROOT_CREATED_BY"] = "创建者",
	["ROOT_CREATED_ON"] = "创建在",
	["ROOT_GEN_ID"] = "生产 ID",
	["ROOT_ID"] = "对象ID",
	["ROOT_SAVED"] = "最后修改者 %s 在 %s",
	["ROOT_TITLE"] = "根对象",
	["ROOT_VERSION"] = "版本",
	["SPECIFIC"] = "特殊目标",
	["SPECIFIC_INNER_ID"] = "内部 ID",
	["SPECIFIC_PATH"] = "根路径",
	["TB_TOOLS"] = "扩展对象数据库",
	["TB_TOOLS_TT"] = "创建你自己的物品和任务.",
	["TU_DB_5"] = "根对象",
	["TU_DB_6"] = "创建一个物品",
	["TU_IT_3"] = "免费文本",
	["TU_IT_4"] = "游戏属性",
	["TYPE"] = "类型",
	["TYPE_CAMPAIGN"] = "剧本",
	["TYPE_DIALOG"] = "剧情",
	["TYPE_DOCUMENT"] = "文件",
	["TYPE_ITEM"] = "物品",
	["TYPE_ITEMS"] = "物品(s)",
	["TYPE_LOOT"] = "战利品",
	["TYPE_QUEST"] = "任务",
	["TYPE_QUEST_STEP"] = "任务步骤",
	["WO_ACTIONS_LINKS"] = "动作环节",
	["WO_ADD"] = "创建工作流",
	["WO_ADD_ID_NO_AVAILABLE"] = "T工作流 ID 无效.",
	["WO_CONTEXT"] = "环境",
	["WO_CONTEXT_TT"] = "工作流上下文确定可以在工作流中使用哪些效果.",
	["WO_ELEMENT_ADD"] = "将元素添加到工作流",
	["WO_EVENT_EX_LINKS"] = "游戏剧本环节",
	["WO_EVENT_EX_LINKS_TT"] = [=[在这里你可以将你的工作流程与游戏事件联系起来.
每个环节都是有条件的.]=],
	["WO_EVENT_LINKS"] = "对象事件环节",
	["WO_EXECUTION"] = "执行服务",
	["WO_LINKS"] = "事件环节",
	["WO_LINKS_NO_LINKS"] = "没有环节",
	["WO_LINKS_TRIGGERS"] = "在这里，您可以将工作流程与该对象的具体事件联系起来.",
	["WO_NO"] = "没有工作流",
	["WO_REMOVE_POPUP"] = "删除这个工作流 %s?",
	["WO_WORKFLOW"] = "工作流"
}

Localization:GetLocale("zhCN"):AddTexts(localeContent);

--[[ Removed while CurseForge is malfunctioning
localeContent = 
}

Localization:GetLocale("zhTW"):AddTexts(localeContent);
]]

TRP3_KS_BACKERS =
[[#Total RP 3: Extended (version %s)

Created by |cff00ff00Sylvain "Telkostrasz" Cossement|r and |cff00ff00Renaud "Ellypse" Parize|r.

## To all our Kickstarter backers: many thanks for the support!

- Abyssaloth
- Alex Stromboli (Strom)
- Alex Villescas
- Alexander Salminen
- Andrew P. Thayer
- Andy Austin Polycarp Tymczyszyn
- Antonio Campos jr from McAllen Texas
- Arranax
- Ashley Ann
- Austin Lang
- Brendan Steward
- Caleb Peyton
- Cave
- Charles Gingras
- Cheezedogg
- Chris Magalee
- Christine Brandon
- Colin Stent
- Dave
- Dwargoth 
- Dylan Garrett
- Edward Ryan
- Ella
- Erzan
- Fannar Vilhelmsson
- GreenGrass
- Herman Duyker
- James Lofshult ((Solav))
- James Turner
- Juan
- Kaeril
- Kerry PMack
- Keti
- Kevin Kerrigan
- krinklebearcat
- Kristin Aurora Brayman
- Laerith
- Laleila
- Lilithsahl from Moon Guard US
- Linreia 
- Lium Alxcen
- Lodjay
- Maethi
- Managan Southpaw
- Manuel Robador Merino
- Max Juchheim
- Meg Karper
- Miajensen 
- Michael Bell
- MisticTiger
- Nat
- Nicolo Dresp
- Nimsy
- Orion Cain
- Patrick D Fletcher
- Paul Corlay
- Phahi
- Rob G
- Robinson Gracely
- Rocky Aldridge
- Ryan McGilloway
- Ryldor
- Sachiel
- Saelora
- Samaramon
- Sean "Pommie" K
- Selendis
- Simon Abadei
- Sindaru
- Soraptor
- Sunkara
- Taurii from House of Crows of Wyrmrest Accord
- TeegeeUK
- thedreameater
- Thêmys
- Thomas
- Thomas Laurberg Sørensen
- Valnoressa
- Victor Nilsson
- Vinayack 
- W. Kristoph "Calmorlayne" Nolen
- Weston R. Haring
- Yann
- Ydara
- Zach Platzer
- Zack Wannemacher
- Zencore

##  You are the best!

## Total RP 3: Extended is also maintained thanks to Ellypse's [Patreon](http://patreon.com/Ellypse) supporters:

%s
]];
