-- Author: Nerino1
-- Create Date : 2/5/2018
-- Version 1.0

local f = CreateFrame("frame");
local size = 30
local faction = UnitFactionGroup("player")

local function eventhandler(self,event)
	DEFAULT_CHAT_FRAME:AddMessage("TogglePvP Loaded.");
end

f:SetScript("OnEvent",eventhandler);

local btn = CreateFrame("Button", "TogglePvPBtn", UIParent, "SecureActionButtonTemplate")
btn:SetPoint("CENTER")
btn:SetHeight(size)
btn:SetWidth(size)
btn:SetAttribute("type", "item")
local icon = btn:CreateTexture()
icon:SetAllPoints(true)

if faction == "Alliance" then
	icon:SetTexture("Interface\\Icons\\Inv_Misc_Tournaments_banner_Human")
elseif faction == "Horde" then
	icon:SetTexture("Interface\\Icons\\Inv_Misc_Tournaments_banner_Orc")
elseif faction == "Neutral" then
	icon:SetTexture("Interface\\Icons\\PandarenRacial_InnerPeace")
end
	
btn.icon = icon
btn:EnableMouse(true)
btn:SetMovable(true)
btn:RegisterForDrag("LeftButton")
btn:SetScript("OnDragStart", function(self) if IsAltKeyDown() then self:StartMoving() end end)
btn:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)

btn:SetScript("OnClick", function(event)
	--print("TogglePvP Clicked")
	DEFAULT_CHAT_FRAME.editBox:SetText("/pvp")
	ChatEdit_SendText(DEFAULT_CHAT_FRAME.editBox,0)
end)

btn:SetScript("OnEnter", function(self)
	GameTooltip:SetOwner(self,"ANCHOR_TOP")
		GameTooltip:AddLine("TogglePvP")
		GameTooltip:AddLine("Click to Toggle PvP")
		GameTooltip:AddLine("Alt+Drag to move")
	GameTooltip:Show()
end)

btn:SetScript("OnLeave", function() GameTooltip:Hide() end)