--[[
	Author: GrimNotepad
--]]

local ADDON_NAME, L = ...;
local VERSION = GetAddOnMetadata(ADDON_NAME, "Version")

local buttonlabel = "Quests: "
local numquests = 0
local showmax = true
local maxquests = 25

local function OnClick(self, button)
	if (button == "LeftButton") then
		OpenQuestLog();
	end
end

local menus = {
	{ type = "toggle", text = "Show Max", var = "ShowMax", def = true, keepShown = true },
}

local eventsTable = {
	PLAYER_ENTERING_WORLD = function(self)
		maxquests = C_QuestLog.GetMaxNumQuestsCanAccept()
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		TitanPanelButton_UpdateButton(self.registry.id)
	end,
	QUEST_LOG_UPDATE = function(self)
		TitanPanelButton_UpdateButton(self.registry.id)
	end
}


function GetButtonText(self, id)
	showmax = TitanGetVar(id, "ShowMax")
	local logentries, numquests = GetNumQuestLogEntries()
	local i = logentries
	while GetQuestLogTitle(i) do
		local _, _, _, isHeader, _, _, _, questID = GetQuestLogTitle(i)
		if not isHeader then
			if GetQuestTagInfo(questID) == 102 then
				numquests = numquests -1
			end
		end
		i = i - 1
	end
	local RetVal = numquests
	if showmax then
		RetVal = RetVal .. "/" .. maxquests
	end
	return buttonlabel, RetVal
end

function GetTooltipText(self, id)
	return "Displays the number of quests you have."
end

L.Elib({
	id = "TitanQuests",
	name = "Titan Quests",
	tooltip = "Titan Quests",
	icon = "Interface\\Icons\\achievement_quests_completed_07.blp",
	category = "Information",
	version = VERSION,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	eventsTable = eventsTable,
	menus = menus,
	onClick = OnClick
})
