-- **************************************************************************
-- * TitanHonor.lua
-- *
-- * By: Elloné
-- ******************************** Changelog ********************************
-- v1.05 - 7.3.5 compatibility, thanks to Elloné
-- The code here uses methods found in TitanXP, but modified to use Legion API.
-- **************************************************************************

-- ******************************** Constants *******************************
local TITAN_HONOR_VER = "1.05";
local TITAN_HONOR_ID = "Honor";
local TITAN_HONOR_FREQUENCY = 1;
local updateTable = {TITAN_HONOR_ID, TITAN_PANEL_UPDATE_ALL};
-- ******************************** Variables *******************************
local TitanPanelHonorButton_ButtonAdded = nil;
local found = nil;
local lastMobXP = 0
local L = LibStub("AceLocale-3.0"):GetLocale("Titan_Honor", true)

local honorThrottle = 1 -- how often to update panel
local honorCounter = 0 -- record elapsed time since throttle reached
local honorTimer = 0 -- record how much total time has elapsed
local honorPerHour = 0 -- calculated field for honor per hour
local honorGained = 0 -- how much honor has been gained during session
local timeToNextHonorLevel = 0 -- how much time to next small rank (level)
local timeToNextPrestige = 0 -- time to prestige based on current earnings

local my_honor = 0
local my_pvp_rank = 0
local my_pvp_rank_max = 0
local my_honor = 0
local my_honor_max = 0
local my_honor_level = 0
local my_honor_level_max = 0

local my_honorable_kills = 0
local my_dishonorable_kills = 0
local my_lifetime_hk = 0

-- ******************************** Global Vars *****************************
local unitHonor, unitHonorMax, unitHonorLevel, unitHonorLevelMax, unitPrestige, unitPrestigeMax;
-- **************************************************************************

-- ******************************** Functions *******************************

honorgoal = 0 -- saved variable that does not reset when you reload the UI.

--Honor Per Hour 

local function TitalPanelHonor_OnUpdate(self, elapsed)

end

--Create Slash Command 
SLASH_TITANHONOR1, SLASH_TITANHONOR2, SLASH_TITANHONOR3 = '/titanhonor', '/th', '/honor';
function SlashCmdList.TITANHONOR(msg, editBox)
	local command, rest = msg:match("^(%S*)%s*(.-)$");
	if string.lower(command) == 'show' then
		--Addon:Show();
	elseif string.lower(command) == 'hide' then
		--Addon:Hide();		
	elseif string.lower(command) == 'goal' and string.match(rest, "%d*") ~= nil and string.match(rest, "%a") == nil then
		honorgoal = string.match(rest, "%d*")
		print("Legion Honor: Honor Goal set to " .. string.match(rest, "%d*"))
	elseif string.lower(command) == 'goal' and string.lower(rest) == "reset" then
		honorgoal = 0
		print("Titan Honor: Honor Goal reset")
	else 
		print("Titan Honor: Available commands are /honor, /titanhonor, or /th")
		print("Titan Honor: To set goal, use /titanhonor goal ####")
		print("Titan Honor: To reset goal, use /titanhonor goal reset")
	end
end		

local function UpdateHonor()
    my_pvp_rank = UnitPrestige("player");
    my_pvp_rank_max = GetMaxPrestigeLevel();
    my_honor = UnitHonor("player");
    my_honor_max = UnitHonorMax("player");
    my_honor_level = UnitHonorLevel("player");
    my_honor_level_max = GetMaxPlayerHonorLevel();
end

--Create Function to round the decimals
local function mathround(number, precision)
  precision = precision or 0

  local decimal = string.find(tostring(number), ".", nil, true);
  
  if ( decimal ) then  
    local power = 10 ^ precision;
    
    if ( number >= 0 ) then 
      number = math.floor(number * power + 0.5) / power;
    else 
      number = math.ceil(number * power - 0.5) / power;    
    end
    
    -- convert number to string for formatting :M
    number = tostring(number);      
    
    -- set cutoff :M
    local cutoff = number:sub(decimal + 1 + precision);
      
    -- delete everything after the cutoff :M
    number = number:gsub(cutoff, "");
  else
    -- number is an integer :M
    if ( precision > 0 ) then
      number = tostring(number);
      
      number = number .. ".";
      
      for i = 1,precision
      do
        number = number .. "0";
      end
    end
  end    
  return number;
end

--************************************ Update Goal Progress **********************************
local function UpdateGoalProgress() --need to set this to run on HONOR GAINED
	
	local honorOld, honorNew, honorDiff, honorMaxOld, honorRemain, honorLevelNew;
	honorLevelNew = UnitHonorLevel("player") --set the current honor level
	
    honorOld = my_honor --honor before compare i.e.795
    honorNew = UnitHonor("player")--new current honor
    
    --if the current level isn't what it was:
    if honorLevelNew ~= my_honor_level then	
		honorMaxOld = my_honor_max	--honormax before update. i.e. 800
		honorRemain = honorMaxOld - honorOld -- i.e. 800 - 795 = 5
		honorDiff = honorNew + honorRemain -- i.e. 5 + 5
		honorgoal = honorgoal - honorDiff
	else	
		honorDiff = honorNew - honorOld
		honorgoal = honorgoal - honorDiff	
	end
    
    honorGained = honorGained + honorDiff
    if honorgoal >= 0 then
        --do nothing.
    else
        honorgoal = 0
    end
end

-- **************************************************************************
-- NAME : TitanPanelHonor_OnLoad()
-- DESC : Registers the plugin upon it loading
-- **************************************************************************
function TitanPanelHonorButton_OnLoad(self)
     self.registry = { 
          id = TITAN_HONOR_ID,
          builtIn = 1,
		  category = "Built-ins",
          version = TITAN_HONOR_VER,
          menuText = L["TITAN_HONOR_MENU_TEXT"],
          buttonTextFunction = "TitanPanelHonorButton_GetButtonText",
          tooltipTitle = L["TITAN_HONOR_TOOLTIP"],
          tooltipTextFunction = "TitanPanelHonorButton_GetTooltipText",
          iconWidth = 16,
          savedVariables = {       
            ShowIcon = 1,
            ShowHonor = 1,
            ShowPVPRank = 1,
            ShowDishonorableKills = 1,
            ShowLifetimeHK = 1,
          }
     };
    
    self:RegisterEvent("PLAYER_ENTERING_WORLD");
    self:RegisterEvent("HONOR_XP_UPDATE");

end

-- **************************************************************************
-- NAME : TitanPanelHonorButton_OnShow()
-- DESC : Display the icon in the bar
-- NOTE : For a lack of better check at the moment TitanPanel_ButtonAdded
--        is a global variable set to true only when a button has just been
--        added to the panel
-- **************************************************************************
function TitanPanelHonorButton_OnShow()
     TitanPanelHonorButton_SetIcon();
     found = nil;
     if not TitanPanelHonorButton_ButtonAdded then
     		TitanPanelHonorButton_ButtonAdded = true;
     end
end


function TitanPanelHonorButton_OnHide()
	if (TitanPanelSettings) then
		for i = 1, table.getn(TitanPanelSettings.Buttons) do		
			if(TitanPanelSettings.Buttons[i] == TITAN_HONOR_ID) then
				found = true;			
			end	
		end
		if not found then
			TitanPanelHonorButton_ButtonAdded = nil
		end
	end
end

-- **************************************************************************
-- NAME : TitanPanelHonorButton_OnEvent(arg1, arg2)
-- DESC : Parse events registered to addon and act on them
-- VARS : arg1 = <research> , arg2 = <research>
-- **************************************************************************
function TitanPanelHonorButton_OnEvent(self, event, a1, a2, ...)
    if (event == "PLAYER_ENTERING_WORLD") then
		UpdateHonor()
	elseif (event == "HONOR_XP_UPDATE") then
		-- Remember play time
		UpdateGoalProgress()
		UpdateHonor()
	end
end

-- **************************************************************************
-- NAME : TitanPanelHonorButton_OnUpdate(elapsed)
-- DESC : Update button data
-- VARS : elapsed = <research>
-- **************************************************************************
function TitanPanelHonorButton_OnUpdate(self, elapsed)
     TITAN_HONOR_FREQUENCY = TITAN_HONOR_FREQUENCY - elapsed;
     if (TITAN_HONOR_FREQUENCY <= 0) then
          TITAN_HONOR_FREQUENCY = 1;
          TitanPanelPluginHandle_OnUpdate(updateTable)
     end
     if (self.totalTime) then
          self.totalTime = self.totalTime + elapsed;          
          self.levelTime = self.levelTime + elapsed;
     end
    
    honorCounter = honorCounter + elapsed
	honorTimer = honorTimer + elapsed
	if honorCounter >= honorThrottle then
		honorCounter = 0
        if (honorGained ~= 0) then
		honorPerHour = honorGained / honorTimer * 3600
		honorPerHour = mathround(honorPerHour, 0)
        end
	end	
    
    --time to next level
    if (honorPerHour ~= 0) then
        local tempTimeToNextHonorLevel = (my_honor_max - my_honor) / honorPerHour
        local tempTimeToNextPrestige = 0
            if ((my_honor_level_max - my_honor_level) <= 11) then
                tempTimeToNextPrestige = (my_honor_level_max - my_honor_level) * 1000
                tempTimeToNextPrestige = tempTimeToNextPrestige / honorPerHour
            else
                tempTimeToNextPrestige = (my_honor_level_max - my_honor_level) * 950
                tempTimeToNextPrestige = tempTimeToNextPrestige / honorPerHour
            end;
        timeToNextHonorLevel = mathround(tempTimeToNextHonorLevel, 2)
        timeToNextPrestige = mathround(tempTimeToNextPrestige, 2)
    else
        timeToNextHonorLevel = 0;
        timeToNextPrestige = 0;
    end
end


-- **************************************************************************
-- NAME : TitanPanelHonorButton_GetButtonText(id)
-- DESC : Calculate time based logic for button text
-- VARS : id = button ID
-- **************************************************************************
function TitanPanelHonorButton_GetButtonText(id)
    local button, id = TitanUtils_GetButton(id, true);
    local res = ""; 

	local my_honorable_kills, my_dishonorable_kills, my_lifetime_hk = GetPVPLifetimeStats("Player");

	
    if (TitanGetVar(TITAN_HONOR_ID, "ShowHonor") ~= nil) then 
        res = res .."H: " .. TitanHonor_HL_text(my_honor) .. "/" .. TitanHonor_HL_text(my_honor_max);
    end;
    if (honorgoal ~= nil) then
    res = res .. " Goal: " .. TitanHonor_HL_text(honorgoal);
    end;
    return res;
end

function TitanHonor_HL_text(text)
	if (text) then
        if (text == 0) then
            return GRAY_FONT_COLOR_CODE..text..FONT_COLOR_CODE_CLOSE;
        else 
            return HIGHLIGHT_FONT_COLOR_CODE..text..FONT_COLOR_CODE_CLOSE;
        end
	end
end

-- **************************************************************************
-- NAME : TitanPanelHonorButton_GetTooltipText()
-- DESC : Display tooltip text
-- **************************************************************************
function TitanPanelHonorButton_GetTooltipText()    
    local res = "";
    
	local my_honorable_kills, my_dishonorable_kills, my_lifetime_hk = GetPVPLifetimeStats("player");
	
    res = res .. "Total Honorable Kills: " .. "\t" .. TitanHonor_HL_text(my_honorable_kills).."\n";
    res = res .. L["TITAN_HONOR_HONOR"] .. ": " .. "\t" .. TitanHonor_HL_text(my_honor) .. " / " .. TitanHonor_HL_text(my_honor_max) .. "\n";
    res = res .. "Honor Level: " .. "\t" .. TitanHonor_HL_text(my_honor_level) .. " / " .. TitanHonor_HL_text(my_honor_level_max) .. "\n";
    res = res .. "Prestige: " .. "\t" .. TitanHonor_HL_text(my_pvp_rank) .. " / " .. TitanHonor_HL_text(my_pvp_rank_max) .. "\n\n";
    if (honorPerHour ~= nil) then
    res = res .. "Honor Earned Per Hour: " .. "\t" .. TitanHonor_HL_text(honorPerHour) .. "\n";
    end;
    res = res .. "Honor Earned This Session: " .. "\t" .. TitanHonor_HL_text(honorGained) .. "\n";
    res = res .. "Time To Next Honor Level (Hours)" .. "\t" .. TitanHonor_HL_text(timeToNextHonorLevel) .. "\n";
    res = res .. "Time To Next Prestige (Hours)" .. "\t" .. TitanHonor_HL_text(timeToNextPrestige) .. "\n\n";
    if (honorgoal ~= nil) then
    res = res .. "Goal: " .. "\t" .. TitanHonor_HL_text(honorgoal) .. "\n";
    end;
        
    return res;
end

-- **************************************************************************
-- NAME : TitanPanelHonorButton_SetIcon()
-- DESC : Define icon based on faction
-- **************************************************************************
function TitanPanelHonorButton_SetIcon()
     local icon = TitanPanelHonorButtonIcon;
     local factionGroup, factionName = UnitFactionGroup("player");     

     if (factionGroup == "Alliance") then
          icon:SetTexture("Interface\\TargetingFrame\\UI-PVP-Alliance");
          icon:SetTexCoord(0.046875, 0.609375, 0.03125, 0.59375);
     elseif (factionGroup == "Horde") then
          icon:SetTexture("Interface\\TargetingFrame\\UI-PVP-Horde");
          icon:SetTexCoord(0.046875, 0.609375, 0.015625, 0.578125);
     else
          icon:SetTexture("Interface\\TargetingFrame\\UI-PVP-FFA");
          icon:SetTexCoord(0.046875, 0.609375, 0.03125, 0.59375);
     end
end

-- **************************************************************************
-- NAME : TitanPanelRightClickMenu_PrepareXPMenu()
-- DESC : Display rightclick menu options
-- **************************************************************************
function TitanPanelRightClickMenu_PrepareHonorMenu()     
  
    local info = {};  
    TitanPanelRightClickMenu_AddTitle(TitanPlugins[TITAN_HONOR_ID].menuText);

    TitanPanelRightClickMenu_AddToggleVar(L["TITAN_HONOR_HONOR"], TITAN_HONOR_ID, "ShowHonor");    
    TitanPanelRightClickMenu_AddToggleVar(L["TITAN_HONOR_PVP_RANK"], TITAN_HONOR_ID, "ShowPVPRank");    
    TitanPanelRightClickMenu_AddToggleVar(L["TITAN_HONOR_DISHONORABLE_KILLS"], TITAN_HONOR_ID, "ShowDishonorableKills");    
    TitanPanelRightClickMenu_AddToggleVar(L["TITAN_HONOR_LIFETIME_HK"], TITAN_HONOR_ID, "ShowLifetimeHK");   
    
    TitanPanelRightClickMenu_AddSpacer();
    TitanPanelRightClickMenu_AddToggleIcon(TITAN_HONOR_ID);

    TitanPanelRightClickMenu_AddSpacer();
    TitanPanelRightClickMenu_AddCommand(L["TITAN_PANEL_MENU_HIDE"], TITAN_HONOR_ID, TITAN_PANEL_MENU_FUNC_HIDE);
  
end

-- **************************************************************************
-- NAME : TitanPanelHonorButton_OnClick()
-- DESC : Show PvP panel on left click
-- **************************************************************************
function TitanPanelHonorButton_OnClick(self, button)
     if (button == "LeftButton") then
		--PVPParentFrame:Show();
		--if not IsAddOnLoaded("Blizzard_PVPUI") then
        --    LoadAddOn("Blizzard_PVPUI")
     end
end