--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Lovely Charm.
It's a eventual plugin, and will be able to use only in the event "Love is in the Air".
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_LYCMM"
local lovelyCharm = 0
local startcurrency = 0
-----------------------------------------------
local function getLovely()
	return GetItemCount(49655, true) or 0
end
-----------------------------------------------
local function GetButtonText(self, id)
	local currencyCountText = TitanUtils_GetHighlightText(lovelyCharm)

	local barBalanceText = ""
	if TitanGetVar(ID, "ShowBarBalance") then
		if (lovelyCharm - startcurrency) > 0 then
			barBalanceText = " |cFF69FF69["..(lovelyCharm - startcurrency).."]"
		elseif (lovelyCharm - startcurrency) < 0 then
			barBalanceText = " |cFFFF2e2e["..(lovelyCharm - startcurrency).."]"
		end
	end

	return L["LovelyLabel"], currencyCountText .. barBalanceText
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local colorValueAccount = "0" -- Cores da conta de valor

	local dif = lovelyCharm - startcurrency
	if dif == 0 then
		colorValueAccount = TitanUtils_GetHighlightText("0")
	elseif dif > 0 then
		colorValueAccount = "|cFF69FF69"..dif
	else
		colorValueAccount = "|cFFFF2e2e"..dif
	end

	local valorBag = L["totalbag"]..TitanUtils_GetHighlightText(GetItemCount(49655)).."\r"
	local valorBank = L["totalbank"]..TitanUtils_GetHighlightText(GetItemCount(49655, true) - GetItemCount(49655))

	local valueText = "" -- Difere com e sem moeda
	if lovelyCharm == 0 then
		valueText = "|cFFFF2e2e"..L["NoLove"]
	else
		valueText = L["info"]..valorBag..valorBank.."\r\r".. L["session"]..colorValueAccount
	end

	return L["LovelyDescription"].."\r\r"..valueText
end
-----------------------------------------------
local eventsTable = {
	PLAYER_ENTERING_WORLD = function(self)
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		self.PLAYER_ENTERING_WORLD = nil

		startcurrency = getLovely()
		lovelyCharm = startcurrency

		TitanPanelButton_UpdateButton(self.registry.id)

		self.BAG_UPDATE = function(self, bagID)
			local lovely = getLovely()

			if lovelyCharm == lovely then return end
			lovelyCharm = lovely

			TitanPanelButton_UpdateButton(self.registry.id)
		end
		self:RegisterEvent("BAG_UPDATE")
	end
}
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mEvent"].." Titan|cFFEA9F66 "..L["LovelyTitle"].."|r",
	tooltip = L["LovelyTitle"],
	icon = "Interface\\Icons\\inv_misc_gem_sapphire_01.blp",
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	prepareMenu = L.PrepareCurrenciesMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		HideMax = false,
		ShowBarBalance = false,
		ShowLabelText = false,
	},
	eventsTable = eventsTable
})
