--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Mark of Honor.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_MKFHNM"
local markHonor = 0
local startcurrency = 0
-----------------------------------------------
local function getMarkHonor()
	return GetItemCount(137642, true) or 0
end
-----------------------------------------------
local function GetButtonText(self, id)
	local currencyCountText
	if not markHonor then
		currencyCountText = TitanUtils_GetHighlightText("0")
	else
		currencyCountText = TitanUtils_GetHighlightText(markHonor)
	end

	local barBalanceText = ""
	if TitanGetVar(ID, "ShowBarBalance") then
		if (markHonor - startcurrency) > 0 then
			barBalanceText = " |cFF69FF69["..(markHonor - startcurrency).."]"
		elseif (markHonor - startcurrency) < 0 then
			barBalanceText = " |cFFFF2e2e["..(markHonor - startcurrency).."]"
		end
	end

	return L["MarkLabel"], currencyCountText .. barBalanceText
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local colorValueAccount = "0" -- Cores da conta de valor

	local dif = markHonor - startcurrency
	if dif == 0 then
		colorValueAccount = TitanUtils_GetHighlightText("0")
	elseif dif > 0 then
		colorValueAccount = "|cFF69FF69"..dif
	else
		colorValueAccount = "|cFFFF2e2e"..dif
	end

	local valorBag = L["totalbag"]..TitanUtils_GetHighlightText(GetItemCount(137642)).."\r"
	local valorBank = L["totalbank"]..TitanUtils_GetHighlightText(GetItemCount(137642, true) - GetItemCount(137642))

	local valueText = "" -- Difere com e sem moeda
	if markHonor == 0 then
		valueText = L["info"].."|cFFFF2e2e"..L["NoMark"]
	else
		valueText = L["info"]..valorBag..valorBank.."\r\r".. L["session"]..colorValueAccount
	end

	return L["MarkDescription"].."\r\r"..valueText
end
-----------------------------------------------
local eventsTable = {
	PLAYER_ENTERING_WORLD = function(self)
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		self.PLAYER_ENTERING_WORLD = nil

		startcurrency = getMarkHonor()
		markHonor = startcurrency

		TitanPanelButton_UpdateButton(self.registry.id)

		self.BAG_UPDATE = function(self, bagID)
			local honor = getMarkHonor()

			if markHonor == honor then return end
			markHonor = honor

			TitanPanelButton_UpdateButton(self.registry.id)
		end
		self:RegisterEvent("BAG_UPDATE")
	end
}
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mPvP"].." Titan|cFF66b1ea "..L["MarkTitle"].."|r",
	tooltip = L["MarkTitle"],
	icon = "Interface\\Icons\\ability_pvp_gladiatormedallion",
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	prepareMenu = L.PrepareCurrenciesMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		HideMax = false,
		ShowBarBalance = false,
		ShowLabelText = false,
	},
	eventsTable = eventsTable
})
