--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Pet Charm.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_PTCMM"
local petCharm = 0
local startcurrency = 0
-----------------------------------------------
local function getPetCharm()
	return GetItemCount(116415, true) or 0
end
-----------------------------------------------
local function GetButtonText(self, id)
	local currencyCountText
	if not petCharm then
		currencyCountText = TitanUtils_GetHighlightText("0")
	else
		currencyCountText = TitanUtils_GetHighlightText(petCharm)
	end

	local barBalanceText = ""
	if TitanGetVar(ID, "ShowBarBalance") then
		if (petCharm - startcurrency) > 0 then
			barBalanceText = " |cFF69FF69["..(petCharm - startcurrency).."]"
		elseif (petCharm - startcurrency) < 0 then
			barBalanceText = " |cFFFF2e2e["..(petCharm - startcurrency).."]"
		end
	end

	return L["PetLabel"], currencyCountText .. barBalanceText
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local colorValueAccount = "0" -- Cores da conta de valor

	local dif = petCharm - startcurrency
	if dif == 0 then
		colorValueAccount = TitanUtils_GetHighlightText("0")
	elseif dif > 0 then
		colorValueAccount = "|cFF69FF69"..dif
	else
		colorValueAccount = "|cFFFF2e2e"..dif
	end

	local valorBag = L["totalbag"]..TitanUtils_GetHighlightText(GetItemCount(116415)).."\r"
	local valorBank = L["totalbank"]..TitanUtils_GetHighlightText(GetItemCount(116415, true) - GetItemCount(116415))

	local valueText = "" -- Difere com e sem moeda
	if petCharm == 0 then
		valueText = L["info"].."|cFFFF2e2e"..L["NoMaxPet"]
	else
		valueText = L["info"]..valorBag..valorBank.."\r\r".. L["session"]..colorValueAccount
	end

	return L["PetDescription"].."\r\r"..valueText
end
-----------------------------------------------
local eventsTable = {
	PLAYER_ENTERING_WORLD = function(self)
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		self.PLAYER_ENTERING_WORLD = nil

		startcurrency = getPetCharm()
		petCharm = startcurrency

		TitanPanelButton_UpdateButton(self.registry.id)

		self.BAG_UPDATE = function(self, bagID)
			local charm = getPetCharm()

			if petCharm == charm then return end
			petCharm = charm

			TitanPanelButton_UpdateButton(self.registry.id)
		end
		self:RegisterEvent("BAG_UPDATE")
	end
}
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mOther"].." Titan|cFF66b1ea "..L["PetTitle"].."|r",
	tooltip = L["PetTitle"],
	icon = "Interface\\Icons\\achievement_guildperk_honorablemention.blp",
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	prepareMenu = L.PrepareCurrenciesMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		HideMax = false,
		ShowBarBalance = false,
		ShowLabelText = false,
	},
	eventsTable = eventsTable
})
