--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Gold.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Eliote
--]]

local ADDON_NAME, L = ...;
local ACE = LibStub("AceLocale-3.0"):GetLocale("Titan", true)
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_OUROM"
local Color = {}
--Color.WHITE = "|cFFFFFFFF"
Color.RED = "|cFFDC2924"
--Color.YELLOW = "|cFFFFF244"
Color.GREEN = "|cFF3DDC53"
Color.OURO = "|cFFFFFF00"
Color.PRATA = "|cFFCCCCCC"
Color.BRONZE = "|cFFFF6600"

local ICO_OURO = "|TInterface\\MoneyFrame\\UI-GoldIcon:0|t"
local ICO_PRATA = "|TInterface\\MoneyFrame\\UI-SilverIcon:0|t"
local ICO_BRONZE = "|TInterface\\MoneyFrame\\UI-CopperIcon:0|t"

local PLAYER_NAME = "|c" .. RAID_CLASS_COLORS[select(2, UnitClass("player"))].colorStr .. UnitName("player")

local startMoney = 0

-- Util
local function interp(str, tab)
	return (str:gsub('($%b{})', function(w) return tostring(tab[w:sub(3, -2)] or w) end))
end

local function trim(s)
	local from = s:match"^%s*()"
	return from > #s and "" or s:match(".*%S", from)
end
-- end Util

local function formatGold(value, cor, somenteMaior)
	local text = ""

	if not somenteMaior or value >= 10000 then
		text = text .. (cor or Color.OURO) .. math.floor(value / 10000) .. ICO_OURO .. "|r "
	end

	if not somenteMaior or (value >= 100 and value < 10000) then
		text = text .. (cor or Color.PRATA) .. math.floor((value / 100) % 100) .. ICO_PRATA .. "|r "
	end

	if not somenteMaior or (value < 100) then
		text = text .. (cor or Color.BRONZE) .. math.floor(value % 100) .. ICO_BRONZE .. "|r"
	end

	text = trim(text)

	return text
end
-----------------------------------------------
local function GetButtonText(self, id)
	local money = GetMoney("player")

	local balance = ""
	if TitanGetVar(id, "ShowBarBalance") then
		local dif = money - startMoney
		if dif > 0 then
			balance = Color.GREEN .. " [+" .. formatGold(dif, nil, true) .. Color.GREEN .. "]"
		elseif dif < 0 then
			balance = Color.RED .. " [-" .. formatGold(-dif, Color.RED, true) .. Color.RED .. "]"
		end
	end

	return L["GoldTitle"] .. ": ", formatGold(money, nil, TitanGetVar(id, "ShowHigherOnly")) .. balance
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local money = GetMoney("player")

	local text = interp(L["GoldPlayerTip"], { player = PLAYER_NAME }) .. "\n\t\n"
	text = text .. L["totalAcquired"] .. "\t" .. formatGold(money) .. "\n"

	local dif = money - startMoney
	if dif > 0 then
		text = text .. L["session"] .. "\t" .. formatGold(dif)
	elseif dif < 0 then
		text = text .. L["session"] .. "\t" .. formatGold(-dif, Color.RED)
	end

	return text
end
-----------------------------------------------
local function OnClick(self, button)
	if (button == "LeftButton") then
		ToggleCharacter("TokenFrame");
	end
end
-----------------------------------------------
local function PrepareMenu(self, id)
	TitanPanelRightClickMenu_AddTitle(TitanPlugins[id].menuText)
	TitanPanelRightClickMenu_AddToggleIcon(id)
	TitanPanelRightClickMenu_AddToggleLabelText(id)

	local info = UIDropDownMenu_CreateInfo();
	info.text = L["HigherOnly"];
	info.func = function() TitanToggleVar(id, "ShowHigherOnly"); TitanPanelButton_UpdateButton(id); end
	info.checked = TitanGetVar(id, "ShowHigherOnly");
	L_UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = L["showbb"];
	info.func = function() TitanToggleVar(id, "ShowBarBalance"); TitanPanelButton_UpdateButton(id); end
	info.checked = TitanGetVar(id, "ShowBarBalance");
	L_UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = ACE["TITAN_CLOCK_MENU_DISPLAY_ON_RIGHT_SIDE"];
	info.func = function() TitanToggleVar(id, "DisplayOnRightSide"); TitanPanel_InitPanelButtons(id); end
	info.checked = TitanGetVar(id, "DisplayOnRightSide");
	L_UIDropDownMenu_AddButton(info);

	TitanPanelRightClickMenu_AddSpacer()
	TitanPanelRightClickMenu_AddCommand(ACE["TITAN_PANEL_MENU_HIDE"], id, TITAN_PANEL_MENU_FUNC_HIDE);
end
-----------------------------------------------
local eventsTable = {
	PLAYER_ENTERING_WORLD = function(self)
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		self.PLAYER_ENTERING_WORLD = nil

		startMoney = GetMoney("player")

		TitanPanelButton_UpdateButton(self.registry.id)
	end,
	PLAYER_MONEY = function(self)
		TitanPanelButton_UpdateButton(self.registry.id)
	end
}
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mOther"].." Titan|cFF66b1ea "..L["GoldTitle"].."|r",
	tooltip = L["GoldTitle"],
	icon = "Interface\\Icons\\inv_misc_coin_02.blp",
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	eventsTable = eventsTable,
	onClick = OnClick,
	prepareMenu = PrepareMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		ShowBarBalance = false,
		ShowLabelText = false,
		ShowHigherOnly = false,
	}
})
