--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Mogu Rune of Fate.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_MGROFM"
local ICON = "Interface\\Icons\\archaeology_5_0_mogucoin"
local CURRENCY_ID = 752
local currencyCount = 0.0
local currencyMaximum
local startcurrency
-----------------------------------------------
local function Util_StringComDefault(v,d)
	if not v then
		return d
	end

	return v
end
-----------------------------------------------
local eventsTable = {
	CURRENCY_DISPLAY_UPDATE = function(self)
		local name, amount, texturePath, earnedThisWeek, weeklyMax, totalMax, isDiscovered = GetCurrencyInfo(CURRENCY_ID)

		currencyCount = amount
		currencyMaximum = totalMax
		if not startcurrency then startcurrency = currencyCount end

		TitanPanelButton_UpdateButton(self.registry.id)
	end
}
-----------------------------------------------
local function GetButtonText(self, id)
	local currencyCountText
	if not currencyCount then
		currencyCountText = TitanUtils_GetHighlightText("0")
	elseif currencyCount > currencyMaximum * 0.4 and currencyCount < currencyMaximum * 0.59 then
		currencyCountText = "|cFFf6ed12"..currencyCount
	elseif currencyCount > currencyMaximum * 0.59 and currencyCount < currencyMaximum * 0.79 then
		currencyCountText = "|cFFf69112"..currencyCount
	elseif currencyCount > currencyMaximum * 0.79 then
		currencyCountText = "|cFFFF2e2e"..currencyCount
	else
		currencyCountText = TitanUtils_GetHighlightText(currencyCount)
	end

	local BarBalanceText = ""
	if currencyMaximum and TitanGetVar(ID, "ShowBarBalance") then
		if (currencyCount - startcurrency) > 0 then
			BarBalanceText = " |cFF69FF69["..(currencyCount - startcurrency).."]"
		elseif (currencyCount - startcurrency) < 0 then
			BarBalanceText = " |cFFFF2e2e["..(currencyCount - startcurrency).."]"
		end
	end

	local maxBarText
	if currencyMaximum and currencyMaximum > 0 and TitanGetVar(ID, "MaxBar") then
		maxBarText = "|r/|cFFFF2e2e"..currencyMaximum.."|r"
	else
		maxBarText = ""
	end

	return L["MRuneLabel"], currencyCountText..maxBarText..BarBalanceText
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local ColorValueAccount = "0" -- Cores da conta de valor
	if currencyCount and startcurrency then
		local dif = currencyCount - startcurrency
		if dif == 0 then
			ColorValueAccount = TitanUtils_GetHighlightText("0")
		elseif dif > 0 then
			ColorValueAccount = "|cFF69FF69"..dif
		else
			ColorValueAccount = "|cFFFF2e2e"..dif
		end
	end

	local valorAtual = TitanUtils_GetHighlightText(Util_StringComDefault(currencyCount, "0"))
	local valorMaximo = TitanUtils_GetHighlightText(Util_StringComDefault(currencyMaximum, "0"))

	local ValueText = "" -- Difere com e sem moeda
	if currencyMaximum == 0 then
		ValueText = L["info"].."|cFFFF2e2e"..L["PandariaOnly"]
	else
		ValueText = L["info"]..L["totalAcquired"]..valorAtual..L["maxpermitted"]..valorMaximo..L["canGet"]..TitanUtils_GetHighlightText((currencyMaximum - currencyCount)).."\r\r"..L["session"]..ColorValueAccount
	end

	return L["MRuneDescription"].."\r\r"..ValueText
end
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mMoP"].." Titan|cFF66b1ea "..L["MRuneTitle"].."|r",
	tooltip = L["MRuneTitle"],
	icon = ICON,
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	eventsTable = eventsTable,
	prepareMenu = L.PrepareCurrenciesMaxMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		ShowBarBalance = false,
		ShowLabelText = false,
		MaxBar = false,
	}
})
