--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Drowned Mana.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_DRWDMM"
local drownedMana = 0
local startcurrency = 0
-----------------------------------------------
local function getDrownedMana()
	return GetItemCount(138777, true) or 0
end
-----------------------------------------------
local function GetButtonText(self, id)
	local currencyCountText = TitanUtils_GetHighlightText(drownedMana)

	local barBalanceText = ""
	if TitanGetVar(ID, "ShowBarBalance") then
		if (drownedMana - startcurrency) > 0 then
			barBalanceText = " |cFF69FF69["..(drownedMana - startcurrency).."]"
		elseif (drownedMana - startcurrency) < 0 then
			barBalanceText = " |cFFFF2e2e["..(drownedMana - startcurrency).."]"
		end
	end

	return L["DrownedLabel"], currencyCountText..barBalanceText
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local colorValueAccount = "0" -- Cores da conta de valor

	local dif = drownedMana - startcurrency
	if dif == 0 then
		colorValueAccount = TitanUtils_GetHighlightText("0")
	elseif dif > 0 then
		colorValueAccount = "|cFF69FF69"..dif
	else
		colorValueAccount = "|cFFFF2e2e"..dif
	end

	local valorBag = L["totalbag"]..TitanUtils_GetHighlightText(GetItemCount(138777)).."\r"
	local valorBank = L["totalbank"]..TitanUtils_GetHighlightText(GetItemCount(138777, true) - GetItemCount(138777))

	local valueText = "" -- Difere com e sem moeda
	if drownedMana == 0 then
		valueText = L["info"].."|cFFFF2e2e"..L["NoDrowned"]
	else
		valueText = L["info"]..valorBag..valorBank.."\r\r".. L["session"]..colorValueAccount
	end

	return L["DrownedDescription"] .. "\r\r"..valueText
end
-----------------------------------------------
local eventsTable = {
	PLAYER_ENTERING_WORLD = function(self)
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		self.PLAYER_ENTERING_WORLD = nil

		startcurrency = getDrownedMana()
		drownedMana = startcurrency

		TitanPanelButton_UpdateButton(self.registry.id)

		self.BAG_UPDATE = function(self, bagID)
			local dmana = getDrownedMana()

			if drownedMana == dmana then return end
			drownedMana = dmana

			TitanPanelButton_UpdateButton(self.registry.id)
		end
		self:RegisterEvent("BAG_UPDATE")
	end
}
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mLegion"].." Titan|cFF66b1ea "..L["DrownedTitle"].."|r",
	tooltip = L["DrownedTitle"],
	icon = "Interface\\Icons\\inv_elemental_primal_water",
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	prepareMenu = L.PrepareCurrenciesMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		HideMax = false,
		ShowBarBalance = false,
		ShowLabelText = false,
	},
	eventsTable = eventsTable
})
