--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Artifact Power.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local ACE = LibStub("AceLocale-3.0"):GetLocale("Titan", true)
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_ARTFTM"
local ICON = "Interface\\Icons\\inv_scroll_05"
local artifactCount
-- local artifactTotalCount (Total adquirido em TODOS os níveis, não está sendo usado.)
local artifactMaximum
local artifactLevel
local artifactSpend
local weaponName
local artifactIcon
--local artifactKnowledge
local CHARCOLOR = "|c" .. RAID_CLASS_COLORS[select(2, UnitClass("player"))].colorStr
-----------------------------------------------
local function getInfo()
	local followerShipments = C_Garrison.GetLooseShipments(LE_GARRISON_TYPE_7_0);

  if not followerShipments then return end

	for i = 1, #followerShipments do
		local name, texture, shipmentCapacity, shipmentsReady, shipmentsTotal, creationTime, duration, timeleftString, _, _, _, followerID = C_Garrison.GetLandingPageShipmentInfoByContainerID(followerShipments[i]);
		if followerID == 139390 or followerID == 146745 then
			 return name or "", texture or 0, shipmentCapacity or 0, shipmentsReady or 0, shipmentsTotal or 0, creationTime or 0, duration or 0, timeleftString or L["unknown"], _, _, _, followerID
		end
	end
end
-----------------------------------------------
local function UpdateAll(self)
	if HasArtifactEquipped() then
		local itemID, altItemID, name, icon, xp, pointsSpent, quality, artifactAppearanceID, appearanceModID, itemAppearanceID, altItemAppearanceID, altOnTop, artifactTier = C_ArtifactUI.GetEquippedArtifactInfo();
		local xpForNextPoint = C_ArtifactUI.GetCostForPointAtRank(pointsSpent, artifactTier)
		local numPointsAvailableToSpend, xp, xpForNextPoint = MainMenuBar_GetNumArtifactTraitsPurchasableFromXP(pointsSpent, xp, artifactTier);
		local _, amount, texturePath, earnedThisWeek, weeklyMax, totalMax, isDiscovered, quality = GetCurrencyInfo(1171);

    artifactCount = xp
  --  artifactTotalCount (Não estava usando para nada!)
    artifactMaximum = xpForNextPoint
    artifactLevel = pointsSpent
    artifactSpend = numPointsAvailableToSpend
    weaponName = name
  --  artifactKnowledge = amount
    artifactIcon = icon
  end

	if TitanPlugins[self.registry.id] and artifactIcon then
  	TitanPlugins[self.registry.id].icon = artifactIcon
  end

	TitanPanelButton_UpdateButton(self.registry.id)
end
-----------------------------------------------
local eventsTable = {
	PLAYER_LOGIN = UpdateAll,
	PLAYER_ENTERING_WORLD = UpdateAll, -- Jogador entra no Mundo
	ARTIFACT_UPDATE = UpdateAll,
	ARTIFACT_XP_UPDATE = UpdateAll,
--	BAG_UPDATE = UpdateAll, -- Atualização da Bolsa
	PLAYER_EQUIPMENT_CHANGED = UpdateAll, -- Atualização de Equipamento
--	UNIT_DAMAGE = UpdateAll, -- Atualização da Arma
	ACTIVE_TALENT_GROUP_CHANGED = UpdateAll, -- Atualização da Árvore de Talentos
	CURRENCY_DISPLAY_UPDATE = UpdateAll, -- Atualização da Lista de Moedas.
--	RESEARCH_ARTIFACT_UPDATE = UpdateAll,
--	GARRISON_TALENT_COMPLETE = UpdateAll,
--	GARRISON_LANDINGPAGE_SHIPMENTS = UpdateAll,
--	GARRISON_SHIPMENT_RECEIVED = UpdateAll,
--	GARRISON_TALENT_UPDATE = UpdateAll
	ARTIFACT_RESPEC_PROMPT = UpdateAll,
}
-----------------------------------------------
local function GetButtonText(self, id)

	if HasArtifactEquipped() then
		local researchname, texture, shipmentCapacity, shipmentsReady, shipmentsTotal, creationTime, duration, timeleftString, _, _, _, followerID = getInfo()

		-------------- Parte responsável pelo texto da arma.

		local XP = (formatNumber(artifactCount, '.'))
		local tolvl = (formatNumber(artifactMaximum, '.'))
		local diff = (formatNumber(artifactMaximum - artifactCount, '.'))

		local weaponlvl = ""
		if artifactSpend == 0 or nil then -- se eu não tiver pontos a serem gastos na arma ou nulo, então mostre apenas o nível atual.
			weaponlvl = artifactLevel
		elseif
		artifactSpend > 0 then
			weaponlvl = artifactLevel.."|cFFFFFFFF-|cFFFF2e2e"..artifactSpend.."|r"
		end

		local simplewarning = "|cFFFF2e2e*|r" -- para mostrar algo no modo simples quando houver níveis novos da arma disponíveis.
		if artifactSpend == 0 or nil then
			simplewarning = ""
		end

		local porcentagem = (artifactCount * 100 / artifactMaximum)

		-------------- Parte responsável pelo texto de conhecimento de artefato.
--[[
		local hasTimeleft = timeleftString
		if not timeleftString then -- se não encontrar o tempo, então mostre "desconhecido".
			hasTimeleft = L["unknown"]
		end

		local klevel = "   |TInterface\\Icons\\inv_scroll_11:0|t |cFFFFFFFF[|r|cffe6cc80"..artifactKnowledge.."|r|cFFFFFFFF]"
		if not artifactKnowledge then -- se der algum problema, não mostre nada.
			klevel = ""
		elseif artifactKnowledge == 0 then -- se estiver entre 100 e 109 (com arma), não mostre nada. Serve para não ficar mostrando "0" até que o personagem consiga chegar ao nível 110.
			klevel = ""
		elseif artifactKnowledge == 50 then -- se estiver no nível máximo, mostre "max".
			klevel = "   |TInterface\\Icons\\inv_scroll_11:0|t |cFFFFFFFF[|r|cffe6cc80"..artifactKnowledge.."|r|cFFFFFFFF]|cFF69FF69 "..L["maximum"].."!"
		end

		local knowledgeRes = ""
		if shipmentCapacity then -- se tiver o "name" da pesquisa, então mostre as informações.
			knowledgeRes = " |cFF69FF69"..shipmentsReady.."|r|||cFFFF2e2e"..shipmentsTotal.." |r|cFFFFFFFF(|r"..hasTimeleft.."|cFFFFFFFF)"
		end

		local knowledgeText = klevel..knowledgeRes
		if TitanGetVar(id, "HideKnowledge") then -- se for desabilitdo no menu, não mostre o texto de conhecimento.
			knowledgeText = ""
		end

		]]--------------

		if not TitanGetVar(id, "SimpleText") then
			return L["ArticaftTitle"]..": ", "|cFFFFFFFF[|r"..CHARCOLOR..weaponlvl.."|cFFFFFFFF]|r|cFF69FF69 "..XP.."|r|||cFFFFFFFF"..tolvl.." |cFFFF2e2e("..diff..")|r |cFFFFFFFF[|cFF69FF69"..(string.format("%.1f", porcentagem)).."%|r|cFFFFFFFF]"--[[..knowledgeText]]--
		else
			return L["ArticaftTitle"]..": ", "|cFF69FF69"..XP..simplewarning.."|r|||cFFFFFFFF"..tolvl
		end

	else
		return L["noweapon"]
	end
end
-----------------------------------------------
local function GetTooltipText(self, id)
	UpdateAll(self)

	if HasArtifactEquipped() then
		local resname, texture, shipmentCapacity, shipmentsReady, shipmentsTotal, creationTime, duration, timeleftString, _, _, _, followerID = getInfo()

		-------------- Parte responsável pelo texto da arma.

		local artifactInfoText = L["info"]..L["ArticaftLevel"]..artifactLevel.."|r\r"..L["ArticaftSpend"]..(formatNumber(artifactSpend, '.')).."|r\r"..L["ArticaftXP"]..(formatNumber(artifactCount, '.')).."|r\r"..L["ArticafttoMaximum"]..(formatNumber(artifactMaximum, '.')).."|r\r"..L["ArticafttoLvL"]..(formatNumber(artifactMaximum - artifactCount, '.'))

		-------------- Parte responsável pelo texto de conhecimento de artefato.
--[[
		local hasTimeleftttp = timeleftString
		if not timeleftString then
			hasTimeleftttp = L["unknown"]
		end

		local knowledgeToottipText = "|r\r"..L["ArticaftKnowledge"]..artifactKnowledge -- Texto normal, se você não estiver pesquisando, mas já tem nível 1 ou mais de conhecimento.
		if resname then -- Se alguma pesquisa estiver em andamento, o texto completo será mostrado.
			knowledgeToottipText = "\r\r".."["..resname.."]|r\r"..L["ArticaftKnowledge"]..artifactKnowledge.."|r\r"..L["researchOn"]..shipmentsReady.."/"..shipmentsTotal.."|r\r"..L["nextResearch"]..hasTimeleftttp
		elseif artifactKnowledge == 50 then -- Se estiver no nível 25, mostrar "max" junto ao texto.
			knowledgeToottipText = "|r\r"..L["ArticaftKnowledge"]..artifactKnowledge.." (|cFF69FF69"..L["maximum"].."!|cFFFFFFFF)"
		elseif artifactKnowledge == 0 then -- Se estiver no 0, não precisa mostrar, não há nem necessidade.
			knowledgeToottipText = ""
		end

		]]--------------

		local hint = L["hint"]
		if TitanGetVar(id, "HideHint") then
			hint = ""
		end

		return hint.."|T"..artifactIcon..":0|t |cFFe6cc80"..weaponName.."|r\r\r"..artifactInfoText--[[..knowledgeToottipText]]--
	else
		return L["noweaponttp"]
	end
end
-----------------------------------------------
local function PrepareMenu(self, id)
	TitanPanelRightClickMenu_AddTitle(TitanPlugins[id].menuText)
	TitanPanelRightClickMenu_AddToggleIcon(id)
	TitanPanelRightClickMenu_AddToggleLabelText(id)

	local info = UIDropDownMenu_CreateInfo();
	info.text = L["simpleText"];
	info.func = function() TitanToggleVar(id, "SimpleText"); TitanPanelButton_UpdateButton(id); end
	info.checked = TitanGetVar(id, "SimpleText");
	L_UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = L["hidehint"];
	info.func = function() TitanToggleVar(id, "HideHint"); TitanPanelButton_UpdateButton(id); end
	info.checked = TitanGetVar(id, "HideHint");
	L_UIDropDownMenu_AddButton(info);
--[[
	local info = UIDropDownMenu_CreateInfo();
	info.text = L["hideknowledge"];
	info.func = function() TitanToggleVar(id, "HideKnowledge"); TitanPanelButton_UpdateButton(id); end
	info.checked = TitanGetVar(id, "HideKnowledge");
	L_UIDropDownMenu_AddButton(info);
]]--
	local info = UIDropDownMenu_CreateInfo();
	info.text = ACE["TITAN_CLOCK_MENU_DISPLAY_ON_RIGHT_SIDE"];
	info.func = function() TitanToggleVar(id, "DisplayOnRightSide"); TitanPanel_InitPanelButtons(id); end
	info.checked = TitanGetVar(id, "DisplayOnRightSide");
	L_UIDropDownMenu_AddButton(info);

	TitanPanelRightClickMenu_AddSpacer()
	TitanPanelRightClickMenu_AddCommand(ACE["TITAN_PANEL_MENU_HIDE"], id, TITAN_PANEL_MENU_FUNC_HIDE);
end
-----------------------------------------------
local function OnClick(self, button)
	if (button == "LeftButton") then
		SocketInventoryItem(16);
	end
end
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mLegion"].." Titan|cFF66b1ea "..L["ArticaftTitle"].."|r",
	tooltip = L["ArticaftTitle"],
	icon = ICON,
	category = "Information",
	version = version,
	onClick = OnClick,
	getButtonText = GetButtonText,
	eventsTable = eventsTable,
	getTooltipText = GetTooltipText,
	prepareMenu = PrepareMenu,
	onUpdate = function() TitanPanelButton_UpdateButton(ID) end,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		ShowLabelText = false,
		SimpleText = false,
		HintText = false,
	--[[	HideKnowledge = false,]]--
	}
})
