--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Spooky Supplies.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_SKYSM"
local spookyToken = 0
local startcurrency = 0
-----------------------------------------------
local function getSpookyToken()
	return GetItemCount(128658, true) or 0
end
-----------------------------------------------
local function GetButtonText(self, id)
	local currencyCountText = TitanUtils_GetHighlightText(spookyToken)

	local barBalanceText = ""
	if TitanGetVar(ID, "ShowBarBalance") then
		if (spookyToken - startcurrency) > 0 then
			barBalanceText = " |cFF69FF69[" .. (spookyToken - startcurrency) .. "]"
		elseif (spookyToken - startcurrency) < 0 then
			barBalanceText = " |cFFFF2e2e[" .. (spookyToken - startcurrency) .. "]"
		end
	end

	return L["SpookyLabel"], currencyCountText .. barBalanceText
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local colorValueAccount = "0" -- Cores da conta de valor

	local dif = spookyToken - startcurrency
	if dif == 0 then
		colorValueAccount = TitanUtils_GetHighlightText("0")
	elseif dif > 0 then
		colorValueAccount = "|cFF69FF69" .. dif
	else
		colorValueAccount = "|cFFFF2e2e" .. dif
	end

	local valorBag = L["totalbag"]..TitanUtils_GetHighlightText(GetItemCount(128658)).."\r"
	local valorBank = L["totalbank"]..TitanUtils_GetHighlightText(GetItemCount(128658, true) - GetItemCount(128658))

	local valueText = "" -- Difere com e sem moeda
	if spookyToken == 0 then
		valueText = L["info"].."|cFFFF2e2e" .. L["HallowEnd"]
	else
		valueText = L["info"]..valorBag..valorBank.."\r".. L["session"]..colorValueAccount
	end

	return L["SpookyDescription"] .. "\r\r" .. valueText
end
-----------------------------------------------
local eventsTable = {
	PLAYER_ENTERING_WORLD = function(self)
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		self.PLAYER_ENTERING_WORLD = nil

		startcurrency = getSpookyToken()
		spookyToken = startcurrency

		TitanPanelButton_UpdateButton(self.registry.id)

		self.BAG_UPDATE = function(self, bagID)
			local supplies = getSpookyToken()

			if spookyToken == supplies then return end
			spookyToken = supplies

			TitanPanelButton_UpdateButton(self.registry.id)
		end
		self:RegisterEvent("BAG_UPDATE")
	end
}
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mEvent"].." Titan|cFF66b1ea " .. L["SpookyTitle"] .. "|r",
	tooltip = L["SpookyTitle"],
	icon = "Interface\\Icons\\inv_misc_bag_28_halloween.blp",
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	prepareMenu = L.PrepareCurrenciesMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		HideMax = false,
		ShowBarBalance = false,
		ShowLabelText = false,
	},
	eventsTable = eventsTable
})
