--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Love Token.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_LTKTM"
local loveToken = 0
local startcurrency = 0
-----------------------------------------------
local function getLove()
	return GetItemCount(49927, true) or 0
end
-----------------------------------------------
local function GetButtonText(self, id)
	local currencyCountText = TitanUtils_GetHighlightText(loveToken)

	local barBalanceText = ""
	if TitanGetVar(ID, "ShowBarBalance") then
		if (loveToken - startcurrency) > 0 then
			barBalanceText = " |cFF69FF69[" .. (loveToken - startcurrency) .. "]"
		elseif (loveToken - startcurrency) < 0 then
			barBalanceText = " |cFFFF2e2e[" .. (loveToken - startcurrency) .. "]"
		end
	end

	return L["LoveLabel"], currencyCountText .. barBalanceText
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local colorValueAccount = "0" -- Cores da conta de valor

	local dif = loveToken - startcurrency
	if dif == 0 then
		colorValueAccount = TitanUtils_GetHighlightText("0")
	elseif dif > 0 then
		colorValueAccount = "|cFF69FF69" .. dif
	else
		colorValueAccount = "|cFFFF2e2e" .. dif
	end

	local valorBag = L["totalbag"]..TitanUtils_GetHighlightText(GetItemCount(49927)).."\r"
	local valorBank = L["totalbank"]..TitanUtils_GetHighlightText(GetItemCount(49927, true) - GetItemCount(49927))

	local valueText = "" -- Difere com e sem moeda
	if loveToken == 0 then
		valueText = L["info"].."|cFFFF2e2e"..L["NoLove"]
	else
		valueText = L["info"]..valorBag..valorBank.."\r"..L["session"]..colorValueAccount
	end

	return L["LoveDescription"] .. "\r\r" .. valueText
end
-----------------------------------------------
local eventsTable = {
	PLAYER_ENTERING_WORLD = function(self)
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		self.PLAYER_ENTERING_WORLD = nil

		startcurrency = getLove()
		loveToken = startcurrency

		TitanPanelButton_UpdateButton(self.registry.id)

		self.BAG_UPDATE = function(self, bagID)
			local love = getLove()

			if loveToken == love then return end
			loveToken = love

			TitanPanelButton_UpdateButton(self.registry.id)
		end
		self:RegisterEvent("BAG_UPDATE")
	end
}
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mEvent"].." Titan|cFF66b1ea " .. L["LoveTitle"] .. "|r",
	tooltip = L["LoveTitle"],
	icon = "Interface\\Icons\\inv_valentinescard01.blp",
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	prepareMenu = L.PrepareCurrenciesMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		HideMax = false,
		ShowBarBalance = false,
		ShowLabelText = false,
	},
	eventsTable = eventsTable
})
