--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Darkmoon Ticket Prize.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "DT"
local ICON = "Interface\\Icons\\inv_misc_ticket_darkmoon_01"
local CURRENCY_ID = 515
local currencyCount = 0.0
local startcurrency
-----------------------------------------------
local function Util_StringComDefault(v,d)
	if not v then
		return d
	end

	return v
end
-----------------------------------------------
local eventsTable = {
	CURRENCY_DISPLAY_UPDATE = function(self)
		local name, amount, texturePath, earnedThisWeek, weeklyMax, totalMax, isDiscovered = GetCurrencyInfo(CURRENCY_ID)

		currencyCount = amount or 0
		if not startcurrency then startcurrency = currencyCount end

		TitanPanelButton_UpdateButton(self.registry.id)
	end
}
-----------------------------------------------
local function GetButtonText(self, id)
	local currencyCountText
	if not currencyCount then
		currencyCountText = TitanUtils_GetHighlightText("0")
	else
		currencyCountText = TitanUtils_GetHighlightText(currencyCount)
	end

	local BarBalanceText = ""
	if TitanGetVar(ID, "ShowBarBalance") then
		if (currencyCount - startcurrency) > 0 then
			BarBalanceText = " |cFF69FF69["..(currencyCount - startcurrency).."]"
		elseif (currencyCount - startcurrency) < 0 then
			BarBalanceText = " |cFFFF2e2e["..(currencyCount - startcurrency).."]"
		end
	end

	return L["DarkmoonLabel"], currencyCountText..BarBalanceText
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local ColorValueAccount = "0" -- Cores da conta de valor
	if currencyCount and startcurrency then
		local dif = currencyCount - startcurrency
		if dif == 0 then
			ColorValueAccount = TitanUtils_GetHighlightText("0")
		elseif dif > 0 then
			ColorValueAccount = "|cFF69FF69"..dif
		else
			ColorValueAccount = "|cFFFF2e2e"..dif
		end
	end

	local valorAtual = TitanUtils_GetHighlightText(Util_StringComDefault(currencyCount, "0"))

	local ValueText = "" -- Difere com e sem moeda
	if valorAtual == TitanUtils_GetHighlightText("0") then
		ValueText = L["info"].."|cFFFF2e2e"..L["NoTickets"]
	else
		ValueText = L["info"]..L["totalAcquired"]..valorAtual.."\r"..L["session"]..ColorValueAccount
	end

	return L["DarkmoonDescription"].."\r\r"..ValueText
end
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mEvent"].." Titan|cFF66b1ea "..L["DarkmoonTitle"].."|r",
	tooltip = L["DarkmoonTitle"],
	icon = ICON,
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	eventsTable = eventsTable,
	prepareMenu = L.PrepareCurrenciesMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		ShowBarBalance = false,
		ShowLabelText = false,
	}
})
