--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Coin of Ancestry.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_COAYM"
local ancestryToken = 0
local startcurrency = 0
-----------------------------------------------
local function getAncestryToken()
	return GetItemCount(21100, true) or 0
end
-----------------------------------------------
local function GetButtonText(self, id)
	local currencyCountText = TitanUtils_GetHighlightText(ancestryToken)

	local barBalanceText = ""
	if TitanGetVar(ID, "ShowBarBalance") then
		if (ancestryToken - startcurrency) > 0 then
			barBalanceText = " |cFF69FF69[" .. (ancestryToken - startcurrency) .. "]"
		elseif (ancestryToken - startcurrency) < 0 then
			barBalanceText = " |cFFFF2e2e[" .. (ancestryToken - startcurrency) .. "]"
		end
	end

	return L["BrewLabel"], currencyCountText .. barBalanceText
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local colorValueAccount = "0" -- Cores da conta de valor

	local dif = ancestryToken - startcurrency
	if dif == 0 then
		colorValueAccount = TitanUtils_GetHighlightText("0")
	elseif dif > 0 then
		colorValueAccount = "|cFF69FF69" .. dif
	else
		colorValueAccount = "|cFFFF2e2e" .. dif
	end

	local valorBag = L["totalbag"]..TitanUtils_GetHighlightText(GetItemCount(21100)).."\r"
	local valorBank = L["totalbank"]..TitanUtils_GetHighlightText(GetItemCount(21100, true) - GetItemCount(21100))

	local valueText = "" -- Difere com e sem moeda
	if ancestryToken == 0 then
		valueText = L["info"].."|cFFFF2e2e" .. L["NoAncestry"]
	else
		valueText = L["info"]..valorBag..valorBank.."\r\r".. L["session"]..colorValueAccount
	end

	return L["AncestryDescription"] .. "\r\r" .. valueText
end
-----------------------------------------------
local eventsTable = {
	PLAYER_ENTERING_WORLD = function(self)
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		self.PLAYER_ENTERING_WORLD = nil

		startcurrency = getAncestryToken()
		ancestryToken = startcurrency

		TitanPanelButton_UpdateButton(self.registry.id)

		self.BAG_UPDATE = function(self, bagID)
			local coin = getAncestryToken()

			if ancestryToken == coin then return end
			ancestryToken = coin

			TitanPanelButton_UpdateButton(self.registry.id)
		end
		self:RegisterEvent("BAG_UPDATE")
	end
}
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mEvent"].." Titan|cFF66b1ea "..L["AncestryTitle"].."|r",
	tooltip = L["AncestryTitle"],
	icon = "Interface\\Icons\\inv_misc_elvencoins.blp",
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	prepareMenu = L.PrepareCurrenciesMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		HideMax = false,
		ShowBarBalance = false,
		ShowLabelText = false,
	},
	eventsTable = eventsTable
})
