--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Brewfest Prize Token.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_BWFTM"
local brewToken = 0
local startcurrency = 0
-----------------------------------------------
local function getBrewToken()
	return GetItemCount(37829, true) or 0
end
-----------------------------------------------
local function GetButtonText(self, id)
	local currencyCountText = TitanUtils_GetHighlightText(brewToken)

	local barBalanceText = ""
	if TitanGetVar(ID, "ShowBarBalance") then
		if (brewToken - startcurrency) > 0 then
			barBalanceText = " |cFF69FF69[" .. (brewToken - startcurrency) .. "]"
		elseif (brewToken - startcurrency) < 0 then
			barBalanceText = " |cFFFF2e2e[" .. (brewToken - startcurrency) .. "]"
		end
	end

	return L["BrewLabel"], currencyCountText .. barBalanceText
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local colorValueAccount = "0" -- Cores da conta de valor

	local dif = brewToken - startcurrency
	if dif == 0 then
		colorValueAccount = TitanUtils_GetHighlightText("0")
	elseif dif > 0 then
		colorValueAccount = "|cFF69FF69" .. dif
	else
		colorValueAccount = "|cFFFF2e2e" .. dif
	end

	local valorBag = L["totalbag"]..TitanUtils_GetHighlightText(GetItemCount(37829)).."\r"
	local valorBank = L["totalbank"]..TitanUtils_GetHighlightText(GetItemCount(37829, true) - GetItemCount(37829))

	local valueText = "" -- Difere com e sem moeda
	if brewToken == 0 then
		valueText = L["info"].."|cFFFF2e2e"..L["NoToken"]
	else
		valueText = L["info"]..valorBag..valorBank.."\r\r"..L["session"]..colorValueAccount
	end

	return L["BrewDescription"] .. "\r\r" .. valueText
end
-----------------------------------------------
local eventsTable = {
	PLAYER_ENTERING_WORLD = function(self)
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		self.PLAYER_ENTERING_WORLD = nil

		startcurrency = getBrewToken()
		brewToken = startcurrency

		TitanPanelButton_UpdateButton(self.registry.id)

		self.BAG_UPDATE = function(self, bagID)
			local token = getBrewToken()

			if brewToken == token then return end
			brewToken = token

			TitanPanelButton_UpdateButton(self.registry.id)
		end
		self:RegisterEvent("BAG_UPDATE")
	end
}
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mEvent"].." Titan|cFF66b1ea "..L["BrewTitle"].."|r",
	tooltip = L["BrewTitle"],
	icon = "Interface\\Icons\\inv_misc_coin_01.blp",
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	prepareMenu = L.PrepareCurrenciesMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		HideMax = false,
		ShowBarBalance = false,
		ShowLabelText = false,
	},
	eventsTable = eventsTable
})
