--[[
Description: This plugin is part of the "Titan Panel [Currencies] Multi" addon. It shows your amount of Primal Spirit.
Site: http://www.curse.com/addons/wow/titan-panel-currencies-multi
Author: Canettieri
Special Thanks to Eliote.
--]]

local ADDON_NAME, L = ...;
local version = GetAddOnMetadata(ADDON_NAME, "Version")
local ID = "TITAN_PRPTM"
local primalSpirit = 0
local startcurrency
-----------------------------------------------
local function getPrimalSpirit()
	return GetItemCount(120945, true) or 0
end
-----------------------------------------------
local function GetButtonText(self, id)
	local currencyCountText
	if not primalSpirit then
		currencyCountText = TitanUtils_GetHighlightText("0")
	else
		currencyCountText = TitanUtils_GetHighlightText(primalSpirit)
	end

	local BarBalanceText = ""
	if TitanGetVar(ID, "ShowBarBalance") then
		if (primalSpirit - startcurrency) > 0 then
			BarBalanceText = " |cFF69FF69["..(primalSpirit - startcurrency).."]"
		elseif (primalSpirit - startcurrency) < 0 then
			BarBalanceText = " |cFFFF2e2e["..(primalSpirit - startcurrency).."]"
		end
	end

	return L["SpiritLabel"], currencyCountText..BarBalanceText
end
-----------------------------------------------
local function GetTooltipText(self, id)
	local colorValueAccount = "0" -- Cores da conta de valor

	local dif = primalSpirit - startcurrency
	if dif == 0 then
		colorValueAccount = TitanUtils_GetHighlightText("0")
	elseif dif > 0 then
		colorValueAccount = "|cFF69FF69" .. dif
	else
		colorValueAccount = "|cFFFF2e2e" .. dif
	end

	local valorBag = L["totalbag"]..TitanUtils_GetHighlightText(GetItemCount(120945)).."\r"
	local valorBank = L["totalbank"]..TitanUtils_GetHighlightText(GetItemCount(120945, true) - GetItemCount(120945))

	local ValueText = "" -- Difere com e sem moeda
	if primalSpirit == 0 then
		ValueText = L["info"].."|cFFFF2e2e"..L["DraenorOnly"]
	else
		ValueText = L["info"]..valorBag..valorBank.."\r\r".. L["session"]..colorValueAccount
	end

	return L["SpiritDescription"].."\r\r"..ValueText
end
-----------------------------------------------
local eventsTable = {
	PLAYER_ENTERING_WORLD = function(self)
		self:UnregisterEvent("PLAYER_ENTERING_WORLD")
		self.PLAYER_ENTERING_WORLD = nil

		startcurrency = getPrimalSpirit()
		primalSpirit = startcurrency

		TitanPanelButton_UpdateButton(self.registry.id)

		self.BAG_UPDATE = function(self, bagID)
			local spirit = getPrimalSpirit()

			if primalSpirit == spirit then return end
			primalSpirit = spirit

			TitanPanelButton_UpdateButton(self.registry.id)
		end
		self:RegisterEvent("BAG_UPDATE")
	end
}
-----------------------------------------------
L.Elib({
	id = ID,
	name = L["mWoD"].." Titan|cFF66b1ea "..L["SpiritTitle"].."|r",
	tooltip = L["SpiritTitle"],
	icon = "Interface\\Icons\\6bf_explosive_shard.blp",
	category = "Information",
	version = version,
	getButtonText = GetButtonText,
	getTooltipText = GetTooltipText,
	prepareMenu = L.PrepareCurrenciesMenu,
	savedVariables = {
		ShowIcon = 1,
		DisplayOnRightSide = false,
		HideMax = false,
		ShowBarBalance = false,
		ShowLabelText = false,
	},
	eventsTable = eventsTable
})
