-- functions to manage tab interfaces where only one tab of a group may be selected
function Tab_PanelTemplates_Tab_OnClick(self, frame)
	Tab_PanelTemplates_SetTab(frame, self:GetID())
end

function Tab_PanelTemplates_SetTab(frame, id)
	frame.selectedTab = id;
	Tab_PanelTemplates_UpdateTabs(frame);
end

function Tab_PanelTemplates_GetSelectedTab(frame)
	return frame.selectedTab;
end

local function GetTabByIndex(frame, index)
	return frame.Tabs and frame.Tabs[index] or _G[frame:GetName().."Tab"..index];
end
 
function Tab_PanelTemplates_UpdateTabs(frame)
	--print("Tab_PanelTemplates_UpdateTabs", frame:GetName(), frame.selectedTab)
	if ( frame.selectedTab ) then
		local tab;
		for i=1, frame.numTabs, 1 do
			tab = GetTabByIndex(frame, i);
			if ( tab.isDisabled ) then
				Tab_PanelTemplates_SetDisabledTabState(tab);
			elseif ( i == frame.selectedTab ) then
				Tab_PanelTemplates_SelectTab(tab);
			else
				Tab_PanelTemplates_DeselectTab(tab);
			end
		end
	end
end

function Tab_PanelTemplates_GetTabWidth(tab)
	local tabName = tab:GetName();

	local sideWidths = 2 * tab.texLeft:GetWidth() --_G[tabName.."Left"]:GetWidth();
	return tab:GetTextWidth() + sideWidths;
end

function Tab_PanelTemplates_TabResize(tab, padding, absoluteSize, minWidth, maxWidth, absoluteTextSize)
	local tabName = tab:GetName();
	
	local buttonMiddle = tab.texMiddle --_G[tabName.."Middle"];
	local buttonMiddleDisabled = tab.texMiddleDisabled --_G[tabName.."MiddleDisabled"];
	local sideWidths = 2 * tab.texLeft:GetWidth() --_G[tabName.."Left"]:GetWidth();
	local tabText = tab.buttonText --_G[tab:GetName().."Text"];
	local width, tabWidth;
	local textWidth;
	if ( absoluteTextSize ) then
		textWidth = absoluteTextSize;
	else
		tabText:SetWidth(0);
		textWidth = tabText:GetWidth();
	end
	-- If there's an absolute size specified then use it
	if ( absoluteSize ) then
		if ( absoluteSize < sideWidths) then
			width = 1;
			tabWidth = sideWidths
		else
			width = absoluteSize - sideWidths;
			tabWidth = absoluteSize
		end
		tabText:SetWidth(width);
	else
		-- Otherwise try to use padding
		if ( padding ) then
			width = textWidth + padding;
		else
			width = textWidth + 24;
		end
		-- If greater than the maxWidth then cap it
		if ( maxWidth and width > maxWidth ) then
			if ( padding ) then
				width = maxWidth + padding;
			else
				width = maxWidth + 24;
			end
			tabText:SetWidth(width);
		else
			tabText:SetWidth(0);
		end
		if (minWidth and width < minWidth) then
			width = minWidth;
		end
		tabWidth = width + sideWidths;
	end
	
	if ( buttonMiddle ) then
		buttonMiddle:SetWidth(width);
	end
	if ( buttonMiddleDisabled ) then
		buttonMiddleDisabled:SetWidth(width);
	end
	
	tab:SetWidth(tabWidth);
	local highlightTexture = _G[tabName.."HighlightTexture"];
	if ( highlightTexture ) then
		highlightTexture:SetWidth(tabWidth);
	end
end

function Tab_PanelTemplates_SetNumTabs(frame, numTabs)
	frame.numTabs = numTabs;
end

function Tab_PanelTemplates_DisableTab(frame, index)
	GetTabByIndex(frame, index).isDisabled = 1;
	Tab_PanelTemplates_UpdateTabs(frame);
end

function Tab_PanelTemplates_EnableTab(frame, index)
	local tab = GetTabByIndex(frame, index);
	tab.isDisabled = nil;
	-- Reset text color
	tab:SetDisabledFontObject(GameFontHighlightSmall);
	Tab_PanelTemplates_UpdateTabs(frame);
end

function Tab_PanelTemplates_HideTab(frame, index)
	local tab = GetTabByIndex(frame, index);
	tab:Hide();
end

function Tab_PanelTemplates_ShowTab(frame, index)
	local tab = GetTabByIndex(frame, index);
	tab:Show();
end
 
function Tab_PanelTemplates_DeselectTab(tab)
	local name = tab:GetName();
	
	local left = tab.texLeft --or _G[name.."Left"];
	local middle = tab.texMiddle --or _G[name.."Middle"];
	local right = tab.texRight --or _G[name.."Right"];
	left:Show();
	middle:Show();
	right:Show();
	--tab:UnlockHighlight();
	tab:Enable();
	local text = tab.buttonText --or _G[name.."Text"];
	--text:SetPoint("CENTER", tab, "CENTER", (tab.deselectedTextX or 0), (tab.deselectedTextY or 2));
	text:SetPoint("CENTER", tab, "CENTER", (tab.selectedTextX or 0), (tab.selectedTextY or -3))
	
	local leftDisabled = tab.LeftDisabled or _G[name.."LeftDisabled"];
	local middleDisabled = tab.MiddleDisabled or _G[name.."MiddleDisabled"];
	local rightDisabled = tab.RightDisabled or _G[name.."RightDisabled"];
	leftDisabled:Hide();
	middleDisabled:Hide();
	rightDisabled:Hide(); 
end

function Tab_PanelTemplates_SelectTab(tab)
	--print("Tab_PanelTemplates_SelectTab", tab:GetName(), tab:GetID())
	--local name = tab:GetName();
	
	local left = tab.texLeft --or _G[name.."Left"];
	local middle = tab.texMiddle --or _G[name.."Middle"];
	local right = tab.texRight --or _G[name.."Right"];
	left:Hide();
	middle:Hide();
	right:Hide();
	--tab:LockHighlight();
	tab:Disable();
	tab:SetDisabledFontObject(GameFontHighlightSmall);
	local text = tab.buttonText --or _G[name.."Text"];
	--text:SetPoint("CENTER", tab, "CENTER", (tab.selectedTextX or 0), (tab.selectedTextY or -3));
	text:SetPoint("CENTER", tab, "CENTER", (tab.deselectedTextX or 0), (tab.deselectedTextY or 2))
	
	local leftDisabled = tab.texLeftDisabled --or _G[name.."LeftDisabled"];
	local middleDisabled = tab.texMiddleDisabled --or _G[name.."MiddleDisabled"];
	local rightDisabled = tab.texRightDisabled --or _G[name.."RightDisabled"];
	leftDisabled:Show();
	middleDisabled:Show();
	rightDisabled:Show();
	
	if ( GameTooltip and GameTooltip:IsOwned(tab) ) then
		GameTooltip:Hide();
	end 
end

function Tab_PanelTemplates_SetDisabledTabState(tab)
	--local name = tab:GetName();
	local left = tab.texLeft --or _G[name.."Left"];
	local middle = tab.texMiddle --or _G[name.."Middle"];
	local right = tab.texRight --or _G[name.."Right"];
	left:Show();
	middle:Show();
	right:Show();
	--tab:UnlockHighlight();
	tab:Disable();
	tab.text = tab:GetText();
	-- Gray out text
	tab:SetDisabledFontObject(GameFontDisableSmall);
	local leftDisabled = tab.texLeftDisabled --or _G[name.."LeftDisabled"];
	local middleDisabled = tab.texMiddleDisabled --or _G[name.."MiddleDisabled"];
	local rightDisabled = tab.texRightDisabled --or _G[name.."RightDisabled"];
	leftDisabled:Hide();
	middleDisabled:Hide();
	rightDisabled:Hide(); 
end
