local SpellIdToButton = {}

local p_timestamp 		= 1
local p_event			= 2
local p_hideCaster      = 3
local p_sourceGUID      = 4 --Player-XX-XXXXXXXX, Vehicle-X-X...
local p_sourceName      = 5
local p_sourceFlags     = 6
local p_sourceRaidFlags = 7
local p_destGUID        = 8 --Vehicle-X-X...
local p_destName        = 9
local p_destFlags       = 10
local p_destRaidFlags   = 11

--offset 12-13(enviroinmental)
local p_spell_offset	= 11
local p_spell_id		= 1
local p_spell_name		= 2
local p_spell_school	= 3

local p_spell_effect_offset	= 14
local p_swing_effect_offset	= 12

local p_effect_amount	= 1
local p_effect_overkill	= 2
local p_effect_school	= 3

local p_buff_offset		= 15

local AVERAGE_COUNT_MAX = 10

local spell_effects = {}

function TinyExtraBars_AddButtonToSpellIds(btn, id)
	if not(id) then
		id = btn.id
	end
	if id then
		local name, rank = GetSpellInfo(id)
		--print("TinyExtraBars_AddButtonToSpellIds", btn:GetName(), name)
		if name then
			SpellIdToButton[name] = SpellIdToButton[name] or {}
			SpellIdToButton[name][btn:GetName()] = btn
		end
	end
end

function TinyExtraBars_RemoveButtonFromSpellIds(btn, id)
	if not(id) then
		id = btn.id
	end
	if id and (type(SpellIdToButton[id]) == "table") then
		local name, rank = GetSpellInfo(id)
		SpellIdToButton[name][btn:GetName()] = nil
	end
end

local function GetFormattedValue(v)
	if v < 1000 then
		return string.format("%d", v)
	elseif v < 10000 then
		return string.format("%.2fk", v / 1000)
	elseif v < 100000 then
		return string.format("%.1fk", v / 1000)
	elseif v < 1000000 then
		return string.format("%dk", v / 1000)
	else
		return string.format("%.2fm", v / 1000000)
	end
end

local function SetButtonText(name, text)
	--print("SetButtonText", name)
	if type(SpellIdToButton[name]) == "table" then
		for k, btn in pairs(SpellIdToButton[name]) do
			if btn then
				--print("button found", btn:GetName())
				if TEB_LastEffectMode then
					btn.damagetext:SetText(text)
					btn.damagetext:Show()
				else
					btn.damagetext:Hide()
				end
			end
		end
	end
end

function TEBLE_ResetSpell(name)
	if not(name) then
		return
	end
	
	--reset amounts by spell on next cast
	if spell_effects[name] then
		spell_effects[name].damage.current = 0
		spell_effects[name].heal.current = 0
	end
end

local function ShowEffect(name)
	if spell_effects[name] then
		--calculate accumulated and show
		if spell_effects[name].damage.current > 0 and spell_effects[name].damage.prev > 0 then
			SetButtonText(name, GetFormattedValue(spell_effects[name].damage.prev))
		elseif spell_effects[name].heal.current > 0 and spell_effects[name].heal.prev > 0 then
			SetButtonText(name, GetFormattedValue(spell_effects[name].heal.prev))
		end
	end
end

function TEBLE_InitAndShowSpell(name)
	--print("TEBLE_InitAndShowSpell", name)
	if not(name) then
		return
	end
	
	spell_effects[name] = spell_effects[name] or {}
	spell_effects[name].damage = spell_effects[name].damage or {["current"] = 0, ["prev"] = 0, ["count"] = 0}
	spell_effects[name].heal = spell_effects[name].heal or {["current"] = 0, ["prev"] = 0, ["count"] = 0}
	--update amounts by spell
	if spell_effects[name].damage.current > 0 then
		local t = spell_effects[name].damage
		if TEB_LastEffectAverageMode then
			if t.count < AVERAGE_COUNT_MAX then
				t.count = t.count + 1
			end
			if t.prev == 0 then
				t.prev = t.current
			else
				t.prev = (t.prev * t.count + t.current) / (t.count + 1)
				--print(t.prev, t.current, t.count)
			end
		else
			t.prev = t.current
		end
	end
	if spell_effects[name].heal.current > 0 then
		local t = spell_effects[name].heal
		if TEB_LastEffectAverageMode then
			if t.count < AVERAGE_COUNT_MAX then
				t.count = t.count + 1
			end
			if t.prev == 0 then
				t.prev = t.current
			else
				t.prev = (t.prev * t.count + t.current) / (t.count + 1)
			end
		else
			t.prev = t.current
		end
	end
	ShowEffect(name)
end

local SummonedGUID
local SummonedName

function TEBLE_EventCombatLog(self, ...)
	
	local args = {...}
	
	local petguid = UnitGUID("pet")
	local playerGuid = UnitGUID("player")
	local sourceGUID = args[p_sourceGUID]
	--print(sourceGUID)
	if sourceGUID ~= playerGuid and sourceGUID ~= petguid and sourceGUID ~= SummonedGUID then
		return
	end
	
	--print all
	--local temp = ""
	--for i = 1, #args do
	--	temp = temp..i.." = "..tostring(args[i])..", "
	--end
	--print(temp)
	
	local events = {strsplit("_", args[p_event])}
	local event_type = events[1]
	
	--print partial
	if TEB_SpellDebug then
		local temp = tostring(args[p_event])..", "..tostring(args[p_spell_offset + p_spell_id])..", "..tostring(args[p_spell_offset + p_spell_name])
		if #args >= p_buff_offset then
			temp = temp..", "..tostring(args[p_buff_offset])
		end
		print(temp)
	end
	
	if event_type == "SPELL" or event_type == "SWING" then
		local effect_name 
		if sourceGUID == SummonedGUID then
			effect_name = SummonedName
		else
			effect_name = args[p_spell_offset + p_spell_name]
		end
		local name = TEBLE_SpellPartOf[effect_name] or effect_name
		--if TEB_SpellDebug then
		--	print(effect_name, "added to", effect_name)
		--end

		--print(name)
		local e = events[2]
		if e == "CAST" then
			local r = events[3]
			if r == "FAILED" then
				--print('reset: failed', name)
				TEBLE_ResetSpell(name)
			end
		end
		
		if e == "PERIODIC" then
			e = events[3]
		end
		
		if e == "SUMMON" then
			SummonedGUID = args[8]
			SummonedName = args[13]
			--print("Summoned", SummonedGUID, SummonedName)
		end
		
		--spell_effects[name] init on click
		if not(spell_effects[name]) then
			--some proc spell, not exists in buttons or LE_SpellPartOf
			return
		end
		
		local effect_offset
		if event_type == "SPELL" then
			effect_offset = p_spell_effect_offset
		elseif event_type == "SWING" then
			effect_offset = p_swing_effect_offset
		else
			return
		end		

	if e == "DAMAGE" then
			--inc damage
			spell_effects[name].damage.current = spell_effects[name].damage.current + args[effect_offset + p_effect_amount]
			--print("damage", spell_effects[name].damage.current)
		elseif e == "HEAL" then
			--inc heal
			spell_effects[name].heal.current = spell_effects[name].heal.current + args[effect_offset + p_effect_amount]
			--print("heal", spell_effects[name].heal.current)
		end
	end
end

