--[[ Common ]]

--const
TEB_DEFAULT_BUTTON_SIZE 	= 36
TEB_DEFAULT_BUTTON_SPACING 	= 4
TEB_HEIGHT_EXTRA 			= 35
TEB_WIDTH_EXTRA 			= 20
TEB_MAX_ROWS 				= 12
TEB_MAX_COLS 				= 12

TEB_ACCEPTABLE_COMMANDS = {
	["spell"] = true,
	["item"] = true,
	["macro"] = true,
	["macrotext"] = true,
	--["companion"] = true,
	["equipmentset"] = true,
	["battlepet"] = true,
	--["mount"] = true,
}

local SpellCacheToSlot = {}

function TinyExtraBars_GetFullSpellName(name, rank)
	--[[if not(rank) then
		rank = ""
	end
	if (name) then
		return name.."("..rank..")"
	end
	return nil, nil]]
	return name
end

function TinyExtraBars_GetSpellNameById(id)
	local name, rank = GetSpellInfo(id)
	return TinyExtraBars_GetFullSpellName(name, rank)
end

local function GetMountIndexBySpellID(id)
	local creatureName, spellID, _, mountID
	for i = 1, C_MountJournal.GetNumMounts() do
		creatureName, spellID, _, _, _, _, _, _, _, _, _, mountID = C_MountJournal.GetDisplayedMountInfo(i)
		--print("GetMountIndexBySpellID", creatureName, spellID, mountID)
		if id == spellID then
			return i, mountID;
		end
	end
end

function TinyExtraBars_SetCursor(command, value, subValue, id)
	--print("SetCursorValues", command, value, subValue, id)
	if not(command) then
		return
	end

	ClearCursor()
	if (command == "spell") then
		local mountIndex, mountID = GetMountIndexBySpellID(id)
		if mountIndex then
			--print(mountIndex, mountID)
			C_MountJournal.Pickup(mountIndex)
		else
			--local name, rank = GetSpellInfo(id)
			--print(name, rank)
			--PickupSpell(name..'('..rank..')')
			PickupSpell(id)
			local cmd, v, s, i = GetCursorInfo()
			if not v then
				PickupSpell(value)
			end
		end
	elseif (command == "item") then
		if PlayerHasToy(value) then
			C_ToyBox.PickupToyBoxItem(value)	--itemID
		else
			PickupItem(value)	--itemID or "itemString" or "itemName" or "itemLink"
		end
	elseif (command == "macro") then
		PickupMacro(value)
	elseif (command == "equipmentset") then
		PickupEquipmentSetByName(value)
	elseif (command == "battlepet") then
		C_PetJournal.PickupPet(value)
	end
end

function TinyExtraBars_GetCursorValues()
	local command, value, subValue, id = GetCursorInfo()
	--print("GetCursorValues", command, value, subValue, id)
	if (command == "spell") then
		value = TinyExtraBars_GetSpellNameById(id)
	--elseif (command == "item") or (command == "equipmentset") then
		--nothing to do
	elseif (command == "macro") then		
		subValue = value -- value is macro index	
		value = GetMacroInfo(value) --name, texture, body
	elseif (command == "mount") then
		command = "spell"		
		value, id = C_MountJournal.GetMountInfoByID(value) --creatureName, spellID
		subValue = "spell"
		--print(command, value, subValue, id)
	end
	return command, value, subValue, id
end

function TinyExtraBars_GetButtonsTotalSize(count, size, spacing)
	return count * size + (count + 1) * spacing
end

function TinyExtraBars_GetButtonsCountByLen(len, size, spacing)
	local count = math.floor((len - TEB_WIDTH_EXTRA)/(size + spacing))
	if count <= 0 then
		count = 1
	elseif count > TEB_MAX_COLS then
		count = TEB_MAX_COLS
	end
	return count
end
