local E, L, V, P, G = unpack(ElvUI)
local TTUIRM = E:GetModule('ThinkTankUI Remastered');
local EP = LibStub("LibElvUIPlugin-1.0")
local addon = ...

local pairs, tinsert, tremove, unpack = pairs, tinsert, tremove, unpack
local format = format
local _G = _G
local ceil, format, checkTable = ceil, format, next
local tinsert, twipe, tsort, tconcat = table.insert, table.wipe, table.sort, table.concat

-- WoW API / Variables
local IsAddOnLoaded = IsAddOnLoaded
local ReloadUI = ReloadUI
local FCF_SetLocked = FCF_SetLocked
local FCF_DockFrame, FCF_UnDockFrame = FCF_DockFrame, FCF_UnDockFrame
local FCF_SavePositionAndDimensions = FCF_SavePositionAndDimensions
local FCF_GetChatWindowInfo = FCF_GetChatWindowInfo
local FCF_StopDragging = FCF_StopDragging
local FCF_SetChatWindowFontSize = FCF_SetChatWindowFontSize
local NUM_CHAT_WINDOWS = NUM_CHAT_WINDOWS
local ADDONS, LOOT, TRADE, TANK, HEALER = ADDONS, LOOT, TRADE, TANK, HEALER

local function SetupChat()
	for i = 1, NUM_CHAT_WINDOWS do
		local frame = _G[format("ChatFrame%s", i)]
		local chatFrameId = frame:GetID()
		local chatName = FCF_GetChatWindowInfo(chatFrameId)

		FCF_SetChatWindowFontSize(nil, frame, 11)

		-- move ElvUI default loot frame to the left chat, so that Recount/Skada can go to the right chat.
		if i == 3 and chatName == LOOT.." / "..TRADE then
			FCF_UnDockFrame(frame)
			frame:ClearAllPoints()
			frame:Point("BOTTOMLEFT", LeftChatToggleButton, "TOPLEFT", 1, 3)
			FCF_SetWindowName(frame, LOOT)
			FCF_DockFrame(frame)
			if not frame.isLocked then
				FCF_SetLocked(frame, 1)
			end
			frame:Show()
		end
		FCF_SavePositionAndDimensions(frame)
		FCF_StopDragging(frame)
	end
	ChatFrame_RemoveChannel(ChatFrame3, L["Trade"])
	ChatFrame_AddChannel(ChatFrame1, L["Trade"])
	ChatFrame_AddMessageGroup(ChatFrame1, "TARGETICONS")
	ChatFrame_AddMessageGroup(ChatFrame3, "COMBAT_FACTION_CHANGE")
	ChatFrame_AddMessageGroup(ChatFrame3, "COMBAT_GUILD_XP_GAIN")
	ChatFrame_AddMessageGroup(ChatFrame3, "COMBAT_HONOR_GAIN")
	ChatFrame_AddMessageGroup(ChatFrame3, "COMBAT_XP_GAIN")
	ChatFrame_AddMessageGroup(ChatFrame3, "CURRENCY")
	ChatFrame_AddMessageGroup(ChatFrame3, "LOOT")
	ChatFrame_AddMessageGroup(ChatFrame3, "MONEY")
	ChatFrame_AddMessageGroup(ChatFrame3, "SKILL")

	-- Enable classcolor automatically on login and on each character without doing /configure each time
	ToggleChatColorNamesByClassGroup(true, "ACHIEVEMENT")
	ToggleChatColorNamesByClassGroup(true, "BATTLEGROUND_LEADER")
	ToggleChatColorNamesByClassGroup(true, "BATTLEGROUND")
	ToggleChatColorNamesByClassGroup(true, "CHANNEL1")
	ToggleChatColorNamesByClassGroup(true, "CHANNEL10")
	ToggleChatColorNamesByClassGroup(true, "CHANNEL11")
	ToggleChatColorNamesByClassGroup(true, "CHANNEL2")
	ToggleChatColorNamesByClassGroup(true, "CHANNEL3")
	ToggleChatColorNamesByClassGroup(true, "CHANNEL4")
	ToggleChatColorNamesByClassGroup(true, "CHANNEL5")
	ToggleChatColorNamesByClassGroup(true, "CHANNEL6")
	ToggleChatColorNamesByClassGroup(true, "CHANNEL7")
	ToggleChatColorNamesByClassGroup(true, "CHANNEL8")
	ToggleChatColorNamesByClassGroup(true, "CHANNEL9")
	ToggleChatColorNamesByClassGroup(true, "EMOTE")
	ToggleChatColorNamesByClassGroup(true, "GUILD_ACHIEVEMENT")
	ToggleChatColorNamesByClassGroup(true, "GUILD")
	ToggleChatColorNamesByClassGroup(true, "INSTANCE_CHAT_LEADER")
	ToggleChatColorNamesByClassGroup(true, "INSTANCE_CHAT")
	ToggleChatColorNamesByClassGroup(true, "OFFICER")
	ToggleChatColorNamesByClassGroup(true, "PARTY_LEADER")
	ToggleChatColorNamesByClassGroup(true, "PARTY")
	ToggleChatColorNamesByClassGroup(true, "RAID_LEADER")
	ToggleChatColorNamesByClassGroup(true, "RAID_WARNING")
	ToggleChatColorNamesByClassGroup(true, "RAID")
	ToggleChatColorNamesByClassGroup(true, "SAY")
	ToggleChatColorNamesByClassGroup(true, "WHISPER")
	ToggleChatColorNamesByClassGroup(true, "YELL")
	--chat options--
	
	E.db["chat"]["tabFontOutline"] = "OUTLINE"
	E.db["chat"]["keywordSound"] = "Whisper Alert"
	E.db["chat"]["timeStampFormat"] = "%H:%M "
	E.db["chat"]["tabFontSize"] = 11
	E.db["chat"]["editBoxPosition"] = "ABOVE_CHAT"
	E.db["chat"]["panelTabTransparency"] = true
	E.db["chat"]["panelHeight"] = 175
	E.db["chat"]["panelWidthRight"] = 400
	E.db["chat"]["chatHistory"] = false
	E.db["chat"]["keywords"] = "%MYNAME%, ElvUI, ThinkTankUI"
	E.db["chat"]["panelHeightRight"] = 175
	E.db["chat"]["font"] = "Expressway"
	E.db["chat"]["copyChatLines"] = true
	E.db["chat"]["tabFont"] = "Expressway"
	E.db["chat"]["separateSizes"] = true
	E.db["chat"]["panelWidth"] = 400
		
	PluginInstallStepComplete.message = TTUIRM.Title..L['Chat Set']
	PluginInstallStepComplete:Show()
	E:UpdateAll(true)
	end
	
	
local function SetupLayout()
		-- common settings
		E.db["databars"]["artifact"]["height"] = 178
		E.db["databars"]["artifact"]["width"] = 8
		E.db["databars"]["experience"]["height"] = 5
		E.db["databars"]["experience"]["orientation"] = "HORIZONTAL"
		E.db["databars"]["experience"]["width"] = 1920
		E.db["databars"]["honor"]["height"] = 5
		E.db["databars"]["honor"]["orientation"] = "HORIZONTAL"
		E.db["databars"]["honor"]["width"] = 400
		E.db["databars"]["reputation"]["enable"] = true
		E.db["databars"]["reputation"]["orientation"] = "HORIZONTAL"
		E.db["databars"]["reputation"]["height"] = 5
		E.db["databars"]["reputation"]["width"] = 400
		E.db["databars"]["azerite"]["height"] = 175
		E.db["databars"]["azerite"]["width"] = 8
		E.db["currentTutorial"] = 1
		E.db["general"]["totems"]["spacing"] = 3
		E.db["general"]["threat"]["enable"] = false
		E.db["general"]["backdropcolor"]["b"] = 0.062745098039216
		E.db["general"]["backdropcolor"]["g"] = 0.062745098039216
		E.db["general"]["backdropcolor"]["r"] = 0.062745098039216
		E.db["general"]["vendorGrays"] = true
		E.db["general"]["bordercolor"]["b"] = 0
		E.db["general"]["bordercolor"]["g"] = 0
		E.db["general"]["bordercolor"]["r"] = 0
		E.db["general"]["minimap"]["locationFont"] = "Expressway"
		E.db["general"]["minimap"]["icons"]["lfgEye"]["position"] = "RIGHT"
		E.db["general"]["minimap"]["icons"]["calendar"]["position"] = "BOTTOMRIGHT"
		E.db["general"]["font"] = "Expressway"
		E.db["general"]["bottomPanel"] = false
		E.db["general"]["backdropfadecolor"]["a"] = 0.75
		E.db["general"]["backdropfadecolor"]["r"] = 0.058823529411765
		E.db["general"]["backdropfadecolor"]["g"] = 0.058823529411765
		E.db["general"]["backdropfadecolor"]["b"] = 0.058823529411765
		E.db["general"]["valuecolor"]["a"] = 1
		E.db["general"]["valuecolor"]["b"] = 0.99
		E.db["general"]["valuecolor"]["g"] = 0.99
		E.db["general"]["valuecolor"]["r"] = 0.99
		E.db["general"]["bonusObjectivePosition"] = "RIGHT"
		E.db["general"]["objectiveFrameHeight"] = 700
		E.db["gridSize"] = 100
		E.db["tooltip"]["font"] = "Expressway"
		E.db["tooltip"]["healthBar"]["font"] = "Expressway"
		E.db["tooltip"]["fontSize"] = 12
		E.private["skins"]["blizzard"]["alertframes"] = true
		E.private["auras"]["enable"] = false
		
		E.private["general"]["normTex"] = "ElvUI Blank"
		E.private["general"]["glossTex"] = "ElvUI Blank"
		E.private["general"]["chatBubbles"] = 'backdrop'
		
		
		--nameplates
		E.db["nameplates"]["stackFont"] = "Expressway"
		E.db["nameplates"]["statusbar"] = "ElvUI Blank"
		E.db["nameplates"]["targetGlow"] = "style7"
		E.db["nameplates"]["units"]["FRIENDLY_NPC"]["healthbar"]["enable"] = true
		E.db["nameplates"]["units"]["FRIENDLY_NPC"]["healthbar"]["text"]["enable"] = true
		E.db["nameplates"]["units"]["FRIENDLY_NPC"]["healthbar"]["width"] = 200
		E.db["nameplates"]["units"]["ENEMY_NPC"]["healthbar"]["height"] = 14
		E.db["nameplates"]["units"]["ENEMY_NPC"]["healthbar"]["text"]["enable"] = true
		E.db["nameplates"]["units"]["ENEMY_NPC"]["healthbar"]["text"]["format"] = "CURRENT_PERCENT"
		E.db["nameplates"]["units"]["ENEMY_NPC"]["healthbar"]["width"] = 200
		E.db["nameplates"]["units"]["ENEMY_NPC"]["castbar"]["height"] = 12
		E.db["nameplates"]["units"]["ENEMY_NPC"]["buffs"]["numAuras"] = 8
		E.db["nameplates"]["units"]["ENEMY_NPC"]["buffs"]["baseHeight"] = 10
		E.db["nameplates"]["units"]["ENEMY_NPC"]["eliteIcon"]["enable"] = true
		E.db["nameplates"]["units"]["ENEMY_NPC"]["eliteIcon"]["size"] = 22
		E.db["nameplates"]["units"]["ENEMY_NPC"]["eliteIcon"]["xOffset"] = 18
		E.db["nameplates"]["units"]["ENEMY_NPC"]["eliteIcon"]["yOffset"] = -3
		E.db["nameplates"]["units"]["ENEMY_PLAYER"]["debuffs"]["numAuras"] = 8
		E.db["nameplates"]["units"]["ENEMY_PLAYER"]["debuffs"]["baseHeight"] = 10
		E.db["nameplates"]["units"]["ENEMY_PLAYER"]["castbar"]["height"] = 10
		E.db["nameplates"]["units"]["ENEMY_PLAYER"]["healthbar"]["width"] = 200
		E.db["nameplates"]["units"]["ENEMY_PLAYER"]["healthbar"]["text"]["enable"] = true
		E.db["nameplates"]["units"]["ENEMY_PLAYER"]["healthbar"]["text"]["format"] = "CURRENT_PERCENT"
		E.db["nameplates"]["units"]["FRIENDLY_PLAYER"]["castbar"]["height"] = 12
		E.db["nameplates"]["units"]["FRIENDLY_PLAYER"]["buffs"]["baseHeight"] = 10
		E.db["nameplates"]["units"]["FRIENDLY_PLAYER"]["buffs"]["numAuras"] = 8
		E.db["nameplates"]["units"]["FRIENDLY_PLAYER"]["healthbar"]["height"] = 14
		E.db["nameplates"]["units"]["FRIENDLY_PLAYER"]["healthbar"]["enable"] = true
		E.db["nameplates"]["units"]["FRIENDLY_PLAYER"]["healthbar"]["width"] = 200
		E.db["nameplates"]["glowColor"]["r"] = 1
		E.db["nameplates"]["glowColor"]["g"] = 0
		E.db["nameplates"]["glowColor"]["b"] = 0.03921568627451
		E.db["nameplates"]["font"] = "Expressway"
		E.db["nameplates"]["clampToScreen"] = true
		E.db["nameplates"]["healthFont"] = "Expressway"
		
		--bags
		E.db["bags"]["countFontSize"] = 12
		E.db["bags"]["countFont"] = "Expressway"
		E.db["bags"]["itemLevelFont"] = "Expressway"
		E.db["bags"]["ignoreItems"] = ""
		E.db["bags"]["bankSize"] = 30
		E.db["bags"]["itemLevelFontSize"] = 12
		E.db["bags"]["bankWidth"] = 500
		E.db["bags"]["bagSize"] = 30
		E.db["bags"]["alignToChat"] = false
		E.db["bags"]["bagWidth"] = 500	
		E.db["bagSortIgnoreItemsReset"] = true
		
		E.db["datatexts"]["minimapPanels"] = false
		E.db["datatexts"]["font"] = "Expressway"
		E.db["datatexts"]["minimapBottom"] = true
		E.db["datatexts"]["fontOutline"] = "OUTLINE"
		E.db["datatexts"]["panelTransparency"] = true
		E.db["datatexts"]["panels"]["BottomMiniPanel"] = "Time"
		E.db["datatexts"]["panels"]["RightMiniPanel"] = ""
		
		
		-- Movers
		E.db["movers"]["SocialMenuMover"] = "TOPLEFT,ElvUIParent,TOPLEFT,4,-107"
		E.db["movers"]["LeftChatMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,4,4"
		E.db["movers"]["RightChatMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-4,4"
		E.db["movers"]["GMMover"] = "TOPLEFT,ElvUIParent,TOPLEFT,497,-4"
		E.db["movers"]["BossButton"] = "TOP,ElvUIParent,TOP,224,-293"
		E.db["movers"]["LootFrameMover"] = "TOPLEFT,ElvUIParent,TOPLEFT,552,-268"
		E.db["movers"]["ZoneAbility"] = "TOP,ElvUIParent,TOP,-225,-293"
		E.db["movers"]["VehicleSeatMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-419,33"
		E.db["movers"]["ExperienceBarMover"] = "TOP,ElvUIParent,TOP,0,0"
		E.db["movers"]["LossControlMover"] = "BOTTOM,ElvUIParent,BOTTOM,-1,489"
		E.db["movers"]["TalkingHeadFrameMover"] = "TOP,ElvUIParent,TOP,0,-152"
		E.db["movers"]["ReputationBarMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-4,178"
		E.db["movers"]["ObjectiveFrameMover"] = "TOPRIGHT,ElvUIParent,TOPRIGHT,-55,-193"
		E.db["movers"]["BNETMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,4,226"
		E.db["movers"]["TotemBarMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,403,4"
		E.db["movers"]["HonorBarMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,4,178"
		E.db["movers"]["TooltipMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-4,226"
		E.db["movers"]["MinimapMover"] = "TOPRIGHT,ElvUIParent,TOPRIGHT,-10,-9"
		E.db["movers"]["AzeriteBarMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-403,4"
		E.db["movers"]["AlertFrameMover"] = "TOP,ElvUIParent,TOP,0,-60"

	PluginInstallStepComplete.message = TTUIRM.Title..L['Layout Set']
	PluginInstallStepComplete:Show()

	E:UpdateAll(true)
end

	
local function SetupUnitframes(layout)
	if layout == 'v1' then
	E.db.unitframes = nil
	
	--Units
	--general
	E.db["unitframe"]["statusbar"] = "ElvUI Blank"
	E.db["unitframe"]["colors"]["auraBarBuff"]["b"] = 0.43
	E.db["unitframe"]["colors"]["auraBarBuff"]["g"] = 0.61
	E.db["unitframe"]["colors"]["auraBarBuff"]["r"] = 0.78
	E.db["unitframe"]["colors"]["colorhealthbyvalue"] = false
	E.db["unitframe"]["colors"]["health_backdrop"]["g"] = 0.011764705882353
	E.db["unitframe"]["colors"]["health_backdrop"]["b"] = 0.011764705882353
	E.db["unitframe"]["colors"]["transparentPower"] = true
	E.db["unitframe"]["colors"]["classResources"]["bgColor"]["b"] = 0.10196078431373
	E.db["unitframe"]["colors"]["classResources"]["bgColor"]["g"] = 0.10196078431373
	E.db["unitframe"]["colors"]["classResources"]["bgColor"]["r"] = 0.10196078431373
	E.db["unitframe"]["colors"]["classResources"]["WARLOCK"]["b"] = 0.74901960784314
	E.db["unitframe"]["colors"]["classResources"]["WARLOCK"]["g"] = 0.17254901960784
	E.db["unitframe"]["colors"]["classResources"]["WARLOCK"]["r"] = 0.26666666666667
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][1]["b"] = 0.18039215686275
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][1]["g"] = 0.12156862745098
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][1]["r"] = 0.69019607843137
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][2]["b"] = 0.12549019607843
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][2]["g"] = 0.54509803921569
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][2]["r"] = 0.65098039215686
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][3]["b"] = 0.24705882352941
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][3]["g"] = 0.58823529411765
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][3]["r"] = 0.18823529411765
	E.db["unitframe"]["colors"]["transparentHealth"] = true
	E.db["unitframe"]["colors"]["debuffHighlight"]["Disease"]["a"] = 0.25
	E.db["unitframe"]["colors"]["debuffHighlight"]["Poison"]["a"] = 0.25
	E.db["unitframe"]["colors"]["debuffHighlight"]["Magic"]["a"] = 0.25
	E.db["unitframe"]["colors"]["debuffHighlight"]["Curse"]["a"] = 0.25
	E.db["unitframe"]["colors"]["power"]["MANA"]["b"] = 0.63137254901961
	E.db["unitframe"]["colors"]["power"]["MANA"]["g"] = 0.45098039215686
	E.db["unitframe"]["colors"]["power"]["MANA"]["r"] = 0.30980392156863
	E.db["unitframe"]["colors"]["castColor"]["b"] = 0.24313725490196
	E.db["unitframe"]["colors"]["castColor"]["g"] = 0.74901960784314
	E.db["unitframe"]["colors"]["castColor"]["r"] = 0.22745098039216
	E.db["unitframe"]["colors"]["healPrediction"]["personal"]["a"] = 0.15000003576279
	E.db["unitframe"]["colors"]["healPrediction"]["personal"]["b"] = 0.50196078431373
	E.db["unitframe"]["colors"]["castNoInterrupt"]["b"] = 0.31764705882353
	E.db["unitframe"]["colors"]["castNoInterrupt"]["g"] = 0.28627450980392
	E.db["unitframe"]["colors"]["castNoInterrupt"]["r"] = 0.78039215686274
	E.db["unitframe"]["colors"]["health"]["b"] = 0.094117647058824
	E.db["unitframe"]["colors"]["health"]["g"] = 0.094117647058824
	E.db["unitframe"]["colors"]["health"]["r"] = 0.094117647058824
	E.db["unitframe"]["colors"]["transparentAurabars"] = true
	E.db["unitframe"]["colors"]["transparentCastbar"] = true
	E.db["unitframe"]["colors"]["classbackdrop"] = true
	E.db["unitframe"]["fontOutline"] = "OUTLINE"
	E.db["unitframe"]["smoothbars"] = true
	E.db["unitframe"]["font"] = "Expressway"
	E.db["unitframe"]["fontSize"] = 12
	
	--Player
	E.db["unitframe"]["units"]["player"]["debuffs"]["enable"] = false
	E.db["unitframe"]["units"]["player"]["debuffs"]["attachTo"] = "HEALTH"
	E.db["unitframe"]["units"]["player"]["aurabar"]["enable"] = false
	E.db["unitframe"]["units"]["player"]["RestIcon"]["size"] = 15
	E.db["unitframe"]["units"]["player"]["RestIcon"]["xOffset"] = 0
	E.db["unitframe"]["units"]["player"]["RestIcon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["player"]["castbar"]["height"] = 15
	E.db["unitframe"]["units"]["player"]["castbar"]["width"] = 225
	E.db["unitframe"]["units"]["player"]["castbar"]["icon"] = false
	E.db["unitframe"]["units"]["player"]["classbar"]["detachFromFrame"] = true
	E.db["unitframe"]["units"]["player"]["classbar"]["detachedWidth"] = 225
	E.db["unitframe"]["units"]["player"]["classbar"]["fill"] = "spaced"
	E.db["unitframe"]["units"]["player"]["classbar"]["height"] = 6
	E.db["unitframe"]["units"]["player"]["classbar"]["additionalPowerText"] = false
	E.db["unitframe"]["units"]["player"]["health"]["text_format"] = "[healthcolor][health:current]"
	E.db["unitframe"]["units"]["player"]["power"]["height"] = 8
	E.db["unitframe"]["units"]["player"]["power"]["xOffset"] = 0
	E.db["unitframe"]["units"]["player"]["width"] = 225
	E.db["unitframe"]["units"]["player"]["name"]["enable"] = false
	E.db["unitframe"]["units"]["player"]["height"] = 40
	E.db["unitframe"]["units"]["player"]["buffs"]["noDuration"] = false
	E.db["unitframe"]["units"]["player"]["CombatIcon"]["anchorPoint"] = "TOP"
	E.db["unitframe"]["units"]["player"]["CombatIcon"]["color"]["g"] = 0.89411764705882
	E.db["unitframe"]["units"]["player"]["CombatIcon"]["color"]["b"] = 0
	E.db["unitframe"]["units"]["player"]["CombatIcon"]["size"] = 13
	E.db["unitframe"]["units"]["player"]["CombatIcon"]["texture"] = "ALERT"
	E.db["unitframe"]["units"]["player"]["raidicon"]["attachTo"] = "CENTER"
	E.db["unitframe"]["units"]["player"]["raidicon"]["size"] = 14
	E.db["unitframe"]["units"]["player"]["raidicon"]["attachToObject"] = "Health"
	E.db["unitframe"]["units"]["player"]["raidicon"]["yOffset"] = 0
	
	--Target
	E.db["unitframe"]["units"]["target"]["debuffs"]["enable"] = false
	E.db["unitframe"]["units"]["target"]["debuffs"]["anchorPoint"] = "TOPLEFT"
	E.db["unitframe"]["units"]["target"]["power"]["xOffset"] = -2
	E.db["unitframe"]["units"]["target"]["power"]["text_format"] = ""
	E.db["unitframe"]["units"]["target"]["power"]["height"] = 8
	E.db["unitframe"]["units"]["target"]["raidicon"]["attachTo"] = "CENTER"
	E.db["unitframe"]["units"]["target"]["raidicon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["target"]["raidicon"]["attachToObject"] = "Health"
	E.db["unitframe"]["units"]["target"]["raidicon"]["size"] = 14
	E.db["unitframe"]["units"]["target"]["smartAuraDisplay"] = "DISABLED"
	E.db["unitframe"]["units"]["target"]["height"] = 40
	E.db["unitframe"]["units"]["target"]["width"] = 225
	E.db["unitframe"]["units"]["target"]["name"]["xOffset"] = 4
	E.db["unitframe"]["units"]["target"]["name"]["text_format"] = "[difficultycolor][level][shortclassification] [namecolor][name:medium]"
	E.db["unitframe"]["units"]["target"]["name"]["position"] = "LEFT"
	E.db["unitframe"]["units"]["target"]["health"]["text_format"] = "[health:current]"
	E.db["unitframe"]["units"]["target"]["orientation"] = "LEFT"
	E.db["unitframe"]["units"]["target"]["buffs"]["enable"] = false
	E.db["unitframe"]["units"]["target"]["buffs"]["selfBuffs"] = true
	E.db["unitframe"]["units"]["target"]["buffs"]["anchorPoint"] = "TOPLEFT"
	E.db["unitframe"]["units"]["target"]["castbar"]["height"] = 40
	E.db["unitframe"]["units"]["target"]["castbar"]["width"] = 225
	E.db["unitframe"]["units"]["target"]["aurabar"]["enable"] = false
	E.db["unitframe"]["units"]["target"]["aurabar"]["selfBuffs"] = true
	
	--Pet
	E.db["unitframe"]["units"]["pet"]["width"] = 100
	E.db["unitframe"]["units"]["pet"]["name"]["attachTextTo"] = "Health"
	E.db["unitframe"]["units"]["pet"]["height"] = 35
	E.db["unitframe"]["units"]["pet"]["castbar"]["enable"] = false
	
	--Focus
	E.db["unitframe"]["units"]["focus"]["debuffs"]["enable"] = false
	E.db["unitframe"]["units"]["focus"]["debuffs"]["anchorPoint"] = "BOTTOMRIGHT"
	E.db["unitframe"]["units"]["focus"]["threatStyle"] = "NONE"
	E.db["unitframe"]["units"]["focus"]["castbar"]["height"] = 22
	E.db["unitframe"]["units"]["focus"]["castbar"]["width"] = 90
	E.db["unitframe"]["units"]["focus"]["raidicon"]["attachTo"] = "LEFT"
	E.db["unitframe"]["units"]["focus"]["raidicon"]["xOffset"] = 1
	E.db["unitframe"]["units"]["focus"]["raidicon"]["size"] = 12
	E.db["unitframe"]["units"]["focus"]["raidicon"]["attachToObject"] = "Health"
	E.db["unitframe"]["units"]["focus"]["raidicon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["focus"]["width"] = 90
	E.db["unitframe"]["units"]["focus"]["name"]["text_format"] = "[namecolor][name:short]"
	E.db["unitframe"]["units"]["focus"]["height"] = 28
	E.db["unitframe"]["units"]["focus"]["power"]["height"] = 6
	
	--TargetTarget
	E.db["unitframe"]["units"]["targettarget"]["debuffs"]["enable"] = false
	E.db["unitframe"]["units"]["targettarget"]["power"]["height"] = 6
	E.db["unitframe"]["units"]["targettarget"]["width"] = 90
	E.db["unitframe"]["units"]["targettarget"]["height"] = 28
	E.db["unitframe"]["units"]["targettarget"]["name"]["text_format"] = "[namecolor][name:short]"
	E.db["unitframe"]["units"]["targettarget"]["raidicon"]["attachTo"] = "LEFT"
	E.db["unitframe"]["units"]["targettarget"]["raidicon"]["xOffset"] = 1
	E.db["unitframe"]["units"]["targettarget"]["raidicon"]["size"] = 12
	E.db["unitframe"]["units"]["targettarget"]["raidicon"]["attachToObject"] = "Health"
	E.db["unitframe"]["units"]["targettarget"]["raidicon"]["yOffset"] = 0
	
	--Party
	E.db["unitframe"]["units"]["party"]["horizontalSpacing"] = 5
	E.db["unitframe"]["units"]["party"]["debuffs"]["anchorPoint"] = "TOPLEFT"
	E.db["unitframe"]["units"]["party"]["debuffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["party"]["debuffs"]["yOffset"] = 5
	E.db["unitframe"]["units"]["party"]["debuffs"]["perrow"] = 5
	E.db["unitframe"]["units"]["party"]["rdebuffs"]["font"] = "Expressway"
	E.db["unitframe"]["units"]["party"]["growthDirection"] = "RIGHT_UP"
	E.db["unitframe"]["units"]["party"]["buffIndicator"]["size"] = 10
	E.db["unitframe"]["units"]["party"]["roleIcon"]["position"] = "RIGHT"
	E.db["unitframe"]["units"]["party"]["targetsGroup"]["anchorPoint"] = "BOTTOM"
	E.db["unitframe"]["units"]["party"]["power"]["text_format"] = ""
	E.db["unitframe"]["units"]["party"]["power"]["height"] = 5
	E.db["unitframe"]["units"]["party"]["width"] = 105
	E.db["unitframe"]["units"]["party"]["name"]["xOffset"] = 2
	E.db["unitframe"]["units"]["party"]["name"]["text_format"] = "[namecolor][name:short] "
	E.db["unitframe"]["units"]["party"]["name"]["position"] = "LEFT"
	E.db["unitframe"]["units"]["party"]["health"]["text_format"] = ""
	E.db["unitframe"]["units"]["party"]["height"] = 30
	E.db["unitframe"]["units"]["party"]["raidicon"]["attachTo"] = "CENTER"
	E.db["unitframe"]["units"]["party"]["raidicon"]["yOffset"] = 4
	E.db["unitframe"]["units"]["party"]["raidicon"]["xOffset"] = 32
	E.db["unitframe"]["units"]["party"]["raidicon"]["size"] = 14
	
	--Raid
	E.db["unitframe"]["units"]["raid"]["horizontalSpacing"] = -1
	E.db["unitframe"]["units"]["raid"]["debuffs"]["anchorPoint"] = "TOPLEFT"
	E.db["unitframe"]["units"]["raid"]["debuffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["raid"]["debuffs"]["perrow"] = 5
	E.db["unitframe"]["units"]["raid"]["rdebuffs"]["font"] = "Expressway"
	E.db["unitframe"]["units"]["raid"]["rdebuffs"]["fontOutline"] = "OUTLINE"
	E.db["unitframe"]["units"]["raid"]["rdebuffs"]["size"] = 18
	E.db["unitframe"]["units"]["raid"]["rdebuffs"]["yOffset"] = 5
	E.db["unitframe"]["units"]["raid"]["growthDirection"] = "RIGHT_UP"
	E.db["unitframe"]["units"]["raid"]["buffIndicator"]["size"] = 9
	E.db["unitframe"]["units"]["raid"]["roleIcon"]["xOffset"] = 0
	E.db["unitframe"]["units"]["raid"]["roleIcon"]["position"] = "RIGHT"
	E.db["unitframe"]["units"]["raid"]["roleIcon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid"]["power"]["height"] = 5
	E.db["unitframe"]["units"]["raid"]["power"]["position"] = "RIGHT"
	E.db["unitframe"]["units"]["raid"]["power"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid"]["width"] = 105
	E.db["unitframe"]["units"]["raid"]["infoPanel"]["height"] = 15
	E.db["unitframe"]["units"]["raid"]["orientation"] = "LEFT"
	E.db["unitframe"]["units"]["raid"]["name"]["text_format"] = "[namecolor][name:short] "
	E.db["unitframe"]["units"]["raid"]["health"]["xOffset"] = 2
	E.db["unitframe"]["units"]["raid"]["health"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid"]["health"]["text_format"] = ""
	E.db["unitframe"]["units"]["raid"]["health"]["position"] = "LEFT"
	E.db["unitframe"]["units"]["raid"]["height"] = 35
	E.db["unitframe"]["units"]["raid"]["verticalSpacing"] = -1
	E.db["unitframe"]["units"]["raid"]["buffs"]["perrow"] = 4
	
	--Raid40
	E.db["unitframe"]["units"]["raid40"]["horizontalSpacing"] = -1
	E.db["unitframe"]["units"]["raid40"]["debuffs"]["anchorPoint"] = "TOPLEFT"
	E.db["unitframe"]["units"]["raid40"]["debuffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["raid40"]["debuffs"]["perrow"] = 5
	E.db["unitframe"]["units"]["raid40"]["portrait"]["camDistanceScale"] = 2
	E.db["unitframe"]["units"]["raid40"]["rdebuffs"]["font"] = "Expressway"
	E.db["unitframe"]["units"]["raid40"]["rdebuffs"]["size"] = 14
	E.db["unitframe"]["units"]["raid40"]["rdebuffs"]["fontOutline"] = "OUTLINE"
	E.db["unitframe"]["units"]["raid40"]["rdebuffs"]["enable"] = true
	E.db["unitframe"]["units"]["raid40"]["rdebuffs"]["yOffset"] = 5
	E.db["unitframe"]["units"]["raid40"]["growthDirection"] = "RIGHT_UP"
	E.db["unitframe"]["units"]["raid40"]["buffIndicator"]["size"] = 6
	E.db["unitframe"]["units"]["raid40"]["roleIcon"]["xOffset"] = 0
	E.db["unitframe"]["units"]["raid40"]["roleIcon"]["enable"] = true
	E.db["unitframe"]["units"]["raid40"]["roleIcon"]["position"] = "RIGHT"
	E.db["unitframe"]["units"]["raid40"]["roleIcon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid40"]["power"]["enable"] = true
	E.db["unitframe"]["units"]["raid40"]["power"]["height"] = 5
	E.db["unitframe"]["units"]["raid40"]["power"]["position"] = "RIGHT"
	E.db["unitframe"]["units"]["raid40"]["power"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid40"]["width"] = 105
	E.db["unitframe"]["units"]["raid40"]["infoPanel"]["height"] = 15
	E.db["unitframe"]["units"]["raid40"]["orientation"] = "LEFT"
	E.db["unitframe"]["units"]["raid40"]["name"]["text_format"] = "[namecolor][name:short] "
	E.db["unitframe"]["units"]["raid40"]["health"]["xOffset"] = 2
	E.db["unitframe"]["units"]["raid40"]["health"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid40"]["health"]["text_format"] = ""
	E.db["unitframe"]["units"]["raid40"]["health"]["position"] = "LEFT"
	E.db["unitframe"]["units"]["raid40"]["height"] = 26
	E.db["unitframe"]["units"]["raid40"]["verticalSpacing"] = -1
	E.db["unitframe"]["units"]["raid40"]["buffs"]["perrow"] = 4
	E.db["unitframe"]["units"]["raid40"]["raidicon"]["attachTo"] = "CENTER"
	E.db["unitframe"]["units"]["raid40"]["raidicon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid40"]["raidicon"]["attachToObject"] = "Health"
	E.db["unitframe"]["units"]["raid40"]["raidicon"]["size"] = 14
	
	--Boss
	E.db["unitframe"]["units"]["boss"]["debuffs"]["maxDuration"] = 300
	E.db["unitframe"]["units"]["boss"]["debuffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["boss"]["width"] = 200
	E.db["unitframe"]["units"]["boss"]["height"] = 40
	E.db["unitframe"]["units"]["boss"]["buffs"]["maxDuration"] = 300
	E.db["unitframe"]["units"]["boss"]["buffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["boss"]["castbar"]["width"] = 200
	
	--Arena
	E.db["unitframe"]["units"]["arena"]["debuffs"]["numrows"] = 2
	E.db["unitframe"]["units"]["arena"]["debuffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["arena"]["debuffs"]["yOffset"] = -3
	E.db["unitframe"]["units"]["arena"]["portrait"]["camDistanceScale"] = 1
	E.db["unitframe"]["units"]["arena"]["portrait"]["width"] = 35
	E.db["unitframe"]["units"]["arena"]["width"] = 200
	E.db["unitframe"]["units"]["arena"]["infoPanel"]["height"] = 16
	E.db["unitframe"]["units"]["arena"]["height"] = 40
	E.db["unitframe"]["units"]["arena"]["buffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["arena"]["buffs"]["yOffset"] = 20
	E.db["unitframe"]["units"]["arena"]["castbar"]["width"] = 200

	--Movers
	E.db["movers"]["ElvUF_FocusCastbarMover"] = "BOTTOM,ElvUIParent,BOTTOM,-315,395"
	E.db["movers"]["ElvUF_RaidpetMover"] = "TOPLEFT,ElvUIParent,BOTTOMLEFT,4,736"
	E.db["movers"]["ElvUF_FocusMover"] = "BOTTOM,ElvUIParent,BOTTOM,-315,419"
	E.db["movers"]["ElvUF_TargetMover"] = "BOTTOM,ElvUIParent,BOTTOM,248,346"
	E.db["movers"]["ElvUF_PartyMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,688,65"
	E.db["movers"]["ElvUF_RaidMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,700,65"
	E.db["movers"]["ElvUF_Raid40Mover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,700,65"
	E.db["movers"]["ElvUF_TargetTargetMover"] = "BOTTOM,ElvUIParent,BOTTOM,315,391"
	E.db["movers"]["ElvUF_PlayerMover"] = "BOTTOM,ElvUIParent,BOTTOM,-247,346"
	E.db["movers"]["ArenaHeaderMover"] = "TOPRIGHT,ElvUIParent,TOPRIGHT,-4,-241"
	E.db["movers"]["ElvUF_PetMover"] = "BOTTOM,ElvUIParent,BOTTOM,-1,293"
	E.db["movers"]["AltPowerBarMover"] = "TOP,ElvUIParent,TOP,0,0"
	E.db["movers"]["ElvUF_AssistMover"] = "TOPLEFT,ElvUIParent,BOTTOMLEFT,4,603"
	E.db["movers"]["ElvUF_TankMover"] = "TOPLEFT,ElvUIParent,BOTTOMLEFT,4,672"
	E.db["movers"]["ElvUF_TargetCastbarMover"] = "BOTTOM,ElvUIParent,BOTTOM,1,346"
	E.db["movers"]["BossHeaderMover"] = "TOPRIGHT,ElvUIParent,TOPRIGHT,-4,-240"
	E.db["movers"]["ClassBarMover"] = "BOTTOM,ElvUIParent,BOTTOM,-247,385"
	
elseif layout == 'v2' then
	E.db.unitframes = nil
	
	--Units
	--general
	E.db["unitframe"]["statusbar"] = "ElvUI Blank"
	E.db["unitframe"]["colors"]["auraBarBuff"]["b"] = 0.43
	E.db["unitframe"]["colors"]["auraBarBuff"]["g"] = 0.61
	E.db["unitframe"]["colors"]["auraBarBuff"]["r"] = 0.78
	E.db["unitframe"]["colors"]["colorhealthbyvalue"] = false
	E.db["unitframe"]["colors"]["health_backdrop"]["g"] = 0.011764705882353
	E.db["unitframe"]["colors"]["health_backdrop"]["b"] = 0.011764705882353
	E.db["unitframe"]["colors"]["transparentPower"] = true
	E.db["unitframe"]["colors"]["classResources"]["bgColor"]["b"] = 0.10196078431373
	E.db["unitframe"]["colors"]["classResources"]["bgColor"]["g"] = 0.10196078431373
	E.db["unitframe"]["colors"]["classResources"]["bgColor"]["r"] = 0.10196078431373
	E.db["unitframe"]["colors"]["classResources"]["WARLOCK"]["b"] = 0.74901960784314
	E.db["unitframe"]["colors"]["classResources"]["WARLOCK"]["g"] = 0.17254901960784
	E.db["unitframe"]["colors"]["classResources"]["WARLOCK"]["r"] = 0.26666666666667
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][1]["b"] = 0.18039215686275
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][1]["g"] = 0.12156862745098
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][1]["r"] = 0.69019607843137
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][2]["b"] = 0.12549019607843
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][2]["g"] = 0.54509803921569
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][2]["r"] = 0.65098039215686
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][3]["b"] = 0.24705882352941
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][3]["g"] = 0.58823529411765
	E.db["unitframe"]["colors"]["classResources"]["comboPoints"][3]["r"] = 0.18823529411765
	E.db["unitframe"]["colors"]["transparentHealth"] = true
	E.db["unitframe"]["colors"]["debuffHighlight"]["Disease"]["a"] = 0.25
	E.db["unitframe"]["colors"]["debuffHighlight"]["Poison"]["a"] = 0.25
	E.db["unitframe"]["colors"]["debuffHighlight"]["Magic"]["a"] = 0.25
	E.db["unitframe"]["colors"]["debuffHighlight"]["Curse"]["a"] = 0.25
	E.db["unitframe"]["colors"]["power"]["MANA"]["b"] = 0.63137254901961
	E.db["unitframe"]["colors"]["power"]["MANA"]["g"] = 0.45098039215686
	E.db["unitframe"]["colors"]["power"]["MANA"]["r"] = 0.30980392156863
	E.db["unitframe"]["colors"]["castColor"]["b"] = 0.24313725490196
	E.db["unitframe"]["colors"]["castColor"]["g"] = 0.74901960784314
	E.db["unitframe"]["colors"]["castColor"]["r"] = 0.22745098039216
	E.db["unitframe"]["colors"]["healPrediction"]["personal"]["a"] = 0.15000003576279
	E.db["unitframe"]["colors"]["healPrediction"]["personal"]["b"] = 0.50196078431373
	E.db["unitframe"]["colors"]["castNoInterrupt"]["b"] = 0.31764705882353
	E.db["unitframe"]["colors"]["castNoInterrupt"]["g"] = 0.28627450980392
	E.db["unitframe"]["colors"]["castNoInterrupt"]["r"] = 0.78039215686274
	E.db["unitframe"]["colors"]["health"]["b"] = 0.094117647058824
	E.db["unitframe"]["colors"]["health"]["g"] = 0.094117647058824
	E.db["unitframe"]["colors"]["health"]["r"] = 0.094117647058824
	E.db["unitframe"]["colors"]["transparentAurabars"] = true
	E.db["unitframe"]["colors"]["transparentCastbar"] = true
	E.db["unitframe"]["colors"]["classbackdrop"] = true
	E.db["unitframe"]["fontOutline"] = "OUTLINE"
	E.db["unitframe"]["smoothbars"] = true
	E.db["unitframe"]["font"] = "Expressway"
	E.db["unitframe"]["fontSize"] = 12
	
	--Player
	E.db["unitframe"]["units"]["player"]["debuffs"]["enable"] = false
	E.db["unitframe"]["units"]["player"]["debuffs"]["attachTo"] = "HEALTH"
	E.db["unitframe"]["units"]["player"]["aurabar"]["enable"] = false
	E.db["unitframe"]["units"]["player"]["RestIcon"]["size"] = 15
	E.db["unitframe"]["units"]["player"]["RestIcon"]["xOffset"] = 0
	E.db["unitframe"]["units"]["player"]["RestIcon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["player"]["castbar"]["height"] = 15
	E.db["unitframe"]["units"]["player"]["castbar"]["width"] = 225
	E.db["unitframe"]["units"]["player"]["castbar"]["icon"] = false
	E.db["unitframe"]["units"]["player"]["classbar"]["detachFromFrame"] = true
	E.db["unitframe"]["units"]["player"]["classbar"]["detachedWidth"] = 225
	E.db["unitframe"]["units"]["player"]["classbar"]["fill"] = "spaced"
	E.db["unitframe"]["units"]["player"]["classbar"]["height"] = 6
	E.db["unitframe"]["units"]["player"]["classbar"]["additionalPowerText"] = false
	E.db["unitframe"]["units"]["player"]["health"]["text_format"] = "[healthcolor][health:current]"
	E.db["unitframe"]["units"]["player"]["power"]["height"] = 8
	E.db["unitframe"]["units"]["player"]["power"]["xOffset"] = 0
	E.db["unitframe"]["units"]["player"]["width"] = 225
	E.db["unitframe"]["units"]["player"]["name"]["enable"] = false
	E.db["unitframe"]["units"]["player"]["height"] = 40
	E.db["unitframe"]["units"]["player"]["buffs"]["noDuration"] = false
	E.db["unitframe"]["units"]["player"]["buffs"]["attachTo"] = "FRAME"
	E.db["unitframe"]["units"]["player"]["CombatIcon"]["anchorPoint"] = "TOP"
	E.db["unitframe"]["units"]["player"]["CombatIcon"]["color"]["g"] = 0.89411764705882
	E.db["unitframe"]["units"]["player"]["CombatIcon"]["color"]["b"] = 0
	E.db["unitframe"]["units"]["player"]["CombatIcon"]["size"] = 13
	E.db["unitframe"]["units"]["player"]["CombatIcon"]["texture"] = "ALERT"
	E.db["unitframe"]["units"]["player"]["raidicon"]["attachTo"] = "CENTER"
	E.db["unitframe"]["units"]["player"]["raidicon"]["size"] = 14
	E.db["unitframe"]["units"]["player"]["raidicon"]["attachToObject"] = "Health"
	E.db["unitframe"]["units"]["player"]["raidicon"]["yOffset"] = 0
	
	--Target
	E.db["unitframe"]["units"]["target"]["debuffs"]["enable"] = false
	E.db["unitframe"]["units"]["target"]["debuffs"]["anchorPoint"] = "TOPLEFT"
	E.db["unitframe"]["units"]["target"]["power"]["xOffset"] = -2
	E.db["unitframe"]["units"]["target"]["power"]["text_format"] = ""
	E.db["unitframe"]["units"]["target"]["power"]["height"] = 8
	E.db["unitframe"]["units"]["target"]["raidicon"]["attachTo"] = "CENTER"
	E.db["unitframe"]["units"]["target"]["raidicon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["target"]["raidicon"]["attachToObject"] = "Health"
	E.db["unitframe"]["units"]["target"]["raidicon"]["size"] = 14
	E.db["unitframe"]["units"]["target"]["smartAuraDisplay"] = "DISABLED"
	E.db["unitframe"]["units"]["target"]["height"] = 40
	E.db["unitframe"]["units"]["target"]["width"] = 225
	E.db["unitframe"]["units"]["target"]["name"]["xOffset"] = 4
	E.db["unitframe"]["units"]["target"]["name"]["text_format"] = "[difficultycolor][level][shortclassification] [namecolor][name:medium]"
	E.db["unitframe"]["units"]["target"]["name"]["position"] = "LEFT"
	E.db["unitframe"]["units"]["target"]["health"]["text_format"] = "[health:current]"
	E.db["unitframe"]["units"]["target"]["orientation"] = "LEFT"
	E.db["unitframe"]["units"]["target"]["buffs"]["enable"] = false
	E.db["unitframe"]["units"]["target"]["buffs"]["selfBuffs"] = true
	E.db["unitframe"]["units"]["target"]["buffs"]["anchorPoint"] = "TOPLEFT"
	E.db["unitframe"]["units"]["target"]["castbar"]["height"] = 40
	E.db["unitframe"]["units"]["target"]["castbar"]["width"] = 225
	E.db["unitframe"]["units"]["target"]["aurabar"]["enable"] = false
	E.db["unitframe"]["units"]["target"]["aurabar"]["selfBuffs"] = true
	
	--Pet
	E.db["unitframe"]["units"]["pet"]["width"] = 100
	E.db["unitframe"]["units"]["pet"]["name"]["attachTextTo"] = "Health"
	E.db["unitframe"]["units"]["pet"]["height"] = 35
	E.db["unitframe"]["units"]["pet"]["castbar"]["enable"] = false
	
	--Focus
	E.db["unitframe"]["units"]["focus"]["debuffs"]["enable"] = false
	E.db["unitframe"]["units"]["focus"]["debuffs"]["anchorPoint"] = "BOTTOMRIGHT"
	E.db["unitframe"]["units"]["focus"]["threatStyle"] = "NONE"
	E.db["unitframe"]["units"]["focus"]["castbar"]["height"] = 22
	E.db["unitframe"]["units"]["focus"]["castbar"]["width"] = 90
	E.db["unitframe"]["units"]["focus"]["raidicon"]["attachTo"] = "LEFT"
	E.db["unitframe"]["units"]["focus"]["raidicon"]["xOffset"] = 1
	E.db["unitframe"]["units"]["focus"]["raidicon"]["size"] = 12
	E.db["unitframe"]["units"]["focus"]["raidicon"]["attachToObject"] = "Health"
	E.db["unitframe"]["units"]["focus"]["raidicon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["focus"]["width"] = 90
	E.db["unitframe"]["units"]["focus"]["name"]["text_format"] = "[namecolor][name:short]"
	E.db["unitframe"]["units"]["focus"]["height"] = 28
	E.db["unitframe"]["units"]["focus"]["power"]["height"] = 6
	
	--TargetTarget
	E.db["unitframe"]["units"]["targettarget"]["debuffs"]["enable"] = false
	E.db["unitframe"]["units"]["targettarget"]["power"]["height"] = 6
	E.db["unitframe"]["units"]["targettarget"]["width"] = 90
	E.db["unitframe"]["units"]["targettarget"]["height"] = 28
	E.db["unitframe"]["units"]["targettarget"]["name"]["text_format"] = "[namecolor][name:short]"
	E.db["unitframe"]["units"]["targettarget"]["raidicon"]["attachTo"] = "LEFT"
	E.db["unitframe"]["units"]["targettarget"]["raidicon"]["xOffset"] = 1
	E.db["unitframe"]["units"]["targettarget"]["raidicon"]["size"] = 12
	E.db["unitframe"]["units"]["targettarget"]["raidicon"]["attachToObject"] = "Health"
	E.db["unitframe"]["units"]["targettarget"]["raidicon"]["yOffset"] = 0
	
	--Party
	E.db["unitframe"]["units"]["party"]["horizontalSpacing"] = 5
	E.db["unitframe"]["units"]["party"]["debuffs"]["anchorPoint"] = "TOPLEFT"
	E.db["unitframe"]["units"]["party"]["debuffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["party"]["debuffs"]["yOffset"] = 5
	E.db["unitframe"]["units"]["party"]["debuffs"]["perrow"] = 5
	E.db["unitframe"]["units"]["party"]["rdebuffs"]["font"] = "Expressway"
	E.db["unitframe"]["units"]["party"]["growthDirection"] = "RIGHT_UP"
	E.db["unitframe"]["units"]["party"]["buffIndicator"]["size"] = 10
	E.db["unitframe"]["units"]["party"]["roleIcon"]["position"] = "RIGHT"
	E.db["unitframe"]["units"]["party"]["targetsGroup"]["anchorPoint"] = "BOTTOM"
	E.db["unitframe"]["units"]["party"]["power"]["text_format"] = ""
	E.db["unitframe"]["units"]["party"]["power"]["height"] = 5
	E.db["unitframe"]["units"]["party"]["width"] = 105
	E.db["unitframe"]["units"]["party"]["name"]["xOffset"] = 2
	E.db["unitframe"]["units"]["party"]["name"]["text_format"] = "[namecolor][name:short] "
	E.db["unitframe"]["units"]["party"]["name"]["position"] = "LEFT"
	E.db["unitframe"]["units"]["party"]["health"]["text_format"] = ""
	E.db["unitframe"]["units"]["party"]["height"] = 50
	E.db["unitframe"]["units"]["party"]["raidicon"]["attachTo"] = "CENTER"
	E.db["unitframe"]["units"]["party"]["raidicon"]["yOffset"] = 4
	E.db["unitframe"]["units"]["party"]["raidicon"]["xOffset"] = 32
	E.db["unitframe"]["units"]["party"]["raidicon"]["size"] = 14
	
	--Raid
	E.db["unitframe"]["units"]["raid"]["horizontalSpacing"] = -1
	E.db["unitframe"]["units"]["raid"]["debuffs"]["anchorPoint"] = "TOPLEFT"
	E.db["unitframe"]["units"]["raid"]["debuffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["raid"]["debuffs"]["perrow"] = 5
	E.db["unitframe"]["units"]["raid"]["rdebuffs"]["font"] = "Expressway"
	E.db["unitframe"]["units"]["raid"]["rdebuffs"]["fontOutline"] = "OUTLINE"
	E.db["unitframe"]["units"]["raid"]["rdebuffs"]["size"] = 18
	E.db["unitframe"]["units"]["raid"]["rdebuffs"]["yOffset"] = 5
	E.db["unitframe"]["units"]["raid"]["growthDirection"] = "RIGHT_UP"
	E.db["unitframe"]["units"]["raid"]["buffIndicator"]["size"] = 9
	E.db["unitframe"]["units"]["raid"]["roleIcon"]["xOffset"] = 0
	E.db["unitframe"]["units"]["raid"]["roleIcon"]["position"] = "RIGHT"
	E.db["unitframe"]["units"]["raid"]["roleIcon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid"]["power"]["height"] = 5
	E.db["unitframe"]["units"]["raid"]["power"]["position"] = "RIGHT"
	E.db["unitframe"]["units"]["raid"]["power"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid"]["width"] = 105
	E.db["unitframe"]["units"]["raid"]["infoPanel"]["height"] = 15
	E.db["unitframe"]["units"]["raid"]["orientation"] = "LEFT"
	E.db["unitframe"]["units"]["raid"]["name"]["text_format"] = "[namecolor][name:short] "
	E.db["unitframe"]["units"]["raid"]["health"]["xOffset"] = 2
	E.db["unitframe"]["units"]["raid"]["health"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid"]["health"]["text_format"] = ""
	E.db["unitframe"]["units"]["raid"]["health"]["position"] = "LEFT"
	E.db["unitframe"]["units"]["raid"]["height"] = 40
	E.db["unitframe"]["units"]["raid"]["verticalSpacing"] = -1
	E.db["unitframe"]["units"]["raid"]["buffs"]["perrow"] = 4
	
	--Raid40
	E.db["unitframe"]["units"]["raid40"]["horizontalSpacing"] = -1
	E.db["unitframe"]["units"]["raid40"]["debuffs"]["anchorPoint"] = "TOPLEFT"
	E.db["unitframe"]["units"]["raid40"]["debuffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["raid40"]["debuffs"]["perrow"] = 5
	E.db["unitframe"]["units"]["raid40"]["portrait"]["camDistanceScale"] = 2
	E.db["unitframe"]["units"]["raid40"]["rdebuffs"]["font"] = "Expressway"
	E.db["unitframe"]["units"]["raid40"]["rdebuffs"]["size"] = 14
	E.db["unitframe"]["units"]["raid40"]["rdebuffs"]["fontOutline"] = "OUTLINE"
	E.db["unitframe"]["units"]["raid40"]["rdebuffs"]["enable"] = true
	E.db["unitframe"]["units"]["raid40"]["rdebuffs"]["yOffset"] = 5
	E.db["unitframe"]["units"]["raid40"]["growthDirection"] = "RIGHT_UP"
	E.db["unitframe"]["units"]["raid40"]["buffIndicator"]["size"] = 6
	E.db["unitframe"]["units"]["raid40"]["roleIcon"]["xOffset"] = 0
	E.db["unitframe"]["units"]["raid40"]["roleIcon"]["enable"] = true
	E.db["unitframe"]["units"]["raid40"]["roleIcon"]["position"] = "RIGHT"
	E.db["unitframe"]["units"]["raid40"]["roleIcon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid40"]["power"]["enable"] = true
	E.db["unitframe"]["units"]["raid40"]["power"]["height"] = 5
	E.db["unitframe"]["units"]["raid40"]["power"]["position"] = "RIGHT"
	E.db["unitframe"]["units"]["raid40"]["power"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid40"]["width"] = 105
	E.db["unitframe"]["units"]["raid40"]["infoPanel"]["height"] = 15
	E.db["unitframe"]["units"]["raid40"]["orientation"] = "LEFT"
	E.db["unitframe"]["units"]["raid40"]["name"]["text_format"] = "[namecolor][name:short] "
	E.db["unitframe"]["units"]["raid40"]["health"]["xOffset"] = 2
	E.db["unitframe"]["units"]["raid40"]["health"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid40"]["health"]["text_format"] = ""
	E.db["unitframe"]["units"]["raid40"]["health"]["position"] = "LEFT"
	E.db["unitframe"]["units"]["raid40"]["height"] = 26
	E.db["unitframe"]["units"]["raid40"]["verticalSpacing"] = -1
	E.db["unitframe"]["units"]["raid40"]["buffs"]["perrow"] = 4
	E.db["unitframe"]["units"]["raid40"]["raidicon"]["attachTo"] = "CENTER"
	E.db["unitframe"]["units"]["raid40"]["raidicon"]["yOffset"] = 0
	E.db["unitframe"]["units"]["raid40"]["raidicon"]["attachToObject"] = "Health"
	E.db["unitframe"]["units"]["raid40"]["raidicon"]["size"] = 14
	
	--Boss
	E.db["unitframe"]["units"]["boss"]["debuffs"]["maxDuration"] = 300
	E.db["unitframe"]["units"]["boss"]["debuffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["boss"]["width"] = 200
	E.db["unitframe"]["units"]["boss"]["height"] = 40
	E.db["unitframe"]["units"]["boss"]["buffs"]["maxDuration"] = 300
	E.db["unitframe"]["units"]["boss"]["buffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["boss"]["castbar"]["width"] = 200
	
	--Arena
	E.db["unitframe"]["units"]["arena"]["debuffs"]["numrows"] = 2
	E.db["unitframe"]["units"]["arena"]["debuffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["arena"]["debuffs"]["yOffset"] = -3
	E.db["unitframe"]["units"]["arena"]["portrait"]["camDistanceScale"] = 1
	E.db["unitframe"]["units"]["arena"]["portrait"]["width"] = 35
	E.db["unitframe"]["units"]["arena"]["width"] = 200
	E.db["unitframe"]["units"]["arena"]["infoPanel"]["height"] = 16
	E.db["unitframe"]["units"]["arena"]["height"] = 40
	E.db["unitframe"]["units"]["arena"]["buffs"]["sizeOverride"] = 20
	E.db["unitframe"]["units"]["arena"]["buffs"]["yOffset"] = 20
	E.db["unitframe"]["units"]["arena"]["castbar"]["width"] = 200
	
	--Movers
	E.db["movers"]["ArenaHeaderMover"] = "TOPRIGHT,ElvUIParent,TOPRIGHT,-4,-241"
	E.db["movers"]["ElvUF_TargetCastbarMover"] = "BOTTOM,ElvUIParent,BOTTOM,1,346"
	E.db["movers"]["ElvUF_TankMover"] = "TOPLEFT,ElvUIParent,BOTTOMLEFT,4,672"
	E.db["movers"]["BossHeaderMover"] = "TOPRIGHT,ElvUIParent,TOPRIGHT,-4,-240"
	E.db["movers"]["ElvUF_PlayerMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,360,346"
	E.db["movers"]["ElvUF_PetMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,360,257"
	E.db["movers"]["ElvUF_AssistMover"] = "TOPLEFT,ElvUIParent,BOTTOMLEFT,4,603"
	E.db["movers"]["ElvUF_TargetTargetMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-360,392"
	E.db["movers"]["AltPowerBarMover"] = "TOP,ElvUIParent,TOP,0,0"
	E.db["movers"]["ElvUF_FocusCastbarMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,360,395"
	E.db["movers"]["ElvUF_PartyMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,688,65"
	E.db["movers"]["ElvUF_RaidMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,700,65"
	E.db["movers"]["ElvUF_Raid40Mover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,700,65"
	E.db["movers"]["ElvUF_RaidpetMover"] = "TOPLEFT,ElvUIParent,BOTTOMLEFT,4,736"
	E.db["movers"]["ElvUF_FocusMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,360,427"
	E.db["movers"]["ClassBarMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,360,385"
	E.db["movers"]["ElvUF_TargetMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-360,346"
		
	end
	PluginInstallStepComplete.message = TTUIRM.Title..L['Unitframes Set']
		PluginInstallStepComplete:Show()
		E:UpdateAll(true)
	
end

local function SetupActionbars(layout)
	-- Actionbars
	E.db["actionbar"]["lockActionBars"] = true

	if layout == 'v1' then
		E.db.actionbars = nil
		
		E.db["actionbar"]["bar3"]["buttonsPerRow"] = 5
		E.db["actionbar"]["bar3"]["buttonsize"] = 24
		E.db["actionbar"]["bar3"]["buttons"] = 10
		E.db["actionbar"]["fontSize"] = 12
		E.db["actionbar"]["fontOutline"] = "OUTLINE"
		E.db["actionbar"]["microbar"]["mouseover"] = true
		E.db["actionbar"]["keyDown"] = false
		E.db["actionbar"]["bar2"]["enabled"] = true
		E.db["actionbar"]["bar2"]["inheritGlobalFade"] = true
		E.db["actionbar"]["bar2"]["buttons"] = 8
		E.db["actionbar"]["bar2"]["buttonsPerRow"] = 4
		E.db["actionbar"]["bar2"]["buttonsize"] = 24
		E.db["actionbar"]["bar1"]["buttonsPerRow"] = 6
		E.db["actionbar"]["bar1"]["buttonsize"] = 50
		E.db["actionbar"]["bar1"]["buttons"] = 6
		E.db["actionbar"]["backdropSpacingConverted"] = true
		E.db["actionbar"]["bar5"]["buttonsPerRow"] = 5
		E.db["actionbar"]["bar5"]["buttonsize"] = 24
		E.db["actionbar"]["bar5"]["buttons"] = 10
		E.db["actionbar"]["globalFadeAlpha"] = 0.85
		E.db["actionbar"]["font"] = "Expressway"
		E.db["actionbar"]["bar6"]["enabled"] = true
		E.db["actionbar"]["bar6"]["inheritGlobalFade"] = true
		E.db["actionbar"]["bar6"]["buttons"] = 8
		E.db["actionbar"]["bar6"]["buttonsPerRow"] = 4
		E.db["actionbar"]["bar6"]["visibility"] = "[vehicleui] hide; [overridebar] hide; [petbattle] hide; show\n\n\n"
		E.db["actionbar"]["bar6"]["buttonsize"] = 24
		E.db["actionbar"]["stanceBar"]["point"] = "TOPRIGHT"
		E.db["actionbar"]["stanceBar"]["buttonsize"] = 25
		E.db["actionbar"]["stanceBar"]["usePositionOverride"] = false
		E.db["actionbar"]["barPet"]["buttonsPerRow"] = 10
		E.db["actionbar"]["barPet"]["inheritGlobalFade"] = true
		E.db["actionbar"]["barPet"]["backdrop"] = false
		E.db["actionbar"]["barPet"]["buttonsize"] = 28
		E.db["actionbar"]["bar4"]["enabled"] = false

		-- Movers
		E.db["movers"]["ElvAB_1"] = "BOTTOM,ElvUIParent,BOTTOM,0,4"
		E.db["movers"]["ElvAB_2"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,561,4"
		E.db["movers"]["ElvAB_3"] = "BOTTOM,ElvUIParent,BOTTOM,226,4"
		E.db["movers"]["ElvAB_5"] = "BOTTOM,ElvUIParent,BOTTOM,-226,4"
		E.db["movers"]["ElvAB_6"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-561,4"
		E.db["movers"]["ShiftAB"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-4,190"
		E.db["movers"]["PetAB"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,4,190"
		E.db["movers"]["VehicleSeatMover"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-419,4"
		
	elseif layout == 'v2' then
		E.db.actionbars = nil
		
		E.db["actionbar"]["bar3"]["buttonsize"] = 24
		E.db["actionbar"]["bar3"]["buttons"] = 12
		E.db["actionbar"]["bar3"]["buttonsPerRow"] = 6
		E.db["actionbar"]["fontSize"] = 12
		E.db["actionbar"]["microbar"]["mouseover"] = true
		E.db["actionbar"]["keyDown"] = false
		E.db["actionbar"]["bar2"]["enabled"] = false
		E.db["actionbar"]["bar2"]["inheritGlobalFade"] = true
		E.db["actionbar"]["bar2"]["buttons"] = 8
		E.db["actionbar"]["bar2"]["buttonsPerRow"] = 4
		E.db["actionbar"]["bar2"]["buttonsize"] = 24
		E.db["actionbar"]["bar1"]["buttonsize"] = 50
		E.db["actionbar"]["bar1"]["buttons"] = 12
		E.db["actionbar"]["bar1"]["buttonsPerRow"] = 12
		E.db["actionbar"]["bar4"]["enabled"] = false
		E.db["actionbar"]["bar5"]["buttonsize"] = 24
		E.db["actionbar"]["bar5"]["buttons"] = 12
		E.db["actionbar"]["bar5"]["buttonsPerRow"] = 6
		E.db["actionbar"]["globalFadeAlpha"] = 0.85
		E.db["actionbar"]["fontOutline"] = "OUTLINE"
		E.db["actionbar"]["font"] = "Expressway"
		E.db["actionbar"]["bar6"]["enabled"] = false
		E.db["actionbar"]["bar6"]["inheritGlobalFade"] = true
		E.db["actionbar"]["bar6"]["buttons"] = 8
		E.db["actionbar"]["bar6"]["buttonsPerRow"] = 4
		E.db["actionbar"]["bar6"]["visibility"] = "[vehicleui] hide; [overridebar] hide; [petbattle] hide; show\n\n\n"
		E.db["actionbar"]["bar6"]["buttonsize"] = 24
		E.db["actionbar"]["stanceBar"]["point"] = "TOPRIGHT"
		E.db["actionbar"]["stanceBar"]["buttonsize"] = 25
		E.db["actionbar"]["stanceBar"]["usePositionOverride"] = false
		E.db["actionbar"]["barPet"]["buttonsPerRow"] = 10
		E.db["actionbar"]["barPet"]["inheritGlobalFade"] = true
		E.db["actionbar"]["barPet"]["backdrop"] = false
		E.db["actionbar"]["barPet"]["buttonsize"] = 28
		E.db["actionbar"]["backdropSpacingConverted"] = true

		-- Movers
		E.db["movers"]["VehicleSeatMover"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,5,305"
		E.db["movers"]["PetAB"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,4,190"
		E.db["movers"]["ElvAB_1"] = "BOTTOM,ElvUIParent,BOTTOM,0,4"
		E.db["movers"]["ElvAB_2"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,561,4"
		E.db["movers"]["ElvAB_3"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-485,4"
		E.db["movers"]["ElvAB_5"] = "BOTTOMLEFT,ElvUIParent,BOTTOMLEFT,485,4"
		E.db["movers"]["ElvAB_6"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-561,4"
		E.db["movers"]["ShiftAB"] = "BOTTOMRIGHT,ElvUIParent,BOTTOMRIGHT,-4,190"

		
	end
	
	PluginInstallStepComplete.message = TTUIRM.Title..L['Actionbars Set']
	PluginInstallStepComplete:Show()
	E:UpdateAll(true)
end

	
local addonNames = {}
local profilesFailed = format('|cff00c0fa%s |r', L["ThinkTankUI: Remastered didn't find any supported addons for profile creation"])
	
local function SetupAddons()
	-- Location Plus
	if TTUIRM.LP then
		TTUIRM:LoadLocationPlusProfile()
		tinsert(addonNames, 'Location Plus')
	end
	
	--Details - Settings
	if IsAddOnLoaded("Details") then
		TTUIRM:LoadDetailsProfile()
		tinsert(addonNames, 'Details')
	end	
	
	--	Skada - Settings
	if IsAddOnLoaded("Skada") then
		TTUIRM:LoadSkadaProfile()
		tinsert(addonNames, 'Skada')
	end
	
	-- Deadly Boss Mods
	if IsAddOnLoaded("DBM-Core") then
		TTUIRM:LoadDBMProfile()
		tinsert(addonNames, 'Deadly Boss Mods')
	end
	
	--	AddOnSkins - Settings
	if IsAddOnLoaded("AddOnSkins") then
		TTUIRM:LoadAddOnSkinsProfile()
		tinsert(addonNames, 'AddOnSkins')
	end

	--	BigWigs - Settings
	if IsAddOnLoaded("BigWigs") then
		TTUIRM:LoadBigWigsProfile()
		tinsert(addonNames, 'BigWigs')
	end
	
	--	xCT_Plus - Settings
	if IsAddOnLoaded("xCT+") then
		TTUIRM:LoadxCT_PlusProfile()
		tinsert(addonNames, 'xCT+')
	end
	
	-- MikScrollingBattleText
	if TTUIRM:IsAddOnEnabled('MikScrollingBattleText') then
		TTUIRM:LoadMSBTProfile()
		tinsert(addonNames, "Mik's Scrolling Battle Text")
	end

	
--	Raven - Settings
	if IsAddOnLoaded("Raven") then
		TTUIRM:LoadRavenProfile()
		tinsert(addonNames, 'Raven')
	end

	if checkTable(addonNames) ~= nil then
		local profileString = format('|cfffff400%s |r', L['ThinkTankUI Remastered successfully created and applied profile(s) for:']..'\n')

		tsort(addonNames, function(a, b) return a < b end)
		local names = tconcat(addonNames, ", ")
		profileString = profileString..names

		PluginInstallFrame.Desc4:SetText(profileString..'.')
	else
		PluginInstallFrame.Desc4:SetText(profilesFailed)
	end

	PluginInstallStepComplete.message = TTUIRM.Title..L['Addons Set']
	PluginInstallStepComplete:Show()
	twipe(addonNames)
	E:UpdateAll(true)
end

local function SetupDataTexts(role)
--Datatexts--
		
	if TTUIRM.LP then
		E.db["datatexts"]["panels"]["LeftCoordDtPanel"] = "Guild"
		E.db["datatexts"]["panels"]["RightCoordDtPanel"] = "Friends"
	end
	
	if role == 'tank' then
		E.db["datatexts"]["panels"]["LeftChatDataPanel"]["left"] = 'Attack Power'
		E.db["datatexts"]["panels"]["LeftChatDataPanel"]["middle"] = 'Avoidance'
		E.db["datatexts"]["panels"]["LeftChatDataPanel"]["right"] = 'Armor'
		E.db["datatexts"]["panels"]["RightChatDataPanel"]["right"] = "Talent/Loot Specialization"
		E.db["datatexts"]["panels"]["RightChatDataPanel"]["left"] = "Bags"
		E.db["datatexts"]["panels"]["RightChatDataPanel"]["middle"] = "Gold"
	elseif role == 'dpsMelee' then
		E.db["datatexts"]["panels"]["LeftChatDataPanel"]["left"] = 'Attack Power'
		E.db["datatexts"]["panels"]["LeftChatDataPanel"]["middle"] = 'Haste'
		E.db["datatexts"]["panels"]["LeftChatDataPanel"]["right"] = 'Crit Chance'
		E.db["datatexts"]["panels"]["RightChatDataPanel"]["right"] = "Talent/Loot Specialization"
		E.db["datatexts"]["panels"]["RightChatDataPanel"]["left"] = "Bags"
		E.db["datatexts"]["panels"]["RightChatDataPanel"]["middle"] = "Gold"
	elseif role == 'healer' or 'dpsCaster' then
		E.db["datatexts"]["panels"]["LeftChatDataPanel"]["left"] = 'Spell/Heal Power'
		E.db["datatexts"]["panels"]["LeftChatDataPanel"]["middle"] = 'Haste'
		E.db["datatexts"]["panels"]["LeftChatDataPanel"]["right"] = 'Crit Chance'
		E.db["datatexts"]["panels"]["RightChatDataPanel"]["right"] = "Talent/Loot Specialization"
		E.db["datatexts"]["panels"]["RightChatDataPanel"]["left"] = "Bags"
		E.db["datatexts"]["panels"]["RightChatDataPanel"]["middle"] = "Gold"
	end
	
	PluginInstallStepComplete.message = TTUIRM.Title..L['Datatexts Set']
	PluginInstallStepComplete:Show()
	E:UpdateAll(true)	
end

local function InstallComplete()
	E.private.TTUIRM.install_complete = TTUIRM.Version
	E.db.TTUIRM.installed = true
	if GetCVarBool("Sound_EnableMusic") then
		StopMusic()
	end

	ReloadUI()
end


TTUIRM.TTUIRMInstallTable = {
	Name = "|cff9482c9ThinkTankUI Remastered|r",
	Title = L["|cff9482c9ThinkTankUI Remastered|r Installation"],
	tutorialImage = [[Interface\AddOns\ElvUI_ThinkTankUI_RM\media\textures\ThinkTankUI_Remastered]],
	Pages = {
		[1] = function()
			PluginInstallFrame.SubTitle:SetFormattedText(L["Welcome to ThinkTankUI [Remastered] |cff00c0faVersion|r %s, for ElvUI %s."], TTUIRM.Version, E.version)
			PluginInstallFrame.Desc1:SetText(L["By pressing the Continue button, ThinkTankUI Remastered will be applied in your current ElvUI installation.\r|cffff8000 TIP: If you apply the changes in a new profile, you can always change back if you don't like the result.|r"])
			PluginInstallFrame.Desc2:SetText(L["Please press the continue button to go onto the next step."])
			PluginInstallFrame.Option1:Show()
			PluginInstallFrame.Option1:SetScript("OnClick", function() InstallComplete() end)
			PluginInstallFrame.Option1:SetText(L["Skip Process"])
		end,
		[2] = function()
			PluginInstallFrame.SubTitle:SetText(L["Chat"])
			PluginInstallFrame.Desc1:SetText(L["This is the part where we set up your chat/colors."])
			PluginInstallFrame.Desc2:SetText(L["This button will set up your chat windows."])
			PluginInstallFrame.Desc3:SetText(L["Importance: |cffD3CF00Medium|r"])
			PluginInstallFrame.Option1:Show()
			PluginInstallFrame.Option1:SetScript("OnClick", function() SetupChat() end)
			PluginInstallFrame.Option1:SetText(L["Set Chat"])
		end,
		[3] = function()
			PluginInstallFrame.SubTitle:SetText(L["Layout"])
			PluginInstallFrame.Desc1:SetText(L["This is the standard layout for ThinkTankUI Remastered."])
			PluginInstallFrame.Desc2:SetText(L["This will set the Minimap, Databars, and some general settings for ThinkTankUI Remastered "])
			PluginInstallFrame.Desc3:SetFormattedText(L["Importance: |cffFF0000High|r"])

			PluginInstallFrame.Option1:Show()
			PluginInstallFrame.Option1:SetScript('OnClick', function() SetupLayout(); end) 
			PluginInstallFrame.Option1:SetText("Set Layout")
		end,
		[4] = function()
			PluginInstallFrame.SubTitle:SetText(L["Unitframes"])
			PluginInstallFrame.Desc1:SetText(L["These are the Uniframe Layouts for ThinkTankUI Remastered"])
			PluginInstallFrame.Desc2:SetText(L["This will apply the settings based on the Specialization you choose for |cff9482c9ThinkTankUI Remastered|r. Click the Button to apply these settings. A New Profile should be made for multiple layouts."])
			PluginInstallFrame.Desc3:SetText(L["Importance: |cffFF0000High|r"])

			PluginInstallFrame.Option1:Show()
			PluginInstallFrame.Option1:SetScript('OnClick', function() SetupUnitframes('v1'); end)
			PluginInstallFrame.Option1:SetText("Dps/Tank")
			
			PluginInstallFrame.Option2:Show()
			PluginInstallFrame.Option2:SetScript('OnClick', function() SetupUnitframes('v2'); end)
			PluginInstallFrame.Option2:SetText("Healer")
		end,
		[5] = function()
			PluginInstallFrame.SubTitle:SetText(L["Actionbars"])
			PluginInstallFrame.Desc1:SetText(L["These are the layouts for the 2 types of actionbars for ThinkTankUI Remastered"])
			PluginInstallFrame.Desc2:SetText(L["There are 2 Actionbar Layouts. Make sure to preview them both."])
			PluginInstallFrame.Desc3:SetText(L["Importance: |cffFF0000High|r"])

			PluginInstallFrame.Option1:Show()
			PluginInstallFrame.Option1:SetScript('OnClick', function() SetupActionbars('v1'); end) 
			PluginInstallFrame.Option1:SetText("Version 1")
			
			PluginInstallFrame.Option2:Show()
			PluginInstallFrame.Option2:SetScript('OnClick', function() SetupActionbars('v2'); end)
			PluginInstallFrame.Option2:SetText("Version 2")
		end,
		[6] = function()
			PluginInstallFrame.SubTitle:SetText(L["Addon Profiles"])
			PluginInstallFrame.Desc1:SetText(L["Creates Addon Profiles for ThinkTankUI Remastered."])
			PluginInstallFrame.Desc2:SetText()
			PluginInstallFrame.Desc3:SetText(L["Importance: |cffD3CF00High|r"])

			PluginInstallFrame.Option1:Show()
			PluginInstallFrame.Option1:SetScript('OnClick', function() SetupAddons() end)
			PluginInstallFrame.Option1:SetText("Set Addon Profiles")
		end,
		[7] = function()
			PluginInstallFrame.SubTitle:SetText(L["DataTexts"])
			PluginInstallFrame.Desc1:SetText(L["This part of the installation process will change the ElvUI DataTexts based on the chosen role of your character."])
			PluginInstallFrame.Desc2:SetText(L["Please click the button below to setup your datatexts."])
			PluginInstallFrame.Desc3:SetText(L["Importance: |cffD3CF00Medium|r"])
			PluginInstallFrame.Option1:Show()
			PluginInstallFrame.Option1:SetScript("OnClick", function() E.db.datatexts.panels.LeftChatDataPanel.left = nil; E.db.datatexts.panels.LeftChatDataPanel.middle = nil; E.db.datatexts.panels.LeftChatDataPanel.right = nil; E.db.datatexts.panels.RightChatDataPanel.left = nil; E.db.datatexts.panels.RightChatDataPanel.middle = nil; E.db.datatexts.panels.RightChatDataPanel.right = nil; SetupDataTexts("tank") end)
			PluginInstallFrame.Option1:SetText(TANK)
			PluginInstallFrame.Option2:Show()
			PluginInstallFrame.Option2:SetScript("OnClick", function() E.db.datatexts.panels.LeftChatDataPanel.left = nil; E.db.datatexts.panels.LeftChatDataPanel.middle = nil; E.db.datatexts.panels.LeftChatDataPanel.right = nil; E.db.datatexts.panels.RightChatDataPanel.left = nil; E.db.datatexts.panels.RightChatDataPanel.middle = nil; E.db.datatexts.panels.RightChatDataPanel.right = nil;  SetupDataTexts("healer") end)
			PluginInstallFrame.Option2:SetText(HEALER)
			PluginInstallFrame.Option3:Show()
			PluginInstallFrame.Option3:SetScript("OnClick", function() E.db.datatexts.panels.LeftChatDataPanel.left = nil; E.db.datatexts.panels.LeftChatDataPanel.middle = nil; E.db.datatexts.panels.LeftChatDataPanel.right = nil; E.db.datatexts.panels.RightChatDataPanel.left = nil; E.db.datatexts.panels.RightChatDataPanel.middle = nil; E.db.datatexts.panels.RightChatDataPanel.right = nil;  SetupDataTexts("dpsMelee") end)
			PluginInstallFrame.Option3:SetText(L["Physical DPS"])
			PluginInstallFrame.Option4:Show()
			PluginInstallFrame.Option4:SetScript("OnClick", function() E.db.datatexts.panels.LeftChatDataPanel.left = nil; E.db.datatexts.panels.LeftChatDataPanel.middle = nil; E.db.datatexts.panels.LeftChatDataPanel.right = nil; E.db.datatexts.panels.RightChatDataPanel.left = nil; E.db.datatexts.panels.RightChatDataPanel.middle = nil; E.db.datatexts.panels.RightChatDataPanel.right = nil; SetupDataTexts("dpsCaster") end)
			PluginInstallFrame.Option4:SetText(L["Caster DPS"])
		end,
		[8] = function()
			PluginInstallFrame.SubTitle:SetText(L["Installation Complete"])
			PluginInstallFrame.Desc1:SetText(L["You are now finished with the installation process. If you are in need of technical support please visit us at http://www.tukui.org."])
			PluginInstallFrame.Desc2:SetText(L["Please click the button below so you can setup variables and ReloadUI."])

			PluginInstallFrame.Option1:Show()
			PluginInstallFrame.Option1:SetScript("OnClick", InstallComplete)
			PluginInstallFrame.Option1:SetText(L["Installed"])
		end,
	},
	StepTitles = {
		 [1] = START,
		 [2] = L["Chat"],
		 [3] = L["Layout"],
		 [4] = L["Unitframes"],
		 [5] = L["Actionbars"],
		 [6] = L["Addon Profiles"],
		 [7] = L["DataTexts"],
		 [8] = L["Installation Complete"],
	},
	StepTitlesColor = {1, 1, 1},
	StepTitlesColorSelected = {0, 179/255, 1},
	StepTitleWidth = 200,
	StepTitleButtonWidth = 180,
	StepTitleTextJustification = "RIGHT",

}

