local E, L, V, P, G = unpack(ElvUI)
local TTUIRM = E:NewModule('ThinkTankUI Remastered', 'AceHook-3.0', 'AceEvent-3.0', 'AceTimer-3.0', "AceConsole-3.0");

local LSM = LibStub('LibSharedMedia-3.0')
local EP = LibStub('LibElvUIPlugin-1.0')
local addon, ns = ...

local _G = _G
local pairs, print = pairs, print
local format = string.format
local CreateFrame = CreateFrame
local C_TimerAfter = C_Timer.After

TTUIRM.Config = {}
TTUIRM["styles"] = {}
TTUIRM["softGlow"] = {}
TTUIRM.TexCoords = {.08, 0.92, -.04, 0.92}
TTUIRM.Title = format('|cff00c0fa%s |r', 'TTUIRM')
TTUIRM.Version = GetAddOnMetadata('ElvUI_ThinkTankUI_RM', 'Version')
TTUIRM.NewSign = '|TInterface\\OptionsFrame\\UI-OptionsFrame-NewFeatureIcon:14:14|t'
BINDING_HEADER_TTUIRM = TTUIRM.Title

function TTUIRM:IsAddOnEnabled(addon) -- Credit: Azilroka
	return GetAddOnEnableState(E.myname, addon) == 2
end

-- Check other addons
TTUIRM.LP = TTUIRM:IsAddOnEnabled('ElvUI_LocPlus')

local classColor = E.myclass == 'PRIEST' and E.PriestColors or (CUSTOM_CLASS_COLORS and CUSTOM_CLASS_COLORS[E.myclass] or RAID_CLASS_COLORS[E.myclass])

function TTUIRM:cOption(name)
	local color = '|cff00c0fa%s |r'
	return (color):format(name)
end

function TTUIRM:PrintURL(url) -- Credit: Azilroka
	return format("|cFF00c0fa[|Hurl:%s|h%s|h]|r", url, url)
end

function TTUIRM:AddOptions()
	for _, func in pairs(TTUIRM.Config) do
		func()
	end
end

function TTUIRM:LoadOptions()
	E:ToggleConfig(); LibStub("AceConfigDialog-3.0-ElvUI"):SelectGroup("ElvUI", "ttuirm")
end

function TTUIRM:LoadCommands()
	self:RegisterChatCommand("ttuirm", "LoadOptions")
	self:RegisterChatCommand("ttuirmsetup", "SetupTTUIRM")
end

local function CreateSplashScreen()
	local f = CreateFrame('Frame', 'TTUIRMSplashScreen', E.UIParent)
	f:Size(300, 150)
	f:SetPoint('CENTER')
	f:SetFrameStrata('TOOLTIP')
	f:SetAlpha(0)

	f.bg = f:CreateTexture(nil, 'BACKGROUND')
	f.bg:SetTexture([[Interface\LevelUp\LevelUpTex]])
	f.bg:SetPoint('BOTTOM')
	f.bg:Size(400, 200)
	f.bg:SetTexCoord(0.00195313, 0.63867188, 0.03710938, 0.23828125)
	f.bg:SetVertexColor(1, 1, 1, 0.7)

	f.lineTop = f:CreateTexture(nil, 'BACKGROUND')
	f.lineTop:SetDrawLayer('BACKGROUND', 2)
	f.lineTop:SetTexture([[Interface\LevelUp\LevelUpTex]])
	f.lineTop:SetPoint("TOP")
	f.lineTop:Size(418, 7)
	f.lineTop:SetTexCoord(0.00195313, 0.81835938, 0.01953125, 0.03320313)

	f.lineBottom = f:CreateTexture(nil, 'BACKGROUND')
	f.lineBottom:SetDrawLayer('BACKGROUND', 2)
	f.lineBottom:SetTexture([[Interface\LevelUp\LevelUpTex]])
	f.lineBottom:SetPoint("BOTTOM")
	f.lineBottom:Size(418, 7)
	f.lineBottom:SetTexCoord(0.00195313, 0.81835938, 0.01953125, 0.03320313)

	f.logo = f:CreateTexture(nil, 'OVERLAY')
	f.logo:Size(256, 128)
	f.logo:SetTexture('Interface\\AddOns\\ElvUI_ThinkTankUI_RM\\media\\textures\\logo_ThinkTankUI_Remastered.tga')
	f.logo:Point('CENTER', f, 'CENTER')

	f.version = f:CreateFontString(nil, 'OVERLAY')
	f.version:FontTemplate(nil, 12, nil)
	f.version:Point('TOP', f.logo, 'BOTTOM')
	f.version:SetFormattedText("v%s", TTUIRM.Version)
end

local function HideSplashScreen()
	TTUIRMSplashScreen:Hide()
end

local function FadeSplashScreen()
	E:Delay(2, function()
		E:UIFrameFadeOut(TTUIRMSplashScreen, 2, 1, 0)
		TTUIRMSplashScreen.fadeInfo.finishedFunc = HideSplashScreen
	end)
end

local function ShowSplashScreen()
	E:UIFrameFadeIn(TTUIRMSplashScreen, 4, 0, 1)
	TTUIRMSplashScreen.fadeInfo.finishedFunc = FadeSplashScreen
end

function TTUIRM:Initialize()
	self:LoadCommands()

	if E.db.TTUIRM.general.splashScreen then
		CreateSplashScreen()
	end

	-- run install when ElvUI install finishes
    if E.private.install_complete == E.version and E.private.TTUIRM.install_complete == nil then
		E:GetModule("PluginInstaller"):Queue(TTUIRM.TTUIRMInstallTable)
	end
	
	-- Show Splash Screen only if the install is completed
	if (E.db.TTUIRM.installed == true and E.db.TTUIRM.general.splashScreen) then C_TimerAfter(6, ShowSplashScreen) end

	-- run the setup again when a profile gets deleted.
	local profileKey = ElvDB.profileKeys[E.myname..' - '..E.myrealm]
	if ElvDB.profileKeys and profileKey == nil then
		E:GetModule("PluginInstaller"):Queue(TTUIRM.TTUIRMInstallTable)
	end
	

	if E.db.TTUIRM.general.loginMessage then
		print(TTUIRM.Title..format('v|cff00c0fa%s|r',TTUIRM.Version)..L[' is loaded. For any issues or suggestions, please visit ']..TTUIRM:PrintURL('https://git.tukui.org/MaximumOverdrive/ThinkTankUI-Remastered/issues'))
	end
	EP:RegisterPlugin(addon, self.AddOptions)

end

local function InitializeCallback()
	TTUIRM:Initialize()
end

E:RegisterModule(TTUIRM:GetName(), InitializeCallback)