hoogsSavedMacros = {};
local sn = 0;
local keyWords = {};
local targetRoles = {};
local lastRoles = "firstrun";
local forceUpdate = "false";
local useType = {};
local rgb_1 = "|r|c66FFFF00";
local rgb_2 = "|r|c6600FF00";

local allKeyWords = {};
allKeyWords["role"] = {};
allKeyWords["role"]["TANK"] = "TANK";
allKeyWords["role"]["DAMAGER"] = "DPS";
allKeyWords["role"]["HEALER"] = "HEALER";

allKeyWords["class"] = {};
allKeyWords["class"]["WARRIOR"] = "WAR";
allKeyWords["class"]["PALADIN"] = "PALLY";
allKeyWords["class"]["HUNTER"] = "HUNTER";
allKeyWords["class"]["ROGUE"] = "ROGUE";
allKeyWords["class"]["PRIEST"] = "PRIEST";
allKeyWords["class"]["DEATHKNIGHT"] = "DK";
allKeyWords["class"]["DEMONHUNTER"] = "DH";
allKeyWords["class"]["SHAMAN"] = "SHAMAN";
allKeyWords["class"]["MAGE"] = "MAGE";
allKeyWords["class"]["WARLOCK"] = "LOCK";
allKeyWords["class"]["MONK"] = "MONK";
allKeyWords["class"]["DRUID"] = "DRUID";

local function reduceKeyWords()
  local i = 0;
  local macrosStr = {};
  for _, macroBody in pairs(hoogsSavedMacros) do
    i = i + 1;
    macrosStr[i] = macroBody;
  end
  
  local searchAllMacros = table.concat(macrosStr, " ");

  keyWords = {};
  useType = {};

  for keyType, keyPairs in pairs(allKeyWords) do
    for rawword, keyword in pairs(keyPairs) do
      if string.find(searchAllMacros, keyword) ~= nil then
        keyWords[rawword] = keyword;
        useType[keyType] = "true";
      end
    end
  end
  if string.find(searchAllMacros, "PET") ~= nil then
    keyWords["PET"] = "PET";
    useType["class"] = "true";
  end
end

local function resetSavedMacros()
  for macroName, macroBody in pairs(hoogsSavedMacros) do
    local macroIndex = GetMacroIndexByName(macroName);
    EditMacro(macroIndex, nil, nil, macroBody);
    print(rgb_1.."'"..macroName.."' has been reset");
  end
end

local function defGsub(str,find)
  str = string.gsub(str, "("..find.."%d*)/?([/%w]*)", function (a,b)
    if targetRoles[a] then
      return targetRoles[a];
    else
      return defGsub(b,find);
    end
  end);

  for _, keyword in pairs(keyWords) do
    if string.find(str, keyword) ~= nil then
      str = defGsub(str,keyword)
    end
  end

  return str;
end;

local function findReplace(str,find)
  str = string.gsub(str, "<("..find.."%d*)/?([/%w]*)>", function (a,b)
    if targetRoles[a] then
      return targetRoles[a];
    else
      return defGsub(b,find);
    end
  end);
  
  if string.find(str, find) ~= nil and find ~= "" then
    str = string.gsub(str, "("..find.."%d*[/%w]*)", "<%1>");
    str = findReplace(str,find);
  end;
  
  return str;
end;

local function updateMacros()
  for macroName, macroBody in pairs(hoogsSavedMacros) do

    for _, keyword in pairs(keyWords) do
      if string.find(macroBody, keyword) ~= nil then
        macroBody = findReplace(macroBody,keyword);
      end
    end

    local macroIndex = GetMacroIndexByName(macroName);
    EditMacro(macroIndex, nil, nil, macroBody);
  end
end

local function plusOne(arr)
  if arr == null then
    return 1;  
  else
    return arr+1;  
  end
end

local function getUnitInfo()
  local inLockdown = InCombatLockdown();
  if inLockdown == 1 then
    print(rgb_1.."TargetRole: you are in combat. macros cannot be updated");
    return;
  end

  targetRoles = {};    
  local gatherStr = {};
  local gCount = GetNumGroupMembers();
  local gType = "raid";
  if IsInRaid() == false then 
    gType = "party";
  end

  if gCount>0 then
    local idNum = {};

    for N=1,gCount,1 do
  		local gUnit = gType..N;
  		local gPet = gType.."pet"..N;
      local rawRole, _, rawClass, rawPower;

      if useType["role"] ~= nil then
        rawRole = UnitGroupRolesAssigned(gUnit);        
        if keyWords[rawRole] ~= nil then 
          local unitRole = keyWords[rawRole];
          idNum[unitRole] = plusOne(idNum[unitRole]);
          local unitRoleNum = unitRole..idNum[unitRole];
          targetRoles[unitRoleNum] = gUnit;
          targetRoles[unitRole] = targetRoles[unitRole.."1"];
          table.insert(gatherStr,rawRole);
        end
      end

      if useType["class"] ~= nil then
        _, rawClass = UnitClass(gUnit);        
        if rawClass == "HUNTER" or rawClass == "DEATHKNIGHT" or rawClass == "MAGE" then 
          idNum["PET"] = plusOne(idNum["PET"]);
          local unitPetNum = "PET"..idNum["PET"];
          targetRoles[unitPetNum] = gPet;
          targetRoles["PET"] = targetRoles["PET1"];
        end
        if keyWords[rawClass] ~= nil then 
          local unitClass = keyWords[rawClass];
          idNum[unitClass] = plusOne(idNum[unitClass]);
          local unitClassNum = unitClass..idNum[unitClass];
          targetRoles[unitClassNum] = gUnit;
          targetRoles[unitClass] = targetRoles[unitClass.."1"];
          table.insert(gatherStr,rawClass);
        end
      end

    end
  end

  local rolesToStr = table.concat(gatherStr, " ");

  if rolesToStr ~= lastRoles or forceUpdate == "true" then  
    forceUpdate = "false";
    updateMacros();
  end

  lastRoles = rolesToStr;
end

SLASH_TARGETROLE1, SLASH_TARGETROLE2 = '/tr', '/targetrole';
local function slashHandler(msg, editbox)
  local command, rest = msg:match("^(%S*)%s*(.-)$");
  if command == "add" and rest ~= "" then
    local macroBody = GetMacroBody(rest);
    if macroBody == nil then     
      print(rgb_1.."no macro named '"..rest.."' found");
    else
      hoogsSavedMacros[rest] = macroBody;
      print(rgb_1.."added '"..rest.."'");
      forceUpdate = "true";
      reduceKeyWords();
      getUnitInfo();
    end
  elseif command == "remove" and rest ~= "" then   
    hoogsSavedMacros[rest] = nil;
    print(rgb_1.."removed '"..rest.."'");
    reduceKeyWords();
  elseif command == "reset" then
    resetSavedMacros();
  elseif command == "list" then
    for macroName, macroBody in pairs(hoogsSavedMacros) do
      local macroIndex = GetMacroIndexByName(macroName);
      print(rgb_1..macroName..":\n"..rgb_2..macroBody);
    end
  elseif command == "run" then
    forceUpdate = "true";
    reduceKeyWords();
    getUnitInfo();
  else
    print(
      rgb_1.."Commands available:"
      ..rgb_2
      .."\n/targetrole add [macro name]"
      .."\n/targetrole remove [macro name]"
      .."\n/targetrole reset"
      .."\n/targetrole list"
    );
    print(rgb_1.."You may replace "..rgb_2.."/targetrole"..rgb_1.." with "..rgb_2.."/tr");
  end
end
SlashCmdList["TARGETROLE"] = slashHandler;

local frame = CreateFrame("FRAME", "hoogsTargetRole");
frame:RegisterEvent("PLAYER_ENTERING_WORLD");
frame:RegisterEvent("ADDON_LOADED");
frame:RegisterEvent("LFG_ROLE_UPDATE");
frame:RegisterEvent("PLAYER_ROLES_ASSIGNED");
frame:RegisterEvent("GROUP_ROSTER_UPDATE");
frame:RegisterEvent("PLAYER_REGEN_ENABLED");

local singleshot = {};
local function eventHandler(self, event, arg1)
  local runtime = time();
  if event == "ADDON_LOADED" and arg1 == "TargetRole" then
    frame:UnregisterEvent("ADDON_LOADED");
    for _ in pairs(hoogsSavedMacros) do sn = sn + 1 end
    print(rgb_1.."TargetRole loaded "..sn.." macros. "..rgb_2.."/targetrole help");
    reduceKeyWords();
  elseif singleshot[runtime] == nil then
    singleshot[runtime] = 1;
    getUnitInfo(); 
  end
end
frame:SetScript("OnEvent", eventHandler);