local FOLDER_NAME, SCA = ...
local GetSpellInfo = GetSpellInfo

local specDetails = {
	["DEATHKNIGHT"] = {
		numSpecs = 3,
		[1] = { -- Blood
			label = "Blood",
			specID = 250,
		},
		[2] = { -- Frost
			label = "Frost",
			specID = 251,
		},
		[3] = { -- Unholy
			label = "Unholy",
			specID = 252,
		},
	},
	["DEMONHUNTER"] = {
		numSpecs = 2,
		[1] = { -- Havok
			label = "Havok",
			specID = 577,
		},
		[2] = { --Vengeance
			label = "Vengeance",
			specID = 581,
		},
	},
	["DRUID"] = {
		numSpecs = 4,
		[1] = { -- Balance
			label = "Balance",
			specID = 102,
		},
		[2] = { -- Feral
			label = "Feral",
			specID = 103,
		},
		[3] = { -- Guardian
			label = "Guardian",
			specID = 104,
		},
		[4] = { -- Restoration
			label = "Restoration",
			specID = 105,
		},
	},
	["HUNTER"] = {
		numSpecs = 3,
		[1] = { -- Beast Mastery
			label = "Beast Mastery",
			specID = 253,
		},
		[2] = { -- Marksmanship
			label = "Marksmanship",
			specID = 254,
		},
		[3] = { -- Survival
			label = "Survival",
			specID = 255,
		},
	},
	["MAGE"] = {
		numSpecs = 3,
		[1] = { -- Arcane
			label = "Arcane",
			specID = 62,
		},
		[2] = { -- Fire
			label = "Fire",
			specID = 63,
		},
		[3] = { -- Frost
			label = "Frost",
			specID = 64,
		},
	},
	["MONK"] = {
		numSpecs = 3,
		[1] = { -- Brewmaster
			label = "Brewmaster",
			specID = 268,
		},
		[2] = { -- Mistweaver
			label = "Mistweaver",
			specID = 270,
		},
		[3] = { -- Windwalker
			label = "Windwalker",
			specID = 269,
		},
	},
	["PALADIN"] = {
		numSpecs = 3,
		[1] = { -- Holy
			label = "Holy",
			specID = 65,
		},
		[2] = { -- Protection
			label = "Protection",
			specID = 66,
		},
		[3] = { -- Retribution
			label = "Retribution",
			specID = 70,
		},
	},
	["PRIEST"] = {
		numSpecs = 3,
		[1] = { -- Discipline
			label = "Discipline",
			specID = 256,
		},
		[2] = { -- Holy
			label = "Holy",
			specID = 257,
		},
		[3] = { -- Shadow
			label = "Shadow",
			specID = 258,
		},
	},
	["ROGUE"] = {
		numSpecs = 3,
		[1] = { -- Assassination
			label = "Assassination",
			specID = 259,
		},
		[2] = { -- Outlaw
			label = "Outlaw",
			specID = 260,
		},
		[3] = { -- Subtlety
			label = "Subtlety",
			specID = 261,
		},
	},
	["SHAMAN"] = {
		numSpecs = 3,
		[1] = { -- Elemental
			label = "Elemental",
			specID = 262,
		},
		[2] = { -- Enhancement
			label = "Enhancement",
			specID = 263,
		},
		[3] = { -- Restoration
			label = "Restoration",
			specID = 264,
		},
	},
	["WARLOCK"] = {
		numSpecs = 3,
		[1] = { -- Affliction
			label = "Affliction",
			specID = 265,
		},
		[2] = { -- Demonology
			label = "Demonology",
			specID = 266,
		},
		[3] = { -- Destruction
			label = "Destruction",
			specID = 267,
		},
	},
	["WARRIOR"] = {
		numSpecs = 3,
		[1] = { -- Arms
			label = "Arms",
			specID = 71,
		},
		[2] = { -- Fury
			label = "Fury",
			specID = 72,
		},
		[3] = { -- Protection
			label = "Protection",
			specID = 73,
		},
	},
}

local healSpells = {
	["DEATHKNIGHT"] = {
		[1] = { -- Blood
			[194844] = true, -- Bonestorm
			[205223] = true, -- Consumption (Artifact)
			[49998] = true,  -- Death Strike
			[206940] = true, -- Mark of Blood
		},
		[2] = { -- Frost
			[49998] = true,  -- Death Strike
		},
		[3] = { -- Unholy
			[49998] = true,  -- Death Strike
		},
	},
	["DEMONHUNTER"] = {
		[1] = { -- Havok
			
		},
		[2] = { -- Vengeance
			[212084] = true, -- Fel Devastation
			[203782] = true, -- Shear
			[228477] = true, -- Soul Cleave
			[247454] = true, -- Spirit Bomb
		},
	},
	["DRUID"] = {
		[1] = { -- Balance
			[22842] = true,  -- Frenzied Regeneration
			[5185] = true,   -- Healing Touch
			[8936] = true,   -- Regrowth
			[774] = true,    -- Rejuvenation
			[108238] = true, -- Renewal
			[18562] = true,  -- Swiftmend
			[145108] = true, -- Ysera's Gift
		},
		[2] = { -- Feral
			[22842] = true,  -- Frenzied Regeneration
			[5185] = true,   -- Healing Touch
			[8936] = true,   -- Regrowth
			[774] = true,    -- Rejuvenation
			[108238] = true, -- Renewal
			[18562] = true,  -- Swiftmend
			[145108] = true, -- Ysera's Gift
		},
		[3] = { -- Guardian
			[22842] = true,  -- Frenzied Regeneration
			[5185] = true,   -- Healing Touch
			[204066] = true, -- Lunar Beam
			[8936] = true,   -- Regrowth
			[774] = true,    -- Rejuvenation
			[18562] = true,  -- Swiftmend
			[145108] = true, -- Ysera's Gift
		},
		[4] = { -- Restoration
			[102351] = true, -- Cenarion Ward
			[20552] = true,  -- Cultivation
			[145205] = true, -- Efflorescence
			[22842] = true,  -- Frenzied Regeneration
			[5185] = true,   -- Healing Touch
			[33763] = true,  -- Lifebloom
			[8936] = true,   -- Regrowth
			[774] = true,    -- Rejuvenation
			[108238] = true, -- Renewal
			[740] = true,    -- Tranquility
			[48438] = true,  -- Wild Growth
			[145108] = true, -- Ysera's Gift
		},
	},
	["HUNTER"] = {
		[1] = { -- Beast Mastery
			[109304] = true, -- Exhilaration
		},
		[2] = { -- Marksmanship
			[109304] = true, -- Exhilaration
		},
		[3] = { -- Survival
			[109304] = true, -- Exhilaration
			[212640] = true, -- Mending Bandage
		},
	},
	["MAGE"] = {
		[1] = { -- Arcane
		
		},
		[2] = { -- Fire
		
		},
		[3] = { -- Frost
		
		},
	},
	["MONK"] = {
		[1] = { -- Brewmaster
			[123986] = true, -- Chi Burst
			[115098] = true, -- Chi Wave
			[116694] = true, -- Effuse
		},
		[2] = { -- Mistweaver
			[123986] = true, -- Chi Burst
			[115098] = true, -- Chi Wave
			[116694] = true, -- Effuse
			[124682] = true, -- Enveloping Mist
			[191837] = true, -- Essence Font
			[205234] = true, -- Healing Sphere
			[198664] = true, -- Invoke Chi-Ji, the Red Crane
			[196725] = true, -- Refreshing Jade Wind
			[115151] = true, -- Renewing Mist
			[115310] = true, -- Revival
			[205406] = true, -- Sheilun's Gift (Artifact)
			[116670] = true, -- Vivify
			[124081] = true, -- Zen Pulse
		},
		[3] = { -- Windwalker
			[123986] = true, -- Chi Burst
			[115098] = true, -- Chi Wave
			[116694] = true, -- Effuse
		},
	},
	["PALADIN"] = {
		[1] = { -- Holy
			[223306] = true, -- Bestow Faith
			[19750] = true,  -- Flash of Light
			[82326] = true,  -- Holy Light
			[114165] = true, -- Holy Prism
			[20473] = true,  -- Holy Shock
			[633] = true,    -- Lay on Hands
			[85222] = true,  -- Light of Dawn
			[183998] = true, -- Light of the Martyr
			[114158] = true, -- Light's Hammer
			[200652] = true, -- Tyr's Deliverance (Artifact)
		},
		[2] = { -- Protection
			[26573] = true,  -- Consecration
			[19750] = true,  -- Flash of Light
			[213652] = true, -- Hand of the Protector
			[633] = true,    -- Lay on Hands
			[143924] = true, -- Leech
			[184092] = true, -- Light of the Protector
		},
		[3] = { -- Retribution
			[19750] = true,  -- Flash of Light
			[203539] = true, -- Greater Blessing of Wisdom
			[215661] = true, -- Justicar's Vengeance
			[633] = true,    -- Lay on Hands
			[143924] = true, -- Leech
			[210191] = true, -- Word of Glory
		},
	},
	["PRIEST"] = {
		[1] = { -- Discipline
			[110744] = true, -- Divine Star
			[2061] = true,   -- Flash Heal
			[120517] = true, -- Halo
			[47540] = true,  -- Penance
			[200829] = true, -- Plea
			[209780] = true, -- Premonition
			[194509] = true, -- Power Word: Radiance
			[214621] = true, -- Schism
			[204065] = true, -- Shadow Covenant
			[186263] = true, -- Shadow Mend
		},
		[2] = { -- Holy
			[32546] = true,  -- Binding Heal
			[214121] = true, -- Body and Mind
			[204883] = true, -- Circle of Healing
			[19236] = true,  -- Desperate Prayer
			[64843] = true,  -- Divine Hymn
			[110744] = true, -- Divine Star
			[2061] = true,   -- Flash Heal
			[120517] = true, -- Halo
			[2060] = true,   -- Heal
			[34861] = true,  -- Holy Word: Sanctify
			[2050] = true,   -- Holy Word: Serenity
			[596] = true,    -- Prayer of Healing
			[33076] = true,  -- Prayer of Mending
			[139] = true,    -- Renew
		},
		[3] = { -- Shadow
			[186263] = true, -- Shadow Mend
			[15286] = true,  -- Vampiric Embrace
			[34914] = true,  -- Vampiric Touch
		},
	},
	["ROGUE"] = {
		[1] = { -- Assassinations
			[185311] = true, -- Crimson Vial
		},
		[2] = { -- Outlaw
			[185311] = true, -- Crimson Vial
		},
		[3] = { -- Subtlety
			[185311] = true, -- Crimson Vial
		},
	},
	["SHAMAN"] = {
		[1] = { -- Elemental
			[108281] = true, -- Ancestral Guidance
			[8004] = true,   -- Healing Surge
		},
		[2] = { -- Enhancement
			[188070] = true, -- Healing Surge
			[215864] = true, -- Rainfall
		},
		[3] = { -- Restoration
			[108281] = true, -- Ancestral Guidance
			[1064] = true,   -- Chain Heal
			[157153] = true, -- Cloudburst Totem
			[204288] = true, -- Earth Shield
			[207778] = true, -- Gift of the Queen (Artifact)
			[73920] = true,  -- Healing Rain
			[5394] = true,   -- Healing Stream Totem
			[108280] = true, -- Healing Tide Totem
			[77472] = true,  -- Healing Wave
			[61295] = true,  -- Riptide
			[98008] = true,  -- Spirit Link Totem
			[73685] = true,  -- Unleash Life
			[197995] = true, -- Wellspring
		},
	},
	["WARLOCK"] = {
		[1] = { -- Affliction
			[198590] = true, -- Drain Soul
			[6789] = true,   -- Mortal Coil
			[205179] = true, -- Phantom Singularity
			[63106] = true,  -- Siphon Life
		},
		[2] = { -- Demonology
			[234153] = true, -- Drain Life
			[6789] = true,   -- Mortal Coil
		},
		[3] = { -- Destruction
			[234153] = true, -- Drain Life
			[6789] = true,   -- Mortal Coil
		},
	},
	["WARRIOR"] = {
		[1] = { -- Arms
			[202147] = true, -- Second Wind
			[34428] = true,  -- Victory Rush
		},
		[2] = { -- Fury
			[23881] = true,  -- Bloodthirst
		},
		[3] = { -- Protection
			[202168] = true, -- Impending Victory
		},
	},
}

local damageSpells = {
	["DEATHKNIGHT"] = {
		[1] = { -- Blood
			[206977] = true, -- Blood Mirror
			[55078] = true,  -- Blood Plague
			[206931] = true, -- Blooddrinker
			[194844] = true, -- Bonestorm
			[205223] = true, -- Consumption (Artifact)
			[49028] = true,  -- Dancing Rune Weapon
			[43265] = true,  -- Death and Decay
			[203173] = true, -- Death Chain
			[49998] = true,  -- Death Strike
			[195292] = true, -- Death's Caress
			[206930] = true, -- Heart Strike
			[195182] = true, -- Marrowrend
		},
		[2] = { -- Frost
			[152279] = true, -- Breath of Sindragosa
			[204160] = true, -- Chill Streak
			[207311] = true, -- Clawing Shadows
			[49998] = true,  -- Death Strike
			[55095] = true,  -- Frost Fever
			[49143] = true,  -- Frost Strike
			[207230] = true, -- Frostsythe
			[194913] = true, -- Glacial Advance
			[49184] = true,  -- Howling Blast
			[49020] = true,  -- Obliterate
			[196770] = true, -- Remorseless Winter
		},
		[3] = { -- Unholy
			[220143] = true, -- Apocalypse (Artifact)
			[43265] = true,  -- Death and Decay
			[49998] = true,  -- Death Strike
			[85948] = true,  -- Festering Strike
			[194311] = true, -- Festering Wound
			[77575] = true,  -- Outbreak
			[55090] = true,  -- Scourge Strike
			[191587] = true, -- Virulent Plague
		},
	},
	["DEMONHUNTER"] = {
		[1] = { -- Havok
			[188499] = true, -- Blade Dance
			[179057] = true, -- Chaos Nova
			[162794] = true, -- Chaos Strike
			[162243] = true, -- Demon's Bite
			[198013] = true, -- Eye Beam
			[206649] = true, -- Eye of Leotheras
			[211053] = true, -- Fel Barrage
			[211881] = true, -- Fel Eruption
			[206966] = true, -- Fel Lance
			[195072] = true, -- Fel Rush
			[232893] = true, -- Felblade
			[201467] = true, -- Fury of the Illidari (Artifact)
			[203704] = true, -- Mana Break
			[235903] = true, -- Mana Rift
			[191427] = true, -- Metamorphosis
			[185123] = true, -- Throw Glaive
			[198793] = true, -- Vengeful Retreat
		},
		[2] = { -- Vengeance
			[205629] = true, -- Demonic Trample
			[206649] = true, -- Eye of Leotheras
			[212084] = true, -- Fel Devastation
			[211881] = true, -- Fel Eruption
			[232893] = true, -- Felblade
			[204021] = true, -- Fiery Brand
			[209795] = true, -- Fracture
			[205630] = true, -- Illidan's Grasp
			[178740] = true, -- Immolation Aura
			[189110] = true, -- Infernal Strike
			[203782] = true, -- Shear
			[204596] = true, -- Sigil of Flame
			[207407] = true, -- Soul Carver (Artifact)
			[228477] = true, -- Soul Cleave
			[247454] = true, -- Spirit Bomb
			[204157] = true, -- Throw Glaive
		},
	},
	["DRUID"] = {
		[1] = { -- Balance
			[22568] = true,  -- Ferocious Bite
			[202771] = true, -- Full Moon (Artifact)
			[202770] = true, -- Fury of Elune
			[202768] = true, -- Half Moon (Artifact)
			[194153] = true, -- Lunar Strike
			[33917] = true,  -- Mangle
			[8921] = true,   -- Moonfire
			[202767] = true, -- New Moon (Artifact)
			[1822] = true,   -- Rake
			[1079] = true,   -- Rip
			[5221] = true,   -- Shred
			[190984] = true, -- Solar Wrath
			[191034] = true, -- Starfall
			[78674] = true,  -- Starsurge
			[202347] = true, -- Stellar Flare
			[93402] = true,  -- Sunfire
			[213764] = true, -- Swipe
			[106832] = true, -- Thrash
		},
		[2] = { -- Feral
			[210722] = true, -- Ashamane's Frenzy (Artifact)
			[202028] = true, -- Brutal Slash
			[236026] = true, -- Enraged Maim
			[22568] = true,  -- Ferocious Bite
			[197628] = true, -- Lunar Strike
			[22570] = true,  -- Maim
			[33917] = true,  -- Mangle
			[8921] = true,   -- Moonfire
			[1822] = true,   -- Rake
			[1079] = true,   -- Rip
			[5221] = true,   -- Shred
			[197629] = true, -- Solar Wrath
			[197626] = true, -- Starsurge
			[197630] = true, -- Sunfire
			[106785] = true, -- Swipe
			[236696] = true, -- Thorns
			[106830] = true, -- Thrash
		},
		[3] = { -- Guardian
			[22568] = true,  -- Ferocious Bite
			[204066] = true, -- Lunar Beam
			[197628] = true, -- Lunar Strike
			[33917] = true,  -- Mangle
			[6807] = true,   -- Maul
			[8921] = true,   -- Moonfire
			[80313] = true,  -- Pulverize
			[200851] = true, -- Rage of the Sleeper (Artifact)
			[1822] = true,   -- Rake
			[1079] = true,   -- Rip
			[5221] = true,   -- Shred
			[197629] = true, -- Solar Wrath
			[197626] = true, -- Starsurge
			[197630] = true, -- Sunfire
			[213771] = true, -- Swipe
			[77758] = true,  -- Thrash
		},
		[4] = { -- Restoration
			[22568] = true,  -- Ferocious Bite
			[197628] = true, -- Lunar Strike
			[33917] = true,  -- Mangle
			[8921] = true,   -- Moonfire
			[1822] = true,   -- Rake
			[1079] = true,   -- Rip
			[5221] = true,   -- Shred
			[5176] = true,   -- Solar Wrath
			[197626] = true, -- Starsurge
			[93402] = true,  -- Sunfire
			[213764] = true, -- Swipe
			[203727] = true, -- Thorns
		},
	},
	["HUNTER"] = {
		[1] = { -- Beast Mastery
			[131894] = true, -- A Murder of Crows
			[120360] = true, -- Barrage
			[53209] = true,  -- Chimaera Shot
			[193455] = true, -- Cobra Shot
			[217200] = true, -- Dire Frenzy (Pet)
			[34026]  = true, -- Kill Command
			[2643]   = true, -- Multi-Shot
			[201430] = true, -- Stampede (?)
			[194386] = true, -- Volley
		},
		[2] = { -- Marksmanship
			[131894] = true, -- A Murder of Crows
			[19434]  = true, -- Aimed Shot
			[120360] = true, -- Barrage
			[194599] = true, -- Black Arrow
			[186387] = true, -- Bursting Shot
			[212431] = true, -- Explosive Shot
			[236776] = true, -- Hi-Explosive Trap
			[185901] = true, -- Marked Shot
			[198670] = true, -- Piercing Shot
			[213691] = true, -- Scatter Shot
			[214579] = true, -- Sidewinders
			[203155] = true, -- Sniper Shot
			[194386] = true, -- Volley
			[204147] = true, -- Windburst (Artifact)
		},
		[3] = { -- Survival
			[206505] = true, -- A Murder of Crows
			[212436] = true, -- Butchery
			[194277] = true, -- Caltrops
			[187708] = true, -- Carve
			[194855] = true, -- Dragonsfire Grenade
			[191433] = true, -- Explosive Trap
			[202800] = true, -- Flanking Strike
			[203415] = true, -- Fury of the Eagle (Artifact)
			[193265] = true, -- Hatchet Toss
			[185855] = true, -- Lacerate
			[190928] = true, -- Mongoose Bite
			[186270] = true, -- Raptor Strike
			[118253] = true, -- Serpent Sting
			[194407] = true, -- Spitting Cobra
			[162488] = true, -- Steel Trap
			[200163] = true, -- Throwing Axes
		},	
	},
	["MAGE"] = {
		[1] = { -- Arcane
			[44425] = true,  -- Arcane Barrage
			[30451] = true,  -- Arcane Blast
			[1449] = true,   -- Arcane Explosion
			[5143] = true,   -- Arcane Missiles
			[153626] = true, -- Arcane Orb
			[122] = true,    -- Frost Nova
			[224968] = true, -- Mark of Aluneth (Artifact)
			[114923] = true, -- Nether Tempest
		},
		[2] = { -- Fire
			[157981] = true, -- Blast Wave
			[235313] = true, -- Blazing Barrier
			[198929] = true, -- Cinderstorm
			[31661] = true,  -- Dragon's Breath
			[203286] = true, -- Greater Pyroblast
			[108853] = true, -- Fire Blast
			[133] = true,    -- Fireball
			[2120] = true,   -- Flamestrike
			[122] = true,    -- Frost Nova
			[44457] = true,  -- Living Bomb
			[153561] = true, -- Meteor
			[2948] = true,   -- Scorch
			[194466] = true, -- Phoenix's Flame (Artifact)
			[11366] = true,  -- Pyroblast
		},
		[3] = { -- Frost
			[190356] = true, -- Blizzard
			[153595] = true, -- Comet Storm
			[120] = true,    -- Cone of Cold
			[214634] = true, -- Ebonbolt (Artifact)
			[44614] = true,  -- Flurry
			[112948] = true, -- Frost Bomb
			[122] = true,    -- Frost Nova
			[116] = true,    -- Frostbolt
			[84714] = true,  -- Frozen Orb
			[199786] = true, -- Glacial Spike
			[30455] = true,  -- Ice Lance
			[157997] = true, -- Ice Nova
			[205021] = true, -- Ray of Frost
		},
	},
	["MONK"] = {
		[1] = { -- Brewmaster
			[205523] = true, -- Blackout Strike
			[115181] = true, -- Breath of Fire
			[123986] = true, -- Chi Burst
			[115098] = true, -- Chi Wave
			[117952] = true, -- Crackling Jade Lightning
			[115072] = true, -- Expel Harm
			[214326] = true, -- Exploding Key (Artifact)
			[121253] = true, -- Keg Smash
			[116847] = true, -- Rushing Jade Wind
			[100780] = true, -- Tiger Palm
		},
		[2] = { -- Mistweaver
			[100784] = true, -- Blackout Kick
			[123986] = true, -- Chi Burst
			[115098] = true, -- Chi Wave
			[117952] = true, -- Crackling Jade Lightning
			[122783] = true, -- Diffuse Magic
			[107428] = true, -- Rising Sun Kick
			[101546] = true, -- Spinning Crane Kick
			[100780] = true, -- Tiger Palm
			[124081] = true, -- Zen Pulse
		},
		[3] = { -- Windwalker
			[100784] = true, -- Blackout Kick
			[123986] = true, -- Chi Burst
			[115098] = true, -- Chi Wave
			[117952] = true, -- Crackling Jade Lightning
			[113656] = true, -- Fists of Fury
			[107428] = true, -- Rising Sun Kick
			[116847] = true, -- Rushing Jade Wind
			[101546] = true, -- Spinning Crane Kick
			[205320] = true, -- Strike of the Windlord (Artifact)
			[100780] = true, -- Tiger Palm
			[115080] = true, -- Touch of Death
			[122470] = true, -- Touch of Karma
		},
	},
	["PALADIN"] = {
		[1] = { -- Holy
			[6940] = true,   -- Blessing of Sacrifice
			[26573] = true,  -- Consecration
			[35395] = true,  -- Crusader Strike
			[114165] = true, -- Holy Prism
			[20473] = true,  -- Holy Shock
			[20271] = true,  -- Judgment
			[183998] = true, -- Light of the Martyr
			[114158] = true, -- Light's Hammer
		},
		[2] = { -- Protection
			[204019] = true, -- Blessed Hammer
			[6940] = true,   -- Blessing of Sacrifice
			[26573] = true,  -- Consecration
			[209202] = true, -- Eye of Tyr (Artifact)
			[53595] = true,  -- Hammer of the Righteous
			[20271] = true,  -- Judgment
			[53600] = true,  -- Shield of the Righteous
		},
		[3] = { -- Retribution
			[184575] = true, -- Blade of Justice
			[205228] = true, -- Consecration
			[35395] = true,  -- Crusader Strike
			[198034] = true, -- Divine Hammer
			[213757] = true, -- Execution Sentence
			[205191] = true, -- Eye for an Eye
			[247675] = true, -- Hammer of Reckoning
			[210220] = true, -- Holy Wrath
			[20271] = true,  -- Judgment
			[215661] = true, -- Justicar's Vengeance
			[85256] = true,  -- Templar's Verdict
			[205273] = true, -- Wake of Ashes (Artifact)
			[217020] = true, -- Zeal
		},
	},
	["PRIEST"] = {
		[1] = { -- Discipline
			[110744] = true, -- Divine Star
			[120517] = true, -- Halo
			[207946] = true, -- Light's Wrath (Artifact)
			[47540] = true,  -- Penance
			[129250] = true, -- Power Word: Solace
			[209780] = true, -- Premonition
			[204197] = true, -- Purge the Wicked
			[186263] = true, -- Shadow Mend
			[589] = true,    -- Shadow Word: Pain
			[585] = true,    -- Smite
		},
		[2] = { -- Holy
			[110744] = true, -- Divine Star
			[120517] = true, -- Halo
			[14914] = true,  -- Holy Fire
			[132157] = true, -- Holy Nova
			[88625] = true,  -- Holy Word: Chastise
			[585] = true,    -- Smite
		},
		[3] = { -- Shadow
			[8092] = true,   -- Mind Blast
			[15407] = true,  -- Mind Flay
			[205385] = true, -- Shadow Crash
			[186263] = true, -- Shadow Mend
			[32379] = true,  -- Shadow Word: Death
			[589] = true,    -- Shadow Word: Pain
			[205351] = true, -- Shadow Word: Void
			[34914] = true,  -- Vampiric Touch
			[228266] = true, -- Void Bolt
			[228260] = true, -- Void Eruption
		},
	},
	["ROGUE"] = {
		[1] = { -- Assassinations
			[152150] = true, -- Death from Above
			[32645] = true,  -- Envenom
			[51723] = true,  -- Fan of Knives
			[703] = true,    -- Garrote
			[16511] = true,  -- Hemorrhage
			[192759] = true, -- Kingsbane (Artifact)
			[1329] = true,   -- Mutilate
			[206328] = true, -- Neurotoxin
			[185565] = true, -- Poisoned Knife
			[248744] = true, -- Shiv
			[245388] = true, -- Toxic Blade
		},
		[2] = { -- Outlaw
			[8676] = true,   -- Ambush
			[185767] = true, -- Cannonball Barrage
			[152150] = true, -- Death from Above
			[196937] = true, -- Ghostly Strike
			[51690] = true,  -- Killing Spree
			[185763] = true, -- Pistol Shot
			[2098] = true,   -- Run Through
			[193315] = true, -- Saber Slash
			[248744] = true, -- Shiv
		},
		[3] = { -- Subtlety
			[53] = true,     -- Backstab
			[152150] = true, -- Death from Above
			[196819] = true, -- Eviscerate
			[209782] = true, -- Goremaw's Bite (Artifact)
			[195452] = true, -- Nightblade
			[185438] = true, -- Shadowstrike
			[248744] = true, -- Shiv
			[197835] = true, -- Shuriken Storm
			[114014] = true, -- Shuriken Toss
		},
	},
	["SHAMAN"] = {
		[1] = { -- Elemental
			[188443] = true, -- Chain Lightning
			[8042] = true,   -- Earth Shock
			[170379] = true, -- Earthen Rage
			[61882] = true,  -- Earthquake
			[117014] = true, -- Elemental Blast
			[188389] = true, -- Flame Shock
			[196840] = true, -- Frost Shock
			[210714] = true, -- Icefury
			[51505] = true,  -- Lava Burst
			[45284] = true,  -- Lightning Bolt (Overload)
			[188196] = true, -- Lightning Bolt
			[204437] = true, -- Lightning Lasso
			[192222] = true, -- Liquid Magma Totem
			[205495] = true, -- Stormkeeper (Artifact)
			[51490] = true,  -- Thunderstorm
		},
		[2] = { -- Enhancement
			[187874] = true, -- Crash Lightning
			[188089] = true, -- Earthen Spike
			[196884] = true, -- Feral Lunge
			[193796] = true, -- Flametongue
			[196834] = true, -- Frostbrand
			[197211] = true, -- Fury of Air
			[60103] = true,  -- Lava Lash
			[187837] = true, -- Lightning Bolt
			[192106] = true, -- Lightning Shield
			[193786] = true, -- Rockbiter
			[17364] = true,  -- Stormstrike
			[197214] = true, -- Sundering
			[201898] = true, -- Windsong
		},
		[3] = { -- Restoration
			[421] = true,    -- Chain Lightning
			[188838] = true, -- Flame Shock
			[51505] = true,  -- Lava Burst
			[403] = true,    -- Lightning Bolt
		},
	},
	["WARLOCK"] = {
		[1] = { -- Affliction
			[980] = true,    -- Agony
			[111400] = true, -- Burning Rush
			[172] = true,    -- Corruption
			[108416] = true, -- Dark Pact
			[198590] = true, -- Drain Soul
			[108503] = true, -- Grimoire of Sacrifice
			[48181] = true,  -- Haunt
			[755] = true,    -- Health Funnel
			[1454] = true,   -- Life Tap
			[205179] = true, -- Phantom Singularity
			[27243] = true,  -- Seed of Corruption
			[63106] = true,  -- Siphon Life
			[212356] = true, -- Soulshatter
			[30108] = true,  -- Unstable Affliction
		},
		[2] = { -- Demonology
			[111400] = true, -- Burning Rush
			[108416] = true, -- Dark Pact
			[157695] = true, -- Demonbolt
			[193440] = true, -- Demonwrath
			[603] = true,    -- Doom
			[234153] = true, -- Drain Life
			[105174] = true, -- Hand of Gul'dan
			[755] = true,    -- Health Funnel
			[1454] = true,   -- Life Tap
			[6789] = true,   -- Mortal Coil
			[686] = true,    -- Shadow Bolt
			[205181] = true, -- Shadowflame
			[211714] = true, -- Thal'kiel's Consumption (Artifact)
		},
		[3] = { -- Destruction
			[111400] = true, -- Burning Rush
			[152108] = true, -- Cataclysm
			[196447] = true, -- Channel Demonfire
			[116858] = true, -- Chaos Bolt
			[17962] = true,  -- Conflagarate
			[108416] = true, -- Dark Pact
			[196586] = true, -- Dimensional Rift (Artifact)
			[234153] = true, -- Drain Life
			[108503] = true, -- Grimoire of Sacrifice
			[755] = true,    -- Health Funnel
			[348] = true,    -- Immolate
			[29722] = true,  -- Incinerate
			[1454] = true,   -- Life Tap
			[6789] = true,   -- Mortal Coil
			[5740] = true,   -- Rain of Fire
			[17877] = true,  -- Shadowburn
		},
	},
	["WARRIOR"] = {
		[1] = { -- Arms
			[107574] = true, -- Avatar
			[1719] = true,   -- Battle Cry
			[18499] = true,  -- Berserker Rage
			[227847] = true, -- Bladestorm
			[100] = true,    -- Charge
			[845] = true,    -- Cleave
			[167105] = true, -- Colossus Smash
			[163201] = true, -- Execute
			[1715] = true,   -- Hamstring
			[6544] = true,   -- Heroic Leap
			[57755] = true,  -- Heroic Throw
			[12294] = true,  -- Mortal Strike
			[7384] = true,   -- Overpower
			[6552] = true,   -- Pummel
			[152277] = true, -- Ravager
			[772] = true,    -- Rend
			[46968] = true,  -- Shockwave
			[1464] = true,   -- Slam
			[107570] = true, -- Storm Bolt
			[34428] = true,  -- Victory Rush
			[209577] = true, -- Warbreaker (Artifact)
			[1680] = true,   -- Whirlwind
		},
		[2] = { -- Fury
			[107574] = true, -- Avatar
			[46924] = true,  -- Bladestorm
			[23881] = true,  -- Bloodthirst
			[100] = true,    -- Charge
			[97462] = true,  -- Commanding Shout
			[118000] = true, -- Dragon Roar
			[5308] = true,   -- Execute
			[100130] = true, -- Furious Slash
			[6544] = true,   -- Heroic Leap
			[57755] = true,  -- Heroic Throw
			[205545] = true, -- Odyn's Fury (Artifact)
			[85288] = true,  -- Raging Blow
			[184367] = true, -- Rampage
			[46968] = true,  -- Shockwave
			[107570] = true, -- Storm Bolt
			[190411] = true, -- Whirlwind
		},
		[3] = { -- Protection
			[213871] = true, -- Bodyguard
			[20243] = true,  -- Devastate
			[206572] = true, -- Dragon Charge
			[6544] = true,   -- Heroic Leap
			[57755] = true,  -- Heroic Throw
			[202168] = true, -- Impending Victory
			[198304] = true, -- Intercept
			[203524] = true, -- Neltharion's Fury (Artifact)
			[228920] = true, -- Ravager
			[6572] = true,   -- Revenge
			[198912] = true, -- Shield Bash
			[23922] = true,  -- Shield Slam
			[46968] = true,  -- Shockwave
			[107570] = true, -- Storm Bolt
			[6343] = true,   -- Thunder Clap
		},
	},
}

local castIDs = {
	["DEATHKNIGHT"] = {
		[1] = { -- Blood
			[206931] = true, -- Blooddrinker
			[111673] = true, -- Control Undead
		},
		[2] = { -- Frost
			[111673] = true, -- Control Undead
		},
		[3] = { -- Unholy
			[111673] = true, -- Control Undead
		},
	},
	["DEMONHUNTER"] = {
		[1] = { -- Havok
			
		},
		[2] = { -- Vengeance
		
		},
	},
	["DRUID"] = {
		[1] = { -- Balance
			[209753] = true, -- Cyclone
			[193753] = true, -- Dreamwalk
			[339] = true,    -- Entangling Roots
			[202771] = true, -- Full Moon (Artifact)
			[202768] = true, -- Half Moon (Artifact)
			[5185] = true,   -- Healing Touch
			[194153] = true, -- Lunar Strike
			[202767] = true, -- New Moon (Artifact)
			[8936] = true,   -- Regrowth
			[50769] = true,  -- Revive
			[190984] = true, -- Solar Wrath
			[202347] = true, -- Stellar Flare
		},
		[2] = { -- Feral
			[193753] = true, -- Dreamwalk
			[339] = true,    -- Entangling Roots
			[5185] = true,   -- Healing Touch
			[197628] = true, -- Lunar Strike
			[8936] = true,   -- Regrowth
			[50769] = true,  -- Revive
			[197629] = true, -- Solar Wrath
			[197626] = true, -- Starsurge
		},
		[3] = { -- Guardian
			[193753] = true, -- Dreamwalk
			[339] = true,    -- Entangling Roots
			[5185] = true,   -- Healing Touch
			[197628] = true, -- Lunar Strike
			[8936] = true,   -- Regrowth
			[50769] = true,  -- Revive
			[197629] = true, -- Solar Wrath
			[197626] = true, -- Starsurge
		},
		[4] = { -- Restoration
			[33786] = true,  -- Cyclone
			[193753] = true, -- Dreamwalk
			[339] = true,    -- Entangling Roots
			[5185] = true,   -- Healing Touch
			[197628] = true, -- Lunar Strike
			[8936] = true,   -- Regrowth
			[50769] = true,  -- Revive
			[5176] = true,   -- Solar Wrath
			[197626] = true, -- Starsurge
			[48438] = true,  -- Wild Growth
		},
	},
	["HUNTER"] = {
		[1] = { -- Beast Mastery
			[2641] = true,   -- Dismiss Pet
			[982] = true,    -- Revive Pet
			[19386] = true,  -- Wyvern Sting
		},
		[2] = { -- Marksmanship
			[19434]  = true, -- Aimed Shot
			[2641] = true,   -- Dismiss Pet
			[982] = true,    -- Revive Pet
			[204147] = true, -- Windburst (Artifact)
			[19386] = true,  -- Wyvern Sting
		},
		[3] = { -- Survival
			[2641] = true,   -- Dismiss Pet
			[212640] = true, -- Mending Bandage
			[982] = true,    -- Revive Pet
		},
	},
	["MAGE"] = {
		[1] = { -- Arcane
			[30451] = true,  -- Arcane Blast
			[190336] = true, -- Conjure Refreshment
			[224968] = true, -- Mark of Aluneth (Artifact)
			[118] = true,    -- Polymorph
			[11417] = true,  -- Portal: Orgrimmar
			[32267] = true,  -- Portal: Silvermoon
			[49361] = true,  -- Portal: Stonard
			[11420] = true,  -- Portal: Thunder Bluff
			[11418] = true,  -- Portal: Undercity
			[113724] = true, -- Ring of Frost
			[116011] = true, -- Rune of Power
			[157980] = true, -- Supernova
			[3567] = true,   -- Teleport: Orgrimmar
			[32272] = true,  -- Teleport: Silvermoon
			[49358] = true,  -- Teleport: Stonard
			[3566] = true,   -- Teleport: Thunder Bluff
			[3563] = true,   -- Teleport: Undercity
		},
		[2] = { -- Fire
			[198929] = true, -- Cinderstorm
			[190336] = true, -- Conjure Refreshment
			[133] = true,    -- Fireball
			[2120] = true,   -- Flamestrike
			[203286] = true, -- Greater Pyroblast
			[118] = true,    -- Polymorph
			[11417] = true,  -- Portal: Orgrimmar
			[32267] = true,  -- Portal: Silvermoon
			[49361] = true,  -- Portal: Stonard
			[11420] = true,  -- Portal: Thunder Bluff
			[11418] = true,  -- Portal: Undercity
			[11366] = true,  -- Pyroblast
			[113724] = true, -- Ring of Frost
			[116011] = true, -- Rune of Power
			[2948] = true,   -- Scorch
			[3567] = true,   -- Teleport: Orgrimmar
			[32272] = true,  -- Teleport: Silvermoon
			[49358] = true,  -- Teleport: Stonard
			[3566] = true,   -- Teleport: Thunder Bluff
			[3563] = true,   -- Teleport: Undercity
		},
		[3] = { -- Frost
			[190356] = true, -- Blizzard
			[190336] = true, -- Conjure Refreshment
			[214634] = true, -- Ebonbolt (Artifact)
			[44614] = true,  -- Flurry
			[112948] = true, -- Frost Bomb
			[199786] = true, -- Glacial Spike
			[118] = true,    -- Polymorph
			[11417] = true,  -- Portal: Orgrimmar
			[32267] = true,  -- Portal: Silvermoon
			[49361] = true,  -- Portal: Stonard
			[11420] = true,  -- Portal: Thunder Bluff
			[11418] = true,  -- Portal: Undercity
			[113724] = true, -- Ring of Frost
			[116011] = true, -- Rune of Power
			[3567] = true,   -- Teleport: Orgrimmar
			[32272] = true,  -- Teleport: Silvermoon
			[49358] = true,  -- Teleport: Stonard
			[3566] = true,   -- Teleport: Thunder Bluff
			[3563] = true,   -- Teleport: Undercity
		},
	},
	["MONK"] = {
		[1] = { -- Brewmaster
			[213658] = true, -- Craft: Nimble Brew
			[116694] = true, -- Effuse
			[124682] = true, -- Enveloping Mist
			[115178] = true, -- Resuscitate
			[126892] = true, -- Zen Pilgrimage
		},
		[2] = { -- Mistweaver
			[116694] = true, -- Effuse
			[212051] = true, -- Reawaken
			[115178] = true, -- Resuscitate
			[205406] = true, -- Sheilun's Gift (Artifact)
			[198898] = true, -- Song of Chi-Ji
			[116670] = true, -- Vivify
			[126892] = true, -- Zen Pilgrimage
		},
		[3] = { -- Windwalker
			[116694] = true, -- Effuse
			[115178] = true, -- Resuscitate
			[126892] = true, -- Zen Pilgrimage
		},
	},
	["PALADIN"] = {
		[1] = { -- Holy
			[212056] = true, -- Absolution
			[19750] = true,  -- Flash of Light
			[82326] = true,  -- Holy Light
			[7328] = true,   -- Redemption
			[20066] = true,  -- Repentance
			[200652] = true, -- Tyr's Deliverance (Artifact)
		},
		[2] = { -- Protection
			[19750] = true,  -- Flash of Light
			[7328] = true,   -- Redemption
			[20066] = true,  -- Repentance
		},
		[3] = { -- Retribution
			[19750] = true,  -- Flash of Light
			[7328] = true,   -- Redemption
			[20066] = true,  -- Repentance
		},
	},
	["PRIEST"] = {
		[1] = { -- Discipline
			[152118] = true, -- Clarity of Will
			[2061] = true,   -- Flash Heal
			[120517] = true, -- Halo
			[32375] = true,  -- Mass Dispel
			[212036] = true, -- Mass Resurrection
			[605] = true,    -- Mind Control
			[194509] = true, -- Power Word: Radiance
			[2006] = true,   -- Resurrection
			[214621] = true, -- Schism
			[9484] = true,   -- Shackle Undead
			[186263] = true, -- Shadow Mend
			[585] = true,    -- Smite
		},
		[2] = { -- Holy
			[32546] = true,  -- Binding Heal
			[32375] = true,  -- Mass Dispel
			[2061] = true,   -- Flash Heal
			[120517] = true, -- Halo
			[2060] = true,   -- Heal
			[212036] = true, -- Mass Resurrection
			[605] = true,    -- Mind Control
			[596] = true,    -- Prayer of Healing
			[33076] = true,  -- Prayer of Mending
			[2006] = true,   -- Resurrection
			[9484] = true,   -- Shackle Undead
		},
		[3] = { -- Shadow
			[8092] = true,   -- Mind Blast
			[605] = true,    -- Mind Control
			[2006] = true,   -- Resurrection
			[9484] = true,   -- Shackle Undead
			[186263] = true, -- Shadow Mend
			[205351] = true, -- Shadow Word: Void
			[34914] = true,  -- Vampiric Touch
			[228260] = true, -- Void Eruption
		},
	},
	["ROGUE"] = {
		[1] = { -- Assassinations
			[2823] = true,   -- Deadly Poison
			[3408] = true,   -- Crippling Poison
			[108211] = true, -- Leeching Poison
			[1804] = true,   -- Pick Lock
			[8679] = true,   -- Wounded Poison
		},
		[2] = { -- Outlaw
		
		},
		[3] = { -- Subtlety
		
		},
	},
	["SHAMAN"] = {
		[1] = { -- Elemental
			[2008] = true,   -- Ancestral Spirit
			[556] = true,    -- Astral Recall
			[188443] = true, -- Chain Lightning
			[117014] = true, -- Elemental Blast
			[6196] = true,   -- Far Sight
			[210714] = true, -- Icefury
			[8004] = true,   -- Healing Surge
			[51514] = true,  -- Hex
			[51505] = true,  -- Lava Burst
			[188196] = true, -- Lightning Bolt
			[205495] = true, -- Stormkeeper (Artifact)
		},
		[2] = { -- Enhancement
			[2008] = true,   -- Ancestral Spirit
			[556] = true,    -- Astral Recall
			[6196] = true,   -- Far Sight
			[188070] = true, -- Healing Surge
			[51514] = true,  -- Hex
		},
		[3] = { -- Restoration
			[2008] = true,   -- Ancestral Spirit
			[212048] = true, -- Ancestral Vision
			[556] = true,    -- Astral Recall
			[1064] = true,   -- Chain Heal
			[421] = true,    -- Chain Lightning
			[6196] = true,   -- Far Sight
			[207778] = true, -- Gift of the Queen (Artifact)
			[73920] = true,  -- Healing Rain
			[8004] = true,   -- Healing Surge
			[77472] = true,  -- Healing Wave
			[51514] = true,  -- Hex
			[51505] = true,  -- Lava Burst
			[403] = true,    -- Lightning Bolt
			[197995] = true, -- Wellspring
		},
	},
	["WARLOCK"] = {
		[1] = { -- Affliction
			[710] = true,    -- Banish
			[221703] = true, -- Casting Circle
			[6201] = true,   -- Create Healthstone
			[29893] = true,  -- Create Soulwell
			[48018] = true,  -- Demonic Circle
			[111771] = true, -- Demonic Gateway
			[1098] = true,   -- Enslave Demon
			[126] = true,    -- Eye of Kilrogg
			[5782] = true,   -- Fear
			[48181] = true,  -- Haunt
			[27243] = true,  -- Seed of Corruption
			[20707] = true,  -- Soulstone
			[691] = true,    -- Summon Felhunter
			[688] = true,    -- Summon Imp
			[712] = true,    -- Summon Succubus
			[697] = true,    -- Summon Voidwalker
			[30108] = true,  -- Unstable Affliction
		},
		[2] = { -- Demonology
			[710] = true,    -- Banish
			[104316] = true, -- Call Dreadstalkers
			[212619] = true, -- Call Felhunter
			[221703] = true, -- Casting Circle
			[6201] = true,   -- Create Healthstone
			[29893] = true,  -- Create Soulwell
			[157695] = true, -- Demonbolt
			[48018] = true,  -- Demonic Circle
			[193396] = true, -- Demonic Empowerment
			[111771] = true, -- Demonic Gateway
			[1098] = true,   -- Enslave Demon
			[126] = true,    -- Eye of Kilrogg
			[5782] = true,   -- Fear
			[105174] = true, -- Hand of Gul'dan
			[698] = true,    -- Ritual of Summoning
			[686] = true,    -- Shadow Bolt
			[30283] = true,  -- Shadowfury
			[20707] = true,  -- Soulstone
			[157757] = true, -- Summon Doomguard
			[30146] = true,  -- Summon Felguard
			[691] = true,    -- Summon Felhunter
			[688] = true,    -- Summon Imp
			[157898] = true, -- Summon Infernal
			[712] = true,    -- Summon Succubus
			[697] = true,    -- Summon Voidwalker
			[211714] = true, -- Thal'kiel's Consumption (Artifact)
		},
		[3] = { -- Destruction
			[710] = true,    -- Banish
			[221703] = true, -- Casting Circle
			[152108] = true, -- Cataclysm
			[116858] = true, -- Chaos Bolt
			[6201] = true,   -- Create Healthstone
			[29893] = true,  -- Create Soulwell
			[48018] = true,  -- Demonic Circle
			[111771] = true, -- Demonic Gateway
			[126] = true,    -- Eye of Kilrogg
			[5782] = true,   -- Fear
			[348] = true,    -- Immolate
			[29722] = true,  -- Incinerate
			[698] = true,    -- Ritual of Summoning
			[30283] = true,  -- Shadowfury
			[20707] = true,  -- Soulstone
			[157757] = true, -- Summon Doomguard
			[691] = true,    -- Summon Felhunter
			[688] = true,    -- Summon Imp
			[157898] = true, -- Summon Infernal
			[712] = true,    -- Summon Succubus
			[697] = true,    -- Summon Voidwalker
		},
	},
	["WARRIOR"] = {
		[1] = { -- Arms
		
		},
		[2] = { -- Fury
		
		},
		[3] = { -- Protection
		
		},
	},
	
}

local successIDs = {
	["DEATHKNIGHT"] = {
		[1] = { -- Blood
			[214027] = true, -- Adaptation
			[48707] = true,  -- Anti-Magic Shell
			[51052] = true,  -- Anti-Magic Zone
			[221562] = true, -- Asphyxiate
			[50842] = true,  -- Blood Boil
			[233411] = true, -- Blood for Blood
			[206977] = true, -- Blood Mirror
			[221699] = true, -- Blood Tap
			[206931] = true, -- Blooddrinker
			[194844] = true, -- Bonestorm
			[205223] = true, -- Consumption (Artifact)
			[111673] = true, -- Control Undead
			[49028] = true,  -- Dancing Rune Weapon
			[56222] = true,  -- Dark Command
			[77606] = true,  -- Dark Simulacrum
			[43265] = true,  -- Death and Decay
			[203173] = true, -- Death Chain
			[49576] = true,  -- Death Grip
			[49998] = true,  -- Death Strike
			[195292] = true, -- Death's Caress
			[208683] = true, -- Gladiator's Medallion
			[108199] = true, -- Gorefiend's Grasp
			[206930] = true, -- Heart Strike
			[48792] = true,  -- Icebound Fortitude
			[206940] = true, -- Mark of Blood
			[195182] = true, -- Marrowrend
			[47528] = true,  -- Mind Freeze
			[207018] = true, -- Murderous Intent
			[3714] = true,   -- Path of Frost
			[61999] = true,  -- Raise Ally
			[194679] = true, -- Rune Tap
			[47476] = true,  -- Strangulate
			[219809] = true, -- Tombstone
			[55233] = true,  -- Vampiric Blood
			[212552] = true, -- Wraith Walk
		},
		[2] = { -- Frost
			[214027] = true, -- Adaptation
			[48707] = true,  -- Anti-Magic Shell
			[51052] = true,  -- Anti-Magic Zone
			[207167] = true, -- Blinding Sheet
			[152279] = true, -- Breath of Sindragosa
			[45524] = true,  -- Chains of Ice
			[111673] = true, -- Control Undead
			[189186] = true, -- Crystalline Swords (Artifact)
			[56222] = true,  -- Dark Command
			[77606] = true,  -- Dark Simulacrum
			[49576] = true,  -- Death Grip
			[49998] = true,  -- Death Strike
			[47568] = true,  -- Empower Rune Weapon
			[49143] = true,  -- Frost Strike
			[207230] = true, -- Frostsythe
			[194913] = true, -- Glacial Advance
			[208683] = true, -- Gladiator's Medallion
			[57330] = true,  -- Horn of Winter
			[49184] = true,  -- Howling Blast
			[207127] = true, -- Hungering Rune Weapon
			[48792] = true,  -- Icebound Fortitude
			[47528] = true,  -- Mind Freeze
			[49020] = true,  -- Obliterate
			[207256] = true, -- Obliteration
			[3714] = true,   -- Path of Frost
			[51271] = true,  -- Pillar of Frost
			[61999] = true,  -- Raise Ally
			[196770] = true, -- Remorseless Winter
			[212552] = true, -- Wraith Walk
		},
		[3] = { -- Unholy
			[214027] = true, -- Adaptation
			[48707] = true,  -- Anti-Magic Shell
			[51052] = true,  -- Anti-Magic Zone
			[220143] = true, -- Apocalypse (Artifact)
			[42650] = true,  -- Army of the Dead
			[108194] = true, -- Asphyxiate
			[194918] = true, -- Blighted Rune Weapon
			[45524] = true,  -- Chains of Ice
			[207311] = true, -- Clawing Shadows
			[111673] = true, -- Control Undead
			[207319] = true, -- Corpse Shield
			[207349] = true, -- Dark Arbiter
			[56222] = true,  -- Dark Command
			[77606] = true,  -- Dark Simulacrum
			[63560] = true,  -- Dark Transformation
			[43265] = true,  -- Death and Decay
			[47541] = true,  -- Death Coil
			[49576] = true,  -- Death Grip
			[49998] = true,  -- Death Strike
			[152280] = true, -- Defile
			[207317] = true, -- Epidemic
			[85948] = true,  -- Festering Strike
			[208683] = true, -- Gladiator's Medallion
			[48792] = true,  -- Icebound Fortitude
			[47528] = true,  -- Mind Freeze
			[77575] = true,  -- Outbreak
			[3714] = true,   -- Path of Frost
			[61999] = true,  -- Raise Ally
			[210128] = true, -- Reanimation
			[55090] = true,  -- Scourge Strike
			[130736] = true, -- Soul Reaper
			[49206] = true,  -- Summon Gargoyle
			[223829] = true, -- Necrotic Strike
			[212552] = true, -- Wraith Walk
		},
	},
	["DEMONHUNTER"] = {
		[1] = { -- Havok
			[214027] = true, -- Adaptation
			[188499] = true, -- Blade Dance
			[198589] = true, -- Blur
			[247938] = true, -- Chaos Blades
			[179057] = true, -- Chaos Nova
			[162794] = true, -- Chaos Strike
			[183752] = true, -- Consumed Magic
			[196718] = true, -- Darkness
			[162243] = true, -- Demon's Bite
			[198013] = true, -- Eye Beam
			[206649] = true, -- Eye of Leotheras
			[211053] = true, -- Fel Barrage
			[211881] = true, -- Fel Eruption
			[206966] = true, -- Fel Lance
			[195072] = true, -- Fel Rush
			[232893] = true, -- Felblade
			[201467] = true, -- Fury of the Illidari (Artifact)
			[208683] = true, -- Gladiator's Medallion
			[131347] = true, -- Glide
			[217832] = true, -- Imprison
			[203704] = true, -- Mana Break
			[235903] = true, -- Mana Rift
			[191427] = true, -- Metamorphosis
			[206491] = true, -- Nemesis
			[196555] = true, -- Netherwalk
			[206803] = true, -- Rain from Above
			[205604] = true, -- Reverse Magic
			[188501] = true, -- Spectral Sight
			[185123] = true, -- Throw Glaive
			[198793] = true, -- Vengeful Retreat
		},
		[2] = { -- Vengeance
			[214027] = true, -- Adaptation
			[183752] = true, -- Consumed Magic
			[203720] = true, -- Demon Spikes
			[236189] = true, -- Demonic Infusion
			[205629] = true, -- Demonic Trample
			[218256] = true, -- Empower Wards
			[206649] = true, -- Eye of Leotheras
			[212084] = true, -- Fel Devastation
			[211881] = true, -- Fel Eruption
			[232893] = true, -- Felblade
			[204021] = true, -- Fiery Brand
			[209795] = true, -- Fracture
			[208683] = true, -- Gladiator's Medallion
			[131347] = true, -- Glide
			[205630] = true, -- Illidan's Grasp
			[178740] = true, -- Immolation Aura
			[217832] = true, -- Imprison
			[189110] = true, -- Infernal Strike
			[187827] = true, -- Metamorphosis
			[205604] = true, -- Reverse Magic
			[203782] = true, -- Shear
			[202138] = true, -- Sigil of Chains
			[204596] = true, -- Sigil of Flame
			[207684] = true, -- Sigil of Misery
			[202137] = true, -- Sigil of Silence
			[227225] = true, -- Soul Barrier
			[207407] = true, -- Soul Carver (Artifact)
			[228477] = true, -- Soul Cleave
			[188501] = true, -- Spectral Sight
			[247454] = true, -- Spirit Bomb
			[204157] = true, -- Throw Glaive
			[185245] = true, -- Torment
			[207029] = true, -- Tormentor
		},
	},
	["DRUID"] = {
		[1] = { -- Balance
			[214027] = true, -- Adaptation
			[202359] = true, -- Astral Communion
			[22812] = true,  -- Barkskin
			[5487] = true,   -- Bear Form
			[202360] = true, -- Blessing of the Ancients
			[768] = true,    -- Cat Form
			[209753] = true, -- Cyclone
			[1850] = true,   -- Dash
			[102280] = true, -- Displacer Beast
			[193753] = true, -- Dreamwalk
			[339] = true,    -- Entangling Roots
			[209749] = true, -- Faerie Swarm
			[22568] = true,  -- Ferocious Bite
			[205636] = true, -- Force of Nature
			[22842] = true,  -- Frenzied Regeneration
			[202771] = true, -- Full Moon (Artifact)
			[202770] = true, -- Fury of Elune
			[208683] = true, -- Gladiator's Medallion
			[6795] = true,   -- Growl
			[202768] = true, -- Half Moon (Artifact)
			[5185] = true,   -- Healing Touch
			[102560] = true, -- Incarnation: Chose of Elune
			[29166] = true,  -- Innervate
			[192081] = true, -- Ironfur
			[194153] = true, -- Lunar Strike
			[33917] = true,  -- Mangle
			[102359] = true, -- Mass Entanglement
			[5211] = true,   -- Mighty Bash
			[8921] = true,   -- Moonfire
			[24858] = true,  -- Moonkin Form
			[202767] = true, -- New Moon (Artifact)
			[5215] = true,   -- Prowl
			[1822] = true,   -- Rake
			[20484] = true,  -- Rebirth
			[8936] = true,   -- Regrowth
			[774] = true,    -- Rejuvenation
			[2782] = true,   -- Remove Corruption
			[108238] = true, -- Renewal
			[50769] = true,  -- Revive
			[1079] = true,   -- Rip
			[5221] = true,   -- Shred
			[78675] = true,  -- Solar Beam
			[190984] = true, -- Solar Wrath
			[191034] = true, -- Starfall
			[78674] = true,  -- Starsurge
			[202347] = true, -- Stellar Flare
			[93402] = true,  -- Sunfire
			[18562] = true,  -- Swiftmend
			[213764] = true, -- Swipe
			[106832] = true, -- Thrash
			[783] = true,    -- Travel Form
			[132469] = true, -- Typhoon
			[202425] = true, -- Warrior of Elune
			[102401] = true, -- Wild Charge
		},
		[2] = { -- Feral
			[214027] = true, -- Adaptation
			[210722] = true, -- Ashamane's Frenzy (Artifact)
			[5487] = true,   -- Bear Form
			[106951] = true, -- Beserk
			[202028] = true, -- Brutal Slash
			[768] = true,    -- Cat Form
			[1850] = true,   -- Dash
			[102280] = true, -- Displacer Beast
			[193753] = true, -- Dreamwalk
			[202060] = true, -- Elune's Guidance
			[236026] = true, -- Enraged Maim
			[339] = true,    -- Entangling Roots
			[22568] = true,  -- Ferocious Bite
			[22842] = true,  -- Frenzied Regeneration
			[208683] = true, -- Gladiator's Medallion
			[6795] = true,   -- Growl
			[5185] = true,   -- Healing Touch
			[102543] = true, -- Incarnation: King of the Jungle
			[192081] = true, -- Ironfur
			[197628] = true, -- Lunar Strike
			[22570] = true,  -- Maim
			[33917] = true,  -- Mangle
			[102359] = true, -- Mass Entanglement
			[5211] = true,   -- Mighty Bash
			[8921] = true,   -- Moonfire
			[197625] = true, -- Moonkin Form
			[5215] = true,   -- Prowl
			[1822] = true,   -- Rake
			[20484] = true,  -- Rebirth
			[8936] = true,   -- Regrowth
			[774] = true,    -- Rejuvenation
			[2782] = true,   -- Remove Corruption
			[108238] = true, -- Renewal
			[50769] = true,  -- Revive
			[1079] = true,   -- Rip
			[203242] = true, -- Rip and Tear
			[52610] = true,  -- Savage Roar
			[5221] = true,   -- Shred
			[106839] = true, -- Skull Bash
			[197629] = true, -- Solar Wrath
			[77764] = true,  -- Stampeding Roar
			[197626] = true, -- Starsurge
			[197630] = true, -- Sunfire
			[61336] = true,  -- Survival Instincts
			[18562] = true,  -- Swiftmend
			[106785] = true, -- Swipe
			[236696] = true, -- Thorns
			[106830] = true, -- Thrash
			[5217] = true,   -- Tiger's Fury
			[783] = true,    -- Travel Form
			[132469] = true, -- Typhoon
			[102401] = true, -- Wild Charge
		},
		[3] = { -- Guardian
			[214027] = true, -- Adaptation
			[207017] = true, -- Alpha Challenge
			[22812] = true,  -- Barkskin
			[5487] = true,   -- Bear Form
			[155835] = true, -- Bristling Furious
			[768] = true,    -- Cat Form
			[1850] = true,   -- Dash
			[201664] = true, -- Demoralizing Roar
			[193753] = true, -- Dreamwalk
			[339] = true,    -- Entangling Roots
			[22568] = true,  -- Ferocious Bite
			[22842] = true,  -- Frenzied Regeneration
			[208683] = true, -- Gladiator's Medallion
			[6795] = true,   -- Growl
			[5185] = true,   -- Healing Touch
			[99] = true,     -- Incapacitating Roar
			[102558] = true, -- Incarnation: Guardian of Ursoc
			[192081] = true, -- Ironfur
			[236748] = true, -- Intimidating Roar
			[204066] = true, -- Lunar Beam
			[197628] = true, -- Lunar Strike
			[33917] = true,  -- Mangle
			[102359] = true, -- Mass Entanglement
			[6807] = true,   -- Maul
			[5211] = true,   -- Mighty Bash
			[8921] = true,   -- Moonfire
			[197625] = true, -- Moonkin Form
			[202246] = true, -- Overrun
			[5215] = true,   -- Prowl
			[80313] = true,  -- Pulverize
			[200851] = true, -- Rage of the Sleeper (Artifact)
			[1822] = true,   -- Rake
			[20484] = true,  -- Rebirth
			[8936] = true,   -- Regrowth
			[774] = true,    -- Rejuvenation
			[50769] = true,  -- Revive
			[2782] = true,   -- Remove Corruption
			[1079] = true,   -- Rip
			[5221] = true,   -- Shred
			[106839] = true, -- Skull Bash
			[197629] = true, -- Solar Wrath
			[197626] = true, -- Starsurge
			[77761] = true,  -- Stampeding Roar
			[197630] = true, -- Sunfire
			[61336] = true,  -- Survival Instincts
			[18562] = true,  -- Swiftmend
			[213771] = true, -- Swipe
			[77758] = true,  -- Thrash
			[783] = true,    -- Travel Form
			[132469] = true, -- Typhoon
			[102401] = true, -- Wild Charge
		},
		[4] = { -- Restoration
			[22812] = true,  -- Barkskin
			[5487] = true,   -- Bear Form
			[768] = true,    -- Cat Form
			[102351] = true, -- Cenarion Ward
			[33786] = true,  -- Cyclone
			[1850] = true,   -- Dash
			[102280] = true, -- Displacer Beast
			[193753] = true, -- Dreamwalk
			[145205] = true, -- Efflorescence
			[339] = true,    -- Entangling Roots
			[208253] = true, -- Essence of G'Hanir (Artifact)
			[22568] = true,  -- Ferocious Bite
			[197721] = true, -- Flourish
			[22842] = true,  -- Frenzied Regeneration
			[208683] = true, -- Gladiator's Medallion
			[6795] = true,   -- Growl
			[5185] = true,   -- Healing Touch
			[33891] = true,  -- Incarnation: Tree of Life
			[29166] = true,  -- Innervate
			[102342] = true, -- Ironbark
			[192081] = true, -- Ironfur
			[33763] = true,  -- Lifebloom
			[197628] = true, -- Lunar Strike
			[33917] = true,  -- Mangle
			[102359] = true, -- Mass Entanglement
			[5211] = true,   -- Mighty Bash
			[8921] = true,   -- Moonfire
			[197625] = true, -- Moonkin Form
			[88423] = true,  -- Nature's Cure
			[203651] = true, -- Overgrowth
			[20484] = true,  -- Rebirth
			[5215] = true,   -- Prowl
			[1822] = true,   -- Rake
			[8936] = true,   -- Regrowth
			[774] = true,    -- Rejuvenation
			[108238] = true, -- Renewal
			[212040] = true, -- Revitalize
			[50769] = true,  -- Revive
			[1079] = true,   -- Rip
			[5221] = true,   -- Shred
			[5176] = true,   -- Solar Wrath
			[197626] = true, -- Starsurge
			[93402] = true,  -- Sunfire
			[18562] = true,  -- Swiftmend
			[213764] = true, -- Swipe
			[203727] = true, -- Thorns
			[106832] = true, -- Thrash
			[740] = true,    -- Tranquility
			[783] = true,    -- Travel Form
			[132469] = true, -- Typhoon
			[102793] = true, -- Ursol's Vortex
			[102401] = true, -- Wild Charge
			[48438] = true,  -- Wild Growth
		},
	},
	["HUNTER"] = {
		[1] = { -- Beast Mastery
			[131894] = true, -- A Murder of Crows
			[214027] = true, -- Adaptation
			[186257] = true, -- Aspect of the Cheetah
			[186265] = true, -- Aspect of the Turtle
			[193530] = true, -- Aspect of the Wild
			[120360] = true, -- Barrage
			[1462] = true,   -- Beast Lore
			[19574] = true,  -- Bestial Wrath
			[109248] = true, -- Binding Shot
			[53209] = true,  -- Chimaera Shot
			[193455] = true, -- Cobra Shot
			[5116] = true,   -- Concussive Shot
			[147362] = true, -- Counter Shot
			[205691] = true, -- Dire Beast: Basilisk
			[208652] = true, -- Dire Beast: Hawk
			[217200] = true, -- Dire Frenzy (Pet)
			[781] = true,    -- Disengage
			[2641] = true,   -- Dismiss Pet
			[6197] = true,   -- Eagle Eye
			[109304] = true, -- Exhilaration
			[6991] = true,   -- Feed Pet
			[5384] = true,   -- Feign Death
			[125050] = true, -- Fetch
			[1543] = true,   -- Flare
			[187650] = true, -- Freezing Trap
			[208683] = true, -- Gladiator's Medallion
			[197344] = true, -- Hati's Bond (Artifact)
			[248518] = true, -- Interlope
			[19577] = true,  -- Intimidation
			[34026]  = true, -- Kill Command
			[34477] = true,  -- Misdirection
			[2643]   = true, -- Multi-Shot
			[209997] = true, -- Play Dead
			[982] = true,    -- Revive Pet
			[202900] = true, -- Scorpid Sting
			[202914] = true, -- Spider Sting
			[201430] = true, -- Stampede (?)
			[187698] = true, -- Tar Trap
			[202797] = true, -- Viper Sting
			[194386] = true, -- Volley
			[19386] = true,  -- Wyvern Sting
		},
		[2] = { -- Marksmanship
			[131894] = true, -- A Murder of Crows
			[214027] = true, -- Adaptation
			[19434]  = true, -- Aimed Shot
			[186257] = true, -- Aspect of the Cheetah
			[186265] = true, -- Aspect of the Turtle
			[120360] = true, -- Barrage
			[1462] = true,   -- Beast Lore
			[109248] = true, -- Binding Shot
			[194599] = true, -- Black Arrow
			[186387] = true, -- Bursting Shot
			[199483] = true, -- Camouflage
			[5116] = true,   -- Concussive Shot
			[147362] = true, -- Counter Shot
			[781] = true,    -- Disengage
			[2641] = true,   -- Dismiss Pet
			[6197] = true,   -- Eagle Eye
			[109304] = true, -- Exhilaration
			[212431] = true, -- Explosive Shot
			[6991] = true,   -- Feed Pet
			[5384] = true,   -- Feign Death
			[125050] = true, -- Fetch
			[1543] = true,   -- Flare
			[187650] = true, -- Freezing Trap
			[208683] = true, -- Gladiator's Medallion
			[236776] = true, -- Hi-Explosive Trap
			[185901] = true, -- Marked Shot
			[34477] = true,  -- Misdirection
			[198670] = true, -- Piercing Shot
			[209997] = true, -- Play Dead
			[982] = true,    -- Revive Pet
			[213691] = true, -- Scatter Shot
			[202900] = true, -- Scorpid Sting
			[206817] = true, -- Sentinel
			[214579] = true, -- Sidewinders
			[203155] = true, -- Sniper Shot
			[202914] = true, -- Spider Sting
			[187698] = true, -- Tar Trap
			[193526] = true, -- Trueshot
			[202797] = true, -- Viper Sting
			[194386] = true, -- Volley
			[204147] = true, -- Windburst (Artifact)
			[19386] = true,  -- Wyvern Sting
		},
		[3] = { -- Survival
			[214027] = true, -- Adaptation
			[186257] = true, -- Aspect of the Cheetah
			[186289] = true, -- Aspect of the Eagle
			[186265] = true, -- Aspect of the Turtle
			[1462] = true,   -- Beast Lore
			[212436] = true, -- Butchery
			[194277] = true, -- Caltrops
			[199483] = true, -- Camouflage
			[187708] = true, -- Carve
			[781] = true,    -- Disengage
			[2641] = true,   -- Dismiss Pet
			[194855] = true, -- Dragonsfire Grenade
			[6197] = true,   -- Eagle Eye
			[109304] = true, -- Exhilaration
			[191433] = true, -- Explosive Trap
			[6991] = true,   -- Feed Pet
			[5384] = true,   -- Feign Death
			[125050] = true, -- Fetch
			[202800] = true, -- Flanking Strike
			[1543] = true,   -- Flare
			[203415] = true, -- Fury of the Eagle (Artifact)
			[208683] = true, -- Gladiator's Medallion
			[190925] = true, -- Harpoon
			[193265] = true, -- Hatchet Toss
			[185855] = true, -- Lacerate
			[53271] = true,  -- Master's Call
			[212640] = true, -- Mending Bandage
			[190928] = true, -- Mongoose Bite
			[187707] = true, -- Muzzle
			[209997] = true, -- Play Dead
			[200108] = true, -- Ranger's Net
			[186270] = true, -- Raptor Strike
			[982] = true,    -- Revive Pet
			[202900] = true, -- Scorpid Sting
			[202914] = true, -- Spider Sting
			[194407] = true, -- Spitting Cobra
			[162488] = true, -- Steel Trap
			[191241] = true, -- Sticky Bomb
			[187698] = true, -- Tar Trap
			[212638] = true, -- Tracker's Net
			[200163] = true, -- Throwing Axes
			[202797] = true, -- Viper Sting
			[195645] = true, -- Wing Clip
		},
	},
	["MAGE"] = {
		[1] = { -- Arcane
			[214027] = true, -- Adaptation
			[44425] = true,  -- Arcane Barrage
			[30451] = true,  -- Arcane Blast
			[1449] = true,   -- Arcane Explosion
			[205022] = true, -- Arcane Familiar
			[5143] = true,   -- Arcane Missiles
			[153626] = true, -- Arcane Orb
			[12042] = true,  -- Arcane Power
			[1953] = true,   -- Blink
			[205032] = true, -- Charged Up
			[190336] = true, -- Conjure Refreshment
			[2139] = true,   -- Counterspell
			[195676] = true, -- Displacement
			[12051] = true,  -- Evocation
			[122] = true,    -- Frost Nova
			[116] = true,    -- Frostbolt
			[208683] = true, -- Gladiator's Medallion
			[110959] = true, -- Greater Invisibility
			[45438] = true,  -- Ice Block
			[224968] = true, -- Mark of Aluneth (Artifact)
			[198158] = true, -- Mass Invisibility
			[55342] = true,  -- Mirror Image
			[114923] = true, -- Nether Tempest
			[118] = true,    -- Polymorph
			[11417] = true,  -- Portal: Orgrimmar
			[32267] = true,  -- Portal: Silvermoon
			[49361] = true,  -- Portal: Stonard
			[11420] = true,  -- Portal: Thunder Bluff
			[11418] = true,  -- Portal: Undercity
			[205025] = true, -- Presence of Mind
			[235450] = true, -- Prismatic Barrier
			[113724] = true, -- Ring of Frost
			[116011] = true, -- Rune of Power
			[212653] = true, -- Shimmer
			[31589] = true,  -- Slow
			[130] = true,    -- Slow Fall
			[30449] = true,  -- Spellsteal
			[157980] = true, -- Supernova
			[3567] = true,   -- Teleport: Orgrimmar
			[32272] = true,  -- Teleport: Silvermoon
			[49358] = true,  -- Teleport: Stonard
			[3566] = true,   -- Teleport: Thunder Bluff
			[3563] = true,   -- Teleport: Undercity
			[198111] = true, -- Temporal Shield
			[80353] = true,  -- Time Warp
		},
		[2] = { -- Fire
			[214027] = true, -- Adaptation
			[157981] = true, -- Blast Wave
			[235313] = true, -- Blazing Barrier
			[1953] = true,   -- Blink
			[198929] = true, -- Cinderstorm
			[190319] = true, -- Combustion
			[190336] = true, -- Conjure Refreshment
			[2139] = true,   -- Counterspell
			[31661] = true,  -- Dragon's Breath
			[108853] = true, -- Fire Blast
			[133] = true,    -- Fireball
			[2120] = true,   -- Flamestrike
			[122] = true,    -- Frost Nova
			[208683] = true, -- Gladiator's Medallion
			[203286] = true, -- Greater Pyroblast
			[45438] = true,  -- Ice Block
			[66]    = true,  -- Invisibility
			[44457] = true,  -- Living Bomb
			[153561] = true, -- Meteor
			[55342] = true,  -- Mirror Image
			[194466] = true, -- Phoenix's Flame (Artifact)
			[118] = true,    -- Polymorph
			[11417] = true,  -- Portal: Orgrimmar
			[32267] = true,  -- Portal: Silvermoon
			[49361] = true,  -- Portal: Stonard
			[11420] = true,  -- Portal: Thunder Bluff
			[11418] = true,  -- Portal: Undercity
			[11366] = true,  -- Pyroblast
			[113724] = true, -- Ring of Frost
			[116011] = true, -- Rune of Power
			[2948] = true,   -- Scorch
			[212653] = true, -- Shimmer
			[130] = true,    -- Slow Fall
			[30449] = true,  -- Spellsteal
			[3567] = true,   -- Teleport: Orgrimmar
			[32272] = true,  -- Teleport: Silvermoon
			[49358] = true,  -- Teleport: Stonard
			[3566] = true,   -- Teleport: Thunder Bluff
			[3563] = true,   -- Teleport: Undercity
			[198111] = true, -- Temporal Shield
			[80353] = true,  -- Time Warp
		},
		[3] = { -- Frost
			[214027] = true, -- Adaptation
			[190356] = true, -- Blizzard
			[235219] = true, -- Cold Snap
			[153595] = true, -- Comet Storm
			[120] = true,    -- Cone of Cold
			[190336] = true, -- Conjure Refreshment
			[2139] = true,   -- Counterspell
			[214634] = true, -- Ebonbolt (Artifact)
			[44614] = true,  -- Flurry
			[112948] = true, -- Frost Bomb
			[122] = true,    -- Frost Nova
			[116] = true,    -- Frostbolt
			[84714] = true,  -- Frozen Orb
			[199786] = true, -- Glacial Spike
			[208683] = true, -- Gladiator's Medallion
			[11426] = true,  -- Ice Barrier
			[45438] = true,  -- Ice Block
			[108839] = true, -- Ice Floes
			[198144] = true, -- Ice Form
			[30455] = true,  -- Ice Lance
			[157997] = true, -- Ice Nova
			[12472] = true,  -- Icy Veins
			[66]    = true,  -- Invisibility
			[55342] = true,  -- Mirror Image
			[118] = true,    -- Polymorph
			[11417] = true,  -- Portal: Orgrimmar
			[32267] = true,  -- Portal: Silvermoon
			[49361] = true,  -- Portal: Stonard
			[11420] = true,  -- Portal: Thunder Bluff
			[11418] = true,  -- Portal: Undercity
			[205021] = true, -- Ray of Frost
			[113724] = true, -- Ring of Frost
			[116011] = true, -- Rune of Power
			[212653] = true, -- Shimmer
			[130] = true,    -- Slow Fall
			[30449] = true,  -- Spellsteal
			[3567] = true,   -- Teleport: Orgrimmar
			[32272] = true,  -- Teleport: Silvermoon
			[49358] = true,  -- Teleport: Stonard
			[3566] = true,   -- Teleport: Thunder Bluff
			[3563] = true,   -- Teleport: Undercity
			[198111] = true, -- Temporal Shield
			[80353] = true,  -- Time Warp
		},
	},
	["MONK"] = {
		[1] = { -- Brewmaster
			[214027] = true, -- Adaptation
			[207025] = true, -- Admonishment
			[115399] = true, -- Black Ox Brew
			[205523] = true, -- Blackout Strike
			[115181] = true, -- Breath of Fire
			[123986] = true, -- Chi Burst
			[115008] = true, -- Chi Torpedo
			[115098] = true, -- Chi Wave
			[117952] = true, -- Crackling Jade Lightning
			[213658] = true, -- Craft: Nimble Brew
			[122278] = true, -- Dampen Harm
			[218164] = true, -- Detox
			[202335] = true, -- Double Barrel
			[116694] = true, -- Effuse
			[115072] = true, -- Expel Harm
			[214326] = true, -- Exploding Key (Artifact)
			[115203] = true, -- Fortifying Brew
			[208683] = true, -- Gladiator's Medallion
			[202162] = true, -- Guard
			[122281] = true, -- Healing Elixir
			[132578] = true, -- Invoke Niuzao, the Black Ox
			[115308] = true, -- Ironskin Brew
			[121253] = true, -- Keg Smash
			[119381] = true, -- Leg Sweep
			[202370] = true, -- Mighty Ox Kick
			[115078] = true, -- Paralysis
			[115546] = true, -- Provoke
			[119582] = true, -- Purifying Brew
			[115178] = true, -- Resuscitate
			[116847] = true, -- Rushing Jade Wind
			[116844] = true, -- Ring of Peace
			[109132] = true, -- Roll
			[116705] = true, -- Spear Hand Strike
			[115315] = true, -- Summon Black Ox Statue
			[100780] = true, -- Tiger Palm
			[116841] = true, -- Tiger's Lust
			[101643] = true, -- Transcendence
			[101643] = true, -- Transcendence: Transfer
			[115176] = true, -- Zen Meditation
			[126892] = true, -- Zen Pilgrimage
		},
		[2] = { -- Mistweaver
			[214027] = true, -- Adaptation
			[100784] = true, -- Blackout Kick
			[123986] = true, -- Chi Burst
			[115008] = true, -- Chi Torpedo
			[115098] = true, -- Chi Wave
			[117952] = true, -- Crackling Jade Lightning
			[122278] = true, -- Dampen Harm
			[115450] = true, -- Detox
			[122783] = true, -- Diffuse Magic
			[116694] = true, -- Effuse
			[124682] = true, -- Enveloping Mist
			[191837] = true, -- Essence Font
			[243435] = true, -- Fortifying Brew
			[208683] = true, -- Gladiator's Medallion
			[122281] = true, -- Healing Elixir
			[205234] = true, -- Healing Sphere
			[198664] = true, -- Invoke Chi-Ji, the Red Crane
			[119381] = true, -- Leg Sweep
			[116849] = true, -- Life Cocoon
			[197908] = true, -- Mana Tea
			[115078] = true, -- Paralysis
			[115546] = true, -- Provoke
			[212051] = true, -- Reawaken
			[196725] = true, -- Refreshing Jade Wind
			[115151] = true, -- Renewing Mist
			[115178] = true, -- Resuscitate
			[115310] = true, -- Revival
			[116844] = true, -- Ring of Peace
			[107428] = true, -- Rising Sun Kick
			[109132] = true, -- Roll
			[205406] = true, -- Sheilun's Gift (Artifact)
			[198898] = true, -- Song of Chi-Ji
			[101546] = true, -- Spinning Crane Kick
			[115313] = true, -- Summon Jade Serpent Statue
			[116680] = true, -- Thunder Focus Tea
			[100780] = true, -- Tiger Palm
			[116841] = true, -- Tiger's Lust
			[101643] = true, -- Transcendence
			[101643] = true, -- Transcendence: Transfer
			[116670] = true, -- Vivify
			[216113] = true, -- Way of the Crane
			[209584] = true, -- Zen Focus Tea
			[126892] = true, -- Zen Pilgrimage
			[124081] = true, -- Zen Pulse
		},
		[3] = { -- Windwalker
			[214027] = true, -- Adaptation
			[100784] = true, -- Blackout Kick
			[123986] = true, -- Chi Burst
			[115008] = true, -- Chi Torpedo
			[115098] = true, -- Chi Wave
			[117952] = true, -- Crackling Jade Lightning
			[122278] = true, -- Dampen Harm
			[218164] = true, -- Detox
			[116095] = true, -- Disable
			[116694] = true, -- Effuse
			[113656] = true, -- Fists of Fury
			[101545] = true, -- Flying Serpent Kick
			[201318] = true, -- Fortifying Brew
			[208683] = true, -- Gladiator's Medallion
			[233759] = true, -- Grapple Weapon
			[122281] = true, -- Healing Elixir
			[119381] = true, -- Leg Sweep
			[115078] = true, -- Paralysis
			[115546] = true, -- Provoke
			[115178] = true, -- Resuscitate
			[116844] = true, -- Ring of Peace
			[107428] = true, -- Rising Sun Kick
			[116847] = true, -- Rushing Jade Wind
			[109132] = true, -- Roll
			[116705] = true, -- Spear Hand Strike
			[101546] = true, -- Spinning Crane Kick
			[137639] = true, -- Storm, Earth, and Fire
			[205320] = true, -- Strike of the Windlord (Artifact)
			[100780] = true, -- Tiger Palm
			[116841] = true, -- Tiger's Lust
			[247483] = true, -- Tigereye Brew
			[115080] = true, -- Touch of Death
			[122470] = true, -- Touch of Karma
			[101643] = true, -- Transcendence
			[101643] = true, -- Transcendence: Transfer
			[201325] = true, -- Zen Moment
			[126892] = true, -- Zen Pilgrimage
		},
	},
	["PALADIN"] = {
		[1] = { -- Holy
			[214027] = true, -- Adaptation
			[212056] = true, -- Absolution
			[31821] = true,  -- Aura Mastery
			[216331] = true, -- Avenging Crusader
			[31842] = true,  -- Avenging Wrath
			[156910] = true, -- Beacon of Faith
			[200025] = true, -- Beacon of Virtue
			[223306] = true, -- Bestow Faith
			[1044] = true,   -- Blessing of Freedom
			[1022] = true,   -- Blessing of Protection
			[6940] = true,   -- Blessing of Sacrifice
			[115750] = true, -- Blinding Light
			[4987] = true,   -- Cleanse
			[26573] = true,  -- Consecration
			[35395] = true,  -- Crusader Strike
			[210294] = true, -- Divine Favor
			[498] = true,    -- Divine Protection
			[642] = true,    -- Divine Shield
			[190784] = true, -- Divine Steed
			[19750] = true,  -- Flash of Light
			[208683] = true, -- Gladiator's Medallion
			[853] = true,    -- Hammer of Justice
			[62124] = true,  -- Hand of Reckoning
			[105809] = true, -- Holy Avenger
			[82326] = true,  -- Holy Light
			[114165] = true, -- Holy Prism
			[20473] = true,  -- Holy Shock
			[20271] = true,  -- Judgment
			[633] = true,    -- Lay on Hands
			[85222] = true,  -- Light of Dawn
			[183998] = true, -- Light of the Martyr
			[114158] = true, -- Light's Hammer
			[7328] = true,   -- Redemption
			[20066] = true,  -- Repentance
			[214202] = true, -- Rule of Law
			[200652] = true, -- Tyr's Deliverance (Artifact)
		},
		[2] = { -- Protection
			[214027] = true, -- Adaptation
			[204150] = true, -- Aegis of Light
			[31850] = true,  -- Arden Defender
			[31935] = true,  -- Avenger's Shield
			[31884] = true,  -- Avenging Wrath
			[204035] = true, -- Bastion of Light
			[204019] = true, -- Blessed Hammer
			[1044] = true,   -- Blessing of Freedom
			[1022] = true,   -- Blessing of Protection
			[6940] = true,   -- Blessing of Sacrifice
			[204018] = true, -- Blessing of Spellwarding
			[115750] = true, -- Blinding Light
			[213644] = true, -- Cleanse Toxins
			[236186] = true, -- Cleansing Light
			[26573] = true,  -- Consecration
			[642] = true,    -- Divine Shield
			[190784] = true, -- Divine Steed
			[209202] = true, -- Eye of Tyr (Artifact)
			[19750] = true,  -- Flash of Light
			[208683] = true, -- Gladiator's Medallion
			[86659] = true,  -- Guardian of Ancient Kings
			[228049] = true, -- Guardian of the Forgotten Queen
			[853] = true,    -- Hammer of Justice
			[53595] = true,  -- Hammer of the Righteous
			[213652] = true, -- Hand of the Protector
			[62124] = true,  -- Hand of Reckoning
			[207028] = true, -- Inquisition
			[20271] = true,  -- Judgment
			[633] = true,    -- Lay on Hands
			[184092] = true, -- Light of the Protector
			[96231] = true,  -- Rebuke
			[7328] = true,   -- Redemption
			[20066] = true,  -- Repentance
			[152262] = true, -- Seraphim
			[53600] = true,  -- Shield of the Righteous
			[215652] = true, -- Shield of Virtue
		},
		[3] = { -- Retribution
			[214027] = true, -- Adaptation
			[31884] = true,  -- Avenging Wrath
			[184575] = true, -- Blade of Justice
			[1044] = true,   -- Blessing of Freedom
			[1022] = true,   -- Blessing of Protection
			[115750] = true, -- Blinding Light
			[213644] = true, -- Cleanse Toxins
			[236186] = true, -- Cleansing Light
			[205228] = true, -- Consecration
			[231895] = true, -- Crusade
			[35395] = true,  -- Crusader Strike
			[198034] = true, -- Divine Hammer
			[642] = true,    -- Divine Shield
			[190784] = true, -- Divine Steed
			[53385] = true,  -- Divine Storm
			[213757] = true, -- Execution Sentence
			[205191] = true, -- Eye for an Eye
			[19750] = true,  -- Flash of Light
			[208683] = true, -- Gladiator's Medallion
			[203538] = true, -- Greater Blessing of Kings
			[203539] = true, -- Greater Blessing of Wisdom
			[853] = true,    -- Hammer of Justice
			[183218] = true, -- Hand of Hindrance
			[62124] = true,  -- Hand of Reckoning
			[210220] = true, -- Holy Wrath
			[20271] = true,  -- Judgment
			[215661] = true, -- Justicar's Vengeance
			[633] = true,    -- Lay on Hands
			[96231] = true,  -- Rebuke
			[7328] = true,   -- Redemption
			[20066] = true,  -- Repentance
			[184662] = true, -- Shield of Vengeance
			[85256] = true,  -- Templar's Verdict
			[205273] = true, -- Wake of Ashes (Artifact)
			[210191] = true, -- Word of Glory
			[217020] = true, -- Zeal
		},
	},
	["PRIEST"] = {
		[1] = { -- Discipline
			[214027] = true, -- Adaptation
			[121536] = true, -- Angelic Feather
			[197862] = true, -- Archangel
			[152118] = true, -- Clarity of Will
			[197871] = true, -- Dark Archangel
			[528] = true,    -- Dispel Magic
			[110744] = true, -- Divine Star
			[246287] = true, -- Evangelism
			[586] = true,    -- Fade
			[2061] = true,   -- Flash Heal
			[208683] = true, -- Gladiator's Medallion
			[120517] = true, -- Halo
			[73325] = true,  -- Leap of Faith
			[1706] = true,   -- Levitate
			[207946] = true, -- Light's Wrath (Artifact)
			[32375] = true,  -- Mass Dispel
			[212036] = true, -- Mass Resurrection
			[605] = true,    -- Mind Control
			[2096] = true,   -- Mind Vision
			[123040] = true, -- Mindbender
			[33206] = true,  -- Pain Suppression
			[47540] = true,  -- Penance
			[200829] = true, -- Plea
			[10060] = true,  -- Power Infusion
			[62618] = true,  -- Power Word: Barrier
			[211681] = true, -- Power Word: Fortitude
			[194509] = true, -- Power Word: Radiance
			[17] = true,     -- Power Word: Shield
			[129250] = true, -- Power Word: Solace
			[209780] = true, -- Premonition
			[8122] = true,   -- Psychic Scream
			[204197] = true, -- Purge the Wicked
			[527] = true,    -- Purify
			[47536] = true,  -- Rapture
			[2006] = true,   -- Resurrection
			[214621] = true, -- Schism
			[9484] = true,   -- Shackle Undead
			[204065] = true, -- Shadow Covenant
			[186263] = true, -- Shadow Mend
			[589] = true,    -- Shadow Word: Pain
			[34433] = true,  -- Shadowfiend
			[204263] = true, -- Shining Force
			[585] = true,    -- Smite
		},
		[2] = { -- Holy
			[214027] = true, -- Adaptation
			[121536] = true, -- Angelic Feather
			[200183] = true, -- Apotheosis
			[32546] = true,  -- Binding Heal
			[214121] = true, -- Body and Mind
			[204883] = true, -- Circle of Healing
			[19236] = true,  -- Desperate Prayer
			[528] = true,    -- Dispel Magic
			[64843] = true,  -- Divine Hymn
			[110744] = true, -- Divine Star
			[586] = true,    -- Fade
			[2061] = true,   -- Flash Heal
			[208683] = true, -- Gladiator's Medallion
			[213602] = true, -- Greater Fade
			[47788] = true,  -- Guardian Spirit
			[120517] = true, -- Halo
			[2060] = true,   -- Heal
			[14914] = true,  -- Holy Fire
			[132157] = true, -- Holy Nova
			[213610] = true, -- Holy Ward
			[88625] = true,  -- Holy Word: Chastise
			[34861] = true,  -- Holy Word: Sanctify
			[2050] = true,   -- Holy Word: Serenity
			[196762] = true, -- Inner Focus
			[196684] = true, -- Invoke the Naaru (Artifact)
			[73325] = true,  -- Leap of Faith
			[1706] = true,   -- Levitate
			[32375] = true,  -- Mass Dispel
			[212036] = true, -- Mass Resurrection
			[605] = true,    -- Mind Control
			[596] = true,    -- Prayer of Healing
			[33076] = true,  -- Prayer of Mending
			[527] = true,    -- Purify
			[197268] = true, -- Ray of Hope
			[139] = true,    -- Renew
			[2006] = true,   -- Resurrection
			[9484] = true,   -- Shackle Undead
			[204263] = true, -- Shining Force
			[585] = true,    -- Smite
			[64901] = true,  -- Symbol of Hope
		},
		[3] = { -- Shadow
			[214027] = true, -- Adaptation
			[528] = true,    -- Dispel Magic
			[47585] = true,  -- Dispersion
			[586] = true,    -- Fade
			[208683] = true, -- Gladiator's Medallion
			[1706] = true,   -- Levitate
			[32375] = true,  -- Mass Dispel
			[8092] = true,   -- Mind Blast
			[205369] = true, -- Mind Bomb
			[605] = true,    -- Mind Control
			[15407] = true,  -- Mind Flay
			[2096] = true,   -- Mind Vision
			[200174] = true, -- Mindbender
			[10060] = true,  -- Power Infusion
			[17] = true,     -- Power Word: Shield
			[213634] = true, -- Purify Disease
			[8122] = true,   -- Psychic Scream
			[211522] = true, -- Psyfiend
			[2006] = true,   -- Resurrection
			[9484] = true,   -- Shackle Undead
			[205385] = true, -- Shadow Crash
			[186263] = true, -- Shadow Mend
			[32379] = true,  -- Shadow Word: Death
			[589] = true,    -- Shadow Word: Pain
			[205351] = true, -- Shadow Word: Void
			[34433] = true,  -- Shadowfiend
			[232698] = true, -- Shadowform
			[15487] = true,  -- Silence
			[193223] = true, -- Surrender to Madness
			[15286] = true,  -- Vampiric Embrace
			[34914] = true,  -- Vampiric Touch
			[228266] = true, -- Void Bolt
			[228260] = true, -- Void Eruption
			[108968] = true, -- Void Shift
			[205065] = true, -- Void Torrent (Artifact)
		},
	},
	["ROGUE"] = {
		[1] = { -- Assassination
			[214027] = true, -- Adaptation
			[2094] = true,   -- Blind
			[1833] = true,   -- Cheap Shot
			[31224] = true,  -- Cloak of Shadows
			[185311] = true, -- Crimson Vial
			[3408] = true,   -- Crippling Poison
			[2823] = true,   -- Deadly Poison
			[152150] = true, -- Death from Above
			[1725] = true,   -- Distract
			[32645] = true,  -- Envenom
			[5277] = true,   -- Evasion
			[200806] = true, -- Exsanguinate
			[51723] = true,  -- Fan of Knives
			[1966] = true,   -- Feint
			[703] = true,    -- Garrote
			[208683] = true, -- Gladiator's Medallion
			[16511] = true,  -- Hemorrhage
			[1766] = true,   -- Kick
			[408] = true,    -- Kidney Shot
			[192759] = true, -- Kingsbane (Artifact)
			[108211] = true, -- Leeching Poison
			[137619] = true, -- Marked for Death
			[1329] = true,   -- Mutilate
			[206328] = true, -- Neurotoxin
			[1943] = true,   -- Rupture
			[1804] = true,   -- Pick Lock
			[921] = true,    -- Pick Pocket
			[185565] = true, -- Poisoned Knife
			[6770] = true,   -- Sap
			[36554] = true,  -- Shadowstep
			[248744] = true, -- Shiv
			[114018] = true, -- Shroud of Concealment
			[2983] = true,   -- Sprint
			[1784] = true,   -- Stealth
			[245388] = true, -- Toxic Blade
			[57934] = true,  -- Tricks of the Trade
			[1856] = true,   -- Vanish
			[79140] = true,  -- Vendetta
			[8679] = true,   -- Wounded Poison
		},
		[2] = { -- Outlaw
			[214027] = true, -- Adaptation
			[13750] = true,  -- Adrenaline Rush
			[8676] = true,   -- Ambush
			[199804] = true, -- Between the Eyes
			[13877] = true,  -- Blade Flurry
			[2094] = true,   -- Blind
			[199740] = true, -- Bribe
			[185767] = true, -- Cannonball Barrage
			[1833] = true,   -- Cheap Shot
			[31224] = true,  -- Cloak of Shadows
			[185311] = true, -- Crimson Vial
			[202665] = true, -- Curse of the Dreadblades (Artifact)
			[152150] = true, -- Death from Above
			[207777] = true, -- Dismantle
			[1725] = true,   -- Distract
			[1966] = true,   -- Feint
			[208683] = true, -- Gladiator's Medallion
			[1766] = true,   -- Kick
			[51690] = true,  -- Killing Spree
			[196937] = true, -- Ghostly Strike
			[1776] = true,   -- Gouge
			[195457] = true, -- Grappling Hook
			[137619] = true, -- Marked for Death
			[199743] = true, -- Parley
			[1804] = true,   -- Pick Lock
			[921] = true,    -- Pick Pocket
			[185763] = true, -- Pistol Shot
			[198529] = true, -- Plunder Armor
			[199754] = true, -- Riposte
			[193316] = true, -- Roll the Bones
			[2098] = true,   -- Run Through
			[193315] = true, -- Saber Slash
			[6770] = true,   -- Sap
			[248744] = true, -- Shiv
			[114018] = true, -- Shroud of Concealment
			[5171] = true,   -- Slice and Dice
			[2983] = true,   -- Sprint
			[1784] = true,   -- Stealth
			[57934] = true,  -- Tricks of the Trade
			[1856] = true,   -- Vanish
		},
		[3] = { -- Subtlety
			[214027] = true, -- Adaptation
			[53] = true,     -- Backstab
			[2094] = true,   -- Blind
			[1833] = true,   -- Cheap Shot
			[31224] = true,  -- Cloak of Shadows
			[213981] = true, -- Cold Blood
			[185311] = true, -- Crimson Vial
			[152150] = true, -- Death from Above
			[1725] = true,   -- Distract
			[5277] = true,   -- Evasion
			[196819] = true, -- Eviscerate
			[1966] = true,   -- Feint
			[208683] = true, -- Gladiator's Medallion
			[200758] = true, -- Gloomblade
			[209782] = true, -- Goremaw's Bite (Artifact)
			[1766] = true,   -- Kick
			[408] = true,    -- Kidney Shot
			[137619] = true, -- Marked for Death
			[195452] = true, -- Nightblade
			[1804] = true,   -- Pick Lock
			[921] = true,    -- Pick Pocket
			[6770] = true,   -- Sap
			[121471] = true, -- Shadow Bladestorm
			[185313] = true, -- Shadow Dance
			[36554] = true,  -- Shadowstep
			[185438] = true, -- Shadowstrike
			[207736] = true, -- Shadowy Duel
			[248744] = true, -- Shiv
			[114018] = true, -- Shroud of Concealment
			[197835] = true, -- Shuriken Storm
			[114014] = true, -- Shuriken Toss
			[212182] = true, -- Smoke Bomb
			[2983] = true,   -- Sprint
			[1784] = true,   -- Stealth
			[212283] = true, -- Symbols of Death
			[57934] = true,  -- Tricks of the Trade
			[1856] = true,   -- Vanish
		},
	},
	["SHAMAN"] = {
		[1] = { -- Elemental
			[214027] = true, -- Adaptation
			[108281] = true, -- Ancestral Guidance
			[2008] = true,   -- Ancestral Spirit
			[556] = true,    -- Astral Recall
			[108271] = true, -- Astral Shift
			[2825] = true,   -- Bloostlust
			[188443] = true, -- Chain Lightning
			[51886] = true,  -- Cleanse Spirit
			[204331] = true, -- Counterstrike Totem
			[198103] = true, -- Earth Elemental
			[8042] = true,   -- Earth Shock
			[2484] = true,   -- Earthbind Totem
			[51485] = true,  -- Earthgrab Totem
			[61882] = true,  -- Earthquake
			[117014] = true, -- Elemental Blast
			[16166] = true,  -- Elemental Mastery
			[6196] = true,   -- Far Sight
			[188389] = true, -- Flame Shock
			[196840] = true, -- Frost Shock
			[2645] = true,   -- Ghost Wolf
			[208683] = true, -- Gladiator's Medallion
			[192063] = true, -- Gust of Wind
			[8004] = true,   -- Healing Surge
			[51514] = true,  -- Hex
			[210714] = true, -- Icefury
			[51505] = true,  -- Lava Burst
			[188196] = true, -- Lightning Bolt
			[204437] = true, -- Lightning Lasso
			[192058] = true, -- Lightning Surge Totem
			[192222] = true, -- Liquid Magma Totem
			[370] = true,    -- Purge
			[20608] = true,  -- Reincarnation
			[204330] = true, -- Skyfury Totem
			[192249] = true, -- Storm Elemental
			[205495] = true, -- Stormkeeper (Artifact)
			[51490] = true,  -- Thunderstorm
			[210643] = true, -- Totem Mastery
			[196932] = true, -- Voodoo Totem
			[546] = true,    -- Water Walking
			[192077] = true, -- Wind Rush Totem
			[57994] = true,  -- Wind Shear
			[204332] = true, -- Windfury Totem
		},
		[2] = { -- Enhancement
			[214027] = true, -- Adaptation
			[2008] = true,   -- Ancestral Spirit
			[114051] = true, -- Ascendance
			[556] = true,    -- Astral Recall
			[108271] = true, -- Astral Shift
			[2825] = true,   -- Bloostlust
			[51886] = true,  -- Cleanse Spirit
			[204331] = true, -- Counterstrike Totem
			[187874] = true, -- Crash Lightning
			[204945] = true, -- Doom Winds (Artifact)
			[188089] = true, -- Earthen Spike
			[2484] = true,   -- Earthbind Totem
			[51485] = true,  -- Earthgrab Totem
			[210918] = true, -- Ethereal Form
			[6196] = true,   -- Far Sight
			[196884] = true, -- Feral Lunge
			[193796] = true, -- Flametongue
			[196834] = true, -- Frostbrand
			[197211] = true, -- Fury of Air
			[2645] = true,   -- Ghost Wolf
			[208683] = true, -- Gladiator's Medallion
			[188070] = true, -- Healing Surge
			[51514] = true,  -- Hex
			[60103] = true,  -- Lava Lash
			[187837] = true, -- Lightning Bolt
			[192106] = true, -- Lightning Shield
			[192058] = true, -- Lightning Surge Totem
			[370] = true,    -- Purge
			[215864] = true, -- Rainfall
			[20608] = true,  -- Reincarnation
			[193786] = true, -- Rockbiter
			[204330] = true, -- Skyfury Totem
			[58875] = true,  -- Spirit Walk
			[17364] = true,  -- Stormstrike
			[197214] = true, -- Sundering
			[204366] = true, -- Thundercharge
			[196932] = true, -- Voodoo Totem
			[546] = true,    -- Water Walking
			[192077] = true, -- Wind Rush Totem
			[57994] = true,  -- Wind Shear
			[204332] = true, -- Windfury Totem
			[201898] = true, -- Windsong
		},
		[3] = { -- Restoration
			[214027] = true, -- Adaptation
			[108281] = true, -- Ancestral Guidance
			[207399] = true, -- Ancestral Protection Totem
			[2008] = true,   -- Ancestral Spirit
			[114052] = true, -- Ascendance
			[556] = true,    -- Astral Recall
			[108271] = true, -- Astral Shift
			[2825] = true,   -- Bloostlust
			[1064] = true,   -- Chain Heal
			[421] = true,    -- Chain Lightning
			[157153] = true, -- Cloudburst Totem
			[204331] = true, -- Counterstrike Totem
			[204288] = true, -- Earth Shield
			[198838] = true, -- Earthen Shield Totem
			[2484] = true,   -- Earthbind Totem
			[51485] = true,  -- Earthgrab Totem
			[6196] = true,   -- Far Sight
			[188838] = true, -- Flame Shock
			[2645] = true,   -- Ghost Wolf
			[207778] = true, -- Gift of the Queen (Artifact)
			[208683] = true, -- Gladiator's Medallion
			[204336] = true, -- Grounding Totem
			[192063] = true, -- Gust of Wind
			[73920] = true,  -- Healing Rain
			[5394] = true,   -- Healing Stream Totem
			[8004] = true,   -- Healing Surge
			[108280] = true, -- Healing Tide Totem
			[77472] = true,  -- Healing Wave
			[51514] = true,  -- Hex
			[51505] = true,  -- Lava Burst
			[403] = true,    -- Lightning Bolt
			[192058] = true, -- Lightning Surge Totem
			[370] = true,    -- Purge
			[77130] = true,  -- Purify Spirit
			[20608] = true,  -- Reincarnation
			[61295] = true,  -- Riptide
			[204330] = true, -- Skyfury Totem
			[204293] = true, -- Spirit Link
			[98008] = true,  -- Spirit Link Totem
			[79206] = true,  -- Spiritwalker's Grace
			[73685] = true,  -- Unleash Life
			[196932] = true, -- Voodoo Totem
			[546] = true,    -- Water Walking
			[197995] = true, -- Wellspring
			[192077] = true, -- Wind Rush Totem
			[57994] = true,  -- Wind Shear
			[204332] = true, -- Windfury Totem
		},
	},
	["WARLOCK"] = {
		[1] = { -- Affliction
			[214027] = true, -- Adaptation
			[980] = true,    -- Agony
			[710] = true,    -- Banish
			[111400] = true, -- Burning Rush
			[221703] = true, -- Casting Circle
			[119898] = true, -- Command Demon
			[172] = true,    -- Corruption
			[6201] = true,   -- Create Healthstone
			[29893] = true,  -- Create Soulwell
			[199954] = true, -- Curse of Fragility
			[234877] = true, -- Curse of Shadows
			[199890] = true, -- Curse of Tongues
			[199892] = true, -- Curse of Weakness
			[108416] = true, -- Dark Pact
			[48018] = true,  -- Demonic Circle
			[111771] = true, -- Demonic Gateway
			[198590] = true, -- Drain Soul
			[1098] = true,   -- Enslave Demon
			[126] = true,    -- Eye of Kilrogg
			[5782] = true,   -- Fear
			[208683] = true, -- Gladiator's Medallion
			[108503] = true, -- Grimoire of Sacrifice
			[48181] = true,  -- Haunt
			[755] = true,    -- Health Funnel
			[5484] = true,   -- Howl of Terror
			[1454] = true,   -- Life Tap
			[6789] = true,   -- Mortal Coil
			[212295] = true, -- Nether Ward
			[205179] = true, -- Phantom Singularity
			[216698] = true, -- Reap Souls (Artifact)
			[698] = true,    -- Ritual of Summoning
			[27243] = true,  -- Seed of Corruption
			[63106] = true,  -- Siphon Life
			[196098] = true, -- Soul Harvest
			[20707] = true,  -- Soulstone
			[18540] = true,  -- Summon Doomguard
			[691] = true,    -- Summon Felhunter
			[688] = true,    -- Summon Imp
			[1122] = true,   -- Summon Infernal
			[712] = true,    -- Summon Succubus
			[697] = true,    -- Summon Voidwalker
			[5697] = true,   -- Unending Breath
			[104773] = true, -- Unending Resolve
			[30108] = true,  -- Unstable Affliction
		},
		[2] = { -- Demonology
			[214027] = true, -- Adaptation
			[710] = true,    -- Banish
			[111400] = true, -- Burning Rush
			[104316] = true, -- Call Dreadstalkers
			[212459] = true, -- Call Fel Lord
			[212619] = true, -- Call Felhunter
			[201996] = true, -- Call Observer
			[221703] = true, -- Casting Circle
			[6201] = true,   -- Create Healthstone
			[29893] = true,  -- Create Soulwell
			[199954] = true, -- Curse of Fragility
			[199890] = true, -- Curse of Tongues
			[199892] = true, -- Curse of Weakness
			[108416] = true, -- Dark Pact
			[157695] = true, -- Demonbolt
			[48018] = true,  -- Demonic Circle
			[193396] = true, -- Demonic Empowerment
			[111771] = true, -- Demonic Gateway
			[193440] = true, -- Demonwrath
			[603] = true,    -- Doom
			[234153] = true, -- Drain Life
			[1098] = true,   -- Enslave Demon
			[126] = true,    -- Eye of Kilrogg
			[5782] = true,   -- Fear
			[208683] = true, -- Gladiator's Medallion
			[105174] = true, -- Hand of Gul'dan
			[755] = true,    -- Health Funnel
			[196277] = true, -- Implosion
			[1454] = true,   -- Life Tap
			[6789] = true,   -- Mortal Coil
			[212295] = true, -- Nether Ward
			[698] = true,    -- Ritual of Summoning
			[686] = true,    -- Shadow Bolt
			[171140] = true, -- Shadow Lock
			[205181] = true, -- Shadowflame
			[30283] = true,  -- Shadowfury
			[212623] = true, -- Singe Magic
			[196098] = true, -- Soul Harvest
			[20707] = true,  -- Soulstone
			[205180] = true, -- Summon Darkglare
			[157757] = true, -- Summon Doomguard
			[30146] = true,  -- Summon Felguard
			[691] = true,    -- Summon Felhunter
			[688] = true,    -- Summon Imp
			[157898] = true, -- Summon Infernal
			[712] = true,    -- Summon Succubus
			[697] = true,    -- Summon Voidwalker
			[211714] = true, -- Thal'kiel's Consumption (Artifact)
			[5697] = true,   -- Unending Breath
			[104773] = true, -- Unending Resolve
		},
		[3] = { -- Destruction
			[214027] = true, -- Adaptation
			[200546] = true, -- Bane of Havoc
			[710] = true,    -- Banish
			[111400] = true, -- Burning Rush
			[221703] = true, -- Casting Circle
			[152108] = true, -- Cataclysm
			[196447] = true, -- Channel Demonfire
			[116858] = true, -- Chaos Bolt
			[119898] = true, -- Command Demon
			[17962] = true,  -- Conflagarate
			[6201] = true,   -- Create Healthstone
			[29893] = true,  -- Create Soulwell
			[199954] = true, -- Curse of Fragility
			[199890] = true, -- Curse of Tongues
			[199892] = true, -- Curse of Weakness
			[108416] = true, -- Dark Pact
			[48018] = true,  -- Demonic Circle
			[111771] = true, -- Demonic Gateway
			[196586] = true, -- Dimensional Rift (Artifact)
			[234153] = true, -- Drain Life
			[1098] = true,   -- Enslave Demon
			[126] = true,    -- Eye of Kilrogg
			[5782] = true,   -- Fear
			[212284] = true, -- Firestone
			[208683] = true, -- Gladiator's Medallion
			[108503] = true, -- Grimoire of Sacrifice
			[80240] = true,  -- Havoc
			[755] = true,    -- Health Funnel
			[348] = true,    -- Immolate
			[29722] = true,  -- Incinerate
			[1454] = true,   -- Life Tap
			[6789] = true,   -- Mortal Coil
			[212295] = true, -- Nether Ward
			[5740] = true,   -- Rain of Fire
			[698] = true,    -- Ritual of Summoning
			[17877] = true,  -- Shadowburn
			[30283] = true,  -- Shadowfury
			[196098] = true, -- Soul Harvest
			[20707] = true,  -- Soulstone
			[157757] = true, -- Summon Doomguard
			[691] = true,    -- Summon Felhunter
			[688] = true,    -- Summon Imp
			[157898] = true, -- Summon Infernal
			[712] = true,    -- Summon Succubus
			[697] = true,    -- Summon Voidwalker
			[5697] = true,   -- Unending Breath
			[104773] = true, -- Unending Resolve
		},
	},
	["WARRIOR"] = {
		[1] = { -- Arms
			[214027] = true, -- Adaptation
			[107574] = true, -- Avatar
			[1719] = true,   -- Battle Cry
			[18499] = true,  -- Berserker Rage
			[227847] = true, -- Bladestorm
			[100] = true,    -- Charge
			[845] = true,    -- Cleave
			[167105] = true, -- Colossus Smash
			[97462] = true,  -- Commanding Shout
			[197690] = true, -- Defensive Stance
			[236077] = true, -- Disarm
			[118038] = true, -- Due by the Sword
			[236273] = true, -- Duel
			[163201] = true, -- Execute
			[207982] = true, -- Focused Rage
			[208683] = true, -- Gladiator's Medallion
			[1715] = true,   -- Hamstring
			[6544] = true,   -- Heroic Leap
			[57755] = true,  -- Heroic Throw
			[5246] = true,   -- Intimidating Shout
			[12294] = true,  -- Mortal Strike
			[7384] = true,   -- Overpower
			[6552] = true,   -- Pummel
			[152277] = true, -- Ravager
			[772] = true,    -- Rend
			[198817] = true, -- Sharpen Blade
			[46968] = true,  -- Shockwave
			[1464] = true,   -- Slam
			[216890] = true, -- Spell Reflection
			[107570] = true, -- Storm Bolt
			[355] = true,    -- Taunt
			[34428] = true,  -- Victory Rush
			[236320] = true, -- War Banner
			[209577] = true, -- Warbreaker (Artifact)
			[1680] = true,   -- Whirlwind
		},
		[2] = { -- Fury
			[214027] = true, -- Adaptation
			[107574] = true, -- Avatar
			[1719] = true,   -- Battle Cry
			[18499] = true,  -- Berserker Rage
			[46924] = true,  -- Bladestorm
			[12292] = true,  -- Bloodbath
			[23881] = true,  -- Bloodthirst
			[100] = true,    -- Charge
			[97462] = true,  -- Commanding Shout
			[199261] = true, -- Death Wish
			[236077] = true, -- Disarm
			[118000] = true, -- Dragon Roar
			[184364] = true, -- Enraged Regeneration
			[5308] = true,   -- Execute
			[100130] = true, -- Furious Slash
			[208683] = true, -- Gladiator's Medallion
			[6544] = true,   -- Heroic Leap
			[57755] = true,  -- Heroic Throw
			[5246] = true,   -- Intimidating Shout
			[205545] = true, -- Odyn's Fury (Artifact)
			[12323] = true,  -- Piercing Howl
			[6552] = true,   -- Pummel
			[85288] = true,  -- Raging Blow
			[184367] = true, -- Rampage
			[46968] = true,  -- Shockwave
			[216890] = true, -- Spell Reflection
			[107570] = true, -- Storm Bolt
			[355] = true,    -- Taunt
			[190411] = true, -- Whirlwind
		},
		[3] = { -- Protection
			[214027] = true, -- Adaptation
			[107574] = true, -- Avatar
			[1719] = true,   -- Battle Cry
			[18499] = true,  -- Berserker Rage
			[213871] = true, -- Bodyguard
			[1160] = true,   -- Demoralizing Shout
			[20243] = true,  -- Devastate
			[236236] = true, -- Disarm
			[206572] = true, -- Dragon Charge
			[208683] = true, -- Gladiator's Medallion
			[6544] = true,   -- Heroic Leap
			[57755] = true,  -- Heroic Throw
			[190456] = true, -- Ignore Pain
			[202168] = true, -- Impending Victory
			[198304] = true, -- Intercept
			[12975] = true,  -- Last Stand
			[203524] = true, -- Neltharion's Fury (Artifact)
			[6552] = true,   -- Pummel
			[228920] = true, -- Ravager
			[6572] = true,   -- Revenge
			[198912] = true, -- Shield Bash
			[2565] = true,   -- Shield Block
			[23922] = true,  -- Shield Slam
			[871] = true,    -- Shield Wall
			[23920] = true,  -- Shield Reflection
			[46968] = true,  -- Shockwave
			[107570] = true, -- Storm Bolt
			[355] = true,    -- Taunt
			[6343] = true,   -- Thunder Clap
		},
	},
}

local artifactSpells = {
	["DEATHKNIGHT"] = {
		[1] = { -- Blood
			[205223] = true, -- Consumption
		},
		[2] = { -- Frost
			[189186] = true, -- Crystalline Swords
		},
		[3] = { -- Undead
			[220143] = true, -- Apocalypse
		},
	},
	["DEMONHUNTER"] = {
		[1] = { -- Havok
			[201467] = true, -- Fury of the Illidari
		},
		[2] = { -- Vengeance
			[207407] = true, -- Soul Carver
		},
	},
	["DRUID"] = {
		[1] = { -- Balance
			[202771] = true, -- Full Moon
			[202768] = true, -- Half Moon
			[202767] = true, -- New Moon
		},
		[2] = { -- Feral
			[210722] = true, -- Ashamane's Frenzy
		},
		[3] = { -- Guardian
			[200851] = true, -- Rage of the Sleeper
		},
		[4] = { -- Restoration
			[208253] = true, -- Essence of G'Hanir
		},
	},
	["HUNTER"] = {
		[1] = { -- Beast Mastery
			[197344] = true, -- Hati's Bond
		},
		[2] = { -- Marksmanship
			[204147] = true, -- Windburst
		},
		[3] = { -- Survival
			[203415] = true, -- Fury of the Eagle
		},
	},
	["MAGE"] = {
		[1] = { -- Arcane
			[224968] = true, -- Mark of Aluneth
		},
		[2] = { -- Fire
			[194466] = true, -- Phoenix's Flame
		},
		[3] = { -- Frost
			[214634] = true, -- Ebonbolt
		},
	},
	["MONK"] = {
		[1] = { -- Brewmaster
			[214326] = true, -- Exploding Key
		},
		[2] = { -- Mistweaver
			[205406] = true, -- Sheilun's Gift
		},
		[3] = { -- Windwalker
			[205320] = true, -- Strike of the Windlord
		},
	},
	["PALADIN"] = {
		[1] = { -- Holy
			[200652] = true, -- Tyr's Deliverance
		},
		[2] = { -- Protection
			[209202] = true, -- Eye of Tyr
		},
		[3] = { -- Retribution
			[205273] = true, -- Wake of Ashes 
		},
	},
	["PRIEST"] = {
		[1] = { -- Discipline
			[207946] = true, -- Light's Wrath
		},
		[2] = { -- Holy
			[196684] = true, -- Invoke the Naaru
		},
		[3] = { -- Shadow
			[205065] = true, -- Void Torrent
		},
	},
	["ROGUE"] = {
		[1] = { -- Assassination
			[192759] = true, -- Kingsbane
		},
		[2] = { -- Outlaw
			[202665] = true, -- Curse of the Dreadblades
		},
		[3] = { -- Subtlety
			[209782] = true, -- Goremaw's Bite
		},
	},
	["SHAMAN"] = {
		[1] = { -- Elemental
			[205495] = true, -- Stormkeeper
		},
		[2] = { -- Enhancement
			[204945] = true, -- Doom Winds
		},
		[3] = { -- Restoration
			[207778] = true, -- Gift of the Queen
		},
	},
	["WARLOCK"] = {
		[1] = { -- Affliction
			[216698] = true, -- Reap Souls
		},
		[2] = { -- Demonology
			[211714] = true, -- Thal'kiel's Consumption
		},
		[3] = { -- Destruction
			[196586] = true, -- Dimensional Rift
		},
	},
	["WARRIOR"] = {
		[1] = { -- Arms
			[209577] = true, -- Warbreaker
		},
		[2] = { -- Fury
			[205545] = true, -- Odyn's Fury
		},
		[3] = { -- Protection
			[203524] = true, -- Neltharion's Fury
		},
	},
}
local pvpSpells = {
	["DEATHKNIGHT"] = {
		[1] = { -- Blood
			[214027] = true, -- Adaptation
			[51052] = true,  -- Anti-Magic Zone
			[233411] = true, -- Blood for Blood
			[77606] = true,  -- Dark Simulacrum
			[203173] = true, -- Death Chain
			[208683] = true, -- Gladiator's Medallion
			[207018] = true, -- Murderous Intent
			[47476] = true,  -- Strangulate
		},
		[2] = { -- Frost
			[214027] = true, -- Adaptation
			[51052] = true,  -- Anti-Magic Zone
			[204160] = true, -- Chill Streak
			[77606] = true,  -- Dark Simulacrum
			[208683] = true, -- Gladiator's Medallion
		},
		[3] = { -- Unholy
			[214027] = true, -- Adaptation
			[51052] = true,  -- Anti-Magic Zone
			[77606] = true,  -- Dark Simulacrum
			[208683] = true, -- Gladiator's Medallion
			[223829] = true, -- Necrotic Strike
			[210128] = true, -- Reanimation
		},
	},
	["DEMONHUNTER"] = {
		[1] = { -- Havok
			[214027] = true, -- Adaptation
			[206649] = true, -- Eye of Leotheras
			[206966] = true, -- Fel Lance
			[208683] = true, -- Gladiator's Medallion
			[203704] = true, -- Mana Break
			[235903] = true, -- Mana Rift
			[206803] = true, -- Rain from Above
			[205604] = true, -- Reverse Magic
		},
		[2] = { -- Vengeance
			[214027] = true, -- Adaptation
			[205629] = true, -- Demonic Trample
			[206649] = true, -- Eye of Leotheras
			[208683] = true, -- Gladiator's Medallion
			[205630] = true, -- Illidan's Grasp
			[205604] = true, -- Reverse Magic
			[207029] = true, -- Tormentor
		},
	},
	["DRUID"] = {
		[1] = { -- Balance
			[214027] = true, -- Adaptation
			[209753] = true, -- Cyclone
			[209749] = true, -- Faerie Swarm
			[208683] = true, -- Gladiator's Medallion
		},
		[2] = { -- Feral
			[214027] = true, -- Adaptation
			[236026] = true, -- Enraged Maim
			[208683] = true, -- Gladiator's Medallion
			[203242] = true, -- Rip and Tear
			[236696] = true, -- Thorns
		},
		[3] = { -- Guardian
			[214027] = true, -- Adaptation
			[207017] = true, -- Alpha Challenge
			[201664] = true, -- Demoralizing Roar
			[208683] = true, -- Gladiator's Medallion
			[202246] = true, -- Overrun
		},
		[4] = { -- Restoration
			[214027] = true, -- Adaptation
			[33786] = true,  -- Cyclone
			[208683] = true, -- Gladiator's Medallion
			[203651] = true, -- Overgrowth
			[203727] = true, -- Thorns
		},
	},
	["HUNTER"] = {
		[1] = { -- Beast Mastery
			[214027] = true, -- Adaptation
			[205691] = true, -- Dire Beast: Basilisk
			[208652] = true, -- Dire Beast: Hawk
			[208683] = true, -- Gladiator's Medallion
			[248518] = true, -- Interlope
			[202900] = true, -- Scorpid Sting
			[202914] = true, -- Spider Sting
			[202797] = true, -- Viper Sting
		},
		[2] = { -- Marksmanship
			[214027] = true, -- Adaptation
			[208683] = true, -- Gladiator's Medallion
			[236776] = true, -- Hi-Explosive Trap
			[213691] = true, -- Scatter Shot
			[202900] = true, -- Scorpid Sting
			[203155] = true, -- Sniper Shot
			[202914] = true, -- Spider Sting
			[202797] = true, -- Viper Sting
		},
		[3] = { -- Survival
			[214027] = true, -- Adaptation
			[208683] = true, -- Gladiator's Medallion
			[53271] = true,  -- Master's Call
			[212640] = true, -- Mending Bandage
			[202900] = true, -- Scorpid Sting
			[202914] = true, -- Spider Sting
			[212638] = true, -- Tracker's Net
			[202797] = true, -- Viper Sting
		},
	},
	["MAGE"] = {
		[1] = { -- Arcane
			[214027] = true, -- Adaptation
			[208683] = true, -- Gladiator's Medallion
			[198158] = true, -- Mass Invisibility
			[198111] = true, -- Temporal Shield
		},
		[2] = { -- Fire
			[214027] = true, -- Adaptation
			[208683] = true, -- Gladiator's Medallion
			[203286] = true, -- Greater Pyroblast
			[198111] = true, -- Temporal Shield
		},
		[3] = { -- Frost
			[214027] = true, -- Adaptation
			[208683] = true, -- Gladiator's Medallion
			[198144] = true, -- Ice Form
			[198111] = true, -- Temporal Shield
		},
	},
	["MONK"] = {
		[1] = { -- Brewmaster
			[214027] = true, -- Adaptation
			[207025] = true, -- Admonishment
			[213658] = true, -- Craft: Nimble Brew
			[202335] = true, -- Double Barrel
			[208683] = true, -- Gladiator's Medallion
			[202162] = true, -- Guard
			[202370] = true, -- Mighty Ox Kick
		},
		[2] = { -- Mistweaver
			[214027] = true, -- Adaptation
			[208683] = true, -- Gladiator's Medallion
			[205234] = true, -- Healing Sphere
			[216113] = true, -- Way of the Crane
			[209584] = true, -- Zen Focus Tea
		},
		[3] = { -- Windwalker
			[214027] = true, -- Adaptation
			[201318] = true, -- Fortifying Brew
			[208683] = true, -- Gladiator's Medallion
			[233759] = true, -- Grapple Weapon
			[247483] = true, -- Tigereye Brew
			[201325] = true, -- Zen Moment
		},
	},
	["PALADIN"] = {
		[1] = { -- Holy
			[214027] = true, -- Adaptation
			[216331] = true, -- Avenging Crusader
			[210294] = true, -- Divine Favor
			[208683] = true, -- Gladiator's Medallion
		},
		[2] = { -- Protection
			[214027] = true, -- Adaptation
			[236186] = true, -- Cleansing Light
			[208683] = true, -- Gladiator's Medallion
			[228049] = true, -- Guardian of the Forgotten Queen
			[207028] = true, -- Inquisition
			[215652] = true, -- Shield of Virtue
		},
		[3] = { -- Retribution
			[214027] = true, -- Adaptation
			[210256] = true, -- Blessing of Sanctuary
			[236186] = true, -- Cleansing Light
			[208683] = true, -- Gladiator's Medallion
			[247675] = true, -- Hammer of Reckoning
		},
	},
	["PRIEST"] = {
		[1] = { -- Discipline
			[214027] = true, -- Adaptation
			[197862] = true, -- Archangel
			[197871] = true, -- Dark Archangel
			[208683] = true, -- Gladiator's Medallion
			[211681] = true, -- Power Word: Fortitude
			[209780] = true, -- Premonition
		},
		[2] = { -- Holy
			[214027] = true, -- Adaptation
			[208683] = true, -- Gladiator's Medallion
			[213602] = true, -- Greater Fade
			[213610] = true, -- Holy Ward
			[196762] = true, -- Inner Focus
			[197268] = true, -- Ray of Hope
		},
		[3] = { -- Shadow
			[214027] = true, -- Adaptation
			[208683] = true, -- Gladiator's Medallion
			[211522] = true, -- Psyfiend
			[108968] = true, -- Void Shift
		},
	},
	["ROGUE"] = {
		[1] = { -- Assassination
			[214027] = true, -- Adaptation
			[208683] = true, -- Gladiator's Medallion
			[206328] = true, -- Neurotoxin
			[248744] = true, -- Shiv
		},
		[2] = { -- Outlaw
			[214027] = true, -- Adaptation
			[207777] = true, -- Dismantle
			[208683] = true, -- Gladiator's Medallion
			[198529] = true, -- Plunder Armor
		},
		[3] = { -- Subtlety
			[214027] = true, -- Adaptation
			[213981] = true, -- Cold Blood
			[208683] = true, -- Gladiator's Medallion
			[207736] = true, -- Shadowy Duel
			[212182] = true, -- Smoke Bomb
		},
	},
	["SHAMAN"] = {
		[1] = { -- Elemental
			[214027] = true, -- Adaptation
			[204331] = true, -- Counterstrike Totem
			[208683] = true, -- Gladiator's Medallion
			[204437] = true, -- Lightning Lasso
			[204330] = true, -- Skyfury Totem
			[204332] = true, -- Windfury Totem
		},
		[2] = { -- Enhancement
			[214027] = true, -- Adaptation
			[204331] = true, -- Counterstrike Totem
			[210918] = true, -- Ethereal Form
			[208683] = true, -- Gladiator's Medallion
			[204330] = true, -- Skyfury Totem
			[204366] = true, -- Thundercharge
			[204332] = true, -- Windfury Totem
		},
		[3] = { -- Restoration
			[214027] = true, -- Adaptation
			[204331] = true, -- Counterstrike Totem
			[204288] = true, -- Earth Shield
			[208683] = true, -- Gladiator's Medallion
			[204336] = true, -- Grounding Totem
			[204330] = true, -- Skyfury Totem
			[204293] = true, -- Spirit Link
			[204332] = true, -- Windfury Totem
		},
	},
	["WARRIOR"] = {
		[1] = { -- Arms
			[214027] = true, -- Adaptation
			[236077] = true, -- Disarm
			[236273] = true, -- Duel
			[208683] = true, -- Gladiator's Medallion
			[216890] = true, -- Spell Reflection
			[236320] = true, -- War Banner
			[198817] = true, -- Sharpen Blade
		},
		[2] = { -- Fury
			[214027] = true, -- Adaptation
			[199261] = true, -- Death Wish
			[236077] = true, -- Disarm
			[208683] = true, -- Gladiator's Medallion
			[216890] = true, -- Spell Reflection
		},
		[3] = { -- Protection
			[214027] = true, -- Adaptation
			[213871] = true, -- Bodyguard
			[236236] = true, -- Disarm
			[206572] = true, -- Dragon Charge
			[208683] = true, -- Gladiator's Medallion
			[198912] = true, -- Shield Bash
		},
	},
	["WARLOCK"] = {
		[1] = { -- Affliction
			[214027] = true, -- Adaptation
			[221703] = true, -- Casting Circle
			[199954] = true, -- Curse of Fragility
			[234877] = true, -- Curse of Shadows
			[199890] = true, -- Curse of Tongues
			[199892] = true, -- Curse of Weakness
			[208683] = true, -- Gladiator's Medallion
			[212295] = true, -- Nether Ward
			[212356] = true, -- Soulshatter
		},
		[2] = { -- Demonology
			[214027] = true, -- Adaptation
			[212459] = true, -- Call Fel Lord
			[212619] = true, -- Call Felhunter
			[201996] = true, -- Call Observer
			[221703] = true, -- Casting Circle
			[199954] = true, -- Curse of Fragility
			[199890] = true, -- Curse of Tongues
			[199892] = true, -- Curse of Weakness
			[212295] = true, -- Nether Ward
			[208683] = true, -- Gladiator's Medallion
			[212623] = true, -- Singe Magic
		},
		[3] = { -- Destruction
			[214027] = true, -- Adaptation
			[200546] = true, -- Bane of Havoc
			[221703] = true, -- Casting Circle
			[199954] = true, -- Curse of Fragility
			[199890] = true, -- Curse of Tongues
			[199892] = true, -- Curse of Weakness
			[212295] = true, -- Nether Ward
			[212284] = true, -- Firestone
			[208683] = true, -- Gladiator's Medallion
		},
	},
}

local overloadSpells = {
	["SHAMAN"] = {
		[1] = { -- Elemental
			[45297] = GetSpellInfo(45297),   -- Chain Lightning Overload
			[120588] = GetSpellInfo(120588), -- Elemental Blast Overload
			[77451] = GetSpellInfo(77451),   -- Lava Burst Overload
			[45284] = GetSpellInfo(45284),   -- Lightning Bolt Overload
		},
		[2] = { -- Enhancement
		
		},
		[3] = { -- Restoration
		
		},
	},
}
SCA[1].data.spells.specDetails = specDetails
SCA[1].data.spells.pvp = pvpSpells
SCA[1].data.spells.artifact = artifactSpells
SCA[1].data.spells.overload = overloadSpells

SCA[1].data.spells.onCast = castIDs
SCA[1].data.spells.onSuccess = successIDs
SCA[1].data.spells.onFail = castIDs
SCA[1].data.spells.onDamage = damageSpells
SCA[1].data.spells.onHeal = healSpells

SCA[1].data.spells.spellNames = {}