local SCA, Ace3, LSM = unpack(select(2,...))

local defaults = {
	profile = {
		audio = {
			keys = {
				[0] = "all",
				[1] = "spells",
				[2] = "defense",
				[3] = "combat",
				[4] = "loot",
				[5] = "chat",
				[6] = "move",
			},
			spells = {
				label = "Spells",
				order = 1,
				damage = {
					enabled = true,
					tutorial = {
						enabled = false,
						frameCount = 0,
						flags = {
							isSeparate = false,
							spellEvent = false,
							source = false,
							spellEvents = false,
							customType = false,
							numFiles = false,
							audioLocationPack = false,
							audioLocationFile = false,
						},
						ofs = {
							spellEvents = {
								x = 340,
								y = -126,
							},
							source = {
								x = 248,
								y = -221,
							},
							isSeparate = {
								x = 750,
								y = -270,
							},
							spellEvent = {
								x = 500,
								y = -335,
							},
							customType = {
								x = 245,
								y = -270,
							},
							audioLocationPack = {
								x = 355,
								y = -340,
							},
							audioLocationFile = {
								x = 355,
								y = -340,
							},
							numFiles = {
								x = 680,
								y = -340,
							},
						},
						ids = {},
					},
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Damage",
						tabName = 'DamageTab',
						errorName = "damage",
						selectTitle = "Spell Events",
						width = "half",
					},
					keys = {
						[0] = "all",
						[1] = "onCast",
						[2] = "onSuccess",
						[3] = "onFail",
						[4] = "onDamage",
					},
					events = {
						onCast = false,
						onSuccess = false,
						onFail = false,
						onDamage = false,
					},
					messages = {
						separateSounds = '',
						notices = '',
					},
					all = {
						label = "All Spells Events",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							trigger = "crit",
							swing = true,
							pet = true,
							dots = true,
							spells = true,
							threshold = 0,
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onCast = {
						label = "Start",
						desc = "you begin to cast a damage spell.\n\n|cFFFF6C6COnly applies to spells that have a cast time.|r",
						order = 1,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onSuccess = {
						label = "Success",
						desc = "a damage spell you casted, or an ability you used, successfully casts.",
						order = 2,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onFail = {
						label = "Failed",
						desc = "a damage spell you began to cast fails to cast.\n\n|cFFFF6C6COccurs when you, or an enemy, interrupts your cast.|r",
						order = 3,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onDamage = {
						label = "Damage",
						desc = "a spell you casted, or an ability you used, causes damage to another unit.",
						order = 4,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							trigger = "crit",
							swing = true,
							pet = true,
							dots = true,
							spells = true,
							threshold = 0,
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				heals = {
					enabled = true,
					tutorial = {
						enabled = false,
						frameCount = 0,
						flags = {
							isSeparate = false,
							spellEvent = false,
							source = false,
							spellEvents = false,
							customType = false,
							numFiles = false,
							audioLocationPack = false,
							audioLocationFile = false,
						},
						ofs = {
							spellEvents = {
								x = 340,
								y = -126,
							},
							source = {
								x = 248,
								y = -221,
							},
							isSeparate = {
								x = 750,
								y = -270,
							},
							spellEvent = {
								x = 500,
								y = -335,
							},
							customType = {
								x = 245,
								y = -270,
							},
							audioLocationPack = {
								x = 355,
								y = -340,
							},
							audioLocationFile = {
								x = 355,
								y = -340,
							},
							numFiles = {
								x = 680,
								y = -340,
							},
						},
						ids = {},
					},
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Healing",
						tabName = 'HealingTab',
						errorName = "healing",
						selectTitle = "Spell Event",
						width = "half",
					},
					keys = {
						[0] = "all",
						[1] = "onCast",
						[2] = "onSuccess",
						[3] = "onFail",
						[4] = "onHeal",
					},
					events = {
						onCast = false,
						onSuccess = false,
						onFail = false,
						onHeal = false,
					},
					messages = {
						separateSounds = '',
						notices = '',
					},
					all = {
						label = "All Spell Events",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							trigger = "crit",
							hots = true,
							spells = true,
							threshold = 0,
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onCast = {
						label = "Start",
						desc = "you begin to cast a healing spell.\n\n|cFFFF6C6COnly applies to spells that have a cast time.|r",
						order = 1,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onSuccess = {
						label = "Success",
						desc = "a healing spell you casted, or an ability you used, successfully casts.",
						order = 2,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onFail = {
						label = "Failed",
						desc = "a healing spell you began to cast fails to cast.\n\n|cFFFF6C6COccurs when you, or an enemy, interrupts your cast.|r",
						order = 3,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onHeal = {
						label = "Healing",
						desc = "a healing spell, that you casted, heals yourself or another unit.",
						order = 4,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							trigger = "crit",
							hots = true,
							spells = true,
							threshold = 0,
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				specific = {
					enabled = true,
					--[[ Separate Sounds Template
					[51505] = {
						onCast = {
							options = {
								source = "packs",
								channel = "Master",
							},
							packs = {
							
							},
							shared = {
							
							},
							custom = {
							
							},
						},
						onDamage = {
							options = {
								trigger = "crit",
								threshold = 0,
								source = "packs",
								channel = "Master",
							},
						},
						onHeal = {
							options = {
								trigger = "crit",
								threshold = 0,
								source = "packs",
								channel = "Master",
							},
						},
						
						
					},
					-- Non-Separate Sounds Template
					[51505] = {
						options = {
							source = "packs",
							channel = "Master",
						},
						onCast = {
							
						},
						onDamage = {
						
						},
						onHeal = {
						
						},
					},
					]]
				},
				ignored = {

				},
			},
			defense = {
				order = 2,
				enabled = true,
				numEvents = 0,
				selected = 0,
				isSeparate = false,
				info = {
					label = "Defense",
					tabName = nil,
					errorName = "defense",
					selectTitle = "Defense Event",
					width = "half",
				},
				keys = {
					[0] = "all",
					[1] = "absorb",
					[2] = "block",
					[3] = "dodge",
					[4] = "parry",
				},
				events = {
					absorb = true,
					block = true,
					dodge = true,
					parry = true,
				},
				all = {
					label = "All Defense Events",
					validAudio = false,
					options = {
						source = "packs",
						channel = "Master",
					},
					packs = {
						text = '',
						value = 'empty',
						path = '',
						max = 1,
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
					shared = {
						value = 'None',
					},
					custom = {
						path = "Interface\\AUDIO\\",
						max = 1,
						customType = 'file',
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
				},
				absorb = {
					label = "Absorb",
					desc = "the damage of an incoming spell/ability is absorbed.",
					validAudio = false,
					order = 1,
					options = {
						source = "packs",
						channel = "Master",
					},
					packs = {
						text = '',
						value = 'empty',
						path = '',
						max = 1,
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
					shared = {
						value = 'None',
					},
					custom = {
						path = "Interface\\AUDIO\\",
						max = 1,
						customType = 'file',
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
				},
				block = {
					label = "Block",
					desc = "damage is blocked.",
					validAudio = false,
					order = 2,
					options = {
						source = "packs",
						channel = "Master",
					},
					packs = {
						text = '',
						value = 'empty',
						path = '',
						max = 1,
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
					shared = {
						value = 'None',
					},
					custom = {
						path = "Interface\\AUDIO\\",
						max = 1,
						customType = 'file',
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
				},
				dodge = {
					label = "Dodge",
					desc = "a spell/ability is dodged.",
					validAudio = false,
					order = 3,
					options = {
						source = "packs",
						channel = "Master",
					},
					packs = {
						text = '',
						value = 'empty',
						path = '',
						max = 1,
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
					shared = {
						value = 'None',
					},
					custom = {
						path = "Interface\\AUDIO\\",
						max = 1,
						customType = 'file',
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
				},
				parry = {
					label = "Parry",
					desc = "a spell/ability is parried.",
					validAudio = false,
					order = 4,
					options = {
						source = "packs",
						channel = "Master",
					},
					packs = {
						text = '',
						value = 'empty',
						path = '',
						max = 1,
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
					shared = {
						value = 'None',
					},
					custom = {
						path = "Interface\\AUDIO\\",
						max = 1,
						customType = 'file',
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
				},
			},
			combat = {
				enabled = true,
				label = "Combat",
				order = 3,
				status = {
					enabled = true,
					order = 1,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					playSong = false,
					info = {
						label = "Combat Start/End",
						tabName = 'statusTab',
						errorName = "status",
						selectTitle = "Combat Event",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "onStart",
						[2] = "onStop",
					},
					events = {
						onStart = true,
						onStop = true,
					},
					options = {
						zoneTrigger = 0,
						dungeonTrigger = 0,
						raidTrigger = 0,
					},
					holder = {},
					all = {
						label = "Combat Start and End",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStart = {
						label = "Combat Starts",
						desc = "combat begins",
						validAudio = false,
						order = 1,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							music = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStop = {
						label = "Combat Ends",
						desc = "you are no longer in combat.",
						validAudio = false,
						order = 2,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				events = {
					enabled = true,
					order = 2,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Combat Events",
						tabName = 'eventsTab',
						errorName = "events",
						selectTitle = "Combat Events",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "onKill",
						[2] = "onDeath",
						[3] = "onEnvironment",
						[4] = "onInterrupt",
					},
					events = {
						onKill = true,
						onDeath = true,
						onEnvironment = true,
						onInterrupt = true,
					},
					all = {
						label = "All Combat Events",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onKill = {
						label = "Killing Blow",
						desc = "you get a killing blow",
						validAudio = false,
						order = 1,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onDeath = {
						label = "Upon Death",
						desc = "you die",
						validAudio = false,
						order = 2,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onEnvironment = {
						label = "Enviro Damage",
						desc = "you take environmental damage.\n\nEXAMPLE: Taking fall damage",
						validAudio = false,
						order = 3,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onInterrupt = {
						label = "Interrupt",
						desc = "you successfully interrupt an enemy unit's spell cast",
						validAudio = false,
						order = 4,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
			},
			looting = {
				enabled = true,
				label = "Looting",
				order = 4,
				loot = {
					enabled = true,
					order = 1,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Item Looting",
						tabName = 'lootTab',
						errorName = 'loot',
						selectTitle = "Item Quality/Type",
						width = "half",
					},
					keys = {
						[0] = "all",
						[1] = "poor",
						[2] = "common",
						[3] = "uncommon",
						[4] = "rare",
						[5] = "epic",
						[6] = "legendary",
						[7] = "mount",
						[8] = "pet",
					},
					events = {
						poor = true,
						common = true,
						uncommon = true,
						rare = true,
						epic = true,
						legendary = true,
						mount = true,
						pet = true,
					},
					all = {
						label = "All Loot Qualities/Types",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					poor = {
						label = "|cFF9D9D9DPoor|r",
						desc = "you loot a |cFF9D9D9DPoor|r-quality item",
						order = 1,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					common = {
						label = "|cFFFFFFFFCommon|r",
						desc = "you loot a |cFFFFFFFFCommon|r-quality item",
						order = 2,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					uncommon = {
						label = "|cFF1EFF00Uncommon|r",
						desc = "you loot an |cFF1EFF00Uncommon|r-quality item",
						order = 3,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					rare = {
						label = "|cFF0070DDRare|r",
						desc = "you loot a |cFF0070DDRare|r-quality item",
						order = 4,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					epic = {
						label = "|cFFA335EEEpic|r",
						desc = "you loot an |cFFA335EEEpic|r-quality item",
						order = 5,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					legendary = {
						label = "|cFFFF8000Legendary|r",
						desc = "you loot a |cFFFF8000Legendary|r-quality item",
						order = 6,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					mount = {
						label = "|cFF00CCFFMount|r",
						desc = "you loot a mount",
						order = 7,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					pet = {
						label = "|cFF00CCFFPet|r",
						desc = "you loot a pet",
						order = 8,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				window = {
					enabled = true,
					order = 2,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Loot Window",
						errorName = 'window',
						tabName = 'windowTab',
						selectTitle = "Loot Event",
						width = "normal",
					},
					keys = {
						[0] = 'all',
						[1] = 'opened',
						[2] = 'closed',
					},
					events = {
						opened = true,
						closed = true,
					},
					all = {
						label = "All Loot Window Events",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					opened = {
						label = "Open",
						desc = "a loot window is opened.",
						validAudio = false,
						order = 1,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					closed = {
						label = "On Close",
						desc = "a loot window is closed",
						validAudio = false,
						order = 2,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				rolling = {
					enabled = true,
					order = 3,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Loot Rolling",
						tabName = 'rollingTab',
						errorName = 'rolling',
						selectTitle = "Roll Event",
						width = "normal",
					},
					keys = {
						[0] = 'all',
						[1] = 'need',
						[2] = 'greed',
						[3] = 'disenchant',
					},
					events = {
						need = true,
						greed = true,
						disenchant = true,
					},
					all = {
						label = "All Loot Rolling Events",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					need = {
						label = "Need",
						desc = "you roll \"Need\" on an item",
						validAudio = false,
						order = 1,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					greed = {
						label = "Greed",
						desc = "you roll \"Greed\" on an item",
						validAudio = false,
						order = 2,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					disenchant = {
						label = "Disenchant",
						desc = "you roll \"Disenchant\" on an item",
						validAudio = false,
						order = 3,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
			},
			chat = {
				enabled = true,
				label = "Chat",
				order = 5,
				guild = {
					enabled = true,
					order = 1,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Guild",
						tabName = "guildTab",
						errorName = 'guild',
						selectTitle = "Chat Channels",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "guild",
						[2] = "officer",
					},
					events = {
						guild = true,
						officer = true,
					},
					all = {
						label = "All Guild Chat Types",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					guild = {
						label = "Guild Chat",
						desc = "a message in the guild chat appears.",
						order = 1,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					officer = {
						label = "Officer",
						desc = "a message in the guild officer chat appears.",
						order = 2,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				group = {
					enabled = true,
					order = 2,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Group",
						tabName = 'groupTab',
						errorName = 'group',
						selectTitle = "Chat Channels",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "party",
						[2] = "raid",
						[3] = "instance",
						[4] = "battleground",
					},
					events = {
						party = true,
						raid = true,
						instance = true,
						battleground = true,
					},
					all = {
						label = "All Group Chat Types",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					party = {
						label = "Party Chat",
						desc = "a message in the party chat appears.",
						order = 1,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					raid = {
						label = "Raid Chat",
						desc = "a message in the raid chat appears.",
						validAudio = false,
						order = 2,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					instance = {
						label = "Instance Chat",
						desc = "a message in the instance chat appears.",
						order = 3,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					battleground = {
						label = "Battleground Chat",
						desc = "a message in the battleground chat appears.",
						order = 4,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				global = {
					enabled = true,
					order = 3,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Global",
						tabName = 'globalTab',
						errorName = 'global',
						selectTitle = "Chat Channels",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "general",
						[2] = "trade",
						[3] = "localdefense",
						[4] = "lookingforgroup",
					},
					events = {
						general = true,
						trade = true,
						localdefense = true,
						lookingforgroup = true,
					},
					all = {
						label = "All Global Chat Types",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					general = {
						label = "General Chat",
						desc = "a message in the general chat appears.",
						order = 1,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					trade = {
						label = "Trade Chat",
						desc = "a message in the trade chat appears.",
						order = 2,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					localdefense = {
						label = "Local Defense",
						desc = "a message in the local defense chat appears.",
						order = 3,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					lookingforgroup = {
						label = "Looking For Group",
						desc = "a message in the looking for group chat appears.",
						order = 4,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				nearby = {
					enabled = true,
					order = 4,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Local",
						tabName = 'nearbyTab',
						errorName = 'local',
						selectTitle = "Chat Channels",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "say",
						[2] = "yell",
						[3] = "emote",
					},
					events = {
						say = true,
						yell = true,
						emote = true,
					},
					all = {
						label = "All Local Chat Types",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					say = {
						label = "Say",
						desc = "a message in the said nearby.",
						order = 1,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					yell = {
						label = "Yell",
						desc = "a message in the yelled nearby.",
						order = 2,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					emote = {
						label = "Emote",
						desc = "a player emotes nearby.",
						order = 3,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				--[[custom = {
					enabled = true,
					order = 5,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Custom",
						tabName = "customTab",
						errorName = "custom",
						selectTitle = "Chat Channels",
						width = "half",
					},
					keys = {
						[0] = "all",
					},
					events = {},
					all = {
						label = "All Custom Chat Types",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					say = {
						label = "Say",
						desc = "a message in the said nearby.",
						order = 1,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					yell = {
						label = "Yell",
						desc = "a message in the yelled nearby.",
						order = 2,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					emote = {
						label = "Emote",
						desc = "a player emotes nearby.",
						order = 3,
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
							ignoreMe = false,
							timeout = {
								enabled = false,
								delay = 0,
								sinceLast = 0,
							},
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},]]
			},
			move = {
				enabled = true,
				label = "Movement",
				order = 6,
				ascend = {
					enabled = false,
					order = 1,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Jump / Ascend",
						tabName = 'ascendTab',
						errorName = "ascend",
						selectTitle = "Move Actions",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "onStart",
						[2] = "onStop",
					},
					events = {
						onStart = true,
						onStop = true,
					},
					triggers = {
						running = true,
						mounted = true,
						swimming = true,
						flying = true,
					},
					messages = {
						separateSounds = '',
						notices = '',
					},
					all = {
						label = "Ascend Start & Stop",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStart = {
						validAudio = false,
						desc = "you either jump or begin to ascend.",
						order = 1,
						label = "Start",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStop = {
						validAudio = false,
						desc = "you stop ascending.\n\n|cFFFF6C6CDoes not apply to jumping.|r",
						order = 2,
						label = "Stop",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				descend = {
					enabled = false,
					order = 2,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Sit / Descend",
						tabName = 'descendTab',
						errorName = "descend",
						selectTitle = "Move Actions",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "onStart",
						[2] = "onStop",
					},
					events = {
						onStart = false,
						onStop = false,
					},
					triggers = {
						running = true,
						mounted = true,
						swimming = true,
						flying = true,
					},
					messages = {
						separateSounds = '',
						notices = '',
					},
					all = {
						label = "Descend Start & Stop",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStart = {
						validAudio = false,
						order = 1,
						label = "Start",
						desc = "you either sit or begin to descend.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStop = {
						validAudio = false,
						order = 2,
						label = "Stop",
						desc = "you stop descending.\n\n|cFFFF6C6CDoes not apply to sitting.|r",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				forward = {
					enabled = false,
					order = 3,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Forward",
						tabName = 'forwardTab',
						errorName = "forward",
						selectTitle = "Move Actions",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "onStart",
						[2] = "onStop",
					},
					events = {
						onStart = false,
						onStop = false,
					},
					triggers = {
						running = true,
						mounted = true,
						swimming = true,
						flying = true,
					},
					messages = {
						separateSounds = '',
						notices = '',
					},
					all = {
						label = "Forward Start & Stop",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStart = {
						validAudio = false,
						order = 1,
						label = "Start",
						desc = "you begin to move forward.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStop = {
						validAudio = false,
						order = 2,
						label = "Stop",
						desc = "you stop moving forward.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				backward = {
					enabled = false,
					order = 4,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Backward",
						tabName = 'backwardTab',
						errorName = "backward",
						selectTitle = "Move Actions",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "onStart",
						[2] = "onStop",
					},
					events = {
						onStart = false,
						onStop = false,
					},
					triggers = {
						running = true,
						mounted = true,
						swimming = true,
						flying = true,
					},
					messages = {
						separateSounds = '',
						notices = '',
					},
					all = {
						label = "Backward Start & Stop",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStart = {
						validAudio = false,
						order = 1,
						label = "Start",
						desc = "you begin to move backward.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStop = {
						validAudio = false,
						order = 2,
						label = "Stop",
						desc = "you stop moving backwards.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				turnleft = {
					enabled = false,
					order = 5,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Turn Left",
						tabName = 'turnleftTab',
						errorName = "turnleft",
						selectTitle = "Move Actions",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "onStart",
						[2] = "onStop",
					},
					events = {
						onStart = false,
						onStop = false,
					},
					triggers = {
						running = true,
						mounted = true,
						swimming = true,
						flying = true,
					},
					messages = {
						separateSounds = '',
						notices = '',
					},
					all = {
						label = "Left Turn Start & Stop",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStart = {
						validAudio = false,
						order = 1,
						label = "Start",
						desc = "you start turning left.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStop = {
						validAudio = false,
						order = 2,
						label = "Stop",
						desc = "you stop turning left.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				turnright = {
					enabled = false,
					order = 6,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Turn Right",
						tabName = 'turnrightTab',
						errorName = "turnright",
						selectTitle = "Move Actions",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "onStart",
						[2] = "onStop",
					},
					events = {
						onStart = false,
						onStop = false,
					},
					triggers = {
						running = true,
						mounted = true,
						swimming = true,
						flying = true,
					},
					messages = {
						separateSounds = '',
						notices = '',
					},
					all = {
						label = "Turn Right Start & Stop",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStart = {
						validAudio = false,
						order = 1,
						label = "Start",
						desc = "you start turning right.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStop = {
						validAudio = false,
						order = 2,
						label = "Stop",
						desc = "you stop turning right.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				pitchup = {
					enabled = false,
					order = 7,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Pitch Up",
						tabName = 'pitchupTab',
						errorName = "pitchup",
						selectTitle = "Move Actions",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "onStart",
						[2] = "onStop",
					},
					events = {
						onStart = false,
						onStop = false,
					},
					messages = {
						separateSounds = '',
						notices = '',
					},
					all = {
						label = "Pitch Up Start & Stop",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStart = {
						validAudio = false,
						order = 1,
						label = "Start",
						desc = "you start to pitch up while on your flying mount.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStop = {
						validAudio = false,
						order = 2,
						label = "Stop",
						desc = "you stop pitching up while on your flying mount.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				pitchdown = {
					enabled = false,
					order = 8,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Pitch Down",
						tabName = 'pitchdownTab',
						errorName = "pitchdown",
						selectTitle = "Move Actions",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "onStart",
						[2] = "onStop",
					},
					events = {
						onStart = false,
						onStop = false,
					},
					messages = {
						separateSounds = '',
						notices = '',
					},
					all = {
						label = "Pitch Down Start & Stop",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStart = {
						validAudio = false,
						order = 1,
						label = "Start",
						desc = "you start to pitch down while on your flying mount.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStop = {
						validAudio = false,
						order = 2,
						label = "Stop",
						desc = "you stop pitching down while on your flying mount.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				autorun = {
					enabled = false,
					order = 9,
					numEvents = 0,
					selected = 0,
					isSeparate = false,
					info = {
						label = "Autorun",
						tabName = 'autorunTab',
						errorName = "autorun",
						selectTitle = "Move Actions",
						width = "normal",
					},
					keys = {
						[0] = "all",
						[1] = "onStart",
						[2] = "onStop",
					},
					events = {
						onStart = false,
						onStop = false,
					},
					messages = {
						separateSounds = '',
						notices = '',
					},
					all = {
						label = "Autorun Start & Stop",
						validAudio = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStart = {
						validAudio = false,
						order = 1,
						label = "Start",
						desc = "you start to autorun.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
					onStop = {
						validAudio = false,
						order = 2,
						label = "Stop",
						desc = "you stop autorunning.",
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = "Interface\\AUDIO\\",
							max = 1,
							customType = 'file',
							isRandom = {
								enabled = true,
								currentFile = 1,
							},
						},
					},
				},
				--[[interact = {
					label = "Interact",
					order = 10,
					selectedAction = "info",
					info = {
						enabled = false,
						options = {
							source = "packs",
							channel = "Master",
						},
						packs = {
							text = '',
							value = 'empty',
							path = '',
							max = 1,
						},
						shared = {
							value = 'None',
						},
						custom = {
							path = '',
							max = 1,
							customType = 'file',
						},
					},
				},]]
			},
		},
	},
	char = {
		chat = {
			enabled = true,
			order = 5,
			numEvents = 0,
			selected = 0,
			isSeparate = false,
			isNewChannelAdded = false,
			info = {
				label = "Custom",
				tabName = 'customTab',
				errorName = 'custom',
				selectTitle = "Chat Channels",
				width = "normal",
			},
			keys = {
				[0] = "all",
			},
			events = {},
			all = {
				label = "All Custom Channels",
				validAudio = false,
				options = {
					source = "packs",
					channel = "Master",
					ignoreMe = false,
					timeout = {
						enabled = false,
						delay = 0,
						sinceLast = 0,
					},
				},
				packs = {
					text = '',
					value = 'empty',
					path = '',
					max = 1,
					isRandom = {
						enabled = true,
						currentFile = 1,
					},
				},
				shared = {
					value = 'None',
				},
				custom = {
					path = "Interface\\AUDIO\\",
					max = 1,
					customType = 'file',
					isRandom = {
						enabled = true,
						currentFile = 1,
					},
				},
			},
		},
	},
}

SCA.defaults = defaults