-- *********************************************************
-- **           Sweetsour's Custom Audio - Core           **
-- **            http://sweetsour.live/discord            **
-- **          https://www.patreon.com/sweetsour          **
-- *********************************************************
--
-- This addon is written and copyrighted by:
--    • Mike Thornton (Sweetsour @ US-Firetree)
--
--
-- Special thanks to:
--    • /r/wow
--    • My guild, "Star Stack On Star"
--
--
-- The code of this addon is licensed under a Creative Commons Attribution-Noncommercial-Share Alike 3.0 License. (see license.txt)
-- All included textures and sounds are copyrighted by their respective owners, license information for these media files can be found in the modules that make use of them.
--
--
--  You are free:
--    • to Share - to copy, distribute, display, and perform the work
--    • to Remix - to make derivative works
--  Under the following conditions:
--    • Attribution. You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work). (A link to https://www.patreon.com/sweetsour is sufficient)
--    • Noncommercial. You may not use this work for commercial purposes.
--    • Share Alike. If you alter, transform, or build upon this work, you may distribute the resulting work only under the same or similar license to this one.
--

--[[---------------------------------------
	VARIABLE CACHING
-----------------------------------------]]

-- Lua Functions
local random = math.random
local pairs, print, select, tonumber, tostring, type = pairs, print, select, tonumber, tostring, type
local find, lower, sub = string.find, string.lower, string.sub
-- WoW API Functions / Variables
local CreateFrame = CreateFrame
local GetAddOnEnableState, GetAddOnInfo, GetAddOnMetadata, LoadAddOn = GetAddOnEnableState, GetAddOnInfo, GetAddOnMetadata, LoadAddOn
local GetCVar, SetCVar = GetCVar, SetCVar
local GetLootInfo, GetNumLootItems = GetLootInfo, GetNumLootItems
local GetSpellInfo = GetSpellInfo
local GetSpecialization = GetSpecialization
local GetRealmName = GetRealmName
local hooksecurefunc = hooksecurefunc
local InterfaceOptionsFrame, InterfaceOptionsFrameAddOns = InterfaceOptionsFrame, InterfaceOptionsFrameAddOns
local IsFlying, IsMounted, IsSwimming = IsFlying, IsMounted, IsSwimming
local PlayMusic, PlaySoundFile, StopMusic = PlayMusic, PlaySoundFile, StopMusic
local UnitAffectingCombat, UnitClass, UnitExists, UnitIsDead, UnitIsEnemy, UnitGUID, UnitName = UnitAffectingCombat, UnitClass, UnitExists, UnitIsDead, UnitIsEnemy, UnitGUID, UnitName
local DEFAULT_CHAT_FRAME = DEFAULT_CHAT_FRAME


local FOLDER_NAME, Engine = ...

local LOOT_QUALITY_VALUE = {
	[0] = "Poor",
	[1] = "Common",
	[2] = "Uncommon",
	[3] = "Rare",
	[4] = "Epic",
	[5] = "Legendary",
}


local SCA = {}
SCA.data = {
	dungeons = {},
	raids = {},
	spells = {},
	zones = {},
}
SCA.library = {}
SCA.temp = {
	IsInterfaceOpen = false,
	selectedMenuItem = 0,
	isShiftDown = false,
	GUIDs = {},
	errors = {},
	backup = {
		data = '',
		isRetrieved = false,
		selected = 0,
	},
	profile = {
		name = '',
	},
	restore = {
		data = '',
		isReady = false,
	},
	isMapLoaded = false,
	music = {
		defaultMusicSetting = '',
		isSongPlaying = false,
		holder = {},
	},
	loot = {
		numItemsLooted = 0,
		totalItems = 0,
		lootInfo = {},
	},
	move = {
		isAutoRunning = false,
		isMoving = false,
		direction = '',
	},
	newIgnore = {
		isValidSpell = false,
		validSpell = '',
		errorName = "ignored",
	},
	addSound = false,
	newSound = {
		tutorial = {
			frameCount = 0,
			enabled = false,
			timeout = 0,
			flags = {
				isSeparate = false,
				spellEvent = false,
				source = false,
				spellEvents = false,
				customType = false,
				numFiles = false,
				audioLocationPack = false,
				audioLocationFile = false,
			},
			ofs = {
				spellEvents = {
					x = 338,
					y = -172,
				},
				source = {
					x = 250,
					y = -265,
				},
				isSeparate = {
					x = 750,
					y = -316,
				},
				spellEvent = {
					x = 500,
					y = -372,
				},
				customType = {
					x = 245,
					y = -316,
				},
				audioLocationPack = {
					x = 355,
					y = -375,
				},
				audioLocationFile = {
					x = 355,
					y = -375,
				},
				numFiles = {
					x = 680,
					y = -375,
				},
			},
			ids = {}
		},
		--validAudio = false,
		errorName = 'newSound',
		toggleInfo = {
			desc = {
				[1] = "the following spell event occurs: ",
				[2] = '|r.'
			},
			width = "half",
		},
		validSpell = false,
		numEvents = 0,
		selected = 0,
		isSeparate = false,
		isError = false,
		keys = {
			[0] = "all",
			[1] = "onCast",
			[2] = "onSuccess",
			[3] = "onFail",
			[4] = "onDamage",
			[5] = "onHeal",
		},
		events = {
			onCast = false,
			onSuccess = false,
			onFail = false,
			onDamage = true,
			onHeal = true,
		},
		messages = {
			separateSounds = '',
			notices = '',
		},
		all = {
			validAudio = false,
			label = "All Events",
			options = {
				source = "packs",
				channel = "Master",
				trigger = "crit",
				threshold = 0,
			},
			packs = {
				text = '',
				value = 'empty',
				path = '',
				max = 1,
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
			shared = {
				value = 'None',
			},
			custom = {
				path = "Interface\\AUDIO\\",
				max = 1,
				customType = 'file',
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
		},
		onCast = {
			label = "Start",
			desc = "you begin to cast a spell.\n\n|cFFFF5025Only applies to spells that have a cast time.|r",
			order = 1,
			validAudio = false,
			options = {
				source = "packs",
				channel = "Master",
			},
			packs = {
				value = 'empty',
				text = '',
				path = '',
				max = 1,
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
			shared = {
				value = 'None',
			},
			custom = {
				path = "Interface\\AUDIO\\",
				max = 1,
				customType = 'file',
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
		},
		onSuccess = {
			label = "Success",
			desc = "a spell you casted, or an ability you used, successfully casts.",
			order = 2,
			validAudio = false,
			options = {
				source = "packs",
				channel = "Master",
			},
			packs = {
				value = 'empty',
				text = '',
				path = '',
				max = 1,
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
			shared = {
				value = 'None',
			},
			custom = {
				path = "Interface\\AUDIO\\",
				max = 1,
				customType = 'file',
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
		},
		onFail = {
			label = "Failed",
			desc = "a spell you began to cast fails to cast.\n\n|cFFFF5025Occurs when you, or an enemy, interrupts your cast.|r",
			order = 3,
			validAudio = false,
			options = {
				source = "packs",
				channel = "Master",
			},
			packs = {
				value = 'empty',
				text = '',
				path = '',
				max = 1,
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
			shared = {
				value = 'None',
			},
			custom = {
				path = "Interface\\AUDIO\\",
				max = 1,
				customType = 'file',
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
		},
		onDamage = {
			label = "Damage",
			desc = "a spell you casted, or an ability you used, causes damage to another unit.",
			order = 4,
			validAudio = false,
			options = {
				source = "packs",
				channel = "Master",
				trigger = "crit",
				threshold = 0,
			},
			packs = {
				value = 'empty',
				text = '',
				path = '',
				max = 1,
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
			shared = {
				value = 'None',
			},
			custom = {
				path = "Interface\\AUDIO\\",
				max = 1,
				customType = 'file',
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
		},
		onHeal = {
			label = "Healing",
			desc = "a healing spell, that you casted, heals yourself or another unit.",
			order = 5,
			validAudio = false,
			options = {
				source = "packs",
				channel = "Master",
				trigger = "crit",
				threshold = 0,
			},
			packs = {
				value = 'empty',
				text = '',
				path = '',
				max = 1,
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
			shared = {
				value = 'None',
			},
			custom = {
				path = "Interface\\AUDIO\\",
				max = 1,
				customType = 'file',
				isRandom = {
					enabled = true,
					currentFile = 1,
				},
			},
		},
	},
}
local Ace3 = LibStub('AceAddon-3.0'):NewAddon("CustomAudio", 'AceConsole-3.0','AceEvent-3.0');
Ace3.version = GetAddOnMetadata("CustomAudio", 'Version')
local LSM = LibStub('LibSharedMedia-3.0')
local GUI = LibStub("AceGUI-3.0")

Engine[1] = SCA
Engine[2] = Ace3
Engine[3] = LSM

------------------------------
--- For Debugging Purposes ---
------------------------------
local BackdropSB = {
	bgFile   = [[Interface\Tooltips\UI-Tooltip-Background]],
	edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
	tile = true,
	tileSize = 16,
	edgeSize = 10
}
SCA.BackdropSB = BackdropSB

local frame = CreateFrame("frame")

local DataFrame = CreateFrame('Frame',nil,UIParent)
DataFrame:SetWidth(700)
DataFrame:SetHeight(300)
DataFrame:SetPoint('TOPLEFT',UIParent,'TOPLEFT',100,-100)
DataFrame:SetBackdrop(BackdropSB)
DataFrame:SetBackdropColor(0.15,0.15,0.15,0.9)
DataFrame:SetBackdropBorderColor(1,1,1,1)
DataFrame:Hide()

DataFrame.text = DataFrame:CreateFontString(nil, 'MEDIUM', 'GameFontHighlightLarge')
DataFrame.text:SetPoint('TOPLEFT',11,-5);
DataFrame.text:SetTextColor(1,1,1,1)
DataFrame.text:SetJustifyH('LEFT')
DataFrame.text:SetFont("Fonts\\FRIZQT__.TTF", 8)

SCA.DataFrame = DataFrame
_G['SCA_DataFrame'] = DataFrame

local function CurText(name)
	return SCA[name].text:GetText() or ''
end

function Ace3:NavigateInterfaceOptions(index,isClick)
	local listIndex

	InterfaceOptionsFrame:Show()
	if (not isClick) then
		InterfaceOptionsFrameTab2:Click()
	end

	for i=2,InterfaceOptionsFrameAddOns:GetNumChildren() do
		if (select(i,InterfaceOptionsFrameAddOns:GetChildren()):GetText() == "CustomAudio") then
			listIndex = i
			listObject = select(i,InterfaceOptionsFrameAddOns:GetChildren())

			if (select((i+1),InterfaceOptionsFrameAddOns:GetChildren()):GetText() ~= "Crit Sounds") then
				if (not isClick) then
					select(1,listObject:GetChildren()):Click()
				end
			end
			break
		end
	end
	
	SCA.temp.IsInterfaceOpen = true
	
	select(listIndex+index,InterfaceOptionsFrameAddOns:GetChildren()):Click()
end

SLASH_SCA1 = "/sca"
SlashCmdList["SCA"] = function(input)
	if (UnitAffectingCombat('player')) then
		DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF77Sweetsour\'s Custom Audio|r: |cFFFF7777You cannot access options while in combat.")
	else
		if not input or input:trim() == "" then
			Ace3:NavigateInterfaceOptions(0,SCA.temp.IsInterfaceOpen)
		elseif input == "quick" then
			Ace3:NavigateInterfaceOptions(1,SCA.temp.IsInterfaceOpen)
		elseif input == "spells" then
			Ace3:NavigateInterfaceOptions(2,SCA.temp.IsInterfaceOpen)
		elseif input == "def" or input == "defense" then
			Ace3:NavigateInterfaceOptions(3,SCA.temp.IsInterfaceOpen)
		elseif input == "combat" then
			Ace3:NavigateInterfaceOptions(4,SCA.temp.IsInterfaceOpen)
		elseif input == "loot" then
			Ace3:NavigateInterfaceOptions(5,SCA.temp.IsInterfaceOpen)
		elseif input == "chat" then
			Ace3:NavigateInterfaceOptions(6,SCA.temp.IsInterfaceOpen)
		elseif input == "move" then
			Ace3:NavigateInterfaceOptions(7,SCA.temp.IsInterfaceOpen)
		elseif input == "backup" or input == "restore" then
			Ace3:NavigateInterfaceOptions(8,SCA.temp.IsInterfaceOpen)
		elseif input == "profile" or input == "profiles" then
			Ace3:NavigateInterfaceOptions(9,SCA.temp.IsInterfaceOpen)
		elseif input == "version" then
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF77Sweetsour\'s Custom Audio|r: |cFF9999FF"..GetAddOnMetadata(FOLDER_NAME,"Version").."|r")
		else
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFF77Sweetsour\'s Custom Audio|r: |cFFFF7777Invalid input.")
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFF77sca|r: |cFFFFFFFFOpen addon's home page|r")
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFF77sca|r |cFFBBBBFFauick|r: |cFFFFFFFFOpen Quick Toggle|r")
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFF77sca|r |cFFBBBBFFspells|r: |cFFFFFFFFOpen Spell Sound options|r")
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFF77sca|r |cFFBBBBFFdef|r: |cFFFFFFFFOpen Defense Sound options|r")
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFF77sca|r |cFFBBBBFFspec|r: |cFFFFFFFFOpen Special Sound options|r")
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFF77sca|r |cFFBBBBFFchat|r: |cFFFFFFFFOpen Chat Sound options|r")
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFF77sca|r |cFFBBBBFFmove|r: |cFFFFFFFFOpen Move Sound options|r")
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFF77sca|r |cFFBBBBFFbackup|r: |cFFFFFFFFOpen Data Backup options|r")
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFF77sca|r |cFFBBBBFFrestore|r: |cFFFFFFFFOpen Data Restore options|r")
		end
	end

end

function Ace3:GetSelected(db)
	--if (type(db.selected) == "number") then
		return db.keys[db.selected]
	--else
		--return db.selected
	--end
end

function Ace3:SetSelected(db,value,any)
	if (any) then
		if (db.keys) then
			for i=1,#db.keys do
				if (db.events[db.keys[i]]) then
					return i
				end
			end
		else
			for k,v in pairs(db.events) do
				if (v) then
					if (db.keys) then
						for i=1,#db.keys do
							if (db.keys[i] == v) then
								return i
							end
						end
					else
						return k
					end
				end
			end
		end
	else
		if (db.keys) then
			for i=1,#db.keys do
				if (db.keys[i] == value) then
					return i
				end
			end
		else
			return value
		end
	end
end

local function GetSpellErrorMessage(i,j,spellID)
	local first = sub(CLASS_SORT_ORDER[i],0,1)
	local remaining = lower(sub(CLASS_SORT_ORDER[i],2))
	local spells = SCA.data.spells
	local specName = spells.specDetails[CLASS_SORT_ORDER[i]][j].label
	local msg = ''
	local ctr = 0
	
	msg = "Spell ID / Name: |cFFFF5F99That spell belongs to "..specName.." "..first..remaining.."s"
	
	for k=1,spells.specDetails[CLASS_SORT_ORDER[i]].numSpecs do
		if (spells.onSuccess[CLASS_SORT_ORDER[i]][k][spellID]) then
			ctr = ctr + 1
		end
	end
	
	if (ctr > 1) then
		msg = "Spell ID / Name: |cFFFF5F99That spell belongs to "..first..remaining.."s"
	end
	
	return msg
end

function Ace3:CheckSpell(spellType,spell)
	local _,_,_,_,_,_,spellID = GetSpellInfo(spell)
	local _,className = UnitClass("player")
	local spec = GetSpecialization()
	local spells = SCA.data.spells
	
	if (not spellID) then
		spellID = spells.spellNames[className][spec][spell]
	end

	if (not spells[spellType][className][spec][spellID]) then
		local spellName = GetSpellInfo(spellID)
		local _,_,_,_,_,_,sID = GetSpellInfo(spellName)
		
		if (spells[spellType][className][spec][sID]) then
			return true,sID,spells[spellType][className][spec][sID]
		else
			local foundSpell = false
			local errorMsg = ''

			for i=1,MAX_CLASSES do
				for j=1,spells.specDetails[CLASS_SORT_ORDER[i]].numSpecs do
					
					if (spells.onSuccess[CLASS_SORT_ORDER[i]][j][spellID]) then
						errorMsg = GetSpellErrorMessage(i,j,spellID)
						
						foundSpell = true
						break
					elseif (spells.spellNames[CLASS_SORT_ORDER[i]][j][value]) then
						errorMsg = GetSpellErrorMessage(i,j,spellID)
						
						foundSpell = true
						break
					end
				end
				if (foundSpell) then
					break
				end
			end

			if (not foundSpell) then
				errorMsg = "Spell ID / Name: |cFFFF0000Spell not found!|r"
			end
			
			return false,sID,spells[spellType][className][spec][sID],errorMsg
		end
	else
		return true,spellID,spells[spellType][className][spec][spellID]
	end
end

-- Event: ADDON_LOADED
function Ace3:OnInitialize()
	--local defaults = SCA.defaults
	local about_panel = LibStub:GetLibrary("LibAboutPanel", true)

	if about_panel then
		self.optionsFrame = about_panel.new(nil, "CustomAudio")
	end

	self.db = LibStub("AceDB-3.0"):New("SCA_db", SCA.defaults)
	SCA.profile = self.db.profile
	SCA.char = self.db.char

	self.db.RegisterCallback(self, "OnNewProfile", "OnProfileUpdate")
	self.db.RegisterCallback(self, "OnProfileChanged", "OnProfileUpdate")
	self.db.RegisterCallback(self, "OnProfileCopied", "OnProfileUpdate")
	self.db.RegisterCallback(self, "OnProfileReset", "OnProfileUpdate")
	
	self:SetupOptions()

	self.myname = UnitName("player")
	self.myrealm = GetRealmName()
	
	local profileKey
	if (SCA_db.profileKeys) then
		--profileKey = SCA_db.profileKeys[self.myname.." - "..self.myrealm]
	end
	--SCA.DataFrame.text:SetText("Profile Key: "..tostring(profileKey).."\nIs Profiles: "..type(SCA_db.profiles).."\n Is Profile Key: "..type(SCA_db.profiles[profileKey]))
	if (profileKey and SCA_db.profiles and SCA_db.profiles[profileKey]) then
		--self:CopyTable(self.db, SCA_db.profiles[profileKey])
	end
	
	--wipe(_G["SCAdb"])
	for i = 1, GetNumAddOns() do
		local addonName = GetAddOnInfo(i)
		local enabled = GetAddOnEnableState(UnitName("player"), i)
		if GetAddOnMetadata(i, "X-SCA-SoundPack-GlobalName") and enabled ~= 0 then
			local loaded = LoadAddOn(addonName)
			local voiceGlobal = GetAddOnMetadata(i, "X-SCA-SoundPack-GlobalName")
			local insertFunction = _G[voiceGlobal]
			if loaded and insertFunction then
				insertFunction(SCA)
			else
				print(addonName.." failed to load at time Sound Pack function ran", 2)
			end
		end
	end
end

local function RefreshConfig()
	local ACFG = LibStub("AceConfigRegistry-3.0")
	local tables = ACFG.tables
	
	foreach(tables,function(k,v)
		ACFG:NotifyChange(k)
	end)
	
end

function Ace3:OnProfileUpdate(event,db,profileKey)
	--local tempProfile = prevProfile.db
	if (db) then
		--if (event == "OnNewProfile" or "OnProfileChanged") then
			ReloadUI()
		--end
	end
	--[[SCA.DataFrame.text:SetText(CurText('DataFrame').."PROFILE UPDATE: "..tostring(event).."\n")
	SCA_db.profiles[prevProfile.key] = nil
	SCA_db.profiles[prevProfile.key] = {}
	SCA_db.profiles[prevProfile.key] = tempProfile]]
	--SCA.profile = self.db.profile
	--LibStub("AceConfigRegistry-3.0"):NotifyChange("CustomAudio")
	--RefreshConfig()
end

local function ResetCurrentFile(db)
	local damage = db.spells.damage
	local heals = db.spells.heals
	local specific = db.spells.specific
	local defense = db.defense
	local chat = db.chat
	local special = db.special
	local move = db.move
	
	
	for k,_ in pairs(damage.events) do
		damage[k].custom.isRandom.currentFile = 1
		damage[k].packs.isRandom.currentFile = 1
	end
	
	for k,_ in pairs(heals.events) do
		heals[k].custom.isRandom.currentFile = 1
		heals[k].packs.isRandom.currentFile = 1
	end
	
	for k,_ in pairs(specific) do
		if (type(specific[k]) == "table") then
			for j,v in pairs(specific[k]) do
				if (type(v) == "table") then
					if (specific[k][j].custom) then
						specific[k][j].custom.isRandom.currentFile = 1
					end
					
					if (specific[k][j].packs) then
						specific[k][j].packs.isRandom.currentFile = 1
					end
				end
			end
		end
	end
	
	for k,_ in pairs(defense.events) do
		defense[k].custom.isRandom.currentFile = 1
		defense[k].packs.isRandom.currentFile = 1
	end
	
	for k,_ in pairs(chat) do
		if (type(chat[k]) == "table") then
			for j,v in pairs(chat[k].events) do
				chat[k][j].custom.isRandom.currentFile = 1
				chat[k][j].packs.isRandom.currentFile = 1
			end
		end
	end
	
	for k,_ in pairs(move) do
		if (type(move[k]) == "table") then
			for j,v in pairs(move[k].events) do
				move[k][j].custom.isRandom.currentFile = 1
				move[k][j].packs.isRandom.currentFile = 1
			end
		end
	end
end

local function GetChannelName(channel)
	if ((find(channel," ") or 0) > 0) then
		return lower(sub(channel,0,find(channel," ") - 1))
	else
		return lower(channel),channel
	end
end

local function SortCustomChannels(db)
	local channelList = {GetChannelList()}
				
	db.keys = nil
	db.keys = {
		[0] = "all",
	}
	
	for i=2,#channelList,2 do
		if (lower(channelList[i]) ~= "general" and lower(channelList[i]) ~= "trade" and lower(channelList[i]) ~= "localdefense" and lower(channelList[i]) ~= "lookingforgroup") then
			tinsert(db.keys,lower(channelList[i]))
			db[lower(channelList[i])].order = #db.keys
		end
	end
end

function Ace3:GetCustomChatChannels(e,...)
	local db = SCA.char.chat
	local action,_,_,_,_,_,_,_,channelName = ...
	local channelTable = {GetChannelList()}

	channelName,ChannelName = GetChannelName(channelName)

	if (action == "YOU_CHANGED") then
		if (channelName ~= "general" and channelName ~= "trade" and channelName ~= "localdefense" and channelName ~= "lookingforgroup") then
			if (not db[channelName]) then
				db.events[channelName] = true
				db[channelName] = {
					label = ChannelName,
					desc = "a message in the custom chat channel, |cFF00FF00"..channelName.."|r appears.",
					order = 0,
					validAudio = false,
					options = {
						source = "packs",
						channel = "Master",
						ignoreMe = false,
						timeout = {
							enabled = false,
							delay = 0,
							sinceLast = 0,
						},
					},
					packs = {
						text = '',
						value = 'empty',
						path = '',
						max = 1,
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
					shared = {
						value = 'None',
					},
					custom = {
						path = "Interface\\AUDIO\\",
						max = 1,
						customType = 'file',
						isRandom = {
							enabled = true,
							currentFile = 1,
						},
					},
				}
			end
			
			SortCustomChannels(db)
			if (SCA.temp.IsInterfaceOpen) then
				db.isNewChannelAdded = true
			end
			LibStub("AceConfigRegistry-3.0"):NotifyChange("CustomAudio Chat Sounds")
		end
	elseif (action == "YOU_LEFT") then
		if (db[channelName]) then
			db.events[channelName] = nil
			db[channelName] = nil

			SortCustomChannels(db)
			
			if (SCA.temp.IsInterfaceOpen) then
				db.isNewChannelAdded = true
			end
			
			LibStub("AceConfigRegistry-3.0"):NotifyChange("CustomAudio Chat Sounds")
		end
	end
	
	db.numEvents = 0
	
	for k,v in pairs(db.events) do
		db.numEvents = db.numEvents + 1
	end
end

function Ace3:OnEnable()
	--self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterEvent("UNIT_SPELLCAST_STOP")
	--self:RegisterEvent("PLAYER_STARTED_MOVING")
	--self:RegisterEvent("PLAYER_STOPPED_MOVING")
	
	-- Register Loot-related Events
	self:RegisterEvent("LOOT_OPENED")
	self:RegisterEvent("CONFIRM_DISENCHANT_ROLL")
	self:RegisterEvent("CONFIRM_LOOT_ROLL")
	
	-- Register Chat-related Events
	self:RegisterEvent("CHAT_MSG_BATTLEGROUND","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_BATTLEGROUND_LEADER","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_CHANNEL","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_EMOTE","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_GUILD","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_OFFICER","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_PARTY","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_PARTY_LEADER","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_RAID","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_RAID_LEADER","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_SAY","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_YELL","RunChatEvent")
	self:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE","GetCustomChatChannels")
	
	-- Reset File Number Sequencing 
	--ResetCurrentFile(self.db.profile.audio)
	ResetCurrentFile(SCA.profile.audio)
	SCA.char.chat.isNewChannelAdded = false
	-- Populate the database with all custom channel the player has joined.
	--GetCustomChatChannels()
	
	-- Build a table of localize spell names based on the spell ID from the "OnSuccess" table.
	-- All Spell ID tables are located in spells.lua
	--SCA.data.spells.spellNames = {}
	local spells = SCA.data.spells
	for i=1,MAX_CLASSES do
		for j=1,spells.specDetails[CLASS_SORT_ORDER[i]].numSpecs do
			for k,_ in pairs(spells.onSuccess[CLASS_SORT_ORDER[i]][j]) do
				local name = GetSpellInfo(k)
				
				if (not spells.spellNames[CLASS_SORT_ORDER[i]]) then
					spells.spellNames[CLASS_SORT_ORDER[i]] = {}
				end
				if (not spells.spellNames[CLASS_SORT_ORDER[i]][j]) then
					spells.spellNames[CLASS_SORT_ORDER[i]][j] = {}
				end
				spells.spellNames[CLASS_SORT_ORDER[i]][j][name] = k
				spells.onSuccess[CLASS_SORT_ORDER[i]][j][k] = name
			end
			
			if (spells.overload[CLASS_SORT_ORDER[i]]) then
				for k,v in pairs(spells.overload[CLASS_SORT_ORDER[i]][j]) do
					spells.spellNames[CLASS_SORT_ORDER[i]][j][v] = k
					spells.onSuccess[CLASS_SORT_ORDER[i]][j][k] = v
				end
			end
		end
	end
end



function Ace3:GetSoundFileNumber(db,source)
	if (db[source].isRandom.enabled) then
		return random(1,db[source].max)
	else
		if (tonumber(db[source].isRandom.currentFile) >= tonumber(db[source].max)) then
			db[source].isRandom.currentFile = 1
		elseif (tonumber(db[source].isRandom.currentFile) < 1) then
			db[source].isRandom.currentFile = 1
		else
			db[source].isRandom.currentFile = db[source].isRandom.currentFile + 1
		end
		
		return db[source].isRandom.currentFile
	end
end

function Ace3:MusicPlayer(db,forceStop)
	if (not SCA.temp.music.isSongPlaying and not forceStop) then
		local path = ''
		
		-- Backup the player's "default" music settings
		SCA.temp.music.defaultMusicSetting = GetCVar("Sound_EnableMusic")
		
		-- Check to see if music is muted; unmute it if it is
		if (GetCVar("Sound_EnableMusic") == "0") then
			SetCVar("Sound_EnableMusic",1)
		end
		
		if (db.custom.customType == "pack") then
			path = db.custom.music..tostring(self:GetSoundFileNumber(db,"custom"))
		else
			path = db.custom.music
		end

		PlayMusic(path..".mp3")
		PlayMusic(path..".ogg")
		
		-- Let the addon know that music is currently playing
		SCA.temp.music.isSongPlaying = true
	else
		-- Verify if the player's default music setting needs to be restored
		if (GetCVar("Sound_EnableMusic") ~= SCA.temp.music.defaultMusicSetting) then
			SetCVar("Sound_EnableMusic",SCA.temp.music.defaultMusicSetting)
		end
		
		StopMusic()
		
		-- Let the addon know that music has stopped playing
		SCA.temp.music.isSongPlaying = false
	end
end

local function AudioHandler(db,event)
	if (not event) then
		return
	end
	
	local path
	local soundTbl = db[event]
	--[[if (db.isSeparate or db.playSong) then
		soundTbl = db[event]
	else
		soundTbl = db.all
	end]]

	if (soundTbl.options.source == "packs") then
		path = soundTbl.packs.path..tostring(Ace3:GetSoundFileNumber(soundTbl,"packs"))
	elseif (soundTbl.options.source == "shared") then
		PlaySoundFile(LSM.MediaTable.sound[soundTbl.shared.value],soundTbl.options.channel)
		return
	elseif (soundTbl.options.source == "custom") then
		if (soundTbl.custom.customType == "pack") then
			path = soundTbl.custom.path..tostring(Ace3:GetSoundFileNumber(soundTbl,"custom"))
		else
			path = soundTbl.custom.path
		end
	end
	
	if (db.playSong) then
		Ace3:MusicPlayer(soundTbl)
	else
		if (not PlaySoundFile(path..".mp3",soundTbl.options.channel)) then
			PlaySoundFile(path..".ogg",soundTbl.options.channel)
		end
	end
end

local function GetChatName(event)
	-- Check to see if there's a third underscore in the chat's event name
	local isExtraUnderscore = find(event,"_",10)

	-- In most cases, the chat event names will only have 2 underscores
	-- If there's 3 or more, we'll have to do a bit more work to extract the chat name
	if (isExtraUnderscore) then
		return lower(sub(event,10,isExtraUnderscore-1))
	else
		return lower(sub(event,10))
	end
end

local function IgnoreMeCheck(db,author,name)
	if (db.options.ignoreMe) then
		if (name ~= author) then
			return true
		else
			return false
		end
	else
		return true
	end
end

local function RunChatSound(db,event,author)
	local name = UnitName("player")
	local realm = GetRealmName()
	name = name.."-"..realm
	
	event = Ace3:GetEvent(db,event)
	
	if (db[event].options.timeout.enabled) then
		if (GetTime() > db[event].options.timeout.delay + db[event].options.timeout.sinceLast) then
			if (IgnoreMeCheck(db[event],author,name)) then
				AudioHandler(db,event)
				db[event].options.timeout.sinceLast = GetTime()
			end
		end
	else
		if (IgnoreMeCheck(db[event],author,name)) then
			AudioHandler(db,event)
		end
	end
end

function Ace3:RunChatEvent(event,...)
	--local db = self.db.profile.audio.chat
	local db = SCA.profile.audio.chat
	
	if (db.enabled) then
		if (event == "CHAT_MSG_GUILD" or event == "CHAT_MSG_OFFICER") then
			local _,author = ...
			local guild = db.guild
			
			if (guild.enabled and guild.events[GetChatName(event)]) then
				RunChatSound(guild,GetChatName(event),author)
			end
		elseif (event == "CHAT_MSG_SAY" or event == "CHAT_MSG_YELL" or event == "CHAT_MSG_EMOTE") then
			local _,author = ...
			local nearby = db.nearby
			
			if (nearby.enabled and nearby.events[GetChatName(event)]) then
				RunChatSound(nearby,GetChatName(event),author)
			end
		elseif (event == "CHAT_MSG_BATTLEGROUND" or event == "CHAT_MSG_BATTLEGROUND_LEADER" or
				event == "CHAT_MSG_PARTY" or event == "CHAT_MSG_PARTY_LEADER" or
				event == "CHAT_MSG_RAID" or event == "CHAT_MSG_RAID_LEADER") then
			local _,author = ...
			local group = db.group
			
			if (group.enabled and group.events[GetChatName(event)]) then
				RunChatSound(group,GetChatName(event),author)
			end
		elseif (event == "CHAT_MSG_CHANNEL") then
			local _,author,_,_,_,_,_,_,channelName = ...
			local channelName = GetChannelName(channelName)

			if (SCA.char.chat[channelName]) then
				channel = SCA.char.chat
			else
				channel = db.global
			end
			
			if (channel.enabled and channel.events[channelName]) then
				RunChatSound(channel,channelName,author)
			end
		end
	end
end

--[[local function IsTargetEnemy()
	if (UnitExists("target") and UnitIsEnemy("target","player") and not UnitIsDead("target")) then
		return true
	else
		return false
	end
end]]

local function IsValidZoneDifficulty(db)
	if (IsInInstance()) then
		local name,instanceType,_,difficulty = GetInstanceInfo()
		
		if (instanceType == "raid") then
			if (db.options.raidTrigger == 0) then -- Always
				return true
			elseif (db.options.raidTrigger == 1) then -- Never
				return false
			else
				local raids = SCA.data.raids
				
				if (raids[name]) then
					local maxLevel = raids[name]
					local level = UnitLevel("player")
					
					if (level == maxLevel) then
						return true
					else
						return false
					end
				else
					return false
				end
			end
		else
			if (db.options.dungeonTrigger == 0) then -- Always
				return true
			elseif (db.options.dungeonTrigger == 1) then -- Never
				return false
			else
				local dungeons = SCA.data.dungeons
				
				if (dungeons[difficulty][name]) then
					local minLevel,maxLevel = dungeons[difficulty][name].min,dungeons[difficulty][name].max
					local level = UnitLevel("player")
					
					if (minLevel <= level and maxLevel >= level) then
						return true
					else
						return false
					end
				else
					return false
				end
			end
		end
	else
		if (db.options.zoneTrigger == 0) then -- Always
			return true
		elseif (db.options.zoneTrigger == 1) then -- Never
			return false
		else
			-- Not running this function may provide invalid map data
			SetMapToCurrentZone()
			
			local zones = SCA.data.zones
			local continent = GetCurrentMapContinent()
			
			if (zones[continent][GetRealZoneText()]) then
				local minLevel,maxLevel = zones[continent][GetRealZoneText()].min,zones[continent][GetRealZoneText()].max
				local level = UnitLevel("player")
				
				-- Verify if player is within scalable content level range, or on the Broken Isles/Argus, or if the zone level is max level
				if (minLevel <= level and maxLevel >= level) then
					return true
				else
					return false
				end
			else
				return false
			end
		end
	end
end

function Ace3:PLAYER_REGEN_DISABLED()
	--local db = self.db.profile.audio.combat.status
	local db = SCA.profile.audio.combat.status

	if (db.enabled and db.events.onStart) then
		--if ((IsTargetEnemy() and (db.options.isTargetRequired or (db.options.isTargetWorthy and UnitIsTrivial("target")))) or not db.options.isTargetRequired) then
		if (IsValidZoneDifficulty(db)) then
			AudioHandler(db,Ace3:GetEvent(db,'onStart'))
		end
	end
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
end

function Ace3:PLAYER_REGEN_ENABLED()
	--local db = self.db.profile.audio.combat.status
	local db = SCA.profile.audio.combat.status
	
	if (((db.enabled and db.events.onStop) or db.playSong) and IsValidZoneDifficulty(db)) then
		if (db.playSong) then
			Ace3:MusicPlayer(db,true)
		else
			AudioHandler(db,Ace3:GetEvent(db,'onStop'))
		end
	end
	self:UnregisterEvent("PLAYER_REGEN_ENABLED")
end

function Ace3:CONFIRM_DISENCHANT_ROLL(event,...)
	local _,roll = ...
	--local db = self.db.profile.audio.looting
	local db = SCA.profile.audio.looting
	
	if (db.enabled and db.rolling.enabled and db.rolling.events.disenchant) then
		AudioHandler(db.rolling,Ace3:GetEvent(db.rolling,'disenchant'))
	end
end

function Ace3:CONFIRM_LOOT_ROLL(event,...)
	local _,roll = ...
	--local db,event = self.db.profile.audio.looting
	local db,event = SCA.profile.audio.looting
	
	if (roll == 1) then -- Need Roll
		event = 'need'
	elseif (roll == 2) then -- Greed Roll
		event = 'greed'
	end
	
	if (db.enabled and db.rolling.enabled and db.rolling.events[event]) then
		AudioHandler(db.rolling,Ace3:GetEvent(db.rolling,event))
	end
end

function Ace3:LOOT_OPENED()
	--local db = self.db.profile.audio.looting
	local db = SCA.profile.audio.looting
	
	if (db.enabled and db.window.enabled and db.window.events.opened) then
		AudioHandler(db.window,Ace3:GetEvent(db.window,'opened'))
	end
	
	SCA.temp.loot.lootInfo = GetLootInfo()
	SCA.temp.loot.numItemsLooted = 0
	SCA.temp.loot.totalItems = GetNumLootItems()
	--[[SCA.temp.loot.slotsLooted = nil
	SCA.temp.loot.slotsLooted = {}

	for i=1,GetNumLootItems() do
		tinsert(SCA.temp.loot.slotsLooted,false)
	end]]
	--self:RegisterEvent("CHAT_MSG_LOOT")
	self:RegisterEvent("LOOT_SLOT_CLEARED")
	self:RegisterEvent("LOOT_CLOSED")
end

function Ace3:LOOT_SLOT_CLEARED(event,slot)
	local loot = SCA.temp.loot
	--local looting = self.db.profile.audio.looting
	local looting = SCA.profile.audio.looting
	
	if (loot.lootInfo[slot]) then
		local _,_,_,_,_,_,itemType = lower(loot.lootInfo[slot].item)
		
		if (looting.loot[itemType] and looting.loot[itemType].validAudio) then
			AudioHandler(looting.loot,Ace3:GetEvent(looting.loot,itemType))
		else
			AudioHandler(looting.loot,Ace3:GetEvent(looting.loot,lower(LOOT_QUALITY_VALUE[loot.lootInfo[slot].quality])))
		end

		loot.numItemsLooted = loot.numItemsLooted + 1
		
		loot.lootInfo[slot] = nil
	end
	
	if (SCA.temp.loot.numItemsLooted == SCA.temp.loot.totalItems) then
		self:UnregisterEvent(event)
	end
end

function Ace3:LOOT_CLOSED()
	--local db = self.db.profile.audio.looting
	local db = SCA.profile.audio.looting
	
	if (db.enabled and db.window.enabled and db.window.events.closed) then
		AudioHandler(db.window,Ace3:GetEvent(db.window,'closed'))
	end
	
	self:UnregisterEvent("LOOT_SLOT_CLEARED")
	self:UnregisterEvent("LOOT_CLOSED")
end

local function CritCheck(db,isCrit,event)
	if (not db) then
		return false
	end
	
	if ((db.options.trigger == "crit" and isCrit) or (db.options.trigger == "nocrit" and not isCrit) or db.options.trigger == "always") then
		return true
	else
		return false
	end
end

function Ace3:UNIT_SPELLCAST_STOP(event,...)
	local unit,_,_,_,spellID = ...

	if (unit == "player") then
		--local db = self.db.profile
		local db = SCA.profile
		local damage = db.audio.spells.damage
		local heals = db.audio.spells.heals
		local specific = db.audio.spells.specific
		local ignored = db.audio.spells.ignored
		local isSpecific = false
		
		local _,spellID = self:CheckSpell('onFail',spellID)
		
		if (specific[spellID]) then
			if (specific[spellID][Ace3:GetEvent(specific[spellID],'onFail')]) then
				isSpecific = true
			else
				isSpecific = false
			end
		end

		if (damage.enabled and damage.events.onFail and self:CheckSpell('onDamage',spellID) and not isSpecific and not ignored[spellID]) then
			AudioHandler(damage,Ace3:GetEvent(damage,'onFail'))
		elseif (heals.enabled and heals.events.onFail and self:CheckSpell('onHeal',spellID) and not isSpecific and not ignored[spellID]) then
			AudioHandler(heals,Ace3:GetEvent(heals,'onFail'))
		elseif (isSpecific and specific.enabled and specific[spellID].events['onFail']) then
			AudioHandler(specific[spellID],Ace3:GetEvent(specific[spellID],'onFail'))
		end
	end
end

function Ace3:COMBAT_LOG_EVENT_UNFILTERED(event,...)
	--local db = self.db.profile
	local db = SCA.profile
	local _,subevent = ...
	
	if (subevent == "SPELL_SUMMON") then
		local _,_,_,sGUID,_,_,_,dGUID,dUnit = ...
		
		if (sGUID == UnitGUID("player") and (dUnit == "Wild Imp" or dUnit == "Dreadstalker" or dUnit == "Darkglare")) then
			SCA.temp.GUIDs[dGUID] = GetTime() + 12
		end
	elseif (subevent == "SWING_MISSED") then
		local _,_,_,_,_,_,_,dGUID,_,_,_,missType = ...
		
		if (dGUID == UnitGUID("player")) then
			local defense = db.audio.defense
			
			if (defense[lower(missType)]) then
				if (defense.events[lower(missType)]) then
					AudioHandler(defense,Ace3:GetEvent(defense,lower(missType)))
				end
			end
		end
	elseif (subevent == "SPELL_MISSED") then
		local _,_,_,_,_,_,_,dGUID,_,_,_,_,_,_,missType = ...
		
		if (dGUID == UnitGUID("player")) then
			local defense = db.audio.defense
			
			if (defense[lower(missType)]) then
				if (defense.events[lower(missType)]) then
					AudioHandler(defense,Ace3:GetEvent(defense,lower(missType)))
				end
			end
		end
	elseif (subevent == "SPELL_ABSORBED") then
		local _,_,_,_,_,_,_,dGUID = ...
		
		if (dGUID == UnitGUID("player")) then
			local defense = db.audio.defense
			if (defense.events.absorb) then
				AudioHandler(defense,Ace3:GetEvent(defense,'absorb'))
			end
		end
	elseif (subevent == "SPELL_CAST_START") then
		local _,_,_,sGUID,_,_,_,_,_,_,_,spellID = ...
		
		if (sGUID == UnitGUID("player")) then
			local damage = db.audio.spells.damage
			local heals = db.audio.spells.heals
			local specific = db.audio.spells.specific
			local ignored = db.audio.spells.ignored
			local isSpecific = false

			local _,spellID,spellName = self:CheckSpell('onCast',spellID)

			if (specific[spellID]) then
				if (specific[spellID][Ace3:GetEvent(specific[spellID],'onCast')]) then
					isSpecific = true
				else
					isSpecific = false
				end
			end

			if (damage.enabled and damage.events.onCast and self:CheckSpell('onDamage',spellID) and not isSpecific and not ignored[spellID]) then
				AudioHandler(damage,Ace3:GetEvent(damage,'onCast'))
			elseif (heals.enabled and heals.events.onCast and self:CheckSpell('onHeal',spellID) and not isSpecific and not ignored[spellID]) then
				AudioHandler(heals,Ace3:GetEvent(heals,'onCast'))
			elseif (isSpecific and specific.enabled and specific[spellID].events['onCast']) then
				AudioHandler(specific[spellID],Ace3:GetEvent(specific[spellID],'onCast'))
			end
		end
	elseif (subevent == "SPELL_CAST_SUCCESS") then
		local _,_,_,sGUID,_,_,_,_,_,_,_,spellID = ...
		
		if (sGUID == UnitGUID("player")) then
			local damage = db.audio.spells.damage
			local heals = db.audio.spells.heals
			local specific = db.audio.spells.specific
			local ignored = db.audio.spells.ignored
			local isSpecific = false
			
			local _,spellID,spellName = self:CheckSpell('onSuccess',spellID)

			if (specific[spellID]) then
				if (specific[spellID][Ace3:GetEvent(specific[spellID],'onSuccess')]) then
					isSpecific = true
				else
					isSpecific = false
				end
			end
			
			if (damage.enabled and damage.events.onSuccess and self:CheckSpell('onDamage',spellID) and not isSpecific and not ignored[spellID]) then
				AudioHandler(damage,Ace3:GetEvent(damage,'onSuccess'))
			elseif (heals.enabled and heals.events.onSuccess and self:CheckSpell('onHeal',spellID) and not isSpecific and not ignored[spellID]) then
				AudioHandler(heals,Ace3:GetEvent(heals,'onSuccess'))
			elseif (isSpecific and specific.enabled and specific[spellID].events['onSuccess']) then
				AudioHandler(specific[spellID],Ace3:GetEvent(specific[spellID],'onSuccess'))
			end
		end
	elseif (subevent == "SPELL_CAST_FAILED") then
	
		--!!!!!!!!!!!!!!!! RELOCATED TO UNIT_SPELLCAST_STOP !!!!!!!!!!!!!!!!!!!!
		
		
		--[[local _,_,_,sGUID,_,_,_,_,_,_,_,spellID,_,_,failReason = ...
		
		if (sGUID == UnitGUID("player") and failReason == "Interrupted") then

			local damage = db.audio.spells.damage
			local heals = db.audio.spells.heals
			local specific = db.audio.spells.specific
			local ignored = db.audio.spells.ignored
			local isSpecific = false
			
			local _,spellID = self:CheckSpell('onFail',spellID)
			
			if (specific[spellID]) then
				if (specific[spellID][Ace3:GetEvent(specific[spellID],'onFail')]) then
					isSpecific = true
				else
					isSpecific = false
				end
			end

			if (damage.enabled and damage.events.onFail and self:CheckSpell('onDamage',spellID) and not isSpecific and not ignored[spellID]) then
				--if (damage.events.onFail and self:CheckSpell('onFail',spellID)) then
					AudioHandler(damage,Ace3:GetEvent(damage,'onFail'))
				--end
			elseif (heals.enabled and heals.events.onFail and self:CheckSpell('onHeal',spellID) and not isSpecific and not ignored[spellID]) then
				--if (heals.events.onFail and self:CheckSpell('onFail',spellID)) then
					AudioHandler(heals,Ace3:GetEvent(heals,'onFail'))
				--end
			elseif (isSpecific and specific.enabled) then
				AudioHandler(specific[spellID],Ace3:GetEvent(specific[spellID],'onFail'))
			end
		end]]
	elseif (subevent == "SPELL_INTERRUPT") then
		local _,_,_,sGUID = ...
		
		if (sGUID == UnitGUID("player")) then
			local combat = db.audio.combat
			
			if (combat.enabled and combat.events.events.onInterrupt) then
				AudioHandler(combat.events,"onInterrupt")
			end
		end
	elseif (subevent == "SPELL_DAMAGE") then
		local _,_,_,sGUID,_,_,_,dGUID,_,_,_,spellID,_,_,dmgAmt,_,_,_,isBlock,_,isCrit = ...

		if (dGUID == UnitGUID("player") and isBlock) then
			local defense = db.audio.defense
			
			if (defense.events.block) then
				AudioHandler(defense,'block')
			end
		elseif (sGUID == UnitGUID("player")) then
			local damage = db.audio.spells.damage
			local specific = db.audio.spells.specific
			local ignored = db.audio.spells.ignored
			local isSpecific = false
			
			local isValidSpell,spellID,spellName = self:CheckSpell('onDamage',spellID)
			
			if (specific[spellID]) then
				if (specific[spellID][Ace3:GetEvent(specific[spellID],'onDamage')]) then
					isSpecific = true
				else
					isSpecific = false
				end
			end
			
			if (isValidSpell and damage.enabled and CritCheck(damage[Ace3:GetEvent(damage,'onDamage')],isCrit,subevent) and not isSpecific and not ignored[spellID] and damage[Ace3:GetEvent(damage,'onDamage')].options.spells and dmgAmt >= damage[Ace3:GetEvent(damage,'onDamage')].options.threshold) then
				AudioHandler(damage,Ace3:GetEvent(damage,'onDamage'))
			elseif (isSpecific and specific.enabled and specific[spellID].events['onDamage']) then
				if (CritCheck(specific[spellID][Ace3:GetEvent(specific[spellID],'onDamage')],isCrit,subevent.."_SPECIFIC")) then
					AudioHandler(specific[spellID],Ace3:GetEvent(specific[spellID],'onDamage'))
				end
			end
		elseif (sGUID == UnitGUID("pet") or SCA.temp.GUIDs[sGUID]) then
			local damage = db.audio.spells.damage

			if (damage.enabled and CritCheck(damage[Ace3:GetEvent(damage,'onDamage')],isCrit) and damage[Ace3:GetEvent(damage,'onDamage')].options.pet) then
				AudioHandler(damage,Ace3:GetEvent(damage,'onDamage'))
			end
		end
	elseif (subevent == "SWING_DAMAGE") then
		local _,_,_,sGUID,_,_,_,dGUID,_,_,_,damage,_,_,_,isBlock,_,isCrit = ...

		if (dGUID == UnitGUID("player") and isBlock) then
			local defense = db.audio.defense
			
			if (defense.events.block) then
				AudioHandler(defense,'block')
			end
		elseif (sGUID == UnitGUID("player")) then
			local damage = db.audio.spells.damage
			if (damage.enabled and CritCheck(damage[Ace3:GetEvent(damage,'onDamage')],isCrit) and damage[Ace3:GetEvent(damage,'onDamage')].options.swing) then
				AudioHandler(damage,Ace3:GetEvent(damage,'onDamage'))
			end
		elseif (sGUID == UnitGUID("pet") or SCA.temp.GUIDs[sGUID]) then
			local damage = db.audio.spells.damage

			if (damage.enabled and CritCheck(damage[Ace3:GetEvent(damage,'onDamage')],isCrit) and damage[Ace3:GetEvent(damage,'onDamage')].options.pet and damage[Ace3:GetEvent(damage,'onDamage')].options.swing) then
				AudioHandler(damage,Ace3:GetEvent(damage,'onDamage'))
			end
		end
	elseif (subevent == "SPELL_PERIODIC_DAMAGE") then
		local _,_,_,sGUID,_,_,_,dGUID,_,_,_,spellID,_,_,dmgAmt,_,_,_,_,_,isCrit = ...

		if (sGUID == UnitGUID("player")) then
			local damage = db.audio.spells.damage
			local specific = db.audio.spells.specific
			local ignored = db.audio.spells.ignored
			local isSpecific = false
			
			local _,spellID,spellName = self:CheckSpell('onDamage',spellID)
			
			if (specific[spellID]) then
				if (specific[spellID][Ace3:GetEvent(specific[spellID],'onDamage')]) then
					isSpecific = true
				else
					isSpecific = false
				end
			end
			
			if (damage.enabled and CritCheck(damage[Ace3:GetEvent(damage,'onDamage')],isCrit,subevent) and not isSpecific and not ignored[spellID] and damage[Ace3:GetEvent(damage,'onDamage')].options.dots and dmgAmt >= damage[Ace3:GetEvent(damage,'onDamage')].options.threshold) then
				AudioHandler(damage,Ace3:GetEvent(damage,'onDamage'))
			elseif (isSpecific and specific.enabled and specific[spellID].events['onDamage']) then
				if (CritCheck(specific[spellID][Ace3:GetEvent(specific[spellID],'onDamage')],isCrit,subevent.."_SPECIFIC")) then
					AudioHandler(specific[spellID],Ace3:GetEvent(specific[spellID],'onDamage'))
				end
			end
		elseif (sGUID == UnitGUID("pet") or SCA.temp.GUIDs[sGUID]) then
			local damage = db.audio.spells.damage

			if (damage.enabled and CritCheck(damage[Ace3:GetEvent(damage,'onDamage')],isCrit) and damage[Ace3:GetEvent(damage,'onDamage')].options.pet) then
				AudioHandler(damage,Ace3:GetEvent(damage,'onDamage'))
			end
		end
	elseif (subevent == "SPELL_HEAL") then
		local _,_,_,sGUID,_,_,_,_,_,_,_,spellID,_,_,amount,_,_,isCrit = ...
		
		if (sGUID == UnitGUID("player")) then
			local heals = db.audio.spells.heals
			local specific = db.audio.spells.specific
			local ignored = db.audio.spells.ignored
			local isSpecific = false

			local _,spellID,spellName = self:CheckSpell('onHeal',spellID)
			
			if (specific[spellID]) then
				if (specific[spellID][Ace3:GetEvent(specific[spellID],'onHeal')]) then
					isSpecific = true
				else
					isSpecific = false
				end
			end

			if (heals.enabled and CritCheck(heals[Ace3:GetEvent(heals,'onHeal')],isCrit,subevent) and not isSpecific and not ignored[spellID] and heals[Ace3:GetEvent(heals,'onHeal')].options.spells and amount >= heals[Ace3:GetEvent(heals,'onHeal')].options.threshold) then
				AudioHandler(heals,Ace3:GetEvent(heals,'onHeal'))
			elseif (isSpecific and specific.enabled and specific[spellID].events['onHeal']) then
				if (CritCheck(specific[spellID][Ace3:GetEvent(specific[spellID],'onHeal')],isCrit,subevent.."_SPECIFIC")) then
					AudioHandler(specific[spellID],Ace3:GetEvent(specific[spellID],'onHeal'))
				end
			end
		end
	elseif (subevent == "SPELL_PERIODIC_HEAL") then
		local _,_,_,sGUID,_,_,_,_,_,_,_,spellID,_,_,amount,_,_,isCrit = ...
		
		if (sGUID == UnitGUID("player")) then
			local heals = db.audio.spells.heals
			local specific = db.audio.spells.specific
			local ignored = db.audio.spells.ignored
			local isSpecific = false
			
			local _,spellID,spellName = self:CheckSpell('onHeal',spellID)
			
			if (specific[spellID]) then
				if (specific[spellID][Ace3:GetEvent(specific[spellID],'onHeal')]) then
					isSpecific = true
				else
					isSpecific = false
				end
			end
			
			if (heals.enabled and CritCheck(heals[Ace3:GetEvent(heals,'onHeal')],isCrit,subevent) and not isSpecific and not ignored[spellID] and heals[Ace3:GetEvent(heals,'onHeal')].options.hots and amount >= heals[Ace3:GetEvent(heals,'onHeal')].options.threshold) then
				AudioHandler(heals,Ace3:GetEvent(heals,'onHeal'))
			elseif (isSpecific and specific.enabled and specific[spellID].events['onHeal']) then
				if (CritCheck(specific[spellID][Ace3:GetEvent(specific[spellID],'onHeal')],isCrit,subevent.."_SPECIFIC")) then
					AudioHandler(specific[spellID],Ace3:GetEvent(specific[spellID],'onHeal'))
				end
			end
		end
	elseif (subevent == "ENVIRONMENTAL_DAMAGE") then
		local _,_,_,_,_,_,_,sGUID = ...
		
		if (sGUID == UnitGUID("player")) then
			local db = self.db.profile.audio.combat
			
			if (db.enabled and db.events.enabled and db.events.events.onEnvironment) then
				AudioHandler(db.events,Ace3:GetEvent(db.events,'onEnvironment'))
			end
		end
	elseif (subevent == "UNIT_DIED") then
		local _,_,_,_,_,_,_,sGUID = ...
		
		if (sGUID == UnitGUID("player")) then
			local db = self.db.profile.audio.combat
			
			if (db.enabled and db.events.enabled and db.events.events.onDeath) then
				AudioHandler(db.events,Ace3:GetEvent(db.events,'onDeath'))
			end
		end
	elseif (subevent == "PARTY_KILL") then
		local _,_,_,sGUID = ...
		
		if (sGUID == UnitGUID("player")) then
			local db = self.db.profile.audio.combat
			
			if (db.enabled and db.events.enabled and db.events.events.onKill) then
				AudioHandler(db.events,Ace3:GetEvent(db.events,'onKill'))
			end
		end
	end
end



local function MovementTriggerCheck(db,playerMove,action)
	local isValid = false
	
	if (IsMounted()) then
		if (playerMove == "pitchup" or playerMove == "pitchdown") then
			isValid = true
		elseif (db[playerMove].triggers.mounted) then
			isValid = true
		else
			return false
		end
	end
	
	if (not IsMounted()) then
		if (playerMove == "ascend" or playerMove == "descend") then
			if (db[playerMove].triggers.running and action == "onStart" and not IsSwimming()) then
				isValid = true
			else
				return false
			end
		elseif (db[playerMove].triggers.running or db[playerMove].triggers.swimming) then
			isValid = true
		else
			return false
		end
	end
	
	if (IsFlying()) then
		if (playerMove == "pitchup" or playerMove == "pitchdown") then
			isValid = true
		elseif (db[playerMove].triggers.flying) then
			isValid = true
		else
			return false
		end
	end
	
	if (IsSwimming()) then
		if (db[playerMove].triggers.swimming) then
			isValid = true
		else
			return false
		end
	end
	
	if (isValid) then
		return true
	end
end

--local function hookPlayerMove(playerMove,action,reportDirection)
local function hookPlayerMove(playerMove,action)
	--local db = Ace3.db.profile.audio.move
	local db = SCA.profile.audio.move
	local playAudio = false
	--[[local isSkipReturn = false

	if ((playerMove == "forward" or playerMove == "backward") and reportDirection) then
		if (#SCA.temp.move.direction > 0) then
			isSkipReturn = true
		end
		
		SCA.temp.move.direction = playerMove
		
		if (not isSkipReturn) then
			return
		end
	end]]
	
	if (db.enabled and db[playerMove].enabled) then
		if (playerMove == "pitchup" or playerMove == "pitchdown" or playerMove == "autorun") then
			if ((action == "onStart" and db[playerMove].events[action]) or (action == "onStop" and db[playerMove].events[action])) then
				AudioHandler(db[playerMove],Ace3:GetEvent(db[playerMove],action))
			end
		elseif (MovementTriggerCheck(db,playerMove,action)) then
			if ((action == "onStart" and db[playerMove].events[action]) or (action == "onStop" and db[playerMove].events[action])) then
				AudioHandler(db[playerMove],Ace3:GetEvent(db[playerMove],action))
			end
		end
	end
end

--[[function Ace3:PLAYER_STARTED_MOVING()
	local db = Ace3.db.profile.audio.move
	

	--C_Timer.After(0.01,function() hookPlayerMove(SCA.temp.move.direction,'onStart') end)
	--C_Timer.After(0.01,function() AudioHandler(db[SCA.temp.move.direction],Ace3:GetEvent(db[SCA.temp.move.direction],"onStart")) end)
end

function Ace3:PLAYER_STOPPED_MOVING()
	local db = Ace3.db.profile.audio.move
	
	--C_Timer.After(0.01,function() hookPlayerMove(SCA.temp.move.direction,'onStop');SCA.temp.move.direction = '' end)
	--C_Timer.After(0.01,function() AudioHandler(db[SCA.temp.move.direction],Ace3:GetEvent(db[SCA.temp.move.direction],"onStop");SCA.temp.move.direction = '') end)
end]]

hooksecurefunc("JumpOrAscendStart"     		, function() hookPlayerMove("ascend",'onStart') end)
hooksecurefunc("AscendStop"            		, function() hookPlayerMove("ascend",'onStop') end)
hooksecurefunc("SitStandOrDescendStart"		, function() hookPlayerMove("descend",'onStart') end)
hooksecurefunc("DescendStop"          		, function() hookPlayerMove("descend",'onStop') end)
hooksecurefunc("MoveForwardStart"	   		, function() hookPlayerMove("forward",'onStart') end)
hooksecurefunc("MoveForwardStop"	  		, function() hookPlayerMove("forward",'onStop') end)
hooksecurefunc("MoveBackwardStart"	   		, function() hookPlayerMove("backward",'onStart') end)
hooksecurefunc("MoveBackwardStop"	   		, function() hookPlayerMove("backward",'onStop') end)
hooksecurefunc("TurnLeftStart"		   		, function() hookPlayerMove("turnleft",'onStart') end)
hooksecurefunc("TurnLeftStop"		   		, function() hookPlayerMove("turnleft",'onStop') end)
hooksecurefunc("TurnRightStart"		   		, function() hookPlayerMove("turnright",'onStart') end)
hooksecurefunc("TurnRightStop"		   		, function() hookPlayerMove("turnright",'onStop') end)
hooksecurefunc("PitchUpStart"		  		, function() hookPlayerMove("pitchup",'onStart') end)
hooksecurefunc("PitchUpStop"		   		, function() hookPlayerMove("pitchup",'onStop') end)
hooksecurefunc("PitchDownStart"		   		, function() hookPlayerMove("pitchdown",'onStart') end)
hooksecurefunc("PitchDownStop"		   		, function() hookPlayerMove("pitchdown",'onStop') end)
--[[hooksecurefunc("StrafeLeftStart"	   		, function() hookPlayerMove("strafeLeft",'onStart') end)
hooksecurefunc("StrafeLeftStop"		   		, function() hookPlayerMove("strafeLeft",'onStop') end)
hooksecurefunc("StrafeRightStart"	   		, function() hookPlayerMove("strafeRight",'onStart') end)
hooksecurefunc("StrafeRightStop"	   		, function() hookPlayerMove("strafeRight",'onStop') end)]]
hooksecurefunc("ToggleAutoRun"		   		, function() hookPlayerMove("autorun") end)
--hooksecurefunc("InteractUnit"		   		, function() hookPlayerMove("interact") end)

frame:SetScript("OnUpdate", function(self,elapsed)
	--SCA.DataFrame.text:SetText(GetTime().."\n\n")
	
	for k,v in pairs(SCA.temp.GUIDs) do
		--SCA.DataFrame.text:SetText(CurText('DataFrame')..tostring(k)..": ".. tostring(v).."\n")
		if (v <= GetTime()) then
			SCA.temp.GUIDs[k] = nil
		end
	end
end)

_G["SCA_private_db"] = SCA