-- Create the frame
local SweetWhisper_EventFrame = CreateFrame("Frame");

-- Settings
local fadeInTime = 0.5;
local fadeOutTime = 1.0;
local moving = false
local frameDefaultX = 0
local frameDefaultY = 450
local frameDefaultRelative = nil
local weapon = nil

-- Bind the event
SweetWhisper_EventFrame:RegisterEvent("CHAT_MSG_MONSTER_WHISPER");
SweetWhisper_EventFrame:SetScript("OnEvent",
function(self, event, ...)
    local message, sender = ...;

    -- Only on valid events
    if(sender == "Xal'atath") then
        moving = false
        showSweetWhisper(message, sender)
    elseif(sender == "Skull of the Man'ari") then
        moving = false
        showSweetWhisper(message, sender)
    elseif(sender == "Aluneth") then
        moving = false
        showSweetWhisper(message, sender)
    end
end)

-- Slash commands
local function SweetWhispersCommands(msg, editbox)
    -- Switch
    if(msg == 'test') then
        moving = false
        showSweetWhisper("This is a long and random message, perhaps I should throw in a joke here?", "Test sender")
    elseif(msg == 'move') then
        if(not moving) then
            moving = true
            showSweetWhisper("You can now move the frame. Type /sw move to stop this.", "Test sender")
        else
            moving = false
            hideSweetWhisper()
        end
    else
        DEFAULT_CHAT_FRAME:AddMessage("/sw - Shows all Sweet Whisper commands")
        DEFAULT_CHAT_FRAME:AddMessage("/sw test - Shows a test dialogue with your current weapon")
        DEFAULT_CHAT_FRAME:AddMessage("/sw move - Move the frame")
    end
end

-- Add /sw and /sweetwhispers to command list
SLASH_SWEETWHISPERS1, SLASH_SWEETWHISPERS2 = '/sw', '/sweetwhispers'
SlashCmdList["SWEETWHISPERS"] = SweetWhispersCommands

-- Show the frame
function showSweetWhisper(message, sender)
    -- Calculate the delay time
    local fadeDelay = string.len(message) / 8;
    
    -- Set minimum time
    if(fadeDelay < 4) then
        fadeDelay = 4.0;
    end

    -- Set the message and header
    SweetWhisperHeader:SetText(sender);
    SweetWhisperText:SetText(message);

    -- Get the model
    local weaponModel = GetInventoryItemID("player", GetInventorySlotInfo("MainHandSlot"))
    local weaponRotation = math.pi / 2
    local posX = 0
    local posY = 0
    local posZ = 0

    -- Set the specific settings
    if(weaponModel == 137246) then -- Skull?
        -- Switch weapon
        weaponModel = 128943

        ModelFrame:SetWidth(80)
        ModelFrame:SetHeight(130)
        ModelFrame:SetPoint("TOPLEFT", 0, 0)
        posX = 0 --right
        posY = 0 --?
        posZ = -0.3 --op
    elseif(weaponModel == 127857) then -- Aluneth
        ModelFrame:SetWidth(160)
        ModelFrame:SetHeight(160)
        ModelFrame:SetPoint("TOPLEFT", -81, 25)
        weaponRotation = math.pi * 1.3
        posX = 0 --right
        posY = 1.2 --?
        posZ = 0 --op
    elseif(weaponModel == 128827) then -- Xal'Atath
        ModelFrame:SetWidth(150)
        ModelFrame:SetHeight(150)
        ModelFrame:SetPoint("TOPLEFT", -35, 35)
    else
        ModelFrame:SetWidth(80)
        ModelFrame:SetHeight(80)
        ModelFrame:SetPoint("TOPLEFT", 0, 0)
    end
    
    -- Set the model
    if(weapon == nil) then
        weapon = CreateFrame("DressUpModel", "ModelFrameDressUp", ModelFrame)
    end
    weapon:ClearAllPoints()
    weapon:SetAllPoints()
    weapon:SetRotation(weaponRotation)
    weapon:SetPosition(posX,posY,posZ)
    weapon:SetItem(weaponModel)

    -- Get initial position
    if(frameDefaultRelative == nil) then
        point, relativeTo, relativePoint, xOfs, yOfs = SweetWhisperFrame:GetPoint()
        frameDefaultRelative = relativePoint
    end

    -- Position the frame
    if(SweetWhispersX ~= nil and SweetWhispersY ~= nil and SweetWhispersRelative ~= nil) then
        SweetWhisperFrame:SetPoint(SweetWhispersRelative, SweetWhispersX, SweetWhispersY)
    else
        SweetWhisperFrame:SetPoint(frameDefaultRelative, frameDefaultX, frameDefaultY)
    end

    -- Fade in the frame
    UIFrameFadeIn(SweetWhisperFrame, fadeInTime, 0.0, 1.0);
    
    -- Fade out the frame - if not moving
    if(not moving) then
        C_Timer.After(fadeDelay, function()
            if(not moving) then
                hideSweetWhisper()
            end
        end);
    end

    -- Mover
    if(moving) then
        SweetWhisperFrame:SetMovable(true)
        SweetWhisperFrame:EnableMouse(true)
        SweetWhisperFrame:SetScript("OnMouseDown", function(self, button)
            if(button == "LeftButton" and not self.isMoving) then
                self:StartMoving();
                self.isMoving = true;
            end
        end)
        SweetWhisperFrame:SetScript("OnMouseUp", function(self, button)
            if(button == "LeftButton" and self.isMoving) then
                self:StopMovingOrSizing();
                self.isMoving = false;

                point, relativeTo, relativePoint, xOfs, yOfs = SweetWhisperFrame:GetPoint()
                SweetWhispersX = xOfs
                SweetWhispersY = yOfs
                SweetWhispersRelative = relativePoint
                SweetWhisperFrame:SetUserPlaced(true)
            end
        end)
        SweetWhisperFrame:SetScript("OnHide", function(self)
            if(self.isMoving) then
                self:StopMovingOrSizing();
                self.isMoving = false;

                point, relativeTo, relativePoint, xOfs, yOfs = SweetWhisperFrame:GetPoint()
                SweetWhispersX = xOfs
                SweetWhispersY = yOfs
                SweetWhispersRelative = relativePoint
                SweetWhisperFrame:SetUserPlaced(true)
            end
        end)
    else
        SweetWhisperFrame:SetMovable(false)
        SweetWhisperFrame:EnableMouse(false)
    end
end

-- Hide the frame
function hideSweetWhisper()
    if(SweetWhisperFrame:IsShown()) then
        UIFrameFadeIn(SweetWhisperFrame, fadeOutTime, 1.0, 0.0);
    end
end