--- Initialization Script
--
local AddOnName, nsVars = ...

--Cache global variables
local CreateFrame = CreateFrame

-- Prepare Addon variables
local SPKE = CreateFrame("Frame", "SPKE_addon")
nsVars.SPKE = SPKE

function SPKE._f(name)
  return "SPKE_" .. name
end

-- Initialize event listeners
local eventFrame = CreateFrame("Frame", SPKE._f("event_watcher"))
eventFrame:RegisterEvent("ADDON_LOADED")

--- Registers an event with the event frame.
-- @param e The event to register.
--
function SPKE:AddEvent(e)
  eventFrame:RegisterEvent(e)
end

--- Unregisters an event from the event frame.
-- @param e The event to register.
--
function SPKE:RemoveEvent(e)
  eventFrame:UnregisterEvent(e)
end

--- The event handler used to process incoming client events.
-- @param self A reference to the event frame.
-- @param event The event that was called.
-- @param ... Remaining values passed with the event.
-- @see Frame_OnEvent
--
local function listen(self, event, ...)
  if SPKE[event] then
    SPKE[event](SPKE, ...)
  end
end

eventFrame:SetScript("OnEvent", listen)
