---------------------------
-- Initialization Script --
---------------------------
local AddOnName, nsVars = ...
local spke = nsVars.SPKE

local selectedKey = 1

local popupButtons = {
  StaticPopup1Button1,
  StaticPopup1Button2,
}

--- Hook for StaticPopup1Button2:OnKeyDown().
-- @param self Reference to StaticPopup1Button2.
-- @param key The pressed key.
--
local function HookStaticPopup1Button2OnKeyDown(self, key)
  popupButtons[2]:SetPropagateKeyboardInput(false)
  
  if key == "ENTER" or key == "SPACE" then
    popupButtons[selectedKey]:Click()
  elseif key == "TAB" then
    selectedKey = (selectedKey == 1) and 2 or 1

    if selectedKey == 1 then
      popupButtons[2]:UnlockHighlight()
      popupButtons[1]:LockHighlight()
    else
      popupButtons[1]:UnlockHighlight()
      popupButtons[2]:LockHighlight()
    end
  else
    popupButtons[2]:SetPropagateKeyboardInput(true)
  end
end

--- Hook for StaticPopup1:OnShow().
-- @param self Reference to StaticPopup1Button2.
--
local function HookStaticPopup1OnShow(self)
  local enabled = popupButtons[2]:IsVisible()
    and popupButtons[1]:IsVisible()
  
  popupButtons[2]:EnableKeyboard(enabled)

  if enabled then
    selectedKey = 1
    popupButtons[1]:LockHighlight()
  end
end

--- Hook for StaticPopup1Button2:OnHide().
--
local function HookStaticPopup1Button2OnHide()
  popupButtons[1]:UnlockHighlight()
  popupButtons[2]:UnlockHighlight()
end

--- Initializes the function hooks.
-- @see Interface\FrameXML\StaticPopup.xml.
--
local function Initialize()
  popupButtons[2]:HookScript("OnKeyDown", HookStaticPopup1Button2OnKeyDown)
  popupButtons[2]:HookScript("OnHide", HookStaticPopup1Button2OnHide)
  StaticPopup1:HookScript("OnShow", HookStaticPopup1OnShow)
end

--- Event handler for "ADDON_LOADED".
--
function spke:ADDON_LOADED()
  self:AddEvent("PLAYER_LOGIN")
  self:RemoveEvent("ADDON_LOADED")
end

--- Event handler for "PLAYER_LOGIN".
--
function spke:PLAYER_LOGIN()
  self:RemoveEvent("PLAYER_LOGIN")
  Initialize()
end
